(ns com.vadelabs.utils.pprint
  (:require
    [fipp.edn :as fpp]))


(defn pprint-str
  [expr & {:keys [width level length]
           :or {width 110 level 8 length 25}}]
  (binding [*print-level* level
            *print-length* length]
    (with-out-str
      (fpp/pprint expr {:width width}))))


(defn pprint
  [expr & {:as opts}]
  (println (pprint-str expr opts)))
