(ns vds.atoms.block
  (:require [stylefy.core :refer [use-style]]
            [re-frame.core :refer [subscribe]]
            [vds.utils :as vdu]
            [vds.atoms.styles.block :as styles]))

(defn vda-block
  [& args]
  (let [[props] (vdu/extract-args args)
        theme @(subscribe [:theme])]
    (fn [& args]
      (let [[_ children] (vdu/extract-args args)]
        (into [:div (use-style (styles/vda-block props theme))] children)))))