(ns com.vadelabs.workflow-core.protocols)

(defprotocol AsyncContext
  (then [x f])
  (catch [x f]))

(defprotocol InterceptorContext
  (async? [x]))

(extend-protocol InterceptorContext
  nil
  (async? [_] false))

(defprotocol Interceptor
  (interceptor [x] "Produces an interceptor from value"))

(extend-protocol InterceptorContext
  ;; We extend all objects including deferred, core.async channels
  ;; and CompletableFuture but when there respective namespaces load,
  ;; they will call extend-protocol thus implementing async? for their
  ;; respective classes
  #?(:clj Object :cljs object)
  (async? [_] false))
