/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.github.toastshaman.dropwizard.auth.jwt.JsonWebTokenParser;
import com.github.toastshaman.dropwizard.auth.jwt.hmac.HmacSHA512Verifier;
import com.github.toastshaman.dropwizard.auth.jwt.parser.DefaultJsonWebTokenParser;
import com.google.common.hash.Hashing;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.Target;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.httpclient.ApacheHttpClient;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.ranger.RangerTarget;
import feign.slf4j.Slf4jLogger;
import io.dropwizard.primer.auth.PrimerAuthorizationRegistry;
import io.dropwizard.primer.auth.authorizer.PrimerVertxAnnotationAuthorizer;
import io.dropwizard.primer.auth.filter.PrimerVertxAuthAnnotationFilter;
import io.dropwizard.primer.auth.filter.PrimerVertxAuthConfigFilter;
import io.dropwizard.primer.client.PrimerClient;
import io.dropwizard.primer.core.PrimerError;
import io.dropwizard.primer.exception.PrimerException;
import io.dropwizard.primer.model.PrimerAuthorizationMatrix;
import io.dropwizard.primer.model.PrimerBundleConfiguration;
import io.dropwizard.primer.model.PrimerConfigurationHolder;
import io.dropwizard.primer.model.PrimerRangerEndpoint;
import io.dropwizard.primer.model.PrimerSimpleEndpoint;
import java.io.IOException;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.apache.http.Consts;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PrimerVertxBundle {
    private static final Logger log = LoggerFactory.getLogger(PrimerVertxBundle.class);
    private static PrimerClient primerClient = null;
    private final PrimerBundleConfiguration primerConfig;
    private final ObjectMapper objectMapper;
    private final ExecutorService executorService = Executors.newFixedThreadPool(5);
    private PrimerVertxAuthConfigFilter primerVertxAuthConfigFilter;
    private PrimerVertxAuthAnnotationFilter primerVertxAuthAnnotationFilter;

    public PrimerVertxBundle(PrimerBundleConfiguration primerConfig, ObjectMapper objectMapper) {
        this.primerConfig = primerConfig;
        this.objectMapper = objectMapper;
    }

    public static PrimerClient getPrimerClient() {
        return primerClient;
    }

    public abstract PrimerBundleConfiguration getPrimerConfiguration();

    public void init() {
        this.initializeAuthorization();
        JacksonDecoder decoder = new JacksonDecoder();
        JacksonEncoder encoder = new JacksonEncoder();
        Slf4jLogger logger = new Slf4jLogger();
        int clientConnectionPool = 128;
        this.initPrimerClient(this.primerConfig, decoder, encoder, logger, 128);
        this.objectMapper.registerSubtypes(new NamedType[]{new NamedType(PrimerSimpleEndpoint.class, "simple")});
        this.objectMapper.registerSubtypes(new NamedType[]{new NamedType(PrimerRangerEndpoint.class, "ranger")});
        SecretKeySpec secretKeySpec = new SecretKeySpec(Hashing.murmur3_128().hashString((CharSequence)this.primerConfig.getPrivateKey(), StandardCharsets.UTF_8).asBytes(), "AES");
        PrimerConfigurationHolder configHolder = new PrimerConfigurationHolder(this.primerConfig);
        GCMParameterSpec ivParameterSpec = new GCMParameterSpec(128, Arrays.copyOf(configHolder.getConfig().getPrivateKey().getBytes(), 8));
        this.primerVertxAuthConfigFilter = PrimerVertxAuthConfigFilter.builder().configHolder(configHolder).objectMapper(this.objectMapper).secretKeySpec(secretKeySpec).ivParameterSpec(ivParameterSpec).build();
        this.primerVertxAuthAnnotationFilter = PrimerVertxAuthAnnotationFilter.builder().configHolder(configHolder).objectMapper(this.objectMapper).authorizer(this.authorizer()).secretKeySpec(secretKeySpec).ivParameterSpec(ivParameterSpec).build();
    }

    public void initializeAuthorization() {
        PrimerAuthorizationMatrix permissionMatrix;
        DefaultJsonWebTokenParser tokenParser = new DefaultJsonWebTokenParser();
        byte[] secretKey = this.primerConfig.getPrivateKey().getBytes(StandardCharsets.UTF_8);
        HmacSHA512Verifier tokenVerifier = new HmacSHA512Verifier(secretKey);
        HashSet<String> whiteListUrls = new HashSet<String>();
        Set<String> dynamicWhiteList = this.withWhiteList();
        if (dynamicWhiteList != null) {
            whiteListUrls.addAll(dynamicWhiteList);
        }
        if (this.primerConfig.getWhileListUrl() != null) {
            whiteListUrls.addAll(this.primerConfig.getWhileListUrl());
        }
        if ((permissionMatrix = this.primerConfig.getAuthorizations()) == null) {
            permissionMatrix = this.withAuthorization();
        } else {
            PrimerAuthorizationMatrix dynamicAuthMatrix = this.withAuthorization();
            if (permissionMatrix.getAuthorizations() == null) {
                permissionMatrix.setAuthorizations(dynamicAuthMatrix.getAuthorizations());
            } else {
                permissionMatrix.getAuthorizations().addAll(dynamicAuthMatrix.getAuthorizations());
            }
            if (permissionMatrix.getAutoAuthorizations() == null) {
                permissionMatrix.setAutoAuthorizations(dynamicAuthMatrix.getAutoAuthorizations());
            } else {
                permissionMatrix.getAutoAuthorizations().addAll(dynamicAuthMatrix.getAutoAuthorizations());
            }
            if (permissionMatrix.getStaticAuthorizations() == null) {
                permissionMatrix.setStaticAuthorizations(dynamicAuthMatrix.getStaticAuthorizations());
            } else {
                permissionMatrix.getStaticAuthorizations().addAll(dynamicAuthMatrix.getStaticAuthorizations());
            }
        }
        PrimerAuthorizationRegistry.init(permissionMatrix, whiteListUrls, this.primerConfig, (JsonWebTokenParser)tokenParser, tokenVerifier);
    }

    private void initPrimerClient(PrimerBundleConfiguration configuration, JacksonDecoder decoder, JacksonEncoder encoder, Slf4jLogger logger, int clientConnectionPool) {
        this.executorService.submit(() -> {
            SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).setSoKeepAlive(true).build();
            ConnectionConfig connectionConfig = ConnectionConfig.custom().setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).setCharset(Consts.UTF_8).build();
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setDefaultMaxPerRoute(clientConnectionPool);
            connectionManager.setMaxTotal(clientConnectionPool);
            connectionManager.setDefaultMaxPerRoute(clientConnectionPool);
            connectionManager.setValidateAfterInactivity(30000);
            connectionManager.setDefaultSocketConfig(socketConfig);
            connectionManager.setDefaultConnectionConfig(connectionConfig);
            RequestConfig defaultRequestConfig = RequestConfig.custom().setAuthenticationEnabled(false).setRedirectsEnabled(false).setConnectTimeout(Integer.MAX_VALUE).setConnectionRequestTimeout(Integer.MAX_VALUE).build();
            HttpClientBuilder client = HttpClients.custom().addInterceptorFirst((httpRequest, httpContext) -> httpRequest.removeHeaders("Content-Length")).setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(defaultRequestConfig);
            primerClient = (PrimerClient)Feign.builder().decoder((Decoder)decoder).encoder((Encoder)encoder).errorDecoder((methodKey, response) -> {
                try {
                    PrimerError error = (PrimerError)this.objectMapper.readValue(response.body().asInputStream(), PrimerError.class);
                    return PrimerException.builder().message(error.getMessage()).errorCode(error.getErrorCode()).status(response.status()).build();
                }
                catch (IOException e) {
                    return PrimerException.builder().status(response.status()).errorCode("PR000").message(e.getMessage()).build();
                }
            }).client((Client)new ApacheHttpClient((HttpClient)client.build())).logger((feign.Logger)logger).logLevel(Logger.Level.BASIC).target(this.getPrimerTarget(configuration));
        });
    }

    public abstract PrimerVertxAnnotationAuthorizer authorizer();

    public abstract Set<String> withWhiteList();

    public abstract PrimerAuthorizationMatrix withAuthorization();

    private Target<PrimerClient> getPrimerTarget(PrimerBundleConfiguration primerConfig) {
        switch (primerConfig.getEndpoint().getType()) {
            case "simple": {
                PrimerSimpleEndpoint endpoint = (PrimerSimpleEndpoint)primerConfig.getEndpoint();
                return new Target.HardCodedTarget(PrimerClient.class, String.format("http://%s:%d", endpoint.getHost(), endpoint.getPort()));
            }
            case "ranger": {
                PrimerRangerEndpoint config = (PrimerRangerEndpoint)primerConfig.getEndpoint();
                try {
                    return new RangerTarget(PrimerClient.class, config.getEnvironment(), config.getNamespace(), config.getService(), this.getCurator(), false, this.objectMapper);
                }
                catch (Exception e) {
                    log.error("Error creating ranger endpoint for primer", (Throwable)e);
                    return null;
                }
            }
        }
        throw new IllegalArgumentException("unknown primer target type specified");
    }

    public CuratorFramework getCurator() {
        PrimerRangerEndpoint config = (PrimerRangerEndpoint)this.primerConfig.getEndpoint();
        CuratorFramework curatorFramework = CuratorFrameworkFactory.builder().connectString(config.getZookeeper()).namespace(config.getNamespace()).retryPolicy((RetryPolicy)new RetryNTimes(1000, 500)).build();
        curatorFramework.start();
        return curatorFramework;
    }

    public PrimerVertxAuthConfigFilter getPrimerVertxAuthConfigFilter() {
        return this.primerVertxAuthConfigFilter;
    }

    public PrimerVertxAuthAnnotationFilter getPrimerVertxAuthAnnotationFilter() {
        return this.primerVertxAuthAnnotationFilter;
    }
}

