/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.auth.filter;

import com.codahale.metrics.annotation.Metered;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.dropwizard.primer.auth.AuthType;
import io.dropwizard.primer.auth.VertxAuthFilter;
import io.dropwizard.primer.auth.annotation.AuthWhitelist;
import io.dropwizard.primer.auth.annotation.Authorize;
import io.dropwizard.primer.auth.authorizer.PrimerVertxAnnotationAuthorizer;
import io.dropwizard.primer.auth.whitelist.AuthWhitelistValidator;
import io.dropwizard.primer.core.PrimerError;
import io.dropwizard.primer.exception.PrimerException;
import io.dropwizard.primer.model.PrimerConfigurationHolder;
import io.dropwizard.primer.util.CryptUtil;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import javax.annotation.Priority;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=1000)
@Singleton
public class PrimerVertxAuthAnnotationFilter
extends VertxAuthFilter {
    private static final Logger log = LoggerFactory.getLogger(PrimerVertxAuthAnnotationFilter.class);
    private final PrimerVertxAnnotationAuthorizer authorizer;
    private final SecretKeySpec secretKeySpec;
    private final GCMParameterSpec ivParameterSpec;
    @Context
    private HttpServletRequest requestProxy;
    @Context
    private ResourceInfo resourceInfo;

    public PrimerVertxAuthAnnotationFilter(PrimerConfigurationHolder configHolder, ObjectMapper objectMapper, PrimerVertxAnnotationAuthorizer authorizer, SecretKeySpec secretKeySpec, GCMParameterSpec ivParameterSpec) {
        super(AuthType.ANNOTATION, configHolder, objectMapper);
        this.authorizer = authorizer;
        this.secretKeySpec = secretKeySpec;
        this.ivParameterSpec = ivParameterSpec;
    }

    @Metered(name="authorize")
    public void filter(RoutingContext routingContext) throws IOException {
        Optional<String> token = this.getToken(routingContext);
        if (!token.isPresent()) {
            if (!this.isEnabled() || this.isWhitelisted()) {
                return;
            }
            routingContext.response().setStatusCode(this.configHolder.getConfig().getAbsentTokenStatus().getStatusCode()).setStatusMessage("PR000").end(this.objectMapper.writeValueAsString((Object)PrimerError.builder().errorCode("PR000").message("Bad request").build()));
        } else {
            try {
                String decryptedToken = CryptUtil.tokenDecrypt(token.get(), this.secretKeySpec, this.ivParameterSpec);
                JsonWebToken webToken = this.authorize(routingContext, decryptedToken, this.authType);
                this.stampHeaders(routingContext, webToken);
                if (!this.isEnabled() || this.isWhitelisted()) {
                    return;
                }
                if (this.authorizer != null) {
                    this.authorizer.authorize(webToken, routingContext, this.getAuthorizeAnnotation());
                }
            }
            catch (UncheckedExecutionException e) {
                if (e.getCause() instanceof CompletionException) {
                    this.handleException(e.getCause().getCause(), routingContext, token.get());
                } else {
                    this.handleException(e.getCause(), routingContext, token.get());
                }
            }
            catch (Exception e) {
                if (e.getCause() instanceof PrimerException) {
                    this.handleException(e.getCause(), routingContext, token.get());
                }
                this.handleException(e, routingContext, token.get());
            }
        }
    }

    private boolean isEnabled() {
        return this.configHolder.getConfig().isEnabled() && this.configHolder.getConfig().getAuthTypesEnabled().getOrDefault((Object)AuthType.ANNOTATION, false) != false && Objects.nonNull(this.getAuthorizeAnnotation());
    }

    private boolean isWhitelisted() {
        AuthWhitelist authWhitelist = this.resourceInfo.getResourceMethod().getAnnotation(AuthWhitelist.class);
        return Objects.nonNull(authWhitelist) && authWhitelist.type().accept(new AuthWhitelistValidator(authWhitelist, this.requestProxy)) != false;
    }

    private Authorize getAuthorizeAnnotation() {
        return this.resourceInfo.getResourceMethod().getAnnotation(Authorize.class);
    }

    public static PrimerVertxAuthAnnotationFilterBuilder builder() {
        return new PrimerVertxAuthAnnotationFilterBuilder();
    }

    public static class PrimerVertxAuthAnnotationFilterBuilder {
        private PrimerConfigurationHolder configHolder;
        private ObjectMapper objectMapper;
        private PrimerVertxAnnotationAuthorizer authorizer;
        private SecretKeySpec secretKeySpec;
        private GCMParameterSpec ivParameterSpec;

        PrimerVertxAuthAnnotationFilterBuilder() {
        }

        public PrimerVertxAuthAnnotationFilterBuilder configHolder(PrimerConfigurationHolder configHolder) {
            this.configHolder = configHolder;
            return this;
        }

        public PrimerVertxAuthAnnotationFilterBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public PrimerVertxAuthAnnotationFilterBuilder authorizer(PrimerVertxAnnotationAuthorizer authorizer) {
            this.authorizer = authorizer;
            return this;
        }

        public PrimerVertxAuthAnnotationFilterBuilder secretKeySpec(SecretKeySpec secretKeySpec) {
            this.secretKeySpec = secretKeySpec;
            return this;
        }

        public PrimerVertxAuthAnnotationFilterBuilder ivParameterSpec(GCMParameterSpec ivParameterSpec) {
            this.ivParameterSpec = ivParameterSpec;
            return this;
        }

        public PrimerVertxAuthAnnotationFilter build() {
            return new PrimerVertxAuthAnnotationFilter(this.configHolder, this.objectMapper, this.authorizer, this.secretKeySpec, this.ivParameterSpec);
        }

        public String toString() {
            return "PrimerVertxAuthAnnotationFilter.PrimerVertxAuthAnnotationFilterBuilder(configHolder=" + this.configHolder + ", objectMapper=" + this.objectMapper + ", authorizer=" + this.authorizer + ", secretKeySpec=" + this.secretKeySpec + ", ivParameterSpec=" + this.ivParameterSpec + ")";
        }
    }
}

