/*
 * Decompiled with CFR 0.152.
 */
package processing.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphicsJava2D;
import processing.core.PImage;
import processing.core.PStyle;

public class PGraphicsPDF
extends PGraphicsJava2D {
    protected File file;
    protected OutputStream output;
    protected Document document;
    protected PdfWriter writer;
    protected PdfContentByte content;
    protected static DefaultFontMapper mapper;
    protected static String[] fontList;

    public void setPath(String path) {
        this.path = path;
        if (path != null) {
            this.file = new File(path);
            if (!this.file.isAbsolute()) {
                this.file = null;
            }
        }
        if (this.file == null) {
            throw new RuntimeException("PGraphicsPDF requires an absolute path for the location of the output file.");
        }
    }

    public void setOutput(OutputStream output) {
        this.output = output;
    }

    protected void allocate() {
    }

    protected void defaultSettings() {
        super.defaultSettings();
        this.textMode = 5;
    }

    public void beginDraw() {
        if (this.document == null) {
            this.document = new Document(new Rectangle((float)this.width, (float)this.height));
            try {
                if (this.file != null) {
                    this.output = new BufferedOutputStream(new FileOutputStream(this.file), 16384);
                } else if (this.output == null) {
                    throw new RuntimeException("PGraphicsPDF requires a path for the location of the output file.");
                }
                this.writer = PdfWriter.getInstance((Document)this.document, (OutputStream)this.output);
                this.document.open();
                this.content = this.writer.getDirectContent();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Problem saving the PDF file.");
            }
            this.g2 = this.content.createGraphicsShapes((float)this.width, (float)this.height);
        }
        this.checkSettings();
        this.resetMatrix();
        this.vertexCount = 0;
        this.pushMatrix();
    }

    protected static DefaultFontMapper getMapper() {
        if (mapper == null) {
            mapper = new DefaultFontMapper();
            if (PApplet.platform == 2) {
                try {
                    String homeLibraryFonts = String.valueOf(System.getProperty("user.home")) + "/Library/Fonts";
                    mapper.insertDirectory(homeLibraryFonts);
                }
                catch (Exception homeLibraryFonts) {
                    // empty catch block
                }
                mapper.insertDirectory("/System/Library/Fonts");
                mapper.insertDirectory("/Library/Fonts");
            } else if (PApplet.platform == 1) {
                File[] roots = File.listRoots();
                int i = 0;
                while (i < roots.length) {
                    if (!roots[i].toString().startsWith("A:")) {
                        File folder = new File(roots[i], "WINDOWS/Fonts");
                        if (folder.exists()) {
                            mapper.insertDirectory(folder.getAbsolutePath());
                            break;
                        }
                        folder = new File(roots[i], "WINNT/Fonts");
                        if (folder.exists()) {
                            mapper.insertDirectory(folder.getAbsolutePath());
                            break;
                        }
                    }
                    ++i;
                }
            } else if (PApplet.platform == 3) {
                PGraphicsPDF.checkDir("/usr/share/fonts/", mapper);
                PGraphicsPDF.checkDir("/usr/local/share/fonts/", mapper);
                PGraphicsPDF.checkDir(String.valueOf(System.getProperty("user.home")) + "/.fonts", mapper);
            }
        }
        return mapper;
    }

    protected static void checkDir(String path, DefaultFontMapper mapper) {
        File folder = new File(path);
        if (folder.exists()) {
            mapper.insertDirectory(path);
            PGraphicsPDF.traverseDir(folder, mapper);
        }
    }

    protected static void traverseDir(File folder, DefaultFontMapper mapper) {
        File[] files = folder.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                mapper.insertDirectory(files[i].getPath());
                PGraphicsPDF.traverseDir(new File(files[i].getPath()), mapper);
            }
            ++i;
        }
    }

    public void endDraw() {
        this.popMatrix();
    }

    protected static boolean fileExists(File file) {
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "dir", file.getAbsolutePath()});
            boolean haveExitCode = false;
            int exitCode = -1;
            InputStream out = process.getInputStream();
            InputStream err = process.getErrorStream();
            while (!haveExitCode) {
                while (out.read() >= 0) {
                }
                while (err.read() >= 0) {
                }
                try {
                    exitCode = process.exitValue();
                    haveExitCode = true;
                }
                catch (IllegalThreadStateException e) {
                    Thread.sleep(100L);
                }
            }
            return exitCode == 0;
        }
        catch (IOException e) {
            System.out.println("Unable to check for file: " + file + " : " + e);
            return false;
        }
        catch (InterruptedException e) {
            System.out.println("Unable to check for file.  Interrupted: " + file + " : " + e);
            return false;
        }
    }

    public void nextPage() {
        PStyle savedStyle = this.getStyle();
        this.endDraw();
        this.g2.dispose();
        try {
            this.document.newPage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.g2 = this.createGraphics();
        this.beginDraw();
        this.style(savedStyle);
    }

    protected Graphics2D createGraphics() {
        if (this.textMode == 5) {
            return this.content.createGraphicsShapes((float)this.width, (float)this.height);
        }
        if (this.textMode == 4) {
            return this.content.createGraphics((float)this.width, (float)this.height, (FontMapper)PGraphicsPDF.getMapper());
        }
        throw new RuntimeException("Invalid textMode() selected for PDF.");
    }

    public void dispose() {
        if (this.document != null) {
            this.g2.dispose();
            this.document.close();
            this.document = null;
        }
    }

    public boolean displayable() {
        return false;
    }

    public void textFont(PFont which) {
        super.textFont(which);
        this.checkFont();
    }

    public void textMode(int mode) {
        if (this.textMode != mode) {
            if (mode == 5) {
                this.textMode = 5;
                this.g2.dispose();
                this.g2 = this.createGraphics();
            } else if (mode == 4) {
                this.textMode = 4;
                this.g2.dispose();
                this.g2 = this.createGraphics();
            } else {
                if (mode == 256) {
                    throw new RuntimeException("textMode(SCREEN) not supported with PDF");
                }
                throw new RuntimeException("That textMode() does not exist");
            }
        }
    }

    protected void textLineImpl(char[] buffer, int start, int stop, float x, float y) {
        this.checkFont();
        super.textLineImpl(buffer, start, stop, x, y);
    }

    public void loadPixels() {
        this.nope("loadPixels");
    }

    public void updatePixels() {
        this.nope("updatePixels");
    }

    public void updatePixels(int x, int y, int c, int d) {
        this.nope("updatePixels");
    }

    public int get(int x, int y) {
        this.nope("get");
        return 0;
    }

    public PImage get(int x, int y, int c, int d) {
        this.nope("get");
        return null;
    }

    public PImage get() {
        this.nope("get");
        return null;
    }

    public void set(int x, int y, int argb) {
        this.nope("set");
    }

    public void set(int x, int y, PImage image) {
        this.nope("set");
    }

    public void mask(int[] alpha) {
        this.nope("mask");
    }

    public void mask(PImage alpha) {
        this.nope("mask");
    }

    public void filter(int kind) {
        this.nope("filter");
    }

    public void filter(int kind, float param) {
        this.nope("filter");
    }

    public void copy(int sx1, int sy1, int sx2, int sy2, int dx1, int dy1, int dx2, int dy2) {
        this.nope("copy");
    }

    public void copy(PImage src, int sx1, int sy1, int sx2, int sy2, int dx1, int dy1, int dx2, int dy2) {
        this.nope("copy");
    }

    public void blend(int sx, int sy, int dx, int dy, int mode) {
        this.nope("blend");
    }

    public void blend(PImage src, int sx, int sy, int dx, int dy, int mode) {
        this.nope("blend");
    }

    public void blend(int sx1, int sy1, int sx2, int sy2, int dx1, int dy1, int dx2, int dy2, int mode) {
        this.nope("blend");
    }

    public void blend(PImage src, int sx1, int sy1, int sx2, int sy2, int dx1, int dy1, int dx2, int dy2, int mode) {
        this.nope("blend");
    }

    public boolean save(String filename) {
        this.nope("save");
        return false;
    }

    public void addFonts(String directory) {
        mapper.insertDirectory(directory);
    }

    protected void checkFont() {
        Font awtFont = (Font)this.textFont.getNative();
        if (awtFont == null) {
            throw new RuntimeException("Use createFont() instead of loadFont() when drawing text using the PDF library.");
        }
        if (this.textMode != 5) {
            if (this.textFont.isStream()) {
                throw new RuntimeException("Use textMode(SHAPE) with PDF when loading .ttf and .otf files with createFont().");
            }
            if (mapper.getAliases().get(this.textFont.getName()) == null) {
                if (this.textFont.getName().equals("Lucida Sans")) {
                    throw new RuntimeException("Use textMode(SHAPE) with the default font when exporting to PDF.");
                }
                throw new RuntimeException("Use textMode(SHAPE) with \u201c" + this.textFont.getName() + "\u201d " + "when exporting to PDF.");
            }
        }
    }

    public static String[] listFonts() {
        if (fontList == null) {
            HashMap map = PGraphicsPDF.getMapper().getAliases();
            fontList = new String[map.size()];
            int count = 0;
            for (Map.Entry entry : map.entrySet()) {
                PGraphicsPDF.fontList[count++] = (String)entry.getKey();
            }
            fontList = PApplet.sort((String[])fontList);
        }
        return fontList;
    }

    protected void nope(String function) {
        throw new RuntimeException("No " + function + "() for PGraphicsPDF");
    }
}

