/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns;

import com.notnoop.apns.ApnsFeedbackServerSocket;
import com.notnoop.apns.ApnsGatewayServerSocket;
import com.notnoop.apns.ApnsServerExceptionDelegate;
import com.notnoop.apns.ApnsServerService;
import com.notnoop.apns.ApnsSocketService;
import com.notnoop.apns.internal.Utilities;
import com.notnoop.exceptions.InvalidSSLConfig;
import com.notnoop.exceptions.RuntimeIOException;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;

public class ApnsServerSocketBuilder {
    private static final String KEYSTORE_TYPE = "PKCS12";
    private static final String KEY_ALGORITHM = "sunx509";
    private SSLContext sslContext = null;
    private int gatewayPort = -1;
    private int feedbackPort = -1;
    private ExecutorService executor = null;
    private ApnsServerService serverService = ApnsServerService.EMPTY;
    private ApnsServerExceptionDelegate exceptionDelegate = ApnsServerExceptionDelegate.EMPTY;

    public ApnsServerSocketBuilder withCert(String fileName, String password) throws RuntimeIOException, InvalidSSLConfig {
        ApnsServerSocketBuilder apnsServerSocketBuilder;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(fileName);
            apnsServerSocketBuilder = this.withCert(stream, password);
        }
        catch (FileNotFoundException e) {
            try {
                throw new RuntimeIOException((IOException)e);
            }
            catch (Throwable throwable) {
                Utilities.close(stream);
                throw throwable;
            }
        }
        Utilities.close((Closeable)stream);
        return apnsServerSocketBuilder;
    }

    public ApnsServerSocketBuilder withCert(InputStream stream, String password) throws InvalidSSLConfig {
        this.assertPasswordNotEmpty(password);
        return this.withSSLContext(Utilities.newSSLContext((InputStream)stream, (String)password, (String)KEYSTORE_TYPE, (String)KEY_ALGORITHM));
    }

    public ApnsServerSocketBuilder withCert(KeyStore keyStore, String password) throws InvalidSSLConfig {
        this.assertPasswordNotEmpty(password);
        return this.withSSLContext(Utilities.newSSLContext((KeyStore)keyStore, (String)password, (String)KEY_ALGORITHM));
    }

    private void assertPasswordNotEmpty(String password) {
        if (password == null || password.length() == 0) {
            throw new IllegalArgumentException("Passwords must be specified.Oracle Java SDK does not support passwordless p12 certificates");
        }
    }

    public ApnsServerSocketBuilder withSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public ApnsServerSocketBuilder withGatewayDestination(int port) {
        this.gatewayPort = port;
        return this;
    }

    public ApnsServerSocketBuilder withFeedbackDestination(int port) {
        this.feedbackPort = port;
        return this;
    }

    public ApnsServerSocketBuilder withSandboxDestination() {
        return this.withGatewayDestination(2195).withFeedbackDestination(2196);
    }

    public ApnsServerSocketBuilder withProductionDestination() {
        return this.withGatewayDestination(2195).withFeedbackDestination(2196);
    }

    public ApnsServerSocketBuilder asPool(int maxConnections) {
        return this.asPool(new ThreadPoolExecutor(maxConnections, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>()));
    }

    public ApnsServerSocketBuilder asPool(ExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public ApnsServerSocketBuilder withService(ApnsServerService serverService) {
        this.serverService = serverService == null ? ApnsServerService.EMPTY : serverService;
        return this;
    }

    public ApnsServerSocketBuilder withDelegate(ApnsServerExceptionDelegate exceptionDelegate) {
        this.exceptionDelegate = exceptionDelegate == null ? ApnsServerExceptionDelegate.EMPTY : exceptionDelegate;
        return this;
    }

    public ApnsSocketService build() throws IOException {
        this.checkInitialization();
        ApnsGatewayServerSocket apnsPushServerSocket = new ApnsGatewayServerSocket(this.sslContext, this.gatewayPort, this.executor, this.serverService, this.exceptionDelegate);
        ApnsFeedbackServerSocket apnsFeedbackServerSocket = new ApnsFeedbackServerSocket(this.sslContext, this.feedbackPort, this.executor, this.serverService, this.exceptionDelegate);
        ApnsSocketService service = new ApnsSocketService(apnsPushServerSocket, apnsFeedbackServerSocket);
        service.start();
        return service;
    }

    private void checkInitialization() {
        if (this.sslContext == null) {
            throw new IllegalStateException("SSL Certificates and attribute are not initialized\nUse .withCert() methods.");
        }
        if (this.executor == null) {
            throw new IllegalStateException("SSL Certificates and attribute are not initialized\nUse .withCert() methods.");
        }
        if (this.gatewayPort == -1 || this.feedbackPort == -1) {
            throw new IllegalStateException("The Destination APNS server is not stated\nUse .withDestination(), withSandboxDestination(), or withProductionDestination().");
        }
    }
}

