/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.integration;

import com.notnoop.apns.APNS;
import com.notnoop.apns.ApnsDelegate;
import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.ApnsService;
import com.notnoop.apns.EnhancedApnsNotification;
import com.notnoop.apns.internal.Utilities;
import com.notnoop.apns.utils.FixedCertificates;
import com.notnoop.apns.utils.Simulator.ApnsServerSimulator;
import com.notnoop.apns.utils.Simulator.FailingApnsServerSimulator;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.lidalia.slf4jext.Level;
import uk.org.lidalia.slf4jtest.LoggingEvent;
import uk.org.lidalia.slf4jtest.TestLoggerFactory;

public class ApnsSimulatorTestBase {
    final Logger logger = LoggerFactory.getLogger(ApnsSimulatorTestBase.class);
    private static final String payload = "{\"aps\":{}}";
    @Rule
    public TestName name = new TestName();
    protected FailingApnsServerSimulator server;
    protected ApnsDelegate delegate;
    private ApnsService service;
    private Random random;

    @Before
    public void startup() {
        TestLoggerFactory.getInstance().setPrintLevel(Level.DEBUG);
        TestLoggerFactory.clearAll();
        this.logger.info("\n\n\n\n\n");
        this.logger.info("********* Test: {}", (Object)this.name.getMethodName());
        this.server = new FailingApnsServerSimulator(FixedCertificates.serverContext().getServerSocketFactory());
        this.server.start();
        this.delegate = ApnsDelegate.EMPTY;
        this.delegate = (ApnsDelegate)Mockito.mock(ApnsDelegate.class);
        this.service = APNS.newService().withSSLContext(FixedCertificates.clientContext()).withGatewayDestination("localhost", this.server.getEffectiveGatewayPort()).withFeedbackDestination("localhost", this.server.getEffectiveFeedbackPort()).withDelegate(this.delegate).build();
        this.random = new Random();
    }

    @After
    public void tearDown() {
        this.server.stop();
        this.server = null;
    }

    protected Matcher<? super LoggingEvent> eventContains(final String subString) {
        return new BaseMatcher<LoggingEvent>(){

            public boolean matches(Object item) {
                String message = ((LoggingEvent)item).getMessage();
                return message.contains(subString);
            }

            public void describeTo(Description description) {
                description.appendText("substring [" + subString + "]");
            }
        };
    }

    protected void send(int ... codes) {
        for (int code : codes) {
            this.send(code);
        }
    }

    protected void send(int code) {
        EnhancedApnsNotification notification = this.makeNotification(code);
        this.service.push((ApnsNotification)notification);
    }

    private EnhancedApnsNotification makeNotification(int code) {
        byte[] deviceToken = new byte[32];
        this.random.nextBytes(deviceToken);
        if (code == 0) {
            deviceToken[0] = 42;
        } else {
            deviceToken[0] = -1;
            deviceToken[1] = -1;
            if (code < -100) {
                deviceToken[2] = 2;
            } else if (code < 0) {
                deviceToken[2] = 1;
                deviceToken[3] = (byte)(-code);
            } else {
                assert (code > 0);
                deviceToken[2] = 0;
                deviceToken[3] = (byte)code;
            }
        }
        return new EnhancedApnsNotification(EnhancedApnsNotification.INCREMENT_ID(), 1, deviceToken, Utilities.toUTF8Bytes((String)payload));
    }

    protected void sendCount(int count, int code) {
        for (int i = 0; i < count; ++i) {
            this.send(code);
        }
    }

    protected void assertNumberReceived(int count) throws InterruptedException {
        int i;
        this.logger.debug("assertNumberReceived {}", (Object)count);
        try {
            for (i = 0; i < count; ++i) {
                ApnsServerSimulator.Notification notification = this.server.getQueue().poll(5L, TimeUnit.SECONDS);
                this.logger.debug("Polled notification {}", (Object)notification);
                if (notification != null) continue;
                throw new RuntimeException("poll timed out");
            }
        }
        catch (RuntimeException re) {
            this.logger.error("Exception in assertNumberReceived, took {}", (Object)i);
            throw re;
        }
        this.logger.debug("assertNumberReceived - successfully took {}", (Object)count);
        this.assertIdle();
    }

    protected void assertIdle() throws InterruptedException {
        this.logger.info("assertIdle");
        Thread.sleep(1000L);
        Assert.assertThat((Object)this.server.getQueue().size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    protected void assertDelegateSentCount(int count) {
        this.logger.info("assertDelegateSentCount {}", (Object)count);
        ((ApnsDelegate)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)count))).messageSent((ApnsNotification)Matchers.any(ApnsNotification.class), Matchers.anyBoolean());
    }
}

