/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import com.notnoop.apns.internal.Utilities;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class ApnsFeedbackParsingUtils {
    static byte[] simpleDevice = new byte[32];
    static byte[] firstDevice = new byte[32];
    static byte[] secondDevice = new byte[32];
    static byte[] thirdDevice = new byte[32];
    static int simpleDate;
    public static byte[] simple;
    static int firstDate;
    static int secondDate;
    static int thirdDate;
    public static byte[] three;

    static byte[] pack(byte[] ... args) {
        int total = 0;
        for (byte[] arg : args) {
            total += arg.length;
        }
        byte[] result = new byte[total];
        int index = 0;
        for (byte[] arg : args) {
            System.arraycopy(arg, 0, result, index, arg.length);
            index += arg.length;
        }
        return result;
    }

    protected static void checkRawSimple(Map<byte[], Integer> simpleParsed) {
        Assert.assertEquals((long)1L, (long)simpleParsed.size());
        Assert.assertThat(simpleParsed.keySet(), (Matcher)CoreMatchers.hasItem((Object)simpleDevice));
        for (Map.Entry<byte[], Integer> e : simpleParsed.entrySet()) {
            byte[] device = e.getKey();
            Integer date = e.getValue();
            if (Arrays.equals(simpleDevice, device)) {
                Assert.assertEquals((long)simpleDate, (long)date.intValue());
                continue;
            }
            Assert.fail((String)"Unexpected value in collection");
        }
    }

    protected static void checkRawThree(Map<byte[], Integer> threeParsed) {
        Assert.assertEquals((long)3L, (long)threeParsed.size());
        Set<byte[]> devices = threeParsed.keySet();
        Assert.assertThat(devices, (Matcher)CoreMatchers.hasItems((Object[])new byte[][]{firstDevice, secondDevice, thirdDevice}));
        for (Map.Entry<byte[], Integer> e : threeParsed.entrySet()) {
            byte[] device = e.getKey();
            Integer date = e.getValue();
            if (Arrays.equals(firstDevice, device)) {
                Assert.assertEquals((long)firstDate, (long)date.intValue());
                continue;
            }
            if (Arrays.equals(secondDevice, device)) {
                Assert.assertEquals((long)secondDate, (long)date.intValue());
                continue;
            }
            if (Arrays.equals(thirdDevice, device)) {
                Assert.assertEquals((long)thirdDate, (long)date.intValue());
                continue;
            }
            Assert.fail((String)"Unexpected value in collection");
        }
    }

    public static void checkParsedSimple(Map<String, Date> simpleParsed) {
        Date sd = new Date((long)simpleDate * 1000L);
        String deviceToken = Utilities.encodeHex((byte[])simpleDevice);
        Assert.assertEquals((long)1L, (long)simpleParsed.size());
        Assert.assertThat(simpleParsed.keySet(), (Matcher)CoreMatchers.hasItem((Object)deviceToken));
        Assert.assertEquals((Object)sd, (Object)simpleParsed.get(deviceToken));
    }

    public static void checkParsedThree(Map<String, Date> threeParsed) {
        Date d1 = new Date((long)firstDate * 1000L);
        String dt1 = Utilities.encodeHex((byte[])firstDevice);
        Date d2 = new Date((long)secondDate * 1000L);
        String dt2 = Utilities.encodeHex((byte[])secondDevice);
        Date d3 = new Date((long)thirdDate * 1000L);
        String dt3 = Utilities.encodeHex((byte[])thirdDevice);
        Assert.assertEquals((long)3L, (long)threeParsed.size());
        Assert.assertThat(threeParsed.keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{dt1, dt2, dt3}));
        Assert.assertEquals((Object)d1, (Object)threeParsed.get(dt1));
        Assert.assertEquals((Object)d2, (Object)threeParsed.get(dt2));
        Assert.assertEquals((Object)d3, (Object)threeParsed.get(dt3));
    }

    static {
        Random random = new Random();
        do {
            random.nextBytes(simpleDevice);
            random.nextBytes(firstDevice);
            random.nextBytes(secondDevice);
            random.nextBytes(thirdDevice);
        } while (Arrays.equals(firstDevice, secondDevice) || Arrays.equals(secondDevice, thirdDevice) || Arrays.equals(firstDevice, thirdDevice));
        simpleDate = 0;
        simple = ApnsFeedbackParsingUtils.pack({0, 0, 0, 0}, {0, 32}, simpleDevice);
        firstDate = 10;
        thirdDate = secondDate = 256;
        three = ApnsFeedbackParsingUtils.pack({0, 0, 0, 10}, {0, 32}, firstDevice, {0, 0, 1, 0}, {0, 32}, secondDevice, {0, 0, 1, 0}, {0, 32}, thirdDevice);
    }
}

