/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.internal.ApnsConnection;
import com.notnoop.apns.internal.ApnsPooledConnection;
import com.notnoop.exceptions.NetworkIOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ApnsPooledConnectionTest {
    private ApnsConnection errorPrototype;
    private ApnsConnection prototype;
    private ExecutorService executorService;

    @Before
    public void setup() {
        this.errorPrototype = (ApnsConnection)Mockito.mock(ApnsConnection.class);
        Mockito.when((Object)this.errorPrototype.copy()).thenReturn((Object)this.errorPrototype);
        ((ApnsConnection)Mockito.doThrow(NetworkIOException.class).when((Object)this.errorPrototype)).sendMessage((ApnsNotification)Mockito.any(ApnsNotification.class));
        this.prototype = (ApnsConnection)Mockito.mock(ApnsConnection.class);
        Mockito.when((Object)this.prototype.copy()).thenReturn((Object)this.prototype);
    }

    @After
    public void cleanup() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    @Test(expected=NetworkIOException.class)
    public void testSendMessage() throws Exception {
        ApnsPooledConnection conn = new ApnsPooledConnection(this.errorPrototype, 1, this.getSingleThreadExecutor());
        conn.sendMessage((ApnsNotification)Mockito.mock(ApnsNotification.class));
    }

    @Test
    public void testCopyCalls() throws Exception {
        ApnsPooledConnection conn = new ApnsPooledConnection(this.prototype, 1, this.getSingleThreadExecutor());
        for (int i = 0; i < 10; ++i) {
            conn.sendMessage((ApnsNotification)Mockito.mock(ApnsNotification.class));
        }
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)1))).copy();
    }

    @Test
    public void testCloseCalls() throws Exception {
        ApnsPooledConnection conn = new ApnsPooledConnection(this.prototype, 1, this.getSingleThreadExecutor());
        conn.sendMessage((ApnsNotification)Mockito.mock(ApnsNotification.class));
        conn.close();
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)2))).close();
    }

    private ExecutorService getSingleThreadExecutor() {
        this.executorService = Executors.newSingleThreadExecutor();
        return this.executorService;
    }
}

