/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import javax.net.SocketFactory;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.OngoingStubbing;

public class MockingUtils {
    static SocketFactory mockSocketFactory(OutputStream out, InputStream in) {
        try {
            Socket socket = (Socket)Mockito.mock(Socket.class);
            Mockito.when((Object)socket.getOutputStream()).thenReturn((Object)out);
            Mockito.when((Object)socket.getInputStream()).thenReturn((Object)in);
            SocketFactory factory = (SocketFactory)Mockito.mock(SocketFactory.class);
            Mockito.when((Object)factory.createSocket()).thenReturn((Object)socket);
            Mockito.when((Object)factory.createSocket(Mockito.anyString(), Mockito.anyInt())).thenReturn((Object)socket);
            return factory;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AssertionError((Object)"Cannot be here!");
        }
    }

    static SocketFactory mockClosedThenOpenSocket(OutputStream out, InputStream in, boolean isClosed, int failedTries) {
        try {
            ArrayList<Socket> socketMocks = new ArrayList<Socket>(failedTries + 1);
            for (int i = 0; i < failedTries; ++i) {
                Socket socket = (Socket)Mockito.mock(Socket.class);
                if (isClosed) {
                    MockingUtils.mockSocketClosed(socket);
                } else {
                    Mockito.when((Object)socket.getOutputStream()).thenThrow(new Throwable[]{new IOException("simulated IOException")});
                    ((Socket)Mockito.doAnswer((Answer)new DynamicMockSocketClosed(socket)).when((Object)socket)).close();
                }
                socketMocks.add(socket);
            }
            Socket socket = (Socket)Mockito.mock(Socket.class);
            Mockito.when((Object)socket.getOutputStream()).thenReturn((Object)out);
            Mockito.when((Object)socket.getInputStream()).thenReturn((Object)in);
            Mockito.when((Object)socket.isConnected()).thenReturn((Object)true);
            socketMocks.add(socket);
            SocketFactory factory = (SocketFactory)Mockito.mock(SocketFactory.class);
            OngoingStubbing stubbing = Mockito.when((Object)factory.createSocket(Mockito.anyString(), Mockito.anyInt()));
            for (Socket t : socketMocks) {
                stubbing = stubbing.thenReturn((Object)t);
            }
            return factory;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AssertionError((Object)"Cannot be here!");
        }
    }

    private static void mockSocketClosed(Socket socket) throws IOException {
        Mockito.when((Object)socket.isClosed()).thenReturn((Object)true);
        Mockito.when((Object)socket.isConnected()).thenReturn((Object)false);
        Mockito.when((Object)socket.getOutputStream()).thenThrow(new Throwable[]{new AssertionError((Object)"Should have checked for closed connection")});
    }

    private static class DynamicMockSocketClosed
    implements Answer<Void> {
        private final Socket socket;

        public DynamicMockSocketClosed(Socket socket) {
            this.socket = socket;
        }

        public Void answer(InvocationOnMock invocation) throws Throwable {
            MockingUtils.mockSocketClosed(this.socket);
            return null;
        }
    }
}

