/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.ApnsService;
import com.notnoop.apns.SimpleApnsNotification;
import com.notnoop.apns.internal.ApnsConnection;
import com.notnoop.apns.internal.ApnsFeedbackConnection;
import com.notnoop.apns.internal.ApnsServiceImpl;
import com.notnoop.apns.internal.QueuedApnsService;
import com.notnoop.apns.internal.QueuedApnsServiceTest;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class QueuedApnsServiceTCTest {
    SimpleApnsNotification notification = new SimpleApnsNotification("2342", "{}");

    @Test(expected=IllegalStateException.class)
    public void sendWithoutStarting() {
        QueuedApnsService service = new QueuedApnsService(null);
        service.push((ApnsNotification)this.notification);
    }

    @Test
    public void pushEventually() {
        QueuedApnsServiceTest.ConnectionStub connection = (QueuedApnsServiceTest.ConnectionStub)Mockito.spy((Object)new QueuedApnsServiceTest.ConnectionStub(0, 1));
        ApnsService service = this.newService(connection, null);
        service.push((ApnsNotification)this.notification);
        connection.semaphore.acquireUninterruptibly();
        ((QueuedApnsServiceTest.ConnectionStub)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).sendMessage((ApnsNotification)this.notification);
    }

    @Test
    public void doNotBlock() {
        int delay = 10000;
        QueuedApnsServiceTest.ConnectionStub connection = (QueuedApnsServiceTest.ConnectionStub)Mockito.spy((Object)new QueuedApnsServiceTest.ConnectionStub(10000, 2));
        QueuedApnsService queued = new QueuedApnsService((ApnsService)new ApnsServiceImpl((ApnsConnection)connection, null));
        queued.start();
        long time1 = System.currentTimeMillis();
        queued.push((ApnsNotification)this.notification);
        queued.push((ApnsNotification)this.notification);
        long time2 = System.currentTimeMillis();
        Assert.assertTrue((String)"queued.push() blocks", (time2 - time1 < 10000L ? 1 : 0) != 0);
        connection.interrupt();
        connection.semaphore.acquireUninterruptibly();
        ((QueuedApnsServiceTest.ConnectionStub)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)2))).sendMessage((ApnsNotification)this.notification);
        queued.stop();
    }

    protected ApnsService newService(ApnsConnection connection, ApnsFeedbackConnection feedback) {
        ApnsServiceImpl service = new ApnsServiceImpl(connection, null);
        QueuedApnsService queued = new QueuedApnsService((ApnsService)service);
        queued.start();
        return queued;
    }
}

