/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import com.notnoop.apns.ApnsService;
import com.notnoop.apns.internal.ApnsFeedbackConnection;
import com.notnoop.apns.internal.ApnsServiceImpl;
import com.notnoop.apns.internal.QueuedApnsService;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SillyTests {
    @Test
    public void testFeedbackCalls() {
        Map<String, Date> map = Collections.singletonMap("Test", new Date());
        ApnsFeedbackConnection feed = (ApnsFeedbackConnection)Mockito.mock(ApnsFeedbackConnection.class);
        Mockito.when((Object)feed.getInactiveDevices()).thenReturn(map);
        ApnsServiceImpl service = new ApnsServiceImpl(null, feed);
        Assert.assertEquals(map, (Object)service.getInactiveDevices());
        ((ApnsFeedbackConnection)Mockito.verify((Object)feed, (VerificationMode)Mockito.times((int)1))).getInactiveDevices();
    }

    @Test
    public void testQueuedFeedbackCalls() {
        Map<String, Date> map = Collections.singletonMap("Test", new Date());
        ApnsFeedbackConnection feed = (ApnsFeedbackConnection)Mockito.mock(ApnsFeedbackConnection.class);
        Mockito.when((Object)feed.getInactiveDevices()).thenReturn(map);
        ApnsServiceImpl service = new ApnsServiceImpl(null, feed);
        QueuedApnsService queued = new QueuedApnsService((ApnsService)service);
        Assert.assertEquals(map, (Object)queued.getInactiveDevices());
        ((ApnsFeedbackConnection)Mockito.verify((Object)feed, (VerificationMode)Mockito.times((int)1))).getInactiveDevices();
    }
}

