/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.utils.Simulator;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ApnsInputStream
extends DataInputStream {
    public ApnsInputStream(InputStream inputStream) {
        super(inputStream);
    }

    byte[] readBlob() throws IOException {
        int length = this.readUnsignedShort();
        byte[] blob = new byte[length];
        this.readFully(blob);
        return blob;
    }

    ApnsInputStream readFrame() throws IOException {
        int length = this.readInt();
        byte[] buffer = new byte[length];
        this.readFully(buffer);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer);
        return new ApnsInputStream(byteArrayInputStream);
    }

    public Item readItem() throws IOException {
        byte itemId = this.readByte();
        byte[] blob = this.readBlob();
        return new Item(itemId, blob);
    }

    public static class Item {
        public static final byte ID_DEVICE_TOKEN = 1;
        public static final byte ID_PAYLOAD = 2;
        public static final byte ID_NOTIFICATION_IDENTIFIER = 3;
        public static final byte ID_EXPIRATION_DATE = 4;
        public static final byte ID_PRIORITY = 5;
        public static final Item DEFAULT = new Item(0, new byte[0]);
        private final byte itemId;
        private final byte[] blob;

        public Item(byte itemId, byte[] blob) {
            this.itemId = itemId;
            this.blob = blob;
        }

        public byte getItemId() {
            return this.itemId;
        }

        public byte[] getBlob() {
            return (byte[])this.blob.clone();
        }

        public int getInt() {
            return this.blob.length < 4 ? 0 : ByteBuffer.wrap(this.blob).getInt();
        }

        public byte getByte() {
            return this.blob.length < 1 ? (byte)0 : this.blob[0];
        }
    }
}

