/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.utils.Simulator;

import com.notnoop.apns.utils.Simulator.ApnsServerSimulator;
import com.notnoop.apns.utils.Simulator.InputOutputSocket;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.net.ServerSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailingApnsServerSimulator
extends ApnsServerSimulator {
    private static final Logger logger = LoggerFactory.getLogger(FailingApnsServerSimulator.class);
    private BlockingQueue<ApnsServerSimulator.Notification> queue = new LinkedBlockingQueue<ApnsServerSimulator.Notification>();

    public FailingApnsServerSimulator(ServerSocketFactory sslFactory) {
        super(sslFactory);
    }

    @Override
    protected void onNotification(ApnsServerSimulator.Notification notification, InputOutputSocket inputOutputSocket) throws IOException {
        logger.debug("Queueing notification " + notification);
        this.queue.add(notification);
        byte[] token = notification.getDeviceToken();
        if (token.length == 32 && token[0] == -1 && token[1] == -1) {
            switch (token[2]) {
                case 0: {
                    this.fail(token[3], notification.getIdentifier(), inputOutputSocket);
                    break;
                }
                case 1: {
                    try {
                        int millis = token[3] * 100;
                        Thread.sleep(millis);
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                    break;
                }
                default: {
                    inputOutputSocket.close();
                }
            }
        }
    }

    @Override
    protected List<byte[]> getBadTokens() {
        return super.getBadTokens();
    }

    public BlockingQueue<ApnsServerSimulator.Notification> getQueue() {
        return this.queue;
    }
}

