/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.utils.junit;

import java.util.Iterator;
import java.util.Map;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class DumpThreadsOnErrorRule
implements TestRule {
    public Statement apply(Statement base, Description description) {
        return new DumpThreadsStatement(base);
    }

    private static class DumpThreadsStatement
    extends Statement {
        private final Statement base;

        private DumpThreadsStatement(Statement base) {
            this.base = base;
        }

        public void evaluate() throws Throwable {
            try {
                this.base.evaluate();
            }
            catch (Throwable t) {
                this.dumpAllThreads();
                throw t;
            }
        }

        private void dumpAllThreads() {
            Map<Thread, StackTraceElement[]> liveThreads = Thread.getAllStackTraces();
            Iterator<Thread> i$ = liveThreads.keySet().iterator();
            while (i$.hasNext()) {
                StackTraceElement[] trace;
                Thread o;
                Thread key = o = i$.next();
                System.err.println("\nThread " + key.getName());
                for (StackTraceElement aTrace : trace = liveThreads.get(key)) {
                    System.err.println("\tat " + aTrace);
                }
            }
        }
    }
}

