/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.utils.junit;

import com.notnoop.apns.utils.junit.Repeat;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RepeatRule
implements TestRule {
    public Statement apply(Statement base, Description description) {
        Repeat repeat = (Repeat)description.getAnnotation(Repeat.class);
        if (repeat != null) {
            return new RepeatStatement(repeat.count(), base);
        }
        return base;
    }

    private static class RepeatStatement
    extends Statement {
        private final int count;
        private final Statement base;

        private RepeatStatement(int count, Statement base) {
            this.count = count;
            this.base = base;
        }

        public void evaluate() throws Throwable {
            for (int i = this.count; i > 0; --i) {
                this.base.evaluate();
            }
        }
    }
}

