/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import com.notnoop.apns.ApnsDelegate;
import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.DeliveryError;
import com.notnoop.apns.EnhancedApnsNotification;
import com.notnoop.apns.ReconnectPolicy;
import com.notnoop.apns.internal.ApnsConnection;
import com.notnoop.apns.internal.ReconnectPolicies;
import com.notnoop.apns.internal.TlsTunnelBuilder;
import com.notnoop.apns.internal.Utilities;
import com.notnoop.exceptions.ApnsDeliveryErrorException;
import com.notnoop.exceptions.NetworkIOException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApnsConnectionImpl
implements ApnsConnection {
    private static final Logger logger = LoggerFactory.getLogger(ApnsConnectionImpl.class);
    private final SocketFactory factory;
    private final String host;
    private final int port;
    private final int readTimeout;
    private final int connectTimeout;
    private final Proxy proxy;
    private final String proxyUsername;
    private final String proxyPassword;
    private final ReconnectPolicy reconnectPolicy;
    private final ApnsDelegate delegate;
    private int cacheLength;
    private final boolean errorDetection;
    private final ThreadFactory threadFactory;
    private final boolean autoAdjustCacheLength;
    private final ConcurrentLinkedQueue<ApnsNotification> cachedNotifications;
    private final ConcurrentLinkedQueue<ApnsNotification> notificationsBuffer;
    private Socket socket;
    private final AtomicInteger threadId = new AtomicInteger(0);
    int DELAY_IN_MS = 1000;
    private static final int RETRIES = 3;

    public ApnsConnectionImpl(SocketFactory factory, String host, int port) {
        this(factory, host, port, new ReconnectPolicies.Never(), ApnsDelegate.EMPTY);
    }

    private ApnsConnectionImpl(SocketFactory factory, String host, int port, ReconnectPolicy reconnectPolicy, ApnsDelegate delegate) {
        this(factory, host, port, null, null, null, reconnectPolicy, delegate);
    }

    private ApnsConnectionImpl(SocketFactory factory, String host, int port, Proxy proxy, String proxyUsername, String proxyPassword, ReconnectPolicy reconnectPolicy, ApnsDelegate delegate) {
        this(factory, host, port, proxy, proxyUsername, proxyPassword, reconnectPolicy, delegate, false, null, 100, true, 0, 0);
    }

    public ApnsConnectionImpl(SocketFactory factory, String host, int port, Proxy proxy, String proxyUsername, String proxyPassword, ReconnectPolicy reconnectPolicy, ApnsDelegate delegate, boolean errorDetection, ThreadFactory tf, int cacheLength, boolean autoAdjustCacheLength, int readTimeout, int connectTimeout) {
        this.factory = factory;
        this.host = host;
        this.port = port;
        this.reconnectPolicy = reconnectPolicy;
        this.delegate = delegate == null ? ApnsDelegate.EMPTY : delegate;
        this.proxy = proxy;
        this.errorDetection = errorDetection;
        this.threadFactory = tf == null ? this.defaultThreadFactory() : tf;
        this.cacheLength = cacheLength;
        this.autoAdjustCacheLength = autoAdjustCacheLength;
        this.readTimeout = readTimeout;
        this.connectTimeout = connectTimeout;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.cachedNotifications = new ConcurrentLinkedQueue();
        this.notificationsBuffer = new ConcurrentLinkedQueue();
    }

    private ThreadFactory defaultThreadFactory() {
        return new ThreadFactory(){
            ThreadFactory wrapped = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(Runnable r) {
                Thread result = this.wrapped.newThread(r);
                result.setName("MonitoringThread-" + ApnsConnectionImpl.this.threadId.incrementAndGet());
                result.setDaemon(true);
                return result;
            }
        };
    }

    @Override
    public synchronized void close() {
        Utilities.close(this.socket);
    }

    private void monitorSocket(final Socket socket) {
        logger.debug("Launching Monitoring Thread for socket {}", (Object)socket);
        Thread t = this.threadFactory.newThread(new Runnable(){
            static final int EXPECTED_SIZE = 6;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                logger.debug("Started monitoring thread");
                try {
                    InputStream in;
                    try {
                        in = socket.getInputStream();
                    }
                    catch (IOException ioe) {
                        in = null;
                    }
                    byte[] bytes = new byte[6];
                    while (in != null && this.readPacket(in, bytes)) {
                        int resendSize;
                        logger.debug("Error-response packet {}", (Object)Utilities.encodeHex(bytes));
                        Utilities.close(socket);
                        int command = bytes[0] & 0xFF;
                        if (command != 8) {
                            throw new IOException("Unexpected command byte " + command);
                        }
                        int statusCode = bytes[1] & 0xFF;
                        DeliveryError e = DeliveryError.ofCode(statusCode);
                        int id = Utilities.parseBytes(bytes[2], bytes[3], bytes[4], bytes[5]);
                        logger.debug("Closed connection cause={}; id={}", (Object)e, (Object)id);
                        ApnsConnectionImpl.this.delegate.connectionClosed(e, id);
                        LinkedList<ApnsNotification> tempCache = new LinkedList<ApnsNotification>();
                        ApnsNotification notification = null;
                        boolean foundNotification = false;
                        while (!ApnsConnectionImpl.this.cachedNotifications.isEmpty()) {
                            notification = (ApnsNotification)ApnsConnectionImpl.this.cachedNotifications.poll();
                            logger.debug("Candidate for removal, message id {}", (Object)notification.getIdentifier());
                            if (notification.getIdentifier() == id) {
                                logger.debug("Bad message found {}", (Object)notification.getIdentifier());
                                foundNotification = true;
                                break;
                            }
                            tempCache.add(notification);
                        }
                        if (foundNotification) {
                            logger.debug("delegate.messageSendFailed, message id {}", (Object)notification.getIdentifier());
                            ApnsConnectionImpl.this.delegate.messageSendFailed(notification, new ApnsDeliveryErrorException(e));
                        } else {
                            ApnsConnectionImpl.this.cachedNotifications.addAll(tempCache);
                            resendSize = tempCache.size();
                            logger.warn("Received error for message that wasn't in the cache...");
                            if (ApnsConnectionImpl.this.autoAdjustCacheLength) {
                                ApnsConnectionImpl.this.cacheLength = ApnsConnectionImpl.this.cacheLength + resendSize / 2;
                                ApnsConnectionImpl.this.delegate.cacheLengthExceeded(ApnsConnectionImpl.this.cacheLength);
                            }
                            logger.debug("delegate.messageSendFailed, unknown id");
                            ApnsConnectionImpl.this.delegate.messageSendFailed(null, new ApnsDeliveryErrorException(e));
                        }
                        resendSize = 0;
                        while (!ApnsConnectionImpl.this.cachedNotifications.isEmpty()) {
                            ++resendSize;
                            ApnsNotification resendNotification = (ApnsNotification)ApnsConnectionImpl.this.cachedNotifications.poll();
                            logger.debug("Queuing for resend {}", (Object)resendNotification.getIdentifier());
                            ApnsConnectionImpl.this.notificationsBuffer.add(resendNotification);
                        }
                        logger.debug("resending {} notifications", (Object)resendSize);
                        ApnsConnectionImpl.this.delegate.notificationsResent(resendSize);
                    }
                    logger.debug("Monitoring input stream closed by EOF");
                }
                catch (IOException e) {
                    logger.info("Exception while waiting for error code", (Throwable)e);
                    ApnsConnectionImpl.this.delegate.connectionClosed(DeliveryError.UNKNOWN, -1);
                }
                finally {
                    ApnsConnectionImpl.this.close();
                    ApnsConnectionImpl.this.drainBuffer();
                }
            }

            private boolean readPacket(InputStream in, byte[] bytes) throws IOException {
                int count;
                int len = bytes.length;
                for (int n = 0; n < len; n += count) {
                    try {
                        count = in.read(bytes, n, len - n);
                        if (count >= 0) continue;
                        throw new EOFException("EOF after reading " + n + " bytes of new packet.");
                    }
                    catch (IOException ioe) {
                        if (n == 0) {
                            return false;
                        }
                        throw new IOException("Error after reading " + n + " bytes of packet", ioe);
                    }
                }
                return true;
            }
        });
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Socket getOrCreateSocket() throws NetworkIOException {
        if (this.reconnectPolicy.shouldReconnect()) {
            logger.debug("Reconnecting due to reconnectPolicy dictating it");
            Utilities.close(this.socket);
            this.socket = null;
        }
        if (this.socket == null || this.socket.isClosed()) {
            try {
                if (this.proxy == null) {
                    this.socket = this.factory.createSocket(this.host, this.port);
                    logger.debug("Connected new socket {}", (Object)this.socket);
                } else if (this.proxy.type() == Proxy.Type.HTTP) {
                    TlsTunnelBuilder tunnelBuilder = new TlsTunnelBuilder();
                    this.socket = tunnelBuilder.build((SSLSocketFactory)this.factory, this.proxy, this.proxyUsername, this.proxyPassword, this.host, this.port);
                    logger.debug("Connected new socket through http tunnel {}", (Object)this.socket);
                } else {
                    boolean success = false;
                    Socket proxySocket = null;
                    try {
                        proxySocket = new Socket(this.proxy);
                        proxySocket.connect(new InetSocketAddress(this.host, this.port), this.connectTimeout);
                        this.socket = ((SSLSocketFactory)this.factory).createSocket(proxySocket, this.host, this.port, false);
                        success = true;
                    }
                    finally {
                        if (!success) {
                            Utilities.close(proxySocket);
                        }
                    }
                    logger.debug("Connected new socket through socks tunnel {}", (Object)this.socket);
                }
                this.socket.setSoTimeout(this.readTimeout);
                this.socket.setKeepAlive(true);
                if (this.errorDetection) {
                    this.monitorSocket(this.socket);
                }
                this.reconnectPolicy.reconnected();
                logger.debug("Made a new connection to APNS");
            }
            catch (IOException e) {
                logger.error("Couldn't connect to APNS server", (Throwable)e);
                throw new NetworkIOException(e);
            }
        }
        return this.socket;
    }

    @Override
    public synchronized void sendMessage(ApnsNotification m) throws NetworkIOException {
        this.sendMessage(m, false);
        this.drainBuffer();
    }

    private synchronized void sendMessage(ApnsNotification m, boolean fromBuffer) throws NetworkIOException {
        logger.debug("sendMessage {} fromBuffer: {}", (Object)m, (Object)fromBuffer);
        int attempts = 0;
        while (true) {
            try {
                ++attempts;
                Socket socket = this.getOrCreateSocket();
                socket.getOutputStream().write(m.marshall());
                socket.getOutputStream().flush();
                this.cacheNotification(m);
                this.delegate.messageSent(m, fromBuffer);
                attempts = 0;
            }
            catch (IOException e) {
                Utilities.close(this.socket);
                if (attempts >= 3) {
                    logger.error("Couldn't send message after 3 retries." + m, (Throwable)e);
                    this.delegate.messageSendFailed(m, e);
                    Utilities.wrapAndThrowAsRuntimeException(e);
                }
                if (attempts == 1) continue;
                logger.info("Failed to send message " + m + "... trying again after delay", (Throwable)e);
                Utilities.sleep(this.DELAY_IN_MS);
                continue;
            }
            break;
        }
    }

    private synchronized void drainBuffer() {
        logger.debug("draining buffer");
        while (!this.notificationsBuffer.isEmpty()) {
            this.sendMessage(this.notificationsBuffer.poll(), true);
        }
    }

    private void cacheNotification(ApnsNotification notification) {
        this.cachedNotifications.add(notification);
        while (this.cachedNotifications.size() > this.cacheLength) {
            this.cachedNotifications.poll();
            logger.debug("Removing notification from cache " + notification);
        }
    }

    @Override
    public ApnsConnectionImpl copy() {
        return new ApnsConnectionImpl(this.factory, this.host, this.port, this.proxy, this.proxyUsername, this.proxyPassword, this.reconnectPolicy.copy(), this.delegate, this.errorDetection, this.threadFactory, this.cacheLength, this.autoAdjustCacheLength, this.readTimeout, this.connectTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testConnection() throws NetworkIOException {
        ApnsConnectionImpl testConnection = null;
        try {
            testConnection = new ApnsConnectionImpl(this.factory, this.host, this.port, this.proxy, this.proxyUsername, this.proxyPassword, this.reconnectPolicy.copy(), this.delegate);
            EnhancedApnsNotification notification = new EnhancedApnsNotification(0, 0, new byte[]{0}, new byte[]{0});
            testConnection.sendMessage(notification);
        }
        finally {
            if (testConnection != null) {
                testConnection.close();
            }
        }
    }

    @Override
    public void setCacheLength(int cacheLength) {
        this.cacheLength = cacheLength;
    }

    @Override
    public int getCacheLength() {
        return this.cacheLength;
    }
}

