/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.algs4.DirectedEdge;
import edu.princeton.cs.introcs.StdOut;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdjMatrixEdgeWeightedDigraph {
    private int V;
    private int E;
    private DirectedEdge[][] adj;

    public AdjMatrixEdgeWeightedDigraph(int V) {
        if (V < 0) {
            throw new RuntimeException("Number of vertices must be nonnegative");
        }
        this.V = V;
        this.E = 0;
        this.adj = new DirectedEdge[V][V];
    }

    public AdjMatrixEdgeWeightedDigraph(int V, int E) {
        this(V);
        if (E < 0) {
            throw new RuntimeException("Number of edges must be nonnegative");
        }
        if (E > V * V) {
            throw new RuntimeException("Too many edges");
        }
        while (this.E != E) {
            int v = (int)((double)V * Math.random());
            int w = (int)((double)V * Math.random());
            double weight = (double)Math.round(100.0 * Math.random()) / 100.0;
            this.addEdge(new DirectedEdge(v, w, weight));
        }
    }

    public int V() {
        return this.V;
    }

    public int E() {
        return this.E;
    }

    public void addEdge(DirectedEdge e) {
        int w;
        int v = e.from();
        if (this.adj[v][w = e.to()] == null) {
            ++this.E;
            this.adj[v][w] = e;
        }
    }

    public Iterable<DirectedEdge> adj(int v) {
        return new AdjIterator(v);
    }

    public String toString() {
        String NEWLINE = System.getProperty("line.separator");
        StringBuilder s = new StringBuilder();
        s.append(this.V + " " + this.E + NEWLINE);
        for (int v = 0; v < this.V; ++v) {
            s.append(v + ": ");
            for (DirectedEdge e : this.adj(v)) {
                s.append(e + "  ");
            }
            s.append(NEWLINE);
        }
        return s.toString();
    }

    public static void main(String[] args) {
        int V = Integer.parseInt(args[0]);
        int E = Integer.parseInt(args[1]);
        AdjMatrixEdgeWeightedDigraph G = new AdjMatrixEdgeWeightedDigraph(V, E);
        StdOut.println(G);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AdjIterator
    implements Iterator<DirectedEdge>,
    Iterable<DirectedEdge> {
        private int v;
        private int w = 0;

        public AdjIterator(int v) {
            this.v = v;
        }

        @Override
        public Iterator<DirectedEdge> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            while (this.w < AdjMatrixEdgeWeightedDigraph.this.V) {
                if (AdjMatrixEdgeWeightedDigraph.this.adj[this.v][this.w] != null) {
                    return true;
                }
                ++this.w;
            }
            return false;
        }

        @Override
        public DirectedEdge next() {
            if (this.hasNext()) {
                return AdjMatrixEdgeWeightedDigraph.this.adj[this.v][this.w++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

