/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.algs4.Bag;
import edu.princeton.cs.algs4.Edge;
import edu.princeton.cs.algs4.EdgeWeightedGraph;
import edu.princeton.cs.algs4.UF;
import edu.princeton.cs.introcs.In;
import edu.princeton.cs.introcs.StdOut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoruvkaMST {
    private Bag<Edge> mst = new Bag();
    private double weight;

    public BoruvkaMST(EdgeWeightedGraph G) {
        UF uf = new UF(G.V());
        for (int t = 1; t < G.V() && this.mst.size() < G.V() - 1; t += t) {
            int w;
            int v;
            Edge[] closest = new Edge[G.V()];
            for (Edge e : G.edges()) {
                int j;
                v = e.either();
                w = e.other(v);
                int i = uf.find(v);
                if (i == (j = uf.find(w))) continue;
                if (closest[i] == null || BoruvkaMST.less(e, closest[i])) {
                    closest[i] = e;
                }
                if (closest[j] != null && !BoruvkaMST.less(e, closest[j])) continue;
                closest[j] = e;
            }
            for (int i = 0; i < G.V(); ++i) {
                Edge e;
                e = closest[i];
                if (e == null || uf.connected(v = e.either(), w = e.other(v))) continue;
                this.mst.add(e);
                this.weight += e.weight();
                uf.union(v, w);
            }
        }
        assert (this.check(G));
    }

    public Iterable<Edge> edges() {
        return this.mst;
    }

    public double weight() {
        return this.weight;
    }

    private static boolean less(Edge e, Edge f) {
        return e.weight() < f.weight();
    }

    private boolean check(EdgeWeightedGraph G) {
        int w;
        int v;
        double totalWeight = 0.0;
        for (Edge e : this.edges()) {
            totalWeight += e.weight();
        }
        double EPSILON = 1.0E-12;
        if (Math.abs(totalWeight - this.weight()) > EPSILON) {
            System.err.printf("Weight of edges does not equal weight(): %f vs. %f\n", totalWeight, this.weight());
            return false;
        }
        UF uf = new UF(G.V());
        for (Edge e : this.edges()) {
            v = e.either();
            if (uf.connected(v, w = e.other(v))) {
                System.err.println("Not a forest");
                return false;
            }
            uf.union(v, w);
        }
        for (Edge e : this.edges()) {
            v = e.either();
            if (uf.connected(v, w = e.other(v))) continue;
            System.err.println("Not a spanning forest");
            return false;
        }
        for (Edge e : this.edges()) {
            int y;
            int x;
            v = e.either();
            w = e.other(v);
            uf = new UF(G.V());
            for (Edge f : this.mst) {
                x = f.either();
                y = f.other(x);
                if (f == e) continue;
                uf.union(x, y);
            }
            for (Edge f : G.edges()) {
                x = f.either();
                if (uf.connected(x, y = f.other(x)) || !(f.weight() < e.weight())) continue;
                System.err.println("Edge " + f + " violates cut optimality conditions");
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        In in = new In(args[0]);
        EdgeWeightedGraph G = new EdgeWeightedGraph(in);
        BoruvkaMST mst = new BoruvkaMST(G);
        for (Edge e : mst.edges()) {
            StdOut.println(e);
        }
        StdOut.printf("%.5f\n", mst.weight());
    }
}

