/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.algs4.Digraph;
import edu.princeton.cs.algs4.SET;
import edu.princeton.cs.introcs.StdRandom;

public class DigraphGenerator {
    public static Digraph complete(int V) {
        return DigraphGenerator.simple(V, V * (V - 1));
    }

    public static Digraph tournament(int V) {
        return DigraphGenerator.dag(V, V * (V - 1) / 2);
    }

    public static Digraph simple(int V, int E) {
        if ((long)E > (long)V * (long)(V - 1)) {
            throw new IllegalArgumentException("Too many edges");
        }
        if (E < 0) {
            throw new IllegalArgumentException("Too few edges");
        }
        Digraph G = new Digraph(V);
        SET<Edge> set = new SET<Edge>();
        while (G.E() < E) {
            int v = StdRandom.uniform(V);
            int w = StdRandom.uniform(V);
            Edge e = new Edge(v, w);
            if (v == w || set.contains(e)) continue;
            set.add(e);
            G.addEdge(v, w);
        }
        return G;
    }

    public static Digraph dag(int V, int E) {
        if ((long)E > (long)V * (long)(V - 1) / 2L) {
            throw new IllegalArgumentException("Too many edges");
        }
        if (E < 0) {
            throw new IllegalArgumentException("Too few edges");
        }
        Digraph G = new Digraph(V);
        SET<Edge> set = new SET<Edge>();
        int[] vertices = new int[V];
        for (int i = 0; i < V; ++i) {
            vertices[i] = i;
        }
        StdRandom.shuffle(vertices);
        while (G.E() < E) {
            int v = StdRandom.uniform(V);
            int w = StdRandom.uniform(V);
            Edge e = new Edge(v, w);
            if (v >= w || set.contains(e)) continue;
            set.add(e);
            G.addEdge(vertices[v], vertices[w]);
        }
        return G;
    }

    public static Digraph rootedInDAG(int V, int E) {
        Edge e;
        int w;
        int v;
        if ((long)E > (long)V * (long)(V - 1) / 2L) {
            throw new IllegalArgumentException("Too many edges");
        }
        if (E < V - 1) {
            throw new IllegalArgumentException("Too few edges");
        }
        Digraph G = new Digraph(V);
        SET<Edge> set = new SET<Edge>();
        int[] vertices = new int[V];
        for (int i = 0; i < V; ++i) {
            vertices[i] = i;
        }
        StdRandom.shuffle(vertices);
        for (v = 0; v < V - 1; ++v) {
            w = StdRandom.uniform(v + 1, V);
            e = new Edge(v, w);
            set.add(e);
            G.addEdge(vertices[v], vertices[w]);
        }
        while (G.E() < E) {
            v = StdRandom.uniform(V);
            w = StdRandom.uniform(V);
            e = new Edge(v, w);
            if (v >= w || set.contains(e)) continue;
            set.add(e);
            G.addEdge(vertices[v], vertices[w]);
        }
        return G;
    }

    public static Digraph rootedOutDAG(int V, int E) {
        Edge e;
        int w;
        int v;
        if ((long)E > (long)V * (long)(V - 1) / 2L) {
            throw new IllegalArgumentException("Too many edges");
        }
        if (E < V - 1) {
            throw new IllegalArgumentException("Too few edges");
        }
        Digraph G = new Digraph(V);
        SET<Edge> set = new SET<Edge>();
        int[] vertices = new int[V];
        for (int i = 0; i < V; ++i) {
            vertices[i] = i;
        }
        StdRandom.shuffle(vertices);
        for (v = 0; v < V - 1; ++v) {
            w = StdRandom.uniform(v + 1, V);
            e = new Edge(v, w);
            set.add(e);
            G.addEdge(vertices[w], vertices[v]);
        }
        while (G.E() < E) {
            v = StdRandom.uniform(V);
            w = StdRandom.uniform(V);
            e = new Edge(v, w);
            if (v >= w || set.contains(e)) continue;
            set.add(e);
            G.addEdge(vertices[w], vertices[v]);
        }
        return G;
    }

    public static Digraph rootedInTree(int V) {
        return DigraphGenerator.rootedInDAG(V, V - 1);
    }

    public static Digraph rootedOutTree(int V) {
        return DigraphGenerator.rootedOutDAG(V, V - 1);
    }

    public static Digraph path(int V) {
        int i;
        Digraph G = new Digraph(V);
        int[] vertices = new int[V];
        for (i = 0; i < V; ++i) {
            vertices[i] = i;
        }
        StdRandom.shuffle(vertices);
        for (i = 0; i < V - 1; ++i) {
            G.addEdge(vertices[i], vertices[i + 1]);
        }
        return G;
    }

    public static Digraph binaryTree(int V) {
        int i;
        Digraph G = new Digraph(V);
        int[] vertices = new int[V];
        for (i = 0; i < V; ++i) {
            vertices[i] = i;
        }
        StdRandom.shuffle(vertices);
        for (i = 1; i < V; ++i) {
            G.addEdge(vertices[i], vertices[(i - 1) / 2]);
        }
        return G;
    }

    public static Digraph cycle(int V) {
        int i;
        Digraph G = new Digraph(V);
        int[] vertices = new int[V];
        for (i = 0; i < V; ++i) {
            vertices[i] = i;
        }
        StdRandom.shuffle(vertices);
        for (i = 0; i < V - 1; ++i) {
            G.addEdge(vertices[i], vertices[i + 1]);
        }
        G.addEdge(vertices[V - 1], vertices[0]);
        return G;
    }

    public static void main(String[] args) {
        int V = Integer.parseInt(args[0]);
        int E = Integer.parseInt(args[1]);
        System.out.println("complete graph");
        System.out.println(DigraphGenerator.complete(V));
        System.out.println();
        System.out.println("simple");
        System.out.println(DigraphGenerator.simple(V, E));
        System.out.println();
        System.out.println("path");
        System.out.println(DigraphGenerator.path(V));
        System.out.println();
        System.out.println("cycle");
        System.out.println(DigraphGenerator.cycle(V));
        System.out.println();
        System.out.println("binary tree");
        System.out.println(DigraphGenerator.binaryTree(V));
        System.out.println();
        System.out.println("tournament");
        System.out.println(DigraphGenerator.tournament(V));
        System.out.println();
        System.out.println("DAG");
        System.out.println(DigraphGenerator.dag(V, E));
        System.out.println();
        System.out.println("rooted-in DAG");
        System.out.println(DigraphGenerator.rootedInDAG(V, E));
        System.out.println();
        System.out.println("rooted-out DAG");
        System.out.println(DigraphGenerator.rootedOutDAG(V, E));
        System.out.println();
        System.out.println("rooted-in tree");
        System.out.println(DigraphGenerator.rootedInTree(V));
        System.out.println();
        System.out.println("rooted-out DAG");
        System.out.println(DigraphGenerator.rootedOutTree(V));
        System.out.println();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Edge
    implements Comparable<Edge> {
        private int v;
        private int w;

        private Edge(int v, int w) {
            this.v = v;
            this.w = w;
        }

        @Override
        public int compareTo(Edge that) {
            if (this.v < that.v) {
                return -1;
            }
            if (this.v > that.v) {
                return 1;
            }
            if (this.w < that.w) {
                return -1;
            }
            if (this.w > that.w) {
                return 1;
            }
            return 0;
        }
    }
}

