/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.introcs.StdOut;

public class GaussianElimination {
    private static final double EPSILON = 1.0E-10;

    public static double[] lsolve(double[][] A, double[] b) {
        int N = b.length;
        for (int p = 0; p < N; ++p) {
            int max = p;
            for (int i = p + 1; i < N; ++i) {
                if (!(Math.abs(A[i][p]) > Math.abs(A[max][p]))) continue;
                max = i;
            }
            double[] temp = A[p];
            A[p] = A[max];
            A[max] = temp;
            double t = b[p];
            b[p] = b[max];
            b[max] = t;
            if (Math.abs(A[p][p]) <= 1.0E-10) {
                throw new ArithmeticException("Matrix is singular or nearly singular");
            }
            for (int i = p + 1; i < N; ++i) {
                double alpha = A[i][p] / A[p][p];
                int n = i;
                b[n] = b[n] - alpha * b[p];
                for (int j = p; j < N; ++j) {
                    double[] dArray = A[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] - alpha * A[p][j];
                }
            }
        }
        double[] x = new double[N];
        for (int i = N - 1; i >= 0; --i) {
            double sum = 0.0;
            for (int j = i + 1; j < N; ++j) {
                sum += A[i][j] * x[j];
            }
            x[i] = (b[i] - sum) / A[i][i];
        }
        return x;
    }

    public static void main(String[] args) {
        int N = 3;
        double[][] A = new double[][]{{0.0, 1.0, 1.0}, {2.0, 4.0, -2.0}, {0.0, 3.0, 15.0}};
        double[] b = new double[]{4.0, 2.0, 36.0};
        double[] x = GaussianElimination.lsolve(A, b);
        for (int i = 0; i < N; ++i) {
            StdOut.println(x[i]);
        }
    }
}

