/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.algs4.Counter;
import edu.princeton.cs.algs4.Interval1D;
import edu.princeton.cs.algs4.Point2D;
import edu.princeton.cs.introcs.StdDraw;
import edu.princeton.cs.introcs.StdOut;
import edu.princeton.cs.introcs.StdRandom;

public class Interval2D {
    private final Interval1D x;
    private final Interval1D y;

    public Interval2D(Interval1D x, Interval1D y) {
        this.x = x;
        this.y = y;
    }

    public boolean intersects(Interval2D that) {
        if (!this.x.intersects(that.x)) {
            return false;
        }
        return this.y.intersects(that.y);
    }

    public boolean contains(Point2D p) {
        return this.x.contains(p.x()) && this.y.contains(p.y());
    }

    public double area() {
        return this.x.length() * this.y.length();
    }

    public String toString() {
        return this.x + " x " + this.y;
    }

    public void draw() {
        double xc = (this.x.left() + this.x.right()) / 2.0;
        double yc = (this.y.left() + this.y.right()) / 2.0;
        StdDraw.rectangle(xc, yc, this.x.length() / 2.0, this.y.length() / 2.0);
    }

    public static void main(String[] args) {
        double xlo = Double.parseDouble(args[0]);
        double xhi = Double.parseDouble(args[1]);
        double ylo = Double.parseDouble(args[2]);
        double yhi = Double.parseDouble(args[3]);
        int T = Integer.parseInt(args[4]);
        Interval1D xinterval = new Interval1D(xlo, xhi);
        Interval1D yinterval = new Interval1D(ylo, yhi);
        Interval2D box = new Interval2D(xinterval, yinterval);
        box.draw();
        Counter counter = new Counter("hits");
        for (int t = 0; t < T; ++t) {
            double y;
            double x = StdRandom.random();
            Point2D p = new Point2D(x, y = StdRandom.random());
            if (box.contains(p)) {
                counter.increment();
                continue;
            }
            p.draw();
        }
        StdOut.println(counter);
        StdOut.printf("box area = %.2f\n", box.area());
    }
}

