/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.algs4.Queue;
import edu.princeton.cs.introcs.StdIn;
import edu.princeton.cs.introcs.StdOut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearProbingHashST<Key, Value> {
    private static final int INIT_CAPACITY = 4;
    private int N;
    private int M;
    private Key[] keys;
    private Value[] vals;

    public LinearProbingHashST() {
        this(4);
    }

    public LinearProbingHashST(int capacity) {
        this.M = capacity;
        this.keys = new Object[this.M];
        this.vals = new Object[this.M];
    }

    public int size() {
        return this.N;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Key key) {
        return this.get(key) != null;
    }

    private int hash(Key key) {
        return (key.hashCode() & Integer.MAX_VALUE) % this.M;
    }

    private void resize(int capacity) {
        LinearProbingHashST<Key, Value> temp = new LinearProbingHashST<Key, Value>(capacity);
        for (int i = 0; i < this.M; ++i) {
            if (this.keys[i] == null) continue;
            temp.put(this.keys[i], this.vals[i]);
        }
        this.keys = temp.keys;
        this.vals = temp.vals;
        this.M = temp.M;
    }

    public void put(Key key, Value val) {
        if (val == null) {
            this.delete(key);
        }
        if (this.N >= this.M / 2) {
            this.resize(2 * this.M);
        }
        int i = this.hash(key);
        while (this.keys[i] != null) {
            if (this.keys[i].equals(key)) {
                this.vals[i] = val;
                return;
            }
            i = (i + 1) % this.M;
        }
        this.keys[i] = key;
        this.vals[i] = val;
        ++this.N;
    }

    public Value get(Key key) {
        int i = this.hash(key);
        while (this.keys[i] != null) {
            if (this.keys[i].equals(key)) {
                return this.vals[i];
            }
            i = (i + 1) % this.M;
        }
        return null;
    }

    public void delete(Key key) {
        if (!this.contains(key)) {
            return;
        }
        int i = this.hash(key);
        while (!key.equals(this.keys[i])) {
            i = (i + 1) % this.M;
        }
        this.keys[i] = null;
        this.vals[i] = null;
        i = (i + 1) % this.M;
        while (this.keys[i] != null) {
            Key keyToRehash = this.keys[i];
            Value valToRehash = this.vals[i];
            this.keys[i] = null;
            this.vals[i] = null;
            --this.N;
            this.put(keyToRehash, valToRehash);
            i = (i + 1) % this.M;
        }
        --this.N;
        if (this.N > 0 && this.N <= this.M / 8) {
            this.resize(this.M / 2);
        }
        assert (this.check());
    }

    public Iterable<Key> keys() {
        Queue<Key> queue = new Queue<Key>();
        for (int i = 0; i < this.M; ++i) {
            if (this.keys[i] == null) continue;
            queue.enqueue(this.keys[i]);
        }
        return queue;
    }

    private boolean check() {
        if (this.M < 2 * this.N) {
            System.err.println("Hash table size M = " + this.M + "; array size N = " + this.N);
            return false;
        }
        for (int i = 0; i < this.M; ++i) {
            if (this.keys[i] == null || this.get(this.keys[i]) == this.vals[i]) continue;
            System.err.println("get[" + this.keys[i] + "] = " + this.get(this.keys[i]) + "; vals[i] = " + this.vals[i]);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        LinearProbingHashST<String, Integer> st = new LinearProbingHashST<String, Integer>();
        int i = 0;
        while (!StdIn.isEmpty()) {
            String key = StdIn.readString();
            st.put(key, i);
            ++i;
        }
        for (String s : st.keys()) {
            StdOut.println(s + " " + st.get(s));
        }
    }
}

