/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.introcs.StdIn;
import edu.princeton.cs.introcs.StdOut;

public class MergeX {
    private static final int CUTOFF = 7;

    private MergeX() {
    }

    private static void merge(Comparable[] src, Comparable[] dst, int lo, int mid, int hi) {
        assert (MergeX.isSorted(src, lo, mid));
        assert (MergeX.isSorted(src, mid + 1, hi));
        int i = lo;
        int j = mid + 1;
        for (int k = lo; k <= hi; ++k) {
            dst[k] = i > mid ? src[j++] : (j > hi ? src[i++] : (MergeX.less(src[j], src[i]) ? src[j++] : src[i++]));
        }
        assert (MergeX.isSorted(dst, lo, hi));
    }

    private static void sort(Comparable[] src, Comparable[] dst, int lo, int hi) {
        if (hi <= lo + 7) {
            MergeX.insertionSort(dst, lo, hi);
            return;
        }
        int mid = lo + (hi - lo) / 2;
        MergeX.sort(dst, src, lo, mid);
        MergeX.sort(dst, src, mid + 1, hi);
        if (!MergeX.less(src[mid + 1], src[mid])) {
            System.arraycopy(src, lo, dst, lo, hi - lo + 1);
            return;
        }
        MergeX.merge(src, dst, lo, mid, hi);
    }

    public static void sort(Comparable[] a) {
        Comparable[] aux = (Comparable[])a.clone();
        MergeX.sort(aux, a, 0, a.length - 1);
        assert (MergeX.isSorted(a));
    }

    private static void insertionSort(Comparable[] a, int lo, int hi) {
        for (int i = lo; i <= hi; ++i) {
            for (int j = i; j > lo && MergeX.less(a[j], a[j - 1]); --j) {
                MergeX.exch(a, j, j - 1);
            }
        }
    }

    private static void exch(Comparable[] a, int i, int j) {
        Comparable swap = a[i];
        a[i] = a[j];
        a[j] = swap;
    }

    private static boolean less(Comparable a, Comparable b) {
        return a.compareTo(b) < 0;
    }

    private static boolean isSorted(Comparable[] a) {
        return MergeX.isSorted(a, 0, a.length - 1);
    }

    private static boolean isSorted(Comparable[] a, int lo, int hi) {
        for (int i = lo + 1; i <= hi; ++i) {
            if (!MergeX.less(a[i], a[i - 1])) continue;
            return false;
        }
        return true;
    }

    private static void show(Comparable[] a) {
        for (int i = 0; i < a.length; ++i) {
            StdOut.println(a[i]);
        }
    }

    public static void main(String[] args) {
        String[] a = StdIn.readAllStrings();
        MergeX.sort((Comparable[])a);
        MergeX.show((Comparable[])a);
    }
}

