/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.introcs.StdIn;
import edu.princeton.cs.introcs.StdOut;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResizingArrayStack<Item>
implements Iterable<Item> {
    private Item[] a = new Object[2];
    private int N;

    public boolean isEmpty() {
        return this.N == 0;
    }

    public int size() {
        return this.N;
    }

    private void resize(int capacity) {
        assert (capacity >= this.N);
        Object[] temp = new Object[capacity];
        for (int i = 0; i < this.N; ++i) {
            temp[i] = this.a[i];
        }
        this.a = temp;
    }

    public void push(Item item) {
        if (this.N == this.a.length) {
            this.resize(2 * this.a.length);
        }
        this.a[this.N++] = item;
    }

    public Item pop() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Stack underflow");
        }
        Item item = this.a[this.N - 1];
        this.a[this.N - 1] = null;
        --this.N;
        if (this.N > 0 && this.N == this.a.length / 4) {
            this.resize(this.a.length / 2);
        }
        return item;
    }

    public Item peek() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Stack underflow");
        }
        return this.a[0];
    }

    @Override
    public Iterator<Item> iterator() {
        return new ReverseArrayIterator();
    }

    public static void main(String[] args) {
        ResizingArrayStack<String> s = new ResizingArrayStack<String>();
        while (!StdIn.isEmpty()) {
            String item = StdIn.readString();
            if (!item.equals("-")) {
                s.push(item);
                continue;
            }
            if (s.isEmpty()) continue;
            StdOut.print((String)s.pop() + " ");
        }
        StdOut.println("(" + s.size() + " left on stack)");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReverseArrayIterator
    implements Iterator<Item> {
        private int i;

        public ReverseArrayIterator() {
            this.i = ResizingArrayStack.this.N;
        }

        @Override
        public boolean hasNext() {
            return this.i > 0;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Item next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return ResizingArrayStack.this.a[--this.i];
        }
    }
}

