/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.introcs.StdOut;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SET<Key extends Comparable<Key>>
implements Iterable<Key> {
    private TreeSet<Key> set = new TreeSet();

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public void add(Key key) {
        this.set.add(key);
    }

    public boolean contains(Key key) {
        return this.set.contains(key);
    }

    public void delete(Key key) {
        this.set.remove(key);
    }

    public int size() {
        return this.set.size();
    }

    @Override
    public Iterator<Key> iterator() {
        return this.set.iterator();
    }

    public Key max() {
        return (Key)((Comparable)this.set.last());
    }

    public Key min() {
        return (Key)((Comparable)this.set.first());
    }

    public Key ceil(Key k) {
        SortedSet<Key> tail = this.set.tailSet(k);
        if (tail.isEmpty()) {
            return null;
        }
        return (Key)((Comparable)tail.first());
    }

    public Key floor(Key k) {
        if (this.set.contains(k)) {
            return k;
        }
        SortedSet<Key> head = this.set.headSet(k);
        if (head.isEmpty()) {
            return null;
        }
        return (Key)((Comparable)head.last());
    }

    public SET<Key> union(SET<Key> that) {
        SET<Comparable> c = new SET<Comparable>();
        for (Comparable x : this) {
            c.add(x);
        }
        for (Comparable x : that) {
            c.add(x);
        }
        return c;
    }

    public SET<Key> intersects(SET<Key> that) {
        SET<Comparable> c = new SET<Comparable>();
        if (this.size() < that.size()) {
            for (Comparable x : this) {
                if (!that.contains(x)) continue;
                c.add(x);
            }
        } else {
            for (Comparable x : that) {
                if (!this.contains(x)) continue;
                c.add(x);
            }
        }
        return c;
    }

    public boolean equals(Object y) {
        if (y == this) {
            return true;
        }
        if (y == null) {
            return false;
        }
        if (y.getClass() != this.getClass()) {
            return false;
        }
        SET that = (SET)y;
        if (this.size() != that.size()) {
            return false;
        }
        try {
            for (Comparable k : this) {
                if (that.contains(k)) continue;
                return false;
            }
        }
        catch (ClassCastException exception) {
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Comparable key : this) {
            s.append(key + " ");
        }
        return s.toString();
    }

    public static void main(String[] args) {
        SET<String> set = new SET<String>();
        set.add("www.cs.princeton.edu");
        set.add("www.cs.princeton.edu");
        set.add("www.princeton.edu");
        set.add("www.math.princeton.edu");
        set.add("www.yale.edu");
        set.add("www.amazon.com");
        set.add("www.simpsons.com");
        set.add("www.stanford.edu");
        set.add("www.google.com");
        set.add("www.ibm.com");
        set.add("www.apple.com");
        set.add("www.slashdot.com");
        set.add("www.whitehouse.gov");
        set.add("www.espn.com");
        set.add("www.snopes.com");
        set.add("www.movies.com");
        set.add("www.cnn.com");
        set.add("www.iitb.ac.in");
        StdOut.println(set.contains("www.cs.princeton.edu"));
        StdOut.println(!set.contains("www.harvardsucks.com"));
        StdOut.println(set.contains("www.simpsons.com"));
        StdOut.println();
        StdOut.println("ceil(www.simpsonr.com) = " + set.ceil("www.simpsonr.com"));
        StdOut.println("ceil(www.simpsons.com) = " + set.ceil("www.simpsons.com"));
        StdOut.println("ceil(www.simpsont.com) = " + set.ceil("www.simpsont.com"));
        StdOut.println("floor(www.simpsonr.com) = " + set.floor("www.simpsonr.com"));
        StdOut.println("floor(www.simpsons.com) = " + set.floor("www.simpsons.com"));
        StdOut.println("floor(www.simpsont.com) = " + set.floor("www.simpsont.com"));
        StdOut.println();
        for (String s : set) {
            StdOut.println(s);
        }
    }
}

