/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.algs4.Queue;
import edu.princeton.cs.introcs.StdIn;
import edu.princeton.cs.introcs.StdOut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TST<Value> {
    private int N;
    private Node root;

    public int size() {
        return this.N;
    }

    public boolean contains(String key) {
        return this.get(key) != null;
    }

    public Value get(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("key must have length >= 1");
        }
        Node x = this.get(this.root, key, 0);
        if (x == null) {
            return null;
        }
        return (Value)x.val;
    }

    private Node get(Node x, String key, int d) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("key must have length >= 1");
        }
        if (x == null) {
            return null;
        }
        char c = key.charAt(d);
        if (c < x.c) {
            return this.get(x.left, key, d);
        }
        if (c > x.c) {
            return this.get(x.right, key, d);
        }
        if (d < key.length() - 1) {
            return this.get(x.mid, key, d + 1);
        }
        return x;
    }

    public void put(String s, Value val) {
        if (!this.contains(s)) {
            ++this.N;
        }
        this.root = this.put(this.root, s, val, 0);
    }

    private Node put(Node x, String s, Value val, int d) {
        char c = s.charAt(d);
        if (x == null) {
            x = new Node();
            x.c = c;
        }
        if (c < x.c) {
            x.left = this.put(x.left, s, val, d);
        } else if (c > x.c) {
            x.right = this.put(x.right, s, val, d);
        } else if (d < s.length() - 1) {
            x.mid = this.put(x.mid, s, val, d + 1);
        } else {
            x.val = val;
        }
        return x;
    }

    public String longestPrefixOf(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        int length = 0;
        Node x = this.root;
        int i = 0;
        while (x != null && i < s.length()) {
            char c = s.charAt(i);
            if (c < x.c) {
                x = x.left;
                continue;
            }
            if (c > x.c) {
                x = x.right;
                continue;
            }
            ++i;
            if (x.val != null) {
                length = i;
            }
            x = x.mid;
        }
        return s.substring(0, length);
    }

    public Iterable<String> keys() {
        Queue<String> queue = new Queue<String>();
        this.collect(this.root, "", queue);
        return queue;
    }

    public Iterable<String> prefixMatch(String prefix) {
        Queue<String> queue = new Queue<String>();
        Node x = this.get(this.root, prefix, 0);
        if (x == null) {
            return queue;
        }
        if (x.val != null) {
            queue.enqueue(prefix);
        }
        this.collect(x.mid, prefix, queue);
        return queue;
    }

    private void collect(Node x, String prefix, Queue<String> queue) {
        if (x == null) {
            return;
        }
        this.collect(x.left, prefix, queue);
        if (x.val != null) {
            queue.enqueue(prefix + x.c);
        }
        this.collect(x.mid, prefix + x.c, queue);
        this.collect(x.right, prefix, queue);
    }

    public Iterable<String> wildcardMatch(String pat) {
        Queue<String> queue = new Queue<String>();
        this.collect(this.root, "", 0, pat, queue);
        return queue;
    }

    public void collect(Node x, String prefix, int i, String pat, Queue<String> q) {
        if (x == null) {
            return;
        }
        char c = pat.charAt(i);
        if (c == '.' || c < x.c) {
            this.collect(x.left, prefix, i, pat, q);
        }
        if (c == '.' || c == x.c) {
            if (i == pat.length() - 1 && x.val != null) {
                q.enqueue(prefix + x.c);
            }
            if (i < pat.length() - 1) {
                this.collect(x.mid, prefix + x.c, i + 1, pat, q);
            }
        }
        if (c == '.' || c > x.c) {
            this.collect(x.right, prefix, i, pat, q);
        }
    }

    public static void main(String[] args) {
        TST<Integer> st = new TST<Integer>();
        int i = 0;
        while (!StdIn.isEmpty()) {
            String key = StdIn.readString();
            st.put(key, i);
            ++i;
        }
        for (String key : st.keys()) {
            StdOut.println(key + " " + st.get(key));
        }
    }

    private class Node {
        private char c;
        private Node left;
        private Node mid;
        private Node right;
        private Value val;

        private Node() {
        }
    }
}

