package com.whimsy.map.algo;

import java.util.List;
import java.util.PriorityQueue;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.whimsy.map.base.Constant;
import com.whimsy.map.base.Edge;
import com.whimsy.map.base.Node;

import edu.princeton.cs.algs4.Bag;


import static com.whimsy.map.base.Utils.*;

/**
 * Created by whimsy on 6/1/15.
 */
public class AStar {
    static final Logger LOG = LoggerFactory.getLogger(AStar.class);

    Bag<Edge>[] bags;

    List<Node> nodes;

    @SuppressWarnings("unchecked")
    public AStar(List<Node> nodes, List<Edge> edges) {

        this.nodes = nodes;

        bags = new Bag[nodes.size()];

        for (int i = 0; i < nodes.size(); ++i) {
            bags[i] = new Bag<Edge>();
        }

        for (Edge edge : edges) {
            bags[edge.sId].add(edge);
        }
    }



    public double query(int s, int t) {

        PriorityQueue<HeapNode> pq = new PriorityQueue<HeapNode>();

        int n = bags.length;


        double [] d = new double[n];
        for (int i = 0; i < n; ++i) {
            d[i] = Constant.INF;
        }



        // initialize source node

        d[s] = 0;
        pq.add(new HeapNode(s, d[s] + estimateDist(s, t)));

        boolean [] isClosed = new boolean[n];

        while (!pq.isEmpty()) {
            HeapNode cur = pq.poll();

            if (isClosed[cur.idx]) continue;

            isClosed[cur.idx] = true;
            if (cur.idx == t) {
                break;
            }

            for (Edge edge : bags[cur.idx]) {
                if (d[edge.eId] > d[cur.idx] + edge.len()) {
                    d[edge.eId]  = d[cur.idx] + edge.len();
                    pq.add(new HeapNode(edge.eId, d[edge.eId] + estimateDist(edge.eId, t)));
                }
            }
        }

        LOG.debug("AStar distance : {}", d[t]);


        return d[t];

    }

    private double estimateDist(int s, int t) {
        return dist(nodes.get(s).lat, nodes.get(s).lon, nodes.get(t).lat, nodes.get(t).lon);

    }

    class HeapNode implements  Comparable<HeapNode> {

        int idx;
        double value;

        public HeapNode(int idx, double value) {
            this.idx = idx;
            this.value = value;
        }

        @Override
        public int compareTo(HeapNode o) {
            return value == o.value ? 0 : (value < o.value ? -1 : 1);
        }
    }


}
