/*
 * Decompiled with CFR 0.152.
 */
package com.whimsy.map.algo;

import com.whimsy.map.base.Edge;
import com.whimsy.map.base.Node;
import com.whimsy.map.base.Utils;
import edu.princeton.cs.algs4.Bag;
import java.util.List;
import java.util.PriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AStar {
    static final Logger LOG = LoggerFactory.getLogger(AStar.class);
    Bag<Edge>[] bags;
    List<Node> nodes;

    public AStar(List<Node> nodes, List<Edge> edges) {
        this.nodes = nodes;
        this.bags = new Bag[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            this.bags[i] = new Bag();
        }
        for (Edge edge : edges) {
            this.bags[edge.sId].add((Object)edge);
        }
    }

    public double query(int s, int t) {
        PriorityQueue<HeapNode> pq = new PriorityQueue<HeapNode>();
        int n = this.bags.length;
        double[] d = new double[n];
        for (int i = 0; i < n; ++i) {
            d[i] = 1.0E20;
        }
        d[s] = 0.0;
        pq.add(new HeapNode(s, d[s] + this.estimateDist(s, t)));
        boolean[] isClosed = new boolean[n];
        while (!pq.isEmpty()) {
            HeapNode cur = (HeapNode)pq.poll();
            if (isClosed[cur.idx]) continue;
            isClosed[cur.idx] = true;
            if (cur.idx == t) break;
            for (Edge edge : this.bags[cur.idx]) {
                if (!(d[edge.eId] > d[cur.idx] + edge.len())) continue;
                d[edge.eId] = d[cur.idx] + edge.len();
                pq.add(new HeapNode(edge.eId, d[edge.eId] + this.estimateDist(edge.eId, t)));
            }
        }
        LOG.debug("AStar distance : {}", (Object)d[t]);
        return d[t];
    }

    private double estimateDist(int s, int t) {
        return Utils.dist(this.nodes.get((int)s).lat, this.nodes.get((int)s).lon, this.nodes.get((int)t).lat, this.nodes.get((int)t).lon);
    }

    class HeapNode
    implements Comparable<HeapNode> {
        int idx;
        double value;

        public HeapNode(int idx, double value) {
            this.idx = idx;
            this.value = value;
        }

        @Override
        public int compareTo(HeapNode o) {
            return this.value == o.value ? 0 : (this.value < o.value ? -1 : 1);
        }
    }
}

