/*
 * Decompiled with CFR 0.152.
 */
package com.whimsy.map.base;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.whimsy.map.algo.AStar;
import com.whimsy.map.base.Edge;
import com.whimsy.map.base.Node;
import com.whimsy.map.base.Pair;
import com.whimsy.map.base.Utils;
import edu.princeton.cs.algs4.Point2D;
import edu.princeton.cs.algs4.Stopwatch;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Scanner;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Graph {
    Logger LOG = LoggerFactory.getLogger(Graph.class);
    boolean isNodeLoaded;
    public List<Node> nodes;
    boolean isEdgeLoaded;
    public List<Edge> edges;
    boolean isGridIndexBuilded = false;
    Area area;
    Set<Edge>[] grid;
    AStar shortestPathAlgo;
    public Map<Pair<Integer, Integer>, Double> shorestPairCache = Maps.newHashMap();

    public void loadNode(InputStream nodeFile) {
        this.LOG.info("Start Loading Node File");
        Stopwatch stopwatch = new Stopwatch();
        Scanner in = new Scanner(nodeFile);
        this.nodes = Lists.newArrayList();
        while (in.hasNext()) {
            int id = in.nextInt();
            double lat = in.nextDouble();
            double lon = in.nextDouble();
            this.nodes.add(new Node(lat, lon));
        }
        in.close();
        this.isNodeLoaded = true;
        this.LOG.info("Loaded Node File {} sec", (Object)stopwatch.elapsedTime());
    }

    public void loadEdge(InputStream edgeFile) {
        this.LOG.info("Start Loading Edge file");
        Stopwatch stopwatch = new Stopwatch();
        Scanner in = new Scanner(edgeFile);
        this.edges = Lists.newArrayList();
        while (in.hasNext()) {
            Edge edge = new Edge();
            int edgeId = in.nextInt();
            int sId = in.nextInt();
            int eId = in.nextInt();
            edge.id = edgeId;
            edge.sId = sId;
            edge.eId = eId;
            int num = in.nextInt();
            for (int i = 0; i < num; ++i) {
                double lat = in.nextDouble();
                double lon = in.nextDouble();
                Edge.Figure figure = new Edge.Figure();
                figure.lat = lat;
                figure.lon = lon;
                edge.figures.add(figure);
            }
            this.edges.add(edge);
        }
        this.isEdgeLoaded = true;
        this.LOG.info("Loaded Edge file {} sec", (Object)stopwatch.elapsedTime());
    }

    public void buildShortestPathAlgorithm() {
        this.LOG.debug("Start Build Shortest Path Algorithm");
        Stopwatch stopwatch = new Stopwatch();
        this.shortestPathAlgo = new AStar(this.nodes, this.edges);
        this.LOG.debug("Build Shortest Path, Used Time {} sec", (Object)stopwatch.elapsedTime());
    }

    void buildArea(int partition) {
        double minlat = 9.223372036854776E18;
        double minlon = 9.223372036854776E18;
        double maxlat = -9.223372036854776E18;
        double maxlon = -9.223372036854776E18;
        for (Edge edge : this.edges) {
            for (Edge.Figure figure : edge.figures) {
                minlat = Math.min(figure.lat, minlat);
                maxlat = Math.max(figure.lat, maxlat);
                minlon = Math.min(figure.lon, minlon);
                maxlon = Math.max(figure.lon, maxlon);
            }
        }
        this.area = new Area();
        this.area.minlat = minlat;
        this.area.maxlat = maxlat;
        this.area.minlon = minlon;
        this.area.maxlon = maxlon;
        this.area.partition = partition;
        this.area.refinement();
        this.LOG.trace("Bound Calced : minlat = {}, minlon = {}, maxlat = {}, maxlon = {}", new Object[]{minlat, minlon, maxlat, maxlon});
    }

    public int gridId(Edge.Figure figure, int size) {
        return 0;
    }

    public void buildGridIndex(int partition) {
        Stopwatch stopwatch = new Stopwatch();
        this.LOG.info("Start buildGridIndex partition = {}", (Object)partition);
        this.buildArea(partition);
        this.grid = new HashSet[partition * partition];
        for (int i = 0; i < partition * partition; ++i) {
            this.grid[i] = new HashSet<Edge>();
        }
        for (Edge edge : this.edges) {
            Edge.Figure fig1;
            int i;
            int x = 2;
            for (i = 0; i < edge.figures.size(); ++i) {
                fig1 = edge.figures.get(i);
                int partId = this.area.getPartId(fig1.lat, fig1.lon);
                this.grid[partId].add(edge);
            }
            for (i = 0; i < edge.figures.size() - 1; ++i) {
                int k;
                int t;
                Point2D rPoint;
                Point2D lPoint;
                int cur;
                int t2;
                int r;
                int l;
                int t3;
                fig1 = edge.figures.get(i);
                Edge.Figure fig2 = edge.figures.get(i + 1);
                int xBound1 = this.area.getPartId(fig1.lat, fig1.lon) / this.area.partition;
                int xBound2 = this.area.getPartId(fig2.lat, fig2.lon) / this.area.partition;
                int yBound1 = this.area.getPartId(fig1.lat, fig1.lon) % this.area.partition;
                int yBound2 = this.area.getPartId(fig2.lat, fig2.lon) % this.area.partition;
                if (xBound2 < xBound1) {
                    t3 = xBound2;
                    xBound2 = xBound1;
                    xBound1 = t3;
                }
                if (yBound1 > yBound2) {
                    t3 = yBound1;
                    yBound1 = yBound2;
                    yBound2 = t3;
                }
                if (Math.abs(fig2.lon - fig1.lon) > Math.abs(fig2.lat - fig1.lat)) {
                    l = this.area.getPartId(fig1.lat, fig1.lon) % this.area.partition;
                    r = this.area.getPartId(fig2.lat, fig2.lon) % this.area.partition;
                    if (r < l) {
                        t2 = l;
                        l = r;
                        r = t2;
                    }
                    for (cur = l; cur <= r; ++cur) {
                        double y1 = (double)cur * this.area.lonStep + this.area.minlon;
                        lPoint = Utils.intersectPoint(new Point2D(fig1.lat, fig1.lon), new Point2D(fig2.lat, fig2.lon), new Point2D(this.area.minlat - 100.0, y1), new Point2D(this.area.maxlat + 100.0, y1));
                        double y2 = (double)(cur + 1) * this.area.lonStep + this.area.minlon;
                        rPoint = Utils.intersectPoint(new Point2D(fig1.lat, fig1.lon), new Point2D(fig2.lat, fig2.lon), new Point2D(this.area.minlat - 100.0, y2), new Point2D(this.area.maxlat + 100.0, y2));
                        int gridX1 = this.area.getPartId(lPoint.x(), lPoint.y()) / this.area.partition;
                        int gridX2 = this.area.getPartId(rPoint.x(), rPoint.y()) / this.area.partition;
                        if ((gridX1 = this.checkAndRefine(xBound1, xBound2, gridX1)) > (gridX2 = this.checkAndRefine(xBound1, xBound2, gridX2))) {
                            t = gridX1;
                            gridX1 = gridX2;
                            gridX2 = t;
                        }
                        for (k = gridX1; k <= gridX2; ++k) {
                            this.grid[k * this.area.partition + cur].add(edge);
                        }
                    }
                    continue;
                }
                l = this.area.getPartId(fig1.lat, fig1.lon) / this.area.partition;
                r = this.area.getPartId(fig2.lat, fig2.lon) / this.area.partition;
                if (r < l) {
                    t2 = l;
                    l = r;
                    r = t2;
                }
                for (cur = l; cur <= r; ++cur) {
                    double x1 = (double)cur * this.area.latStep + this.area.minlat;
                    lPoint = Utils.intersectPoint(new Point2D(fig1.lat, fig1.lon), new Point2D(fig2.lat, fig2.lon), new Point2D(x1, this.area.minlon - 100.0), new Point2D(x1, this.area.minlon + 100.0));
                    double x2 = (double)(cur + 1) * this.area.latStep + this.area.minlat;
                    rPoint = Utils.intersectPoint(new Point2D(fig1.lat, fig1.lon), new Point2D(fig2.lat, fig2.lon), new Point2D(x2, this.area.minlat - 100.0), new Point2D(x2, this.area.maxlat + 100.0));
                    int gridY1 = this.area.getPartId(lPoint.x(), lPoint.y()) % this.area.partition;
                    int gridY2 = this.area.getPartId(rPoint.x(), rPoint.y()) % this.area.partition;
                    gridY1 = this.checkAndRefine(yBound1, yBound2, gridY1);
                    if ((gridY2 = this.checkAndRefine(yBound1, yBound2, gridY2)) < gridY1) {
                        t = gridY1;
                        gridY2 = gridY1;
                        gridY1 = t;
                    }
                    for (k = gridY1; k <= gridY2; ++k) {
                        this.grid[cur * this.area.partition + k].add(edge);
                    }
                }
            }
        }
        this.isGridIndexBuilded = true;
        this.LOG.info("Grid Index Builded in {} sec", (Object)stopwatch.elapsedTime());
    }

    private int checkAndRefine(int b1, int b2, int v) {
        if (v < b1) {
            return b1;
        }
        if (v > b2) {
            return b2;
        }
        return v;
    }

    public double shortestPathLength(int sId, int tId) {
        Double dist = this.shorestPairCache.get(new Pair<Integer, Integer>(sId, tId));
        if (dist != null) {
            return dist;
        }
        dist = this.shortestPathAlgo.query(sId, tId);
        this.shorestPairCache.put(new Pair<Integer, Integer>(sId, tId), dist);
        this.LOG.info("Query shortestPath bewteen {} to {}, length = {}", new Object[]{sId, tId, dist});
        return dist;
    }

    private static double sqr(double x) {
        return x * x;
    }

    public List<Edge> getNearEdges(final double lat, final double lon, int numOfCandidateEdges) {
        PriorityQueue<Edge> heap = new PriorityQueue<Edge>(numOfCandidateEdges * 2, new Comparator<Edge>(){

            @Override
            public int compare(Edge o1, Edge o2) {
                double dist2;
                double dist1 = Utils.distM(lat, lon, o1);
                return dist1 < (dist2 = Utils.distM(lat, lon, o2)) - 1.0E-8 ? -1 : (dist1 - 1.0E-8 > dist2 ? 1 : 0);
            }
        });
        HashSet<Edge> hasAdded = new HashSet<Edge>();
        int curGridId = this.area.getPartId(lat, lon);
        int gx = curGridId / this.area.partition;
        int gy = curGridId % this.area.partition;
        int step = 0;
        do {
            int i;
            HashSet<Edge> edgeToAdd = new HashSet<Edge>();
            if (step >= this.area.partition) break;
            for (i = -step; i <= step; ++i) {
                if (this.area.isLegal(i + gx) && this.area.isLegal(gy - step)) {
                    edgeToAdd.addAll(this.grid[this.area.index(i + gx, gy - step)]);
                }
                if (!this.area.isLegal(i + gx) || !this.area.isLegal(gy + step)) continue;
                edgeToAdd.addAll(this.grid[this.area.index(i + gx, gy + step)]);
            }
            for (i = -step + 1; i <= step - 1; ++i) {
                if (this.area.isLegal(gx - step) && this.area.isLegal(i + gy)) {
                    edgeToAdd.addAll(this.grid[this.area.index(gx - step, i + gy)]);
                }
                if (!this.area.isLegal(gx + step) || !this.area.isLegal(i + gy)) continue;
                edgeToAdd.addAll(this.grid[this.area.index(gx + step, i + gy)]);
            }
            for (Edge e : edgeToAdd) {
                if (hasAdded.contains(e)) continue;
                heap.add(e);
                hasAdded.add(e);
            }
        } while (++step == 1 || heap.size() < numOfCandidateEdges && step < this.area.partition);
        if (heap.size() < numOfCandidateEdges) {
            this.LOG.warn("candidate too few! expected = {}, got {}", (Object)numOfCandidateEdges, (Object)heap.size());
        }
        ArrayList resEdge = Lists.newArrayList();
        for (int cnt = 0; !heap.isEmpty() && cnt < numOfCandidateEdges; ++cnt) {
            resEdge.add(heap.poll());
        }
        return resEdge;
    }

    public void inspectGrid() {
        if (this.isGridIndexBuilded) {
            for (int i = 0; i < this.grid.length; ++i) {
                this.LOG.debug(i + " " + this.grid[i].toString());
            }
        } else {
            this.LOG.error("Gird Index Haven't build");
        }
    }

    static class Area {
        static Logger LOG = LoggerFactory.getLogger(Area.class);
        public double minlon;
        public double maxlon;
        public double minlat;
        public double maxlat;
        public int partition;
        public double latStep;
        public double lonStep;

        Area() {
        }

        public void refinement() {
            this.minlat -= 1.0E-8;
            this.maxlat += 1.0E-8;
            this.minlon -= 1.0E-8;
            this.maxlon += 1.0E-8;
            this.latStep = (this.maxlat - this.minlat) / (double)this.partition;
            this.lonStep = (this.maxlon - this.minlon) / (double)this.partition;
            LOG.trace("Area has been refined");
        }

        public int getPartId(double lat, double lon) {
            return (int)((lat - this.minlat - 1.0E-8) / this.latStep) * this.partition + (int)((lon - this.minlon - 1.0E-8) / this.lonStep);
        }

        boolean isLegal(int x) {
            return x >= 0 && x < this.partition;
        }

        int index(int x, int y) {
            return x * this.partition + y;
        }
    }
}

