/*
 * Decompiled with CFR 0.152.
 */
package com.whimsy.map.dataprocess;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import edu.princeton.cs.algs4.Stopwatch;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSMProcess {
    Logger LOG = LoggerFactory.getLogger(OSMProcess.class);
    Map<Long, Node> nodeMap = new HashMap<Long, Node>();
    List<Way> ways = new ArrayList<Way>();
    String nodeFile;
    String edgeFile;
    String sourceFile = "mapOSM.xml";
    ListMultimap<Long, Integer> node2way = ArrayListMultimap.create();
    Set<Long> node2Extract = new HashSet<Long>();

    public OSMProcess() {
        String outputPath = this.getClass().getClassLoader().getResource("").getPath();
        this.nodeFile = outputPath + "/nodeOSM.txt";
        this.edgeFile = outputPath + "/edgeOSM.txt";
    }

    void parseFromXML() throws Exception {
        XMLInputFactory factory = XMLInputFactory.newFactory();
        this.LOG.debug(factory.toString());
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.sourceFile);
        InputStreamReader reader = new InputStreamReader(is, "UTF-8");
        XMLEventReader r = factory.createXMLEventReader(reader);
        while (r.hasNext()) {
            XMLEvent e = r.nextEvent();
            if (!e.isStartElement()) continue;
            StartElement startElement = e.asStartElement();
            if (startElement.getName().getLocalPart().equals("node")) {
                this.parseNode(startElement, r);
            }
            if (!startElement.getName().getLocalPart().equals("way")) continue;
            this.parseWay(startElement, r);
        }
    }

    void spliceAndExtract() throws Exception {
        for (int idx = 0; idx < this.ways.size(); ++idx) {
            Way way = this.ways.get(idx);
            if (this.nodeMap.get(way.enode.get(0)) == null) {
                throw new RuntimeException("Node ID that doesn't exist!");
            }
            this.node2Extract.add(way.enode.get(0));
            if (this.nodeMap.get(way.enode.get(way.enode.size() - 1)) == null) {
                throw new RuntimeException("Node ID that doesn't exist!");
            }
            this.node2Extract.add(way.enode.get(way.enode.size() - 1));
            for (int i = 1; i < way.enode.size() - 1; ++i) {
                if (this.nodeMap.get(way.enode.get(i)) == null) {
                    throw new RuntimeException("Node ID that doesn't exist!");
                }
                this.node2way.put((Object)way.enode.get(i), (Object)idx);
            }
        }
        int innerPointCnt = 0;
        for (Long key : this.node2way.keySet()) {
            if (this.node2way.get((Object)key).size() >= 2) {
                this.node2Extract.add(key);
                continue;
            }
            ++innerPointCnt;
        }
        this.LOG.info("Inner Point Cnt = {}", (Object)innerPointCnt);
        HashMap<Long, Integer> newIdDict = new HashMap<Long, Integer>();
        PrintWriter nodeOutput = new PrintWriter(this.nodeFile);
        int idCnt = 0;
        for (Long id : this.node2Extract) {
            Node node = this.nodeMap.get(id);
            nodeOutput.printf("%d\t%.7f\t%.7f\n", idCnt, node.lat, node.lon);
            newIdDict.put(id, idCnt++);
        }
        this.LOG.info("Extract Node number = {}", (Object)idCnt);
        nodeOutput.close();
        PrintWriter edgeOutput = new PrintWriter(this.edgeFile);
        idCnt = 0;
        for (Way way : this.ways) {
            int sid = 0;
            for (int j = 1; j < way.enode.size(); ++j) {
                Node node;
                int k;
                Long idx = way.enode.get(j);
                if (!this.node2Extract.contains(idx)) continue;
                long start = way.enode.get(sid);
                long end = idx;
                int num = j - sid + 1;
                edgeOutput.printf("%d\t%d\t%d\t%d", idCnt++, newIdDict.get(start), newIdDict.get(end), num);
                for (k = sid; k <= j; ++k) {
                    node = this.nodeMap.get(way.enode.get(k));
                    edgeOutput.printf("\t%.7f\t%.7f", node.lat, node.lon);
                }
                edgeOutput.println();
                if (!way.isoneway) {
                    edgeOutput.printf("%d\t%d\t%d\t%d", idCnt++, newIdDict.get(end), newIdDict.get(start), num);
                    for (k = j; k >= sid; --k) {
                        node = this.nodeMap.get(way.enode.get(k));
                        edgeOutput.printf("\t%.7f\t%.7f", node.lat, node.lon);
                    }
                    edgeOutput.println();
                }
                sid = j;
            }
        }
        edgeOutput.close();
        this.LOG.info("Extract Edge number = {} (consider oneway)", (Object)idCnt);
    }

    void work() throws Exception {
        Stopwatch stopwatch = new Stopwatch();
        this.parseFromXML();
        this.LOG.info("ParseFromXML time elapsed {} sec", (Object)stopwatch.elapsedTime());
        this.LOG.info("The raw node number = {}", (Object)this.nodeMap.size());
        this.LOG.info("The raw way number = {} (not consider oneway..)", (Object)this.ways.size());
        stopwatch = new Stopwatch();
        this.spliceAndExtract();
        this.LOG.info("SpliceAndExtract time elapsed {} sec", (Object)stopwatch.elapsedTime());
    }

    private void parseWay(StartElement startElement, XMLEventReader r) throws Exception {
        XMLEvent e;
        int id = Integer.parseInt(startElement.getAttributeByName(new QName("id")).getValue());
        boolean isHighWay = false;
        boolean isOneWay = false;
        ArrayList<Long> figure = new ArrayList<Long>();
        while (!(!r.hasNext() || (e = r.nextEvent()).isEndElement() && e.asEndElement().getName().getLocalPart().equals("way"))) {
            if (!e.isStartElement()) continue;
            StartElement se = e.asStartElement();
            if (se.getName().getLocalPart().equals("nd")) {
                Long nId = Long.parseLong(se.getAttributeByName(new QName("ref")).getValue());
                figure.add(nId);
            }
            if (!se.getName().getLocalPart().equals("tag")) continue;
            if (se.getAttributeByName(new QName("k")).getValue().equals("highway")) {
                isHighWay = true;
            }
            if (!se.getAttributeByName(new QName("k")).getValue().equals("oneway")) continue;
            isOneWay = true;
        }
        if (!isHighWay) {
            return;
        }
        Way way = new Way();
        way.enode = figure;
        way.isoneway = isOneWay;
        this.ways.add(way);
    }

    private void parseNode(StartElement startElement, XMLEventReader r) {
        Node node = new Node();
        Long id = Long.parseLong(startElement.getAttributeByName(new QName("id")).getValue());
        double lat = Double.parseDouble(startElement.getAttributeByName(new QName("lat")).getValue());
        double lon = Double.parseDouble(startElement.getAttributeByName(new QName("lon")).getValue());
        node.lat = lat;
        node.lon = lon;
        this.nodeMap.put(id, node);
    }

    public static void main(String[] args) throws Exception {
        new OSMProcess().work();
    }

    class Way {
        public List<Long> enode = new ArrayList<Long>();
        public boolean isoneway;

        Way() {
        }
    }

    class Node {
        double lon;
        double lat;

        Node() {
        }
    }
}

