package com.whimsy.map.algo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import com.google.common.collect.Lists;
import com.whimsy.map.api.Edge;
import com.whimsy.map.api.GeoPoint;
import com.whimsy.map.api.Graph;
import com.whimsy.map.base.Constant;
import com.whimsy.map.base.ValueBox;

import static com.whimsy.map.base.Constant.*;
import static com.whimsy.map.base.Utils.*;

/**
 * Created by whimsy on 5/27/15.
 */
public class MapMatching {

    Graph graph;


    AStar aStar;
    GridIndex gridIndex;

    public MapMatching(Graph graph) {
        this(graph, Constant.DEFAULT_GRID_PARITITON);
    }
    public MapMatching(Graph roadNetwork, int gridPartition) {
        graph = roadNetwork;
        aStar = new CachedAstar(roadNetwork);
        gridIndex = new GridIndex(graph, gridPartition);
    }



    static class Score {
        Edge edge;
        double score;
        int preColumnIndex;
        double distLeft;

        public Score(Edge edge, double score, int preColumnIndex, double disLeft) {
            this.edge = edge;
            this.score = score;
            this.preColumnIndex = preColumnIndex;
            this.distLeft = disLeft;
        }

        @Override
        public String toString() {
            return String.format("%d %.2f %d %.2f", edge.id, score, preColumnIndex, distLeft);
        }
    }


    public List<Edge> nearestMatching(List<GeoPoint> trajectory) {

        List<Edge> resEdges = Lists.newArrayList();

        for (GeoPoint trajPoint : trajectory) {
            List<Edge> edges = gridIndex.getNearEdges(trajPoint.lat, trajPoint.lon, 1);

            assert edges.size() == 1;

            resEdges.add(edges.get(0));

        }

        return resEdges;
    }


    public double MAXSPEED = 50;

    //地图匹配所用参数
    // Not Used
    public static final double COEFFICIENT_FOR_EMISSIONPROB = 140.2384599822997282786640971977 ; //原始值为0.01402384599822997282786640971977，现扩大10000倍
    public static final double COEFFICIENT_FOR_TRANSITIONPROB = 0.31273997011; //原始值为0.00931003342301998864175922391561，现扩大10000倍


    public List<Edge> hmmMatching(List<GeoPoint> trajectory, int k) {



        ArrayList<ArrayList<Score>> scoreMatrix = Lists.newArrayList();

        GeoPoint formerTrajPoint = null;
        boolean cutFlag = true;
        int currentTrajPointIndex = 0;

        int cnt = 0;

        for (GeoPoint point : trajectory) {
            double deltaT = 1;
            if (formerTrajPoint != null) {
                deltaT = point.time - formerTrajPoint.time;
            }

            double currentMaxProb = INF;

            ArrayList<Score> scores = new ArrayList<Score>();


            List<Edge> candidateEdges = gridIndex.getNearEdges(point.lat, point.lon, k);


            double [] emmissionProbs = new double[candidateEdges.size()];

            int currentCandidateEdgeIndex = 0;

            for (Edge candidateEdge : candidateEdges) {
                int preColumnIndex = -1;
                double currentDistLeft = 0;

                ValueBox<Double> distBetweenTrajPointAndEdge = new ValueBox<Double>();
                ValueBox<Double> distLeft = new ValueBox<Double>();

                project(point, candidateEdge,
                                       distBetweenTrajPointAndEdge, distLeft);

                emmissionProbs[currentCandidateEdgeIndex] = deltaT * Math.sqrt(distBetweenTrajPointAndEdge.value);


                if (!cutFlag) {
                    double currentMaxProbTmp = INF;

                    int formerCandidateEdgeIndex = 0;

                    for (Score formerCandidateEdge : scoreMatrix.get(scoreMatrix.size() - 1)) {

                        double formerDistLeft = formerCandidateEdge.distLeft;
                        double formerDistToEnd = formerCandidateEdge.edge.lenM() - formerDistLeft;


                        double routeNetworkDistBetweenTwoEdges = 0;
                        double routeNetworkDistBetweenTwoTrajPoints;

                        if (candidateEdge == formerCandidateEdge.edge) {
                            routeNetworkDistBetweenTwoTrajPoints = Math.abs(currentDistLeft
                                                                                - formerCandidateEdge.distLeft);
                        } else {


                            Double res = aStar.query(formerCandidateEdge.edge.eId, candidateEdge.sId) * GEO_SCALE;

                            if (res <= MAXSPEED * deltaT) {
                                routeNetworkDistBetweenTwoEdges = res;
                            } else {
                                routeNetworkDistBetweenTwoEdges = res * 100;
                            }

                            routeNetworkDistBetweenTwoTrajPoints = routeNetworkDistBetweenTwoEdges + currentDistLeft + formerDistToEnd;

                        }


                        double transitionProb = routeNetworkDistBetweenTwoTrajPoints * COEFFICIENT_FOR_TRANSITIONPROB;

                        double tmpTotalProbForTrasition = formerCandidateEdge.score + transitionProb;

                        if (currentMaxProbTmp > tmpTotalProbForTrasition) {
                            currentMaxProbTmp = tmpTotalProbForTrasition;
                            preColumnIndex = formerCandidateEdgeIndex;
                        }

                        formerCandidateEdgeIndex++;

                    }

                    emmissionProbs[currentCandidateEdgeIndex] += currentMaxProbTmp;
                }

                scores.add(new Score(candidateEdge, emmissionProbs[currentCandidateEdgeIndex], preColumnIndex, currentDistLeft));


                if (currentMaxProb > emmissionProbs[currentCandidateEdgeIndex]) {
                    currentMaxProb = emmissionProbs[currentCandidateEdgeIndex];
                }

                currentCandidateEdgeIndex++;

            }

            formerTrajPoint = point;

            currentTrajPointIndex++;

            scoreMatrix.add(scores);

            if (scores.size() == 0) {
                cutFlag = true;
                formerTrajPoint = null;
            } else {
                cutFlag = false;
            }


            ++cnt;
        }

        for (int i = 0; i < scoreMatrix.size(); ++i) {
            for (int j = 0; j < scoreMatrix.get(i).size(); ++j) {
                System.out.printf("%d  %d %s\n", i, j,   scoreMatrix.get(i).get(j));
            }
        }


        int startColumnIndex = getStartColumnIndex(scoreMatrix.get(scoreMatrix.size() - 1));


        List<Edge> resEdges = Lists.newArrayList();

        for (int i = scoreMatrix.size() - 1; i>=0; --i) {
            if (startColumnIndex != -1) {
                resEdges.add(scoreMatrix.get(i).get(startColumnIndex).edge);
                startColumnIndex = scoreMatrix.get(i).get(startColumnIndex).preColumnIndex;
            } else {
                resEdges.add(null);

                if (i > 0) {
                    startColumnIndex = getStartColumnIndex(scoreMatrix.get(i - 1));
                }
            }
        }

        Collections.reverse(resEdges);

        return resEdges;
    }


    private int getStartColumnIndex(List<Score> scores) {
        int resultIndex = -1;
        double currentMaxProb = INF;

        int idx = 0;
        for (Score score : scores) {
            if (currentMaxProb > score.score) {
                currentMaxProb = score.score;
                resultIndex = idx;

            }

            ++idx;
        }

        return resultIndex;
    }



}
