package com.whimsy.map.entry;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Scanner;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.collect.Lists;

import com.whimsy.map.api.Edge;
import com.whimsy.map.api.GeoPoint;
import com.whimsy.map.api.Graph;
import com.whimsy.map.algo.MapMatching;
import edu.princeton.cs.algs4.Stopwatch;

/**
 * Created by whimsy on 5/29/15.
 */
public class MainEntry {

    static final Logger LOG = LoggerFactory.getLogger(MainEntry.class);

    public static int K = 20;


    Graph graph = new Graph();

    public MainEntry() {

        graph.loadNode(this.getClass().getClassLoader().getResourceAsStream("nodeOSM.txt"));
        graph.loadEdge(this.getClass().getClassLoader().getResourceAsStream("edgeOSM.txt"));


    }

    void NearestEdgeMatch() {


        MapMatching mapMatching = new MapMatching(graph);

        List<GeoPoint> trajectory = loadTrajectory();

        LOG.info("Going to start naive MapMatching");
        Stopwatch stopwatch = new Stopwatch();

        List<Edge> edges = mapMatching.nearestMatching(trajectory);

        LOG.info("Matching time comsumes {} sec", stopwatch.elapsedTime());

        printEdges(edges, "naiveMatch.txt");

    }

    void HmmMatch() {
        MapMatching mapMatching = new MapMatching(graph);


        List<GeoPoint> trajectory = loadTrajectory();

        LOG.info("Going to start Hmm MapMatching");

        Stopwatch stopwatch = new Stopwatch();

        List<Edge> edges = mapMatching.hmmMatching(trajectory, 20);
        LOG.info("Matching time consumes {} sec", stopwatch.elapsedTime());

        printEdges(edges, "hmmMatch.txt");

    }

    private void printEdges(List<Edge> edges, String rawFilename) {

        String filename = this.getClass().getClassLoader().getResource("").getPath() + "/" + rawFilename;

        LOG.info("Generate Matching Edge File : {}", filename);

        try {
            PrintWriter out = new PrintWriter(filename);

            int cnt = 0;
            for (Edge edge : edges) {
                if (edge != null) {
                    out.println(edge.id);
                } else {
                    LOG.info("Not found Matching Edge in traj {}", cnt);
                }
                ++cnt;
            }
            out.close();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private List<GeoPoint> loadTrajectory() {

        Scanner in = new Scanner(this.getClass().getClassLoader().getResourceAsStream("20081023025304.plt.path"));

        List<GeoPoint> res = Lists.newArrayList();

        while (in.hasNext()) {
            res.add(new GeoPoint(in.nextDouble(), in.nextDouble(), in.nextDouble()));
        }

        return res;

    }

    public static void main(String [] args) {

        MainEntry mainEntry = new MainEntry();
//        mainEntry.NearestEdgeMatch();

        mainEntry.HmmMatch();
    }
}
