goog.provide('clojure.data');
goog.require('cljs.core');
goog.require('clojure.set');
/**
 * Internal helper for diff.
 */
clojure.data.atom_diff = (function clojure$data$atom_diff(a,b){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a,b)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,a], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,null], null);
}
});
/**
 * Convert an associative-by-numeric-index collection into
 * an equivalent vector, with nil for any missing keys
 */
clojure.data.vectorize = (function clojure$data$vectorize(m){
if(cljs.core.seq(m)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,p__38539){
var vec__38540 = p__38539;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38540,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38540,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,k,v);
}),cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.keys(m)),null)),m);
} else {
return null;
}
});
/**
 * Diff associative things a and b, comparing only the key k.
 */
clojure.data.diff_associative_key = (function clojure$data$diff_associative_key(a,b,k){
var va = cljs.core.get.cljs$core$IFn$_invoke$arity$2(a,k);
var vb = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b,k);
var vec__38549 = clojure.data.diff(va,vb);
var a_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38549,(0),null);
var b_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38549,(1),null);
var ab = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38549,(2),null);
var in_a = cljs.core.contains_QMARK_(a,k);
var in_b = cljs.core.contains_QMARK_(b,k);
var same = ((in_a) && (in_b) && (((!((ab == null))) || ((((va == null)) && ((vb == null)))))));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [((((in_a) && (((!((a_STAR_ == null))) || (!(same))))))?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,a_STAR_]):null),((((in_b) && (((!((b_STAR_ == null))) || (!(same))))))?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,b_STAR_]):null),((same)?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,ab]):null)], null);
});
/**
 * Diff associative things a and b, comparing only keys in ks (if supplied).
 */
clojure.data.diff_associative = (function clojure$data$diff_associative(var_args){
var G__38563 = arguments.length;
switch (G__38563) {
case 2:
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3(a,b,clojure.set.union.cljs$core$IFn$_invoke$arity$2(cljs.core.keys(a),cljs.core.keys(b)));
});

clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3 = (function (a,b,ks){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (diff1,diff2){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.merge,diff1,diff2));
}),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,null], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(clojure.data.diff_associative_key,a,b),ks));
});

clojure.data.diff_associative.cljs$lang$maxFixedArity = 3;

clojure.data.diff_sequential = (function clojure$data$diff_sequential(a,b){
return cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.data.vectorize,clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3(((cljs.core.vector_QMARK_(a))?a:cljs.core.vec(a)),((cljs.core.vector_QMARK_(b))?b:cljs.core.vec(b)),cljs.core.range.cljs$core$IFn$_invoke$arity$1((function (){var x__4037__auto__ = cljs.core.count(a);
var y__4038__auto__ = cljs.core.count(b);
return ((x__4037__auto__ > y__4038__auto__) ? x__4037__auto__ : y__4038__auto__);
})()))));
});
clojure.data.diff_set = (function clojure$data$diff_set(a,b){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.not_empty(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(a,b)),cljs.core.not_empty(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(b,a)),cljs.core.not_empty(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(a,b))], null);
});

/**
 * Implementation detail. Subject to change.
 * @interface
 */
clojure.data.EqualityPartition = function(){};

/**
 * Implementation detail. Subject to change.
 */
clojure.data.equality_partition = (function clojure$data$equality_partition(x){
if(((!((x == null))) && (!((x.clojure$data$EqualityPartition$equality_partition$arity$1 == null))))){
return x.clojure$data$EqualityPartition$equality_partition$arity$1(x);
} else {
var x__4243__auto__ = (((x == null))?null:x);
var m__4244__auto__ = (clojure.data.equality_partition[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4244__auto__.call(null,x));
} else {
var m__4244__auto____$1 = (clojure.data.equality_partition["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__4244__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("EqualityPartition.equality-partition",x);
}
}
}
});


/**
 * Implementation detail. Subject to change.
 * @interface
 */
clojure.data.Diff = function(){};

/**
 * Implementation detail. Subject to change.
 */
clojure.data.diff_similar = (function clojure$data$diff_similar(a,b){
if(((!((a == null))) && (!((a.clojure$data$Diff$diff_similar$arity$2 == null))))){
return a.clojure$data$Diff$diff_similar$arity$2(a,b);
} else {
var x__4243__auto__ = (((a == null))?null:a);
var m__4244__auto__ = (clojure.data.diff_similar[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(a,b) : m__4244__auto__.call(null,a,b));
} else {
var m__4244__auto____$1 = (clojure.data.diff_similar["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(a,b) : m__4244__auto____$1.call(null,a,b));
} else {
throw cljs.core.missing_protocol("Diff.diff-similar",a);
}
}
}
});

goog.object.set(clojure.data.EqualityPartition,"null",true);

var G__38582_38651 = clojure.data.equality_partition;
var G__38583_38652 = "null";
var G__38584_38653 = ((function (G__38582_38651,G__38583_38652){
return (function (x){
return new cljs.core.Keyword(null,"atom","atom",-397043653);
});})(G__38582_38651,G__38583_38652))
;
goog.object.set(G__38582_38651,G__38583_38652,G__38584_38653);

goog.object.set(clojure.data.EqualityPartition,"string",true);

var G__38585_38655 = clojure.data.equality_partition;
var G__38586_38656 = "string";
var G__38587_38657 = ((function (G__38585_38655,G__38586_38656){
return (function (x){
return new cljs.core.Keyword(null,"atom","atom",-397043653);
});})(G__38585_38655,G__38586_38656))
;
goog.object.set(G__38585_38655,G__38586_38656,G__38587_38657);

goog.object.set(clojure.data.EqualityPartition,"number",true);

var G__38590_38659 = clojure.data.equality_partition;
var G__38591_38660 = "number";
var G__38592_38661 = ((function (G__38590_38659,G__38591_38660){
return (function (x){
return new cljs.core.Keyword(null,"atom","atom",-397043653);
});})(G__38590_38659,G__38591_38660))
;
goog.object.set(G__38590_38659,G__38591_38660,G__38592_38661);

goog.object.set(clojure.data.EqualityPartition,"array",true);

var G__38593_38663 = clojure.data.equality_partition;
var G__38594_38664 = "array";
var G__38595_38665 = ((function (G__38593_38663,G__38594_38664){
return (function (x){
return new cljs.core.Keyword(null,"sequential","sequential",-1082983960);
});})(G__38593_38663,G__38594_38664))
;
goog.object.set(G__38593_38663,G__38594_38664,G__38595_38665);

goog.object.set(clojure.data.EqualityPartition,"function",true);

var G__38600_38669 = clojure.data.equality_partition;
var G__38601_38670 = "function";
var G__38602_38671 = ((function (G__38600_38669,G__38601_38670){
return (function (x){
return new cljs.core.Keyword(null,"atom","atom",-397043653);
});})(G__38600_38669,G__38601_38670))
;
goog.object.set(G__38600_38669,G__38601_38670,G__38602_38671);

goog.object.set(clojure.data.EqualityPartition,"boolean",true);

var G__38609_38672 = clojure.data.equality_partition;
var G__38610_38673 = "boolean";
var G__38611_38674 = ((function (G__38609_38672,G__38610_38673){
return (function (x){
return new cljs.core.Keyword(null,"atom","atom",-397043653);
});})(G__38609_38672,G__38610_38673))
;
goog.object.set(G__38609_38672,G__38610_38673,G__38611_38674);

goog.object.set(clojure.data.EqualityPartition,"_",true);

var G__38622_38675 = clojure.data.equality_partition;
var G__38623_38676 = "_";
var G__38624_38677 = ((function (G__38622_38675,G__38623_38676){
return (function (x){
if(((!((x == null)))?(((((x.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x))){
return new cljs.core.Keyword(null,"map","map",1371690461);
} else {
if(((!((x == null)))?(((((x.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x))){
return new cljs.core.Keyword(null,"set","set",304602554);
} else {
if(((!((x == null)))?(((((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x))){
return new cljs.core.Keyword(null,"sequential","sequential",-1082983960);
} else {
return new cljs.core.Keyword(null,"atom","atom",-397043653);

}
}
}
});})(G__38622_38675,G__38623_38676))
;
goog.object.set(G__38622_38675,G__38623_38676,G__38624_38677);
goog.object.set(clojure.data.Diff,"null",true);

var G__38682_38718 = clojure.data.diff_similar;
var G__38683_38719 = "null";
var G__38684_38720 = ((function (G__38682_38718,G__38683_38719){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__38682_38718,G__38683_38719))
;
goog.object.set(G__38682_38718,G__38683_38719,G__38684_38720);

goog.object.set(clojure.data.Diff,"string",true);

var G__38685_38721 = clojure.data.diff_similar;
var G__38686_38722 = "string";
var G__38687_38723 = ((function (G__38685_38721,G__38686_38722){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__38685_38721,G__38686_38722))
;
goog.object.set(G__38685_38721,G__38686_38722,G__38687_38723);

goog.object.set(clojure.data.Diff,"number",true);

var G__38689_38724 = clojure.data.diff_similar;
var G__38690_38725 = "number";
var G__38691_38726 = ((function (G__38689_38724,G__38690_38725){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__38689_38724,G__38690_38725))
;
goog.object.set(G__38689_38724,G__38690_38725,G__38691_38726);

goog.object.set(clojure.data.Diff,"array",true);

var G__38693_38729 = clojure.data.diff_similar;
var G__38694_38730 = "array";
var G__38695_38731 = ((function (G__38693_38729,G__38694_38730){
return (function (a,b){
return clojure.data.diff_sequential(a,b);
});})(G__38693_38729,G__38694_38730))
;
goog.object.set(G__38693_38729,G__38694_38730,G__38695_38731);

goog.object.set(clojure.data.Diff,"function",true);

var G__38697_38733 = clojure.data.diff_similar;
var G__38698_38734 = "function";
var G__38699_38735 = ((function (G__38697_38733,G__38698_38734){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__38697_38733,G__38698_38734))
;
goog.object.set(G__38697_38733,G__38698_38734,G__38699_38735);

goog.object.set(clojure.data.Diff,"boolean",true);

var G__38703_38737 = clojure.data.diff_similar;
var G__38704_38738 = "boolean";
var G__38705_38739 = ((function (G__38703_38737,G__38704_38738){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__38703_38737,G__38704_38738))
;
goog.object.set(G__38703_38737,G__38704_38738,G__38705_38739);

goog.object.set(clojure.data.Diff,"_",true);

var G__38708_38740 = clojure.data.diff_similar;
var G__38709_38741 = "_";
var G__38710_38742 = ((function (G__38708_38740,G__38709_38741){
return (function (a,b){
var fexpr__38715 = (function (){var G__38716 = clojure.data.equality_partition(a);
var G__38716__$1 = (((G__38716 instanceof cljs.core.Keyword))?G__38716.fqn:null);
switch (G__38716__$1) {
case "atom":
return clojure.data.atom_diff;

break;
case "set":
return clojure.data.diff_set;

break;
case "sequential":
return clojure.data.diff_sequential;

break;
case "map":
return clojure.data.diff_associative;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__38716__$1)].join('')));

}
})();
return (fexpr__38715.cljs$core$IFn$_invoke$arity$2 ? fexpr__38715.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__38715.call(null,a,b));
});})(G__38708_38740,G__38709_38741))
;
goog.object.set(G__38708_38740,G__38709_38741,G__38710_38742);
/**
 * Recursively compares a and b, returning a tuple of
 *   [things-only-in-a things-only-in-b things-in-both].
 *   Comparison rules:
 * 
 *   * For equal a and b, return [nil nil a].
 *   * Maps are subdiffed where keys match and values differ.
 *   * Sets are never subdiffed.
 *   * All sequential things are treated as associative collections
 *  by their indexes, with results returned as vectors.
 *   * Everything else (including strings!) is treated as
 *  an atom and compared for equality.
 */
clojure.data.diff = (function clojure$data$diff(a,b){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a,b)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,a], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(clojure.data.equality_partition(a),clojure.data.equality_partition(b))){
return clojure.data.diff_similar(a,b);
} else {
return clojure.data.atom_diff(a,b);
}
}
});

//# sourceMappingURL=clojure.data.js.map
