goog.provide('duff.core');
goog.require('cljs.core');
var module$node_modules$prop_types$index=shadow.js.require("module$node_modules$prop_types$index", {});
goog.require('clojure.string');
goog.require('goog.object');
goog.require('rf_utils.core');
goog.require('re_frame.core');
goog.require('reagent.core');
duff.core.noop = cljs.core.constantly(null);
duff.core.clean = (function duff$core$clean(data){

return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(data,new cljs.core.Keyword(null,"errors","errors",-908790718),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"pristine?","pristine?",-718436279),new cljs.core.Keyword(null,"value?","value?",-1107852432),new cljs.core.Keyword(null,"dirty?","dirty?",-2059845846),new cljs.core.Keyword(null,"initial-value","initial-value",470619381),new cljs.core.Keyword(null,"submitted?","submitted?",-1363786466),new cljs.core.Keyword(null,"field-name","field-name",1300687948),new cljs.core.Keyword(null,"errors?","errors?",-1324290149)], 0));
});
duff.core.make_toast_id = (function duff$core$make_toast_id(){
return (new Date()).getTime();
});
duff.core.query = (function duff$core$query(form_name,query_key){
var form_state = duff.core.clean(rf_utils.core.get_in.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"forms","forms",2045992350),form_name], null)));
var get_STAR_ = ((function (form_state){
return (function() { 
var G__32601__delegate = function (path){
return rf_utils.core.get_in.cljs$core$IFn$_invoke$arity$1(cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"forms","forms",2045992350),form_name], null),path));
};
var G__32601 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__32602__i = 0, G__32602__a = new Array(arguments.length -  0);
while (G__32602__i < G__32602__a.length) {G__32602__a[G__32602__i] = arguments[G__32602__i + 0]; ++G__32602__i;}
  path = new cljs.core.IndexedSeq(G__32602__a,0,null);
} 
return G__32601__delegate.call(this,path);};
G__32601.cljs$lang$maxFixedArity = 0;
G__32601.cljs$lang$applyTo = (function (arglist__32603){
var path = cljs.core.seq(arglist__32603);
return G__32601__delegate(path);
});
G__32601.cljs$core$IFn$_invoke$arity$variadic = G__32601__delegate;
return G__32601;
})()
;})(form_state))
;
var G__32592 = query_key;
var G__32592__$1 = (((G__32592 instanceof cljs.core.Keyword))?G__32592.fqn:null);
switch (G__32592__$1) {
case "pristine?":
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form_state,get_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"initial-value","initial-value",470619381)], 0)));

break;
case "errors":
return get_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"errors","errors",-908790718)], 0));

break;
case "dirty?":
return cljs.core.not((function (){var G__32593 = form_name;
var G__32594 = new cljs.core.Keyword(null,"pristine?","pristine?",-718436279);
return (duff.core.query.cljs$core$IFn$_invoke$arity$2 ? duff.core.query.cljs$core$IFn$_invoke$arity$2(G__32593,G__32594) : duff.core.query.call(null,G__32593,G__32594));
})());

break;
case "value":
return form_state;

break;
case "valid?":
return cljs.core.empty_QMARK_(get_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"errors","errors",-908790718)], 0)));

break;
case "invalid":
return !(cljs.core.empty_QMARK_(get_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"errors","errors",-908790718)], 0))));

break;
case "submitted?":
return get_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"submitted?","submitted?",-1363786466)], 0));

break;
case "should-confirm?":
var and__3938__auto__ = (function (){var G__32597 = form_name;
var G__32598 = new cljs.core.Keyword(null,"dirty?","dirty?",-2059845846);
return (duff.core.query.cljs$core$IFn$_invoke$arity$2 ? duff.core.query.cljs$core$IFn$_invoke$arity$2(G__32597,G__32598) : duff.core.query.call(null,G__32597,G__32598));
})();
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.not((function (){var G__32599 = form_name;
var G__32600 = new cljs.core.Keyword(null,"submitted?","submitted?",-1363786466);
return (duff.core.query.cljs$core$IFn$_invoke$arity$2 ? duff.core.query.cljs$core$IFn$_invoke$arity$2(G__32599,G__32600) : duff.core.query.call(null,G__32599,G__32600));
})());
} else {
return and__3938__auto__;
}

break;
default:
return null;

}
});
/**
 * fired once when create-form mounts
 */
duff.core.initialize_state = (function duff$core$initialize_state(p__32605){
var map__32606 = p__32605;
var map__32606__$1 = ((((!((map__32606 == null)))?(((((map__32606.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32606.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32606):map__32606);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32606__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32606__$1,new cljs.core.Keyword(null,"value","value",305978217));
var validate = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32606__$1,new cljs.core.Keyword(null,"validate","validate",-201300827));
var initial_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32606__$1,new cljs.core.Keyword(null,"initial-value","initial-value",470619381));
if(cljs.core.truth_(rf_utils.core.get.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"active-forms","active-forms",-1942150964)))){
rf_utils.core.update_sync.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"active-forms","active-forms",-1942150964),cljs.core.conj,name], 0));
} else {
rf_utils.core.assoc_sync.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"active-forms","active-forms",-1942150964),cljs.core.PersistentHashSet.createAsIfByAssoc([name])], 0));
}

return rf_utils.core.assoc_in_sync.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"forms","forms",2045992350),name], null),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([value,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"errors","errors",-908790718),(validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(value) : validate.call(null,value)),new cljs.core.Keyword(null,"initial-value","initial-value",470619381),(function (){var or__3949__auto__ = initial_value;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})()], null)], 0))], 0));
});
var G__32608_32614 = new cljs.core.Keyword("forms","active-form?","forms/active-form?",611076086);
var G__32609_32615 = ((function (G__32608_32614){
return (function (db,p__32610){
var vec__32611 = p__32610;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32611,(0),null);
var form_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32611,(1),null);
var temp__5457__auto__ = new cljs.core.Keyword(null,"active-forms","active-forms",-1942150964).cljs$core$IFn$_invoke$arity$1(db);
if(cljs.core.truth_(temp__5457__auto__)){
var forms = temp__5457__auto__;
return (forms.cljs$core$IFn$_invoke$arity$1 ? forms.cljs$core$IFn$_invoke$arity$1(form_name) : forms.call(null,form_name));
} else {
return null;
}
});})(G__32608_32614))
;
(re_frame.core.reg_sub.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.reg_sub.cljs$core$IFn$_invoke$arity$2(G__32608_32614,G__32609_32615) : re_frame.core.reg_sub.call(null,G__32608_32614,G__32609_32615));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("duff.core","on-change","duff.core/on-change",-1921536097),(function (p__32616,p__32617){
var map__32618 = p__32616;
var map__32618__$1 = ((((!((map__32618 == null)))?(((((map__32618.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32618.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32618):map__32618);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32618__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__32619 = p__32617;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32619,(0),null);
var map__32622 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32619,(1),null);
var map__32622__$1 = ((((!((map__32622 == null)))?(((((map__32622.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32622.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32622):map__32622);
var event_args = map__32622__$1;
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32622__$1,new cljs.core.Keyword(null,"value","value",305978217));
var form_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32622__$1,new cljs.core.Keyword(null,"form-name","form-name",586014988));
var field_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32622__$1,new cljs.core.Keyword(null,"field-name","field-name",1300687948));
var validate_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32622__$1,new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944));
var new_db = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"forms","forms",2045992350),form_name], null),((function (map__32618,map__32618__$1,db,vec__32619,_,map__32622,map__32622__$1,event_args,value,form_name,field_name,validate_fn){
return (function (form_state){
var new_form_state = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(form_state,field_name,value);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_form_state,new cljs.core.Keyword(null,"errors","errors",-908790718),(validate_fn.cljs$core$IFn$_invoke$arity$1 ? validate_fn.cljs$core$IFn$_invoke$arity$1(new_form_state) : validate_fn.call(null,new_form_state)));
});})(map__32618,map__32618__$1,db,vec__32619,_,map__32622,map__32622__$1,event_args,value,form_name,field_name,validate_fn))
);
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"db","db",993250759),new_db], null);
}));
duff.core.merge_props = (function duff$core$merge_props(form_props,rest){

return reagent.core.merge_props(duff.core.clean(form_props),rest);
});
duff.core.make_synthetic_event = (function duff$core$make_synthetic_event(value){

return ({"target": ({"value": value})});
});
duff.core.context_shape = ({"form-name": module$node_modules$prop_types$index.object.isRequired, "get-initial-value": module$node_modules$prop_types$index.func.isRequired, "validate": module$node_modules$prop_types$index.func.isRequired});
duff.core.make_validation = (function duff$core$make_validation(spec){

return (function (vals){
var result = cljs.core.reduce_kv((function (acc,field_key,fns_STAR_){
var fns = rf_utils.core.collify(fns_STAR_);
var field_val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vals,field_key);
var errors = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (fns,field_val){
return (function (validation){
if(cljs.core.map_QMARK_(validation)){
var map__32625 = validation;
var map__32625__$1 = ((((!((map__32625 == null)))?(((((map__32625.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32625.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32625):map__32625);
var pred = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32625__$1,new cljs.core.Keyword(null,"pred","pred",1927423397));
var text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32625__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(field_val) : pred.call(null,field_val)))){
return text;
} else {
return null;
}
} else {
return (validation.cljs$core$IFn$_invoke$arity$1 ? validation.cljs$core$IFn$_invoke$arity$1(field_val) : validation.call(null,field_val));
}
});})(fns,field_val))
,fns);
if(cljs.core.every_QMARK_(cljs.core.nil_QMARK_,errors)){
return acc;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,field_key,errors);
}
}),cljs.core.PersistentArrayMap.EMPTY,spec);
if(!(cljs.core.empty_QMARK_(result))){
return result;
} else {
return null;
}
});
});
duff.core.get_field_props = (function duff$core$get_field_props(ctx,field_name){
var form_name = goog.object.get(ctx,"form-name");
var get_initial_value = goog.object.get(ctx,"get-initial-value");
var validate_fn = goog.object.get(ctx,"validate");
var getter_fn = ((function (form_name,get_initial_value,validate_fn){
return (function (p1__32627_SHARP_){
return goog.object.getValueByKeys(p1__32627_SHARP_,"target","value");
});})(form_name,get_initial_value,validate_fn))
;
var path_in_state = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"forms","forms",2045992350),form_name,field_name], null);
var form_value = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"forms","forms",2045992350),form_name], null);
var initial_field_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2((get_initial_value.cljs$core$IFn$_invoke$arity$0 ? get_initial_value.cljs$core$IFn$_invoke$arity$0() : get_initial_value.call(null)),field_name);
var field_value = rf_utils.core.get_in.cljs$core$IFn$_invoke$arity$1(path_in_state);
var errors = rf_utils.core.get_in.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"forms","forms",2045992350),form_name,new cljs.core.Keyword(null,"errors","errors",-908790718),field_name], null));
var pristine_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(field_value,initial_field_value);
var dirty_QMARK_ = !(pristine_QMARK_);
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"initial-value","initial-value",470619381),initial_field_value,new cljs.core.Keyword(null,"value","value",305978217),field_value,new cljs.core.Keyword(null,"errors","errors",-908790718),errors,new cljs.core.Keyword(null,"pristine?","pristine?",-718436279),pristine_QMARK_,new cljs.core.Keyword(null,"on-change","on-change",-732046149),((function (form_name,get_initial_value,validate_fn,getter_fn,path_in_state,form_value,initial_field_value,field_value,errors,pristine_QMARK_,dirty_QMARK_){
return (function (p1__32628_SHARP_){
var G__32629 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("duff.core","on-change","duff.core/on-change",-1921536097),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"value","value",305978217),getter_fn(p1__32628_SHARP_),new cljs.core.Keyword(null,"form-name","form-name",586014988),form_name,new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),validate_fn,new cljs.core.Keyword(null,"field-name","field-name",1300687948),field_name], null)], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__32629) : re_frame.core.dispatch.call(null,G__32629));
});})(form_name,get_initial_value,validate_fn,getter_fn,path_in_state,form_value,initial_field_value,field_value,errors,pristine_QMARK_,dirty_QMARK_))
,new cljs.core.Keyword(null,"dirty?","dirty?",-2059845846),dirty_QMARK_], null);
});
duff.core.connect_to_fields = (function duff$core$connect_to_fields(var_args){
var G__32631 = arguments.length;
switch (G__32631) {
case 2:
return duff.core.connect_to_fields.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return duff.core.connect_to_fields.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

duff.core.connect_to_fields.cljs$core$IFn$_invoke$arity$2 = (function (fields,component){
return duff.core.connect_to_fields.cljs$core$IFn$_invoke$arity$3(fields,component,null);
});

duff.core.connect_to_fields.cljs$core$IFn$_invoke$arity$3 = (function (fields,component,opts){
return (function (props){
return reagent.core.create_class(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display-name","display-name",694513143),["Connect-to-fields: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2(", ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.name,fields)))].join(''),new cljs.core.Keyword(null,"context-types","context-types",1252270646),duff.core.context_shape,new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),(function (props__$1){
var this$ = reagent.core.current_component();
var ctx = goog.object.get(this$,"context");
var fields_props = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (this$,ctx){
return (function (acc,field_name){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,field_name,duff.core.get_field_props(ctx,field_name));
});})(this$,ctx))
,cljs.core.PersistentArrayMap.EMPTY,fields);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [component,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([props__$1,fields_props,opts], 0))], null);
})], null));
});
});

duff.core.connect_to_fields.cljs$lang$maxFixedArity = 3;

duff.core.field = (function duff$core$field(p__32635){
var map__32636 = p__32635;
var map__32636__$1 = ((((!((map__32636 == null)))?(((((map__32636.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32636.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32636):map__32636);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32636__$1,new cljs.core.Keyword(null,"name","name",1843675177));

return reagent.core.create_class(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display-name","display-name",694513143),["Field: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''),new cljs.core.Keyword(null,"context-types","context-types",1252270646),duff.core.context_shape,new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),((function (map__32636,map__32636__$1,name){
return (function (p__32638){
var map__32639 = p__32638;
var map__32639__$1 = ((((!((map__32639 == null)))?(((((map__32639.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32639.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32639):map__32639);
var props = map__32639__$1;
var name__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32639__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32639__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32639__$1,new cljs.core.Keyword(null,"format","format",-1306924766),cljs.core.identity);
var parse = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32639__$1,new cljs.core.Keyword(null,"parse","parse",-1162164619),cljs.core.identity);
var getter = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32639__$1,new cljs.core.Keyword(null,"getter","getter",84844855),((function (map__32639,map__32639__$1,props,name__$1,component,format,parse,map__32636,map__32636__$1,name){
return (function (p1__32633_SHARP_){
return goog.object.getValueByKeys(p1__32633_SHARP_,"target","value");
});})(map__32639,map__32639__$1,props,name__$1,component,format,parse,map__32636,map__32636__$1,name))
);
var sync_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32639__$1,new cljs.core.Keyword(null,"sync?","sync?",630471618));
var this$ = reagent.core.current_component();
var ctx = goog.object.get(this$,"context");
var form_name = goog.object.get(ctx,"form-name");
var get_initial_value = goog.object.get(ctx,"get-initial-value");
var validate_fn = goog.object.get(ctx,"validate");
var path_in_state = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"forms","forms",2045992350),form_name,name__$1], null);
var initial_field_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2((get_initial_value.cljs$core$IFn$_invoke$arity$0 ? get_initial_value.cljs$core$IFn$_invoke$arity$0() : get_initial_value.call(null)),name__$1);
var field_value = rf_utils.core.get_in.cljs$core$IFn$_invoke$arity$1(path_in_state);
var dispatch_fn = ((sync_QMARK_ === false)?re_frame.core.dispatch:re_frame.core.dispatch_sync);
var on_change = ((function (this$,ctx,form_name,get_initial_value,validate_fn,path_in_state,initial_field_value,field_value,dispatch_fn,map__32639,map__32639__$1,props,name__$1,component,format,parse,getter,sync_QMARK_,map__32636,map__32636__$1,name){
return (function (p1__32634_SHARP_){
var G__32641 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("duff.core","on-change","duff.core/on-change",-1921536097),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"value","value",305978217),(function (){var G__32642 = (getter.cljs$core$IFn$_invoke$arity$1 ? getter.cljs$core$IFn$_invoke$arity$1(p1__32634_SHARP_) : getter.call(null,p1__32634_SHARP_));
return (parse.cljs$core$IFn$_invoke$arity$1 ? parse.cljs$core$IFn$_invoke$arity$1(G__32642) : parse.call(null,G__32642));
})(),new cljs.core.Keyword(null,"form-name","form-name",586014988),form_name,new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),validate_fn,new cljs.core.Keyword(null,"field-name","field-name",1300687948),name__$1], null)], null);
return (dispatch_fn.cljs$core$IFn$_invoke$arity$1 ? dispatch_fn.cljs$core$IFn$_invoke$arity$1(G__32641) : dispatch_fn.call(null,G__32641));
});})(this$,ctx,form_name,get_initial_value,validate_fn,path_in_state,initial_field_value,field_value,dispatch_fn,map__32639,map__32639__$1,props,name__$1,component,format,parse,getter,sync_QMARK_,map__32636,map__32636__$1,name))
;
var errors = rf_utils.core.get_in.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"forms","forms",2045992350),form_name,new cljs.core.Keyword(null,"errors","errors",-908790718),name__$1], null));
var pristine_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(field_value,initial_field_value);
var dirty_QMARK_ = !(pristine_QMARK_);
var value = (format.cljs$core$IFn$_invoke$arity$1 ? format.cljs$core$IFn$_invoke$arity$1(field_value) : format.call(null,field_value));
var children = reagent.core.children(reagent.core.current_component());
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [component,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"value?","value?",-1107852432),((cljs.core.seq_QMARK_(value))?!(cljs.core.empty_QMARK_(value)):!((value == null))),new cljs.core.Keyword(null,"pristine?","pristine?",-718436279),pristine_QMARK_,new cljs.core.Keyword(null,"dirty?","dirty?",-2059845846),dirty_QMARK_,new cljs.core.Keyword(null,"errors","errors",-908790718),errors,new cljs.core.Keyword(null,"field-name","field-name",1300687948),name__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149),on_change], null),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(props,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"format","format",-1306924766),new cljs.core.Keyword(null,"parse","parse",-1162164619),new cljs.core.Keyword(null,"getter","getter",84844855),new cljs.core.Keyword(null,"sync?","sync?",630471618)], 0))], 0))], null),children);
});})(map__32636,map__32636__$1,name))
], null));
});
duff.core.wrap_field = (function duff$core$wrap_field(path,component){
var opts = ((cljs.core.fn_QMARK_(component))?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"component","component",1555936782),component], null):component);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [duff.core.field,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),path], null),opts], 0))], null);
});
duff.core.make_fields_map = (function duff$core$make_fields_map(spec){
return cljs.core.reduce_kv((function (acc,k,v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,duff.core.wrap_field(k,v));
}),cljs.core.PersistentArrayMap.EMPTY,spec);
});
duff.core.create_form = (function duff$core$create_form(p__32643,component){
var map__32644 = p__32643;
var map__32644__$1 = ((((!((map__32644 == null)))?(((((map__32644.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32644.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32644):map__32644);
var initial_config = map__32644__$1;
var form_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32644__$1,new cljs.core.Keyword(null,"form-name","form-name",586014988));
var initial_value = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32644__$1,new cljs.core.Keyword(null,"initial-value","initial-value",470619381),duff.core.noop);
var validate = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32644__$1,new cljs.core.Keyword(null,"validate","validate",-201300827),duff.core.noop);
var persist_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32644__$1,new cljs.core.Keyword(null,"persist?","persist?",-1772568760));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32644__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));

return ((function (map__32644,map__32644__$1,initial_config,form_name,initial_value,validate,persist_QMARK_,fields){
return (function (){
var this$ = reagent.core.current_component();
var props = reagent.core.props(this$);
var get_initial_value = ((function (this$,props,map__32644,map__32644__$1,initial_config,form_name,initial_value,validate,persist_QMARK_,fields){
return (function (){
if(cljs.core.truth_(cljs.core.some(cljs.core.true_QMARK_,(function (){var fexpr__32646 = cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(cljs.core.fn_QMARK_,cljs.core.keyword_QMARK_);
return (fexpr__32646.cljs$core$IFn$_invoke$arity$1 ? fexpr__32646.cljs$core$IFn$_invoke$arity$1(initial_value) : fexpr__32646.call(null,initial_value));
})()))){
return (initial_value.cljs$core$IFn$_invoke$arity$1 ? initial_value.cljs$core$IFn$_invoke$arity$1(props) : initial_value.call(null,props));
} else {
return initial_value;
}
});})(this$,props,map__32644,map__32644__$1,initial_config,form_name,initial_value,validate,persist_QMARK_,fields))
;
var _ = duff.core.initialize_state(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),form_name,new cljs.core.Keyword(null,"value","value",305978217),get_initial_value(),new cljs.core.Keyword(null,"initial-value","initial-value",470619381),get_initial_value(),new cljs.core.Keyword(null,"validate","validate",-201300827),validate], null));
return reagent.core.create_class(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"display-name","display-name",694513143),["Form: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(form_name))].join(''),new cljs.core.Keyword(null,"get-child-context","get-child-context",-867424947),((function (this$,props,get_initial_value,_,map__32644,map__32644__$1,initial_config,form_name,initial_value,validate,persist_QMARK_,fields){
return (function (){
var this$__$1 = this;
return ({"form-name": form_name, "get-initial-value": get_initial_value, "validate": validate});
});})(this$,props,get_initial_value,_,map__32644,map__32644__$1,initial_config,form_name,initial_value,validate,persist_QMARK_,fields))
,new cljs.core.Keyword(null,"child-context-types","child-context-types",1863743773),duff.core.context_shape,new cljs.core.Keyword(null,"component-will-unmount","component-will-unmount",-2058314698),((function (this$,props,get_initial_value,_,map__32644,map__32644__$1,initial_config,form_name,initial_value,validate,persist_QMARK_,fields){
return (function (){
rf_utils.core.update.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"active-forms","active-forms",-1942150964),cljs.core.disj,form_name], 0));

if(cljs.core.not(persist_QMARK_)){
return rf_utils.core.dissoc_in.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"forms","forms",2045992350),form_name], null)], 0));
} else {
return null;
}
});})(this$,props,get_initial_value,_,map__32644,map__32644__$1,initial_config,form_name,initial_value,validate,persist_QMARK_,fields))
,new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),((function (this$,props,get_initial_value,_,map__32644,map__32644__$1,initial_config,form_name,initial_value,validate,persist_QMARK_,fields){
return (function (){
var this$__$1 = reagent.core.current_component();
var map__32647 = reagent.core.props(this$__$1);
var map__32647__$1 = ((((!((map__32647 == null)))?(((((map__32647.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32647.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32647):map__32647);
var props__$1 = map__32647__$1;
var on_submit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32647__$1,new cljs.core.Keyword(null,"on-submit","on-submit",1227871159));
var before_submit = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32647__$1,new cljs.core.Keyword(null,"before-submit","before-submit",-1632596221),((function (this$__$1,map__32647,map__32647__$1,props__$1,on_submit,this$,props,get_initial_value,_,map__32644,map__32644__$1,initial_config,form_name,initial_value,validate,persist_QMARK_,fields){
return (function (___$1,done){
return (done.cljs$core$IFn$_invoke$arity$0 ? done.cljs$core$IFn$_invoke$arity$0() : done.call(null));
});})(this$__$1,map__32647,map__32647__$1,props__$1,on_submit,this$,props,get_initial_value,_,map__32644,map__32644__$1,initial_config,form_name,initial_value,validate,persist_QMARK_,fields))
);
var state = duff.core.query(form_name,new cljs.core.Keyword(null,"value","value",305978217));
var initial_value__$1 = get_initial_value();
var pristine_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(state,initial_value__$1);
var errors = duff.core.query(form_name,new cljs.core.Keyword(null,"errors","errors",-908790718));
var submitted_QMARK_ = duff.core.query(form_name,new cljs.core.Keyword(null,"submitted?","submitted?",-1363786466));
var valid_QMARK_ = cljs.core.empty_QMARK_(errors);
var invalid_QMARK_ = !(valid_QMARK_);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [component,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"errors","errors",-908790718),new cljs.core.Keyword(null,"valid?","valid?",-212412379),new cljs.core.Keyword(null,"handle-submit","handle-submit",1732326917),new cljs.core.Keyword(null,"reset","reset",-800929946),new cljs.core.Keyword(null,"pristine?","pristine?",-718436279),new cljs.core.Keyword(null,"dirty?","dirty?",-2059845846),new cljs.core.Keyword(null,"invalid?","invalid?",789397235),new cljs.core.Keyword(null,"values","values",372645556),new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),new cljs.core.Keyword(null,"submitted?","submitted?",-1363786466)],[errors,valid_QMARK_,((function (this$__$1,map__32647,map__32647__$1,props__$1,on_submit,before_submit,state,initial_value__$1,pristine_QMARK_,errors,submitted_QMARK_,valid_QMARK_,invalid_QMARK_,this$,props,get_initial_value,_,map__32644,map__32644__$1,initial_config,form_name,initial_value,validate,persist_QMARK_,fields){
return (function (e){
var state__$1 = duff.core.query(form_name,new cljs.core.Keyword(null,"value","value",305978217));
var valid_QMARK___$1 = cljs.core.empty_QMARK_(errors);
e.preventDefault();

if(valid_QMARK___$1){
var G__32649 = state__$1;
var G__32650 = ((function (G__32649,state__$1,valid_QMARK___$1,this$__$1,map__32647,map__32647__$1,props__$1,on_submit,before_submit,state,initial_value__$1,pristine_QMARK_,errors,submitted_QMARK_,valid_QMARK_,invalid_QMARK_,this$,props,get_initial_value,_,map__32644,map__32644__$1,initial_config,form_name,initial_value,validate,persist_QMARK_,fields){
return (function (){
rf_utils.core.assoc_in_sync.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"forms","forms",2045992350),form_name,new cljs.core.Keyword(null,"submitted?","submitted?",-1363786466)], null),true], 0));

return (on_submit.cljs$core$IFn$_invoke$arity$1 ? on_submit.cljs$core$IFn$_invoke$arity$1(state__$1) : on_submit.call(null,state__$1));
});})(G__32649,state__$1,valid_QMARK___$1,this$__$1,map__32647,map__32647__$1,props__$1,on_submit,before_submit,state,initial_value__$1,pristine_QMARK_,errors,submitted_QMARK_,valid_QMARK_,invalid_QMARK_,this$,props,get_initial_value,_,map__32644,map__32644__$1,initial_config,form_name,initial_value,validate,persist_QMARK_,fields))
;
return (before_submit.cljs$core$IFn$_invoke$arity$2 ? before_submit.cljs$core$IFn$_invoke$arity$2(G__32649,G__32650) : before_submit.call(null,G__32649,G__32650));
} else {
return null;
}
});})(this$__$1,map__32647,map__32647__$1,props__$1,on_submit,before_submit,state,initial_value__$1,pristine_QMARK_,errors,submitted_QMARK_,valid_QMARK_,invalid_QMARK_,this$,props,get_initial_value,_,map__32644,map__32644__$1,initial_config,form_name,initial_value,validate,persist_QMARK_,fields))
,((function (this$__$1,map__32647,map__32647__$1,props__$1,on_submit,before_submit,state,initial_value__$1,pristine_QMARK_,errors,submitted_QMARK_,valid_QMARK_,invalid_QMARK_,this$,props,get_initial_value,_,map__32644,map__32644__$1,initial_config,form_name,initial_value,validate,persist_QMARK_,fields){
return (function (){
return duff.core.initialize_state(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),form_name,new cljs.core.Keyword(null,"value","value",305978217),initial_value__$1,new cljs.core.Keyword(null,"initial-value","initial-value",470619381),initial_value__$1,new cljs.core.Keyword(null,"validate","validate",-201300827),validate], null));
});})(this$__$1,map__32647,map__32647__$1,props__$1,on_submit,before_submit,state,initial_value__$1,pristine_QMARK_,errors,submitted_QMARK_,valid_QMARK_,invalid_QMARK_,this$,props,get_initial_value,_,map__32644,map__32644__$1,initial_config,form_name,initial_value,validate,persist_QMARK_,fields))
,pristine_QMARK_,!(pristine_QMARK_),invalid_QMARK_,state,(function (){var or__3949__auto__ = submitted_QMARK_;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return invalid_QMARK_;
}
})(),submitted_QMARK_]),(cljs.core.truth_(fields)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"fields","fields",-1932066230),duff.core.make_fields_map(fields)], null):null),props__$1], 0))], null);
});})(this$,props,get_initial_value,_,map__32644,map__32644__$1,initial_config,form_name,initial_value,validate,persist_QMARK_,fields))
], null));
});
;})(map__32644,map__32644__$1,initial_config,form_name,initial_value,validate,persist_QMARK_,fields))
});

//# sourceMappingURL=duff.core.js.map
