goog.provide('re_frame.trace');
goog.require('cljs.core');
goog.require('re_frame.interop');
goog.require('re_frame.loggers');
goog.require('goog.functions');
re_frame.trace.id = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_(re_frame.trace.id,(0));
});

/** @define {boolean} */
goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.traces !== 'undefined')){
} else {
re_frame.trace.traces = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.next_delivery !== 'undefined')){
} else {
re_frame.trace.next_delivery = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(re_frame.trace.trace_enabled_QMARK_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/Day8/re-frame-trace#installation."], 0));
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__41286){
var map__41287 = p__41286;
var map__41287__$1 = ((((!((map__41287 == null)))?(((((map__41287.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41287.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41287):map__41287);
var operation = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41287__$1,new cljs.core.Keyword(null,"operation","operation",-1267664310));
var op_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41287__$1,new cljs.core.Keyword(null,"op-type","op-type",-1636141668));
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41287__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
var child_of = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41287__$1,new cljs.core.Keyword(null,"child-of","child-of",-903376662));
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"id","id",-1388402092),re_frame.trace.next_id(),new cljs.core.Keyword(null,"operation","operation",-1267664310),operation,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),op_type,new cljs.core.Keyword(null,"tags","tags",1771418977),tags,new cljs.core.Keyword(null,"child-of","child-of",-903376662),(function (){var or__3949__auto__ = child_of;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),new cljs.core.Keyword(null,"start","start",-355208981),re_frame.interop.now()], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce((function re_frame$trace$tracing_cb_debounced(){
var seq__41289_41303 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__41290_41304 = null;
var count__41291_41305 = (0);
var i__41292_41306 = (0);
while(true){
if((i__41292_41306 < count__41291_41305)){
var vec__41293_41307 = chunk__41290_41304.cljs$core$IIndexed$_nth$arity$2(null,i__41292_41306);
var k_41308 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41293_41307,(0),null);
var cb_41309 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41293_41307,(1),null);
try{var G__41297_41310 = cljs.core.deref(re_frame.trace.traces);
(cb_41309.cljs$core$IFn$_invoke$arity$1 ? cb_41309.cljs$core$IFn$_invoke$arity$1(G__41297_41310) : cb_41309.call(null,G__41297_41310));
}catch (e41296){var e_41311 = e41296;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_41308,"while storing",cljs.core.deref(re_frame.trace.traces),e_41311], 0));
}

var G__41312 = seq__41289_41303;
var G__41313 = chunk__41290_41304;
var G__41314 = count__41291_41305;
var G__41315 = (i__41292_41306 + (1));
seq__41289_41303 = G__41312;
chunk__41290_41304 = G__41313;
count__41291_41305 = G__41314;
i__41292_41306 = G__41315;
continue;
} else {
var temp__5457__auto___41316 = cljs.core.seq(seq__41289_41303);
if(temp__5457__auto___41316){
var seq__41289_41317__$1 = temp__5457__auto___41316;
if(cljs.core.chunked_seq_QMARK_(seq__41289_41317__$1)){
var c__4351__auto___41318 = cljs.core.chunk_first(seq__41289_41317__$1);
var G__41319 = cljs.core.chunk_rest(seq__41289_41317__$1);
var G__41320 = c__4351__auto___41318;
var G__41321 = cljs.core.count(c__4351__auto___41318);
var G__41322 = (0);
seq__41289_41303 = G__41319;
chunk__41290_41304 = G__41320;
count__41291_41305 = G__41321;
i__41292_41306 = G__41322;
continue;
} else {
var vec__41298_41323 = cljs.core.first(seq__41289_41317__$1);
var k_41324 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41298_41323,(0),null);
var cb_41325 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41298_41323,(1),null);
try{var G__41302_41326 = cljs.core.deref(re_frame.trace.traces);
(cb_41325.cljs$core$IFn$_invoke$arity$1 ? cb_41325.cljs$core$IFn$_invoke$arity$1(G__41302_41326) : cb_41325.call(null,G__41302_41326));
}catch (e41301){var e_41327 = e41301;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_41324,"while storing",cljs.core.deref(re_frame.trace.traces),e_41327], 0));
}

var G__41328 = cljs.core.next(seq__41289_41317__$1);
var G__41329 = null;
var G__41330 = (0);
var G__41331 = (0);
seq__41289_41303 = G__41328;
chunk__41290_41304 = G__41329;
count__41291_41305 = G__41330;
i__41292_41306 = G__41331;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_(re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref(re_frame.trace.next_delivery) - (10)) < now)){
(re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0 ? re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0() : re_frame.trace.schedule_debounce.call(null));

return cljs.core.reset_BANG_(re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});

//# sourceMappingURL=re_frame.trace.js.map
