goog.provide('shadow.dom');
goog.require('cljs.core');
goog.require('goog.dom');
goog.require('goog.dom.forms');
goog.require('goog.dom.classlist');
goog.require('goog.style');
goog.require('goog.style.transition');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('cljs.core.async');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if(((!((this$ == null))) && (!((this$.shadow$dom$IElement$_to_dom$arity$1 == null))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
var x__4243__auto__ = (((this$ == null))?null:this$);
var m__4244__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4244__auto__.call(null,this$));
} else {
var m__4244__auto____$1 = (shadow.dom._to_dom["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__4244__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if(((!((this$ == null))) && (!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
var x__4243__auto__ = (((this$ == null))?null:this$);
var m__4244__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4244__auto__.call(null,this$));
} else {
var m__4244__auto____$1 = (shadow.dom._to_svg["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__4244__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__38853 = coll;
var G__38854 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__38853,G__38854) : shadow.dom.lazy_native_coll_seq.call(null,G__38853,G__38854));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
});

shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
});

shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__3949__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return not_found;
}
});

shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
});

shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
});

shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
});

shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
});

shadow.dom.NativeColl.cljs$lang$type = true;

shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl";

shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"shadow.dom/NativeColl");
});

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if(((!((el == null)))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode([cljs.core.str.cljs$core$IFn$_invoke$arity$1(el)].join(''));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__38864 = arguments.length;
switch (G__38864) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
});

shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
});

shadow.dom.query_one.cljs$lang$maxFixedArity = 2;

shadow.dom.query = (function shadow$dom$query(var_args){
var G__38867 = arguments.length;
switch (G__38867) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
});

shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
});

shadow.dom.query.cljs$lang$maxFixedArity = 2;

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__38870 = arguments.length;
switch (G__38870) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
});

shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
});

shadow.dom.by_id.cljs$lang$maxFixedArity = 2;

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__38873 = arguments.length;
switch (G__38873) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
e.cancelBubble = true;

e.returnValue = false;
}

return e;
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
});

shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4;

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__38876 = arguments.length;
switch (G__38876) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__38877 = document;
var G__38878 = shadow.dom.dom_node(el);
return goog.dom.contains(G__38877,G__38878);
});

shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
var G__38879 = shadow.dom.dom_node(parent);
var G__38880 = shadow.dom.dom_node(el);
return goog.dom.contains(G__38879,G__38880);
});

shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2;

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
var G__38882 = shadow.dom.dom_node(el);
var G__38883 = cls;
return goog.dom.classlist.add(G__38882,G__38883);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
var G__38884 = shadow.dom.dom_node(el);
var G__38885 = cls;
return goog.dom.classlist.remove(G__38884,G__38885);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__38887 = arguments.length;
switch (G__38887) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
var G__38888 = shadow.dom.dom_node(el);
var G__38889 = cls;
return goog.dom.classlist.toggle(G__38888,G__38889);
});

shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
});

shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3;

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__3949__auto__ = !((typeof document !== 'undefined'));
if(or__3949__auto__){
return or__3949__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e38891){if((e38891 instanceof Object)){
var e = e38891;
return console.log("didnt support attachEvent",el,e);
} else {
throw e38891;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__3949__auto__ = !((typeof document !== 'undefined'));
if(or__3949__auto__){
return or__3949__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__38892 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__38893 = null;
var count__38894 = (0);
var i__38895 = (0);
while(true){
if((i__38895 < count__38894)){
var el = chunk__38893.cljs$core$IIndexed$_nth$arity$2(null,i__38895);
var handler_38902__$1 = ((function (seq__38892,chunk__38893,count__38894,i__38895,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__38892,chunk__38893,count__38894,i__38895,el))
;
var G__38896_38903 = el;
var G__38897_38904 = cljs.core.name(ev);
var G__38898_38905 = handler_38902__$1;
(shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__38896_38903,G__38897_38904,G__38898_38905) : shadow.dom.dom_listen.call(null,G__38896_38903,G__38897_38904,G__38898_38905));


var G__38906 = seq__38892;
var G__38907 = chunk__38893;
var G__38908 = count__38894;
var G__38909 = (i__38895 + (1));
seq__38892 = G__38906;
chunk__38893 = G__38907;
count__38894 = G__38908;
i__38895 = G__38909;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__38892);
if(temp__5457__auto__){
var seq__38892__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__38892__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__38892__$1);
var G__38910 = cljs.core.chunk_rest(seq__38892__$1);
var G__38911 = c__4351__auto__;
var G__38912 = cljs.core.count(c__4351__auto__);
var G__38913 = (0);
seq__38892 = G__38910;
chunk__38893 = G__38911;
count__38894 = G__38912;
i__38895 = G__38913;
continue;
} else {
var el = cljs.core.first(seq__38892__$1);
var handler_38914__$1 = ((function (seq__38892,chunk__38893,count__38894,i__38895,el,seq__38892__$1,temp__5457__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__38892,chunk__38893,count__38894,i__38895,el,seq__38892__$1,temp__5457__auto__))
;
var G__38899_38915 = el;
var G__38900_38916 = cljs.core.name(ev);
var G__38901_38917 = handler_38914__$1;
(shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__38899_38915,G__38900_38916,G__38901_38917) : shadow.dom.dom_listen.call(null,G__38899_38915,G__38900_38916,G__38901_38917));


var G__38918 = cljs.core.next(seq__38892__$1);
var G__38919 = null;
var G__38920 = (0);
var G__38921 = (0);
seq__38892 = G__38918;
chunk__38893 = G__38919;
count__38894 = G__38920;
i__38895 = G__38921;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__38923 = arguments.length;
switch (G__38923) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
});

shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
var G__38924 = shadow.dom.dom_node(el);
var G__38925 = cljs.core.name(ev);
var G__38926 = handler__$1;
return (shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__38924,G__38925,G__38926) : shadow.dom.dom_listen.call(null,G__38924,G__38925,G__38926));
}
});

shadow.dom.on.cljs$lang$maxFixedArity = 4;

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
var G__38928 = shadow.dom.dom_node(el);
var G__38929 = cljs.core.name(ev);
var G__38930 = handler;
return (shadow.dom.dom_listen_remove.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen_remove.cljs$core$IFn$_invoke$arity$3(G__38928,G__38929,G__38930) : shadow.dom.dom_listen_remove.call(null,G__38928,G__38929,G__38930));
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__38931 = cljs.core.seq(events);
var chunk__38932 = null;
var count__38933 = (0);
var i__38934 = (0);
while(true){
if((i__38934 < count__38933)){
var vec__38935 = chunk__38932.cljs$core$IIndexed$_nth$arity$2(null,i__38934);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38935,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38935,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__38941 = seq__38931;
var G__38942 = chunk__38932;
var G__38943 = count__38933;
var G__38944 = (i__38934 + (1));
seq__38931 = G__38941;
chunk__38932 = G__38942;
count__38933 = G__38943;
i__38934 = G__38944;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__38931);
if(temp__5457__auto__){
var seq__38931__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__38931__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__38931__$1);
var G__38945 = cljs.core.chunk_rest(seq__38931__$1);
var G__38946 = c__4351__auto__;
var G__38947 = cljs.core.count(c__4351__auto__);
var G__38948 = (0);
seq__38931 = G__38945;
chunk__38932 = G__38946;
count__38933 = G__38947;
i__38934 = G__38948;
continue;
} else {
var vec__38938 = cljs.core.first(seq__38931__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38938,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38938,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__38949 = cljs.core.next(seq__38931__$1);
var G__38950 = null;
var G__38951 = (0);
var G__38952 = (0);
seq__38931 = G__38949;
chunk__38932 = G__38950;
count__38933 = G__38951;
i__38934 = G__38952;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__38953 = cljs.core.seq(styles);
var chunk__38954 = null;
var count__38955 = (0);
var i__38956 = (0);
while(true){
if((i__38956 < count__38955)){
var vec__38957 = chunk__38954.cljs$core$IIndexed$_nth$arity$2(null,i__38956);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38957,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38957,(1),null);
var G__38960_38969 = dom;
var G__38961_38970 = cljs.core.name(k);
var G__38962_38971 = (((v == null))?"":v);
goog.style.setStyle(G__38960_38969,G__38961_38970,G__38962_38971);


var G__38972 = seq__38953;
var G__38973 = chunk__38954;
var G__38974 = count__38955;
var G__38975 = (i__38956 + (1));
seq__38953 = G__38972;
chunk__38954 = G__38973;
count__38955 = G__38974;
i__38956 = G__38975;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__38953);
if(temp__5457__auto__){
var seq__38953__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__38953__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__38953__$1);
var G__38976 = cljs.core.chunk_rest(seq__38953__$1);
var G__38977 = c__4351__auto__;
var G__38978 = cljs.core.count(c__4351__auto__);
var G__38979 = (0);
seq__38953 = G__38976;
chunk__38954 = G__38977;
count__38955 = G__38978;
i__38956 = G__38979;
continue;
} else {
var vec__38963 = cljs.core.first(seq__38953__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38963,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38963,(1),null);
var G__38966_38980 = dom;
var G__38967_38981 = cljs.core.name(k);
var G__38968_38982 = (((v == null))?"":v);
goog.style.setStyle(G__38966_38980,G__38967_38981,G__38968_38982);


var G__38983 = cljs.core.next(seq__38953__$1);
var G__38984 = null;
var G__38985 = (0);
var G__38986 = (0);
seq__38953 = G__38983;
chunk__38954 = G__38984;
count__38955 = G__38985;
i__38956 = G__38986;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__38987_38988 = key;
var G__38987_38989__$1 = (((G__38987_38988 instanceof cljs.core.Keyword))?G__38987_38988.fqn:null);
switch (G__38987_38989__$1) {
case "id":
el.id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join('');

break;
case "class":
el.className = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join('');

break;
case "for":
el.htmlFor = value;

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_38991 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__3949__auto__ = goog.string.startsWith(ks_38991,"data-");
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return goog.string.startsWith(ks_38991,"aria-");
}
})())){
el.setAttribute(ks_38991,value);
} else {
(el[ks_38991] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
var G__38992 = shadow.dom.dom_node(el);
var G__38993 = cls;
return goog.dom.classlist.contains(G__38992,G__38993);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(spec__$1)].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__38994){
var map__38995 = p__38994;
var map__38995__$1 = ((((!((map__38995 == null)))?(((((map__38995.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38995.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38995):map__38995);
var props = map__38995__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38995__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__38997 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38997,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38997,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38997,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__39000 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__39000,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__39000;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__39002 = arguments.length;
switch (G__39002) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5457__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5457__auto__)){
var n = temp__5457__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
});

shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5457__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5457__auto__)){
var n = temp__5457__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
});

shadow.dom.append.cljs$lang$maxFixedArity = 2;

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__39004){
var vec__39005 = p__39004;
var seq__39006 = cljs.core.seq(vec__39005);
var first__39007 = cljs.core.first(seq__39006);
var seq__39006__$1 = cljs.core.next(seq__39006);
var nn = first__39007;
var first__39007__$1 = cljs.core.first(seq__39006__$1);
var seq__39006__$2 = cljs.core.next(seq__39006__$1);
var np = first__39007__$1;
var nc = seq__39006__$2;
var node = vec__39005;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__39008 = nn;
var G__39009 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__39008,G__39009) : create_fn.call(null,G__39008,G__39009));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__39010 = nn;
var G__39011 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__39010,G__39011) : create_fn.call(null,G__39010,G__39011));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__39012 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39012,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39012,(1),null);
var seq__39015_39031 = cljs.core.seq(node_children);
var chunk__39016_39032 = null;
var count__39017_39033 = (0);
var i__39018_39034 = (0);
while(true){
if((i__39018_39034 < count__39017_39033)){
var child_struct_39035 = chunk__39016_39032.cljs$core$IIndexed$_nth$arity$2(null,i__39018_39034);
var children_39036 = shadow.dom.dom_node(child_struct_39035);
if(cljs.core.seq_QMARK_(children_39036)){
var seq__39019_39037 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_39036));
var chunk__39021_39038 = null;
var count__39022_39039 = (0);
var i__39023_39040 = (0);
while(true){
if((i__39023_39040 < count__39022_39039)){
var child_39041 = chunk__39021_39038.cljs$core$IIndexed$_nth$arity$2(null,i__39023_39040);
if(cljs.core.truth_(child_39041)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_39041);


var G__39042 = seq__39019_39037;
var G__39043 = chunk__39021_39038;
var G__39044 = count__39022_39039;
var G__39045 = (i__39023_39040 + (1));
seq__39019_39037 = G__39042;
chunk__39021_39038 = G__39043;
count__39022_39039 = G__39044;
i__39023_39040 = G__39045;
continue;
} else {
var G__39046 = seq__39019_39037;
var G__39047 = chunk__39021_39038;
var G__39048 = count__39022_39039;
var G__39049 = (i__39023_39040 + (1));
seq__39019_39037 = G__39046;
chunk__39021_39038 = G__39047;
count__39022_39039 = G__39048;
i__39023_39040 = G__39049;
continue;
}
} else {
var temp__5457__auto___39050 = cljs.core.seq(seq__39019_39037);
if(temp__5457__auto___39050){
var seq__39019_39051__$1 = temp__5457__auto___39050;
if(cljs.core.chunked_seq_QMARK_(seq__39019_39051__$1)){
var c__4351__auto___39052 = cljs.core.chunk_first(seq__39019_39051__$1);
var G__39053 = cljs.core.chunk_rest(seq__39019_39051__$1);
var G__39054 = c__4351__auto___39052;
var G__39055 = cljs.core.count(c__4351__auto___39052);
var G__39056 = (0);
seq__39019_39037 = G__39053;
chunk__39021_39038 = G__39054;
count__39022_39039 = G__39055;
i__39023_39040 = G__39056;
continue;
} else {
var child_39057 = cljs.core.first(seq__39019_39051__$1);
if(cljs.core.truth_(child_39057)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_39057);


var G__39058 = cljs.core.next(seq__39019_39051__$1);
var G__39059 = null;
var G__39060 = (0);
var G__39061 = (0);
seq__39019_39037 = G__39058;
chunk__39021_39038 = G__39059;
count__39022_39039 = G__39060;
i__39023_39040 = G__39061;
continue;
} else {
var G__39062 = cljs.core.next(seq__39019_39051__$1);
var G__39063 = null;
var G__39064 = (0);
var G__39065 = (0);
seq__39019_39037 = G__39062;
chunk__39021_39038 = G__39063;
count__39022_39039 = G__39064;
i__39023_39040 = G__39065;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_39036);
}


var G__39066 = seq__39015_39031;
var G__39067 = chunk__39016_39032;
var G__39068 = count__39017_39033;
var G__39069 = (i__39018_39034 + (1));
seq__39015_39031 = G__39066;
chunk__39016_39032 = G__39067;
count__39017_39033 = G__39068;
i__39018_39034 = G__39069;
continue;
} else {
var temp__5457__auto___39070 = cljs.core.seq(seq__39015_39031);
if(temp__5457__auto___39070){
var seq__39015_39071__$1 = temp__5457__auto___39070;
if(cljs.core.chunked_seq_QMARK_(seq__39015_39071__$1)){
var c__4351__auto___39072 = cljs.core.chunk_first(seq__39015_39071__$1);
var G__39073 = cljs.core.chunk_rest(seq__39015_39071__$1);
var G__39074 = c__4351__auto___39072;
var G__39075 = cljs.core.count(c__4351__auto___39072);
var G__39076 = (0);
seq__39015_39031 = G__39073;
chunk__39016_39032 = G__39074;
count__39017_39033 = G__39075;
i__39018_39034 = G__39076;
continue;
} else {
var child_struct_39077 = cljs.core.first(seq__39015_39071__$1);
var children_39078 = shadow.dom.dom_node(child_struct_39077);
if(cljs.core.seq_QMARK_(children_39078)){
var seq__39025_39079 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_39078));
var chunk__39027_39080 = null;
var count__39028_39081 = (0);
var i__39029_39082 = (0);
while(true){
if((i__39029_39082 < count__39028_39081)){
var child_39083 = chunk__39027_39080.cljs$core$IIndexed$_nth$arity$2(null,i__39029_39082);
if(cljs.core.truth_(child_39083)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_39083);


var G__39084 = seq__39025_39079;
var G__39085 = chunk__39027_39080;
var G__39086 = count__39028_39081;
var G__39087 = (i__39029_39082 + (1));
seq__39025_39079 = G__39084;
chunk__39027_39080 = G__39085;
count__39028_39081 = G__39086;
i__39029_39082 = G__39087;
continue;
} else {
var G__39088 = seq__39025_39079;
var G__39089 = chunk__39027_39080;
var G__39090 = count__39028_39081;
var G__39091 = (i__39029_39082 + (1));
seq__39025_39079 = G__39088;
chunk__39027_39080 = G__39089;
count__39028_39081 = G__39090;
i__39029_39082 = G__39091;
continue;
}
} else {
var temp__5457__auto___39092__$1 = cljs.core.seq(seq__39025_39079);
if(temp__5457__auto___39092__$1){
var seq__39025_39093__$1 = temp__5457__auto___39092__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39025_39093__$1)){
var c__4351__auto___39094 = cljs.core.chunk_first(seq__39025_39093__$1);
var G__39095 = cljs.core.chunk_rest(seq__39025_39093__$1);
var G__39096 = c__4351__auto___39094;
var G__39097 = cljs.core.count(c__4351__auto___39094);
var G__39098 = (0);
seq__39025_39079 = G__39095;
chunk__39027_39080 = G__39096;
count__39028_39081 = G__39097;
i__39029_39082 = G__39098;
continue;
} else {
var child_39099 = cljs.core.first(seq__39025_39093__$1);
if(cljs.core.truth_(child_39099)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_39099);


var G__39100 = cljs.core.next(seq__39025_39093__$1);
var G__39101 = null;
var G__39102 = (0);
var G__39103 = (0);
seq__39025_39079 = G__39100;
chunk__39027_39080 = G__39101;
count__39028_39081 = G__39102;
i__39029_39082 = G__39103;
continue;
} else {
var G__39104 = cljs.core.next(seq__39025_39093__$1);
var G__39105 = null;
var G__39106 = (0);
var G__39107 = (0);
seq__39025_39079 = G__39104;
chunk__39027_39080 = G__39105;
count__39028_39081 = G__39106;
i__39029_39082 = G__39107;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_39078);
}


var G__39108 = cljs.core.next(seq__39015_39071__$1);
var G__39109 = null;
var G__39110 = (0);
var G__39111 = (0);
seq__39015_39031 = G__39108;
chunk__39016_39032 = G__39109;
count__39017_39033 = G__39110;
i__39018_39034 = G__39111;
continue;
}
} else {
}
}
break;
}

return node;
});
cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
});

cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
});

cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
});
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
var G__39112 = shadow.dom.dom_node(node);
return goog.dom.removeChildren(G__39112);
});
shadow.dom.remove = (function shadow$dom$remove(node){
if(((!((node == null)))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__39114 = cljs.core.seq(node);
var chunk__39115 = null;
var count__39116 = (0);
var i__39117 = (0);
while(true){
if((i__39117 < count__39116)){
var n = chunk__39115.cljs$core$IIndexed$_nth$arity$2(null,i__39117);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__39118 = seq__39114;
var G__39119 = chunk__39115;
var G__39120 = count__39116;
var G__39121 = (i__39117 + (1));
seq__39114 = G__39118;
chunk__39115 = G__39119;
count__39116 = G__39120;
i__39117 = G__39121;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__39114);
if(temp__5457__auto__){
var seq__39114__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__39114__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__39114__$1);
var G__39122 = cljs.core.chunk_rest(seq__39114__$1);
var G__39123 = c__4351__auto__;
var G__39124 = cljs.core.count(c__4351__auto__);
var G__39125 = (0);
seq__39114 = G__39122;
chunk__39115 = G__39123;
count__39116 = G__39124;
i__39117 = G__39125;
continue;
} else {
var n = cljs.core.first(seq__39114__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__39126 = cljs.core.next(seq__39114__$1);
var G__39127 = null;
var G__39128 = (0);
var G__39129 = (0);
seq__39114 = G__39126;
chunk__39115 = G__39127;
count__39116 = G__39128;
i__39117 = G__39129;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
var G__39130 = shadow.dom.dom_node(new$);
var G__39131 = shadow.dom.dom_node(old);
return goog.dom.replaceNode(G__39130,G__39131);
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__39133 = arguments.length;
switch (G__39133) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return shadow.dom.dom_node(el).innerText = new_text;
});

shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
});

shadow.dom.text.cljs$lang$maxFixedArity = 2;

shadow.dom.check = (function shadow$dom$check(var_args){
var G__39136 = arguments.length;
switch (G__39136) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
});

shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return shadow.dom.dom_node(el).checked = checked;
});

shadow.dom.check.cljs$lang$maxFixedArity = 2;

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__39139 = arguments.length;
switch (G__39139) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
});

shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__3949__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return default$;
}
});

shadow.dom.attr.cljs$lang$maxFixedArity = 3;

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(key))].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(key))].join(''),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join(''));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return shadow.dom.dom_node(node).innerHTML = text;
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4534__auto__ = [];
var len__4531__auto___39146 = arguments.length;
var i__4532__auto___39147 = (0);
while(true){
if((i__4532__auto___39147 < len__4531__auto___39146)){
args__4534__auto__.push((arguments[i__4532__auto___39147]));

var G__39148 = (i__4532__auto___39147 + (1));
i__4532__auto___39147 = G__39148;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__39142_39149 = cljs.core.seq(nodes);
var chunk__39143_39150 = null;
var count__39144_39151 = (0);
var i__39145_39152 = (0);
while(true){
if((i__39145_39152 < count__39144_39151)){
var node_39153 = chunk__39143_39150.cljs$core$IIndexed$_nth$arity$2(null,i__39145_39152);
fragment.appendChild(shadow.dom._to_dom(node_39153));


var G__39154 = seq__39142_39149;
var G__39155 = chunk__39143_39150;
var G__39156 = count__39144_39151;
var G__39157 = (i__39145_39152 + (1));
seq__39142_39149 = G__39154;
chunk__39143_39150 = G__39155;
count__39144_39151 = G__39156;
i__39145_39152 = G__39157;
continue;
} else {
var temp__5457__auto___39158 = cljs.core.seq(seq__39142_39149);
if(temp__5457__auto___39158){
var seq__39142_39159__$1 = temp__5457__auto___39158;
if(cljs.core.chunked_seq_QMARK_(seq__39142_39159__$1)){
var c__4351__auto___39160 = cljs.core.chunk_first(seq__39142_39159__$1);
var G__39161 = cljs.core.chunk_rest(seq__39142_39159__$1);
var G__39162 = c__4351__auto___39160;
var G__39163 = cljs.core.count(c__4351__auto___39160);
var G__39164 = (0);
seq__39142_39149 = G__39161;
chunk__39143_39150 = G__39162;
count__39144_39151 = G__39163;
i__39145_39152 = G__39164;
continue;
} else {
var node_39165 = cljs.core.first(seq__39142_39159__$1);
fragment.appendChild(shadow.dom._to_dom(node_39165));


var G__39166 = cljs.core.next(seq__39142_39159__$1);
var G__39167 = null;
var G__39168 = (0);
var G__39169 = (0);
seq__39142_39149 = G__39166;
chunk__39143_39150 = G__39167;
count__39144_39151 = G__39168;
i__39145_39152 = G__39169;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
});

shadow.dom.fragment.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
shadow.dom.fragment.cljs$lang$applyTo = (function (seq39141){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39141));
});

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__39170_39184 = cljs.core.seq(scripts);
var chunk__39171_39185 = null;
var count__39172_39186 = (0);
var i__39173_39187 = (0);
while(true){
if((i__39173_39187 < count__39172_39186)){
var vec__39174_39188 = chunk__39171_39185.cljs$core$IIndexed$_nth$arity$2(null,i__39173_39187);
var script_tag_39189 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39174_39188,(0),null);
var script_body_39190 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39174_39188,(1),null);
eval(script_body_39190);


var G__39191 = seq__39170_39184;
var G__39192 = chunk__39171_39185;
var G__39193 = count__39172_39186;
var G__39194 = (i__39173_39187 + (1));
seq__39170_39184 = G__39191;
chunk__39171_39185 = G__39192;
count__39172_39186 = G__39193;
i__39173_39187 = G__39194;
continue;
} else {
var temp__5457__auto___39195 = cljs.core.seq(seq__39170_39184);
if(temp__5457__auto___39195){
var seq__39170_39196__$1 = temp__5457__auto___39195;
if(cljs.core.chunked_seq_QMARK_(seq__39170_39196__$1)){
var c__4351__auto___39197 = cljs.core.chunk_first(seq__39170_39196__$1);
var G__39198 = cljs.core.chunk_rest(seq__39170_39196__$1);
var G__39199 = c__4351__auto___39197;
var G__39200 = cljs.core.count(c__4351__auto___39197);
var G__39201 = (0);
seq__39170_39184 = G__39198;
chunk__39171_39185 = G__39199;
count__39172_39186 = G__39200;
i__39173_39187 = G__39201;
continue;
} else {
var vec__39177_39202 = cljs.core.first(seq__39170_39196__$1);
var script_tag_39203 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39177_39202,(0),null);
var script_body_39204 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39177_39202,(1),null);
eval(script_body_39204);


var G__39205 = cljs.core.next(seq__39170_39196__$1);
var G__39206 = null;
var G__39207 = (0);
var G__39208 = (0);
seq__39170_39184 = G__39205;
chunk__39171_39185 = G__39206;
count__39172_39186 = G__39207;
i__39173_39187 = G__39208;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (scripts){
return (function (s__$1,p__39180){
var vec__39181 = p__39180;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39181,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39181,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
});})(scripts))
,s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
el.innerHTML = s;

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
var G__39209 = shadow.dom.dom_node(el);
var G__39210 = cls;
return goog.dom.getAncestorByClass(G__39209,G__39210);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__39212 = arguments.length;
switch (G__39212) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
var G__39213 = shadow.dom.dom_node(el);
var G__39214 = cljs.core.name(tag);
return goog.dom.getAncestorByTagNameAndClass(G__39213,G__39214);
});

shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
var G__39215 = shadow.dom.dom_node(el);
var G__39216 = cljs.core.name(tag);
var G__39217 = cljs.core.name(cls);
return goog.dom.getAncestorByTagNameAndClass(G__39215,G__39216,G__39217);
});

shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3;

shadow.dom.get_value = (function shadow$dom$get_value(dom){
var G__39219 = shadow.dom.dom_node(dom);
return goog.dom.forms.getValue(G__39219);
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
var G__39220 = shadow.dom.dom_node(dom);
var G__39221 = value;
return goog.dom.forms.setValue(G__39220,G__39221);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__39222 = cljs.core.seq(style_keys);
var chunk__39223 = null;
var count__39224 = (0);
var i__39225 = (0);
while(true){
if((i__39225 < count__39224)){
var it = chunk__39223.cljs$core$IIndexed$_nth$arity$2(null,i__39225);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__39226 = seq__39222;
var G__39227 = chunk__39223;
var G__39228 = count__39224;
var G__39229 = (i__39225 + (1));
seq__39222 = G__39226;
chunk__39223 = G__39227;
count__39224 = G__39228;
i__39225 = G__39229;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__39222);
if(temp__5457__auto__){
var seq__39222__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__39222__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__39222__$1);
var G__39230 = cljs.core.chunk_rest(seq__39222__$1);
var G__39231 = c__4351__auto__;
var G__39232 = cljs.core.count(c__4351__auto__);
var G__39233 = (0);
seq__39222 = G__39230;
chunk__39223 = G__39231;
count__39224 = G__39232;
i__39225 = G__39233;
continue;
} else {
var it = cljs.core.first(seq__39222__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__39234 = cljs.core.next(seq__39222__$1);
var G__39235 = null;
var G__39236 = (0);
var G__39237 = (0);
seq__39222 = G__39234;
chunk__39223 = G__39235;
count__39224 = G__39236;
i__39225 = G__39237;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4203__auto__,k__4204__auto__){
var self__ = this;
var this__4203__auto____$1 = this;
return this__4203__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4204__auto__,null);
});

shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4205__auto__,k39239,else__4206__auto__){
var self__ = this;
var this__4205__auto____$1 = this;
var G__39243 = k39239;
var G__39243__$1 = (((G__39243 instanceof cljs.core.Keyword))?G__39243.fqn:null);
switch (G__39243__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k39239,else__4206__auto__);

}
});

shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4217__auto__,writer__4218__auto__,opts__4219__auto__){
var self__ = this;
var this__4217__auto____$1 = this;
var pr_pair__4220__auto__ = ((function (this__4217__auto____$1){
return (function (keyval__4221__auto__){
return cljs.core.pr_sequential_writer(writer__4218__auto__,cljs.core.pr_writer,""," ","",opts__4219__auto__,keyval__4221__auto__);
});})(this__4217__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4218__auto__,pr_pair__4220__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4219__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__39238){
var self__ = this;
var G__39238__$1 = this;
return (new cljs.core.RecordIter((0),G__39238__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4201__auto__){
var self__ = this;
var this__4201__auto____$1 = this;
return self__.__meta;
});

shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4198__auto__){
var self__ = this;
var this__4198__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
});

shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4207__auto__){
var self__ = this;
var this__4207__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4199__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = (function (){var fexpr__39244 = ((function (h__4061__auto__,this__4199__auto____$1){
return (function (coll__4200__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4200__auto__));
});})(h__4061__auto__,this__4199__auto____$1))
;
return fexpr__39244(this__4199__auto____$1);
})();
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this39240,other39241){
var self__ = this;
var this39240__$1 = this;
return ((!((other39241 == null))) && ((this39240__$1.constructor === other39241.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39240__$1.x,other39241.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39240__$1.y,other39241.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39240__$1.__extmap,other39241.__extmap)));
});

shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4212__auto__,k__4213__auto__){
var self__ = this;
var this__4212__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4213__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4212__auto____$1),self__.__meta),k__4213__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4213__auto__)),null));
}
});

shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4210__auto__,k__4211__auto__,G__39238){
var self__ = this;
var this__4210__auto____$1 = this;
var pred__39245 = cljs.core.keyword_identical_QMARK_;
var expr__39246 = k__4211__auto__;
if(cljs.core.truth_((function (){var G__39248 = new cljs.core.Keyword(null,"x","x",2099068185);
var G__39249 = expr__39246;
return (pred__39245.cljs$core$IFn$_invoke$arity$2 ? pred__39245.cljs$core$IFn$_invoke$arity$2(G__39248,G__39249) : pred__39245.call(null,G__39248,G__39249));
})())){
return (new shadow.dom.Coordinate(G__39238,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39250 = new cljs.core.Keyword(null,"y","y",-1757859776);
var G__39251 = expr__39246;
return (pred__39245.cljs$core$IFn$_invoke$arity$2 ? pred__39245.cljs$core$IFn$_invoke$arity$2(G__39250,G__39251) : pred__39245.call(null,G__39250,G__39251));
})())){
return (new shadow.dom.Coordinate(self__.x,G__39238,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4211__auto__,G__39238),null));
}
}
});

shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4215__auto__){
var self__ = this;
var this__4215__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4202__auto__,G__39238){
var self__ = this;
var this__4202__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__39238,self__.__extmap,self__.__hash));
});

shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4208__auto__,entry__4209__auto__){
var self__ = this;
var this__4208__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4209__auto__)){
return this__4208__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4209__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4209__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4208__auto____$1,entry__4209__auto__);
}
});

shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
});

shadow.dom.Coordinate.cljs$lang$type = true;

shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4240__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
});

shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4240__auto__,writer__4241__auto__){
return cljs.core._write(writer__4241__auto__,"shadow.dom/Coordinate");
});

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__39242){
var extmap__4236__auto__ = (function (){var G__39252 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__39242,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__39242)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__39252);
} else {
return G__39252;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__39242),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__39242),null,cljs.core.not_empty(extmap__4236__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = (function (){var G__39254 = shadow.dom.dom_node(el);
return goog.style.getPosition(G__39254);
})();
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = (function (){var G__39255 = shadow.dom.dom_node(el);
return goog.style.getClientPosition(G__39255);
})();
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = (function (){var G__39256 = shadow.dom.dom_node(el);
return goog.style.getPageOffset(G__39256);
})();
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4203__auto__,k__4204__auto__){
var self__ = this;
var this__4203__auto____$1 = this;
return this__4203__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4204__auto__,null);
});

shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4205__auto__,k39258,else__4206__auto__){
var self__ = this;
var this__4205__auto____$1 = this;
var G__39262 = k39258;
var G__39262__$1 = (((G__39262 instanceof cljs.core.Keyword))?G__39262.fqn:null);
switch (G__39262__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k39258,else__4206__auto__);

}
});

shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4217__auto__,writer__4218__auto__,opts__4219__auto__){
var self__ = this;
var this__4217__auto____$1 = this;
var pr_pair__4220__auto__ = ((function (this__4217__auto____$1){
return (function (keyval__4221__auto__){
return cljs.core.pr_sequential_writer(writer__4218__auto__,cljs.core.pr_writer,""," ","",opts__4219__auto__,keyval__4221__auto__);
});})(this__4217__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4218__auto__,pr_pair__4220__auto__,"#shadow.dom.Size{",", ","}",opts__4219__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__39257){
var self__ = this;
var G__39257__$1 = this;
return (new cljs.core.RecordIter((0),G__39257__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4201__auto__){
var self__ = this;
var this__4201__auto____$1 = this;
return self__.__meta;
});

shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4198__auto__){
var self__ = this;
var this__4198__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
});

shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4207__auto__){
var self__ = this;
var this__4207__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4199__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = (function (){var fexpr__39263 = ((function (h__4061__auto__,this__4199__auto____$1){
return (function (coll__4200__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4200__auto__));
});})(h__4061__auto__,this__4199__auto____$1))
;
return fexpr__39263(this__4199__auto____$1);
})();
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this39259,other39260){
var self__ = this;
var this39259__$1 = this;
return ((!((other39260 == null))) && ((this39259__$1.constructor === other39260.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39259__$1.w,other39260.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39259__$1.h,other39260.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39259__$1.__extmap,other39260.__extmap)));
});

shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4212__auto__,k__4213__auto__){
var self__ = this;
var this__4212__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4213__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4212__auto____$1),self__.__meta),k__4213__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4213__auto__)),null));
}
});

shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4210__auto__,k__4211__auto__,G__39257){
var self__ = this;
var this__4210__auto____$1 = this;
var pred__39264 = cljs.core.keyword_identical_QMARK_;
var expr__39265 = k__4211__auto__;
if(cljs.core.truth_((function (){var G__39267 = new cljs.core.Keyword(null,"w","w",354169001);
var G__39268 = expr__39265;
return (pred__39264.cljs$core$IFn$_invoke$arity$2 ? pred__39264.cljs$core$IFn$_invoke$arity$2(G__39267,G__39268) : pred__39264.call(null,G__39267,G__39268));
})())){
return (new shadow.dom.Size(G__39257,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39269 = new cljs.core.Keyword(null,"h","h",1109658740);
var G__39270 = expr__39265;
return (pred__39264.cljs$core$IFn$_invoke$arity$2 ? pred__39264.cljs$core$IFn$_invoke$arity$2(G__39269,G__39270) : pred__39264.call(null,G__39269,G__39270));
})())){
return (new shadow.dom.Size(self__.w,G__39257,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4211__auto__,G__39257),null));
}
}
});

shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4215__auto__){
var self__ = this;
var this__4215__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4202__auto__,G__39257){
var self__ = this;
var this__4202__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__39257,self__.__extmap,self__.__hash));
});

shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4208__auto__,entry__4209__auto__){
var self__ = this;
var this__4208__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4209__auto__)){
return this__4208__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4209__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4209__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4208__auto____$1,entry__4209__auto__);
}
});

shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
});

shadow.dom.Size.cljs$lang$type = true;

shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4240__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
});

shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4240__auto__,writer__4241__auto__){
return cljs.core._write(writer__4241__auto__,"shadow.dom/Size");
});

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__39261){
var extmap__4236__auto__ = (function (){var G__39271 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__39261,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__39261)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__39271);
} else {
return G__39271;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__39261),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__39261),null,cljs.core.not_empty(extmap__4236__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj((function (){var G__39273 = shadow.dom.dom_node(el);
return goog.style.getSize(G__39273);
})());
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(shadow.dom.get_size(el));
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4405__auto__ = opts;
var l__4406__auto__ = a__4405__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4406__auto__)){
var G__39274 = (i + (1));
var G__39275 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__39274;
ret = G__39275;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__39276){
var vec__39277 = p__39276;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39277,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39277,(1),null);
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(k)),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent([cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join('')))].join('');
}),query_params)))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__39281 = arguments.length;
switch (G__39281) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
});

shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
});

shadow.dom.redirect.cljs$lang$maxFixedArity = 2;

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return document.location.href = document.location.href;
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
var G__39283_39285 = new_node;
var G__39284_39286 = shadow.dom.dom_node(ref);
goog.dom.insertSiblingAfter(G__39283_39285,G__39284_39286);

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
var G__39287_39289 = new_node;
var G__39288_39290 = shadow.dom.dom_node(ref);
goog.dom.insertSiblingBefore(G__39287_39289,G__39288_39290);

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5455__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5455__auto__)){
var child = temp__5455__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__39291 = ps;
var G__39292 = (i + (1));
el__$1 = G__39291;
i = G__39292;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
var G__39293 = shadow.dom.dom_node(el);
return goog.dom.getParentElement(G__39293);
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,((function (parent){
return (function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
});})(parent))
,null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
var G__39294 = shadow.dom.dom_node(el);
return goog.dom.getNextElementSibling(G__39294);
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
var G__39295 = shadow.dom.dom_node(el);
return goog.dom.getPreviousElementSibling(G__39295);
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__39296 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39296,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39296,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39296,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__39299_39309 = cljs.core.seq(props);
var chunk__39300_39310 = null;
var count__39301_39311 = (0);
var i__39302_39312 = (0);
while(true){
if((i__39302_39312 < count__39301_39311)){
var vec__39303_39313 = chunk__39300_39310.cljs$core$IIndexed$_nth$arity$2(null,i__39302_39312);
var k_39314 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39303_39313,(0),null);
var v_39315 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39303_39313,(1),null);
el.setAttributeNS((function (){var temp__5457__auto__ = cljs.core.namespace(k_39314);
if(cljs.core.truth_(temp__5457__auto__)){
var ns = temp__5457__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_39314),v_39315);


var G__39316 = seq__39299_39309;
var G__39317 = chunk__39300_39310;
var G__39318 = count__39301_39311;
var G__39319 = (i__39302_39312 + (1));
seq__39299_39309 = G__39316;
chunk__39300_39310 = G__39317;
count__39301_39311 = G__39318;
i__39302_39312 = G__39319;
continue;
} else {
var temp__5457__auto___39320 = cljs.core.seq(seq__39299_39309);
if(temp__5457__auto___39320){
var seq__39299_39321__$1 = temp__5457__auto___39320;
if(cljs.core.chunked_seq_QMARK_(seq__39299_39321__$1)){
var c__4351__auto___39322 = cljs.core.chunk_first(seq__39299_39321__$1);
var G__39323 = cljs.core.chunk_rest(seq__39299_39321__$1);
var G__39324 = c__4351__auto___39322;
var G__39325 = cljs.core.count(c__4351__auto___39322);
var G__39326 = (0);
seq__39299_39309 = G__39323;
chunk__39300_39310 = G__39324;
count__39301_39311 = G__39325;
i__39302_39312 = G__39326;
continue;
} else {
var vec__39306_39327 = cljs.core.first(seq__39299_39321__$1);
var k_39328 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39306_39327,(0),null);
var v_39329 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39306_39327,(1),null);
el.setAttributeNS((function (){var temp__5457__auto____$1 = cljs.core.namespace(k_39328);
if(cljs.core.truth_(temp__5457__auto____$1)){
var ns = temp__5457__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_39328),v_39329);


var G__39330 = cljs.core.next(seq__39299_39321__$1);
var G__39331 = null;
var G__39332 = (0);
var G__39333 = (0);
seq__39299_39309 = G__39330;
chunk__39300_39310 = G__39331;
count__39301_39311 = G__39332;
i__39302_39312 = G__39333;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if(((!((el == null)))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__39335 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39335,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39335,(1),null);
var seq__39338_39356 = cljs.core.seq(node_children);
var chunk__39340_39357 = null;
var count__39341_39358 = (0);
var i__39342_39359 = (0);
while(true){
if((i__39342_39359 < count__39341_39358)){
var child_struct_39360 = chunk__39340_39357.cljs$core$IIndexed$_nth$arity$2(null,i__39342_39359);
if(!((child_struct_39360 == null))){
if(typeof child_struct_39360 === 'string'){
var text_39361 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_39361),cljs.core.str.cljs$core$IFn$_invoke$arity$1(child_struct_39360)].join(''));
} else {
var children_39362 = shadow.dom.svg_node(child_struct_39360);
if(cljs.core.seq_QMARK_(children_39362)){
var seq__39344_39363 = cljs.core.seq(children_39362);
var chunk__39346_39364 = null;
var count__39347_39365 = (0);
var i__39348_39366 = (0);
while(true){
if((i__39348_39366 < count__39347_39365)){
var child_39367 = chunk__39346_39364.cljs$core$IIndexed$_nth$arity$2(null,i__39348_39366);
if(cljs.core.truth_(child_39367)){
node.appendChild(child_39367);


var G__39368 = seq__39344_39363;
var G__39369 = chunk__39346_39364;
var G__39370 = count__39347_39365;
var G__39371 = (i__39348_39366 + (1));
seq__39344_39363 = G__39368;
chunk__39346_39364 = G__39369;
count__39347_39365 = G__39370;
i__39348_39366 = G__39371;
continue;
} else {
var G__39372 = seq__39344_39363;
var G__39373 = chunk__39346_39364;
var G__39374 = count__39347_39365;
var G__39375 = (i__39348_39366 + (1));
seq__39344_39363 = G__39372;
chunk__39346_39364 = G__39373;
count__39347_39365 = G__39374;
i__39348_39366 = G__39375;
continue;
}
} else {
var temp__5457__auto___39376 = cljs.core.seq(seq__39344_39363);
if(temp__5457__auto___39376){
var seq__39344_39377__$1 = temp__5457__auto___39376;
if(cljs.core.chunked_seq_QMARK_(seq__39344_39377__$1)){
var c__4351__auto___39378 = cljs.core.chunk_first(seq__39344_39377__$1);
var G__39379 = cljs.core.chunk_rest(seq__39344_39377__$1);
var G__39380 = c__4351__auto___39378;
var G__39381 = cljs.core.count(c__4351__auto___39378);
var G__39382 = (0);
seq__39344_39363 = G__39379;
chunk__39346_39364 = G__39380;
count__39347_39365 = G__39381;
i__39348_39366 = G__39382;
continue;
} else {
var child_39383 = cljs.core.first(seq__39344_39377__$1);
if(cljs.core.truth_(child_39383)){
node.appendChild(child_39383);


var G__39384 = cljs.core.next(seq__39344_39377__$1);
var G__39385 = null;
var G__39386 = (0);
var G__39387 = (0);
seq__39344_39363 = G__39384;
chunk__39346_39364 = G__39385;
count__39347_39365 = G__39386;
i__39348_39366 = G__39387;
continue;
} else {
var G__39388 = cljs.core.next(seq__39344_39377__$1);
var G__39389 = null;
var G__39390 = (0);
var G__39391 = (0);
seq__39344_39363 = G__39388;
chunk__39346_39364 = G__39389;
count__39347_39365 = G__39390;
i__39348_39366 = G__39391;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_39362);
}
}


var G__39392 = seq__39338_39356;
var G__39393 = chunk__39340_39357;
var G__39394 = count__39341_39358;
var G__39395 = (i__39342_39359 + (1));
seq__39338_39356 = G__39392;
chunk__39340_39357 = G__39393;
count__39341_39358 = G__39394;
i__39342_39359 = G__39395;
continue;
} else {
var G__39396 = seq__39338_39356;
var G__39397 = chunk__39340_39357;
var G__39398 = count__39341_39358;
var G__39399 = (i__39342_39359 + (1));
seq__39338_39356 = G__39396;
chunk__39340_39357 = G__39397;
count__39341_39358 = G__39398;
i__39342_39359 = G__39399;
continue;
}
} else {
var temp__5457__auto___39400 = cljs.core.seq(seq__39338_39356);
if(temp__5457__auto___39400){
var seq__39338_39401__$1 = temp__5457__auto___39400;
if(cljs.core.chunked_seq_QMARK_(seq__39338_39401__$1)){
var c__4351__auto___39402 = cljs.core.chunk_first(seq__39338_39401__$1);
var G__39403 = cljs.core.chunk_rest(seq__39338_39401__$1);
var G__39404 = c__4351__auto___39402;
var G__39405 = cljs.core.count(c__4351__auto___39402);
var G__39406 = (0);
seq__39338_39356 = G__39403;
chunk__39340_39357 = G__39404;
count__39341_39358 = G__39405;
i__39342_39359 = G__39406;
continue;
} else {
var child_struct_39407 = cljs.core.first(seq__39338_39401__$1);
if(!((child_struct_39407 == null))){
if(typeof child_struct_39407 === 'string'){
var text_39408 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_39408),cljs.core.str.cljs$core$IFn$_invoke$arity$1(child_struct_39407)].join(''));
} else {
var children_39409 = shadow.dom.svg_node(child_struct_39407);
if(cljs.core.seq_QMARK_(children_39409)){
var seq__39350_39410 = cljs.core.seq(children_39409);
var chunk__39352_39411 = null;
var count__39353_39412 = (0);
var i__39354_39413 = (0);
while(true){
if((i__39354_39413 < count__39353_39412)){
var child_39414 = chunk__39352_39411.cljs$core$IIndexed$_nth$arity$2(null,i__39354_39413);
if(cljs.core.truth_(child_39414)){
node.appendChild(child_39414);


var G__39415 = seq__39350_39410;
var G__39416 = chunk__39352_39411;
var G__39417 = count__39353_39412;
var G__39418 = (i__39354_39413 + (1));
seq__39350_39410 = G__39415;
chunk__39352_39411 = G__39416;
count__39353_39412 = G__39417;
i__39354_39413 = G__39418;
continue;
} else {
var G__39419 = seq__39350_39410;
var G__39420 = chunk__39352_39411;
var G__39421 = count__39353_39412;
var G__39422 = (i__39354_39413 + (1));
seq__39350_39410 = G__39419;
chunk__39352_39411 = G__39420;
count__39353_39412 = G__39421;
i__39354_39413 = G__39422;
continue;
}
} else {
var temp__5457__auto___39423__$1 = cljs.core.seq(seq__39350_39410);
if(temp__5457__auto___39423__$1){
var seq__39350_39424__$1 = temp__5457__auto___39423__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39350_39424__$1)){
var c__4351__auto___39425 = cljs.core.chunk_first(seq__39350_39424__$1);
var G__39426 = cljs.core.chunk_rest(seq__39350_39424__$1);
var G__39427 = c__4351__auto___39425;
var G__39428 = cljs.core.count(c__4351__auto___39425);
var G__39429 = (0);
seq__39350_39410 = G__39426;
chunk__39352_39411 = G__39427;
count__39353_39412 = G__39428;
i__39354_39413 = G__39429;
continue;
} else {
var child_39430 = cljs.core.first(seq__39350_39424__$1);
if(cljs.core.truth_(child_39430)){
node.appendChild(child_39430);


var G__39431 = cljs.core.next(seq__39350_39424__$1);
var G__39432 = null;
var G__39433 = (0);
var G__39434 = (0);
seq__39350_39410 = G__39431;
chunk__39352_39411 = G__39432;
count__39353_39412 = G__39433;
i__39354_39413 = G__39434;
continue;
} else {
var G__39435 = cljs.core.next(seq__39350_39424__$1);
var G__39436 = null;
var G__39437 = (0);
var G__39438 = (0);
seq__39350_39410 = G__39435;
chunk__39352_39411 = G__39436;
count__39353_39412 = G__39437;
i__39354_39413 = G__39438;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_39409);
}
}


var G__39439 = cljs.core.next(seq__39338_39401__$1);
var G__39440 = null;
var G__39441 = (0);
var G__39442 = (0);
seq__39338_39356 = G__39439;
chunk__39340_39357 = G__39440;
count__39341_39358 = G__39441;
i__39342_39359 = G__39442;
continue;
} else {
var G__39443 = cljs.core.next(seq__39338_39401__$1);
var G__39444 = null;
var G__39445 = (0);
var G__39446 = (0);
seq__39338_39356 = G__39443;
chunk__39340_39357 = G__39444;
count__39341_39358 = G__39445;
i__39342_39359 = G__39446;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

var G__39447_39453 = shadow.dom._to_svg;
var G__39448_39454 = "string";
var G__39449_39455 = ((function (G__39447_39453,G__39448_39454){
return (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
});})(G__39447_39453,G__39448_39454))
;
goog.object.set(G__39447_39453,G__39448_39454,G__39449_39455);

cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
});

cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
});

goog.object.set(shadow.dom.SVGElement,"null",true);

var G__39450_39456 = shadow.dom._to_svg;
var G__39451_39457 = "null";
var G__39452_39458 = ((function (G__39450_39456,G__39451_39457){
return (function (_){
return null;
});})(G__39450_39456,G__39451_39457))
;
goog.object.set(G__39450_39456,G__39451_39457,G__39452_39458);
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4534__auto__ = [];
var len__4531__auto___39461 = arguments.length;
var i__4532__auto___39462 = (0);
while(true){
if((i__4532__auto___39462 < len__4531__auto___39461)){
args__4534__auto__.push((arguments[i__4532__auto___39462]));

var G__39463 = (i__4532__auto___39462 + (1));
i__4532__auto___39462 = G__39463;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
});

shadow.dom.svg.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
shadow.dom.svg.cljs$lang$applyTo = (function (seq39459){
var G__39460 = cljs.core.first(seq39459);
var seq39459__$1 = cljs.core.next(seq39459);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__39460,seq39459__$1);
});

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__39465 = arguments.length;
switch (G__39465) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = ((function (buf,chan){
return (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});})(buf,chan))
;
var G__39466_39481 = shadow.dom.dom_node(el);
var G__39467_39482 = cljs.core.name(event);
var G__39468_39483 = event_fn;
(shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__39466_39481,G__39467_39482,G__39468_39483) : shadow.dom.dom_listen.call(null,G__39466_39481,G__39467_39482,G__39468_39483));

if(cljs.core.truth_((function (){var and__3938__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__3938__auto__)){
return !(once_or_cleanup === true);
} else {
return and__3938__auto__;
}
})())){
var c__35868__auto___39484 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__35868__auto___39484,buf,chan,event_fn){
return (function (){
var f__35869__auto__ = (function (){var switch__35726__auto__ = ((function (c__35868__auto___39484,buf,chan,event_fn){
return (function (state_39473){
var state_val_39474 = (state_39473[(1)]);
if((state_val_39474 === (1))){
var state_39473__$1 = state_39473;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39473__$1,(2),once_or_cleanup);
} else {
if((state_val_39474 === (2))){
var inst_39470 = (state_39473[(2)]);
var inst_39471 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_39473__$1 = (function (){var statearr_39475 = state_39473;
(statearr_39475[(7)] = inst_39470);

return statearr_39475;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_39473__$1,inst_39471);
} else {
return null;
}
}
});})(c__35868__auto___39484,buf,chan,event_fn))
;
return ((function (switch__35726__auto__,c__35868__auto___39484,buf,chan,event_fn){
return (function() {
var shadow$dom$state_machine__35727__auto__ = null;
var shadow$dom$state_machine__35727__auto____0 = (function (){
var statearr_39476 = [null,null,null,null,null,null,null,null];
(statearr_39476[(0)] = shadow$dom$state_machine__35727__auto__);

(statearr_39476[(1)] = (1));

return statearr_39476;
});
var shadow$dom$state_machine__35727__auto____1 = (function (state_39473){
while(true){
var ret_value__35728__auto__ = (function (){try{while(true){
var result__35729__auto__ = switch__35726__auto__(state_39473);
if(cljs.core.keyword_identical_QMARK_(result__35729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__35729__auto__;
}
break;
}
}catch (e39477){if((e39477 instanceof Object)){
var ex__35730__auto__ = e39477;
var statearr_39478_39485 = state_39473;
(statearr_39478_39485[(5)] = ex__35730__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_39473);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39477;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__35728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39486 = state_39473;
state_39473 = G__39486;
continue;
} else {
return ret_value__35728__auto__;
}
break;
}
});
shadow$dom$state_machine__35727__auto__ = function(state_39473){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__35727__auto____0.call(this);
case 1:
return shadow$dom$state_machine__35727__auto____1.call(this,state_39473);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__35727__auto____0;
shadow$dom$state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__35727__auto____1;
return shadow$dom$state_machine__35727__auto__;
})()
;})(switch__35726__auto__,c__35868__auto___39484,buf,chan,event_fn))
})();
var state__35870__auto__ = (function (){var statearr_39479 = (f__35869__auto__.cljs$core$IFn$_invoke$arity$0 ? f__35869__auto__.cljs$core$IFn$_invoke$arity$0() : f__35869__auto__.call(null));
(statearr_39479[(6)] = c__35868__auto___39484);

return statearr_39479;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__35870__auto__);
});})(c__35868__auto___39484,buf,chan,event_fn))
);

} else {
}

return chan;
});

shadow.dom.event_chan.cljs$lang$maxFixedArity = 4;


//# sourceMappingURL=shadow.dom.js.map
