goog.provide('wonka.core');
goog.require('cljs.core');
var module$node_modules$glamor$lib$index=shadow.js.require("module$node_modules$glamor$lib$index", {});
goog.require('cljs.spec.alpha');
goog.require('goog.memoize');
goog.require('oops.core');
goog.require('wonka.reset');
wonka.core.CONFIG = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
wonka.core.dash_rgx = /-(.)/g;
wonka.core.upcase = (function wonka$core$upcase(_,s){
return s.toUpperCase();
});
/**
 * Camelcases a hyphenated CSS property name, for example:
 * 
 * > camelizeStyleName('background-color')
 * < "backgroundColor"
 * > camelizeStyleName('-moz-transition')
 * < "MozTransition"
 * > camelizeStyleName('-ms-transition')
 * < "msTransition"
 */
wonka.core.camelize_style_name_STAR_ = (function wonka$core$camelize_style_name_STAR_(style_name){
return cljs.core.name(style_name).replace(wonka.core.dash_rgx,wonka.core.upcase);
});
wonka.core.camelize_style_name = goog.memoize(wonka.core.camelize_style_name_STAR_);
wonka.core.get_theme_var = (function wonka$core$get_theme_var(v){
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"theme","theme",-1247880880).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(wonka.core.CONFIG)),v,cljs.core.PersistentArrayMap.EMPTY);
});
wonka.core.get_theme_prefix = (function wonka$core$get_theme_prefix(){
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.deref(wonka.core.CONFIG),new cljs.core.Keyword(null,"theme-prefix","theme-prefix",228362393),"");
});
wonka.core.theme_rgx = (function wonka$core$theme_rgx(){
return cljs.core.re_pattern(["^",cljs.core.str.cljs$core$IFn$_invoke$arity$1(wonka.core.get_theme_prefix()),"\\.?"].join(''));
});
wonka.core.theme_kw_QMARK_ = (function wonka$core$theme_kw_QMARK_(k){
var and__3938__auto__ = (k instanceof cljs.core.Keyword);
if(and__3938__auto__){
return cljs.core.re_find(wonka.core.theme_rgx(),(function (){var or__3949__auto__ = cljs.core.namespace(k);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return "";
}
})());
} else {
return and__3938__auto__;
}
});
wonka.core.resolve_theme_kw = (function wonka$core$resolve_theme_kw(v){
var resolved_value = wonka.core.get_theme_var(v);
if((resolved_value == null)){
console.log("Could not resolve css rule '",v,"'.");
} else {
}

return resolved_value;
});
/**
 * Recurs down the rule and resolves keywords values in the styleguide.
 */
wonka.core.resolve_rule_values = (function wonka$core$resolve_rule_values(rule){
return cljs.core.persistent_BANG_(cljs.core.reduce_kv((function (acc,k,v){
var rule_key = (((k instanceof cljs.core.Keyword))?(wonka.core.camelize_style_name.cljs$core$IFn$_invoke$arity$1 ? wonka.core.camelize_style_name.cljs$core$IFn$_invoke$arity$1(k) : wonka.core.camelize_style_name.call(null,k)):k);
var rule_val = (cljs.core.truth_(wonka.core.theme_kw_QMARK_(v))?wonka.core.resolve_theme_kw(v):((cljs.core.map_QMARK_(v))?(wonka.core.resolve_rule_values.cljs$core$IFn$_invoke$arity$1 ? wonka.core.resolve_rule_values.cljs$core$IFn$_invoke$arity$1(v) : wonka.core.resolve_rule_values.call(null,v)):v
));
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(acc,rule_key,rule_val);
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),rule));
});
wonka.core.add_label = (function wonka$core$add_label(rule,label){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(rule,new cljs.core.Keyword(null,"label","label",1718410804),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,label));
});
/**
 * Creates and returns a new glamor rule from a CLJ map. Used internally by the
 *   `let-css` macro.
 */
wonka.core.css_rule = (function wonka$core$css_rule(rule,label){
var G__43469 = cljs.core.clj__GT_js(wonka.core.add_label(wonka.core.resolve_rule_values(rule),label));
return module$node_modules$glamor$lib$index.css(G__43469);
});
wonka.core.glamor_QMARK_ = (function wonka$core$glamor_QMARK_(rule){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(goog.typeOf(rule),"object");
});
cljs.spec.alpha.def_impl(new cljs.core.Keyword("wonka.core","glamor?","wonka.core/glamor?",410850827),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("wonka.core","glamor?","wonka.core/glamor?",2051382354,null)),cljs.spec.alpha.and_spec_impl(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("wonka.core","glamor?","wonka.core/glamor?",2051382354,null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [wonka.core.glamor_QMARK_], null),null));
/**
 * Takes a variable number of arguments, which could be:
 * 
 *   - A map of CSS properties
 *   - A glamor object generated by a previous `css` call
 *   - A CSS class name as a string or keyword
 *   - A `nil` value (so we can use `when`s)
 * 
 *   and returns a glamor object or a coll that includes a glamor object and any
 *   CSS class names as strings.
 */
wonka.core.css = (function wonka$core$css(var_args){
var args__4534__auto__ = [];
var len__4531__auto___43473 = arguments.length;
var i__4532__auto___43474 = (0);
while(true){
if((i__4532__auto___43474 < len__4531__auto___43473)){
args__4534__auto__.push((arguments[i__4532__auto___43474]));

var G__43475 = (i__4532__auto___43474 + (1));
i__4532__auto___43474 = G__43475;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return wonka.core.css.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

wonka.core.css.cljs$core$IFn$_invoke$arity$variadic = (function (rules){
if(cljs.core.truth_(cljs.spec.alpha.every_impl.cljs$core$IFn$_invoke$arity$4(new cljs.core.Symbol(null,"string?","string?",-1129175764,null),cljs.core.string_QMARK_,cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),null,cljs.core.keyword_QMARK_,cljs.core.map_QMARK_,new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__43472){
return cljs.core.coll_QMARK_(G__43472);
}),cljs.core.nil_QMARK_,new cljs.core.Keyword("wonka.core","glamor?","wonka.core/glamor?",410850827),new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null),new cljs.core.Symbol(null,"keyword?","keyword?",1917797069,null),new cljs.core.Symbol(null,"map?","map?",-1780568534,null),new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Keyword("wonka.core","glamor?","wonka.core/glamor?",410850827))]),null))){
} else {
throw (new Error("Assert failed: (s/coll-of string? keyword? map? nil? :wonka.core/glamor?)"));
}

var _PERCENT_ = ((cljs.core.empty_QMARK_(rules))?null:(function (){var grouped = cljs.core.group_by((function (p1__43470_SHARP_){
if(((typeof p1__43470_SHARP_ === 'string') || ((p1__43470_SHARP_ instanceof cljs.core.Keyword)))){
return new cljs.core.Keyword(null,"static","static",1214358571);
} else {
if(cljs.core.truth_((function (){var or__3949__auto__ = cljs.core.map_QMARK_(p1__43470_SHARP_);
if(or__3949__auto__){
return or__3949__auto__;
} else {
return wonka.core.glamor_QMARK_(p1__43470_SHARP_);
}
})())){
return new cljs.core.Keyword(null,"processable","processable",-1497305758);
} else {
return new cljs.core.Keyword(null,"drop","drop",364481611);

}
}
}),cljs.core.flatten(rules));
var processed = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(module$node_modules$glamor$lib$index.css,cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (grouped){
return (function (acc,rule){
if(cljs.core.map_QMARK_(rule)){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(acc,wonka.core.css_rule(rule,null));
} else {
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(acc,rule);
}
});})(grouped))
,cljs.core.transient$(cljs.core.PersistentVector.EMPTY),new cljs.core.Keyword(null,"processable","processable",-1497305758).cljs$core$IFn$_invoke$arity$1(grouped))));
if(cljs.core.empty_QMARK_(new cljs.core.Keyword(null,"static","static",1214358571).cljs$core$IFn$_invoke$arity$1(grouped))){
return processed;
} else {
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [processed], null),cljs.core.dedupe.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.name,new cljs.core.Keyword(null,"static","static",1214358571).cljs$core$IFn$_invoke$arity$1(grouped))));
}
})());
if(cljs.core.truth_(cljs.spec.alpha.or_spec_impl(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g","g",1738089905),new cljs.core.Keyword(null,"c","c",-1763192079),new cljs.core.Keyword(null,"n","n",562130025)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("wonka.core","glamor?","wonka.core/glamor?",410850827),new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("wonka.core","glamor?","wonka.core/glamor?",410850827),cljs.core.coll_QMARK_,cljs.core.nil_QMARK_], null),null))){
} else {
throw (new Error("Assert failed: (s/or :g :wonka.core/glamor? :c coll? :n nil?)"));
}

return _PERCENT_;
});

wonka.core.css.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
wonka.core.css.cljs$lang$applyTo = (function (seq43471){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq43471));
});

/**
 * Creates and returns a glamor keyframe definition. Use it inside css:
 * 
 *   (def kf (keyframes {:from {:opacity 0}
 *                    :to   {:opacity 1}}))
 * 
 *   (let-css [class-a {:animation kf}]
 *  [:div {:class class-a}])
 */
wonka.core.keyframes = (function wonka$core$keyframes(timeline){
var target_obj_43487 = module$node_modules$glamor$lib$index.css;
var _STAR_runtime_state_STAR_43494 = oops.state._STAR_runtime_state_STAR_;
oops.state._STAR_runtime_state_STAR_ = oops.state.prepare_state(target_obj_43487,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});

try{var call_info_43489 = [target_obj_43487,(function (){var next_obj_43493 = ((oops.core.validate_object_access_dynamically(target_obj_43487,(0),"keyframes",true,true,false))?(target_obj_43487["keyframes"]):null);
return next_obj_43493;
})()];
var fn_43488 = (call_info_43489[(1)]);
if(oops.core.validate_fn_call_dynamically(fn_43488,oops.state.get_last_access_modifier())){
if(!((fn_43488 == null))){
return fn_43488.call((call_info_43489[(0)]),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("paper_keyframes"),cljs.core.clj__GT_js(wonka.core.resolve_rule_values(timeline)));
} else {
return null;
}
} else {
return null;
}
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR_43494;
}});
wonka.core.insert_global_BANG_ = (function wonka$core$insert_global_BANG_(selector,rule){
var target_obj_43500 = module$node_modules$glamor$lib$index.css;
var _STAR_runtime_state_STAR_43506 = oops.state._STAR_runtime_state_STAR_;
oops.state._STAR_runtime_state_STAR_ = oops.state.prepare_state(target_obj_43500,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});

try{var call_info_43502 = [target_obj_43500,(function (){var next_obj_43503 = ((oops.core.validate_object_access_dynamically(target_obj_43500,(0),"global",true,true,false))?(target_obj_43500["global"]):null);
return next_obj_43503;
})()];
var fn_43501 = (call_info_43502[(1)]);
if(oops.core.validate_fn_call_dynamically(fn_43501,oops.state.get_last_access_modifier())){
if(!((fn_43501 == null))){
return fn_43501.call((call_info_43502[(0)]),cljs.core.name(selector),cljs.core.clj__GT_js(wonka.core.resolve_rule_values(rule)));
} else {
return null;
}
} else {
return null;
}
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR_43506;
}});
/**
 * CSS allows you to specify many shorthand properties as a single string
 *   (ex: `background-image: url(images/bg.gif); background-repeat: no-repeat;`
 *   becomes `background: url(images/bg.gif) no-repeat`). String concat isn't fun
 *   in Clojure, so you can use the paper.core/join to a sequence of properties
 *   into CSS shorthand string. Automatically appends "px" to integers and does
 *   paper namespaced keyword lookups in the styleguide.
 * 
 *   Ex:
 * 
 *   (let-css [x {:background (p/join "url(images/bg.gif)" "no-repeat")}]
 *  [:div {:class x}])
 */
wonka.core.join = (function wonka$core$join(var_args){
var args__4534__auto__ = [];
var len__4531__auto___43519 = arguments.length;
var i__4532__auto___43520 = (0);
while(true){
if((i__4532__auto___43520 < len__4531__auto___43519)){
args__4534__auto__.push((arguments[i__4532__auto___43520]));

var G__43521 = (i__4532__auto___43520 + (1));
i__4532__auto___43520 = G__43521;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return wonka.core.join.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

wonka.core.join.cljs$core$IFn$_invoke$arity$variadic = (function (properties){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
if(cljs.core.integer_QMARK_(x)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"px"].join('');
} else {
if(cljs.core.truth_(wonka.core.theme_kw_QMARK_(x))){
return wonka.core.resolve_theme_kw(x);
} else {
if((x instanceof cljs.core.Keyword)){
return cljs.core.name(x);
} else {
return x;

}
}
}
}),properties)));
});

wonka.core.join.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
wonka.core.join.cljs$lang$applyTo = (function (seq43516){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq43516));
});

wonka.core.config = (function wonka$core$config(p__43534){
var map__43535 = p__43534;
var map__43535__$1 = ((((!((map__43535 == null)))?(((((map__43535.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43535.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43535):map__43535);
var config = map__43535__$1;
var theme_prefix = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43535__$1,new cljs.core.Keyword(null,"theme-prefix","theme-prefix",228362393));
var theme = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43535__$1,new cljs.core.Keyword(null,"theme","theme",-1247880880));
cljs.core.reset_BANG_(wonka.core.CONFIG,config);

return config;
});
wonka.core.insert_BANG_ = (function wonka$core$insert_BANG_(css_str){
var target_obj_43546 = module$node_modules$glamor$lib$index.css;
var _STAR_runtime_state_STAR_43550 = oops.state._STAR_runtime_state_STAR_;
oops.state._STAR_runtime_state_STAR_ = oops.state.prepare_state(target_obj_43546,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});

try{var call_info_43548 = [target_obj_43546,(function (){var next_obj_43549 = ((oops.core.validate_object_access_dynamically(target_obj_43546,(0),"insert",true,true,false))?(target_obj_43546["insert"]):null);
return next_obj_43549;
})()];
var fn_43547 = (call_info_43548[(1)]);
if(oops.core.validate_fn_call_dynamically(fn_43547,oops.state.get_last_access_modifier())){
if(!((fn_43547 == null))){
return fn_43547.call((call_info_43548[(0)]),css_str);
} else {
return null;
}
} else {
return null;
}
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR_43550;
}});
wonka.core.insert_reset_BANG_ = (function wonka$core$insert_reset_BANG_(){
return wonka.core.insert_BANG_(wonka.reset.meyer_reset);
});

//# sourceMappingURL=wonka.core.js.map
