var shadow$provide = {};
var CLOSURE_NO_DEPS = true;
var CLOSURE_BASE_PATH = '/js/compiled/examples/cljs-runtime/';
var CLOSURE_DEFINES = {"shadow.cljs.devtools.client.env.repl_pprint":false,"shadow.cljs.devtools.client.env.devtools_url":"","shadow.cljs.devtools.client.env.autoload":true,"shadow.cljs.devtools.client.env.proc_id":"70044fb3-c350-4814-b9a5-56ceb9e1651a","goog.ENABLE_DEBUG_LOADER":false,"shadow.cljs.devtools.client.env.server_port":9630,"shadow.cljs.devtools.client.env.use_document_host":true,"shadow.cljs.devtools.client.env.module_format":"goog","goog.LOCALE":"en","shadow.cljs.devtools.client.env.build_id":"examples","shadow.js.process.browser":true,"shadow.cljs.devtools.client.env.ignore_warnings":false,"goog.DEBUG":true,"shadow.cljs.devtools.client.env.ssl":false,"shadow.cljs.devtools.client.env.enabled":true,"shadow.cljs.devtools.client.env.server_host":"localhost","goog.TRANSPILE":"never"};
// Copyright 2006 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @fileoverview Bootstrap for the Google JS Library (Closure).
 *
 * In uncompiled mode base.js will attempt to load Closure's deps file, unless
 * the global <code>CLOSURE_NO_DEPS</code> is set to true.  This allows projects
 * to include their own deps file(s) from different locations.
 *
 * Avoid including base.js more than once. This is strictly discouraged and not
 * supported. goog.require(...) won't work properly in that case.
 *
 * @provideGoog
 */


/**
 * @define {boolean} Overridden to true by the compiler.
 */
var COMPILED = false;


/**
 * Base namespace for the Closure library.  Checks to see goog is already
 * defined in the current scope before assigning to prevent clobbering if
 * base.js is loaded more than once.
 *
 * @const
 */
var goog = goog || {};


/**
 * Reference to the global context.  In most cases this will be 'window'.
 */
goog.global = this;


/**
 * A hook for overriding the define values in uncompiled mode.
 *
 * In uncompiled mode, {@code CLOSURE_UNCOMPILED_DEFINES} may be defined before
 * loading base.js.  If a key is defined in {@code CLOSURE_UNCOMPILED_DEFINES},
 * {@code goog.define} will use the value instead of the default value.  This
 * allows flags to be overwritten without compilation (this is normally
 * accomplished with the compiler's "define" flag).
 *
 * Example:
 * <pre>
 *   var CLOSURE_UNCOMPILED_DEFINES = {'goog.DEBUG': false};
 * </pre>
 *
 * @type {Object<string, (string|number|boolean)>|undefined}
 */
goog.global.CLOSURE_UNCOMPILED_DEFINES;


/**
 * A hook for overriding the define values in uncompiled or compiled mode,
 * like CLOSURE_UNCOMPILED_DEFINES but effective in compiled code.  In
 * uncompiled code CLOSURE_UNCOMPILED_DEFINES takes precedence.
 *
 * Also unlike CLOSURE_UNCOMPILED_DEFINES the values must be number, boolean or
 * string literals or the compiler will emit an error.
 *
 * While any @define value may be set, only those set with goog.define will be
 * effective for uncompiled code.
 *
 * Example:
 * <pre>
 *   var CLOSURE_DEFINES = {'goog.DEBUG': false} ;
 * </pre>
 *
 * @type {Object<string, (string|number|boolean)>|undefined}
 */
goog.global.CLOSURE_DEFINES;


/**
 * Returns true if the specified value is not undefined.
 *
 * @param {?} val Variable to test.
 * @return {boolean} Whether variable is defined.
 */
goog.isDef = function(val) {
  // void 0 always evaluates to undefined and hence we do not need to depend on
  // the definition of the global variable named 'undefined'.
  return val !== void 0;
};

/**
 * Returns true if the specified value is a string.
 * @param {?} val Variable to test.
 * @return {boolean} Whether variable is a string.
 */
goog.isString = function(val) {
  return typeof val == 'string';
};


/**
 * Returns true if the specified value is a boolean.
 * @param {?} val Variable to test.
 * @return {boolean} Whether variable is boolean.
 */
goog.isBoolean = function(val) {
  return typeof val == 'boolean';
};


/**
 * Returns true if the specified value is a number.
 * @param {?} val Variable to test.
 * @return {boolean} Whether variable is a number.
 */
goog.isNumber = function(val) {
  return typeof val == 'number';
};


/**
 * Builds an object structure for the provided namespace path, ensuring that
 * names that already exist are not overwritten. For example:
 * "a.b.c" -> a = {};a.b={};a.b.c={};
 * Used by goog.provide and goog.exportSymbol.
 * @param {string} name name of the object that this file defines.
 * @param {*=} opt_object the object to expose at the end of the path.
 * @param {Object=} opt_objectToExportTo The object to add the path to; default
 *     is `goog.global`.
 * @private
 */
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split('.');
  var cur = opt_objectToExportTo || goog.global;

  // Internet Explorer exhibits strange behavior when throwing errors from
  // methods externed in this manner.  See the testExportSymbolExceptions in
  // base_test.html for an example.
  if (!(parts[0] in cur) && cur.execScript) {
    cur.execScript('var ' + parts[0]);
  }

  for (var part; parts.length && (part = parts.shift());) {
    if (!parts.length && goog.isDef(opt_object)) {
      // last part and we have an object; use it
      cur[part] = opt_object;
    } else if (cur[part] && cur[part] !== Object.prototype[part]) {
      cur = cur[part];
    } else {
      cur = cur[part] = {};
    }
  }
};


/**
 * Defines a named value. In uncompiled mode, the value is retrieved from
 * CLOSURE_DEFINES or CLOSURE_UNCOMPILED_DEFINES if the object is defined and
 * has the property specified, and otherwise used the defined defaultValue.
 * When compiled the default can be overridden using the compiler
 * options or the value set in the CLOSURE_DEFINES object.
 *
 * @param {string} name The distinguished name to provide.
 * @param {string|number|boolean} defaultValue
 */
goog.define = function(name, defaultValue) {
  var value = defaultValue;
  if (!COMPILED) {
    if (goog.global.CLOSURE_UNCOMPILED_DEFINES &&
        // Anti DOM-clobbering runtime check (b/37736576).
        /** @type {?} */ (goog.global.CLOSURE_UNCOMPILED_DEFINES).nodeType ===
            undefined &&
        Object.prototype.hasOwnProperty.call(
            goog.global.CLOSURE_UNCOMPILED_DEFINES, name)) {
      value = goog.global.CLOSURE_UNCOMPILED_DEFINES[name];
    } else if (
        goog.global.CLOSURE_DEFINES &&
        // Anti DOM-clobbering runtime check (b/37736576).
        /** @type {?} */ (goog.global.CLOSURE_DEFINES).nodeType === undefined &&
        Object.prototype.hasOwnProperty.call(
            goog.global.CLOSURE_DEFINES, name)) {
      value = goog.global.CLOSURE_DEFINES[name];
    }
  }
  goog.exportPath_(name, value);
};


/**
 * @define {boolean} DEBUG is provided as a convenience so that debugging code
 * that should not be included in a production. It can be easily stripped
 * by specifying --define goog.DEBUG=false to the Closure Compiler aka
 * JSCompiler. For example, most toString() methods should be declared inside an
 * "if (goog.DEBUG)" conditional because they are generally used for debugging
 * purposes and it is difficult for the JSCompiler to statically determine
 * whether they are used.
 */
goog.define('goog.DEBUG', true);


/**
 * @define {string} LOCALE defines the locale being used for compilation. It is
 * used to select locale specific data to be compiled in js binary. BUILD rule
 * can specify this value by "--define goog.LOCALE=<locale_name>" as a compiler
 * option.
 *
 * Take into account that the locale code format is important. You should use
 * the canonical Unicode format with hyphen as a delimiter. Language must be
 * lowercase, Language Script - Capitalized, Region - UPPERCASE.
 * There are few examples: pt-BR, en, en-US, sr-Latin-BO, zh-Hans-CN.
 *
 * See more info about locale codes here:
 * http://www.unicode.org/reports/tr35/#Unicode_Language_and_Locale_Identifiers
 *
 * For language codes you should use values defined by ISO 693-1. See it here
 * http://www.w3.org/WAI/ER/IG/ert/iso639.htm. There is only one exception from
 * this rule: the Hebrew language. For legacy reasons the old code (iw) should
 * be used instead of the new code (he).
 *
 */
goog.define('goog.LOCALE', 'en');  // default to en


/**
 * @define {boolean} Whether this code is running on trusted sites.
 *
 * On untrusted sites, several native functions can be defined or overridden by
 * external libraries like Prototype, Datejs, and JQuery and setting this flag
 * to false forces closure to use its own implementations when possible.
 *
 * If your JavaScript can be loaded by a third party site and you are wary about
 * relying on non-standard implementations, specify
 * "--define goog.TRUSTED_SITE=false" to the compiler.
 */
goog.define('goog.TRUSTED_SITE', true);


/**
 * @define {boolean} Whether a project is expected to be running in strict mode.
 *
 * This define can be used to trigger alternate implementations compatible with
 * running in EcmaScript Strict mode or warn about unavailable functionality.
 * @see https://goo.gl/PudQ4y
 *
 */
goog.define('goog.STRICT_MODE_COMPATIBLE', false);


/**
 * @define {boolean} Whether code that calls {@link goog.setTestOnly} should
 *     be disallowed in the compilation unit.
 */
goog.define('goog.DISALLOW_TEST_ONLY_CODE', COMPILED && !goog.DEBUG);


/**
 * @define {boolean} Whether to use a Chrome app CSP-compliant method for
 *     loading scripts via goog.require. @see appendScriptSrcNode_.
 */
goog.define('goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING', false);


/**
 * Defines a namespace in Closure.
 *
 * A namespace may only be defined once in a codebase. It may be defined using
 * goog.provide() or goog.module().
 *
 * The presence of one or more goog.provide() calls in a file indicates
 * that the file defines the given objects/namespaces.
 * Provided symbols must not be null or undefined.
 *
 * In addition, goog.provide() creates the object stubs for a namespace
 * (for example, goog.provide("goog.foo.bar") will create the object
 * goog.foo.bar if it does not already exist).
 *
 * Build tools also scan for provide/require/module statements
 * to discern dependencies, build dependency files (see deps.js), etc.
 *
 * @see goog.require
 * @see goog.module
 * @param {string} name Namespace provided by this file in the form
 *     "goog.package.part".
 */
goog.provide = function(name) {
  if (goog.isInModuleLoader_()) {
    throw Error('goog.provide can not be used within a goog.module.');
  }
  if (!COMPILED) {
    // Ensure that the same namespace isn't provided twice.
    // A goog.module/goog.provide maps a goog.require to a specific file
    if (goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
  }

  goog.constructNamespace_(name);
};


/**
 * @param {string} name Namespace provided by this file in the form
 *     "goog.package.part".
 * @param {Object=} opt_obj The object to embed in the namespace.
 * @private
 */
goog.constructNamespace_ = function(name, opt_obj) {
  if (!COMPILED) {
    delete goog.implicitNamespaces_[name];

    var namespace = name;
    while ((namespace = namespace.substring(0, namespace.lastIndexOf('.')))) {
      if (goog.getObjectByName(namespace)) {
        break;
      }
      goog.implicitNamespaces_[namespace] = true;
    }
  }

  goog.exportPath_(name, opt_obj);
};


/**
 * Module identifier validation regexp.
 * Note: This is a conservative check, it is very possible to be more lenient,
 *   the primary exclusion here is "/" and "\" and a leading ".", these
 *   restrictions are intended to leave the door open for using goog.require
 *   with relative file paths rather than module identifiers.
 * @private
 */
goog.VALID_MODULE_RE_ = /^[a-zA-Z_$][a-zA-Z0-9._$]*$/;


/**
 * Defines a module in Closure.
 *
 * Marks that this file must be loaded as a module and claims the namespace.
 *
 * A namespace may only be defined once in a codebase. It may be defined using
 * goog.provide() or goog.module().
 *
 * goog.module() has three requirements:
 * - goog.module may not be used in the same file as goog.provide.
 * - goog.module must be the first statement in the file.
 * - only one goog.module is allowed per file.
 *
 * When a goog.module annotated file is loaded, it is enclosed in
 * a strict function closure. This means that:
 * - any variables declared in a goog.module file are private to the file
 * (not global), though the compiler is expected to inline the module.
 * - The code must obey all the rules of "strict" JavaScript.
 * - the file will be marked as "use strict"
 *
 * NOTE: unlike goog.provide, goog.module does not declare any symbols by
 * itself. If declared symbols are desired, use
 * goog.module.declareLegacyNamespace().
 *
 *
 * See the public goog.module proposal: http://goo.gl/Va1hin
 *
 * @param {string} name Namespace provided by this file in the form
 *     "goog.package.part", is expected but not required.
 * @return {void}
 */
goog.module = function(name) {
  if (!goog.isString(name) || !name ||
      name.search(goog.VALID_MODULE_RE_) == -1) {
    throw Error('Invalid module identifier');
  }
  if (!goog.isInModuleLoader_()) {
    throw Error(
        'Module ' + name + ' has been loaded incorrectly. Note, ' +
        'modules cannot be loaded as normal scripts. They require some kind of ' +
        'pre-processing step. You\'re likely trying to load a module via a ' +
        'script tag or as a part of a concatenated bundle without rewriting the ' +
        'module. For more info see: ' +
        'https://github.com/google/closure-library/wiki/goog.module:-an-ES6-module-like-alternative-to-goog.provide.');
  }
  if (goog.moduleLoaderState_.moduleName) {
    throw Error('goog.module may only be called once per module.');
  }

  // Store the module name for the loader.
  goog.moduleLoaderState_.moduleName = name;
  if (!COMPILED) {
    // Ensure that the same namespace isn't provided twice.
    // A goog.module/goog.provide maps a goog.require to a specific file
    if (goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
    delete goog.implicitNamespaces_[name];
  }
};


/**
 * @param {string} name The module identifier.
 * @return {?} The module exports for an already loaded module or null.
 *
 * Note: This is not an alternative to goog.require, it does not
 * indicate a hard dependency, instead it is used to indicate
 * an optional dependency or to access the exports of a module
 * that has already been loaded.
 * @suppress {missingProvide}
 */
goog.module.get = function(name) {
  return goog.module.getInternal_(name);
};


/**
 * @param {string} name The module identifier.
 * @return {?} The module exports for an already loaded module or null.
 * @private
 */
goog.module.getInternal_ = function(name) {
  if (!COMPILED) {
    if (name in goog.loadedModules_) {
      return goog.loadedModules_[name];
    } else if (!goog.implicitNamespaces_[name]) {
      var ns = goog.getObjectByName(name);
      return ns != null ? ns : null;
    }
  }
  return null;
};


/**
 * @private {?{moduleName: (string|undefined), declareLegacyNamespace:boolean}}
 */
goog.moduleLoaderState_ = null;


/**
 * @private
 * @return {boolean} Whether a goog.module is currently being initialized.
 */
goog.isInModuleLoader_ = function() {
  return goog.moduleLoaderState_ != null;
};


/**
 * Provide the module's exports as a globally accessible object under the
 * module's declared name.  This is intended to ease migration to goog.module
 * for files that have existing usages.
 * @suppress {missingProvide}
 */
goog.module.declareLegacyNamespace = function() {
  if (!COMPILED && !goog.isInModuleLoader_()) {
    throw new Error(
        'goog.module.declareLegacyNamespace must be called from ' +
        'within a goog.module');
  }
  if (!COMPILED && !goog.moduleLoaderState_.moduleName) {
    throw Error(
        'goog.module must be called prior to ' +
        'goog.module.declareLegacyNamespace.');
  }
  goog.moduleLoaderState_.declareLegacyNamespace = true;
};


/**
 * Marks that the current file should only be used for testing, and never for
 * live code in production.
 *
 * In the case of unit tests, the message may optionally be an exact namespace
 * for the test (e.g. 'goog.stringTest'). The linter will then ignore the extra
 * provide (if not explicitly defined in the code).
 *
 * @param {string=} opt_message Optional message to add to the error that's
 *     raised when used in production code.
 */
goog.setTestOnly = function(opt_message) {
  if (goog.DISALLOW_TEST_ONLY_CODE) {
    opt_message = opt_message || '';
    throw Error(
        'Importing test-only code into non-debug environment' +
        (opt_message ? ': ' + opt_message : '.'));
  }
};


/**
 * Forward declares a symbol. This is an indication to the compiler that the
 * symbol may be used in the source yet is not required and may not be provided
 * in compilation.
 *
 * The most common usage of forward declaration is code that takes a type as a
 * function parameter but does not need to require it. By forward declaring
 * instead of requiring, no hard dependency is made, and (if not required
 * elsewhere) the namespace may never be required and thus, not be pulled
 * into the JavaScript binary. If it is required elsewhere, it will be type
 * checked as normal.
 *
 * Before using goog.forwardDeclare, please read the documentation at
 * https://github.com/google/closure-compiler/wiki/Bad-Type-Annotation to
 * understand the options and tradeoffs when working with forward declarations.
 *
 * @param {string} name The namespace to forward declare in the form of
 *     "goog.package.part".
 */
goog.forwardDeclare = function(name) {};


/**
 * Forward declare type information. Used to assign types to goog.global
 * referenced object that would otherwise result in unknown type references
 * and thus block property disambiguation.
 */
goog.forwardDeclare('Document');
goog.forwardDeclare('HTMLScriptElement');
goog.forwardDeclare('XMLHttpRequest');


if (!COMPILED) {
  /**
   * Check if the given name has been goog.provided. This will return false for
   * names that are available only as implicit namespaces.
   * @param {string} name name of the object to look for.
   * @return {boolean} Whether the name has been provided.
   * @private
   */
  goog.isProvided_ = function(name) {
    return (name in goog.loadedModules_) ||
        (!goog.implicitNamespaces_[name] &&
         goog.isDefAndNotNull(goog.getObjectByName(name)));
  };

  /**
   * Namespaces implicitly defined by goog.provide. For example,
   * goog.provide('goog.events.Event') implicitly declares that 'goog' and
   * 'goog.events' must be namespaces.
   *
   * @type {!Object<string, (boolean|undefined)>}
   * @private
   */
  goog.implicitNamespaces_ = {'goog.module': true};

  // NOTE: We add goog.module as an implicit namespace as goog.module is defined
  // here and because the existing module package has not been moved yet out of
  // the goog.module namespace. This satisifies both the debug loader and
  // ahead-of-time dependency management.
}


/**
 * Returns an object based on its fully qualified external name.  The object
 * is not found if null or undefined.  If you are using a compilation pass that
 * renames property names beware that using this function will not find renamed
 * properties.
 *
 * @param {string} name The fully qualified name.
 * @param {Object=} opt_obj The object within which to look; default is
 *     |goog.global|.
 * @return {?} The value (object or primitive) or, if not found, null.
 */
goog.getObjectByName = function(name, opt_obj) {
  var parts = name.split('.');
  var cur = opt_obj || goog.global;
  for (var part; part = parts.shift();) {
    if (goog.isDefAndNotNull(cur[part])) {
      cur = cur[part];
    } else {
      return null;
    }
  }
  return cur;
};


/**
 * Globalizes a whole namespace, such as goog or goog.lang.
 *
 * @param {!Object} obj The namespace to globalize.
 * @param {Object=} opt_global The object to add the properties to.
 * @deprecated Properties may be explicitly exported to the global scope, but
 *     this should no longer be done in bulk.
 */
goog.globalize = function(obj, opt_global) {
  var global = opt_global || goog.global;
  for (var x in obj) {
    global[x] = obj[x];
  }
};


/**
 * Adds a dependency from a file to the files it requires.
 * @param {string} relPath The path to the js file.
 * @param {!Array<string>} provides An array of strings with
 *     the names of the objects this file provides.
 * @param {!Array<string>} requires An array of strings with
 *     the names of the objects this file requires.
 * @param {boolean|!Object<string>=} opt_loadFlags Parameters indicating
 *     how the file must be loaded.  The boolean 'true' is equivalent
 *     to {'module': 'goog'} for backwards-compatibility.  Valid properties
 *     and values include {'module': 'goog'} and {'lang': 'es6'}.
 */
goog.addDependency = function(relPath, provides, requires, opt_loadFlags) {
  if (goog.DEPENDENCIES_ENABLED) {
    var provide, require;
    var path = relPath.replace(/\\/g, '/');
    var deps = goog.dependencies_;
    if (!opt_loadFlags || typeof opt_loadFlags === 'boolean') {
      opt_loadFlags = opt_loadFlags ? {'module': 'goog'} : {};
    }
    for (var i = 0; provide = provides[i]; i++) {
      deps.nameToPath[provide] = path;
      deps.loadFlags[path] = opt_loadFlags;
    }
    for (var j = 0; require = requires[j]; j++) {
      if (!(path in deps.requires)) {
        deps.requires[path] = {};
      }
      deps.requires[path][require] = true;
    }
  }
};




// NOTE(nnaze): The debug DOM loader was included in base.js as an original way
// to do "debug-mode" development.  The dependency system can sometimes be
// confusing, as can the debug DOM loader's asynchronous nature.
//
// With the DOM loader, a call to goog.require() is not blocking -- the script
// will not load until some point after the current script.  If a namespace is
// needed at runtime, it needs to be defined in a previous script, or loaded via
// require() with its registered dependencies.
//
// User-defined namespaces may need their own deps file. For a reference on
// creating a deps file, see:
// Externally: https://developers.google.com/closure/library/docs/depswriter
//
// Because of legacy clients, the DOM loader can't be easily removed from
// base.js.  Work was done to make it disableable or replaceable for
// different environments (DOM-less JavaScript interpreters like Rhino or V8,
// for example). See bootstrap/ for more information.


/**
 * @define {boolean} Whether to enable the debug loader.
 *
 * If enabled, a call to goog.require() will attempt to load the namespace by
 * appending a script tag to the DOM (if the namespace has been registered).
 *
 * If disabled, goog.require() will simply assert that the namespace has been
 * provided (and depend on the fact that some outside tool correctly ordered
 * the script).
 */
goog.define('goog.ENABLE_DEBUG_LOADER', true);


/**
 * @param {string} msg
 * @private
 */
goog.logToConsole_ = function(msg) {
  if (goog.global.console) {
    goog.global.console['error'](msg);
  }
};


/**
 * Implements a system for the dynamic resolution of dependencies that works in
 * parallel with the BUILD system. Note that all calls to goog.require will be
 * stripped by the compiler.
 * @see goog.provide
 * @param {string} name Namespace to include (as was given in goog.provide()) in
 *     the form "goog.package.part".
 * @return {?} If called within a goog.module file, the associated namespace or
 *     module otherwise null.
 */
goog.require = function(name) {
  // If the object already exists we do not need to do anything.
  if (!COMPILED) {
    if (goog.ENABLE_DEBUG_LOADER && goog.IS_OLD_IE_) {
      goog.maybeProcessDeferredDep_(name);
    }

    if (goog.isProvided_(name)) {
      if (goog.isInModuleLoader_()) {
        return goog.module.getInternal_(name);
      }
    } else if (goog.ENABLE_DEBUG_LOADER) {
      var path = goog.getPathFromDeps_(name);
      if (path) {
        goog.writeScripts_(path);
      } else {
        var errorMessage = 'goog.require could not find: ' + name;
        goog.logToConsole_(errorMessage);

        throw Error(errorMessage);
      }
    }

    return null;
  }
};


/**
 * Path for included scripts.
 * @type {string}
 */
goog.basePath = '';


/**
 * A hook for overriding the base path.
 * @type {string|undefined}
 */
goog.global.CLOSURE_BASE_PATH;


/**
 * Whether to attempt to load Closure's deps file. By default, when uncompiled,
 * deps files will attempt to be loaded.
 * @type {boolean|undefined}
 */
goog.global.CLOSURE_NO_DEPS;


/**
 * A function to import a single script. This is meant to be overridden when
 * Closure is being run in non-HTML contexts, such as web workers. It's defined
 * in the global scope so that it can be set before base.js is loaded, which
 * allows deps.js to be imported properly.
 *
 * The function is passed the script source, which is a relative URI. It should
 * return true if the script was imported, false otherwise.
 * @type {(function(string): boolean)|undefined}
 */
goog.global.CLOSURE_IMPORT_SCRIPT;


/**
 * Null function used for default values of callbacks, etc.
 * @return {void} Nothing.
 */
goog.nullFunction = function() {};


/**
 * When defining a class Foo with an abstract method bar(), you can do:
 * Foo.prototype.bar = goog.abstractMethod
 *
 * Now if a subclass of Foo fails to override bar(), an error will be thrown
 * when bar() is invoked.
 *
 * @type {!Function}
 * @throws {Error} when invoked to indicate the method should be overridden.
 */
goog.abstractMethod = function() {
  throw Error('unimplemented abstract method');
};


/**
 * Adds a {@code getInstance} static method that always returns the same
 * instance object.
 * @param {!Function} ctor The constructor for the class to add the static
 *     method to.
 */
goog.addSingletonGetter = function(ctor) {
  // instance_ is immediately set to prevent issues with sealed constructors
  // such as are encountered when a constructor is returned as the export object
  // of a goog.module in unoptimized code.
  ctor.instance_ = undefined;
  ctor.getInstance = function() {
    if (ctor.instance_) {
      return ctor.instance_;
    }
    if (goog.DEBUG) {
      // NOTE: JSCompiler can't optimize away Array#push.
      goog.instantiatedSingletons_[goog.instantiatedSingletons_.length] = ctor;
    }
    return ctor.instance_ = new ctor;
  };
};


/**
 * All singleton classes that have been instantiated, for testing. Don't read
 * it directly, use the {@code goog.testing.singleton} module. The compiler
 * removes this variable if unused.
 * @type {!Array<!Function>}
 * @private
 */
goog.instantiatedSingletons_ = [];


/**
 * @define {boolean} Whether to load goog.modules using {@code eval} when using
 * the debug loader.  This provides a better debugging experience as the
 * source is unmodified and can be edited using Chrome Workspaces or similar.
 * However in some environments the use of {@code eval} is banned
 * so we provide an alternative.
 */
goog.define('goog.LOAD_MODULE_USING_EVAL', true);


/**
 * @define {boolean} Whether the exports of goog.modules should be sealed when
 * possible.
 */
goog.define('goog.SEAL_MODULE_EXPORTS', goog.DEBUG);


/**
 * The registry of initialized modules:
 * the module identifier to module exports map.
 * @private @const {!Object<string, ?>}
 */
goog.loadedModules_ = {};


/**
 * True if goog.dependencies_ is available.
 * @const {boolean}
 */
goog.DEPENDENCIES_ENABLED = !COMPILED && goog.ENABLE_DEBUG_LOADER;


/**
 * @define {string} How to decide whether to transpile.  Valid values
 * are 'always', 'never', and 'detect'.  The default ('detect') is to
 * use feature detection to determine which language levels need
 * transpilation.
 */
// NOTE(user): we could expand this to accept a language level to bypass
// detection: e.g. goog.TRANSPILE == 'es5' would transpile ES6 files but
// would leave ES3 and ES5 files alone.
goog.define('goog.TRANSPILE', 'detect');


/**
 * @define {string} Path to the transpiler.  Executing the script at this
 * path (relative to base.js) should define a function $jscomp.transpile.
 */
goog.define('goog.TRANSPILER', 'transpile.js');


if (goog.DEPENDENCIES_ENABLED) {
  /**
   * This object is used to keep track of dependencies and other data that is
   * used for loading scripts.
   * @private
   * @type {{
   *   loadFlags: !Object<string, !Object<string, string>>,
   *   nameToPath: !Object<string, string>,
   *   requires: !Object<string, !Object<string, boolean>>,
   *   visited: !Object<string, boolean>,
   *   written: !Object<string, boolean>,
   *   deferred: !Object<string, string>
   * }}
   */
  goog.dependencies_ = {
    loadFlags: {},  // 1 to 1

    nameToPath: {},  // 1 to 1

    requires: {},  // 1 to many

    // Used when resolving dependencies to prevent us from visiting file twice.
    visited: {},

    written: {},  // Used to keep track of script files we have written.

    deferred: {}  // Used to track deferred module evaluations in old IEs
  };


  /**
   * Tries to detect whether is in the context of an HTML document.
   * @return {boolean} True if it looks like HTML document.
   * @private
   */
  goog.inHtmlDocument_ = function() {
    /** @type {Document} */
    var doc = goog.global.document;
    return doc != null && 'write' in doc;  // XULDocument misses write.
  };


  /**
   * Tries to detect the base path of base.js script that bootstraps Closure.
   * @private
   */
  goog.findBasePath_ = function() {
    if (goog.isDef(goog.global.CLOSURE_BASE_PATH) &&
        // Anti DOM-clobbering runtime check (b/37736576).
        goog.isString(goog.global.CLOSURE_BASE_PATH)) {
      goog.basePath = goog.global.CLOSURE_BASE_PATH;
      return;
    } else if (!goog.inHtmlDocument_()) {
      return;
    }
    /** @type {Document} */
    var doc = goog.global.document;
    // If we have a currentScript available, use it exclusively.
    var currentScript = doc.currentScript;
    if (currentScript) {
      var scripts = [currentScript];
    } else {
      var scripts = doc.getElementsByTagName('SCRIPT');
    }
    // Search backwards since the current script is in almost all cases the one
    // that has base.js.
    for (var i = scripts.length - 1; i >= 0; --i) {
      var script = /** @type {!HTMLScriptElement} */ (scripts[i]);
      var src = script.src;
      var qmark = src.lastIndexOf('?');
      var l = qmark == -1 ? src.length : qmark;
      if (src.substr(l - 7, 7) == 'base.js') {
        goog.basePath = src.substr(0, l - 7);
        return;
      }
    }
  };


  /**
   * Imports a script if, and only if, that script hasn't already been imported.
   * (Must be called at execution time)
   * @param {string} src Script source.
   * @param {string=} opt_sourceText The optionally source text to evaluate
   * @private
   */
  goog.importScript_ = function(src, opt_sourceText) {
    var importScript =
        goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    if (importScript(src, opt_sourceText)) {
      goog.dependencies_.written[src] = true;
    }
  };


  /**
   * Whether the browser is IE9 or earlier, which needs special handling
   * for deferred modules.
   * @const @private {boolean}
   */
  goog.IS_OLD_IE_ =
      !!(!goog.global.atob && goog.global.document && goog.global.document.all);


  /**
   * Whether IE9 or earlier is waiting on a dependency.  This ensures that
   * deferred modules that have no non-deferred dependencies actually get
   * loaded, since if we defer them and then never pull in a non-deferred
   * script, then `goog.loadQueuedModules_` will never be called.  Instead,
   * if not waiting on anything we simply don't defer in the first place.
   * @private {boolean}
   */
  goog.oldIeWaiting_ = false;


  /**
   * Given a URL initiate retrieval and execution of a script that needs
   * pre-processing.
   * @param {string} src Script source URL.
   * @param {boolean} isModule Whether this is a goog.module.
   * @param {boolean} needsTranspile Whether this source needs transpilation.
   * @private
   */
  goog.importProcessedScript_ = function(src, isModule, needsTranspile) {
    // In an attempt to keep browsers from timing out loading scripts using
    // synchronous XHRs, put each load in its own script block.
    var bootstrap = 'goog.retrieveAndExec_("' + src + '", ' + isModule + ', ' +
        needsTranspile + ');';

    goog.importScript_('', bootstrap);
  };


  /** @private {!Array<string>} */
  goog.queuedModules_ = [];


  /**
   * Return an appropriate module text. Suitable to insert into
   * a script tag (that is unescaped).
   * @param {string} srcUrl
   * @param {string} scriptText
   * @return {string}
   * @private
   */
  goog.wrapModule_ = function(srcUrl, scriptText) {
    if (!goog.LOAD_MODULE_USING_EVAL || !goog.isDef(goog.global.JSON)) {
      return '' +
          'goog.loadModule(function(exports) {' +
          '"use strict";' + scriptText +
          '\n' +  // terminate any trailing single line comment.
          ';return exports' +
          '});' +
          '\n//# sourceURL=' + srcUrl + '\n';
    } else {
      return '' +
          'goog.loadModule(' +
          goog.global.JSON.stringify(
              scriptText + '\n//# sourceURL=' + srcUrl + '\n') +
          ');';
    }
  };

  // On IE9 and earlier, it is necessary to handle
  // deferred module loads. In later browsers, the
  // code to be evaluated is simply inserted as a script
  // block in the correct order. To eval deferred
  // code at the right time, we piggy back on goog.require to call
  // goog.maybeProcessDeferredDep_.
  //
  // The goog.requires are used both to bootstrap
  // the loading process (when no deps are available) and
  // declare that they should be available.
  //
  // Here we eval the sources, if all the deps are available
  // either already eval'd or goog.require'd.  This will
  // be the case when all the dependencies have already
  // been loaded, and the dependent module is loaded.
  //
  // But this alone isn't sufficient because it is also
  // necessary to handle the case where there is no root
  // that is not deferred.  For that there we register for an event
  // and trigger goog.loadQueuedModules_ handle any remaining deferred
  // evaluations.

  /**
   * Handle any remaining deferred goog.module evals.
   * @private
   */
  goog.loadQueuedModules_ = function() {
    var count = goog.queuedModules_.length;
    if (count > 0) {
      var queue = goog.queuedModules_;
      goog.queuedModules_ = [];
      for (var i = 0; i < count; i++) {
        var path = queue[i];
        goog.maybeProcessDeferredPath_(path);
      }
    }
    goog.oldIeWaiting_ = false;
  };


  /**
   * Eval the named module if its dependencies are
   * available.
   * @param {string} name The module to load.
   * @private
   */
  goog.maybeProcessDeferredDep_ = function(name) {
    if (goog.isDeferredModule_(name) && goog.allDepsAreAvailable_(name)) {
      var path = goog.getPathFromDeps_(name);
      goog.maybeProcessDeferredPath_(goog.basePath + path);
    }
  };

  /**
   * @param {string} name The module to check.
   * @return {boolean} Whether the name represents a
   *     module whose evaluation has been deferred.
   * @private
   */
  goog.isDeferredModule_ = function(name) {
    var path = goog.getPathFromDeps_(name);
    var loadFlags = path && goog.dependencies_.loadFlags[path] || {};
    var languageLevel = loadFlags['lang'] || 'es3';
    if (path && (loadFlags['module'] == 'goog' ||
                 goog.needsTranspile_(languageLevel))) {
      var abspath = goog.basePath + path;
      return (abspath) in goog.dependencies_.deferred;
    }
    return false;
  };

  /**
   * @param {string} name The module to check.
   * @return {boolean} Whether the name represents a
   *     module whose declared dependencies have all been loaded
   *     (eval'd or a deferred module load)
   * @private
   */
  goog.allDepsAreAvailable_ = function(name) {
    var path = goog.getPathFromDeps_(name);
    if (path && (path in goog.dependencies_.requires)) {
      for (var requireName in goog.dependencies_.requires[path]) {
        if (!goog.isProvided_(requireName) &&
            !goog.isDeferredModule_(requireName)) {
          return false;
        }
      }
    }
    return true;
  };


  /**
   * @param {string} abspath
   * @private
   */
  goog.maybeProcessDeferredPath_ = function(abspath) {
    if (abspath in goog.dependencies_.deferred) {
      var src = goog.dependencies_.deferred[abspath];
      delete goog.dependencies_.deferred[abspath];
      goog.globalEval(src);
    }
  };


  /**
   * Load a goog.module from the provided URL.  This is not a general purpose
   * code loader and does not support late loading code, that is it should only
   * be used during page load. This method exists to support unit tests and
   * "debug" loaders that would otherwise have inserted script tags. Under the
   * hood this needs to use a synchronous XHR and is not recommeneded for
   * production code.
   *
   * The module's goog.requires must have already been satisified; an exception
   * will be thrown if this is not the case. This assumption is that no
   * "deps.js" file exists, so there is no way to discover and locate the
   * module-to-be-loaded's dependencies and no attempt is made to do so.
   *
   * There should only be one attempt to load a module.  If
   * "goog.loadModuleFromUrl" is called for an already loaded module, an
   * exception will be throw.
   *
   * @param {string} url The URL from which to attempt to load the goog.module.
   */
  goog.loadModuleFromUrl = function(url) {
    // Because this executes synchronously, we don't need to do any additional
    // bookkeeping. When "goog.loadModule" the namespace will be marked as
    // having been provided which is sufficient.
    goog.retrieveAndExec_(url, true, false);
  };


  /**
   * Writes a new script pointing to {@code src} directly into the DOM.
   *
   * NOTE: This method is not CSP-compliant. @see goog.appendScriptSrcNode_ for
   * the fallback mechanism.
   *
   * @param {string} src The script URL.
   * @private
   */
  goog.writeScriptSrcNode_ = function(src) {
    goog.global.document.write(
        '<script type="text/javascript" src="' + src + '"></' +
        'script>');
  };


  /**
   * Appends a new script node to the DOM using a CSP-compliant mechanism. This
   * method exists as a fallback for document.write (which is not allowed in a
   * strict CSP context, e.g., Chrome apps).
   *
   * NOTE: This method is not analogous to using document.write to insert a
   * <script> tag; specifically, the user agent will execute a script added by
   * document.write immediately after the current script block finishes
   * executing, whereas the DOM-appended script node will not be executed until
   * the entire document is parsed and executed. That is to say, this script is
   * added to the end of the script execution queue.
   *
   * The page must not attempt to call goog.required entities until after the
   * document has loaded, e.g., in or after the window.onload callback.
   *
   * @param {string} src The script URL.
   * @private
   */
  goog.appendScriptSrcNode_ = function(src) {
    /** @type {Document} */
    var doc = goog.global.document;
    var scriptEl =
        /** @type {HTMLScriptElement} */ (doc.createElement('script'));
    scriptEl.type = 'text/javascript';
    scriptEl.src = src;
    scriptEl.defer = false;
    scriptEl.async = false;
    doc.head.appendChild(scriptEl);
  };


  /**
   * The default implementation of the import function. Writes a script tag to
   * import the script.
   *
   * @param {string} src The script url.
   * @param {string=} opt_sourceText The optionally source text to evaluate
   * @return {boolean} True if the script was imported, false otherwise.
   * @private
   */
  goog.writeScriptTag_ = function(src, opt_sourceText) {
    if (goog.inHtmlDocument_()) {
      /** @type {!HTMLDocument} */
      var doc = goog.global.document;

      // If the user tries to require a new symbol after document load,
      // something has gone terribly wrong. Doing a document.write would
      // wipe out the page. This does not apply to the CSP-compliant method
      // of writing script tags.
      if (!goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING &&
          doc.readyState == 'complete') {
        // Certain test frameworks load base.js multiple times, which tries
        // to write deps.js each time. If that happens, just fail silently.
        // These frameworks wipe the page between each load of base.js, so this
        // is OK.
        var isDeps = /\bdeps.js$/.test(src);
        if (isDeps) {
          return false;
        } else {
          throw Error('Cannot write "' + src + '" after document load');
        }
      }

      if (opt_sourceText === undefined) {
        if (!goog.IS_OLD_IE_) {
          if (goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING) {
            goog.appendScriptSrcNode_(src);
          } else {
            goog.writeScriptSrcNode_(src);
          }
        } else {
          goog.oldIeWaiting_ = true;
          var state = ' onreadystatechange=\'goog.onScriptLoad_(this, ' +
              ++goog.lastNonModuleScriptIndex_ + ')\' ';
          doc.write(
              '<script type="text/javascript" src="' + src + '"' + state +
              '></' +
              'script>');
        }
      } else {
        doc.write(
            '<script type="text/javascript">' +
            goog.protectScriptTag_(opt_sourceText) + '</' +
            'script>');
      }
      return true;
    } else {
      return false;
    }
  };

  /**
   * Rewrites closing script tags in input to avoid ending an enclosing script
   * tag.
   *
   * @param {string} str
   * @return {string}
   * @private
   */
  goog.protectScriptTag_ = function(str) {
    return str.replace(/<\/(SCRIPT)/ig, '\\x3c/$1');
  };

  /**
   * Determines whether the given language needs to be transpiled.
   * @param {string} lang
   * @return {boolean}
   * @private
   */
  goog.needsTranspile_ = function(lang) {
    if (goog.TRANSPILE == 'always') {
      return true;
    } else if (goog.TRANSPILE == 'never') {
      return false;
    } else if (!goog.requiresTranspilation_) {
      goog.requiresTranspilation_ = goog.createRequiresTranspilation_();
    }
    if (lang in goog.requiresTranspilation_) {
      return goog.requiresTranspilation_[lang];
    } else {
      throw new Error('Unknown language mode: ' + lang);
    }
  };

  /** @private {?Object<string, boolean>} */
  goog.requiresTranspilation_ = null;


  /** @private {number} */
  goog.lastNonModuleScriptIndex_ = 0;


  /**
   * A readystatechange handler for legacy IE
   * @param {?} script
   * @param {number} scriptIndex
   * @return {boolean}
   * @private
   */
  goog.onScriptLoad_ = function(script, scriptIndex) {
    // for now load the modules when we reach the last script,
    // later allow more inter-mingling.
    if (script.readyState == 'complete' &&
        goog.lastNonModuleScriptIndex_ == scriptIndex) {
      goog.loadQueuedModules_();
    }
    return true;
  };

  /**
   * Resolves dependencies based on the dependencies added using addDependency
   * and calls importScript_ in the correct order.
   * @param {string} pathToLoad The path from which to start discovering
   *     dependencies.
   * @private
   */
  goog.writeScripts_ = function(pathToLoad) {
    /** @type {!Array<string>} The scripts we need to write this time. */
    var scripts = [];
    var seenScript = {};
    var deps = goog.dependencies_;

    /** @param {string} path */
    function visitNode(path) {
      if (path in deps.written) {
        return;
      }

      // We have already visited this one. We can get here if we have cyclic
      // dependencies.
      if (path in deps.visited) {
        return;
      }

      deps.visited[path] = true;

      if (path in deps.requires) {
        for (var requireName in deps.requires[path]) {
          // If the required name is defined, we assume that it was already
          // bootstrapped by other means.
          if (!goog.isProvided_(requireName)) {
            if (requireName in deps.nameToPath) {
              visitNode(deps.nameToPath[requireName]);
            } else {
              throw Error('Undefined nameToPath for ' + requireName);
            }
          }
        }
      }

      if (!(path in seenScript)) {
        seenScript[path] = true;
        scripts.push(path);
      }
    }

    visitNode(pathToLoad);

    // record that we are going to load all these scripts.
    for (var i = 0; i < scripts.length; i++) {
      var path = scripts[i];
      goog.dependencies_.written[path] = true;
    }

    // If a module is loaded synchronously then we need to
    // clear the current inModuleLoader value, and restore it when we are
    // done loading the current "requires".
    var moduleState = goog.moduleLoaderState_;
    goog.moduleLoaderState_ = null;

    for (var i = 0; i < scripts.length; i++) {
      var path = scripts[i];
      if (path) {
        var loadFlags = deps.loadFlags[path] || {};
        var languageLevel = loadFlags['lang'] || 'es3';
        var needsTranspile = goog.needsTranspile_(languageLevel);
        if (loadFlags['module'] == 'goog' || needsTranspile) {
          goog.importProcessedScript_(
              goog.basePath + path, loadFlags['module'] == 'goog',
              needsTranspile);
        } else {
          goog.importScript_(goog.basePath + path);
        }
      } else {
        goog.moduleLoaderState_ = moduleState;
        throw Error('Undefined script input');
      }
    }

    // restore the current "module loading state"
    goog.moduleLoaderState_ = moduleState;
  };


  /**
   * Looks at the dependency rules and tries to determine the script file that
   * fulfills a particular rule.
   * @param {string} rule In the form goog.namespace.Class or project.script.
   * @return {?string} Url corresponding to the rule, or null.
   * @private
   */
  goog.getPathFromDeps_ = function(rule) {
    if (rule in goog.dependencies_.nameToPath) {
      return goog.dependencies_.nameToPath[rule];
    } else {
      return null;
    }
  };

  goog.findBasePath_();

  // Allow projects to manage the deps files themselves.
  if (!goog.global.CLOSURE_NO_DEPS) {
    goog.importScript_(goog.basePath + 'deps.js');
  }
}


/**
 * @package {?boolean}
 * Visible for testing.
 */
goog.hasBadLetScoping = null;


/**
 * @return {boolean}
 * @package Visible for testing.
 */
goog.useSafari10Workaround = function() {
  if (goog.hasBadLetScoping == null) {
    var hasBadLetScoping;
    try {
      hasBadLetScoping = !eval(
          '"use strict";' +
          'let x = 1; function f() { return typeof x; };' +
          'f() == "number";');
    } catch (e) {
      // Assume that ES6 syntax isn't supported.
      hasBadLetScoping = false;
    }
    goog.hasBadLetScoping = hasBadLetScoping;
  }
  return goog.hasBadLetScoping;
};


/**
 * @param {string} moduleDef
 * @return {string}
 * @package Visible for testing.
 */
goog.workaroundSafari10EvalBug = function(moduleDef) {
  return '(function(){' + moduleDef +
      '\n' +  // Terminate any trailing single line comment.
      ';' +   // Terminate any trailing expression.
      '})();\n';
};


/**
 * @param {function(?):?|string} moduleDef The module definition.
 */
goog.loadModule = function(moduleDef) {
  // NOTE: we allow function definitions to be either in the from
  // of a string to eval (which keeps the original source intact) or
  // in a eval forbidden environment (CSP) we allow a function definition
  // which in its body must call {@code goog.module}, and return the exports
  // of the module.
  var previousState = goog.moduleLoaderState_;
  try {
    goog.moduleLoaderState_ = {
      moduleName: undefined,
      declareLegacyNamespace: false
    };
    var exports;
    if (goog.isFunction(moduleDef)) {
      exports = moduleDef.call(undefined, {});
    } else if (goog.isString(moduleDef)) {
      if (goog.useSafari10Workaround()) {
        moduleDef = goog.workaroundSafari10EvalBug(moduleDef);
      }

      exports = goog.loadModuleFromSource_.call(undefined, moduleDef);
    } else {
      throw Error('Invalid module definition');
    }

    var moduleName = goog.moduleLoaderState_.moduleName;
    if (!goog.isString(moduleName) || !moduleName) {
      throw Error('Invalid module name \"' + moduleName + '\"');
    }

    // Don't seal legacy namespaces as they may be uses as a parent of
    // another namespace
    if (goog.moduleLoaderState_.declareLegacyNamespace) {
      goog.constructNamespace_(moduleName, exports);
    } else if (
        goog.SEAL_MODULE_EXPORTS && Object.seal && typeof exports == 'object' &&
        exports != null) {
      Object.seal(exports);
    }

    goog.loadedModules_[moduleName] = exports;
  } finally {
    goog.moduleLoaderState_ = previousState;
  }
};


/**
 * @private @const
 */
goog.loadModuleFromSource_ = /** @type {function(string):?} */ (function() {
  // NOTE: we avoid declaring parameters or local variables here to avoid
  // masking globals or leaking values into the module definition.
  'use strict';
  var exports = {};
  eval(arguments[0]);
  return exports;
});


/**
 * Normalize a file path by removing redundant ".." and extraneous "." file
 * path components.
 * @param {string} path
 * @return {string}
 * @private
 */
goog.normalizePath_ = function(path) {
  var components = path.split('/');
  var i = 0;
  while (i < components.length) {
    if (components[i] == '.') {
      components.splice(i, 1);
    } else if (
        i && components[i] == '..' && components[i - 1] &&
        components[i - 1] != '..') {
      components.splice(--i, 2);
    } else {
      i++;
    }
  }
  return components.join('/');
};


/**
 * Provides a hook for loading a file when using Closure's goog.require() API
 * with goog.modules.  In particular this hook is provided to support Node.js.
 *
 * @type {(function(string):string)|undefined}
 */
goog.global.CLOSURE_LOAD_FILE_SYNC;


/**
 * Loads file by synchronous XHR. Should not be used in production environments.
 * @param {string} src Source URL.
 * @return {?string} File contents, or null if load failed.
 * @private
 */
goog.loadFileSync_ = function(src) {
  if (goog.global.CLOSURE_LOAD_FILE_SYNC) {
    return goog.global.CLOSURE_LOAD_FILE_SYNC(src);
  } else {
    try {
      /** @type {XMLHttpRequest} */
      var xhr = new goog.global['XMLHttpRequest']();
      xhr.open('get', src, false);
      xhr.send();
      // NOTE: Successful http: requests have a status of 200, but successful
      // file: requests may have a status of zero.  Any other status, or a
      // thrown exception (particularly in case of file: requests) indicates
      // some sort of error, which we treat as a missing or unavailable file.
      return xhr.status == 0 || xhr.status == 200 ? xhr.responseText : null;
    } catch (err) {
      // No need to rethrow or log, since errors should show up on their own.
      return null;
    }
  }
};


/**
 * Retrieve and execute a script that needs some sort of wrapping.
 * @param {string} src Script source URL.
 * @param {boolean} isModule Whether to load as a module.
 * @param {boolean} needsTranspile Whether to transpile down to ES3.
 * @private
 */
goog.retrieveAndExec_ = function(src, isModule, needsTranspile) {
  if (!COMPILED) {
    // The full but non-canonicalized URL for later use.
    var originalPath = src;
    // Canonicalize the path, removing any /./ or /../ since Chrome's debugging
    // console doesn't auto-canonicalize XHR loads as it does <script> srcs.
    src = goog.normalizePath_(src);

    var importScript =
        goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;

    var scriptText = goog.loadFileSync_(src);
    if (scriptText == null) {
      throw new Error('Load of "' + src + '" failed');
    }

    if (needsTranspile) {
      scriptText = goog.transpile_.call(goog.global, scriptText, src);
    }

    if (isModule) {
      scriptText = goog.wrapModule_(src, scriptText);
    } else {
      scriptText += '\n//# sourceURL=' + src;
    }
    var isOldIE = goog.IS_OLD_IE_;
    if (isOldIE && goog.oldIeWaiting_) {
      goog.dependencies_.deferred[originalPath] = scriptText;
      goog.queuedModules_.push(originalPath);
    } else {
      importScript(src, scriptText);
    }
  }
};


/**
 * Lazily retrieves the transpiler and applies it to the source.
 * @param {string} code JS code.
 * @param {string} path Path to the code.
 * @return {string} The transpiled code.
 * @private
 */
goog.transpile_ = function(code, path) {
  var jscomp = goog.global['$jscomp'];
  if (!jscomp) {
    goog.global['$jscomp'] = jscomp = {};
  }
  var transpile = jscomp.transpile;
  if (!transpile) {
    var transpilerPath = goog.basePath + goog.TRANSPILER;
    var transpilerCode = goog.loadFileSync_(transpilerPath);
    if (transpilerCode) {
      // This must be executed synchronously, since by the time we know we
      // need it, we're about to load and write the ES6 code synchronously,
      // so a normal script-tag load will be too slow.
      eval(transpilerCode + '\n//# sourceURL=' + transpilerPath);
      // Even though the transpiler is optional, if $gwtExport is found, it's
      // a sign the transpiler was loaded and the $jscomp.transpile *should*
      // be there.
      if (goog.global['$gwtExport'] && goog.global['$gwtExport']['$jscomp'] &&
          !goog.global['$gwtExport']['$jscomp']['transpile']) {
        throw new Error(
            'The transpiler did not properly export the "transpile" ' +
            'method. $gwtExport: ' + JSON.stringify(goog.global['$gwtExport']));
      }
      // transpile.js only exports a single $jscomp function, transpile. We
      // grab just that and add it to the existing definition of $jscomp which
      // contains the polyfills.
      goog.global['$jscomp'].transpile =
          goog.global['$gwtExport']['$jscomp']['transpile'];
      jscomp = goog.global['$jscomp'];
      transpile = jscomp.transpile;
    }
  }
  if (!transpile) {
    // The transpiler is an optional component.  If it's not available then
    // replace it with a pass-through function that simply logs.
    var suffix = ' requires transpilation but no transpiler was found.';
    transpile = jscomp.transpile = function(code, path) {
      // TODO(user): figure out some way to get this error to show up
      // in test results, noting that the failure may occur in many
      // different ways, including in loadModule() before the test
      // runner even comes up.
      goog.logToConsole_(path + suffix);
      return code;
    };
  }
  // Note: any transpilation errors/warnings will be logged to the console.
  return transpile(code, path);
};


//==============================================================================
// Language Enhancements
//==============================================================================


/**
 * This is a "fixed" version of the typeof operator.  It differs from the typeof
 * operator in such a way that null returns 'null' and arrays return 'array'.
 * @param {?} value The value to get the type of.
 * @return {string} The name of the type.
 */
goog.typeOf = function(value) {
  var s = typeof value;
  if (s == 'object') {
    if (value) {
      // Check these first, so we can avoid calling Object.prototype.toString if
      // possible.
      //
      // IE improperly marshals typeof across execution contexts, but a
      // cross-context object will still return false for "instanceof Object".
      if (value instanceof Array) {
        return 'array';
      } else if (value instanceof Object) {
        return s;
      }

      // HACK: In order to use an Object prototype method on the arbitrary
      //   value, the compiler requires the value be cast to type Object,
      //   even though the ECMA spec explicitly allows it.
      var className = Object.prototype.toString.call(
          /** @type {!Object} */ (value));
      // In Firefox 3.6, attempting to access iframe window objects' length
      // property throws an NS_ERROR_FAILURE, so we need to special-case it
      // here.
      if (className == '[object Window]') {
        return 'object';
      }

      // We cannot always use constructor == Array or instanceof Array because
      // different frames have different Array objects. In IE6, if the iframe
      // where the array was created is destroyed, the array loses its
      // prototype. Then dereferencing val.splice here throws an exception, so
      // we can't use goog.isFunction. Calling typeof directly returns 'unknown'
      // so that will work. In this case, this function will return false and
      // most array functions will still work because the array is still
      // array-like (supports length and []) even though it has lost its
      // prototype.
      // Mark Miller noticed that Object.prototype.toString
      // allows access to the unforgeable [[Class]] property.
      //  15.2.4.2 Object.prototype.toString ( )
      //  When the toString method is called, the following steps are taken:
      //      1. Get the [[Class]] property of this object.
      //      2. Compute a string value by concatenating the three strings
      //         "[object ", Result(1), and "]".
      //      3. Return Result(2).
      // and this behavior survives the destruction of the execution context.
      if ((className == '[object Array]' ||
           // In IE all non value types are wrapped as objects across window
           // boundaries (not iframe though) so we have to do object detection
           // for this edge case.
           typeof value.length == 'number' &&
               typeof value.splice != 'undefined' &&
               typeof value.propertyIsEnumerable != 'undefined' &&
               !value.propertyIsEnumerable('splice')

               )) {
        return 'array';
      }
      // HACK: There is still an array case that fails.
      //     function ArrayImpostor() {}
      //     ArrayImpostor.prototype = [];
      //     var impostor = new ArrayImpostor;
      // this can be fixed by getting rid of the fast path
      // (value instanceof Array) and solely relying on
      // (value && Object.prototype.toString.vall(value) === '[object Array]')
      // but that would require many more function calls and is not warranted
      // unless closure code is receiving objects from untrusted sources.

      // IE in cross-window calls does not correctly marshal the function type
      // (it appears just as an object) so we cannot use just typeof val ==
      // 'function'. However, if the object has a call property, it is a
      // function.
      if ((className == '[object Function]' ||
           typeof value.call != 'undefined' &&
               typeof value.propertyIsEnumerable != 'undefined' &&
               !value.propertyIsEnumerable('call'))) {
        return 'function';
      }

    } else {
      return 'null';
    }

  } else if (s == 'function' && typeof value.call == 'undefined') {
    // In Safari typeof nodeList returns 'function', and on Firefox typeof
    // behaves similarly for HTML{Applet,Embed,Object}, Elements and RegExps. We
    // would like to return object for those and we can detect an invalid
    // function by making sure that the function object has a call method.
    return 'object';
  }
  return s;
};


/**
 * Returns true if the specified value is null.
 * @param {?} val Variable to test.
 * @return {boolean} Whether variable is null.
 */
goog.isNull = function(val) {
  return val === null;
};


/**
 * Returns true if the specified value is defined and not null.
 * @param {?} val Variable to test.
 * @return {boolean} Whether variable is defined and not null.
 */
goog.isDefAndNotNull = function(val) {
  // Note that undefined == null.
  return val != null;
};


/**
 * Returns true if the specified value is an array.
 * @param {?} val Variable to test.
 * @return {boolean} Whether variable is an array.
 */
goog.isArray = function(val) {
  return goog.typeOf(val) == 'array';
};


/**
 * Returns true if the object looks like an array. To qualify as array like
 * the value needs to be either a NodeList or an object with a Number length
 * property. As a special case, a function value is not array like, because its
 * length property is fixed to correspond to the number of expected arguments.
 * @param {?} val Variable to test.
 * @return {boolean} Whether variable is an array.
 */
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  // We do not use goog.isObject here in order to exclude function values.
  return type == 'array' || type == 'object' && typeof val.length == 'number';
};


/**
 * Returns true if the object looks like a Date. To qualify as Date-like the
 * value needs to be an object and have a getFullYear() function.
 * @param {?} val Variable to test.
 * @return {boolean} Whether variable is a like a Date.
 */
goog.isDateLike = function(val) {
  return goog.isObject(val) && typeof val.getFullYear == 'function';
};


/**
 * Returns true if the specified value is a function.
 * @param {?} val Variable to test.
 * @return {boolean} Whether variable is a function.
 */
goog.isFunction = function(val) {
  return goog.typeOf(val) == 'function';
};


/**
 * Returns true if the specified value is an object.  This includes arrays and
 * functions.
 * @param {?} val Variable to test.
 * @return {boolean} Whether variable is an object.
 */
goog.isObject = function(val) {
  var type = typeof val;
  return type == 'object' && val != null || type == 'function';
  // return Object(val) === val also works, but is slower, especially if val is
  // not an object.
};


/**
 * Gets a unique ID for an object. This mutates the object so that further calls
 * with the same object as a parameter returns the same value. The unique ID is
 * guaranteed to be unique across the current session amongst objects that are
 * passed into {@code getUid}. There is no guarantee that the ID is unique or
 * consistent across sessions. It is unsafe to generate unique ID for function
 * prototypes.
 *
 * @param {Object} obj The object to get the unique ID for.
 * @return {number} The unique ID for the object.
 */
goog.getUid = function(obj) {
  // TODO(arv): Make the type stricter, do not accept null.

  // In Opera window.hasOwnProperty exists but always returns false so we avoid
  // using it. As a consequence the unique ID generated for BaseClass.prototype
  // and SubClass.prototype will be the same.
  return obj[goog.UID_PROPERTY_] ||
      (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_);
};


/**
 * Whether the given object is already assigned a unique ID.
 *
 * This does not modify the object.
 *
 * @param {!Object} obj The object to check.
 * @return {boolean} Whether there is an assigned unique id for the object.
 */
goog.hasUid = function(obj) {
  return !!obj[goog.UID_PROPERTY_];
};


/**
 * Removes the unique ID from an object. This is useful if the object was
 * previously mutated using {@code goog.getUid} in which case the mutation is
 * undone.
 * @param {Object} obj The object to remove the unique ID field from.
 */
goog.removeUid = function(obj) {
  // TODO(arv): Make the type stricter, do not accept null.

  // In IE, DOM nodes are not instances of Object and throw an exception if we
  // try to delete.  Instead we try to use removeAttribute.
  if (obj !== null && 'removeAttribute' in obj) {
    obj.removeAttribute(goog.UID_PROPERTY_);
  }

  try {
    delete obj[goog.UID_PROPERTY_];
  } catch (ex) {
  }
};


/**
 * Name for unique ID property. Initialized in a way to help avoid collisions
 * with other closure JavaScript on the same page.
 * @type {string}
 * @private
 */
goog.UID_PROPERTY_ = 'closure_uid_' + ((Math.random() * 1e9) >>> 0);


/**
 * Counter for UID.
 * @type {number}
 * @private
 */
goog.uidCounter_ = 0;


/**
 * Adds a hash code field to an object. The hash code is unique for the
 * given object.
 * @param {Object} obj The object to get the hash code for.
 * @return {number} The hash code for the object.
 * @deprecated Use goog.getUid instead.
 */
goog.getHashCode = goog.getUid;


/**
 * Removes the hash code field from an object.
 * @param {Object} obj The object to remove the field from.
 * @deprecated Use goog.removeUid instead.
 */
goog.removeHashCode = goog.removeUid;


/**
 * Clones a value. The input may be an Object, Array, or basic type. Objects and
 * arrays will be cloned recursively.
 *
 * WARNINGS:
 * <code>goog.cloneObject</code> does not detect reference loops. Objects that
 * refer to themselves will cause infinite recursion.
 *
 * <code>goog.cloneObject</code> is unaware of unique identifiers, and copies
 * UIDs created by <code>getUid</code> into cloned results.
 *
 * @param {*} obj The value to clone.
 * @return {*} A clone of the input value.
 * @deprecated goog.cloneObject is unsafe. Prefer the goog.object methods.
 */
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if (type == 'object' || type == 'array') {
    if (obj.clone) {
      return obj.clone();
    }
    var clone = type == 'array' ? [] : {};
    for (var key in obj) {
      clone[key] = goog.cloneObject(obj[key]);
    }
    return clone;
  }

  return obj;
};


/**
 * A native implementation of goog.bind.
 * @param {?function(this:T, ...)} fn A function to partially apply.
 * @param {T} selfObj Specifies the object which this should point to when the
 *     function is run.
 * @param {...*} var_args Additional arguments that are partially applied to the
 *     function.
 * @return {!Function} A partially-applied form of the function goog.bind() was
 *     invoked as a method of.
 * @template T
 * @private
 */
goog.bindNative_ = function(fn, selfObj, var_args) {
  return /** @type {!Function} */ (fn.call.apply(fn.bind, arguments));
};


/**
 * A pure-JS implementation of goog.bind.
 * @param {?function(this:T, ...)} fn A function to partially apply.
 * @param {T} selfObj Specifies the object which this should point to when the
 *     function is run.
 * @param {...*} var_args Additional arguments that are partially applied to the
 *     function.
 * @return {!Function} A partially-applied form of the function goog.bind() was
 *     invoked as a method of.
 * @template T
 * @private
 */
goog.bindJs_ = function(fn, selfObj, var_args) {
  if (!fn) {
    throw new Error();
  }

  if (arguments.length > 2) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      // Prepend the bound arguments to the current arguments.
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(selfObj, newArgs);
    };

  } else {
    return function() {
      return fn.apply(selfObj, arguments);
    };
  }
};


/**
 * Partially applies this function to a particular 'this object' and zero or
 * more arguments. The result is a new function with some arguments of the first
 * function pre-filled and the value of this 'pre-specified'.
 *
 * Remaining arguments specified at call-time are appended to the pre-specified
 * ones.
 *
 * Also see: {@link #partial}.
 *
 * Usage:
 * <pre>var barMethBound = goog.bind(myFunction, myObj, 'arg1', 'arg2');
 * barMethBound('arg3', 'arg4');</pre>
 *
 * @param {?function(this:T, ...)} fn A function to partially apply.
 * @param {T} selfObj Specifies the object which this should point to when the
 *     function is run.
 * @param {...*} var_args Additional arguments that are partially applied to the
 *     function.
 * @return {!Function} A partially-applied form of the function goog.bind() was
 *     invoked as a method of.
 * @template T
 * @suppress {deprecated} See above.
 */
goog.bind = function(fn, selfObj, var_args) {
  // TODO(nicksantos): narrow the type signature.
  if (Function.prototype.bind &&
      // NOTE(nicksantos): Somebody pulled base.js into the default Chrome
      // extension environment. This means that for Chrome extensions, they get
      // the implementation of Function.prototype.bind that calls goog.bind
      // instead of the native one. Even worse, we don't want to introduce a
      // circular dependency between goog.bind and Function.prototype.bind, so
      // we have to hack this to make sure it works correctly.
      Function.prototype.bind.toString().indexOf('native code') != -1) {
    goog.bind = goog.bindNative_;
  } else {
    goog.bind = goog.bindJs_;
  }
  return goog.bind.apply(null, arguments);
};


/**
 * Like goog.bind(), except that a 'this object' is not required. Useful when
 * the target function is already bound.
 *
 * Usage:
 * var g = goog.partial(f, arg1, arg2);
 * g(arg3, arg4);
 *
 * @param {Function} fn A function to partially apply.
 * @param {...*} var_args Additional arguments that are partially applied to fn.
 * @return {!Function} A partially-applied form of the function goog.partial()
 *     was invoked as a method of.
 */
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    // Clone the array (with slice()) and append additional arguments
    // to the existing arguments.
    var newArgs = args.slice();
    newArgs.push.apply(newArgs, arguments);
    return fn.apply(this, newArgs);
  };
};


/**
 * Copies all the members of a source object to a target object. This method
 * does not work on all browsers for all objects that contain keys such as
 * toString or hasOwnProperty. Use goog.object.extend for this purpose.
 * @param {Object} target Target.
 * @param {Object} source Source.
 */
goog.mixin = function(target, source) {
  for (var x in source) {
    target[x] = source[x];
  }

  // For IE7 or lower, the for-in-loop does not contain any properties that are
  // not enumerable on the prototype object (for example, isPrototypeOf from
  // Object.prototype) but also it will not include 'replace' on objects that
  // extend String and change 'replace' (not that it is common for anyone to
  // extend anything except Object).
};


/**
 * @return {number} An integer value representing the number of milliseconds
 *     between midnight, January 1, 1970 and the current time.
 */
goog.now = (goog.TRUSTED_SITE && Date.now) || (function() {
             // Unary plus operator converts its operand to a number which in
             // the case of
             // a date is done by calling getTime().
             return +new Date();
           });


/**
 * Evals JavaScript in the global scope.  In IE this uses execScript, other
 * browsers use goog.global.eval. If goog.global.eval does not evaluate in the
 * global scope (for example, in Safari), appends a script tag instead.
 * Throws an exception if neither execScript or eval is defined.
 * @param {string} script JavaScript string.
 */
goog.globalEval = function(script) {
  if (goog.global.execScript) {
    goog.global.execScript(script, 'JavaScript');
  } else if (goog.global.eval) {
    // Test to see if eval works
    if (goog.evalWorksForGlobals_ == null) {
      goog.global.eval('var _evalTest_ = 1;');
      if (typeof goog.global['_evalTest_'] != 'undefined') {
        try {
          delete goog.global['_evalTest_'];
        } catch (ignore) {
          // Microsoft edge fails the deletion above in strict mode.
        }
        goog.evalWorksForGlobals_ = true;
      } else {
        goog.evalWorksForGlobals_ = false;
      }
    }

    if (goog.evalWorksForGlobals_) {
      goog.global.eval(script);
    } else {
      /** @type {Document} */
      var doc = goog.global.document;
      var scriptElt =
          /** @type {!HTMLScriptElement} */ (doc.createElement('SCRIPT'));
      scriptElt.type = 'text/javascript';
      scriptElt.defer = false;
      // Note(user): can't use .innerHTML since "t('<test>')" will fail and
      // .text doesn't work in Safari 2.  Therefore we append a text node.
      scriptElt.appendChild(doc.createTextNode(script));
      doc.body.appendChild(scriptElt);
      doc.body.removeChild(scriptElt);
    }
  } else {
    throw Error('goog.globalEval not available');
  }
};


/**
 * Indicates whether or not we can call 'eval' directly to eval code in the
 * global scope. Set to a Boolean by the first call to goog.globalEval (which
 * empirically tests whether eval works for globals). @see goog.globalEval
 * @type {?boolean}
 * @private
 */
goog.evalWorksForGlobals_ = null;


/**
 * Optional map of CSS class names to obfuscated names used with
 * goog.getCssName().
 * @private {!Object<string, string>|undefined}
 * @see goog.setCssNameMapping
 */
goog.cssNameMapping_;


/**
 * Optional obfuscation style for CSS class names. Should be set to either
 * 'BY_WHOLE' or 'BY_PART' if defined.
 * @type {string|undefined}
 * @private
 * @see goog.setCssNameMapping
 */
goog.cssNameMappingStyle_;



/**
 * A hook for modifying the default behavior goog.getCssName. The function
 * if present, will recieve the standard output of the goog.getCssName as
 * its input.
 *
 * @type {(function(string):string)|undefined}
 */
goog.global.CLOSURE_CSS_NAME_MAP_FN;


/**
 * Handles strings that are intended to be used as CSS class names.
 *
 * This function works in tandem with @see goog.setCssNameMapping.
 *
 * Without any mapping set, the arguments are simple joined with a hyphen and
 * passed through unaltered.
 *
 * When there is a mapping, there are two possible styles in which these
 * mappings are used. In the BY_PART style, each part (i.e. in between hyphens)
 * of the passed in css name is rewritten according to the map. In the BY_WHOLE
 * style, the full css name is looked up in the map directly. If a rewrite is
 * not specified by the map, the compiler will output a warning.
 *
 * When the mapping is passed to the compiler, it will replace calls to
 * goog.getCssName with the strings from the mapping, e.g.
 *     var x = goog.getCssName('foo');
 *     var y = goog.getCssName(this.baseClass, 'active');
 *  becomes:
 *     var x = 'foo';
 *     var y = this.baseClass + '-active';
 *
 * If one argument is passed it will be processed, if two are passed only the
 * modifier will be processed, as it is assumed the first argument was generated
 * as a result of calling goog.getCssName.
 *
 * @param {string} className The class name.
 * @param {string=} opt_modifier A modifier to be appended to the class name.
 * @return {string} The class name or the concatenation of the class name and
 *     the modifier.
 */
goog.getCssName = function(className, opt_modifier) {
  // String() is used for compatibility with compiled soy where the passed
  // className can be non-string objects.
  if (String(className).charAt(0) == '.') {
    throw new Error(
        'className passed in goog.getCssName must not start with ".".' +
        ' You passed: ' + className);
  }

  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName;
  };

  var renameByParts = function(cssName) {
    // Remap all the parts individually.
    var parts = cssName.split('-');
    var mapped = [];
    for (var i = 0; i < parts.length; i++) {
      mapped.push(getMapping(parts[i]));
    }
    return mapped.join('-');
  };

  var rename;
  if (goog.cssNameMapping_) {
    rename =
        goog.cssNameMappingStyle_ == 'BY_WHOLE' ? getMapping : renameByParts;
  } else {
    rename = function(a) {
      return a;
    };
  }

  var result =
      opt_modifier ? className + '-' + rename(opt_modifier) : rename(className);

  // The special CLOSURE_CSS_NAME_MAP_FN allows users to specify further
  // processing of the class name.
  if (goog.global.CLOSURE_CSS_NAME_MAP_FN) {
    return goog.global.CLOSURE_CSS_NAME_MAP_FN(result);
  }

  return result;
};


/**
 * Sets the map to check when returning a value from goog.getCssName(). Example:
 * <pre>
 * goog.setCssNameMapping({
 *   "goog": "a",
 *   "disabled": "b",
 * });
 *
 * var x = goog.getCssName('goog');
 * // The following evaluates to: "a a-b".
 * goog.getCssName('goog') + ' ' + goog.getCssName(x, 'disabled')
 * </pre>
 * When declared as a map of string literals to string literals, the JSCompiler
 * will replace all calls to goog.getCssName() using the supplied map if the
 * --process_closure_primitives flag is set.
 *
 * @param {!Object} mapping A map of strings to strings where keys are possible
 *     arguments to goog.getCssName() and values are the corresponding values
 *     that should be returned.
 * @param {string=} opt_style The style of css name mapping. There are two valid
 *     options: 'BY_PART', and 'BY_WHOLE'.
 * @see goog.getCssName for a description.
 */
goog.setCssNameMapping = function(mapping, opt_style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = opt_style;
};


/**
 * To use CSS renaming in compiled mode, one of the input files should have a
 * call to goog.setCssNameMapping() with an object literal that the JSCompiler
 * can extract and use to replace all calls to goog.getCssName(). In uncompiled
 * mode, JavaScript code should be loaded before this base.js file that declares
 * a global variable, CLOSURE_CSS_NAME_MAPPING, which is used below. This is
 * to ensure that the mapping is loaded before any calls to goog.getCssName()
 * are made in uncompiled mode.
 *
 * A hook for overriding the CSS name mapping.
 * @type {!Object<string, string>|undefined}
 */
goog.global.CLOSURE_CSS_NAME_MAPPING;


if (!COMPILED && goog.global.CLOSURE_CSS_NAME_MAPPING) {
  // This does not call goog.setCssNameMapping() because the JSCompiler
  // requires that goog.setCssNameMapping() be called with an object literal.
  goog.cssNameMapping_ = goog.global.CLOSURE_CSS_NAME_MAPPING;
}


/**
 * Gets a localized message.
 *
 * This function is a compiler primitive. If you give the compiler a localized
 * message bundle, it will replace the string at compile-time with a localized
 * version, and expand goog.getMsg call to a concatenated string.
 *
 * Messages must be initialized in the form:
 * <code>
 * var MSG_NAME = goog.getMsg('Hello {$placeholder}', {'placeholder': 'world'});
 * </code>
 *
 * This function produces a string which should be treated as plain text. Use
 * {@link goog.html.SafeHtmlFormatter} in conjunction with goog.getMsg to
 * produce SafeHtml.
 *
 * @param {string} str Translatable string, places holders in the form {$foo}.
 * @param {Object<string, string>=} opt_values Maps place holder name to value.
 * @return {string} message with placeholders filled.
 */
goog.getMsg = function(str, opt_values) {
  if (opt_values) {
    str = str.replace(/\{\$([^}]+)}/g, function(match, key) {
      return (opt_values != null && key in opt_values) ? opt_values[key] :
                                                         match;
    });
  }
  return str;
};


/**
 * Gets a localized message. If the message does not have a translation, gives a
 * fallback message.
 *
 * This is useful when introducing a new message that has not yet been
 * translated into all languages.
 *
 * This function is a compiler primitive. Must be used in the form:
 * <code>var x = goog.getMsgWithFallback(MSG_A, MSG_B);</code>
 * where MSG_A and MSG_B were initialized with goog.getMsg.
 *
 * @param {string} a The preferred message.
 * @param {string} b The fallback message.
 * @return {string} The best translated message.
 */
goog.getMsgWithFallback = function(a, b) {
  return a;
};


/**
 * Exposes an unobfuscated global namespace path for the given object.
 * Note that fields of the exported object *will* be obfuscated, unless they are
 * exported in turn via this function or goog.exportProperty.
 *
 * Also handy for making public items that are defined in anonymous closures.
 *
 * ex. goog.exportSymbol('public.path.Foo', Foo);
 *
 * ex. goog.exportSymbol('public.path.Foo.staticFunction', Foo.staticFunction);
 *     public.path.Foo.staticFunction();
 *
 * ex. goog.exportSymbol('public.path.Foo.prototype.myMethod',
 *                       Foo.prototype.myMethod);
 *     new public.path.Foo().myMethod();
 *
 * @param {string} publicPath Unobfuscated name to export.
 * @param {*} object Object the name should point to.
 * @param {Object=} opt_objectToExportTo The object to add the path to; default
 *     is goog.global.
 */
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo);
};


/**
 * Exports a property unobfuscated into the object's namespace.
 * ex. goog.exportProperty(Foo, 'staticFunction', Foo.staticFunction);
 * ex. goog.exportProperty(Foo.prototype, 'myMethod', Foo.prototype.myMethod);
 * @param {Object} object Object whose static property is being exported.
 * @param {string} publicName Unobfuscated name to export.
 * @param {*} symbol Object the name should point to.
 */
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol;
};


/**
 * Inherit the prototype methods from one constructor into another.
 *
 * Usage:
 * <pre>
 * function ParentClass(a, b) { }
 * ParentClass.prototype.foo = function(a) { };
 *
 * function ChildClass(a, b, c) {
 *   ChildClass.base(this, 'constructor', a, b);
 * }
 * goog.inherits(ChildClass, ParentClass);
 *
 * var child = new ChildClass('a', 'b', 'see');
 * child.foo(); // This works.
 * </pre>
 *
 * @param {!Function} childCtor Child class.
 * @param {!Function} parentCtor Parent class.
 */
goog.inherits = function(childCtor, parentCtor) {
  /** @constructor */
  function tempCtor() {}
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor();
  /** @override */
  childCtor.prototype.constructor = childCtor;

  /**
   * Calls superclass constructor/method.
   *
   * This function is only available if you use goog.inherits to
   * express inheritance relationships between classes.
   *
   * NOTE: This is a replacement for goog.base and for superClass_
   * property defined in childCtor.
   *
   * @param {!Object} me Should always be "this".
   * @param {string} methodName The method name to call. Calling
   *     superclass constructor can be done with the special string
   *     'constructor'.
   * @param {...*} var_args The arguments to pass to superclass
   *     method/constructor.
   * @return {*} The return value of the superclass method/constructor.
   */
  childCtor.base = function(me, methodName, var_args) {
    // Copying using loop to avoid deop due to passing arguments object to
    // function. This is faster in many JS engines as of late 2014.
    var args = new Array(arguments.length - 2);
    for (var i = 2; i < arguments.length; i++) {
      args[i - 2] = arguments[i];
    }
    return parentCtor.prototype[methodName].apply(me, args);
  };
};


/**
 * Call up to the superclass.
 *
 * If this is called from a constructor, then this calls the superclass
 * constructor with arguments 1-N.
 *
 * If this is called from a prototype method, then you must pass the name of the
 * method as the second argument to this function. If you do not, you will get a
 * runtime error. This calls the superclass' method with arguments 2-N.
 *
 * This function only works if you use goog.inherits to express inheritance
 * relationships between your classes.
 *
 * This function is a compiler primitive. At compile-time, the compiler will do
 * macro expansion to remove a lot of the extra overhead that this function
 * introduces. The compiler will also enforce a lot of the assumptions that this
 * function makes, and treat it as a compiler error if you break them.
 *
 * @param {!Object} me Should always be "this".
 * @param {*=} opt_methodName The method name if calling a super method.
 * @param {...*} var_args The rest of the arguments.
 * @return {*} The return value of the superclass method.
 * @suppress {es5Strict} This method can not be used in strict mode, but
 *     all Closure Library consumers must depend on this file.
 * @deprecated goog.base is not strict mode compatible.  Prefer the static
 *     "base" method added to the constructor by goog.inherits
 *     or ES6 classes and the "super" keyword.
 */
goog.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;

  if (goog.STRICT_MODE_COMPATIBLE || (goog.DEBUG && !caller)) {
    throw Error(
        'arguments.caller not defined.  goog.base() cannot be used ' +
        'with strict mode code. See ' +
        'http://www.ecma-international.org/ecma-262/5.1/#sec-C');
  }

  if (caller.superClass_) {
    // Copying using loop to avoid deop due to passing arguments object to
    // function. This is faster in many JS engines as of late 2014.
    var ctorArgs = new Array(arguments.length - 1);
    for (var i = 1; i < arguments.length; i++) {
      ctorArgs[i - 1] = arguments[i];
    }
    // This is a constructor. Call the superclass constructor.
    return caller.superClass_.constructor.apply(me, ctorArgs);
  }

  // Copying using loop to avoid deop due to passing arguments object to
  // function. This is faster in many JS engines as of late 2014.
  var args = new Array(arguments.length - 2);
  for (var i = 2; i < arguments.length; i++) {
    args[i - 2] = arguments[i];
  }
  var foundCaller = false;
  for (var ctor = me.constructor; ctor;
       ctor = ctor.superClass_ && ctor.superClass_.constructor) {
    if (ctor.prototype[opt_methodName] === caller) {
      foundCaller = true;
    } else if (foundCaller) {
      return ctor.prototype[opt_methodName].apply(me, args);
    }
  }

  // If we did not find the caller in the prototype chain, then one of two
  // things happened:
  // 1) The caller is an instance method.
  // 2) This method was not called by the right caller.
  if (me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args);
  } else {
    throw Error(
        'goog.base called from a method of one name ' +
        'to a method of a different name');
  }
};


/**
 * Allow for aliasing within scope functions.  This function exists for
 * uncompiled code - in compiled code the calls will be inlined and the aliases
 * applied.  In uncompiled code the function is simply run since the aliases as
 * written are valid JavaScript.
 *
 *
 * @param {function()} fn Function to call.  This function can contain aliases
 *     to namespaces (e.g. "var dom = goog.dom") or classes
 *     (e.g. "var Timer = goog.Timer").
 */
goog.scope = function(fn) {
  if (goog.isInModuleLoader_()) {
    throw Error('goog.scope is not supported within a goog.module.');
  }
  fn.call(goog.global);
};


/*
 * To support uncompiled, strict mode bundles that use eval to divide source
 * like so:
 *    eval('someSource;//# sourceUrl sourcefile.js');
 * We need to export the globally defined symbols "goog" and "COMPILED".
 * Exporting "goog" breaks the compiler optimizations, so we required that
 * be defined externally.
 * NOTE: We don't use goog.exportSymbol here because we don't want to trigger
 * extern generation when that compiler option is enabled.
 */
if (!COMPILED) {
  goog.global['COMPILED'] = COMPILED;
}


//==============================================================================
// goog.defineClass implementation
//==============================================================================


/**
 * Creates a restricted form of a Closure "class":
 *   - from the compiler's perspective, the instance returned from the
 *     constructor is sealed (no new properties may be added).  This enables
 *     better checks.
 *   - the compiler will rewrite this definition to a form that is optimal
 *     for type checking and optimization (initially this will be a more
 *     traditional form).
 *
 * @param {Function} superClass The superclass, Object or null.
 * @param {goog.defineClass.ClassDescriptor} def
 *     An object literal describing
 *     the class.  It may have the following properties:
 *     "constructor": the constructor function
 *     "statics": an object literal containing methods to add to the constructor
 *        as "static" methods or a function that will receive the constructor
 *        function as its only parameter to which static properties can
 *        be added.
 *     all other properties are added to the prototype.
 * @return {!Function} The class constructor.
 */
goog.defineClass = function(superClass, def) {
  // TODO(johnlenz): consider making the superClass an optional parameter.
  var constructor = def.constructor;
  var statics = def.statics;
  // Wrap the constructor prior to setting up the prototype and static methods.
  if (!constructor || constructor == Object.prototype.constructor) {
    constructor = function() {
      throw Error('cannot instantiate an interface (no constructor defined).');
    };
  }

  var cls = goog.defineClass.createSealingConstructor_(constructor, superClass);
  if (superClass) {
    goog.inherits(cls, superClass);
  }

  // Remove all the properties that should not be copied to the prototype.
  delete def.constructor;
  delete def.statics;

  goog.defineClass.applyProperties_(cls.prototype, def);
  if (statics != null) {
    if (statics instanceof Function) {
      statics(cls);
    } else {
      goog.defineClass.applyProperties_(cls, statics);
    }
  }

  return cls;
};


/**
 * @typedef {{
 *   constructor: (!Function|undefined),
 *   statics: (Object|undefined|function(Function):void)
 * }}
 */
goog.defineClass.ClassDescriptor;


/**
 * @define {boolean} Whether the instances returned by goog.defineClass should
 *     be sealed when possible.
 *
 * When sealing is disabled the constructor function will not be wrapped by
 * goog.defineClass, making it incompatible with ES6 class methods.
 */
goog.define('goog.defineClass.SEAL_CLASS_INSTANCES', goog.DEBUG);


/**
 * If goog.defineClass.SEAL_CLASS_INSTANCES is enabled and Object.seal is
 * defined, this function will wrap the constructor in a function that seals the
 * results of the provided constructor function.
 *
 * @param {!Function} ctr The constructor whose results maybe be sealed.
 * @param {Function} superClass The superclass constructor.
 * @return {!Function} The replacement constructor.
 * @private
 */
goog.defineClass.createSealingConstructor_ = function(ctr, superClass) {
  if (!goog.defineClass.SEAL_CLASS_INSTANCES) {
    // Do now wrap the constructor when sealing is disabled. Angular code
    // depends on this for injection to work properly.
    return ctr;
  }

  // Compute whether the constructor is sealable at definition time, rather
  // than when the instance is being constructed.
  var superclassSealable = !goog.defineClass.isUnsealable_(superClass);

  /**
   * @this {Object}
   * @return {?}
   */
  var wrappedCtr = function() {
    // Don't seal an instance of a subclass when it calls the constructor of
    // its super class as there is most likely still setup to do.
    var instance = ctr.apply(this, arguments) || this;
    instance[goog.UID_PROPERTY_] = instance[goog.UID_PROPERTY_];

    if (this.constructor === wrappedCtr && superclassSealable &&
        Object.seal instanceof Function) {
      Object.seal(instance);
    }
    return instance;
  };

  return wrappedCtr;
};


/**
 * @param {Function} ctr The constructor to test.
 * @return {boolean} Whether the constructor has been tagged as unsealable
 *     using goog.tagUnsealableClass.
 * @private
 */
goog.defineClass.isUnsealable_ = function(ctr) {
  return ctr && ctr.prototype &&
      ctr.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_];
};


// TODO(johnlenz): share these values with the goog.object
/**
 * The names of the fields that are defined on Object.prototype.
 * @type {!Array<string>}
 * @private
 * @const
 */
goog.defineClass.OBJECT_PROTOTYPE_FIELDS_ = [
  'constructor', 'hasOwnProperty', 'isPrototypeOf', 'propertyIsEnumerable',
  'toLocaleString', 'toString', 'valueOf'
];


// TODO(johnlenz): share this function with the goog.object
/**
 * @param {!Object} target The object to add properties to.
 * @param {!Object} source The object to copy properties from.
 * @private
 */
goog.defineClass.applyProperties_ = function(target, source) {
  // TODO(johnlenz): update this to support ES5 getters/setters

  var key;
  for (key in source) {
    if (Object.prototype.hasOwnProperty.call(source, key)) {
      target[key] = source[key];
    }
  }

  // For IE the for-in-loop does not contain any properties that are not
  // enumerable on the prototype object (for example isPrototypeOf from
  // Object.prototype) and it will also not include 'replace' on objects that
  // extend String and change 'replace' (not that it is common for anyone to
  // extend anything except Object).
  for (var i = 0; i < goog.defineClass.OBJECT_PROTOTYPE_FIELDS_.length; i++) {
    key = goog.defineClass.OBJECT_PROTOTYPE_FIELDS_[i];
    if (Object.prototype.hasOwnProperty.call(source, key)) {
      target[key] = source[key];
    }
  }
};


/**
 * Sealing classes breaks the older idiom of assigning properties on the
 * prototype rather than in the constructor. As such, goog.defineClass
 * must not seal subclasses of these old-style classes until they are fixed.
 * Until then, this marks a class as "broken", instructing defineClass
 * not to seal subclasses.
 * @param {!Function} ctr The legacy constructor to tag as unsealable.
 */
goog.tagUnsealableClass = function(ctr) {
  if (!COMPILED && goog.defineClass.SEAL_CLASS_INSTANCES) {
    ctr.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_] = true;
  }
};


/**
 * Name for unsealable tag property.
 * @const @private {string}
 */
goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_ = 'goog_defineClass_legacy_unsealable';


/**
 * Returns a newly created map from language mode string to a boolean
 * indicating whether transpilation should be done for that mode.
 *
 * Guaranteed invariant:
 * For any two modes, l1 and l2 where l2 is a newer mode than l1,
 * `map[l1] == true` implies that `map[l2] == true`.
 * @private
 * @return {!Object<string, boolean>}
 */
goog.createRequiresTranspilation_ = function() {
  var /** !Object<string, boolean> */ requiresTranspilation = {'es3': false};
  var transpilationRequiredForAllLaterModes = false;

  /**
   * Adds an entry to requiresTranspliation for the given language mode.
   *
   * IMPORTANT: Calls must be made in order from oldest to newest language
   * mode.
   * @param {string} modeName
   * @param {function(): boolean} isSupported Returns true if the JS engine
   *     supports the given mode.
   */
  function addNewerLanguageTranspilationCheck(modeName, isSupported) {
    if (transpilationRequiredForAllLaterModes) {
      requiresTranspilation[modeName] = true;
    } else if (isSupported()) {
      requiresTranspilation[modeName] = false;
    } else {
      requiresTranspilation[modeName] = true;
      transpilationRequiredForAllLaterModes = true;
    }
  }

  /**
   * Does the given code evaluate without syntax errors and return a truthy
   * result?
   */
  function /** boolean */ evalCheck(/** string */ code) {
    try {
      return !!eval(code);
    } catch (ignored) {
      return false;
    }
  }

  var userAgent = goog.global.navigator && goog.global.navigator.userAgent ?
      goog.global.navigator.userAgent :
      '';

  // Identify ES3-only browsers by their incorrect treatment of commas.
  addNewerLanguageTranspilationCheck('es5', function() {
    return evalCheck('[1,].length==1');
  });
  addNewerLanguageTranspilationCheck('es6', function() {
    // Edge has a non-deterministic (i.e., not reproducible) bug with ES6:
    // https://github.com/Microsoft/ChakraCore/issues/1496.
    var re = /Edge\/(\d+)(\.\d)*/i;
    var edgeUserAgent = userAgent.match(re);
    if (edgeUserAgent && Number(edgeUserAgent[1]) < 15) {
      return false;
    }
    // Test es6: [FF50 (?), Edge 14 (?), Chrome 50]
    //   (a) default params (specifically shadowing locals),
    //   (b) destructuring, (c) block-scoped functions,
    //   (d) for-of (const), (e) new.target/Reflect.construct
    var es6fullTest =
        'class X{constructor(){if(new.target!=String)throw 1;this.x=42}}' +
        'let q=Reflect.construct(X,[],String);if(q.x!=42||!(q instanceof ' +
        'String))throw 1;for(const a of[2,3]){if(a==2)continue;function ' +
        'f(z={a}){let a=0;return z.a}{function f(){return 0;}}return f()' +
        '==3}';

    return evalCheck('(()=>{"use strict";' + es6fullTest + '})()');
  });
  // TODO(joeltine): Remove es6-impl references for b/31340605.
  // Consider es6-impl (widely-implemented es6 features) to be supported
  // whenever es6 is supported. Technically es6-impl is a lower level of
  // support than es6, but we don't have tests specifically for it.
  addNewerLanguageTranspilationCheck('es6-impl', function() {
    return true;
  });
  // ** and **= are the only new features in 'es7'
  addNewerLanguageTranspilationCheck('es7', function() {
    return evalCheck('2 ** 2 == 4');
  });
  // async functions are the only new features in 'es8'
  addNewerLanguageTranspilationCheck('es8', function() {
    return evalCheck('async () => 1, true');
  });
  return requiresTranspilation;
};

var SHADOW_ENV = function() {
  var loadedFiles = {};

  var env = {};

  var doc = goog.global.document;

  if (!doc) {
    throw new Error("browser bootstrap used in incorrect target");
  }

  var wentAsync = false;

  var canDocumentWrite = function() {
    return !wentAsync && doc.readyState == "loading";
  };

  var asyncLoad = (function() {
    var loadOrder = [];
    var loadState = {};

    function loadPending() {
      for (var i = 0, len = loadOrder.length; i < len; i++) {
        var uri = loadOrder[i];
        var state = loadState[uri];

        if (typeof state === "string") {
          loadState[uri] = true;
          if (state != "") {
            var code = state + "\n//# sourceURL=" + uri + "\n";
            goog.globalEval(code);
          }
        } else if (state === true) {
          continue;
        } else {
          break;
        }
      }
    }

    // ie11 doesn't have fetch, use xhr instead
    // FIXME: not sure if fetch provides any benefit over xhr
    if (typeof window.fetch === "undefined") {
      return function asyncXhr(uri) {
        loadOrder.push(uri);
        loadState[uri] = false;
        var req = new XMLHttpRequest();
        req.onload = function(e) {
          loadState[uri] = req.responseText;
          loadPending();
        };
        req.open("GET", uri);
        req.send();
      }
    } else {
      function responseText(response) {
        // FIXME: check status
        return response.text();
      }

      function evalFetch(uri) {
        return function(code) {
          loadState[uri] = code;
          loadPending();
        };
      }

      return function asyncFetch(uri) {
        if (loadState[uri] == undefined) {
          loadState[uri] = false;
          loadOrder.push(uri);
          fetch(uri)
            .then(responseText)
            .then(evalFetch(uri));
        }
      };
    }
  })();

  env.load = function(opts, paths) {
    var docWrite = opts.forceAsync ? false : canDocumentWrite();

    paths.forEach(function(path) {
      if (!loadedFiles[path]) {
        loadedFiles[path] = true;

        var uri = CLOSURE_BASE_PATH + path;

        if (docWrite) {
          document.write(
            "<script src='" + uri + "' type='text/javascript'></script>"
          );
        } else {
          // once async always async
          wentAsync = true;
          asyncLoad(uri);
        }
      }
    });
  };

  env.isLoaded = function(path) {
    return loadedFiles[path] || false; // false is better than undefined
  };

  env.setLoaded = function(path) {
    loadedFiles[path] = true;
  };

  env.evalLoad = function(path, sourceMap, code) {
    loadedFiles[path] = true;
    code += ("\n//# sourceURL=" + CLOSURE_BASE_PATH + path);
    if (sourceMap) {
      code += ("\n//# sourceMappingURL=" + path + ".map");
    }
    try {
      goog.globalEval(code);
    } catch (e) {
      console.warn("failed to load", path, e);
    }
  }

  return env;
}.call(this);


goog.global["$CLJS"] = goog.global;


if(typeof Math.imul == "undefined" || (Math.imul(0xffffffff,5) == 0)) {
    Math.imul = function (a, b) {
        var ah  = (a >>> 16) & 0xffff;
        var al = a & 0xffff;
        var bh  = (b >>> 16) & 0xffff;
        var bl = b & 0xffff;
        // the shift by 0 fixes the sign on the high part
        // the final |0 converts the unsigned value into a signed value
        return ((al * bl) + (((ah * bl + al * bh) << 16) >>> 0)|0);
    }
}
SHADOW_ENV.evalLoad("goog.debug.error.js", false , "// Copyright 2009 The Closure Library Authors. All Rights Reserved.\n//\n// Licensed under the Apache License, Version 2.0 (the \x22License\x22);\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//      http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an \x22AS-IS\x22 BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\n\n/**\n * @fileoverview Provides a base class for custom Error objects such that the\n * stack is correctly maintained.\n *\n * You should never need to throw goog.debug.Error(msg) directly, Error(msg) is\n * sufficient.\n *\n */\n\ngoog.provide(\x27goog.debug.Error\x27);\n\n\n\n/**\n * Base class for custom error objects.\n * @param {*\x3d} opt_msg The message associated with the error.\n * @constructor\n * @extends {Error}\n */\ngoog.debug.Error \x3d function(opt_msg) {\n\n  // Attempt to ensure there is a stack trace.\n  if (Error.captureStackTrace) {\n    Error.captureStackTrace(this, goog.debug.Error);\n  } else {\n    var stack \x3d new Error().stack;\n    if (stack) {\n      this.stack \x3d stack;\n    }\n  }\n\n  if (opt_msg) {\n    this.message \x3d String(opt_msg);\n  }\n\n  /**\n   * Whether to report this error to the server. Setting this to false will\n   * cause the error reporter to not report the error back to the server,\n   * which can be useful if the client knows that the error has already been\n   * logged on the server.\n   * @type {boolean}\n   */\n  this.reportErrorToServer \x3d true;\n};\ngoog.inherits(goog.debug.Error, Error);\n\n\n/** @override */\ngoog.debug.Error.prototype.name \x3d \x27CustomError\x27;\n");
SHADOW_ENV.evalLoad("goog.dom.nodetype.js", false , "// Copyright 2006 The Closure Library Authors. All Rights Reserved.\n//\n// Licensed under the Apache License, Version 2.0 (the \x22License\x22);\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//      http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an \x22AS-IS\x22 BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\n\n/**\n * @fileoverview Definition of goog.dom.NodeType.\n */\n\ngoog.provide(\x27goog.dom.NodeType\x27);\n\n\n/**\n * Constants for the nodeType attribute in the Node interface.\n *\n * These constants match those specified in the Node interface. These are\n * usually present on the Node object in recent browsers, but not in older\n * browsers (specifically, early IEs) and thus are given here.\n *\n * In some browsers (early IEs), these are not defined on the Node object,\n * so they are provided here.\n *\n * See http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-1950641247\n * @enum {number}\n */\ngoog.dom.NodeType \x3d {\n  ELEMENT: 1,\n  ATTRIBUTE: 2,\n  TEXT: 3,\n  CDATA_SECTION: 4,\n  ENTITY_REFERENCE: 5,\n  ENTITY: 6,\n  PROCESSING_INSTRUCTION: 7,\n  COMMENT: 8,\n  DOCUMENT: 9,\n  DOCUMENT_TYPE: 10,\n  DOCUMENT_FRAGMENT: 11,\n  NOTATION: 12\n};\n");
SHADOW_ENV.evalLoad("goog.string.string.js", false , "// Copyright 2006 The Closure Library Authors. All Rights Reserved.\n//\n// Licensed under the Apache License, Version 2.0 (the \x22License\x22);\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//      http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an \x22AS-IS\x22 BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\n\n/**\n * @fileoverview Utilities for string manipulation.\n * @author arv@google.com (Erik Arvidsson)\n */\n\n\n/**\n * Namespace for string utilities\n */\ngoog.provide(\x27goog.string\x27);\ngoog.provide(\x27goog.string.Unicode\x27);\n\n\n/**\n * @define {boolean} Enables HTML escaping of lowercase letter \x22e\x22 which helps\n * with detection of double-escaping as this letter is frequently used.\n */\ngoog.define(\x27goog.string.DETECT_DOUBLE_ESCAPING\x27, false);\n\n\n/**\n * @define {boolean} Whether to force non-dom html unescaping.\n */\ngoog.define(\x27goog.string.FORCE_NON_DOM_HTML_UNESCAPING\x27, false);\n\n\n/**\n * Common Unicode string characters.\n * @enum {string}\n */\ngoog.string.Unicode \x3d {\n  NBSP: \x27\\xa0\x27\n};\n\n\n/**\n * Fast prefix-checker.\n * @param {string} str The string to check.\n * @param {string} prefix A string to look for at the start of {@code str}.\n * @return {boolean} True if {@code str} begins with {@code prefix}.\n */\ngoog.string.startsWith \x3d function(str, prefix) {\n  return str.lastIndexOf(prefix, 0) \x3d\x3d 0;\n};\n\n\n/**\n * Fast suffix-checker.\n * @param {string} str The string to check.\n * @param {string} suffix A string to look for at the end of {@code str}.\n * @return {boolean} True if {@code str} ends with {@code suffix}.\n */\ngoog.string.endsWith \x3d function(str, suffix) {\n  var l \x3d str.length - suffix.length;\n  return l \x3e\x3d 0 \x26\x26 str.indexOf(suffix, l) \x3d\x3d l;\n};\n\n\n/**\n * Case-insensitive prefix-checker.\n * @param {string} str The string to check.\n * @param {string} prefix  A string to look for at the end of {@code str}.\n * @return {boolean} True if {@code str} begins with {@code prefix} (ignoring\n *     case).\n */\ngoog.string.caseInsensitiveStartsWith \x3d function(str, prefix) {\n  return goog.string.caseInsensitiveCompare(\n             prefix, str.substr(0, prefix.length)) \x3d\x3d 0;\n};\n\n\n/**\n * Case-insensitive suffix-checker.\n * @param {string} str The string to check.\n * @param {string} suffix A string to look for at the end of {@code str}.\n * @return {boolean} True if {@code str} ends with {@code suffix} (ignoring\n *     case).\n */\ngoog.string.caseInsensitiveEndsWith \x3d function(str, suffix) {\n  return (\n      goog.string.caseInsensitiveCompare(\n          suffix, str.substr(str.length - suffix.length, suffix.length)) \x3d\x3d 0);\n};\n\n\n/**\n * Case-insensitive equality checker.\n * @param {string} str1 First string to check.\n * @param {string} str2 Second string to check.\n * @return {boolean} True if {@code str1} and {@code str2} are the same string,\n *     ignoring case.\n */\ngoog.string.caseInsensitiveEquals \x3d function(str1, str2) {\n  return str1.toLowerCase() \x3d\x3d str2.toLowerCase();\n};\n\n\n/**\n * Does simple python-style string substitution.\n * subs(\x22foo%s hot%s\x22, \x22bar\x22, \x22dog\x22) becomes \x22foobar hotdog\x22.\n * @param {string} str The string containing the pattern.\n * @param {...*} var_args The items to substitute into the pattern.\n * @return {string} A copy of {@code str} in which each occurrence of\n *     {@code %s} has been replaced an argument from {@code var_args}.\n */\ngoog.string.subs \x3d function(str, var_args) {\n  var splitParts \x3d str.split(\x27%s\x27);\n  var returnString \x3d \x27\x27;\n\n  var subsArguments \x3d Array.prototype.slice.call(arguments, 1);\n  while (subsArguments.length \x26\x26\n         // Replace up to the last split part. We are inserting in the\n         // positions between split parts.\n         splitParts.length \x3e 1) {\n    returnString +\x3d splitParts.shift() + subsArguments.shift();\n  }\n\n  return returnString + splitParts.join(\x27%s\x27);  // Join unused \x27%s\x27\n};\n\n\n/**\n * Converts multiple whitespace chars (spaces, non-breaking-spaces, new lines\n * and tabs) to a single space, and strips leading and trailing whitespace.\n * @param {string} str Input string.\n * @return {string} A copy of {@code str} with collapsed whitespace.\n */\ngoog.string.collapseWhitespace \x3d function(str) {\n  // Since IE doesn\x27t include non-breaking-space (0xa0) in their \\s character\n  // class (as required by section 7.2 of the ECMAScript spec), we explicitly\n  // include it in the regexp to enforce consistent cross-browser behavior.\n  return str.replace(/[\\s\\xa0]+/g, \x27 \x27).replace(/^\\s+|\\s+$/g, \x27\x27);\n};\n\n\n/**\n * Checks if a string is empty or contains only whitespaces.\n * @param {string} str The string to check.\n * @return {boolean} Whether {@code str} is empty or whitespace only.\n */\ngoog.string.isEmptyOrWhitespace \x3d function(str) {\n  // testing length \x3d\x3d 0 first is actually slower in all browsers (about the\n  // same in Opera).\n  // Since IE doesn\x27t include non-breaking-space (0xa0) in their \\s character\n  // class (as required by section 7.2 of the ECMAScript spec), we explicitly\n  // include it in the regexp to enforce consistent cross-browser behavior.\n  return /^[\\s\\xa0]*$/.test(str);\n};\n\n\n/**\n * Checks if a string is empty.\n * @param {string} str The string to check.\n * @return {boolean} Whether {@code str} is empty.\n */\ngoog.string.isEmptyString \x3d function(str) {\n  return str.length \x3d\x3d 0;\n};\n\n\n/**\n * Checks if a string is empty or contains only whitespaces.\n *\n * @param {string} str The string to check.\n * @return {boolean} Whether {@code str} is empty or whitespace only.\n * @deprecated Use goog.string.isEmptyOrWhitespace instead.\n */\ngoog.string.isEmpty \x3d goog.string.isEmptyOrWhitespace;\n\n\n/**\n * Checks if a string is null, undefined, empty or contains only whitespaces.\n * @param {*} str The string to check.\n * @return {boolean} Whether {@code str} is null, undefined, empty, or\n *     whitespace only.\n * @deprecated Use goog.string.isEmptyOrWhitespace(goog.string.makeSafe(str))\n *     instead.\n */\ngoog.string.isEmptyOrWhitespaceSafe \x3d function(str) {\n  return goog.string.isEmptyOrWhitespace(goog.string.makeSafe(str));\n};\n\n\n/**\n * Checks if a string is null, undefined, empty or contains only whitespaces.\n *\n * @param {*} str The string to check.\n * @return {boolean} Whether {@code str} is null, undefined, empty, or\n *     whitespace only.\n * @deprecated Use goog.string.isEmptyOrWhitespace instead.\n */\ngoog.string.isEmptySafe \x3d goog.string.isEmptyOrWhitespaceSafe;\n\n\n/**\n * Checks if a string is all breaking whitespace.\n * @param {string} str The string to check.\n * @return {boolean} Whether the string is all breaking whitespace.\n */\ngoog.string.isBreakingWhitespace \x3d function(str) {\n  return !/[^\\t\\n\\r ]/.test(str);\n};\n\n\n/**\n * Checks if a string contains all letters.\n * @param {string} str string to check.\n * @return {boolean} True if {@code str} consists entirely of letters.\n */\ngoog.string.isAlpha \x3d function(str) {\n  return !/[^a-zA-Z]/.test(str);\n};\n\n\n/**\n * Checks if a string contains only numbers.\n * @param {*} str string to check. If not a string, it will be\n *     casted to one.\n * @return {boolean} True if {@code str} is numeric.\n */\ngoog.string.isNumeric \x3d function(str) {\n  return !/[^0-9]/.test(str);\n};\n\n\n/**\n * Checks if a string contains only numbers or letters.\n * @param {string} str string to check.\n * @return {boolean} True if {@code str} is alphanumeric.\n */\ngoog.string.isAlphaNumeric \x3d function(str) {\n  return !/[^a-zA-Z0-9]/.test(str);\n};\n\n\n/**\n * Checks if a character is a space character.\n * @param {string} ch Character to check.\n * @return {boolean} True if {@code ch} is a space.\n */\ngoog.string.isSpace \x3d function(ch) {\n  return ch \x3d\x3d \x27 \x27;\n};\n\n\n/**\n * Checks if a character is a valid unicode character.\n * @param {string} ch Character to check.\n * @return {boolean} True if {@code ch} is a valid unicode character.\n */\ngoog.string.isUnicodeChar \x3d function(ch) {\n  return ch.length \x3d\x3d 1 \x26\x26 ch \x3e\x3d \x27 \x27 \x26\x26 ch \x3c\x3d \x27~\x27 ||\n      ch \x3e\x3d \x27\\u0080\x27 \x26\x26 ch \x3c\x3d \x27\\uFFFD\x27;\n};\n\n\n/**\n * Takes a string and replaces newlines with a space. Multiple lines are\n * replaced with a single space.\n * @param {string} str The string from which to strip newlines.\n * @return {string} A copy of {@code str} stripped of newlines.\n */\ngoog.string.stripNewlines \x3d function(str) {\n  return str.replace(/(\\r\\n|\\r|\\n)+/g, \x27 \x27);\n};\n\n\n/**\n * Replaces Windows and Mac new lines with unix style: \\r or \\r\\n with \\n.\n * @param {string} str The string to in which to canonicalize newlines.\n * @return {string} {@code str} A copy of {@code} with canonicalized newlines.\n */\ngoog.string.canonicalizeNewlines \x3d function(str) {\n  return str.replace(/(\\r\\n|\\r|\\n)/g, \x27\\n\x27);\n};\n\n\n/**\n * Normalizes whitespace in a string, replacing all whitespace chars with\n * a space.\n * @param {string} str The string in which to normalize whitespace.\n * @return {string} A copy of {@code str} with all whitespace normalized.\n */\ngoog.string.normalizeWhitespace \x3d function(str) {\n  return str.replace(/\\xa0|\\s/g, \x27 \x27);\n};\n\n\n/**\n * Normalizes spaces in a string, replacing all consecutive spaces and tabs\n * with a single space. Replaces non-breaking space with a space.\n * @param {string} str The string in which to normalize spaces.\n * @return {string} A copy of {@code str} with all consecutive spaces and tabs\n *    replaced with a single space.\n */\ngoog.string.normalizeSpaces \x3d function(str) {\n  return str.replace(/\\xa0|[ \\t]+/g, \x27 \x27);\n};\n\n\n/**\n * Removes the breaking spaces from the left and right of the string and\n * collapses the sequences of breaking spaces in the middle into single spaces.\n * The original and the result strings render the same way in HTML.\n * @param {string} str A string in which to collapse spaces.\n * @return {string} Copy of the string with normalized breaking spaces.\n */\ngoog.string.collapseBreakingSpaces \x3d function(str) {\n  return str.replace(/[\\t\\r\\n ]+/g, \x27 \x27)\n      .replace(/^[\\t\\r\\n ]+|[\\t\\r\\n ]+$/g, \x27\x27);\n};\n\n\n/**\n * Trims white spaces to the left and right of a string.\n * @param {string} str The string to trim.\n * @return {string} A trimmed copy of {@code str}.\n */\ngoog.string.trim \x3d\n    (goog.TRUSTED_SITE \x26\x26 String.prototype.trim) ? function(str) {\n      return str.trim();\n    } : function(str) {\n      // Since IE doesn\x27t include non-breaking-space (0xa0) in their \\s\n      // character class (as required by section 7.2 of the ECMAScript spec),\n      // we explicitly include it in the regexp to enforce consistent\n      // cross-browser behavior.\n      return str.replace(/^[\\s\\xa0]+|[\\s\\xa0]+$/g, \x27\x27);\n    };\n\n\n/**\n * Trims whitespaces at the left end of a string.\n * @param {string} str The string to left trim.\n * @return {string} A trimmed copy of {@code str}.\n */\ngoog.string.trimLeft \x3d function(str) {\n  // Since IE doesn\x27t include non-breaking-space (0xa0) in their \\s character\n  // class (as required by section 7.2 of the ECMAScript spec), we explicitly\n  // include it in the regexp to enforce consistent cross-browser behavior.\n  return str.replace(/^[\\s\\xa0]+/, \x27\x27);\n};\n\n\n/**\n * Trims whitespaces at the right end of a string.\n * @param {string} str The string to right trim.\n * @return {string} A trimmed copy of {@code str}.\n */\ngoog.string.trimRight \x3d function(str) {\n  // Since IE doesn\x27t include non-breaking-space (0xa0) in their \\s character\n  // class (as required by section 7.2 of the ECMAScript spec), we explicitly\n  // include it in the regexp to enforce consistent cross-browser behavior.\n  return str.replace(/[\\s\\xa0]+$/, \x27\x27);\n};\n\n\n/**\n * A string comparator that ignores case.\n * -1 \x3d str1 less than str2\n *  0 \x3d str1 equals str2\n *  1 \x3d str1 greater than str2\n *\n * @param {string} str1 The string to compare.\n * @param {string} str2 The string to compare {@code str1} to.\n * @return {number} The comparator result, as described above.\n */\ngoog.string.caseInsensitiveCompare \x3d function(str1, str2) {\n  var test1 \x3d String(str1).toLowerCase();\n  var test2 \x3d String(str2).toLowerCase();\n\n  if (test1 \x3c test2) {\n    return -1;\n  } else if (test1 \x3d\x3d test2) {\n    return 0;\n  } else {\n    return 1;\n  }\n};\n\n\n/**\n * Compares two strings interpreting their numeric substrings as numbers.\n *\n * @param {string} str1 First string.\n * @param {string} str2 Second string.\n * @param {!RegExp} tokenizerRegExp Splits a string into substrings of\n *     non-negative integers, non-numeric characters and optionally fractional\n *     numbers starting with a decimal point.\n * @return {number} Negative if str1 \x3c str2, 0 is str1 \x3d\x3d str2, positive if\n *     str1 \x3e str2.\n * @private\n */\ngoog.string.numberAwareCompare_ \x3d function(str1, str2, tokenizerRegExp) {\n  if (str1 \x3d\x3d str2) {\n    return 0;\n  }\n  if (!str1) {\n    return -1;\n  }\n  if (!str2) {\n    return 1;\n  }\n\n  // Using match to split the entire string ahead of time turns out to be faster\n  // for most inputs than using RegExp.exec or iterating over each character.\n  var tokens1 \x3d str1.toLowerCase().match(tokenizerRegExp);\n  var tokens2 \x3d str2.toLowerCase().match(tokenizerRegExp);\n\n  var count \x3d Math.min(tokens1.length, tokens2.length);\n\n  for (var i \x3d 0; i \x3c count; i++) {\n    var a \x3d tokens1[i];\n    var b \x3d tokens2[i];\n\n    // Compare pairs of tokens, returning if one token sorts before the other.\n    if (a !\x3d b) {\n      // Only if both tokens are integers is a special comparison required.\n      // Decimal numbers are sorted as strings (e.g., \x27.09\x27 \x3c \x27.1\x27).\n      var num1 \x3d parseInt(a, 10);\n      if (!isNaN(num1)) {\n        var num2 \x3d parseInt(b, 10);\n        if (!isNaN(num2) \x26\x26 num1 - num2) {\n          return num1 - num2;\n        }\n      }\n      return a \x3c b ? -1 : 1;\n    }\n  }\n\n  // If one string is a substring of the other, the shorter string sorts first.\n  if (tokens1.length !\x3d tokens2.length) {\n    return tokens1.length - tokens2.length;\n  }\n\n  // The two strings must be equivalent except for case (perfect equality is\n  // tested at the head of the function.) Revert to default ASCII string\n  // comparison to stabilize the sort.\n  return str1 \x3c str2 ? -1 : 1;\n};\n\n\n/**\n * String comparison function that handles non-negative integer numbers in a\n * way humans might expect. Using this function, the string \x27File 2.jpg\x27 sorts\n * before \x27File 10.jpg\x27, and \x27Version 1.9\x27 before \x27Version 1.10\x27. The comparison\n * is mostly case-insensitive, though strings that are identical except for case\n * are sorted with the upper-case strings before lower-case.\n *\n * This comparison function is up to 50x slower than either the default or the\n * case-insensitive compare. It should not be used in time-critical code, but\n * should be fast enough to sort several hundred short strings (like filenames)\n * with a reasonable delay.\n *\n * @param {string} str1 The string to compare in a numerically sensitive way.\n * @param {string} str2 The string to compare {@code str1} to.\n * @return {number} less than 0 if str1 \x3c str2, 0 if str1 \x3d\x3d str2, greater than\n *     0 if str1 \x3e str2.\n */\ngoog.string.intAwareCompare \x3d function(str1, str2) {\n  return goog.string.numberAwareCompare_(str1, str2, /\\d+|\\D+/g);\n};\n\n\n/**\n * String comparison function that handles non-negative integer and fractional\n * numbers in a way humans might expect. Using this function, the string\n * \x27File 2.jpg\x27 sorts before \x27File 10.jpg\x27, and \x273.14\x27 before \x273.2\x27. Equivalent\n * to {@link goog.string.intAwareCompare} apart from the way how it interprets\n * dots.\n *\n * @param {string} str1 The string to compare in a numerically sensitive way.\n * @param {string} str2 The string to compare {@code str1} to.\n * @return {number} less than 0 if str1 \x3c str2, 0 if str1 \x3d\x3d str2, greater than\n *     0 if str1 \x3e str2.\n */\ngoog.string.floatAwareCompare \x3d function(str1, str2) {\n  return goog.string.numberAwareCompare_(str1, str2, /\\d+|\\.\\d+|\\D+/g);\n};\n\n\n/**\n * Alias for {@link goog.string.floatAwareCompare}.\n *\n * @param {string} str1\n * @param {string} str2\n * @return {number}\n */\ngoog.string.numerateCompare \x3d goog.string.floatAwareCompare;\n\n\n/**\n * URL-encodes a string\n * @param {*} str The string to url-encode.\n * @return {string} An encoded copy of {@code str} that is safe for urls.\n *     Note that \x27#\x27, \x27:\x27, and other characters used to delimit portions\n *     of URLs *will* be encoded.\n */\ngoog.string.urlEncode \x3d function(str) {\n  return encodeURIComponent(String(str));\n};\n\n\n/**\n * URL-decodes the string. We need to specially handle \x27+\x27s because\n * the javascript library doesn\x27t convert them to spaces.\n * @param {string} str The string to url decode.\n * @return {string} The decoded {@code str}.\n */\ngoog.string.urlDecode \x3d function(str) {\n  return decodeURIComponent(str.replace(/\\+/g, \x27 \x27));\n};\n\n\n/**\n * Converts \\n to \x3cbr\x3es or \x3cbr /\x3es.\n * @param {string} str The string in which to convert newlines.\n * @param {boolean\x3d} opt_xml Whether to use XML compatible tags.\n * @return {string} A copy of {@code str} with converted newlines.\n */\ngoog.string.newLineToBr \x3d function(str, opt_xml) {\n  return str.replace(/(\\r\\n|\\r|\\n)/g, opt_xml ? \x27\x3cbr /\x3e\x27 : \x27\x3cbr\x3e\x27);\n};\n\n\n/**\n * Escapes double quote \x27\x22\x27 and single quote \x27\\\x27\x27 characters in addition to\n * \x27\x26\x27, \x27\x3c\x27, and \x27\x3e\x27 so that a string can be included in an HTML tag attribute\n * value within double or single quotes.\n *\n * It should be noted that \x3e doesn\x27t need to be escaped for the HTML or XML to\n * be valid, but it has been decided to escape it for consistency with other\n * implementations.\n *\n * With goog.string.DETECT_DOUBLE_ESCAPING, this function escapes also the\n * lowercase letter \x22e\x22.\n *\n * NOTE(user):\n * HtmlEscape is often called during the generation of large blocks of HTML.\n * Using statics for the regular expressions and strings is an optimization\n * that can more than half the amount of time IE spends in this function for\n * large apps, since strings and regexes both contribute to GC allocations.\n *\n * Testing for the presence of a character before escaping increases the number\n * of function calls, but actually provides a speed increase for the average\n * case -- since the average case often doesn\x27t require the escaping of all 4\n * characters and indexOf() is much cheaper than replace().\n * The worst case does suffer slightly from the additional calls, therefore the\n * opt_isLikelyToContainHtmlChars option has been included for situations\n * where all 4 HTML entities are very likely to be present and need escaping.\n *\n * Some benchmarks (times tended to fluctuate +-0.05ms):\n *                                     FireFox                     IE6\n * (no chars / average (mix of cases) / all 4 chars)\n * no checks                     0.13 / 0.22 / 0.22         0.23 / 0.53 / 0.80\n * indexOf                       0.08 / 0.17 / 0.26         0.22 / 0.54 / 0.84\n * indexOf + re test             0.07 / 0.17 / 0.28         0.19 / 0.50 / 0.85\n *\n * An additional advantage of checking if replace actually needs to be called\n * is a reduction in the number of object allocations, so as the size of the\n * application grows the difference between the various methods would increase.\n *\n * @param {string} str string to be escaped.\n * @param {boolean\x3d} opt_isLikelyToContainHtmlChars Don\x27t perform a check to see\n *     if the character needs replacing - use this option if you expect each of\n *     the characters to appear often. Leave false if you expect few html\n *     characters to occur in your strings, such as if you are escaping HTML.\n * @return {string} An escaped copy of {@code str}.\n */\ngoog.string.htmlEscape \x3d function(str, opt_isLikelyToContainHtmlChars) {\n\n  if (opt_isLikelyToContainHtmlChars) {\n    str \x3d str.replace(goog.string.AMP_RE_, \x27\x26amp;\x27)\n              .replace(goog.string.LT_RE_, \x27\x26lt;\x27)\n              .replace(goog.string.GT_RE_, \x27\x26gt;\x27)\n              .replace(goog.string.QUOT_RE_, \x27\x26quot;\x27)\n              .replace(goog.string.SINGLE_QUOTE_RE_, \x27\x26#39;\x27)\n              .replace(goog.string.NULL_RE_, \x27\x26#0;\x27);\n    if (goog.string.DETECT_DOUBLE_ESCAPING) {\n      str \x3d str.replace(goog.string.E_RE_, \x27\x26#101;\x27);\n    }\n    return str;\n\n  } else {\n    // quick test helps in the case when there are no chars to replace, in\n    // worst case this makes barely a difference to the time taken\n    if (!goog.string.ALL_RE_.test(str)) return str;\n\n    // str.indexOf is faster than regex.test in this case\n    if (str.indexOf(\x27\x26\x27) !\x3d -1) {\n      str \x3d str.replace(goog.string.AMP_RE_, \x27\x26amp;\x27);\n    }\n    if (str.indexOf(\x27\x3c\x27) !\x3d -1) {\n      str \x3d str.replace(goog.string.LT_RE_, \x27\x26lt;\x27);\n    }\n    if (str.indexOf(\x27\x3e\x27) !\x3d -1) {\n      str \x3d str.replace(goog.string.GT_RE_, \x27\x26gt;\x27);\n    }\n    if (str.indexOf(\x27\x22\x27) !\x3d -1) {\n      str \x3d str.replace(goog.string.QUOT_RE_, \x27\x26quot;\x27);\n    }\n    if (str.indexOf(\x27\\\x27\x27) !\x3d -1) {\n      str \x3d str.replace(goog.string.SINGLE_QUOTE_RE_, \x27\x26#39;\x27);\n    }\n    if (str.indexOf(\x27\\x00\x27) !\x3d -1) {\n      str \x3d str.replace(goog.string.NULL_RE_, \x27\x26#0;\x27);\n    }\n    if (goog.string.DETECT_DOUBLE_ESCAPING \x26\x26 str.indexOf(\x27e\x27) !\x3d -1) {\n      str \x3d str.replace(goog.string.E_RE_, \x27\x26#101;\x27);\n    }\n    return str;\n  }\n};\n\n\n/**\n * Regular expression that matches an ampersand, for use in escaping.\n * @const {!RegExp}\n * @private\n */\ngoog.string.AMP_RE_ \x3d /\x26/g;\n\n\n/**\n * Regular expression that matches a less than sign, for use in escaping.\n * @const {!RegExp}\n * @private\n */\ngoog.string.LT_RE_ \x3d /\x3c/g;\n\n\n/**\n * Regular expression that matches a greater than sign, for use in escaping.\n * @const {!RegExp}\n * @private\n */\ngoog.string.GT_RE_ \x3d /\x3e/g;\n\n\n/**\n * Regular expression that matches a double quote, for use in escaping.\n * @const {!RegExp}\n * @private\n */\ngoog.string.QUOT_RE_ \x3d /\x22/g;\n\n\n/**\n * Regular expression that matches a single quote, for use in escaping.\n * @const {!RegExp}\n * @private\n */\ngoog.string.SINGLE_QUOTE_RE_ \x3d /\x27/g;\n\n\n/**\n * Regular expression that matches null character, for use in escaping.\n * @const {!RegExp}\n * @private\n */\ngoog.string.NULL_RE_ \x3d /\\x00/g;\n\n\n/**\n * Regular expression that matches a lowercase letter \x22e\x22, for use in escaping.\n * @const {!RegExp}\n * @private\n */\ngoog.string.E_RE_ \x3d /e/g;\n\n\n/**\n * Regular expression that matches any character that needs to be escaped.\n * @const {!RegExp}\n * @private\n */\ngoog.string.ALL_RE_ \x3d\n    (goog.string.DETECT_DOUBLE_ESCAPING ? /[\\x00\x26\x3c\x3e\x22\x27e]/ : /[\\x00\x26\x3c\x3e\x22\x27]/);\n\n\n/**\n * Unescapes an HTML string.\n *\n * @param {string} str The string to unescape.\n * @return {string} An unescaped copy of {@code str}.\n */\ngoog.string.unescapeEntities \x3d function(str) {\n  if (goog.string.contains(str, \x27\x26\x27)) {\n    // We are careful not to use a DOM if we do not have one or we explicitly\n    // requested non-DOM html unescaping.\n    if (!goog.string.FORCE_NON_DOM_HTML_UNESCAPING \x26\x26\n        \x27document\x27 in goog.global) {\n      return goog.string.unescapeEntitiesUsingDom_(str);\n    } else {\n      // Fall back on pure XML entities\n      return goog.string.unescapePureXmlEntities_(str);\n    }\n  }\n  return str;\n};\n\n\n/**\n * Unescapes a HTML string using the provided document.\n *\n * @param {string} str The string to unescape.\n * @param {!Document} document A document to use in escaping the string.\n * @return {string} An unescaped copy of {@code str}.\n */\ngoog.string.unescapeEntitiesWithDocument \x3d function(str, document) {\n  if (goog.string.contains(str, \x27\x26\x27)) {\n    return goog.string.unescapeEntitiesUsingDom_(str, document);\n  }\n  return str;\n};\n\n\n/**\n * Unescapes an HTML string using a DOM to resolve non-XML, non-numeric\n * entities. This function is XSS-safe and whitespace-preserving.\n * @private\n * @param {string} str The string to unescape.\n * @param {Document\x3d} opt_document An optional document to use for creating\n *     elements. If this is not specified then the default window.document\n *     will be used.\n * @return {string} The unescaped {@code str} string.\n */\ngoog.string.unescapeEntitiesUsingDom_ \x3d function(str, opt_document) {\n  /** @type {!Object\x3cstring, string\x3e} */\n  var seen \x3d {\x27\x26amp;\x27: \x27\x26\x27, \x27\x26lt;\x27: \x27\x3c\x27, \x27\x26gt;\x27: \x27\x3e\x27, \x27\x26quot;\x27: \x27\x22\x27};\n  var div;\n  if (opt_document) {\n    div \x3d opt_document.createElement(\x27div\x27);\n  } else {\n    div \x3d goog.global.document.createElement(\x27div\x27);\n  }\n  // Match as many valid entity characters as possible. If the actual entity\n  // happens to be shorter, it will still work as innerHTML will return the\n  // trailing characters unchanged. Since the entity characters do not include\n  // open angle bracket, there is no chance of XSS from the innerHTML use.\n  // Since no whitespace is passed to innerHTML, whitespace is preserved.\n  return str.replace(goog.string.HTML_ENTITY_PATTERN_, function(s, entity) {\n    // Check for cached entity.\n    var value \x3d seen[s];\n    if (value) {\n      return value;\n    }\n    // Check for numeric entity.\n    if (entity.charAt(0) \x3d\x3d \x27#\x27) {\n      // Prefix with 0 so that hex entities (e.g. \x26#x10) parse as hex numbers.\n      var n \x3d Number(\x270\x27 + entity.substr(1));\n      if (!isNaN(n)) {\n        value \x3d String.fromCharCode(n);\n      }\n    }\n    // Fall back to innerHTML otherwise.\n    if (!value) {\n      // Append a non-entity character to avoid a bug in Webkit that parses\n      // an invalid entity at the end of innerHTML text as the empty string.\n      div.innerHTML \x3d s + \x27 \x27;\n      // Then remove the trailing character from the result.\n      value \x3d div.firstChild.nodeValue.slice(0, -1);\n    }\n    // Cache and return.\n    return seen[s] \x3d value;\n  });\n};\n\n\n/**\n * Unescapes XML entities.\n * @private\n * @param {string} str The string to unescape.\n * @return {string} An unescaped copy of {@code str}.\n */\ngoog.string.unescapePureXmlEntities_ \x3d function(str) {\n  return str.replace(/\x26([^;]+);/g, function(s, entity) {\n    switch (entity) {\n      case \x27amp\x27:\n        return \x27\x26\x27;\n      case \x27lt\x27:\n        return \x27\x3c\x27;\n      case \x27gt\x27:\n        return \x27\x3e\x27;\n      case \x27quot\x27:\n        return \x27\x22\x27;\n      default:\n        if (entity.charAt(0) \x3d\x3d \x27#\x27) {\n          // Prefix with 0 so that hex entities (e.g. \x26#x10) parse as hex.\n          var n \x3d Number(\x270\x27 + entity.substr(1));\n          if (!isNaN(n)) {\n            return String.fromCharCode(n);\n          }\n        }\n        // For invalid entities we just return the entity\n        return s;\n    }\n  });\n};\n\n\n/**\n * Regular expression that matches an HTML entity.\n * See also HTML5: Tokenization / Tokenizing character references.\n * @private\n * @type {!RegExp}\n */\ngoog.string.HTML_ENTITY_PATTERN_ \x3d /\x26([^;\\s\x3c\x26]+);?/g;\n\n\n/**\n * Do escaping of whitespace to preserve spatial formatting. We use character\n * entity #160 to make it safer for xml.\n * @param {string} str The string in which to escape whitespace.\n * @param {boolean\x3d} opt_xml Whether to use XML compatible tags.\n * @return {string} An escaped copy of {@code str}.\n */\ngoog.string.whitespaceEscape \x3d function(str, opt_xml) {\n  // This doesn\x27t use goog.string.preserveSpaces for backwards compatibility.\n  return goog.string.newLineToBr(str.replace(/  /g, \x27 \x26#160;\x27), opt_xml);\n};\n\n\n/**\n * Preserve spaces that would be otherwise collapsed in HTML by replacing them\n * with non-breaking space Unicode characters.\n * @param {string} str The string in which to preserve whitespace.\n * @return {string} A copy of {@code str} with preserved whitespace.\n */\ngoog.string.preserveSpaces \x3d function(str) {\n  return str.replace(/(^|[\\n ]) /g, \x27$1\x27 + goog.string.Unicode.NBSP);\n};\n\n\n/**\n * Strip quote characters around a string.  The second argument is a string of\n * characters to treat as quotes.  This can be a single character or a string of\n * multiple character and in that case each of those are treated as possible\n * quote characters. For example:\n *\n * \x3cpre\x3e\n * goog.string.stripQuotes(\x27\x22abc\x22\x27, \x27\x22`\x27) --\x3e \x27abc\x27\n * goog.string.stripQuotes(\x27`abc`\x27, \x27\x22`\x27) --\x3e \x27abc\x27\n * \x3c/pre\x3e\n *\n * @param {string} str The string to strip.\n * @param {string} quoteChars The quote characters to strip.\n * @return {string} A copy of {@code str} without the quotes.\n */\ngoog.string.stripQuotes \x3d function(str, quoteChars) {\n  var length \x3d quoteChars.length;\n  for (var i \x3d 0; i \x3c length; i++) {\n    var quoteChar \x3d length \x3d\x3d 1 ? quoteChars : quoteChars.charAt(i);\n    if (str.charAt(0) \x3d\x3d quoteChar \x26\x26 str.charAt(str.length - 1) \x3d\x3d quoteChar) {\n      return str.substring(1, str.length - 1);\n    }\n  }\n  return str;\n};\n\n\n/**\n * Truncates a string to a certain length and adds \x27...\x27 if necessary.  The\n * length also accounts for the ellipsis, so a maximum length of 10 and a string\n * \x27Hello World!\x27 produces \x27Hello W...\x27.\n * @param {string} str The string to truncate.\n * @param {number} chars Max number of characters.\n * @param {boolean\x3d} opt_protectEscapedCharacters Whether to protect escaped\n *     characters from being cut off in the middle.\n * @return {string} The truncated {@code str} string.\n */\ngoog.string.truncate \x3d function(str, chars, opt_protectEscapedCharacters) {\n  if (opt_protectEscapedCharacters) {\n    str \x3d goog.string.unescapeEntities(str);\n  }\n\n  if (str.length \x3e chars) {\n    str \x3d str.substring(0, chars - 3) + \x27...\x27;\n  }\n\n  if (opt_protectEscapedCharacters) {\n    str \x3d goog.string.htmlEscape(str);\n  }\n\n  return str;\n};\n\n\n/**\n * Truncate a string in the middle, adding \x22...\x22 if necessary,\n * and favoring the beginning of the string.\n * @param {string} str The string to truncate the middle of.\n * @param {number} chars Max number of characters.\n * @param {boolean\x3d} opt_protectEscapedCharacters Whether to protect escaped\n *     characters from being cutoff in the middle.\n * @param {number\x3d} opt_trailingChars Optional number of trailing characters to\n *     leave at the end of the string, instead of truncating as close to the\n *     middle as possible.\n * @return {string} A truncated copy of {@code str}.\n */\ngoog.string.truncateMiddle \x3d function(\n    str, chars, opt_protectEscapedCharacters, opt_trailingChars) {\n  if (opt_protectEscapedCharacters) {\n    str \x3d goog.string.unescapeEntities(str);\n  }\n\n  if (opt_trailingChars \x26\x26 str.length \x3e chars) {\n    if (opt_trailingChars \x3e chars) {\n      opt_trailingChars \x3d chars;\n    }\n    var endPoint \x3d str.length - opt_trailingChars;\n    var startPoint \x3d chars - opt_trailingChars;\n    str \x3d str.substring(0, startPoint) + \x27...\x27 + str.substring(endPoint);\n  } else if (str.length \x3e chars) {\n    // Favor the beginning of the string:\n    var half \x3d Math.floor(chars / 2);\n    var endPos \x3d str.length - half;\n    half +\x3d chars % 2;\n    str \x3d str.substring(0, half) + \x27...\x27 + str.substring(endPos);\n  }\n\n  if (opt_protectEscapedCharacters) {\n    str \x3d goog.string.htmlEscape(str);\n  }\n\n  return str;\n};\n\n\n/**\n * Special chars that need to be escaped for goog.string.quote.\n * @private {!Object\x3cstring, string\x3e}\n */\ngoog.string.specialEscapeChars_ \x3d {\n  \x27\\0\x27: \x27\\\\0\x27,\n  \x27\\b\x27: \x27\\\\b\x27,\n  \x27\\f\x27: \x27\\\\f\x27,\n  \x27\\n\x27: \x27\\\\n\x27,\n  \x27\\r\x27: \x27\\\\r\x27,\n  \x27\\t\x27: \x27\\\\t\x27,\n  \x27\\x0B\x27: \x27\\\\x0B\x27,  // \x27\\v\x27 is not supported in JScript\n  \x27\x22\x27: \x27\\\\\x22\x27,\n  \x27\\\\\x27: \x27\\\\\\\\\x27,\n  // To support the use case of embedding quoted strings inside of script\n  // tags, we have to make sure HTML comments and opening/closing script tags do\n  // not appear in the resulting string. The specific strings that must be\n  // escaped are documented at:\n  // http://www.w3.org/TR/html51/semantics.html#restrictions-for-contents-of-script-elements\n  \x27\x3c\x27: \x27\\x3c\x27\n};\n\n\n/**\n * Character mappings used internally for goog.string.escapeChar.\n * @private {!Object\x3cstring, string\x3e}\n */\ngoog.string.jsEscapeCache_ \x3d {\n  \x27\\\x27\x27: \x27\\\\\\\x27\x27\n};\n\n\n/**\n * Encloses a string in double quotes and escapes characters so that the\n * string is a valid JS string. The resulting string is safe to embed in\n * `\x3cscript\x3e` tags as \x22\x3c\x22 is escaped.\n * @param {string} s The string to quote.\n * @return {string} A copy of {@code s} surrounded by double quotes.\n */\ngoog.string.quote \x3d function(s) {\n  s \x3d String(s);\n  var sb \x3d [\x27\x22\x27];\n  for (var i \x3d 0; i \x3c s.length; i++) {\n    var ch \x3d s.charAt(i);\n    var cc \x3d ch.charCodeAt(0);\n    sb[i + 1] \x3d goog.string.specialEscapeChars_[ch] ||\n        ((cc \x3e 31 \x26\x26 cc \x3c 127) ? ch : goog.string.escapeChar(ch));\n  }\n  sb.push(\x27\x22\x27);\n  return sb.join(\x27\x27);\n};\n\n\n/**\n * Takes a string and returns the escaped string for that input string.\n * @param {string} str The string to escape.\n * @return {string} An escaped string representing {@code str}.\n */\ngoog.string.escapeString \x3d function(str) {\n  var sb \x3d [];\n  for (var i \x3d 0; i \x3c str.length; i++) {\n    sb[i] \x3d goog.string.escapeChar(str.charAt(i));\n  }\n  return sb.join(\x27\x27);\n};\n\n\n/**\n * Takes a character and returns the escaped string for that character. For\n * example escapeChar(String.fromCharCode(15)) -\x3e \x22\\\\x0E\x22.\n * @param {string} c The character to escape.\n * @return {string} An escaped string representing {@code c}.\n */\ngoog.string.escapeChar \x3d function(c) {\n  if (c in goog.string.jsEscapeCache_) {\n    return goog.string.jsEscapeCache_[c];\n  }\n\n  if (c in goog.string.specialEscapeChars_) {\n    return goog.string.jsEscapeCache_[c] \x3d goog.string.specialEscapeChars_[c];\n  }\n\n  var rv \x3d c;\n  var cc \x3d c.charCodeAt(0);\n  if (cc \x3e 31 \x26\x26 cc \x3c 127) {\n    rv \x3d c;\n  } else {\n    // tab is 9 but handled above\n    if (cc \x3c 256) {\n      rv \x3d \x27\\\\x\x27;\n      if (cc \x3c 16 || cc \x3e 256) {\n        rv +\x3d \x270\x27;\n      }\n    } else {\n      rv \x3d \x27\\\\u\x27;\n      if (cc \x3c 4096) {  // \\u1000\n        rv +\x3d \x270\x27;\n      }\n    }\n    rv +\x3d cc.toString(16).toUpperCase();\n  }\n\n  return goog.string.jsEscapeCache_[c] \x3d rv;\n};\n\n\n/**\n * Determines whether a string contains a substring.\n * @param {string} str The string to search.\n * @param {string} subString The substring to search for.\n * @return {boolean} Whether {@code str} contains {@code subString}.\n */\ngoog.string.contains \x3d function(str, subString) {\n  return str.indexOf(subString) !\x3d -1;\n};\n\n\n/**\n * Determines whether a string contains a substring, ignoring case.\n * @param {string} str The string to search.\n * @param {string} subString The substring to search for.\n * @return {boolean} Whether {@code str} contains {@code subString}.\n */\ngoog.string.caseInsensitiveContains \x3d function(str, subString) {\n  return goog.string.contains(str.toLowerCase(), subString.toLowerCase());\n};\n\n\n/**\n * Returns the non-overlapping occurrences of ss in s.\n * If either s or ss evalutes to false, then returns zero.\n * @param {string} s The string to look in.\n * @param {string} ss The string to look for.\n * @return {number} Number of occurrences of ss in s.\n */\ngoog.string.countOf \x3d function(s, ss) {\n  return s \x26\x26 ss ? s.split(ss).length - 1 : 0;\n};\n\n\n/**\n * Removes a substring of a specified length at a specific\n * index in a string.\n * @param {string} s The base string from which to remove.\n * @param {number} index The index at which to remove the substring.\n * @param {number} stringLength The length of the substring to remove.\n * @return {string} A copy of {@code s} with the substring removed or the full\n *     string if nothing is removed or the input is invalid.\n */\ngoog.string.removeAt \x3d function(s, index, stringLength) {\n  var resultStr \x3d s;\n  // If the index is greater or equal to 0 then remove substring\n  if (index \x3e\x3d 0 \x26\x26 index \x3c s.length \x26\x26 stringLength \x3e 0) {\n    resultStr \x3d s.substr(0, index) +\n        s.substr(index + stringLength, s.length - index - stringLength);\n  }\n  return resultStr;\n};\n\n\n/**\n * Removes the first occurrence of a substring from a string.\n * @param {string} str The base string from which to remove.\n * @param {string} substr The string to remove.\n * @return {string} A copy of {@code str} with {@code substr} removed or the\n *     full string if nothing is removed.\n */\ngoog.string.remove \x3d function(str, substr) {\n  return str.replace(substr, \x27\x27);\n};\n\n\n/**\n *  Removes all occurrences of a substring from a string.\n *  @param {string} s The base string from which to remove.\n *  @param {string} ss The string to remove.\n *  @return {string} A copy of {@code s} with {@code ss} removed or the full\n *      string if nothing is removed.\n */\ngoog.string.removeAll \x3d function(s, ss) {\n  var re \x3d new RegExp(goog.string.regExpEscape(ss), \x27g\x27);\n  return s.replace(re, \x27\x27);\n};\n\n\n/**\n *  Replaces all occurrences of a substring of a string with a new substring.\n *  @param {string} s The base string from which to remove.\n *  @param {string} ss The string to replace.\n *  @param {string} replacement The replacement string.\n *  @return {string} A copy of {@code s} with {@code ss} replaced by\n *      {@code replacement} or the original string if nothing is replaced.\n */\ngoog.string.replaceAll \x3d function(s, ss, replacement) {\n  var re \x3d new RegExp(goog.string.regExpEscape(ss), \x27g\x27);\n  return s.replace(re, replacement.replace(/\\$/g, \x27$$$$\x27));\n};\n\n\n/**\n * Escapes characters in the string that are not safe to use in a RegExp.\n * @param {*} s The string to escape. If not a string, it will be casted\n *     to one.\n * @return {string} A RegExp safe, escaped copy of {@code s}.\n */\ngoog.string.regExpEscape \x3d function(s) {\n  return String(s)\n      .replace(/([-()\\[\\]{}+?*.$\\^|,:#\x3c!\\\\])/g, \x27\\\\$1\x27)\n      .replace(/\\x08/g, \x27\\\\x08\x27);\n};\n\n\n/**\n * Repeats a string n times.\n * @param {string} string The string to repeat.\n * @param {number} length The number of times to repeat.\n * @return {string} A string containing {@code length} repetitions of\n *     {@code string}.\n */\ngoog.string.repeat \x3d (String.prototype.repeat) ? function(string, length) {\n  // The native method is over 100 times faster than the alternative.\n  return string.repeat(length);\n} : function(string, length) {\n  return new Array(length + 1).join(string);\n};\n\n\n/**\n * Pads number to given length and optionally rounds it to a given precision.\n * For example:\n * \x3cpre\x3epadNumber(1.25, 2, 3) -\x3e \x2701.250\x27\n * padNumber(1.25, 2) -\x3e \x2701.25\x27\n * padNumber(1.25, 2, 1) -\x3e \x2701.3\x27\n * padNumber(1.25, 0) -\x3e \x271.25\x27\x3c/pre\x3e\n *\n * @param {number} num The number to pad.\n * @param {number} length The desired length.\n * @param {number\x3d} opt_precision The desired precision.\n * @return {string} {@code num} as a string with the given options.\n */\ngoog.string.padNumber \x3d function(num, length, opt_precision) {\n  var s \x3d goog.isDef(opt_precision) ? num.toFixed(opt_precision) : String(num);\n  var index \x3d s.indexOf(\x27.\x27);\n  if (index \x3d\x3d -1) {\n    index \x3d s.length;\n  }\n  return goog.string.repeat(\x270\x27, Math.max(0, length - index)) + s;\n};\n\n\n/**\n * Returns a string representation of the given object, with\n * null and undefined being returned as the empty string.\n *\n * @param {*} obj The object to convert.\n * @return {string} A string representation of the {@code obj}.\n */\ngoog.string.makeSafe \x3d function(obj) {\n  return obj \x3d\x3d null ? \x27\x27 : String(obj);\n};\n\n\n/**\n * Concatenates string expressions. This is useful\n * since some browsers are very inefficient when it comes to using plus to\n * concat strings. Be careful when using null and undefined here since\n * these will not be included in the result. If you need to represent these\n * be sure to cast the argument to a String first.\n * For example:\n * \x3cpre\x3ebuildString(\x27a\x27, \x27b\x27, \x27c\x27, \x27d\x27) -\x3e \x27abcd\x27\n * buildString(null, undefined) -\x3e \x27\x27\n * \x3c/pre\x3e\n * @param {...*} var_args A list of strings to concatenate. If not a string,\n *     it will be casted to one.\n * @return {string} The concatenation of {@code var_args}.\n */\ngoog.string.buildString \x3d function(var_args) {\n  return Array.prototype.join.call(arguments, \x27\x27);\n};\n\n\n/**\n * Returns a string with at least 64-bits of randomness.\n *\n * Doesn\x27t trust Javascript\x27s random function entirely. Uses a combination of\n * random and current timestamp, and then encodes the string in base-36 to\n * make it shorter.\n *\n * @return {string} A random string, e.g. sn1s7vb4gcic.\n */\ngoog.string.getRandomString \x3d function() {\n  var x \x3d 2147483648;\n  return Math.floor(Math.random() * x).toString(36) +\n      Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36);\n};\n\n\n/**\n * Compares two version numbers.\n *\n * @param {string|number} version1 Version of first item.\n * @param {string|number} version2 Version of second item.\n *\n * @return {number}  1 if {@code version1} is higher.\n *                   0 if arguments are equal.\n *                  -1 if {@code version2} is higher.\n */\ngoog.string.compareVersions \x3d function(version1, version2) {\n  var order \x3d 0;\n  // Trim leading and trailing whitespace and split the versions into\n  // subversions.\n  var v1Subs \x3d goog.string.trim(String(version1)).split(\x27.\x27);\n  var v2Subs \x3d goog.string.trim(String(version2)).split(\x27.\x27);\n  var subCount \x3d Math.max(v1Subs.length, v2Subs.length);\n\n  // Iterate over the subversions, as long as they appear to be equivalent.\n  for (var subIdx \x3d 0; order \x3d\x3d 0 \x26\x26 subIdx \x3c subCount; subIdx++) {\n    var v1Sub \x3d v1Subs[subIdx] || \x27\x27;\n    var v2Sub \x3d v2Subs[subIdx] || \x27\x27;\n\n    do {\n      // Split the subversions into pairs of numbers and qualifiers (like \x27b\x27).\n      // Two different RegExp objects are use to make it clear the code\n      // is side-effect free\n      var v1Comp \x3d /(\\d*)(\\D*)(.*)/.exec(v1Sub) || [\x27\x27, \x27\x27, \x27\x27, \x27\x27];\n      var v2Comp \x3d /(\\d*)(\\D*)(.*)/.exec(v2Sub) || [\x27\x27, \x27\x27, \x27\x27, \x27\x27];\n      // Break if there are no more matches.\n      if (v1Comp[0].length \x3d\x3d 0 \x26\x26 v2Comp[0].length \x3d\x3d 0) {\n        break;\n      }\n\n      // Parse the numeric part of the subversion. A missing number is\n      // equivalent to 0.\n      var v1CompNum \x3d v1Comp[1].length \x3d\x3d 0 ? 0 : parseInt(v1Comp[1], 10);\n      var v2CompNum \x3d v2Comp[1].length \x3d\x3d 0 ? 0 : parseInt(v2Comp[1], 10);\n\n      // Compare the subversion components. The number has the highest\n      // precedence. Next, if the numbers are equal, a subversion without any\n      // qualifier is always higher than a subversion with any qualifier. Next,\n      // the qualifiers are compared as strings.\n      order \x3d goog.string.compareElements_(v1CompNum, v2CompNum) ||\n          goog.string.compareElements_(\n              v1Comp[2].length \x3d\x3d 0, v2Comp[2].length \x3d\x3d 0) ||\n          goog.string.compareElements_(v1Comp[2], v2Comp[2]);\n      // Stop as soon as an inequality is discovered.\n\n      v1Sub \x3d v1Comp[3];\n      v2Sub \x3d v2Comp[3];\n    } while (order \x3d\x3d 0);\n  }\n\n  return order;\n};\n\n\n/**\n * Compares elements of a version number.\n *\n * @param {string|number|boolean} left An element from a version number.\n * @param {string|number|boolean} right An element from a version number.\n *\n * @return {number}  1 if {@code left} is higher.\n *                   0 if arguments are equal.\n *                  -1 if {@code right} is higher.\n * @private\n */\ngoog.string.compareElements_ \x3d function(left, right) {\n  if (left \x3c right) {\n    return -1;\n  } else if (left \x3e right) {\n    return 1;\n  }\n  return 0;\n};\n\n\n/**\n * String hash function similar to java.lang.String.hashCode().\n * The hash code for a string is computed as\n * s[0] * 31 ^ (n - 1) + s[1] * 31 ^ (n - 2) + ... + s[n - 1],\n * where s[i] is the ith character of the string and n is the length of\n * the string. We mod the result to make it between 0 (inclusive) and 2^32\n * (exclusive).\n * @param {string} str A string.\n * @return {number} Hash value for {@code str}, between 0 (inclusive) and 2^32\n *  (exclusive). The empty string returns 0.\n */\ngoog.string.hashCode \x3d function(str) {\n  var result \x3d 0;\n  for (var i \x3d 0; i \x3c str.length; ++i) {\n    // Normalize to 4 byte range, 0 ... 2^32.\n    result \x3d (31 * result + str.charCodeAt(i)) \x3e\x3e\x3e 0;\n  }\n  return result;\n};\n\n\n/**\n * The most recent unique ID. |0 is equivalent to Math.floor in this case.\n * @type {number}\n * @private\n */\ngoog.string.uniqueStringCounter_ \x3d Math.random() * 0x80000000 | 0;\n\n\n/**\n * Generates and returns a string which is unique in the current document.\n * This is useful, for example, to create unique IDs for DOM elements.\n * @return {string} A unique id.\n */\ngoog.string.createUniqueString \x3d function() {\n  return \x27goog_\x27 + goog.string.uniqueStringCounter_++;\n};\n\n\n/**\n * Converts the supplied string to a number, which may be Infinity or NaN.\n * This function strips whitespace: (toNumber(\x27 123\x27) \x3d\x3d\x3d 123)\n * This function accepts scientific notation: (toNumber(\x271e1\x27) \x3d\x3d\x3d 10)\n *\n * This is better than Javascript\x27s built-in conversions because, sadly:\n *     (Number(\x27 \x27) \x3d\x3d\x3d 0) and (parseFloat(\x27123a\x27) \x3d\x3d\x3d 123)\n *\n * @param {string} str The string to convert.\n * @return {number} The number the supplied string represents, or NaN.\n */\ngoog.string.toNumber \x3d function(str) {\n  var num \x3d Number(str);\n  if (num \x3d\x3d 0 \x26\x26 goog.string.isEmptyOrWhitespace(str)) {\n    return NaN;\n  }\n  return num;\n};\n\n\n/**\n * Returns whether the given string is lower camel case (e.g. \x22isFooBar\x22).\n *\n * Note that this assumes the string is entirely letters.\n * @see http://en.wikipedia.org/wiki/CamelCase#Variations_and_synonyms\n *\n * @param {string} str String to test.\n * @return {boolean} Whether the string is lower camel case.\n */\ngoog.string.isLowerCamelCase \x3d function(str) {\n  return /^[a-z]+([A-Z][a-z]*)*$/.test(str);\n};\n\n\n/**\n * Returns whether the given string is upper camel case (e.g. \x22FooBarBaz\x22).\n *\n * Note that this assumes the string is entirely letters.\n * @see http://en.wikipedia.org/wiki/CamelCase#Variations_and_synonyms\n *\n * @param {string} str String to test.\n * @return {boolean} Whether the string is upper camel case.\n */\ngoog.string.isUpperCamelCase \x3d function(str) {\n  return /^([A-Z][a-z]*)+$/.test(str);\n};\n\n\n/**\n * Converts a string from selector-case to camelCase (e.g. from\n * \x22multi-part-string\x22 to \x22multiPartString\x22), useful for converting\n * CSS selectors and HTML dataset keys to their equivalent JS properties.\n * @param {string} str The string in selector-case form.\n * @return {string} The string in camelCase form.\n */\ngoog.string.toCamelCase \x3d function(str) {\n  return String(str).replace(\n      /\\-([a-z])/g, function(all, match) { return match.toUpperCase(); });\n};\n\n\n/**\n * Converts a string from camelCase to selector-case (e.g. from\n * \x22multiPartString\x22 to \x22multi-part-string\x22), useful for converting JS\n * style and dataset properties to equivalent CSS selectors and HTML keys.\n * @param {string} str The string in camelCase form.\n * @return {string} The string in selector-case form.\n */\ngoog.string.toSelectorCase \x3d function(str) {\n  return String(str).replace(/([A-Z])/g, \x27-$1\x27).toLowerCase();\n};\n\n\n/**\n * Converts a string into TitleCase. First character of the string is always\n * capitalized in addition to the first letter of every subsequent word.\n * Words are delimited by one or more whitespaces by default. Custom delimiters\n * can optionally be specified to replace the default, which doesn\x27t preserve\n * whitespace delimiters and instead must be explicitly included if needed.\n *\n * Default delimiter \x3d\x3e \x22 \x22:\n *    goog.string.toTitleCase(\x27oneTwoThree\x27)    \x3d\x3e \x27OneTwoThree\x27\n *    goog.string.toTitleCase(\x27one two three\x27)  \x3d\x3e \x27One Two Three\x27\n *    goog.string.toTitleCase(\x27  one   two   \x27) \x3d\x3e \x27  One   Two   \x27\n *    goog.string.toTitleCase(\x27one_two_three\x27)  \x3d\x3e \x27One_two_three\x27\n *    goog.string.toTitleCase(\x27one-two-three\x27)  \x3d\x3e \x27One-two-three\x27\n *\n * Custom delimiter \x3d\x3e \x22_-.\x22:\n *    goog.string.toTitleCase(\x27oneTwoThree\x27, \x27_-.\x27)       \x3d\x3e \x27OneTwoThree\x27\n *    goog.string.toTitleCase(\x27one two three\x27, \x27_-.\x27)     \x3d\x3e \x27One two three\x27\n *    goog.string.toTitleCase(\x27  one   two   \x27, \x27_-.\x27)    \x3d\x3e \x27  one   two   \x27\n *    goog.string.toTitleCase(\x27one_two_three\x27, \x27_-.\x27)     \x3d\x3e \x27One_Two_Three\x27\n *    goog.string.toTitleCase(\x27one-two-three\x27, \x27_-.\x27)     \x3d\x3e \x27One-Two-Three\x27\n *    goog.string.toTitleCase(\x27one...two...three\x27, \x27_-.\x27) \x3d\x3e \x27One...Two...Three\x27\n *    goog.string.toTitleCase(\x27one. two. three\x27, \x27_-.\x27)   \x3d\x3e \x27One. two. three\x27\n *    goog.string.toTitleCase(\x27one-two.three\x27, \x27_-.\x27)     \x3d\x3e \x27One-Two.Three\x27\n *\n * @param {string} str String value in camelCase form.\n * @param {string\x3d} opt_delimiters Custom delimiter character set used to\n *      distinguish words in the string value. Each character represents a\n *      single delimiter. When provided, default whitespace delimiter is\n *      overridden and must be explicitly included if needed.\n * @return {string} String value in TitleCase form.\n */\ngoog.string.toTitleCase \x3d function(str, opt_delimiters) {\n  var delimiters \x3d goog.isString(opt_delimiters) ?\n      goog.string.regExpEscape(opt_delimiters) :\n      \x27\\\\s\x27;\n\n  // For IE8, we need to prevent using an empty character set. Otherwise,\n  // incorrect matching will occur.\n  delimiters \x3d delimiters ? \x27|[\x27 + delimiters + \x27]+\x27 : \x27\x27;\n\n  var regexp \x3d new RegExp(\x27(^\x27 + delimiters + \x27)([a-z])\x27, \x27g\x27);\n  return str.replace(\n      regexp, function(all, p1, p2) { return p1 + p2.toUpperCase(); });\n};\n\n\n/**\n * Capitalizes a string, i.e. converts the first letter to uppercase\n * and all other letters to lowercase, e.g.:\n *\n * goog.string.capitalize(\x27one\x27)     \x3d\x3e \x27One\x27\n * goog.string.capitalize(\x27ONE\x27)     \x3d\x3e \x27One\x27\n * goog.string.capitalize(\x27one two\x27) \x3d\x3e \x27One two\x27\n *\n * Note that this function does not trim initial whitespace.\n *\n * @param {string} str String value to capitalize.\n * @return {string} String value with first letter in uppercase.\n */\ngoog.string.capitalize \x3d function(str) {\n  return String(str.charAt(0)).toUpperCase() +\n      String(str.substr(1)).toLowerCase();\n};\n\n\n/**\n * Parse a string in decimal or hexidecimal (\x270xFFFF\x27) form.\n *\n * To parse a particular radix, please use parseInt(string, radix) directly. See\n * https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/parseInt\n *\n * This is a wrapper for the built-in parseInt function that will only parse\n * numbers as base 10 or base 16.  Some JS implementations assume strings\n * starting with \x220\x22 are intended to be octal. ES3 allowed but discouraged\n * this behavior. ES5 forbids it.  This function emulates the ES5 behavior.\n *\n * For more information, see Mozilla JS Reference: http://goo.gl/8RiFj\n *\n * @param {string|number|null|undefined} value The value to be parsed.\n * @return {number} The number, parsed. If the string failed to parse, this\n *     will be NaN.\n */\ngoog.string.parseInt \x3d function(value) {\n  // Force finite numbers to strings.\n  if (isFinite(value)) {\n    value \x3d String(value);\n  }\n\n  if (goog.isString(value)) {\n    // If the string starts with \x270x\x27 or \x27-0x\x27, parse as hex.\n    return /^\\s*-?0x/i.test(value) ? parseInt(value, 16) : parseInt(value, 10);\n  }\n\n  return NaN;\n};\n\n\n/**\n * Splits a string on a separator a limited number of times.\n *\n * This implementation is more similar to Python or Java, where the limit\n * parameter specifies the maximum number of splits rather than truncating\n * the number of results.\n *\n * See http://docs.python.org/2/library/stdtypes.html#str.split\n * See JavaDoc: http://goo.gl/F2AsY\n * See Mozilla reference: http://goo.gl/dZdZs\n *\n * @param {string} str String to split.\n * @param {string} separator The separator.\n * @param {number} limit The limit to the number of splits. The resulting array\n *     will have a maximum length of limit+1.  Negative numbers are the same\n *     as zero.\n * @return {!Array\x3cstring\x3e} The string, split.\n */\ngoog.string.splitLimit \x3d function(str, separator, limit) {\n  var parts \x3d str.split(separator);\n  var returnVal \x3d [];\n\n  // Only continue doing this while we haven\x27t hit the limit and we have\n  // parts left.\n  while (limit \x3e 0 \x26\x26 parts.length) {\n    returnVal.push(parts.shift());\n    limit--;\n  }\n\n  // If there are remaining parts, append them to the end.\n  if (parts.length) {\n    returnVal.push(parts.join(separator));\n  }\n\n  return returnVal;\n};\n\n\n/**\n * Finds the characters to the right of the last instance of any separator\n *\n * This function is similar to goog.string.path.baseName, except it can take a\n * list of characters to split the string on. It will return the rightmost\n * grouping of characters to the right of any separator as a left-to-right\n * oriented string.\n *\n * @see goog.string.path.baseName\n * @param {string} str The string\n * @param {string|!Array\x3cstring\x3e} separators A list of separator characters\n * @return {string} The last part of the string with respect to the separators\n */\ngoog.string.lastComponent \x3d function(str, separators) {\n  if (!separators) {\n    return str;\n  } else if (typeof separators \x3d\x3d \x27string\x27) {\n    separators \x3d [separators];\n  }\n\n  var lastSeparatorIndex \x3d -1;\n  for (var i \x3d 0; i \x3c separators.length; i++) {\n    if (separators[i] \x3d\x3d \x27\x27) {\n      continue;\n    }\n    var currentSeparatorIndex \x3d str.lastIndexOf(separators[i]);\n    if (currentSeparatorIndex \x3e lastSeparatorIndex) {\n      lastSeparatorIndex \x3d currentSeparatorIndex;\n    }\n  }\n  if (lastSeparatorIndex \x3d\x3d -1) {\n    return str;\n  }\n  return str.slice(lastSeparatorIndex + 1);\n};\n\n\n/**\n * Computes the Levenshtein edit distance between two strings.\n * @param {string} a\n * @param {string} b\n * @return {number} The edit distance between the two strings.\n */\ngoog.string.editDistance \x3d function(a, b) {\n  var v0 \x3d [];\n  var v1 \x3d [];\n\n  if (a \x3d\x3d b) {\n    return 0;\n  }\n\n  if (!a.length || !b.length) {\n    return Math.max(a.length, b.length);\n  }\n\n  for (var i \x3d 0; i \x3c b.length + 1; i++) {\n    v0[i] \x3d i;\n  }\n\n  for (var i \x3d 0; i \x3c a.length; i++) {\n    v1[0] \x3d i + 1;\n\n    for (var j \x3d 0; j \x3c b.length; j++) {\n      var cost \x3d Number(a[i] !\x3d b[j]);\n      // Cost for the substring is the minimum of adding one character, removing\n      // one character, or a swap.\n      v1[j + 1] \x3d Math.min(v1[j] + 1, v0[j + 1] + 1, v0[j] + cost);\n    }\n\n    for (var j \x3d 0; j \x3c v0.length; j++) {\n      v0[j] \x3d v1[j];\n    }\n  }\n\n  return v1[b.length];\n};\n");
SHADOW_ENV.evalLoad("goog.asserts.asserts.js", false , "// Copyright 2008 The Closure Library Authors. All Rights Reserved.\n//\n// Licensed under the Apache License, Version 2.0 (the \x22License\x22);\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//      http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an \x22AS-IS\x22 BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\n\n/**\n * @fileoverview Utilities to check the preconditions, postconditions and\n * invariants runtime.\n *\n * Methods in this package should be given special treatment by the compiler\n * for type-inference. For example, \x3ccode\x3egoog.asserts.assert(foo)\x3c/code\x3e\n * will restrict \x3ccode\x3efoo\x3c/code\x3e to a truthy value.\n *\n * The compiler has an option to disable asserts. So code like:\n * \x3ccode\x3e\n * var x \x3d goog.asserts.assert(foo()); goog.asserts.assert(bar());\n * \x3c/code\x3e\n * will be transformed into:\n * \x3ccode\x3e\n * var x \x3d foo();\n * \x3c/code\x3e\n * The compiler will leave in foo() (because its return value is used),\n * but it will remove bar() because it assumes it does not have side-effects.\n *\n * @author agrieve@google.com (Andrew Grieve)\n */\n\ngoog.provide(\x27goog.asserts\x27);\ngoog.provide(\x27goog.asserts.AssertionError\x27);\n\ngoog.require(\x27goog.debug.Error\x27);\ngoog.require(\x27goog.dom.NodeType\x27);\ngoog.require(\x27goog.string\x27);\n\n\n/**\n * @define {boolean} Whether to strip out asserts or to leave them in.\n */\ngoog.define(\x27goog.asserts.ENABLE_ASSERTS\x27, goog.DEBUG);\n\n\n\n/**\n * Error object for failed assertions.\n * @param {string} messagePattern The pattern that was used to form message.\n * @param {!Array\x3c*\x3e} messageArgs The items to substitute into the pattern.\n * @constructor\n * @extends {goog.debug.Error}\n * @final\n */\ngoog.asserts.AssertionError \x3d function(messagePattern, messageArgs) {\n  messageArgs.unshift(messagePattern);\n  goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));\n  // Remove the messagePattern afterwards to avoid permanently modifying the\n  // passed in array.\n  messageArgs.shift();\n\n  /**\n   * The message pattern used to format the error message. Error handlers can\n   * use this to uniquely identify the assertion.\n   * @type {string}\n   */\n  this.messagePattern \x3d messagePattern;\n};\ngoog.inherits(goog.asserts.AssertionError, goog.debug.Error);\n\n\n/** @override */\ngoog.asserts.AssertionError.prototype.name \x3d \x27AssertionError\x27;\n\n\n/**\n * The default error handler.\n * @param {!goog.asserts.AssertionError} e The exception to be handled.\n */\ngoog.asserts.DEFAULT_ERROR_HANDLER \x3d function(e) {\n  throw e;\n};\n\n\n/**\n * The handler responsible for throwing or logging assertion errors.\n * @private {function(!goog.asserts.AssertionError)}\n */\ngoog.asserts.errorHandler_ \x3d goog.asserts.DEFAULT_ERROR_HANDLER;\n\n\n/**\n * Throws an exception with the given message and \x22Assertion failed\x22 prefixed\n * onto it.\n * @param {string} defaultMessage The message to use if givenMessage is empty.\n * @param {Array\x3c*\x3e} defaultArgs The substitution arguments for defaultMessage.\n * @param {string|undefined} givenMessage Message supplied by the caller.\n * @param {Array\x3c*\x3e} givenArgs The substitution arguments for givenMessage.\n * @throws {goog.asserts.AssertionError} When the value is not a number.\n * @private\n */\ngoog.asserts.doAssertFailure_ \x3d function(\n    defaultMessage, defaultArgs, givenMessage, givenArgs) {\n  var message \x3d \x27Assertion failed\x27;\n  if (givenMessage) {\n    message +\x3d \x27: \x27 + givenMessage;\n    var args \x3d givenArgs;\n  } else if (defaultMessage) {\n    message +\x3d \x27: \x27 + defaultMessage;\n    args \x3d defaultArgs;\n  }\n  // The \x27\x27 + works around an Opera 10 bug in the unit tests. Without it,\n  // a stack trace is added to var message above. With this, a stack trace is\n  // not added until this line (it causes the extra garbage to be added after\n  // the assertion message instead of in the middle of it).\n  var e \x3d new goog.asserts.AssertionError(\x27\x27 + message, args || []);\n  goog.asserts.errorHandler_(e);\n};\n\n\n/**\n * Sets a custom error handler that can be used to customize the behavior of\n * assertion failures, for example by turning all assertion failures into log\n * messages.\n * @param {function(!goog.asserts.AssertionError)} errorHandler\n */\ngoog.asserts.setErrorHandler \x3d function(errorHandler) {\n  if (goog.asserts.ENABLE_ASSERTS) {\n    goog.asserts.errorHandler_ \x3d errorHandler;\n  }\n};\n\n\n/**\n * Checks if the condition evaluates to true if goog.asserts.ENABLE_ASSERTS is\n * true.\n * @template T\n * @param {T} condition The condition to check.\n * @param {string\x3d} opt_message Error message in case of failure.\n * @param {...*} var_args The items to substitute into the failure message.\n * @return {T} The value of the condition.\n * @throws {goog.asserts.AssertionError} When the condition evaluates to false.\n */\ngoog.asserts.assert \x3d function(condition, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS \x26\x26 !condition) {\n    goog.asserts.doAssertFailure_(\n        \x27\x27, null, opt_message, Array.prototype.slice.call(arguments, 2));\n  }\n  return condition;\n};\n\n\n/**\n * Fails if goog.asserts.ENABLE_ASSERTS is true. This function is useful in case\n * when we want to add a check in the unreachable area like switch-case\n * statement:\n *\n * \x3cpre\x3e\n *  switch(type) {\n *    case FOO: doSomething(); break;\n *    case BAR: doSomethingElse(); break;\n *    default: goog.asserts.fail(\x27Unrecognized type: \x27 + type);\n *      // We have only 2 types - \x22default:\x22 section is unreachable code.\n *  }\n * \x3c/pre\x3e\n *\n * @param {string\x3d} opt_message Error message in case of failure.\n * @param {...*} var_args The items to substitute into the failure message.\n * @throws {goog.asserts.AssertionError} Failure.\n */\ngoog.asserts.fail \x3d function(opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS) {\n    goog.asserts.errorHandler_(\n        new goog.asserts.AssertionError(\n            \x27Failure\x27 + (opt_message ? \x27: \x27 + opt_message : \x27\x27),\n            Array.prototype.slice.call(arguments, 1)));\n  }\n};\n\n\n/**\n * Checks if the value is a number if goog.asserts.ENABLE_ASSERTS is true.\n * @param {*} value The value to check.\n * @param {string\x3d} opt_message Error message in case of failure.\n * @param {...*} var_args The items to substitute into the failure message.\n * @return {number} The value, guaranteed to be a number when asserts enabled.\n * @throws {goog.asserts.AssertionError} When the value is not a number.\n */\ngoog.asserts.assertNumber \x3d function(value, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS \x26\x26 !goog.isNumber(value)) {\n    goog.asserts.doAssertFailure_(\n        \x27Expected number but got %s: %s.\x27, [goog.typeOf(value), value],\n        opt_message, Array.prototype.slice.call(arguments, 2));\n  }\n  return /** @type {number} */ (value);\n};\n\n\n/**\n * Checks if the value is a string if goog.asserts.ENABLE_ASSERTS is true.\n * @param {*} value The value to check.\n * @param {string\x3d} opt_message Error message in case of failure.\n * @param {...*} var_args The items to substitute into the failure message.\n * @return {string} The value, guaranteed to be a string when asserts enabled.\n * @throws {goog.asserts.AssertionError} When the value is not a string.\n */\ngoog.asserts.assertString \x3d function(value, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS \x26\x26 !goog.isString(value)) {\n    goog.asserts.doAssertFailure_(\n        \x27Expected string but got %s: %s.\x27, [goog.typeOf(value), value],\n        opt_message, Array.prototype.slice.call(arguments, 2));\n  }\n  return /** @type {string} */ (value);\n};\n\n\n/**\n * Checks if the value is a function if goog.asserts.ENABLE_ASSERTS is true.\n * @param {*} value The value to check.\n * @param {string\x3d} opt_message Error message in case of failure.\n * @param {...*} var_args The items to substitute into the failure message.\n * @return {!Function} The value, guaranteed to be a function when asserts\n *     enabled.\n * @throws {goog.asserts.AssertionError} When the value is not a function.\n */\ngoog.asserts.assertFunction \x3d function(value, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS \x26\x26 !goog.isFunction(value)) {\n    goog.asserts.doAssertFailure_(\n        \x27Expected function but got %s: %s.\x27, [goog.typeOf(value), value],\n        opt_message, Array.prototype.slice.call(arguments, 2));\n  }\n  return /** @type {!Function} */ (value);\n};\n\n\n/**\n * Checks if the value is an Object if goog.asserts.ENABLE_ASSERTS is true.\n * @param {*} value The value to check.\n * @param {string\x3d} opt_message Error message in case of failure.\n * @param {...*} var_args The items to substitute into the failure message.\n * @return {!Object} The value, guaranteed to be a non-null object.\n * @throws {goog.asserts.AssertionError} When the value is not an object.\n */\ngoog.asserts.assertObject \x3d function(value, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS \x26\x26 !goog.isObject(value)) {\n    goog.asserts.doAssertFailure_(\n        \x27Expected object but got %s: %s.\x27, [goog.typeOf(value), value],\n        opt_message, Array.prototype.slice.call(arguments, 2));\n  }\n  return /** @type {!Object} */ (value);\n};\n\n\n/**\n * Checks if the value is an Array if goog.asserts.ENABLE_ASSERTS is true.\n * @param {*} value The value to check.\n * @param {string\x3d} opt_message Error message in case of failure.\n * @param {...*} var_args The items to substitute into the failure message.\n * @return {!Array\x3c?\x3e} The value, guaranteed to be a non-null array.\n * @throws {goog.asserts.AssertionError} When the value is not an array.\n */\ngoog.asserts.assertArray \x3d function(value, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS \x26\x26 !goog.isArray(value)) {\n    goog.asserts.doAssertFailure_(\n        \x27Expected array but got %s: %s.\x27, [goog.typeOf(value), value],\n        opt_message, Array.prototype.slice.call(arguments, 2));\n  }\n  return /** @type {!Array\x3c?\x3e} */ (value);\n};\n\n\n/**\n * Checks if the value is a boolean if goog.asserts.ENABLE_ASSERTS is true.\n * @param {*} value The value to check.\n * @param {string\x3d} opt_message Error message in case of failure.\n * @param {...*} var_args The items to substitute into the failure message.\n * @return {boolean} The value, guaranteed to be a boolean when asserts are\n *     enabled.\n * @throws {goog.asserts.AssertionError} When the value is not a boolean.\n */\ngoog.asserts.assertBoolean \x3d function(value, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS \x26\x26 !goog.isBoolean(value)) {\n    goog.asserts.doAssertFailure_(\n        \x27Expected boolean but got %s: %s.\x27, [goog.typeOf(value), value],\n        opt_message, Array.prototype.slice.call(arguments, 2));\n  }\n  return /** @type {boolean} */ (value);\n};\n\n\n/**\n * Checks if the value is a DOM Element if goog.asserts.ENABLE_ASSERTS is true.\n * @param {*} value The value to check.\n * @param {string\x3d} opt_message Error message in case of failure.\n * @param {...*} var_args The items to substitute into the failure message.\n * @return {!Element} The value, likely to be a DOM Element when asserts are\n *     enabled.\n * @throws {goog.asserts.AssertionError} When the value is not an Element.\n */\ngoog.asserts.assertElement \x3d function(value, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS \x26\x26\n      (!goog.isObject(value) || value.nodeType !\x3d goog.dom.NodeType.ELEMENT)) {\n    goog.asserts.doAssertFailure_(\n        \x27Expected Element but got %s: %s.\x27, [goog.typeOf(value), value],\n        opt_message, Array.prototype.slice.call(arguments, 2));\n  }\n  return /** @type {!Element} */ (value);\n};\n\n\n/**\n * Checks if the value is an instance of the user-defined type if\n * goog.asserts.ENABLE_ASSERTS is true.\n *\n * The compiler may tighten the type returned by this function.\n *\n * @param {?} value The value to check.\n * @param {function(new: T, ...)} type A user-defined constructor.\n * @param {string\x3d} opt_message Error message in case of failure.\n * @param {...*} var_args The items to substitute into the failure message.\n * @throws {goog.asserts.AssertionError} When the value is not an instance of\n *     type.\n * @return {T}\n * @template T\n */\ngoog.asserts.assertInstanceof \x3d function(value, type, opt_message, var_args) {\n  if (goog.asserts.ENABLE_ASSERTS \x26\x26 !(value instanceof type)) {\n    goog.asserts.doAssertFailure_(\n        \x27Expected instanceof %s but got %s.\x27,\n        [goog.asserts.getType_(type), goog.asserts.getType_(value)],\n        opt_message, Array.prototype.slice.call(arguments, 3));\n  }\n  return value;\n};\n\n\n/**\n * Checks that no enumerable keys are present in Object.prototype. Such keys\n * would break most code that use {@code for (var ... in ...)} loops.\n */\ngoog.asserts.assertObjectPrototypeIsIntact \x3d function() {\n  for (var key in Object.prototype) {\n    goog.asserts.fail(key + \x27 should not be enumerable in Object.prototype.\x27);\n  }\n};\n\n\n/**\n * Returns the type of a value. If a constructor is passed, and a suitable\n * string cannot be found, \x27unknown type name\x27 will be returned.\n * @param {*} value A constructor, object, or primitive.\n * @return {string} The best display name for the value, or \x27unknown type name\x27.\n * @private\n */\ngoog.asserts.getType_ \x3d function(value) {\n  if (value instanceof Function) {\n    return value.displayName || value.name || \x27unknown type name\x27;\n  } else if (value instanceof Object) {\n    return value.constructor.displayName || value.constructor.name ||\n        Object.prototype.toString.call(value);\n  } else {\n    return value \x3d\x3d\x3d null ? \x27null\x27 : typeof value;\n  }\n};\n");
SHADOW_ENV.evalLoad("goog.reflect.reflect.js", false , "// Copyright 2009 The Closure Library Authors. All Rights Reserved.\n//\n// Licensed under the Apache License, Version 2.0 (the \x22License\x22);\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//      http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an \x22AS-IS\x22 BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\n\n/**\n * @fileoverview Useful compiler idioms.\n *\n * @author johnlenz@google.com (John Lenz)\n */\n\ngoog.provide(\x27goog.reflect\x27);\n\n\n/**\n * Syntax for object literal casts.\n * @see http://go/jscompiler-renaming\n * @see https://goo.gl/CRs09P\n *\n * Use this if you have an object literal whose keys need to have the same names\n * as the properties of some class even after they are renamed by the compiler.\n *\n * @param {!Function} type Type to cast to.\n * @param {Object} object Object literal to cast.\n * @return {Object} The object literal.\n */\ngoog.reflect.object \x3d function(type, object) {\n  return object;\n};\n\n/**\n * Syntax for renaming property strings.\n * @see http://go/jscompiler-renaming\n * @see https://goo.gl/CRs09P\n *\n * Use this if you have an need to access a property as a string, but want\n * to also have the property renamed by the compiler. In contrast to\n * goog.reflect.object, this method takes an instance of an object.\n *\n * Properties must be simple names (not qualified names).\n *\n * @param {string} prop Name of the property\n * @param {!Object} object Instance of the object whose type will be used\n *     for renaming\n * @return {string} The renamed property.\n */\ngoog.reflect.objectProperty \x3d function(prop, object) {\n  return prop;\n};\n\n/**\n * To assert to the compiler that an operation is needed when it would\n * otherwise be stripped. For example:\n * \x3ccode\x3e\n *     // Force a layout\n *     goog.reflect.sinkValue(dialog.offsetHeight);\n * \x3c/code\x3e\n * @param {T} x\n * @return {T}\n * @template T\n */\ngoog.reflect.sinkValue \x3d function(x) {\n  goog.reflect.sinkValue[\x27 \x27](x);\n  return x;\n};\n\n\n/**\n * The compiler should optimize this function away iff no one ever uses\n * goog.reflect.sinkValue.\n */\ngoog.reflect.sinkValue[\x27 \x27] \x3d goog.nullFunction;\n\n\n/**\n * Check if a property can be accessed without throwing an exception.\n * @param {Object} obj The owner of the property.\n * @param {string} prop The property name.\n * @return {boolean} Whether the property is accessible. Will also return true\n *     if obj is null.\n */\ngoog.reflect.canAccessProperty \x3d function(obj, prop) {\n\n  try {\n    goog.reflect.sinkValue(obj[prop]);\n    return true;\n  } catch (e) {\n  }\n  return false;\n};\n\n\n/**\n * Retrieves a value from a cache given a key. The compiler provides special\n * consideration for this call such that it is generally considered side-effect\n * free. However, if the {@code opt_keyFn} or {@code valueFn} have side-effects\n * then the entire call is considered to have side-effects.\n *\n * Conventionally storing the value on the cache would be considered a\n * side-effect and preclude unused calls from being pruned, ie. even if\n * the value was never used, it would still always be stored in the cache.\n *\n * Providing a side-effect free {@code valueFn} and {@code opt_keyFn}\n * allows unused calls to {@code goog.reflect.cache} to be pruned.\n *\n * @param {!Object\x3cK, V\x3e} cacheObj The object that contains the cached values.\n * @param {?} key The key to lookup in the cache. If it is not string or number\n *     then a {@code opt_keyFn} should be provided. The key is also used as the\n *     parameter to the {@code valueFn}.\n * @param {function(?):V} valueFn The value provider to use to calculate the\n *     value to store in the cache. This function should be side-effect free\n *     to take advantage of the optimization.\n * @param {function(?):K\x3d} opt_keyFn The key provider to determine the cache\n *     map key. This should be used if the given key is not a string or number.\n *     If not provided then the given key is used. This function should be\n *     side-effect free to take advantage of the optimization.\n * @return {V} The cached or calculated value.\n * @template K\n * @template V\n */\ngoog.reflect.cache \x3d function(cacheObj, key, valueFn, opt_keyFn) {\n  var storedKey \x3d opt_keyFn ? opt_keyFn(key) : key;\n\n  if (Object.prototype.hasOwnProperty.call(cacheObj, storedKey)) {\n    return cacheObj[storedKey];\n  }\n\n  return (cacheObj[storedKey] \x3d valueFn(key));\n};\n");
SHADOW_ENV.evalLoad("goog.math.long.js", false , "// Copyright 2009 The Closure Library Authors. All Rights Reserved.\n//\n// Licensed under the Apache License, Version 2.0 (the \x22License\x22);\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//      http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an \x22AS-IS\x22 BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\n\n/**\n * @fileoverview Defines a Long class for representing a 64-bit two\x27s-complement\n * integer value, which faithfully simulates the behavior of a Java \x22long\x22. This\n * implementation is derived from LongLib in GWT.\n *\n */\n\ngoog.provide(\x27goog.math.Long\x27);\n\ngoog.require(\x27goog.asserts\x27);\ngoog.require(\x27goog.reflect\x27);\n\n\n\n/**\n * Constructs a 64-bit two\x27s-complement integer, given its low and high 32-bit\n * values as *signed* integers.  See the from* functions below for more\n * convenient ways of constructing Longs.\n *\n * The internal representation of a long is the two given signed, 32-bit values.\n * We use 32-bit pieces because these are the size of integers on which\n * Javascript performs bit-operations.  For operations like addition and\n * multiplication, we split each number into 16-bit pieces, which can easily be\n * multiplied within Javascript\x27s floating-point representation without overflow\n * or change in sign.\n *\n * In the algorithms below, we frequently reduce the negative case to the\n * positive case by negating the input(s) and then post-processing the result.\n * Note that we must ALWAYS check specially whether those values are MIN_VALUE\n * (-2^63) because -MIN_VALUE \x3d\x3d MIN_VALUE (since 2^63 cannot be represented as\n * a positive number, it overflows back into a negative).  Not handling this\n * case would often result in infinite recursion.\n *\n * @param {number} low  The low (signed) 32 bits of the long.\n * @param {number} high  The high (signed) 32 bits of the long.\n * @struct\n * @constructor\n * @final\n */\ngoog.math.Long \x3d function(low, high) {\n  /**\n   * @type {number}\n   * @private\n   */\n  this.low_ \x3d low | 0;  // force into 32 signed bits.\n\n  /**\n   * @type {number}\n   * @private\n   */\n  this.high_ \x3d high | 0;  // force into 32 signed bits.\n};\n\n\n// NOTE: Common constant values ZERO, ONE, NEG_ONE, etc. are defined below the\n// from* methods on which they depend.\n\n\n/**\n * A cache of the Long representations of small integer values.\n * @type {!Object\x3cnumber, !goog.math.Long\x3e}\n * @private\n */\ngoog.math.Long.IntCache_ \x3d {};\n\n\n/**\n * A cache of the Long representations of common values.\n * @type {!Object\x3cgoog.math.Long.ValueCacheId_, !goog.math.Long\x3e}\n * @private\n */\ngoog.math.Long.valueCache_ \x3d {};\n\n/**\n * Returns a cached long number representing the given (32-bit) integer value.\n * @param {number} value The 32-bit integer in question.\n * @return {!goog.math.Long} The corresponding Long value.\n * @private\n */\ngoog.math.Long.getCachedIntValue_ \x3d function(value) {\n  return goog.reflect.cache(goog.math.Long.IntCache_, value, function(val) {\n    return new goog.math.Long(val, val \x3c 0 ? -1 : 0);\n  });\n};\n\n/**\n * The array of maximum values of a Long in string representation for a given\n * radix between 2 and 36, inclusive.\n * @private @const {!Array\x3cstring\x3e}\n */\ngoog.math.Long.MAX_VALUE_FOR_RADIX_ \x3d [\n  \x27\x27, \x27\x27,  // unused\n  \x27111111111111111111111111111111111111111111111111111111111111111\x27,\n  // base 2\n  \x272021110011022210012102010021220101220221\x27,  // base 3\n  \x2713333333333333333333333333333333\x27,          // base 4\n  \x271104332401304422434310311212\x27,              // base 5\n  \x271540241003031030222122211\x27,                 // base 6\n  \x2722341010611245052052300\x27,                   // base 7\n  \x27777777777777777777777\x27,                     // base 8\n  \x2767404283172107811827\x27,                      // base 9\n  \x279223372036854775807\x27,                       // base 10\n  \x271728002635214590697\x27,                       // base 11\n  \x2741a792678515120367\x27,                        // base 12\n  \x2710b269549075433c37\x27,                        // base 13\n  \x274340724c6c71dc7a7\x27,                         // base 14\n  \x27160e2ad3246366807\x27,                         // base 15\n  \x277fffffffffffffff\x27,                          // base 16\n  \x2733d3d8307b214008\x27,                          // base 17\n  \x2716agh595df825fa7\x27,                          // base 18\n  \x27ba643dci0ffeehh\x27,                           // base 19\n  \x275cbfjia3fh26ja7\x27,                           // base 20\n  \x272heiciiie82dh97\x27,                           // base 21\n  \x271adaibb21dckfa7\x27,                           // base 22\n  \x27i6k448cf4192c2\x27,                            // base 23\n  \x27acd772jnc9l0l7\x27,                            // base 24\n  \x2764ie1focnn5g77\x27,                            // base 25\n  \x273igoecjbmca687\x27,                            // base 26\n  \x2727c48l5b37oaop\x27,                            // base 27\n  \x271bk39f3ah3dmq7\x27,                            // base 28\n  \x27q1se8f0m04isb\x27,                             // base 29\n  \x27hajppbc1fc207\x27,                             // base 30\n  \x27bm03i95hia437\x27,                             // base 31\n  \x277vvvvvvvvvvvv\x27,                             // base 32\n  \x275hg4ck9jd4u37\x27,                             // base 33\n  \x273tdtk1v8j6tpp\x27,                             // base 34\n  \x272pijmikexrxp7\x27,                             // base 35\n  \x271y2p0ij32e8e7\x27                              // base 36\n];\n\n\n/**\n * The array of minimum values of a Long in string representation for a given\n * radix between 2 and 36, inclusive.\n * @private @const {!Array\x3cstring\x3e}\n */\ngoog.math.Long.MIN_VALUE_FOR_RADIX_ \x3d [\n  \x27\x27, \x27\x27,  // unused\n  \x27-1000000000000000000000000000000000000000000000000000000000000000\x27,\n  // base 2\n  \x27-2021110011022210012102010021220101220222\x27,  // base 3\n  \x27-20000000000000000000000000000000\x27,          // base 4\n  \x27-1104332401304422434310311213\x27,              // base 5\n  \x27-1540241003031030222122212\x27,                 // base 6\n  \x27-22341010611245052052301\x27,                   // base 7\n  \x27-1000000000000000000000\x27,                    // base 8\n  \x27-67404283172107811828\x27,                      // base 9\n  \x27-9223372036854775808\x27,                       // base 10\n  \x27-1728002635214590698\x27,                       // base 11\n  \x27-41a792678515120368\x27,                        // base 12\n  \x27-10b269549075433c38\x27,                        // base 13\n  \x27-4340724c6c71dc7a8\x27,                         // base 14\n  \x27-160e2ad3246366808\x27,                         // base 15\n  \x27-8000000000000000\x27,                          // base 16\n  \x27-33d3d8307b214009\x27,                          // base 17\n  \x27-16agh595df825fa8\x27,                          // base 18\n  \x27-ba643dci0ffeehi\x27,                           // base 19\n  \x27-5cbfjia3fh26ja8\x27,                           // base 20\n  \x27-2heiciiie82dh98\x27,                           // base 21\n  \x27-1adaibb21dckfa8\x27,                           // base 22\n  \x27-i6k448cf4192c3\x27,                            // base 23\n  \x27-acd772jnc9l0l8\x27,                            // base 24\n  \x27-64ie1focnn5g78\x27,                            // base 25\n  \x27-3igoecjbmca688\x27,                            // base 26\n  \x27-27c48l5b37oaoq\x27,                            // base 27\n  \x27-1bk39f3ah3dmq8\x27,                            // base 28\n  \x27-q1se8f0m04isc\x27,                             // base 29\n  \x27-hajppbc1fc208\x27,                             // base 30\n  \x27-bm03i95hia438\x27,                             // base 31\n  \x27-8000000000000\x27,                             // base 32\n  \x27-5hg4ck9jd4u38\x27,                             // base 33\n  \x27-3tdtk1v8j6tpq\x27,                             // base 34\n  \x27-2pijmikexrxp8\x27,                             // base 35\n  \x27-1y2p0ij32e8e8\x27                              // base 36\n];\n\n\n/**\n * Returns a Long representing the given (32-bit) integer value.\n * @param {number} value The 32-bit integer in question.\n * @return {!goog.math.Long} The corresponding Long value.\n */\ngoog.math.Long.fromInt \x3d function(value) {\n  var intValue \x3d value | 0;\n  goog.asserts.assert(value \x3d\x3d\x3d intValue, \x27value should be a 32-bit integer\x27);\n\n  if (-128 \x3c\x3d intValue \x26\x26 intValue \x3c 128) {\n    return goog.math.Long.getCachedIntValue_(intValue);\n  } else {\n    return new goog.math.Long(intValue, intValue \x3c 0 ? -1 : 0);\n  }\n};\n\n\n/**\n * Returns a Long representing the given value.\n * NaN will be returned as zero. Infinity is converted to max value and\n * -Infinity to min value.\n * @param {number} value The number in question.\n * @return {!goog.math.Long} The corresponding Long value.\n */\ngoog.math.Long.fromNumber \x3d function(value) {\n  if (isNaN(value)) {\n    return goog.math.Long.getZero();\n  } else if (value \x3c\x3d -goog.math.Long.TWO_PWR_63_DBL_) {\n    return goog.math.Long.getMinValue();\n  } else if (value + 1 \x3e\x3d goog.math.Long.TWO_PWR_63_DBL_) {\n    return goog.math.Long.getMaxValue();\n  } else if (value \x3c 0) {\n    return goog.math.Long.fromNumber(-value).negate();\n  } else {\n    return new goog.math.Long(\n        (value % goog.math.Long.TWO_PWR_32_DBL_) | 0,\n        (value / goog.math.Long.TWO_PWR_32_DBL_) | 0);\n  }\n};\n\n\n/**\n * Returns a Long representing the 64-bit integer that comes by concatenating\n * the given high and low bits.  Each is assumed to use 32 bits.\n * @param {number} lowBits The low 32-bits.\n * @param {number} highBits The high 32-bits.\n * @return {!goog.math.Long} The corresponding Long value.\n */\ngoog.math.Long.fromBits \x3d function(lowBits, highBits) {\n  return new goog.math.Long(lowBits, highBits);\n};\n\n\n/**\n * Returns a Long representation of the given string, written using the given\n * radix.\n * @param {string} str The textual representation of the Long.\n * @param {number\x3d} opt_radix The radix in which the text is written.\n * @return {!goog.math.Long} The corresponding Long value.\n */\ngoog.math.Long.fromString \x3d function(str, opt_radix) {\n  if (str.length \x3d\x3d 0) {\n    throw Error(\x27number format error: empty string\x27);\n  }\n\n  var radix \x3d opt_radix || 10;\n  if (radix \x3c 2 || 36 \x3c radix) {\n    throw Error(\x27radix out of range: \x27 + radix);\n  }\n\n  if (str.charAt(0) \x3d\x3d \x27-\x27) {\n    return goog.math.Long.fromString(str.substring(1), radix).negate();\n  } else if (str.indexOf(\x27-\x27) \x3e\x3d 0) {\n    throw Error(\x27number format error: interior \x22-\x22 character: \x27 + str);\n  }\n\n  // Do several (8) digits each time through the loop, so as to\n  // minimize the calls to the very expensive emulated div.\n  var radixToPower \x3d goog.math.Long.fromNumber(Math.pow(radix, 8));\n\n  var result \x3d goog.math.Long.getZero();\n  for (var i \x3d 0; i \x3c str.length; i +\x3d 8) {\n    var size \x3d Math.min(8, str.length - i);\n    var value \x3d parseInt(str.substring(i, i + size), radix);\n    if (size \x3c 8) {\n      var power \x3d goog.math.Long.fromNumber(Math.pow(radix, size));\n      result \x3d result.multiply(power).add(goog.math.Long.fromNumber(value));\n    } else {\n      result \x3d result.multiply(radixToPower);\n      result \x3d result.add(goog.math.Long.fromNumber(value));\n    }\n  }\n  return result;\n};\n\n/**\n * Returns the boolean value of whether the input string is within a Long\x27s\n * range. Assumes an input string containing only numeric characters with an\n * optional preceding \x27-\x27.\n * @param {string} str The textual representation of the Long.\n * @param {number\x3d} opt_radix The radix in which the text is written.\n * @return {boolean} Whether the string is within the range of a Long.\n */\ngoog.math.Long.isStringInRange \x3d function(str, opt_radix) {\n  var radix \x3d opt_radix || 10;\n  if (radix \x3c 2 || 36 \x3c radix) {\n    throw Error(\x27radix out of range: \x27 + radix);\n  }\n\n  var extremeValue \x3d (str.charAt(0) \x3d\x3d \x27-\x27) ?\n      goog.math.Long.MIN_VALUE_FOR_RADIX_[radix] :\n      goog.math.Long.MAX_VALUE_FOR_RADIX_[radix];\n\n  if (str.length \x3c extremeValue.length) {\n    return true;\n  } else if (str.length \x3d\x3d extremeValue.length \x26\x26 str \x3c\x3d extremeValue) {\n    return true;\n  } else {\n    return false;\n  }\n};\n\n// NOTE: the compiler should inline these constant values below and then remove\n// these variables, so there should be no runtime penalty for these.\n\n\n/**\n * Number used repeated below in calculations.  This must appear before the\n * first call to any from* function below.\n * @type {number}\n * @private\n */\ngoog.math.Long.TWO_PWR_16_DBL_ \x3d 1 \x3c\x3c 16;\n\n\n/**\n * @type {number}\n * @private\n */\ngoog.math.Long.TWO_PWR_32_DBL_ \x3d\n    goog.math.Long.TWO_PWR_16_DBL_ * goog.math.Long.TWO_PWR_16_DBL_;\n\n\n/**\n * @type {number}\n * @private\n */\ngoog.math.Long.TWO_PWR_64_DBL_ \x3d\n    goog.math.Long.TWO_PWR_32_DBL_ * goog.math.Long.TWO_PWR_32_DBL_;\n\n\n/**\n * @type {number}\n * @private\n */\ngoog.math.Long.TWO_PWR_63_DBL_ \x3d goog.math.Long.TWO_PWR_64_DBL_ / 2;\n\n\n/**\n * @return {!goog.math.Long}\n * @public\n */\ngoog.math.Long.getZero \x3d function() {\n  return goog.math.Long.getCachedIntValue_(0);\n};\n\n\n/**\n * @return {!goog.math.Long}\n * @public\n */\ngoog.math.Long.getOne \x3d function() {\n  return goog.math.Long.getCachedIntValue_(1);\n};\n\n\n/**\n * @return {!goog.math.Long}\n * @public\n */\ngoog.math.Long.getNegOne \x3d function() {\n  return goog.math.Long.getCachedIntValue_(-1);\n};\n\n\n/**\n * @return {!goog.math.Long}\n * @public\n */\ngoog.math.Long.getMaxValue \x3d function() {\n  return goog.reflect.cache(\n      goog.math.Long.valueCache_, goog.math.Long.ValueCacheId_.MAX_VALUE,\n      function() {\n        return goog.math.Long.fromBits(0xFFFFFFFF | 0, 0x7FFFFFFF | 0);\n      });\n};\n\n\n/**\n * @return {!goog.math.Long}\n * @public\n */\ngoog.math.Long.getMinValue \x3d function() {\n  return goog.reflect.cache(\n      goog.math.Long.valueCache_, goog.math.Long.ValueCacheId_.MIN_VALUE,\n      function() { return goog.math.Long.fromBits(0, 0x80000000 | 0); });\n};\n\n\n/**\n * @return {!goog.math.Long}\n * @public\n */\ngoog.math.Long.getTwoPwr24 \x3d function() {\n  return goog.reflect.cache(\n      goog.math.Long.valueCache_, goog.math.Long.ValueCacheId_.TWO_PWR_24,\n      function() { return goog.math.Long.fromInt(1 \x3c\x3c 24); });\n};\n\n\n/** @return {number} The value, assuming it is a 32-bit integer. */\ngoog.math.Long.prototype.toInt \x3d function() {\n  return this.low_;\n};\n\n\n/** @return {number} The closest floating-point representation to this value. */\ngoog.math.Long.prototype.toNumber \x3d function() {\n  return this.high_ * goog.math.Long.TWO_PWR_32_DBL_ +\n      this.getLowBitsUnsigned();\n};\n\n\n/**\n * @param {number\x3d} opt_radix The radix in which the text should be written.\n * @return {string} The textual representation of this value.\n * @override\n */\ngoog.math.Long.prototype.toString \x3d function(opt_radix) {\n  var radix \x3d opt_radix || 10;\n  if (radix \x3c 2 || 36 \x3c radix) {\n    throw Error(\x27radix out of range: \x27 + radix);\n  }\n\n  if (this.isZero()) {\n    return \x270\x27;\n  }\n\n  if (this.isNegative()) {\n    if (this.equals(goog.math.Long.getMinValue())) {\n      // We need to change the Long value before it can be negated, so we remove\n      // the bottom-most digit in this base and then recurse to do the rest.\n      var radixLong \x3d goog.math.Long.fromNumber(radix);\n      var div \x3d this.div(radixLong);\n      var rem \x3d div.multiply(radixLong).subtract(this);\n      return div.toString(radix) + rem.toInt().toString(radix);\n    } else {\n      return \x27-\x27 + this.negate().toString(radix);\n    }\n  }\n\n  // Do several (6) digits each time through the loop, so as to\n  // minimize the calls to the very expensive emulated div.\n  var radixToPower \x3d goog.math.Long.fromNumber(Math.pow(radix, 6));\n\n  var rem \x3d this;\n  var result \x3d \x27\x27;\n  while (true) {\n    var remDiv \x3d rem.div(radixToPower);\n    // The right shifting fixes negative values in the case when\n    // intval \x3e\x3d 2^31; for more details see\n    // https://github.com/google/closure-library/pull/498\n    var intval \x3d rem.subtract(remDiv.multiply(radixToPower)).toInt() \x3e\x3e\x3e 0;\n    var digits \x3d intval.toString(radix);\n\n    rem \x3d remDiv;\n    if (rem.isZero()) {\n      return digits + result;\n    } else {\n      while (digits.length \x3c 6) {\n        digits \x3d \x270\x27 + digits;\n      }\n      result \x3d \x27\x27 + digits + result;\n    }\n  }\n};\n\n\n/** @return {number} The high 32-bits as a signed value. */\ngoog.math.Long.prototype.getHighBits \x3d function() {\n  return this.high_;\n};\n\n\n/** @return {number} The low 32-bits as a signed value. */\ngoog.math.Long.prototype.getLowBits \x3d function() {\n  return this.low_;\n};\n\n\n/** @return {number} The low 32-bits as an unsigned value. */\ngoog.math.Long.prototype.getLowBitsUnsigned \x3d function() {\n  return (this.low_ \x3e\x3d 0) ? this.low_ :\n                            goog.math.Long.TWO_PWR_32_DBL_ + this.low_;\n};\n\n\n/**\n * @return {number} Returns the number of bits needed to represent the absolute\n *     value of this Long.\n */\ngoog.math.Long.prototype.getNumBitsAbs \x3d function() {\n  if (this.isNegative()) {\n    if (this.equals(goog.math.Long.getMinValue())) {\n      return 64;\n    } else {\n      return this.negate().getNumBitsAbs();\n    }\n  } else {\n    var val \x3d this.high_ !\x3d 0 ? this.high_ : this.low_;\n    for (var bit \x3d 31; bit \x3e 0; bit--) {\n      if ((val \x26 (1 \x3c\x3c bit)) !\x3d 0) {\n        break;\n      }\n    }\n    return this.high_ !\x3d 0 ? bit + 33 : bit + 1;\n  }\n};\n\n\n/** @return {boolean} Whether this value is zero. */\ngoog.math.Long.prototype.isZero \x3d function() {\n  return this.high_ \x3d\x3d 0 \x26\x26 this.low_ \x3d\x3d 0;\n};\n\n\n/** @return {boolean} Whether this value is negative. */\ngoog.math.Long.prototype.isNegative \x3d function() {\n  return this.high_ \x3c 0;\n};\n\n\n/** @return {boolean} Whether this value is odd. */\ngoog.math.Long.prototype.isOdd \x3d function() {\n  return (this.low_ \x26 1) \x3d\x3d 1;\n};\n\n\n/**\n * @param {goog.math.Long} other Long to compare against.\n * @return {boolean} Whether this Long equals the other.\n */\ngoog.math.Long.prototype.equals \x3d function(other) {\n  return (this.high_ \x3d\x3d other.high_) \x26\x26 (this.low_ \x3d\x3d other.low_);\n};\n\n\n/**\n * @param {goog.math.Long} other Long to compare against.\n * @return {boolean} Whether this Long does not equal the other.\n */\ngoog.math.Long.prototype.notEquals \x3d function(other) {\n  return (this.high_ !\x3d other.high_) || (this.low_ !\x3d other.low_);\n};\n\n\n/**\n * @param {goog.math.Long} other Long to compare against.\n * @return {boolean} Whether this Long is less than the other.\n */\ngoog.math.Long.prototype.lessThan \x3d function(other) {\n  return this.compare(other) \x3c 0;\n};\n\n\n/**\n * @param {goog.math.Long} other Long to compare against.\n * @return {boolean} Whether this Long is less than or equal to the other.\n */\ngoog.math.Long.prototype.lessThanOrEqual \x3d function(other) {\n  return this.compare(other) \x3c\x3d 0;\n};\n\n\n/**\n * @param {goog.math.Long} other Long to compare against.\n * @return {boolean} Whether this Long is greater than the other.\n */\ngoog.math.Long.prototype.greaterThan \x3d function(other) {\n  return this.compare(other) \x3e 0;\n};\n\n\n/**\n * @param {goog.math.Long} other Long to compare against.\n * @return {boolean} Whether this Long is greater than or equal to the other.\n */\ngoog.math.Long.prototype.greaterThanOrEqual \x3d function(other) {\n  return this.compare(other) \x3e\x3d 0;\n};\n\n\n/**\n * Compares this Long with the given one.\n * @param {goog.math.Long} other Long to compare against.\n * @return {number} 0 if they are the same, 1 if the this is greater, and -1\n *     if the given one is greater.\n */\ngoog.math.Long.prototype.compare \x3d function(other) {\n  if (this.equals(other)) {\n    return 0;\n  }\n\n  var thisNeg \x3d this.isNegative();\n  var otherNeg \x3d other.isNegative();\n  if (thisNeg \x26\x26 !otherNeg) {\n    return -1;\n  }\n  if (!thisNeg \x26\x26 otherNeg) {\n    return 1;\n  }\n\n  // at this point, the signs are the same, so subtraction will not overflow\n  if (this.subtract(other).isNegative()) {\n    return -1;\n  } else {\n    return 1;\n  }\n};\n\n\n/** @return {!goog.math.Long} The negation of this value. */\ngoog.math.Long.prototype.negate \x3d function() {\n  if (this.equals(goog.math.Long.getMinValue())) {\n    return goog.math.Long.getMinValue();\n  } else {\n    return this.not().add(goog.math.Long.getOne());\n  }\n};\n\n\n/**\n * Returns the sum of this and the given Long.\n * @param {goog.math.Long} other Long to add to this one.\n * @return {!goog.math.Long} The sum of this and the given Long.\n */\ngoog.math.Long.prototype.add \x3d function(other) {\n  // Divide each number into 4 chunks of 16 bits, and then sum the chunks.\n\n  var a48 \x3d this.high_ \x3e\x3e\x3e 16;\n  var a32 \x3d this.high_ \x26 0xFFFF;\n  var a16 \x3d this.low_ \x3e\x3e\x3e 16;\n  var a00 \x3d this.low_ \x26 0xFFFF;\n\n  var b48 \x3d other.high_ \x3e\x3e\x3e 16;\n  var b32 \x3d other.high_ \x26 0xFFFF;\n  var b16 \x3d other.low_ \x3e\x3e\x3e 16;\n  var b00 \x3d other.low_ \x26 0xFFFF;\n\n  var c48 \x3d 0, c32 \x3d 0, c16 \x3d 0, c00 \x3d 0;\n  c00 +\x3d a00 + b00;\n  c16 +\x3d c00 \x3e\x3e\x3e 16;\n  c00 \x26\x3d 0xFFFF;\n  c16 +\x3d a16 + b16;\n  c32 +\x3d c16 \x3e\x3e\x3e 16;\n  c16 \x26\x3d 0xFFFF;\n  c32 +\x3d a32 + b32;\n  c48 +\x3d c32 \x3e\x3e\x3e 16;\n  c32 \x26\x3d 0xFFFF;\n  c48 +\x3d a48 + b48;\n  c48 \x26\x3d 0xFFFF;\n  return goog.math.Long.fromBits((c16 \x3c\x3c 16) | c00, (c48 \x3c\x3c 16) | c32);\n};\n\n\n/**\n * Returns the difference of this and the given Long.\n * @param {goog.math.Long} other Long to subtract from this.\n * @return {!goog.math.Long} The difference of this and the given Long.\n */\ngoog.math.Long.prototype.subtract \x3d function(other) {\n  return this.add(other.negate());\n};\n\n\n/**\n * Returns the product of this and the given long.\n * @param {goog.math.Long} other Long to multiply with this.\n * @return {!goog.math.Long} The product of this and the other.\n */\ngoog.math.Long.prototype.multiply \x3d function(other) {\n  if (this.isZero()) {\n    return goog.math.Long.getZero();\n  } else if (other.isZero()) {\n    return goog.math.Long.getZero();\n  }\n\n  if (this.equals(goog.math.Long.getMinValue())) {\n    return other.isOdd() ? goog.math.Long.getMinValue() :\n                           goog.math.Long.getZero();\n  } else if (other.equals(goog.math.Long.getMinValue())) {\n    return this.isOdd() ? goog.math.Long.getMinValue() :\n                          goog.math.Long.getZero();\n  }\n\n  if (this.isNegative()) {\n    if (other.isNegative()) {\n      return this.negate().multiply(other.negate());\n    } else {\n      return this.negate().multiply(other).negate();\n    }\n  } else if (other.isNegative()) {\n    return this.multiply(other.negate()).negate();\n  }\n\n  // If both longs are small, use float multiplication\n  if (this.lessThan(goog.math.Long.getTwoPwr24()) \x26\x26\n      other.lessThan(goog.math.Long.getTwoPwr24())) {\n    return goog.math.Long.fromNumber(this.toNumber() * other.toNumber());\n  }\n\n  // Divide each long into 4 chunks of 16 bits, and then add up 4x4 products.\n  // We can skip products that would overflow.\n\n  var a48 \x3d this.high_ \x3e\x3e\x3e 16;\n  var a32 \x3d this.high_ \x26 0xFFFF;\n  var a16 \x3d this.low_ \x3e\x3e\x3e 16;\n  var a00 \x3d this.low_ \x26 0xFFFF;\n\n  var b48 \x3d other.high_ \x3e\x3e\x3e 16;\n  var b32 \x3d other.high_ \x26 0xFFFF;\n  var b16 \x3d other.low_ \x3e\x3e\x3e 16;\n  var b00 \x3d other.low_ \x26 0xFFFF;\n\n  var c48 \x3d 0, c32 \x3d 0, c16 \x3d 0, c00 \x3d 0;\n  c00 +\x3d a00 * b00;\n  c16 +\x3d c00 \x3e\x3e\x3e 16;\n  c00 \x26\x3d 0xFFFF;\n  c16 +\x3d a16 * b00;\n  c32 +\x3d c16 \x3e\x3e\x3e 16;\n  c16 \x26\x3d 0xFFFF;\n  c16 +\x3d a00 * b16;\n  c32 +\x3d c16 \x3e\x3e\x3e 16;\n  c16 \x26\x3d 0xFFFF;\n  c32 +\x3d a32 * b00;\n  c48 +\x3d c32 \x3e\x3e\x3e 16;\n  c32 \x26\x3d 0xFFFF;\n  c32 +\x3d a16 * b16;\n  c48 +\x3d c32 \x3e\x3e\x3e 16;\n  c32 \x26\x3d 0xFFFF;\n  c32 +\x3d a00 * b32;\n  c48 +\x3d c32 \x3e\x3e\x3e 16;\n  c32 \x26\x3d 0xFFFF;\n  c48 +\x3d a48 * b00 + a32 * b16 + a16 * b32 + a00 * b48;\n  c48 \x26\x3d 0xFFFF;\n  return goog.math.Long.fromBits((c16 \x3c\x3c 16) | c00, (c48 \x3c\x3c 16) | c32);\n};\n\n\n/**\n * Returns this Long divided by the given one.\n * @param {goog.math.Long} other Long by which to divide.\n * @return {!goog.math.Long} This Long divided by the given one.\n */\ngoog.math.Long.prototype.div \x3d function(other) {\n  if (other.isZero()) {\n    throw Error(\x27division by zero\x27);\n  } else if (this.isZero()) {\n    return goog.math.Long.getZero();\n  }\n\n  if (this.equals(goog.math.Long.getMinValue())) {\n    if (other.equals(goog.math.Long.getOne()) ||\n        other.equals(goog.math.Long.getNegOne())) {\n      return goog.math.Long.getMinValue();  // recall -MIN_VALUE \x3d\x3d MIN_VALUE\n    } else if (other.equals(goog.math.Long.getMinValue())) {\n      return goog.math.Long.getOne();\n    } else {\n      // At this point, we have |other| \x3e\x3d 2, so |this/other| \x3c |MIN_VALUE|.\n      var halfThis \x3d this.shiftRight(1);\n      var approx \x3d halfThis.div(other).shiftLeft(1);\n      if (approx.equals(goog.math.Long.getZero())) {\n        return other.isNegative() ? goog.math.Long.getOne() :\n                                    goog.math.Long.getNegOne();\n      } else {\n        var rem \x3d this.subtract(other.multiply(approx));\n        var result \x3d approx.add(rem.div(other));\n        return result;\n      }\n    }\n  } else if (other.equals(goog.math.Long.getMinValue())) {\n    return goog.math.Long.getZero();\n  }\n\n  if (this.isNegative()) {\n    if (other.isNegative()) {\n      return this.negate().div(other.negate());\n    } else {\n      return this.negate().div(other).negate();\n    }\n  } else if (other.isNegative()) {\n    return this.div(other.negate()).negate();\n  }\n\n  // Repeat the following until the remainder is less than other:  find a\n  // floating-point that approximates remainder / other *from below*, add this\n  // into the result, and subtract it from the remainder.  It is critical that\n  // the approximate value is less than or equal to the real value so that the\n  // remainder never becomes negative.\n  var res \x3d goog.math.Long.getZero();\n  var rem \x3d this;\n  while (rem.greaterThanOrEqual(other)) {\n    // Approximate the result of division. This may be a little greater or\n    // smaller than the actual value.\n    var approx \x3d Math.max(1, Math.floor(rem.toNumber() / other.toNumber()));\n\n    // We will tweak the approximate result by changing it in the 48-th digit or\n    // the smallest non-fractional digit, whichever is larger.\n    var log2 \x3d Math.ceil(Math.log(approx) / Math.LN2);\n    var delta \x3d (log2 \x3c\x3d 48) ? 1 : Math.pow(2, log2 - 48);\n\n    // Decrease the approximation until it is smaller than the remainder.  Note\n    // that if it is too large, the product overflows and is negative.\n    var approxRes \x3d goog.math.Long.fromNumber(approx);\n    var approxRem \x3d approxRes.multiply(other);\n    while (approxRem.isNegative() || approxRem.greaterThan(rem)) {\n      approx -\x3d delta;\n      approxRes \x3d goog.math.Long.fromNumber(approx);\n      approxRem \x3d approxRes.multiply(other);\n    }\n\n    // We know the answer can\x27t be zero... and actually, zero would cause\n    // infinite recursion since we would make no progress.\n    if (approxRes.isZero()) {\n      approxRes \x3d goog.math.Long.getOne();\n    }\n\n    res \x3d res.add(approxRes);\n    rem \x3d rem.subtract(approxRem);\n  }\n  return res;\n};\n\n\n/**\n * Returns this Long modulo the given one.\n * @param {goog.math.Long} other Long by which to mod.\n * @return {!goog.math.Long} This Long modulo the given one.\n */\ngoog.math.Long.prototype.modulo \x3d function(other) {\n  return this.subtract(this.div(other).multiply(other));\n};\n\n\n/** @return {!goog.math.Long} The bitwise-NOT of this value. */\ngoog.math.Long.prototype.not \x3d function() {\n  return goog.math.Long.fromBits(~this.low_, ~this.high_);\n};\n\n\n/**\n * Returns the bitwise-AND of this Long and the given one.\n * @param {goog.math.Long} other The Long with which to AND.\n * @return {!goog.math.Long} The bitwise-AND of this and the other.\n */\ngoog.math.Long.prototype.and \x3d function(other) {\n  return goog.math.Long.fromBits(\n      this.low_ \x26 other.low_, this.high_ \x26 other.high_);\n};\n\n\n/**\n * Returns the bitwise-OR of this Long and the given one.\n * @param {goog.math.Long} other The Long with which to OR.\n * @return {!goog.math.Long} The bitwise-OR of this and the other.\n */\ngoog.math.Long.prototype.or \x3d function(other) {\n  return goog.math.Long.fromBits(\n      this.low_ | other.low_, this.high_ | other.high_);\n};\n\n\n/**\n * Returns the bitwise-XOR of this Long and the given one.\n * @param {goog.math.Long} other The Long with which to XOR.\n * @return {!goog.math.Long} The bitwise-XOR of this and the other.\n */\ngoog.math.Long.prototype.xor \x3d function(other) {\n  return goog.math.Long.fromBits(\n      this.low_ ^ other.low_, this.high_ ^ other.high_);\n};\n\n\n/**\n * Returns this Long with bits shifted to the left by the given amount.\n * @param {number} numBits The number of bits by which to shift.\n * @return {!goog.math.Long} This shifted to the left by the given amount.\n */\ngoog.math.Long.prototype.shiftLeft \x3d function(numBits) {\n  numBits \x26\x3d 63;\n  if (numBits \x3d\x3d 0) {\n    return this;\n  } else {\n    var low \x3d this.low_;\n    if (numBits \x3c 32) {\n      var high \x3d this.high_;\n      return goog.math.Long.fromBits(\n          low \x3c\x3c numBits, (high \x3c\x3c numBits) | (low \x3e\x3e\x3e (32 - numBits)));\n    } else {\n      return goog.math.Long.fromBits(0, low \x3c\x3c (numBits - 32));\n    }\n  }\n};\n\n\n/**\n * Returns this Long with bits shifted to the right by the given amount.\n * The new leading bits match the current sign bit.\n * @param {number} numBits The number of bits by which to shift.\n * @return {!goog.math.Long} This shifted to the right by the given amount.\n */\ngoog.math.Long.prototype.shiftRight \x3d function(numBits) {\n  numBits \x26\x3d 63;\n  if (numBits \x3d\x3d 0) {\n    return this;\n  } else {\n    var high \x3d this.high_;\n    if (numBits \x3c 32) {\n      var low \x3d this.low_;\n      return goog.math.Long.fromBits(\n          (low \x3e\x3e\x3e numBits) | (high \x3c\x3c (32 - numBits)), high \x3e\x3e numBits);\n    } else {\n      return goog.math.Long.fromBits(\n          high \x3e\x3e (numBits - 32), high \x3e\x3d 0 ? 0 : -1);\n    }\n  }\n};\n\n\n/**\n * Returns this Long with bits shifted to the right by the given amount, with\n * zeros placed into the new leading bits.\n * @param {number} numBits The number of bits by which to shift.\n * @return {!goog.math.Long} This shifted to the right by the given amount, with\n *     zeros placed into the new leading bits.\n */\ngoog.math.Long.prototype.shiftRightUnsigned \x3d function(numBits) {\n  numBits \x26\x3d 63;\n  if (numBits \x3d\x3d 0) {\n    return this;\n  } else {\n    var high \x3d this.high_;\n    if (numBits \x3c 32) {\n      var low \x3d this.low_;\n      return goog.math.Long.fromBits(\n          (low \x3e\x3e\x3e numBits) | (high \x3c\x3c (32 - numBits)), high \x3e\x3e\x3e numBits);\n    } else if (numBits \x3d\x3d 32) {\n      return goog.math.Long.fromBits(high, 0);\n    } else {\n      return goog.math.Long.fromBits(high \x3e\x3e\x3e (numBits - 32), 0);\n    }\n  }\n};\n\n\n/**\n * @enum {number} Ids of commonly requested Long instances.\n * @private\n */\ngoog.math.Long.ValueCacheId_ \x3d {\n  MAX_VALUE: 1,\n  MIN_VALUE: 2,\n  TWO_PWR_24: 6\n};\n");
SHADOW_ENV.evalLoad("goog.math.integer.js", false , "// Copyright 2009 The Closure Library Authors. All Rights Reserved.\n//\n// Licensed under the Apache License, Version 2.0 (the \x22License\x22);\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//      http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an \x22AS-IS\x22 BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\n\n/**\n * @fileoverview Defines an Integer class for representing (potentially)\n * infinite length two\x27s-complement integer values.\n *\n * For the specific case of 64-bit integers, use goog.math.Long, which is more\n * efficient.\n *\n */\n\ngoog.provide(\x27goog.math.Integer\x27);\n\n\n\n/**\n * Constructs a two\x27s-complement integer an array containing bits of the\n * integer in 32-bit (signed) pieces, given in little-endian order (i.e.,\n * lowest-order bits in the first piece), and the sign of -1 or 0.\n *\n * See the from* functions below for other convenient ways of constructing\n * Integers.\n *\n * The internal representation of an integer is an array of 32-bit signed\n * pieces, along with a sign (0 or -1) that indicates the contents of all the\n * other 32-bit pieces out to infinity.  We use 32-bit pieces because these are\n * the size of integers on which Javascript performs bit-operations.  For\n * operations like addition and multiplication, we split each number into 16-bit\n * pieces, which can easily be multiplied within Javascript\x27s floating-point\n * representation without overflow or change in sign.\n *\n * @struct\n * @constructor\n * @param {Array\x3cnumber\x3e} bits Array containing the bits of the number.\n * @param {number} sign The sign of the number: -1 for negative and 0 positive.\n * @final\n */\ngoog.math.Integer \x3d function(bits, sign) {\n  /**\n   * @type {!Array\x3cnumber\x3e}\n   * @private\n   */\n  this.bits_ \x3d [];\n\n  /**\n   * @type {number}\n   * @private\n   */\n  this.sign_ \x3d sign;\n\n  // Copy the 32-bit signed integer values passed in.  We prune out those at the\n  // top that equal the sign since they are redundant.\n  var top \x3d true;\n  for (var i \x3d bits.length - 1; i \x3e\x3d 0; i--) {\n    var val \x3d bits[i] | 0;\n    if (!top || val !\x3d sign) {\n      this.bits_[i] \x3d val;\n      top \x3d false;\n    }\n  }\n};\n\n\n// NOTE: Common constant values ZERO, ONE, NEG_ONE, etc. are defined below the\n// from* methods on which they depend.\n\n\n/**\n * A cache of the Integer representations of small integer values.\n * @type {!Object}\n * @private\n */\ngoog.math.Integer.IntCache_ \x3d {};\n\n\n/**\n * Returns an Integer representing the given (32-bit) integer value.\n * @param {number} value A 32-bit integer value.\n * @return {!goog.math.Integer} The corresponding Integer value.\n */\ngoog.math.Integer.fromInt \x3d function(value) {\n  if (-128 \x3c\x3d value \x26\x26 value \x3c 128) {\n    var cachedObj \x3d goog.math.Integer.IntCache_[value];\n    if (cachedObj) {\n      return cachedObj;\n    }\n  }\n\n  var obj \x3d new goog.math.Integer([value | 0], value \x3c 0 ? -1 : 0);\n  if (-128 \x3c\x3d value \x26\x26 value \x3c 128) {\n    goog.math.Integer.IntCache_[value] \x3d obj;\n  }\n  return obj;\n};\n\n\n/**\n * Returns an Integer representing the given value, provided that it is a finite\n * number.  Otherwise, zero is returned.\n * @param {number} value The value in question.\n * @return {!goog.math.Integer} The corresponding Integer value.\n */\ngoog.math.Integer.fromNumber \x3d function(value) {\n  if (isNaN(value) || !isFinite(value)) {\n    return goog.math.Integer.ZERO;\n  } else if (value \x3c 0) {\n    return goog.math.Integer.fromNumber(-value).negate();\n  } else {\n    var bits \x3d [];\n    var pow \x3d 1;\n    for (var i \x3d 0; value \x3e\x3d pow; i++) {\n      bits[i] \x3d (value / pow) | 0;\n      pow *\x3d goog.math.Integer.TWO_PWR_32_DBL_;\n    }\n    return new goog.math.Integer(bits, 0);\n  }\n};\n\n\n/**\n * Returns a Integer representing the value that comes by concatenating the\n * given entries, each is assumed to be 32 signed bits, given in little-endian\n * order (lowest order bits in the lowest index), and sign-extending the highest\n * order 32-bit value.\n * @param {Array\x3cnumber\x3e} bits The bits of the number, in 32-bit signed pieces,\n *     in little-endian order.\n * @return {!goog.math.Integer} The corresponding Integer value.\n */\ngoog.math.Integer.fromBits \x3d function(bits) {\n  var high \x3d bits[bits.length - 1];\n  return new goog.math.Integer(bits, high \x26 (1 \x3c\x3c 31) ? -1 : 0);\n};\n\n\n/**\n * Returns an Integer representation of the given string, written using the\n * given radix.\n * @param {string} str The textual representation of the Integer.\n * @param {number\x3d} opt_radix The radix in which the text is written.\n * @return {!goog.math.Integer} The corresponding Integer value.\n */\ngoog.math.Integer.fromString \x3d function(str, opt_radix) {\n  if (str.length \x3d\x3d 0) {\n    throw Error(\x27number format error: empty string\x27);\n  }\n\n  var radix \x3d opt_radix || 10;\n  if (radix \x3c 2 || 36 \x3c radix) {\n    throw Error(\x27radix out of range: \x27 + radix);\n  }\n\n  if (str.charAt(0) \x3d\x3d \x27-\x27) {\n    return goog.math.Integer.fromString(str.substring(1), radix).negate();\n  } else if (str.indexOf(\x27-\x27) \x3e\x3d 0) {\n    throw Error(\x27number format error: interior \x22-\x22 character\x27);\n  }\n\n  // Do several (8) digits each time through the loop, so as to\n  // minimize the calls to the very expensive emulated div.\n  var radixToPower \x3d goog.math.Integer.fromNumber(Math.pow(radix, 8));\n\n  var result \x3d goog.math.Integer.ZERO;\n  for (var i \x3d 0; i \x3c str.length; i +\x3d 8) {\n    var size \x3d Math.min(8, str.length - i);\n    var value \x3d parseInt(str.substring(i, i + size), radix);\n    if (size \x3c 8) {\n      var power \x3d goog.math.Integer.fromNumber(Math.pow(radix, size));\n      result \x3d result.multiply(power).add(goog.math.Integer.fromNumber(value));\n    } else {\n      result \x3d result.multiply(radixToPower);\n      result \x3d result.add(goog.math.Integer.fromNumber(value));\n    }\n  }\n  return result;\n};\n\n\n/**\n * A number used repeatedly in calculations.  This must appear before the first\n * call to the from* functions below.\n * @type {number}\n * @private\n */\ngoog.math.Integer.TWO_PWR_32_DBL_ \x3d (1 \x3c\x3c 16) * (1 \x3c\x3c 16);\n\n\n/** @type {!goog.math.Integer} */\ngoog.math.Integer.ZERO \x3d goog.math.Integer.fromInt(0);\n\n\n/** @type {!goog.math.Integer} */\ngoog.math.Integer.ONE \x3d goog.math.Integer.fromInt(1);\n\n\n/**\n * @type {!goog.math.Integer}\n * @private\n */\ngoog.math.Integer.TWO_PWR_24_ \x3d goog.math.Integer.fromInt(1 \x3c\x3c 24);\n\n\n/**\n * Returns the value, assuming it is a 32-bit integer.\n * @return {number} The corresponding int value.\n */\ngoog.math.Integer.prototype.toInt \x3d function() {\n  return this.bits_.length \x3e 0 ? this.bits_[0] : this.sign_;\n};\n\n\n/** @return {number} The closest floating-point representation to this value. */\ngoog.math.Integer.prototype.toNumber \x3d function() {\n  if (this.isNegative()) {\n    return -this.negate().toNumber();\n  } else {\n    var val \x3d 0;\n    var pow \x3d 1;\n    for (var i \x3d 0; i \x3c this.bits_.length; i++) {\n      val +\x3d this.getBitsUnsigned(i) * pow;\n      pow *\x3d goog.math.Integer.TWO_PWR_32_DBL_;\n    }\n    return val;\n  }\n};\n\n\n/**\n * @param {number\x3d} opt_radix The radix in which the text should be written.\n * @return {string} The textual representation of this value.\n * @override\n */\ngoog.math.Integer.prototype.toString \x3d function(opt_radix) {\n  var radix \x3d opt_radix || 10;\n  if (radix \x3c 2 || 36 \x3c radix) {\n    throw Error(\x27radix out of range: \x27 + radix);\n  }\n\n  if (this.isZero()) {\n    return \x270\x27;\n  } else if (this.isNegative()) {\n    return \x27-\x27 + this.negate().toString(radix);\n  }\n\n  // Do several (6) digits each time through the loop, so as to\n  // minimize the calls to the very expensive emulated div.\n  var radixToPower \x3d goog.math.Integer.fromNumber(Math.pow(radix, 6));\n\n  var rem \x3d this;\n  var result \x3d \x27\x27;\n  while (true) {\n    var remDiv \x3d rem.divide(radixToPower);\n    // The right shifting fixes negative values in the case when\n    // intval \x3e\x3d 2^31; for more details see\n    // https://github.com/google/closure-library/pull/498\n    var intval \x3d rem.subtract(remDiv.multiply(radixToPower)).toInt() \x3e\x3e\x3e 0;\n    var digits \x3d intval.toString(radix);\n\n    rem \x3d remDiv;\n    if (rem.isZero()) {\n      return digits + result;\n    } else {\n      while (digits.length \x3c 6) {\n        digits \x3d \x270\x27 + digits;\n      }\n      result \x3d \x27\x27 + digits + result;\n    }\n  }\n};\n\n\n/**\n * Returns the index-th 32-bit (signed) piece of the Integer according to\n * little-endian order (i.e., index 0 contains the smallest bits).\n * @param {number} index The index in question.\n * @return {number} The requested 32-bits as a signed number.\n */\ngoog.math.Integer.prototype.getBits \x3d function(index) {\n  if (index \x3c 0) {\n    return 0;  // Allowing this simplifies bit shifting operations below...\n  } else if (index \x3c this.bits_.length) {\n    return this.bits_[index];\n  } else {\n    return this.sign_;\n  }\n};\n\n\n/**\n * Returns the index-th 32-bit piece as an unsigned number.\n * @param {number} index The index in question.\n * @return {number} The requested 32-bits as an unsigned number.\n */\ngoog.math.Integer.prototype.getBitsUnsigned \x3d function(index) {\n  var val \x3d this.getBits(index);\n  return val \x3e\x3d 0 ? val : goog.math.Integer.TWO_PWR_32_DBL_ + val;\n};\n\n\n/** @return {number} The sign bit of this number, -1 or 0. */\ngoog.math.Integer.prototype.getSign \x3d function() {\n  return this.sign_;\n};\n\n\n/** @return {boolean} Whether this value is zero. */\ngoog.math.Integer.prototype.isZero \x3d function() {\n  if (this.sign_ !\x3d 0) {\n    return false;\n  }\n  for (var i \x3d 0; i \x3c this.bits_.length; i++) {\n    if (this.bits_[i] !\x3d 0) {\n      return false;\n    }\n  }\n  return true;\n};\n\n\n/** @return {boolean} Whether this value is negative. */\ngoog.math.Integer.prototype.isNegative \x3d function() {\n  return this.sign_ \x3d\x3d -1;\n};\n\n\n/** @return {boolean} Whether this value is odd. */\ngoog.math.Integer.prototype.isOdd \x3d function() {\n  return (this.bits_.length \x3d\x3d 0) \x26\x26 (this.sign_ \x3d\x3d -1) ||\n      (this.bits_.length \x3e 0) \x26\x26 ((this.bits_[0] \x26 1) !\x3d 0);\n};\n\n\n/**\n * @param {goog.math.Integer} other Integer to compare against.\n * @return {boolean} Whether this Integer equals the other.\n */\ngoog.math.Integer.prototype.equals \x3d function(other) {\n  if (this.sign_ !\x3d other.sign_) {\n    return false;\n  }\n  var len \x3d Math.max(this.bits_.length, other.bits_.length);\n  for (var i \x3d 0; i \x3c len; i++) {\n    if (this.getBits(i) !\x3d other.getBits(i)) {\n      return false;\n    }\n  }\n  return true;\n};\n\n\n/**\n * @param {goog.math.Integer} other Integer to compare against.\n * @return {boolean} Whether this Integer does not equal the other.\n */\ngoog.math.Integer.prototype.notEquals \x3d function(other) {\n  return !this.equals(other);\n};\n\n\n/**\n * @param {goog.math.Integer} other Integer to compare against.\n * @return {boolean} Whether this Integer is greater than the other.\n */\ngoog.math.Integer.prototype.greaterThan \x3d function(other) {\n  return this.compare(other) \x3e 0;\n};\n\n\n/**\n * @param {goog.math.Integer} other Integer to compare against.\n * @return {boolean} Whether this Integer is greater than or equal to the other.\n */\ngoog.math.Integer.prototype.greaterThanOrEqual \x3d function(other) {\n  return this.compare(other) \x3e\x3d 0;\n};\n\n\n/**\n * @param {goog.math.Integer} other Integer to compare against.\n * @return {boolean} Whether this Integer is less than the other.\n */\ngoog.math.Integer.prototype.lessThan \x3d function(other) {\n  return this.compare(other) \x3c 0;\n};\n\n\n/**\n * @param {goog.math.Integer} other Integer to compare against.\n * @return {boolean} Whether this Integer is less than or equal to the other.\n */\ngoog.math.Integer.prototype.lessThanOrEqual \x3d function(other) {\n  return this.compare(other) \x3c\x3d 0;\n};\n\n\n/**\n * Compares this Integer with the given one.\n * @param {goog.math.Integer} other Integer to compare against.\n * @return {number} 0 if they are the same, 1 if the this is greater, and -1\n *     if the given one is greater.\n */\ngoog.math.Integer.prototype.compare \x3d function(other) {\n  var diff \x3d this.subtract(other);\n  if (diff.isNegative()) {\n    return -1;\n  } else if (diff.isZero()) {\n    return 0;\n  } else {\n    return +1;\n  }\n};\n\n\n/**\n * Returns an integer with only the first numBits bits of this value, sign\n * extended from the final bit.\n * @param {number} numBits The number of bits by which to shift.\n * @return {!goog.math.Integer} The shorted integer value.\n */\ngoog.math.Integer.prototype.shorten \x3d function(numBits) {\n  var arr_index \x3d (numBits - 1) \x3e\x3e 5;\n  var bit_index \x3d (numBits - 1) % 32;\n  var bits \x3d [];\n  for (var i \x3d 0; i \x3c arr_index; i++) {\n    bits[i] \x3d this.getBits(i);\n  }\n  var sigBits \x3d bit_index \x3d\x3d 31 ? 0xFFFFFFFF : (1 \x3c\x3c (bit_index + 1)) - 1;\n  var val \x3d this.getBits(arr_index) \x26 sigBits;\n  if (val \x26 (1 \x3c\x3c bit_index)) {\n    val |\x3d 0xFFFFFFFF - sigBits;\n    bits[arr_index] \x3d val;\n    return new goog.math.Integer(bits, -1);\n  } else {\n    bits[arr_index] \x3d val;\n    return new goog.math.Integer(bits, 0);\n  }\n};\n\n\n/** @return {!goog.math.Integer} The negation of this value. */\ngoog.math.Integer.prototype.negate \x3d function() {\n  return this.not().add(goog.math.Integer.ONE);\n};\n\n\n/**\n * Returns the sum of this and the given Integer.\n * @param {goog.math.Integer} other The Integer to add to this.\n * @return {!goog.math.Integer} The Integer result.\n */\ngoog.math.Integer.prototype.add \x3d function(other) {\n  var len \x3d Math.max(this.bits_.length, other.bits_.length);\n  var arr \x3d [];\n  var carry \x3d 0;\n\n  for (var i \x3d 0; i \x3c\x3d len; i++) {\n    var a1 \x3d this.getBits(i) \x3e\x3e\x3e 16;\n    var a0 \x3d this.getBits(i) \x26 0xFFFF;\n\n    var b1 \x3d other.getBits(i) \x3e\x3e\x3e 16;\n    var b0 \x3d other.getBits(i) \x26 0xFFFF;\n\n    var c0 \x3d carry + a0 + b0;\n    var c1 \x3d (c0 \x3e\x3e\x3e 16) + a1 + b1;\n    carry \x3d c1 \x3e\x3e\x3e 16;\n    c0 \x26\x3d 0xFFFF;\n    c1 \x26\x3d 0xFFFF;\n    arr[i] \x3d (c1 \x3c\x3c 16) | c0;\n  }\n  return goog.math.Integer.fromBits(arr);\n};\n\n\n/**\n * Returns the difference of this and the given Integer.\n * @param {goog.math.Integer} other The Integer to subtract from this.\n * @return {!goog.math.Integer} The Integer result.\n */\ngoog.math.Integer.prototype.subtract \x3d function(other) {\n  return this.add(other.negate());\n};\n\n\n/**\n * Returns the product of this and the given Integer.\n * @param {goog.math.Integer} other The Integer to multiply against this.\n * @return {!goog.math.Integer} The product of this and the other.\n */\ngoog.math.Integer.prototype.multiply \x3d function(other) {\n  if (this.isZero()) {\n    return goog.math.Integer.ZERO;\n  } else if (other.isZero()) {\n    return goog.math.Integer.ZERO;\n  }\n\n  if (this.isNegative()) {\n    if (other.isNegative()) {\n      return this.negate().multiply(other.negate());\n    } else {\n      return this.negate().multiply(other).negate();\n    }\n  } else if (other.isNegative()) {\n    return this.multiply(other.negate()).negate();\n  }\n\n  // If both numbers are small, use float multiplication\n  if (this.lessThan(goog.math.Integer.TWO_PWR_24_) \x26\x26\n      other.lessThan(goog.math.Integer.TWO_PWR_24_)) {\n    return goog.math.Integer.fromNumber(this.toNumber() * other.toNumber());\n  }\n\n  // Fill in an array of 16-bit products.\n  var len \x3d this.bits_.length + other.bits_.length;\n  var arr \x3d [];\n  for (var i \x3d 0; i \x3c 2 * len; i++) {\n    arr[i] \x3d 0;\n  }\n  for (var i \x3d 0; i \x3c this.bits_.length; i++) {\n    for (var j \x3d 0; j \x3c other.bits_.length; j++) {\n      var a1 \x3d this.getBits(i) \x3e\x3e\x3e 16;\n      var a0 \x3d this.getBits(i) \x26 0xFFFF;\n\n      var b1 \x3d other.getBits(j) \x3e\x3e\x3e 16;\n      var b0 \x3d other.getBits(j) \x26 0xFFFF;\n\n      arr[2 * i + 2 * j] +\x3d a0 * b0;\n      goog.math.Integer.carry16_(arr, 2 * i + 2 * j);\n      arr[2 * i + 2 * j + 1] +\x3d a1 * b0;\n      goog.math.Integer.carry16_(arr, 2 * i + 2 * j + 1);\n      arr[2 * i + 2 * j + 1] +\x3d a0 * b1;\n      goog.math.Integer.carry16_(arr, 2 * i + 2 * j + 1);\n      arr[2 * i + 2 * j + 2] +\x3d a1 * b1;\n      goog.math.Integer.carry16_(arr, 2 * i + 2 * j + 2);\n    }\n  }\n\n  // Combine the 16-bit values into 32-bit values.\n  for (var i \x3d 0; i \x3c len; i++) {\n    arr[i] \x3d (arr[2 * i + 1] \x3c\x3c 16) | arr[2 * i];\n  }\n  for (var i \x3d len; i \x3c 2 * len; i++) {\n    arr[i] \x3d 0;\n  }\n  return new goog.math.Integer(arr, 0);\n};\n\n\n/**\n * Carries any overflow from the given index into later entries.\n * @param {Array\x3cnumber\x3e} bits Array of 16-bit values in little-endian order.\n * @param {number} index The index in question.\n * @private\n */\ngoog.math.Integer.carry16_ \x3d function(bits, index) {\n  while ((bits[index] \x26 0xFFFF) !\x3d bits[index]) {\n    bits[index + 1] +\x3d bits[index] \x3e\x3e\x3e 16;\n    bits[index] \x26\x3d 0xFFFF;\n    index++;\n  }\n};\n\n\n/**\n * Returns \x22this\x22 Integer divided by the given one. Both \x22this\x22 and the given\n * Integer MUST be positive.\n *\n * This method is only needed for very large numbers (\x3e10^308),\n * for which the original division algorithm gets into an infinite\n * loop (see https://github.com/google/closure-library/issues/500).\n *\n * The algorithm has some possible performance enhancements (or\n * could be rewritten entirely), it\x27s just an initial solution for\n * the issue linked above.\n *\n * @param {!goog.math.Integer} other The Integer to divide \x22this\x22 by.\n * @return {!goog.math.Integer} \x22this\x22 value divided by the given one.\n * @private\n */\ngoog.math.Integer.prototype.slowDivide_ \x3d function(other) {\n  if (this.isNegative() || other.isNegative()) {\n    throw Error(\x27slowDivide_ only works with positive integers.\x27);\n  }\n\n  var twoPower \x3d goog.math.Integer.ONE;\n  var multiple \x3d other;\n\n  // First we have to figure out what the highest bit of the result\n  // is, so we increase \x22twoPower\x22 and \x22multiple\x22 until \x22multiple\x22\n  // exceeds \x22this\x22.\n  while (multiple.lessThanOrEqual(this)) {\n    twoPower \x3d twoPower.shiftLeft(1);\n    multiple \x3d multiple.shiftLeft(1);\n  }\n\n  // Rewind by one power of two, giving us the highest bit of the\n  // result.\n  var res \x3d twoPower.shiftRight(1);\n  var total \x3d multiple.shiftRight(1);\n\n  // Now we starting decreasing \x22multiple\x22 and \x22twoPower\x22 to find the\n  // rest of the bits of the result.\n  var total2;\n  multiple \x3d multiple.shiftRight(2);\n  twoPower \x3d twoPower.shiftRight(2);\n  while (!multiple.isZero()) {\n    // whenever we can add \x22multiple\x22 to the total and not exceed\n    // \x22this\x22, that means we\x27ve found a 1 bit. Else we\x27ve found a 0\n    // and don\x27t need to add to the result.\n    total2 \x3d total.add(multiple);\n    if (total2.lessThanOrEqual(this)) {\n      res \x3d res.add(twoPower);\n      total \x3d total2;\n    }\n    multiple \x3d multiple.shiftRight(1);\n    twoPower \x3d twoPower.shiftRight(1);\n  }\n  return res;\n};\n\n\n/**\n * Returns this Integer divided by the given one.\n * @param {!goog.math.Integer} other The Integer to divide this by.\n * @return {!goog.math.Integer} This value divided by the given one.\n */\ngoog.math.Integer.prototype.divide \x3d function(other) {\n  if (other.isZero()) {\n    throw Error(\x27division by zero\x27);\n  } else if (this.isZero()) {\n    return goog.math.Integer.ZERO;\n  }\n\n  if (this.isNegative()) {\n    if (other.isNegative()) {\n      return this.negate().divide(other.negate());\n    } else {\n      return this.negate().divide(other).negate();\n    }\n  } else if (other.isNegative()) {\n    return this.divide(other.negate()).negate();\n  }\n\n  // Have to degrade to slowDivide for Very Large Numbers, because\n  // they\x27re out of range for the floating-point approximation\n  // technique used below.\n  if (this.bits_.length \x3e 30) {\n    return this.slowDivide_(other);\n  }\n\n  // Repeat the following until the remainder is less than other:  find a\n  // floating-point that approximates remainder / other *from below*, add this\n  // into the result, and subtract it from the remainder.  It is critical that\n  // the approximate value is less than or equal to the real value so that the\n  // remainder never becomes negative.\n  var res \x3d goog.math.Integer.ZERO;\n  var rem \x3d this;\n  while (rem.greaterThanOrEqual(other)) {\n    // Approximate the result of division. This may be a little greater or\n    // smaller than the actual value.\n    var approx \x3d Math.max(1, Math.floor(rem.toNumber() / other.toNumber()));\n\n    // We will tweak the approximate result by changing it in the 48-th digit or\n    // the smallest non-fractional digit, whichever is larger.\n    var log2 \x3d Math.ceil(Math.log(approx) / Math.LN2);\n    var delta \x3d (log2 \x3c\x3d 48) ? 1 : Math.pow(2, log2 - 48);\n\n    // Decrease the approximation until it is smaller than the remainder.  Note\n    // that if it is too large, the product overflows and is negative.\n    var approxRes \x3d goog.math.Integer.fromNumber(approx);\n    var approxRem \x3d approxRes.multiply(other);\n    while (approxRem.isNegative() || approxRem.greaterThan(rem)) {\n      approx -\x3d delta;\n      approxRes \x3d goog.math.Integer.fromNumber(approx);\n      approxRem \x3d approxRes.multiply(other);\n    }\n\n    // We know the answer can\x27t be zero... and actually, zero would cause\n    // infinite recursion since we would make no progress.\n    if (approxRes.isZero()) {\n      approxRes \x3d goog.math.Integer.ONE;\n    }\n\n    res \x3d res.add(approxRes);\n    rem \x3d rem.subtract(approxRem);\n  }\n  return res;\n};\n\n\n/**\n * Returns this Integer modulo the given one.\n * @param {!goog.math.Integer} other The Integer by which to mod.\n * @return {!goog.math.Integer} This value modulo the given one.\n */\ngoog.math.Integer.prototype.modulo \x3d function(other) {\n  return this.subtract(this.divide(other).multiply(other));\n};\n\n\n/** @return {!goog.math.Integer} The bitwise-NOT of this value. */\ngoog.math.Integer.prototype.not \x3d function() {\n  var len \x3d this.bits_.length;\n  var arr \x3d [];\n  for (var i \x3d 0; i \x3c len; i++) {\n    arr[i] \x3d ~this.bits_[i];\n  }\n  return new goog.math.Integer(arr, ~this.sign_);\n};\n\n\n/**\n * Returns the bitwise-AND of this Integer and the given one.\n * @param {goog.math.Integer} other The Integer to AND with this.\n * @return {!goog.math.Integer} The bitwise-AND of this and the other.\n */\ngoog.math.Integer.prototype.and \x3d function(other) {\n  var len \x3d Math.max(this.bits_.length, other.bits_.length);\n  var arr \x3d [];\n  for (var i \x3d 0; i \x3c len; i++) {\n    arr[i] \x3d this.getBits(i) \x26 other.getBits(i);\n  }\n  return new goog.math.Integer(arr, this.sign_ \x26 other.sign_);\n};\n\n\n/**\n * Returns the bitwise-OR of this Integer and the given one.\n * @param {goog.math.Integer} other The Integer to OR with this.\n * @return {!goog.math.Integer} The bitwise-OR of this and the other.\n */\ngoog.math.Integer.prototype.or \x3d function(other) {\n  var len \x3d Math.max(this.bits_.length, other.bits_.length);\n  var arr \x3d [];\n  for (var i \x3d 0; i \x3c len; i++) {\n    arr[i] \x3d this.getBits(i) | other.getBits(i);\n  }\n  return new goog.math.Integer(arr, this.sign_ | other.sign_);\n};\n\n\n/**\n * Returns the bitwise-XOR of this Integer and the given one.\n * @param {goog.math.Integer} other The Integer to XOR with this.\n * @return {!goog.math.Integer} The bitwise-XOR of this and the other.\n */\ngoog.math.Integer.prototype.xor \x3d function(other) {\n  var len \x3d Math.max(this.bits_.length, other.bits_.length);\n  var arr \x3d [];\n  for (var i \x3d 0; i \x3c len; i++) {\n    arr[i] \x3d this.getBits(i) ^ other.getBits(i);\n  }\n  return new goog.math.Integer(arr, this.sign_ ^ other.sign_);\n};\n\n\n/**\n * Returns this value with bits shifted to the left by the given amount.\n * @param {number} numBits The number of bits by which to shift.\n * @return {!goog.math.Integer} This shifted to the left by the given amount.\n */\ngoog.math.Integer.prototype.shiftLeft \x3d function(numBits) {\n  var arr_delta \x3d numBits \x3e\x3e 5;\n  var bit_delta \x3d numBits % 32;\n  var len \x3d this.bits_.length + arr_delta + (bit_delta \x3e 0 ? 1 : 0);\n  var arr \x3d [];\n  for (var i \x3d 0; i \x3c len; i++) {\n    if (bit_delta \x3e 0) {\n      arr[i] \x3d (this.getBits(i - arr_delta) \x3c\x3c bit_delta) |\n          (this.getBits(i - arr_delta - 1) \x3e\x3e\x3e (32 - bit_delta));\n    } else {\n      arr[i] \x3d this.getBits(i - arr_delta);\n    }\n  }\n  return new goog.math.Integer(arr, this.sign_);\n};\n\n\n/**\n * Returns this value with bits shifted to the right by the given amount.\n * @param {number} numBits The number of bits by which to shift.\n * @return {!goog.math.Integer} This shifted to the right by the given amount.\n */\ngoog.math.Integer.prototype.shiftRight \x3d function(numBits) {\n  var arr_delta \x3d numBits \x3e\x3e 5;\n  var bit_delta \x3d numBits % 32;\n  var len \x3d this.bits_.length - arr_delta;\n  var arr \x3d [];\n  for (var i \x3d 0; i \x3c len; i++) {\n    if (bit_delta \x3e 0) {\n      arr[i] \x3d (this.getBits(i + arr_delta) \x3e\x3e\x3e bit_delta) |\n          (this.getBits(i + arr_delta + 1) \x3c\x3c (32 - bit_delta));\n    } else {\n      arr[i] \x3d this.getBits(i + arr_delta);\n    }\n  }\n  return new goog.math.Integer(arr, this.sign_);\n};\n");
SHADOW_ENV.evalLoad("goog.object.object.js", false , "// Copyright 2006 The Closure Library Authors. All Rights Reserved.\n//\n// Licensed under the Apache License, Version 2.0 (the \x22License\x22);\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//      http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an \x22AS-IS\x22 BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\n\n/**\n * @fileoverview Utilities for manipulating objects/maps/hashes.\n * @author arv@google.com (Erik Arvidsson)\n */\n\ngoog.provide(\x27goog.object\x27);\n\n\n/**\n * Whether two values are not observably distinguishable. This\n * correctly detects that 0 is not the same as -0 and two NaNs are\n * practically equivalent.\n *\n * The implementation is as suggested by harmony:egal proposal.\n *\n * @param {*} v The first value to compare.\n * @param {*} v2 The second value to compare.\n * @return {boolean} Whether two values are not observably distinguishable.\n * @see http://wiki.ecmascript.org/doku.php?id\x3dharmony:egal\n */\ngoog.object.is \x3d function(v, v2) {\n  if (v \x3d\x3d\x3d v2) {\n    // 0 \x3d\x3d\x3d -0, but they are not identical.\n    // We need the cast because the compiler requires that v2 is a\n    // number (although 1/v2 works with non-number). We cast to ? to\n    // stop the compiler from type-checking this statement.\n    return v !\x3d\x3d 0 || 1 / v \x3d\x3d\x3d 1 / /** @type {?} */ (v2);\n  }\n\n  // NaN is non-reflexive: NaN !\x3d\x3d NaN, although they are identical.\n  return v !\x3d\x3d v \x26\x26 v2 !\x3d\x3d v2;\n};\n\n\n/**\n * Calls a function for each element in an object/map/hash.\n *\n * @param {Object\x3cK,V\x3e} obj The object over which to iterate.\n * @param {function(this:T,V,?,Object\x3cK,V\x3e):?} f The function to call\n *     for every element. This function takes 3 arguments (the value, the\n *     key and the object) and the return value is ignored.\n * @param {T\x3d} opt_obj This is used as the \x27this\x27 object within f.\n * @template T,K,V\n */\ngoog.object.forEach \x3d function(obj, f, opt_obj) {\n  for (var key in obj) {\n    f.call(/** @type {?} */ (opt_obj), obj[key], key, obj);\n  }\n};\n\n\n/**\n * Calls a function for each element in an object/map/hash. If that call returns\n * true, adds the element to a new object.\n *\n * @param {Object\x3cK,V\x3e} obj The object over which to iterate.\n * @param {function(this:T,V,?,Object\x3cK,V\x3e):boolean} f The function to call\n *     for every element. This\n *     function takes 3 arguments (the value, the key and the object)\n *     and should return a boolean. If the return value is true the\n *     element is added to the result object. If it is false the\n *     element is not included.\n * @param {T\x3d} opt_obj This is used as the \x27this\x27 object within f.\n * @return {!Object\x3cK,V\x3e} a new object in which only elements that passed the\n *     test are present.\n * @template T,K,V\n */\ngoog.object.filter \x3d function(obj, f, opt_obj) {\n  var res \x3d {};\n  for (var key in obj) {\n    if (f.call(/** @type {?} */ (opt_obj), obj[key], key, obj)) {\n      res[key] \x3d obj[key];\n    }\n  }\n  return res;\n};\n\n\n/**\n * For every element in an object/map/hash calls a function and inserts the\n * result into a new object.\n *\n * @param {Object\x3cK,V\x3e} obj The object over which to iterate.\n * @param {function(this:T,V,?,Object\x3cK,V\x3e):R} f The function to call\n *     for every element. This function\n *     takes 3 arguments (the value, the key and the object)\n *     and should return something. The result will be inserted\n *     into a new object.\n * @param {T\x3d} opt_obj This is used as the \x27this\x27 object within f.\n * @return {!Object\x3cK,R\x3e} a new object with the results from f.\n * @template T,K,V,R\n */\ngoog.object.map \x3d function(obj, f, opt_obj) {\n  var res \x3d {};\n  for (var key in obj) {\n    res[key] \x3d f.call(/** @type {?} */ (opt_obj), obj[key], key, obj);\n  }\n  return res;\n};\n\n\n/**\n * Calls a function for each element in an object/map/hash. If any\n * call returns true, returns true (without checking the rest). If\n * all calls return false, returns false.\n *\n * @param {Object\x3cK,V\x3e} obj The object to check.\n * @param {function(this:T,V,?,Object\x3cK,V\x3e):boolean} f The function to\n *     call for every element. This function\n *     takes 3 arguments (the value, the key and the object) and should\n *     return a boolean.\n * @param {T\x3d} opt_obj This is used as the \x27this\x27 object within f.\n * @return {boolean} true if any element passes the test.\n * @template T,K,V\n */\ngoog.object.some \x3d function(obj, f, opt_obj) {\n  for (var key in obj) {\n    if (f.call(/** @type {?} */ (opt_obj), obj[key], key, obj)) {\n      return true;\n    }\n  }\n  return false;\n};\n\n\n/**\n * Calls a function for each element in an object/map/hash. If\n * all calls return true, returns true. If any call returns false, returns\n * false at this point and does not continue to check the remaining elements.\n *\n * @param {Object\x3cK,V\x3e} obj The object to check.\n * @param {?function(this:T,V,?,Object\x3cK,V\x3e):boolean} f The function to\n *     call for every element. This function\n *     takes 3 arguments (the value, the key and the object) and should\n *     return a boolean.\n * @param {T\x3d} opt_obj This is used as the \x27this\x27 object within f.\n * @return {boolean} false if any element fails the test.\n * @template T,K,V\n */\ngoog.object.every \x3d function(obj, f, opt_obj) {\n  for (var key in obj) {\n    if (!f.call(/** @type {?} */ (opt_obj), obj[key], key, obj)) {\n      return false;\n    }\n  }\n  return true;\n};\n\n\n/**\n * Returns the number of key-value pairs in the object map.\n *\n * @param {Object} obj The object for which to get the number of key-value\n *     pairs.\n * @return {number} The number of key-value pairs in the object map.\n */\ngoog.object.getCount \x3d function(obj) {\n  var rv \x3d 0;\n  for (var key in obj) {\n    rv++;\n  }\n  return rv;\n};\n\n\n/**\n * Returns one key from the object map, if any exists.\n * For map literals the returned key will be the first one in most of the\n * browsers (a know exception is Konqueror).\n *\n * @param {Object} obj The object to pick a key from.\n * @return {string|undefined} The key or undefined if the object is empty.\n */\ngoog.object.getAnyKey \x3d function(obj) {\n  for (var key in obj) {\n    return key;\n  }\n};\n\n\n/**\n * Returns one value from the object map, if any exists.\n * For map literals the returned value will be the first one in most of the\n * browsers (a know exception is Konqueror).\n *\n * @param {Object\x3cK,V\x3e} obj The object to pick a value from.\n * @return {V|undefined} The value or undefined if the object is empty.\n * @template K,V\n */\ngoog.object.getAnyValue \x3d function(obj) {\n  for (var key in obj) {\n    return obj[key];\n  }\n};\n\n\n/**\n * Whether the object/hash/map contains the given object as a value.\n * An alias for goog.object.containsValue(obj, val).\n *\n * @param {Object\x3cK,V\x3e} obj The object in which to look for val.\n * @param {V} val The object for which to check.\n * @return {boolean} true if val is present.\n * @template K,V\n */\ngoog.object.contains \x3d function(obj, val) {\n  return goog.object.containsValue(obj, val);\n};\n\n\n/**\n * Returns the values of the object/map/hash.\n *\n * @param {Object\x3cK,V\x3e} obj The object from which to get the values.\n * @return {!Array\x3cV\x3e} The values in the object/map/hash.\n * @template K,V\n */\ngoog.object.getValues \x3d function(obj) {\n  var res \x3d [];\n  var i \x3d 0;\n  for (var key in obj) {\n    res[i++] \x3d obj[key];\n  }\n  return res;\n};\n\n\n/**\n * Returns the keys of the object/map/hash.\n *\n * @param {Object} obj The object from which to get the keys.\n * @return {!Array\x3cstring\x3e} Array of property keys.\n */\ngoog.object.getKeys \x3d function(obj) {\n  var res \x3d [];\n  var i \x3d 0;\n  for (var key in obj) {\n    res[i++] \x3d key;\n  }\n  return res;\n};\n\n\n/**\n * Get a value from an object multiple levels deep.  This is useful for\n * pulling values from deeply nested objects, such as JSON responses.\n * Example usage: getValueByKeys(jsonObj, \x27foo\x27, \x27entries\x27, 3)\n *\n * @param {!Object} obj An object to get the value from.  Can be array-like.\n * @param {...(string|number|!IArrayLike\x3cnumber|string\x3e)}\n *     var_args A number of keys\n *     (as strings, or numbers, for array-like objects).  Can also be\n *     specified as a single array of keys.\n * @return {*} The resulting value.  If, at any point, the value for a key\n *     is undefined, returns undefined.\n */\ngoog.object.getValueByKeys \x3d function(obj, var_args) {\n  var isArrayLike \x3d goog.isArrayLike(var_args);\n  var keys \x3d isArrayLike ? var_args : arguments;\n\n  // Start with the 2nd parameter for the variable parameters syntax.\n  for (var i \x3d isArrayLike ? 0 : 1; i \x3c keys.length; i++) {\n    obj \x3d obj[keys[i]];\n    if (!goog.isDef(obj)) {\n      break;\n    }\n  }\n\n  return obj;\n};\n\n\n/**\n * Whether the object/map/hash contains the given key.\n *\n * @param {Object} obj The object in which to look for key.\n * @param {?} key The key for which to check.\n * @return {boolean} true If the map contains the key.\n */\ngoog.object.containsKey \x3d function(obj, key) {\n  return obj !\x3d\x3d null \x26\x26 key in obj;\n};\n\n\n/**\n * Whether the object/map/hash contains the given value. This is O(n).\n *\n * @param {Object\x3cK,V\x3e} obj The object in which to look for val.\n * @param {V} val The value for which to check.\n * @return {boolean} true If the map contains the value.\n * @template K,V\n */\ngoog.object.containsValue \x3d function(obj, val) {\n  for (var key in obj) {\n    if (obj[key] \x3d\x3d val) {\n      return true;\n    }\n  }\n  return false;\n};\n\n\n/**\n * Searches an object for an element that satisfies the given condition and\n * returns its key.\n * @param {Object\x3cK,V\x3e} obj The object to search in.\n * @param {function(this:T,V,string,Object\x3cK,V\x3e):boolean} f The\n *      function to call for every element. Takes 3 arguments (the value,\n *     the key and the object) and should return a boolean.\n * @param {T\x3d} opt_this An optional \x22this\x22 context for the function.\n * @return {string|undefined} The key of an element for which the function\n *     returns true or undefined if no such element is found.\n * @template T,K,V\n */\ngoog.object.findKey \x3d function(obj, f, opt_this) {\n  for (var key in obj) {\n    if (f.call(/** @type {?} */ (opt_this), obj[key], key, obj)) {\n      return key;\n    }\n  }\n  return undefined;\n};\n\n\n/**\n * Searches an object for an element that satisfies the given condition and\n * returns its value.\n * @param {Object\x3cK,V\x3e} obj The object to search in.\n * @param {function(this:T,V,string,Object\x3cK,V\x3e):boolean} f The function\n *     to call for every element. Takes 3 arguments (the value, the key\n *     and the object) and should return a boolean.\n * @param {T\x3d} opt_this An optional \x22this\x22 context for the function.\n * @return {V} The value of an element for which the function returns true or\n *     undefined if no such element is found.\n * @template T,K,V\n */\ngoog.object.findValue \x3d function(obj, f, opt_this) {\n  var key \x3d goog.object.findKey(obj, f, opt_this);\n  return key \x26\x26 obj[key];\n};\n\n\n/**\n * Whether the object/map/hash is empty.\n *\n * @param {Object} obj The object to test.\n * @return {boolean} true if obj is empty.\n */\ngoog.object.isEmpty \x3d function(obj) {\n  for (var key in obj) {\n    return false;\n  }\n  return true;\n};\n\n\n/**\n * Removes all key value pairs from the object/map/hash.\n *\n * @param {Object} obj The object to clear.\n */\ngoog.object.clear \x3d function(obj) {\n  for (var i in obj) {\n    delete obj[i];\n  }\n};\n\n\n/**\n * Removes a key-value pair based on the key.\n *\n * @param {Object} obj The object from which to remove the key.\n * @param {?} key The key to remove.\n * @return {boolean} Whether an element was removed.\n */\ngoog.object.remove \x3d function(obj, key) {\n  var rv;\n  if (rv \x3d key in /** @type {!Object} */ (obj)) {\n    delete obj[key];\n  }\n  return rv;\n};\n\n\n/**\n * Adds a key-value pair to the object. Throws an exception if the key is\n * already in use. Use set if you want to change an existing pair.\n *\n * @param {Object\x3cK,V\x3e} obj The object to which to add the key-value pair.\n * @param {string} key The key to add.\n * @param {V} val The value to add.\n * @template K,V\n */\ngoog.object.add \x3d function(obj, key, val) {\n  if (obj !\x3d\x3d null \x26\x26 key in obj) {\n    throw Error(\x27The object already contains the key \x22\x27 + key + \x27\x22\x27);\n  }\n  goog.object.set(obj, key, val);\n};\n\n\n/**\n * Returns the value for the given key.\n *\n * @param {Object\x3cK,V\x3e} obj The object from which to get the value.\n * @param {string} key The key for which to get the value.\n * @param {R\x3d} opt_val The value to return if no item is found for the given\n *     key (default is undefined).\n * @return {V|R|undefined} The value for the given key.\n * @template K,V,R\n */\ngoog.object.get \x3d function(obj, key, opt_val) {\n  if (obj !\x3d\x3d null \x26\x26 key in obj) {\n    return obj[key];\n  }\n  return opt_val;\n};\n\n\n/**\n * Adds a key-value pair to the object/map/hash.\n *\n * @param {Object\x3cK,V\x3e} obj The object to which to add the key-value pair.\n * @param {string} key The key to add.\n * @param {V} value The value to add.\n * @template K,V\n */\ngoog.object.set \x3d function(obj, key, value) {\n  obj[key] \x3d value;\n};\n\n\n/**\n * Adds a key-value pair to the object/map/hash if it doesn\x27t exist yet.\n *\n * @param {Object\x3cK,V\x3e} obj The object to which to add the key-value pair.\n * @param {string} key The key to add.\n * @param {V} value The value to add if the key wasn\x27t present.\n * @return {V} The value of the entry at the end of the function.\n * @template K,V\n */\ngoog.object.setIfUndefined \x3d function(obj, key, value) {\n  return key in /** @type {!Object} */ (obj) ? obj[key] : (obj[key] \x3d value);\n};\n\n\n/**\n * Sets a key and value to an object if the key is not set. The value will be\n * the return value of the given function. If the key already exists, the\n * object will not be changed and the function will not be called (the function\n * will be lazily evaluated -- only called if necessary).\n *\n * This function is particularly useful for use with a map used a as a cache.\n *\n * @param {!Object\x3cK,V\x3e} obj The object to which to add the key-value pair.\n * @param {string} key The key to add.\n * @param {function():V} f The value to add if the key wasn\x27t present.\n * @return {V} The value of the entry at the end of the function.\n * @template K,V\n */\ngoog.object.setWithReturnValueIfNotSet \x3d function(obj, key, f) {\n  if (key in obj) {\n    return obj[key];\n  }\n\n  var val \x3d f();\n  obj[key] \x3d val;\n  return val;\n};\n\n\n/**\n * Compares two objects for equality using \x3d\x3d\x3d on the values.\n *\n * @param {!Object\x3cK,V\x3e} a\n * @param {!Object\x3cK,V\x3e} b\n * @return {boolean}\n * @template K,V\n */\ngoog.object.equals \x3d function(a, b) {\n  for (var k in a) {\n    if (!(k in b) || a[k] !\x3d\x3d b[k]) {\n      return false;\n    }\n  }\n  for (var k in b) {\n    if (!(k in a)) {\n      return false;\n    }\n  }\n  return true;\n};\n\n\n/**\n * Returns a shallow clone of the object.\n *\n * @param {Object\x3cK,V\x3e} obj Object to clone.\n * @return {!Object\x3cK,V\x3e} Clone of the input object.\n * @template K,V\n */\ngoog.object.clone \x3d function(obj) {\n  // We cannot use the prototype trick because a lot of methods depend on where\n  // the actual key is set.\n\n  var res \x3d {};\n  for (var key in obj) {\n    res[key] \x3d obj[key];\n  }\n  return res;\n  // We could also use goog.mixin but I wanted this to be independent from that.\n};\n\n\n/**\n * Clones a value. The input may be an Object, Array, or basic type. Objects and\n * arrays will be cloned recursively.\n *\n * WARNINGS:\n * \x3ccode\x3egoog.object.unsafeClone\x3c/code\x3e does not detect reference loops. Objects\n * that refer to themselves will cause infinite recursion.\n *\n * \x3ccode\x3egoog.object.unsafeClone\x3c/code\x3e is unaware of unique identifiers, and\n * copies UIDs created by \x3ccode\x3egetUid\x3c/code\x3e into cloned results.\n *\n * @param {T} obj The value to clone.\n * @return {T} A clone of the input value.\n * @template T\n */\ngoog.object.unsafeClone \x3d function(obj) {\n  var type \x3d goog.typeOf(obj);\n  if (type \x3d\x3d \x27object\x27 || type \x3d\x3d \x27array\x27) {\n    if (goog.isFunction(obj.clone)) {\n      return obj.clone();\n    }\n    var clone \x3d type \x3d\x3d \x27array\x27 ? [] : {};\n    for (var key in obj) {\n      clone[key] \x3d goog.object.unsafeClone(obj[key]);\n    }\n    return clone;\n  }\n\n  return obj;\n};\n\n\n/**\n * Returns a new object in which all the keys and values are interchanged\n * (keys become values and values become keys). If multiple keys map to the\n * same value, the chosen transposed value is implementation-dependent.\n *\n * @param {Object} obj The object to transpose.\n * @return {!Object} The transposed object.\n */\ngoog.object.transpose \x3d function(obj) {\n  var transposed \x3d {};\n  for (var key in obj) {\n    transposed[obj[key]] \x3d key;\n  }\n  return transposed;\n};\n\n\n/**\n * The names of the fields that are defined on Object.prototype.\n * @type {Array\x3cstring\x3e}\n * @private\n */\ngoog.object.PROTOTYPE_FIELDS_ \x3d [\n  \x27constructor\x27, \x27hasOwnProperty\x27, \x27isPrototypeOf\x27, \x27propertyIsEnumerable\x27,\n  \x27toLocaleString\x27, \x27toString\x27, \x27valueOf\x27\n];\n\n\n/**\n * Extends an object with another object.\n * This operates \x27in-place\x27; it does not create a new Object.\n *\n * Example:\n * var o \x3d {};\n * goog.object.extend(o, {a: 0, b: 1});\n * o; // {a: 0, b: 1}\n * goog.object.extend(o, {b: 2, c: 3});\n * o; // {a: 0, b: 2, c: 3}\n *\n * @param {Object} target The object to modify. Existing properties will be\n *     overwritten if they are also present in one of the objects in\n *     {@code var_args}.\n * @param {...Object} var_args The objects from which values will be copied.\n */\ngoog.object.extend \x3d function(target, var_args) {\n  var key, source;\n  for (var i \x3d 1; i \x3c arguments.length; i++) {\n    source \x3d arguments[i];\n    for (key in source) {\n      target[key] \x3d source[key];\n    }\n\n    // For IE the for-in-loop does not contain any properties that are not\n    // enumerable on the prototype object (for example isPrototypeOf from\n    // Object.prototype) and it will also not include \x27replace\x27 on objects that\n    // extend String and change \x27replace\x27 (not that it is common for anyone to\n    // extend anything except Object).\n\n    for (var j \x3d 0; j \x3c goog.object.PROTOTYPE_FIELDS_.length; j++) {\n      key \x3d goog.object.PROTOTYPE_FIELDS_[j];\n      if (Object.prototype.hasOwnProperty.call(source, key)) {\n        target[key] \x3d source[key];\n      }\n    }\n  }\n};\n\n\n/**\n * Creates a new object built from the key-value pairs provided as arguments.\n * @param {...*} var_args If only one argument is provided and it is an array\n *     then this is used as the arguments, otherwise even arguments are used as\n *     the property names and odd arguments are used as the property values.\n * @return {!Object} The new object.\n * @throws {Error} If there are uneven number of arguments or there is only one\n *     non array argument.\n */\ngoog.object.create \x3d function(var_args) {\n  var argLength \x3d arguments.length;\n  if (argLength \x3d\x3d 1 \x26\x26 goog.isArray(arguments[0])) {\n    return goog.object.create.apply(null, arguments[0]);\n  }\n\n  if (argLength % 2) {\n    throw Error(\x27Uneven number of arguments\x27);\n  }\n\n  var rv \x3d {};\n  for (var i \x3d 0; i \x3c argLength; i +\x3d 2) {\n    rv[arguments[i]] \x3d arguments[i + 1];\n  }\n  return rv;\n};\n\n\n/**\n * Creates a new object where the property names come from the arguments but\n * the value is always set to true\n * @param {...*} var_args If only one argument is provided and it is an array\n *     then this is used as the arguments, otherwise the arguments are used\n *     as the property names.\n * @return {!Object} The new object.\n */\ngoog.object.createSet \x3d function(var_args) {\n  var argLength \x3d arguments.length;\n  if (argLength \x3d\x3d 1 \x26\x26 goog.isArray(arguments[0])) {\n    return goog.object.createSet.apply(null, arguments[0]);\n  }\n\n  var rv \x3d {};\n  for (var i \x3d 0; i \x3c argLength; i++) {\n    rv[arguments[i]] \x3d true;\n  }\n  return rv;\n};\n\n\n/**\n * Creates an immutable view of the underlying object, if the browser\n * supports immutable objects.\n *\n * In default mode, writes to this view will fail silently. In strict mode,\n * they will throw an error.\n *\n * @param {!Object\x3cK,V\x3e} obj An object.\n * @return {!Object\x3cK,V\x3e} An immutable view of that object, or the\n *     original object if this browser does not support immutables.\n * @template K,V\n */\ngoog.object.createImmutableView \x3d function(obj) {\n  var result \x3d obj;\n  if (Object.isFrozen \x26\x26 !Object.isFrozen(obj)) {\n    result \x3d Object.create(obj);\n    Object.freeze(result);\n  }\n  return result;\n};\n\n\n/**\n * @param {!Object} obj An object.\n * @return {boolean} Whether this is an immutable view of the object.\n */\ngoog.object.isImmutableView \x3d function(obj) {\n  return !!Object.isFrozen \x26\x26 Object.isFrozen(obj);\n};\n\n\n/**\n * Get all properties names on a given Object regardless of enumerability.\n *\n * \x3cp\x3e If the browser does not support {@code Object.getOwnPropertyNames} nor\n * {@code Object.getPrototypeOf} then this is equivalent to using {@code\n * goog.object.getKeys}\n *\n * @param {?Object} obj The object to get the properties of.\n * @param {boolean\x3d} opt_includeObjectPrototype Whether properties defined on\n *     {@code Object.prototype} should be included in the result.\n * @param {boolean\x3d} opt_includeFunctionPrototype Whether properties defined on\n *     {@code Function.prototype} should be included in the result.\n * @return {!Array\x3cstring\x3e}\n * @public\n */\ngoog.object.getAllPropertyNames \x3d function(\n    obj, opt_includeObjectPrototype, opt_includeFunctionPrototype) {\n  if (!obj) {\n    return [];\n  }\n\n  // Naively use a for..in loop to get the property names if the browser doesn\x27t\n  // support any other APIs for getting it.\n  if (!Object.getOwnPropertyNames || !Object.getPrototypeOf) {\n    return goog.object.getKeys(obj);\n  }\n\n  var visitedSet \x3d {};\n\n  // Traverse the prototype chain and add all properties to the visited set.\n  var proto \x3d obj;\n  while (proto \x26\x26\n         (proto !\x3d\x3d Object.prototype || !!opt_includeObjectPrototype) \x26\x26\n         (proto !\x3d\x3d Function.prototype || !!opt_includeFunctionPrototype)) {\n    var names \x3d Object.getOwnPropertyNames(proto);\n    for (var i \x3d 0; i \x3c names.length; i++) {\n      visitedSet[names[i]] \x3d true;\n    }\n    proto \x3d Object.getPrototypeOf(proto);\n  }\n\n  return goog.object.getKeys(visitedSet);\n};\n");
SHADOW_ENV.evalLoad("goog.array.array.js", false , "// Copyright 2006 The Closure Library Authors. All Rights Reserved.\n//\n// Licensed under the Apache License, Version 2.0 (the \x22License\x22);\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//      http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an \x22AS-IS\x22 BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\n\n/**\n * @fileoverview Utilities for manipulating arrays.\n *\n * @author arv@google.com (Erik Arvidsson)\n */\n\n\ngoog.provide(\x27goog.array\x27);\n\ngoog.require(\x27goog.asserts\x27);\n\n\n/**\n * @define {boolean} NATIVE_ARRAY_PROTOTYPES indicates whether the code should\n * rely on Array.prototype functions, if available.\n *\n * The Array.prototype functions can be defined by external libraries like\n * Prototype and setting this flag to false forces closure to use its own\n * goog.array implementation.\n *\n * If your javascript can be loaded by a third party site and you are wary about\n * relying on the prototype functions, specify\n * \x22--define goog.NATIVE_ARRAY_PROTOTYPES\x3dfalse\x22 to the JSCompiler.\n *\n * Setting goog.TRUSTED_SITE to false will automatically set\n * NATIVE_ARRAY_PROTOTYPES to false.\n */\ngoog.define(\x27goog.NATIVE_ARRAY_PROTOTYPES\x27, goog.TRUSTED_SITE);\n\n\n/**\n * @define {boolean} If true, JSCompiler will use the native implementation of\n * array functions where appropriate (e.g., {@code Array#filter}) and remove the\n * unused pure JS implementation.\n */\ngoog.define(\x27goog.array.ASSUME_NATIVE_FUNCTIONS\x27, false);\n\n\n/**\n * Returns the last element in an array without removing it.\n * Same as goog.array.last.\n * @param {IArrayLike\x3cT\x3e|string} array The array.\n * @return {T} Last item in array.\n * @template T\n */\ngoog.array.peek \x3d function(array) {\n  return array[array.length - 1];\n};\n\n\n/**\n * Returns the last element in an array without removing it.\n * Same as goog.array.peek.\n * @param {IArrayLike\x3cT\x3e|string} array The array.\n * @return {T} Last item in array.\n * @template T\n */\ngoog.array.last \x3d goog.array.peek;\n\n// NOTE(arv): Since most of the array functions are generic it allows you to\n// pass an array-like object. Strings have a length and are considered array-\n// like. However, the \x27in\x27 operator does not work on strings so we cannot just\n// use the array path even if the browser supports indexing into strings. We\n// therefore end up splitting the string.\n\n\n/**\n * Returns the index of the first element of an array with a specified value, or\n * -1 if the element is not present in the array.\n *\n * See {@link http://tinyurl.com/developer-mozilla-org-array-indexof}\n *\n * @param {IArrayLike\x3cT\x3e|string} arr The array to be searched.\n * @param {T} obj The object for which we are searching.\n * @param {number\x3d} opt_fromIndex The index at which to start the search. If\n *     omitted the search starts at index 0.\n * @return {number} The index of the first matching array element.\n * @template T\n */\ngoog.array.indexOf \x3d goog.NATIVE_ARRAY_PROTOTYPES \x26\x26\n        (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.indexOf) ?\n    function(arr, obj, opt_fromIndex) {\n      goog.asserts.assert(arr.length !\x3d null);\n\n      return Array.prototype.indexOf.call(arr, obj, opt_fromIndex);\n    } :\n    function(arr, obj, opt_fromIndex) {\n      var fromIndex \x3d opt_fromIndex \x3d\x3d null ?\n          0 :\n          (opt_fromIndex \x3c 0 ? Math.max(0, arr.length + opt_fromIndex) :\n                               opt_fromIndex);\n\n      if (goog.isString(arr)) {\n        // Array.prototype.indexOf uses \x3d\x3d\x3d so only strings should be found.\n        if (!goog.isString(obj) || obj.length !\x3d 1) {\n          return -1;\n        }\n        return arr.indexOf(obj, fromIndex);\n      }\n\n      for (var i \x3d fromIndex; i \x3c arr.length; i++) {\n        if (i in arr \x26\x26 arr[i] \x3d\x3d\x3d obj) return i;\n      }\n      return -1;\n    };\n\n\n/**\n * Returns the index of the last element of an array with a specified value, or\n * -1 if the element is not present in the array.\n *\n * See {@link http://tinyurl.com/developer-mozilla-org-array-lastindexof}\n *\n * @param {!IArrayLike\x3cT\x3e|string} arr The array to be searched.\n * @param {T} obj The object for which we are searching.\n * @param {?number\x3d} opt_fromIndex The index at which to start the search. If\n *     omitted the search starts at the end of the array.\n * @return {number} The index of the last matching array element.\n * @template T\n */\ngoog.array.lastIndexOf \x3d goog.NATIVE_ARRAY_PROTOTYPES \x26\x26\n        (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.lastIndexOf) ?\n    function(arr, obj, opt_fromIndex) {\n      goog.asserts.assert(arr.length !\x3d null);\n\n      // Firefox treats undefined and null as 0 in the fromIndex argument which\n      // leads it to always return -1\n      var fromIndex \x3d opt_fromIndex \x3d\x3d null ? arr.length - 1 : opt_fromIndex;\n      return Array.prototype.lastIndexOf.call(arr, obj, fromIndex);\n    } :\n    function(arr, obj, opt_fromIndex) {\n      var fromIndex \x3d opt_fromIndex \x3d\x3d null ? arr.length - 1 : opt_fromIndex;\n\n      if (fromIndex \x3c 0) {\n        fromIndex \x3d Math.max(0, arr.length + fromIndex);\n      }\n\n      if (goog.isString(arr)) {\n        // Array.prototype.lastIndexOf uses \x3d\x3d\x3d so only strings should be found.\n        if (!goog.isString(obj) || obj.length !\x3d 1) {\n          return -1;\n        }\n        return arr.lastIndexOf(obj, fromIndex);\n      }\n\n      for (var i \x3d fromIndex; i \x3e\x3d 0; i--) {\n        if (i in arr \x26\x26 arr[i] \x3d\x3d\x3d obj) return i;\n      }\n      return -1;\n    };\n\n\n/**\n * Calls a function for each element in an array. Skips holes in the array.\n * See {@link http://tinyurl.com/developer-mozilla-org-array-foreach}\n *\n * @param {IArrayLike\x3cT\x3e|string} arr Array or array like object over\n *     which to iterate.\n * @param {?function(this: S, T, number, ?): ?} f The function to call for every\n *     element. This function takes 3 arguments (the element, the index and the\n *     array). The return value is ignored.\n * @param {S\x3d} opt_obj The object to be used as the value of \x27this\x27 within f.\n * @template T,S\n */\ngoog.array.forEach \x3d goog.NATIVE_ARRAY_PROTOTYPES \x26\x26\n        (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.forEach) ?\n    function(arr, f, opt_obj) {\n      goog.asserts.assert(arr.length !\x3d null);\n\n      Array.prototype.forEach.call(arr, f, opt_obj);\n    } :\n    function(arr, f, opt_obj) {\n      var l \x3d arr.length;  // must be fixed during loop... see docs\n      var arr2 \x3d goog.isString(arr) ? arr.split(\x27\x27) : arr;\n      for (var i \x3d 0; i \x3c l; i++) {\n        if (i in arr2) {\n          f.call(/** @type {?} */ (opt_obj), arr2[i], i, arr);\n        }\n      }\n    };\n\n\n/**\n * Calls a function for each element in an array, starting from the last\n * element rather than the first.\n *\n * @param {IArrayLike\x3cT\x3e|string} arr Array or array\n *     like object over which to iterate.\n * @param {?function(this: S, T, number, ?): ?} f The function to call for every\n *     element. This function\n *     takes 3 arguments (the element, the index and the array). The return\n *     value is ignored.\n * @param {S\x3d} opt_obj The object to be used as the value of \x27this\x27\n *     within f.\n * @template T,S\n */\ngoog.array.forEachRight \x3d function(arr, f, opt_obj) {\n  var l \x3d arr.length;  // must be fixed during loop... see docs\n  var arr2 \x3d goog.isString(arr) ? arr.split(\x27\x27) : arr;\n  for (var i \x3d l - 1; i \x3e\x3d 0; --i) {\n    if (i in arr2) {\n      f.call(/** @type {?} */ (opt_obj), arr2[i], i, arr);\n    }\n  }\n};\n\n\n/**\n * Calls a function for each element in an array, and if the function returns\n * true adds the element to a new array.\n *\n * See {@link http://tinyurl.com/developer-mozilla-org-array-filter}\n *\n * @param {IArrayLike\x3cT\x3e|string} arr Array or array\n *     like object over which to iterate.\n * @param {?function(this:S, T, number, ?):boolean} f The function to call for\n *     every element. This function\n *     takes 3 arguments (the element, the index and the array) and must\n *     return a Boolean. If the return value is true the element is added to the\n *     result array. If it is false the element is not included.\n * @param {S\x3d} opt_obj The object to be used as the value of \x27this\x27\n *     within f.\n * @return {!Array\x3cT\x3e} a new array in which only elements that passed the test\n *     are present.\n * @template T,S\n */\ngoog.array.filter \x3d goog.NATIVE_ARRAY_PROTOTYPES \x26\x26\n        (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.filter) ?\n    function(arr, f, opt_obj) {\n      goog.asserts.assert(arr.length !\x3d null);\n\n      return Array.prototype.filter.call(arr, f, opt_obj);\n    } :\n    function(arr, f, opt_obj) {\n      var l \x3d arr.length;  // must be fixed during loop... see docs\n      var res \x3d [];\n      var resLength \x3d 0;\n      var arr2 \x3d goog.isString(arr) ? arr.split(\x27\x27) : arr;\n      for (var i \x3d 0; i \x3c l; i++) {\n        if (i in arr2) {\n          var val \x3d arr2[i];  // in case f mutates arr2\n          if (f.call(/** @type {?} */ (opt_obj), val, i, arr)) {\n            res[resLength++] \x3d val;\n          }\n        }\n      }\n      return res;\n    };\n\n\n/**\n * Calls a function for each element in an array and inserts the result into a\n * new array.\n *\n * See {@link http://tinyurl.com/developer-mozilla-org-array-map}\n *\n * @param {IArrayLike\x3cVALUE\x3e|string} arr Array or array like object\n *     over which to iterate.\n * @param {function(this:THIS, VALUE, number, ?): RESULT} f The function to call\n *     for every element. This function takes 3 arguments (the element,\n *     the index and the array) and should return something. The result will be\n *     inserted into a new array.\n * @param {THIS\x3d} opt_obj The object to be used as the value of \x27this\x27 within f.\n * @return {!Array\x3cRESULT\x3e} a new array with the results from f.\n * @template THIS, VALUE, RESULT\n */\ngoog.array.map \x3d goog.NATIVE_ARRAY_PROTOTYPES \x26\x26\n        (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.map) ?\n    function(arr, f, opt_obj) {\n      goog.asserts.assert(arr.length !\x3d null);\n\n      return Array.prototype.map.call(arr, f, opt_obj);\n    } :\n    function(arr, f, opt_obj) {\n      var l \x3d arr.length;  // must be fixed during loop... see docs\n      var res \x3d new Array(l);\n      var arr2 \x3d goog.isString(arr) ? arr.split(\x27\x27) : arr;\n      for (var i \x3d 0; i \x3c l; i++) {\n        if (i in arr2) {\n          res[i] \x3d f.call(/** @type {?} */ (opt_obj), arr2[i], i, arr);\n        }\n      }\n      return res;\n    };\n\n\n/**\n * Passes every element of an array into a function and accumulates the result.\n *\n * See {@link http://tinyurl.com/developer-mozilla-org-array-reduce}\n *\n * For example:\n * var a \x3d [1, 2, 3, 4];\n * goog.array.reduce(a, function(r, v, i, arr) {return r + v;}, 0);\n * returns 10\n *\n * @param {IArrayLike\x3cT\x3e|string} arr Array or array\n *     like object over which to iterate.\n * @param {function(this:S, R, T, number, ?) : R} f The function to call for\n *     every element. This function\n *     takes 4 arguments (the function\x27s previous result or the initial value,\n *     the value of the current array element, the current array index, and the\n *     array itself)\n *     function(previousValue, currentValue, index, array).\n * @param {?} val The initial value to pass into the function on the first call.\n * @param {S\x3d} opt_obj  The object to be used as the value of \x27this\x27\n *     within f.\n * @return {R} Result of evaluating f repeatedly across the values of the array.\n * @template T,S,R\n */\ngoog.array.reduce \x3d goog.NATIVE_ARRAY_PROTOTYPES \x26\x26\n        (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.reduce) ?\n    function(arr, f, val, opt_obj) {\n      goog.asserts.assert(arr.length !\x3d null);\n      if (opt_obj) {\n        f \x3d goog.bind(f, opt_obj);\n      }\n      return Array.prototype.reduce.call(arr, f, val);\n    } :\n    function(arr, f, val, opt_obj) {\n      var rval \x3d val;\n      goog.array.forEach(arr, function(val, index) {\n        rval \x3d f.call(/** @type {?} */ (opt_obj), rval, val, index, arr);\n      });\n      return rval;\n    };\n\n\n/**\n * Passes every element of an array into a function and accumulates the result,\n * starting from the last element and working towards the first.\n *\n * See {@link http://tinyurl.com/developer-mozilla-org-array-reduceright}\n *\n * For example:\n * var a \x3d [\x27a\x27, \x27b\x27, \x27c\x27];\n * goog.array.reduceRight(a, function(r, v, i, arr) {return r + v;}, \x27\x27);\n * returns \x27cba\x27\n *\n * @param {IArrayLike\x3cT\x3e|string} arr Array or array\n *     like object over which to iterate.\n * @param {?function(this:S, R, T, number, ?) : R} f The function to call for\n *     every element. This function\n *     takes 4 arguments (the function\x27s previous result or the initial value,\n *     the value of the current array element, the current array index, and the\n *     array itself)\n *     function(previousValue, currentValue, index, array).\n * @param {?} val The initial value to pass into the function on the first call.\n * @param {S\x3d} opt_obj The object to be used as the value of \x27this\x27\n *     within f.\n * @return {R} Object returned as a result of evaluating f repeatedly across the\n *     values of the array.\n * @template T,S,R\n */\ngoog.array.reduceRight \x3d goog.NATIVE_ARRAY_PROTOTYPES \x26\x26\n        (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.reduceRight) ?\n    function(arr, f, val, opt_obj) {\n      goog.asserts.assert(arr.length !\x3d null);\n      goog.asserts.assert(f !\x3d null);\n      if (opt_obj) {\n        f \x3d goog.bind(f, opt_obj);\n      }\n      return Array.prototype.reduceRight.call(arr, f, val);\n    } :\n    function(arr, f, val, opt_obj) {\n      var rval \x3d val;\n      goog.array.forEachRight(arr, function(val, index) {\n        rval \x3d f.call(/** @type {?} */ (opt_obj), rval, val, index, arr);\n      });\n      return rval;\n    };\n\n\n/**\n * Calls f for each element of an array. If any call returns true, some()\n * returns true (without checking the remaining elements). If all calls\n * return false, some() returns false.\n *\n * See {@link http://tinyurl.com/developer-mozilla-org-array-some}\n *\n * @param {IArrayLike\x3cT\x3e|string} arr Array or array\n *     like object over which to iterate.\n * @param {?function(this:S, T, number, ?) : boolean} f The function to call for\n *     for every element. This function takes 3 arguments (the element, the\n *     index and the array) and should return a boolean.\n * @param {S\x3d} opt_obj  The object to be used as the value of \x27this\x27\n *     within f.\n * @return {boolean} true if any element passes the test.\n * @template T,S\n */\ngoog.array.some \x3d goog.NATIVE_ARRAY_PROTOTYPES \x26\x26\n        (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.some) ?\n    function(arr, f, opt_obj) {\n      goog.asserts.assert(arr.length !\x3d null);\n\n      return Array.prototype.some.call(arr, f, opt_obj);\n    } :\n    function(arr, f, opt_obj) {\n      var l \x3d arr.length;  // must be fixed during loop... see docs\n      var arr2 \x3d goog.isString(arr) ? arr.split(\x27\x27) : arr;\n      for (var i \x3d 0; i \x3c l; i++) {\n        if (i in arr2 \x26\x26 f.call(/** @type {?} */ (opt_obj), arr2[i], i, arr)) {\n          return true;\n        }\n      }\n      return false;\n    };\n\n\n/**\n * Call f for each element of an array. If all calls return true, every()\n * returns true. If any call returns false, every() returns false and\n * does not continue to check the remaining elements.\n *\n * See {@link http://tinyurl.com/developer-mozilla-org-array-every}\n *\n * @param {IArrayLike\x3cT\x3e|string} arr Array or array\n *     like object over which to iterate.\n * @param {?function(this:S, T, number, ?) : boolean} f The function to call for\n *     for every element. This function takes 3 arguments (the element, the\n *     index and the array) and should return a boolean.\n * @param {S\x3d} opt_obj The object to be used as the value of \x27this\x27\n *     within f.\n * @return {boolean} false if any element fails the test.\n * @template T,S\n */\ngoog.array.every \x3d goog.NATIVE_ARRAY_PROTOTYPES \x26\x26\n        (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.every) ?\n    function(arr, f, opt_obj) {\n      goog.asserts.assert(arr.length !\x3d null);\n\n      return Array.prototype.every.call(arr, f, opt_obj);\n    } :\n    function(arr, f, opt_obj) {\n      var l \x3d arr.length;  // must be fixed during loop... see docs\n      var arr2 \x3d goog.isString(arr) ? arr.split(\x27\x27) : arr;\n      for (var i \x3d 0; i \x3c l; i++) {\n        if (i in arr2 \x26\x26 !f.call(/** @type {?} */ (opt_obj), arr2[i], i, arr)) {\n          return false;\n        }\n      }\n      return true;\n    };\n\n\n/**\n * Counts the array elements that fulfill the predicate, i.e. for which the\n * callback function returns true. Skips holes in the array.\n *\n * @param {!IArrayLike\x3cT\x3e|string} arr Array or array like object\n *     over which to iterate.\n * @param {function(this: S, T, number, ?): boolean} f The function to call for\n *     every element. Takes 3 arguments (the element, the index and the array).\n * @param {S\x3d} opt_obj The object to be used as the value of \x27this\x27 within f.\n * @return {number} The number of the matching elements.\n * @template T,S\n */\ngoog.array.count \x3d function(arr, f, opt_obj) {\n  var count \x3d 0;\n  goog.array.forEach(arr, function(element, index, arr) {\n    if (f.call(/** @type {?} */ (opt_obj), element, index, arr)) {\n      ++count;\n    }\n  }, opt_obj);\n  return count;\n};\n\n\n/**\n * Search an array for the first element that satisfies a given condition and\n * return that element.\n * @param {IArrayLike\x3cT\x3e|string} arr Array or array\n *     like object over which to iterate.\n * @param {?function(this:S, T, number, ?) : boolean} f The function to call\n *     for every element. This function takes 3 arguments (the element, the\n *     index and the array) and should return a boolean.\n * @param {S\x3d} opt_obj An optional \x22this\x22 context for the function.\n * @return {T|null} The first array element that passes the test, or null if no\n *     element is found.\n * @template T,S\n */\ngoog.array.find \x3d function(arr, f, opt_obj) {\n  var i \x3d goog.array.findIndex(arr, f, opt_obj);\n  return i \x3c 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i];\n};\n\n\n/**\n * Search an array for the first element that satisfies a given condition and\n * return its index.\n * @param {IArrayLike\x3cT\x3e|string} arr Array or array\n *     like object over which to iterate.\n * @param {?function(this:S, T, number, ?) : boolean} f The function to call for\n *     every element. This function\n *     takes 3 arguments (the element, the index and the array) and should\n *     return a boolean.\n * @param {S\x3d} opt_obj An optional \x22this\x22 context for the function.\n * @return {number} The index of the first array element that passes the test,\n *     or -1 if no element is found.\n * @template T,S\n */\ngoog.array.findIndex \x3d function(arr, f, opt_obj) {\n  var l \x3d arr.length;  // must be fixed during loop... see docs\n  var arr2 \x3d goog.isString(arr) ? arr.split(\x27\x27) : arr;\n  for (var i \x3d 0; i \x3c l; i++) {\n    if (i in arr2 \x26\x26 f.call(/** @type {?} */ (opt_obj), arr2[i], i, arr)) {\n      return i;\n    }\n  }\n  return -1;\n};\n\n\n/**\n * Search an array (in reverse order) for the last element that satisfies a\n * given condition and return that element.\n * @param {IArrayLike\x3cT\x3e|string} arr Array or array\n *     like object over which to iterate.\n * @param {?function(this:S, T, number, ?) : boolean} f The function to call\n *     for every element. This function\n *     takes 3 arguments (the element, the index and the array) and should\n *     return a boolean.\n * @param {S\x3d} opt_obj An optional \x22this\x22 context for the function.\n * @return {T|null} The last array element that passes the test, or null if no\n *     element is found.\n * @template T,S\n */\ngoog.array.findRight \x3d function(arr, f, opt_obj) {\n  var i \x3d goog.array.findIndexRight(arr, f, opt_obj);\n  return i \x3c 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i];\n};\n\n\n/**\n * Search an array (in reverse order) for the last element that satisfies a\n * given condition and return its index.\n * @param {IArrayLike\x3cT\x3e|string} arr Array or array\n *     like object over which to iterate.\n * @param {?function(this:S, T, number, ?) : boolean} f The function to call\n *     for every element. This function\n *     takes 3 arguments (the element, the index and the array) and should\n *     return a boolean.\n * @param {S\x3d} opt_obj An optional \x22this\x22 context for the function.\n * @return {number} The index of the last array element that passes the test,\n *     or -1 if no element is found.\n * @template T,S\n */\ngoog.array.findIndexRight \x3d function(arr, f, opt_obj) {\n  var l \x3d arr.length;  // must be fixed during loop... see docs\n  var arr2 \x3d goog.isString(arr) ? arr.split(\x27\x27) : arr;\n  for (var i \x3d l - 1; i \x3e\x3d 0; i--) {\n    if (i in arr2 \x26\x26 f.call(/** @type {?} */ (opt_obj), arr2[i], i, arr)) {\n      return i;\n    }\n  }\n  return -1;\n};\n\n\n/**\n * Whether the array contains the given object.\n * @param {IArrayLike\x3c?\x3e|string} arr The array to test for the presence of the\n *     element.\n * @param {*} obj The object for which to test.\n * @return {boolean} true if obj is present.\n */\ngoog.array.contains \x3d function(arr, obj) {\n  return goog.array.indexOf(arr, obj) \x3e\x3d 0;\n};\n\n\n/**\n * Whether the array is empty.\n * @param {IArrayLike\x3c?\x3e|string} arr The array to test.\n * @return {boolean} true if empty.\n */\ngoog.array.isEmpty \x3d function(arr) {\n  return arr.length \x3d\x3d 0;\n};\n\n\n/**\n * Clears the array.\n * @param {IArrayLike\x3c?\x3e} arr Array or array like object to clear.\n */\ngoog.array.clear \x3d function(arr) {\n  // For non real arrays we don\x27t have the magic length so we delete the\n  // indices.\n  if (!goog.isArray(arr)) {\n    for (var i \x3d arr.length - 1; i \x3e\x3d 0; i--) {\n      delete arr[i];\n    }\n  }\n  arr.length \x3d 0;\n};\n\n\n/**\n * Pushes an item into an array, if it\x27s not already in the array.\n * @param {Array\x3cT\x3e} arr Array into which to insert the item.\n * @param {T} obj Value to add.\n * @template T\n */\ngoog.array.insert \x3d function(arr, obj) {\n  if (!goog.array.contains(arr, obj)) {\n    arr.push(obj);\n  }\n};\n\n\n/**\n * Inserts an object at the given index of the array.\n * @param {IArrayLike\x3c?\x3e} arr The array to modify.\n * @param {*} obj The object to insert.\n * @param {number\x3d} opt_i The index at which to insert the object. If omitted,\n *      treated as 0. A negative index is counted from the end of the array.\n */\ngoog.array.insertAt \x3d function(arr, obj, opt_i) {\n  goog.array.splice(arr, opt_i, 0, obj);\n};\n\n\n/**\n * Inserts at the given index of the array, all elements of another array.\n * @param {IArrayLike\x3c?\x3e} arr The array to modify.\n * @param {IArrayLike\x3c?\x3e} elementsToAdd The array of elements to add.\n * @param {number\x3d} opt_i The index at which to insert the object. If omitted,\n *      treated as 0. A negative index is counted from the end of the array.\n */\ngoog.array.insertArrayAt \x3d function(arr, elementsToAdd, opt_i) {\n  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd);\n};\n\n\n/**\n * Inserts an object into an array before a specified object.\n * @param {Array\x3cT\x3e} arr The array to modify.\n * @param {T} obj The object to insert.\n * @param {T\x3d} opt_obj2 The object before which obj should be inserted. If obj2\n *     is omitted or not found, obj is inserted at the end of the array.\n * @template T\n */\ngoog.array.insertBefore \x3d function(arr, obj, opt_obj2) {\n  var i;\n  if (arguments.length \x3d\x3d 2 || (i \x3d goog.array.indexOf(arr, opt_obj2)) \x3c 0) {\n    arr.push(obj);\n  } else {\n    goog.array.insertAt(arr, obj, i);\n  }\n};\n\n\n/**\n * Removes the first occurrence of a particular value from an array.\n * @param {IArrayLike\x3cT\x3e} arr Array from which to remove\n *     value.\n * @param {T} obj Object to remove.\n * @return {boolean} True if an element was removed.\n * @template T\n */\ngoog.array.remove \x3d function(arr, obj) {\n  var i \x3d goog.array.indexOf(arr, obj);\n  var rv;\n  if ((rv \x3d i \x3e\x3d 0)) {\n    goog.array.removeAt(arr, i);\n  }\n  return rv;\n};\n\n\n/**\n * Removes the last occurrence of a particular value from an array.\n * @param {!IArrayLike\x3cT\x3e} arr Array from which to remove value.\n * @param {T} obj Object to remove.\n * @return {boolean} True if an element was removed.\n * @template T\n */\ngoog.array.removeLast \x3d function(arr, obj) {\n  var i \x3d goog.array.lastIndexOf(arr, obj);\n  if (i \x3e\x3d 0) {\n    goog.array.removeAt(arr, i);\n    return true;\n  }\n  return false;\n};\n\n\n/**\n * Removes from an array the element at index i\n * @param {IArrayLike\x3c?\x3e} arr Array or array like object from which to\n *     remove value.\n * @param {number} i The index to remove.\n * @return {boolean} True if an element was removed.\n */\ngoog.array.removeAt \x3d function(arr, i) {\n  goog.asserts.assert(arr.length !\x3d null);\n\n  // use generic form of splice\n  // splice returns the removed items and if successful the length of that\n  // will be 1\n  return Array.prototype.splice.call(arr, i, 1).length \x3d\x3d 1;\n};\n\n\n/**\n * Removes the first value that satisfies the given condition.\n * @param {IArrayLike\x3cT\x3e} arr Array or array\n *     like object over which to iterate.\n * @param {?function(this:S, T, number, ?) : boolean} f The function to call\n *     for every element. This function\n *     takes 3 arguments (the element, the index and the array) and should\n *     return a boolean.\n * @param {S\x3d} opt_obj An optional \x22this\x22 context for the function.\n * @return {boolean} True if an element was removed.\n * @template T,S\n */\ngoog.array.removeIf \x3d function(arr, f, opt_obj) {\n  var i \x3d goog.array.findIndex(arr, f, opt_obj);\n  if (i \x3e\x3d 0) {\n    goog.array.removeAt(arr, i);\n    return true;\n  }\n  return false;\n};\n\n\n/**\n * Removes all values that satisfy the given condition.\n * @param {IArrayLike\x3cT\x3e} arr Array or array\n *     like object over which to iterate.\n * @param {?function(this:S, T, number, ?) : boolean} f The function to call\n *     for every element. This function\n *     takes 3 arguments (the element, the index and the array) and should\n *     return a boolean.\n * @param {S\x3d} opt_obj An optional \x22this\x22 context for the function.\n * @return {number} The number of items removed\n * @template T,S\n */\ngoog.array.removeAllIf \x3d function(arr, f, opt_obj) {\n  var removedCount \x3d 0;\n  goog.array.forEachRight(arr, function(val, index) {\n    if (f.call(/** @type {?} */ (opt_obj), val, index, arr)) {\n      if (goog.array.removeAt(arr, index)) {\n        removedCount++;\n      }\n    }\n  });\n  return removedCount;\n};\n\n\n/**\n * Returns a new array that is the result of joining the arguments.  If arrays\n * are passed then their items are added, however, if non-arrays are passed they\n * will be added to the return array as is.\n *\n * Note that ArrayLike objects will be added as is, rather than having their\n * items added.\n *\n * goog.array.concat([1, 2], [3, 4]) -\x3e [1, 2, 3, 4]\n * goog.array.concat(0, [1, 2]) -\x3e [0, 1, 2]\n * goog.array.concat([1, 2], null) -\x3e [1, 2, null]\n *\n * There is bug in all current versions of IE (6, 7 and 8) where arrays created\n * in an iframe become corrupted soon (not immediately) after the iframe is\n * destroyed. This is common if loading data via goog.net.IframeIo, for example.\n * This corruption only affects the concat method which will start throwing\n * Catastrophic Errors (#-2147418113).\n *\n * See http://endoflow.com/scratch/corrupted-arrays.html for a test case.\n *\n * Internally goog.array should use this, so that all methods will continue to\n * work on these broken array objects.\n *\n * @param {...*} var_args Items to concatenate.  Arrays will have each item\n *     added, while primitives and objects will be added as is.\n * @return {!Array\x3c?\x3e} The new resultant array.\n */\ngoog.array.concat \x3d function(var_args) {\n  return Array.prototype.concat.apply([], arguments);\n};\n\n\n/**\n * Returns a new array that contains the contents of all the arrays passed.\n * @param {...!Array\x3cT\x3e} var_args\n * @return {!Array\x3cT\x3e}\n * @template T\n */\ngoog.array.join \x3d function(var_args) {\n  return Array.prototype.concat.apply([], arguments);\n};\n\n\n/**\n * Converts an object to an array.\n * @param {IArrayLike\x3cT\x3e|string} object  The object to convert to an\n *     array.\n * @return {!Array\x3cT\x3e} The object converted into an array. If object has a\n *     length property, every property indexed with a non-negative number\n *     less than length will be included in the result. If object does not\n *     have a length property, an empty array will be returned.\n * @template T\n */\ngoog.array.toArray \x3d function(object) {\n  var length \x3d object.length;\n\n  // If length is not a number the following it false. This case is kept for\n  // backwards compatibility since there are callers that pass objects that are\n  // not array like.\n  if (length \x3e 0) {\n    var rv \x3d new Array(length);\n    for (var i \x3d 0; i \x3c length; i++) {\n      rv[i] \x3d object[i];\n    }\n    return rv;\n  }\n  return [];\n};\n\n\n/**\n * Does a shallow copy of an array.\n * @param {IArrayLike\x3cT\x3e|string} arr  Array or array-like object to\n *     clone.\n * @return {!Array\x3cT\x3e} Clone of the input array.\n * @template T\n */\ngoog.array.clone \x3d goog.array.toArray;\n\n\n/**\n * Extends an array with another array, element, or \x22array like\x22 object.\n * This function operates \x27in-place\x27, it does not create a new Array.\n *\n * Example:\n * var a \x3d [];\n * goog.array.extend(a, [0, 1]);\n * a; // [0, 1]\n * goog.array.extend(a, 2);\n * a; // [0, 1, 2]\n *\n * @param {Array\x3cVALUE\x3e} arr1  The array to modify.\n * @param {...(Array\x3cVALUE\x3e|VALUE)} var_args The elements or arrays of elements\n *     to add to arr1.\n * @template VALUE\n */\ngoog.array.extend \x3d function(arr1, var_args) {\n  for (var i \x3d 1; i \x3c arguments.length; i++) {\n    var arr2 \x3d arguments[i];\n    if (goog.isArrayLike(arr2)) {\n      var len1 \x3d arr1.length || 0;\n      var len2 \x3d arr2.length || 0;\n      arr1.length \x3d len1 + len2;\n      for (var j \x3d 0; j \x3c len2; j++) {\n        arr1[len1 + j] \x3d arr2[j];\n      }\n    } else {\n      arr1.push(arr2);\n    }\n  }\n};\n\n\n/**\n * Adds or removes elements from an array. This is a generic version of Array\n * splice. This means that it might work on other objects similar to arrays,\n * such as the arguments object.\n *\n * @param {IArrayLike\x3cT\x3e} arr The array to modify.\n * @param {number|undefined} index The index at which to start changing the\n *     array. If not defined, treated as 0.\n * @param {number} howMany How many elements to remove (0 means no removal. A\n *     value below 0 is treated as zero and so is any other non number. Numbers\n *     are floored).\n * @param {...T} var_args Optional, additional elements to insert into the\n *     array.\n * @return {!Array\x3cT\x3e} the removed elements.\n * @template T\n */\ngoog.array.splice \x3d function(arr, index, howMany, var_args) {\n  goog.asserts.assert(arr.length !\x3d null);\n\n  return Array.prototype.splice.apply(arr, goog.array.slice(arguments, 1));\n};\n\n\n/**\n * Returns a new array from a segment of an array. This is a generic version of\n * Array slice. This means that it might work on other objects similar to\n * arrays, such as the arguments object.\n *\n * @param {IArrayLike\x3cT\x3e|string} arr The array from\n * which to copy a segment.\n * @param {number} start The index of the first element to copy.\n * @param {number\x3d} opt_end The index after the last element to copy.\n * @return {!Array\x3cT\x3e} A new array containing the specified segment of the\n *     original array.\n * @template T\n */\ngoog.array.slice \x3d function(arr, start, opt_end) {\n  goog.asserts.assert(arr.length !\x3d null);\n\n  // passing 1 arg to slice is not the same as passing 2 where the second is\n  // null or undefined (in that case the second argument is treated as 0).\n  // we could use slice on the arguments object and then use apply instead of\n  // testing the length\n  if (arguments.length \x3c\x3d 2) {\n    return Array.prototype.slice.call(arr, start);\n  } else {\n    return Array.prototype.slice.call(arr, start, opt_end);\n  }\n};\n\n\n/**\n * Removes all duplicates from an array (retaining only the first\n * occurrence of each array element).  This function modifies the\n * array in place and doesn\x27t change the order of the non-duplicate items.\n *\n * For objects, duplicates are identified as having the same unique ID as\n * defined by {@link goog.getUid}.\n *\n * Alternatively you can specify a custom hash function that returns a unique\n * value for each item in the array it should consider unique.\n *\n * Runtime: N,\n * Worstcase space: 2N (no dupes)\n *\n * @param {IArrayLike\x3cT\x3e} arr The array from which to remove\n *     duplicates.\n * @param {Array\x3d} opt_rv An optional array in which to return the results,\n *     instead of performing the removal inplace.  If specified, the original\n *     array will remain unchanged.\n * @param {function(T):string\x3d} opt_hashFn An optional function to use to\n *     apply to every item in the array. This function should return a unique\n *     value for each item in the array it should consider unique.\n * @template T\n */\ngoog.array.removeDuplicates \x3d function(arr, opt_rv, opt_hashFn) {\n  var returnArray \x3d opt_rv || arr;\n  var defaultHashFn \x3d function(item) {\n    // Prefix each type with a single character representing the type to\n    // prevent conflicting keys (e.g. true and \x27true\x27).\n    return goog.isObject(item) ? \x27o\x27 + goog.getUid(item) :\n                                 (typeof item).charAt(0) + item;\n  };\n  var hashFn \x3d opt_hashFn || defaultHashFn;\n\n  var seen \x3d {}, cursorInsert \x3d 0, cursorRead \x3d 0;\n  while (cursorRead \x3c arr.length) {\n    var current \x3d arr[cursorRead++];\n    var key \x3d hashFn(current);\n    if (!Object.prototype.hasOwnProperty.call(seen, key)) {\n      seen[key] \x3d true;\n      returnArray[cursorInsert++] \x3d current;\n    }\n  }\n  returnArray.length \x3d cursorInsert;\n};\n\n\n/**\n * Searches the specified array for the specified target using the binary\n * search algorithm.  If no opt_compareFn is specified, elements are compared\n * using \x3ccode\x3egoog.array.defaultCompare\x3c/code\x3e, which compares the elements\n * using the built in \x3c and \x3e operators.  This will produce the expected\n * behavior for homogeneous arrays of String(s) and Number(s). The array\n * specified \x3cb\x3emust\x3c/b\x3e be sorted in ascending order (as defined by the\n * comparison function).  If the array is not sorted, results are undefined.\n * If the array contains multiple instances of the specified target value, any\n * of these instances may be found.\n *\n * Runtime: O(log n)\n *\n * @param {IArrayLike\x3cVALUE\x3e} arr The array to be searched.\n * @param {TARGET} target The sought value.\n * @param {function(TARGET, VALUE): number\x3d} opt_compareFn Optional comparison\n *     function by which the array is ordered. Should take 2 arguments to\n *     compare, and return a negative number, zero, or a positive number\n *     depending on whether the first argument is less than, equal to, or\n *     greater than the second.\n * @return {number} Lowest index of the target value if found, otherwise\n *     (-(insertion point) - 1). The insertion point is where the value should\n *     be inserted into arr to preserve the sorted property.  Return value \x3e\x3d 0\n *     iff target is found.\n * @template TARGET, VALUE\n */\ngoog.array.binarySearch \x3d function(arr, target, opt_compareFn) {\n  return goog.array.binarySearch_(\n      arr, opt_compareFn || goog.array.defaultCompare, false /* isEvaluator */,\n      target);\n};\n\n\n/**\n * Selects an index in the specified array using the binary search algorithm.\n * The evaluator receives an element and determines whether the desired index\n * is before, at, or after it.  The evaluator must be consistent (formally,\n * goog.array.map(goog.array.map(arr, evaluator, opt_obj), goog.math.sign)\n * must be monotonically non-increasing).\n *\n * Runtime: O(log n)\n *\n * @param {IArrayLike\x3cVALUE\x3e} arr The array to be searched.\n * @param {function(this:THIS, VALUE, number, ?): number} evaluator\n *     Evaluator function that receives 3 arguments (the element, the index and\n *     the array). Should return a negative number, zero, or a positive number\n *     depending on whether the desired index is before, at, or after the\n *     element passed to it.\n * @param {THIS\x3d} opt_obj The object to be used as the value of \x27this\x27\n *     within evaluator.\n * @return {number} Index of the leftmost element matched by the evaluator, if\n *     such exists; otherwise (-(insertion point) - 1). The insertion point is\n *     the index of the first element for which the evaluator returns negative,\n *     or arr.length if no such element exists. The return value is non-negative\n *     iff a match is found.\n * @template THIS, VALUE\n */\ngoog.array.binarySelect \x3d function(arr, evaluator, opt_obj) {\n  return goog.array.binarySearch_(\n      arr, evaluator, true /* isEvaluator */, undefined /* opt_target */,\n      opt_obj);\n};\n\n\n/**\n * Implementation of a binary search algorithm which knows how to use both\n * comparison functions and evaluators. If an evaluator is provided, will call\n * the evaluator with the given optional data object, conforming to the\n * interface defined in binarySelect. Otherwise, if a comparison function is\n * provided, will call the comparison function against the given data object.\n *\n * This implementation purposefully does not use goog.bind or goog.partial for\n * performance reasons.\n *\n * Runtime: O(log n)\n *\n * @param {IArrayLike\x3c?\x3e} arr The array to be searched.\n * @param {function(?, ?, ?): number | function(?, ?): number} compareFn\n *     Either an evaluator or a comparison function, as defined by binarySearch\n *     and binarySelect above.\n * @param {boolean} isEvaluator Whether the function is an evaluator or a\n *     comparison function.\n * @param {?\x3d} opt_target If the function is a comparison function, then\n *     this is the target to binary search for.\n * @param {Object\x3d} opt_selfObj If the function is an evaluator, this is an\n *     optional this object for the evaluator.\n * @return {number} Lowest index of the target value if found, otherwise\n *     (-(insertion point) - 1). The insertion point is where the value should\n *     be inserted into arr to preserve the sorted property.  Return value \x3e\x3d 0\n *     iff target is found.\n * @private\n */\ngoog.array.binarySearch_ \x3d function(\n    arr, compareFn, isEvaluator, opt_target, opt_selfObj) {\n  var left \x3d 0;            // inclusive\n  var right \x3d arr.length;  // exclusive\n  var found;\n  while (left \x3c right) {\n    var middle \x3d (left + right) \x3e\x3e 1;\n    var compareResult;\n    if (isEvaluator) {\n      compareResult \x3d compareFn.call(opt_selfObj, arr[middle], middle, arr);\n    } else {\n      // NOTE(dimvar): To avoid this cast, we\x27d have to use function overloading\n      // for the type of binarySearch_, which the type system can\x27t express yet.\n      compareResult \x3d /** @type {function(?, ?): number} */ (compareFn)(\n          opt_target, arr[middle]);\n    }\n    if (compareResult \x3e 0) {\n      left \x3d middle + 1;\n    } else {\n      right \x3d middle;\n      // We are looking for the lowest index so we can\x27t return immediately.\n      found \x3d !compareResult;\n    }\n  }\n  // left is the index if found, or the insertion point otherwise.\n  // ~left is a shorthand for -left - 1.\n  return found ? left : ~left;\n};\n\n\n/**\n * Sorts the specified array into ascending order.  If no opt_compareFn is\n * specified, elements are compared using\n * \x3ccode\x3egoog.array.defaultCompare\x3c/code\x3e, which compares the elements using\n * the built in \x3c and \x3e operators.  This will produce the expected behavior\n * for homogeneous arrays of String(s) and Number(s), unlike the native sort,\n * but will give unpredictable results for heterogeneous lists of strings and\n * numbers with different numbers of digits.\n *\n * This sort is not guaranteed to be stable.\n *\n * Runtime: Same as \x3ccode\x3eArray.prototype.sort\x3c/code\x3e\n *\n * @param {Array\x3cT\x3e} arr The array to be sorted.\n * @param {?function(T,T):number\x3d} opt_compareFn Optional comparison\n *     function by which the\n *     array is to be ordered. Should take 2 arguments to compare, and return a\n *     negative number, zero, or a positive number depending on whether the\n *     first argument is less than, equal to, or greater than the second.\n * @template T\n */\ngoog.array.sort \x3d function(arr, opt_compareFn) {\n  // TODO(arv): Update type annotation since null is not accepted.\n  arr.sort(opt_compareFn || goog.array.defaultCompare);\n};\n\n\n/**\n * Sorts the specified array into ascending order in a stable way.  If no\n * opt_compareFn is specified, elements are compared using\n * \x3ccode\x3egoog.array.defaultCompare\x3c/code\x3e, which compares the elements using\n * the built in \x3c and \x3e operators.  This will produce the expected behavior\n * for homogeneous arrays of String(s) and Number(s).\n *\n * Runtime: Same as \x3ccode\x3eArray.prototype.sort\x3c/code\x3e, plus an additional\n * O(n) overhead of copying the array twice.\n *\n * @param {Array\x3cT\x3e} arr The array to be sorted.\n * @param {?function(T, T): number\x3d} opt_compareFn Optional comparison function\n *     by which the array is to be ordered. Should take 2 arguments to compare,\n *     and return a negative number, zero, or a positive number depending on\n *     whether the first argument is less than, equal to, or greater than the\n *     second.\n * @template T\n */\ngoog.array.stableSort \x3d function(arr, opt_compareFn) {\n  var compArr \x3d new Array(arr.length);\n  for (var i \x3d 0; i \x3c arr.length; i++) {\n    compArr[i] \x3d {index: i, value: arr[i]};\n  }\n  var valueCompareFn \x3d opt_compareFn || goog.array.defaultCompare;\n  function stableCompareFn(obj1, obj2) {\n    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index;\n  }\n  goog.array.sort(compArr, stableCompareFn);\n  for (var i \x3d 0; i \x3c arr.length; i++) {\n    arr[i] \x3d compArr[i].value;\n  }\n};\n\n\n/**\n * Sort the specified array into ascending order based on item keys\n * returned by the specified key function.\n * If no opt_compareFn is specified, the keys are compared in ascending order\n * using \x3ccode\x3egoog.array.defaultCompare\x3c/code\x3e.\n *\n * Runtime: O(S(f(n)), where S is runtime of \x3ccode\x3egoog.array.sort\x3c/code\x3e\n * and f(n) is runtime of the key function.\n *\n * @param {Array\x3cT\x3e} arr The array to be sorted.\n * @param {function(T): K} keyFn Function taking array element and returning\n *     a key used for sorting this element.\n * @param {?function(K, K): number\x3d} opt_compareFn Optional comparison function\n *     by which the keys are to be ordered. Should take 2 arguments to compare,\n *     and return a negative number, zero, or a positive number depending on\n *     whether the first argument is less than, equal to, or greater than the\n *     second.\n * @template T,K\n */\ngoog.array.sortByKey \x3d function(arr, keyFn, opt_compareFn) {\n  var keyCompareFn \x3d opt_compareFn || goog.array.defaultCompare;\n  goog.array.sort(\n      arr, function(a, b) { return keyCompareFn(keyFn(a), keyFn(b)); });\n};\n\n\n/**\n * Sorts an array of objects by the specified object key and compare\n * function. If no compare function is provided, the key values are\n * compared in ascending order using \x3ccode\x3egoog.array.defaultCompare\x3c/code\x3e.\n * This won\x27t work for keys that get renamed by the compiler. So use\n * {\x27foo\x27: 1, \x27bar\x27: 2} rather than {foo: 1, bar: 2}.\n * @param {Array\x3cObject\x3e} arr An array of objects to sort.\n * @param {string} key The object key to sort by.\n * @param {Function\x3d} opt_compareFn The function to use to compare key\n *     values.\n */\ngoog.array.sortObjectsByKey \x3d function(arr, key, opt_compareFn) {\n  goog.array.sortByKey(arr, function(obj) { return obj[key]; }, opt_compareFn);\n};\n\n\n/**\n * Tells if the array is sorted.\n * @param {!Array\x3cT\x3e} arr The array.\n * @param {?function(T,T):number\x3d} opt_compareFn Function to compare the\n *     array elements.\n *     Should take 2 arguments to compare, and return a negative number, zero,\n *     or a positive number depending on whether the first argument is less\n *     than, equal to, or greater than the second.\n * @param {boolean\x3d} opt_strict If true no equal elements are allowed.\n * @return {boolean} Whether the array is sorted.\n * @template T\n */\ngoog.array.isSorted \x3d function(arr, opt_compareFn, opt_strict) {\n  var compare \x3d opt_compareFn || goog.array.defaultCompare;\n  for (var i \x3d 1; i \x3c arr.length; i++) {\n    var compareResult \x3d compare(arr[i - 1], arr[i]);\n    if (compareResult \x3e 0 || compareResult \x3d\x3d 0 \x26\x26 opt_strict) {\n      return false;\n    }\n  }\n  return true;\n};\n\n\n/**\n * Compares two arrays for equality. Two arrays are considered equal if they\n * have the same length and their corresponding elements are equal according to\n * the comparison function.\n *\n * @param {IArrayLike\x3c?\x3e} arr1 The first array to compare.\n * @param {IArrayLike\x3c?\x3e} arr2 The second array to compare.\n * @param {Function\x3d} opt_equalsFn Optional comparison function.\n *     Should take 2 arguments to compare, and return true if the arguments\n *     are equal. Defaults to {@link goog.array.defaultCompareEquality} which\n *     compares the elements using the built-in \x27\x3d\x3d\x3d\x27 operator.\n * @return {boolean} Whether the two arrays are equal.\n */\ngoog.array.equals \x3d function(arr1, arr2, opt_equalsFn) {\n  if (!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) ||\n      arr1.length !\x3d arr2.length) {\n    return false;\n  }\n  var l \x3d arr1.length;\n  var equalsFn \x3d opt_equalsFn || goog.array.defaultCompareEquality;\n  for (var i \x3d 0; i \x3c l; i++) {\n    if (!equalsFn(arr1[i], arr2[i])) {\n      return false;\n    }\n  }\n  return true;\n};\n\n\n/**\n * 3-way array compare function.\n * @param {!IArrayLike\x3cVALUE\x3e} arr1 The first array to\n *     compare.\n * @param {!IArrayLike\x3cVALUE\x3e} arr2 The second array to\n *     compare.\n * @param {function(VALUE, VALUE): number\x3d} opt_compareFn Optional comparison\n *     function by which the array is to be ordered. Should take 2 arguments to\n *     compare, and return a negative number, zero, or a positive number\n *     depending on whether the first argument is less than, equal to, or\n *     greater than the second.\n * @return {number} Negative number, zero, or a positive number depending on\n *     whether the first argument is less than, equal to, or greater than the\n *     second.\n * @template VALUE\n */\ngoog.array.compare3 \x3d function(arr1, arr2, opt_compareFn) {\n  var compare \x3d opt_compareFn || goog.array.defaultCompare;\n  var l \x3d Math.min(arr1.length, arr2.length);\n  for (var i \x3d 0; i \x3c l; i++) {\n    var result \x3d compare(arr1[i], arr2[i]);\n    if (result !\x3d 0) {\n      return result;\n    }\n  }\n  return goog.array.defaultCompare(arr1.length, arr2.length);\n};\n\n\n/**\n * Compares its two arguments for order, using the built in \x3c and \x3e\n * operators.\n * @param {VALUE} a The first object to be compared.\n * @param {VALUE} b The second object to be compared.\n * @return {number} A negative number, zero, or a positive number as the first\n *     argument is less than, equal to, or greater than the second,\n *     respectively.\n * @template VALUE\n */\ngoog.array.defaultCompare \x3d function(a, b) {\n  return a \x3e b ? 1 : a \x3c b ? -1 : 0;\n};\n\n\n/**\n * Compares its two arguments for inverse order, using the built in \x3c and \x3e\n * operators.\n * @param {VALUE} a The first object to be compared.\n * @param {VALUE} b The second object to be compared.\n * @return {number} A negative number, zero, or a positive number as the first\n *     argument is greater than, equal to, or less than the second,\n *     respectively.\n * @template VALUE\n */\ngoog.array.inverseDefaultCompare \x3d function(a, b) {\n  return -goog.array.defaultCompare(a, b);\n};\n\n\n/**\n * Compares its two arguments for equality, using the built in \x3d\x3d\x3d operator.\n * @param {*} a The first object to compare.\n * @param {*} b The second object to compare.\n * @return {boolean} True if the two arguments are equal, false otherwise.\n */\ngoog.array.defaultCompareEquality \x3d function(a, b) {\n  return a \x3d\x3d\x3d b;\n};\n\n\n/**\n * Inserts a value into a sorted array. The array is not modified if the\n * value is already present.\n * @param {IArrayLike\x3cVALUE\x3e} array The array to modify.\n * @param {VALUE} value The object to insert.\n * @param {function(VALUE, VALUE): number\x3d} opt_compareFn Optional comparison\n *     function by which the array is ordered. Should take 2 arguments to\n *     compare, and return a negative number, zero, or a positive number\n *     depending on whether the first argument is less than, equal to, or\n *     greater than the second.\n * @return {boolean} True if an element was inserted.\n * @template VALUE\n */\ngoog.array.binaryInsert \x3d function(array, value, opt_compareFn) {\n  var index \x3d goog.array.binarySearch(array, value, opt_compareFn);\n  if (index \x3c 0) {\n    goog.array.insertAt(array, value, -(index + 1));\n    return true;\n  }\n  return false;\n};\n\n\n/**\n * Removes a value from a sorted array.\n * @param {!IArrayLike\x3cVALUE\x3e} array The array to modify.\n * @param {VALUE} value The object to remove.\n * @param {function(VALUE, VALUE): number\x3d} opt_compareFn Optional comparison\n *     function by which the array is ordered. Should take 2 arguments to\n *     compare, and return a negative number, zero, or a positive number\n *     depending on whether the first argument is less than, equal to, or\n *     greater than the second.\n * @return {boolean} True if an element was removed.\n * @template VALUE\n */\ngoog.array.binaryRemove \x3d function(array, value, opt_compareFn) {\n  var index \x3d goog.array.binarySearch(array, value, opt_compareFn);\n  return (index \x3e\x3d 0) ? goog.array.removeAt(array, index) : false;\n};\n\n\n/**\n * Splits an array into disjoint buckets according to a splitting function.\n * @param {Array\x3cT\x3e} array The array.\n * @param {function(this:S, T, number, !Array\x3cT\x3e):?} sorter Function to call for\n *     every element.  This takes 3 arguments (the element, the index and the\n *     array) and must return a valid object key (a string, number, etc), or\n *     undefined, if that object should not be placed in a bucket.\n * @param {S\x3d} opt_obj The object to be used as the value of \x27this\x27 within\n *     sorter.\n * @return {!Object\x3c!Array\x3cT\x3e\x3e} An object, with keys being all of the unique\n *     return values of sorter, and values being arrays containing the items for\n *     which the splitter returned that key.\n * @template T,S\n */\ngoog.array.bucket \x3d function(array, sorter, opt_obj) {\n  var buckets \x3d {};\n\n  for (var i \x3d 0; i \x3c array.length; i++) {\n    var value \x3d array[i];\n    var key \x3d sorter.call(/** @type {?} */ (opt_obj), value, i, array);\n    if (goog.isDef(key)) {\n      // Push the value to the right bucket, creating it if necessary.\n      var bucket \x3d buckets[key] || (buckets[key] \x3d []);\n      bucket.push(value);\n    }\n  }\n\n  return buckets;\n};\n\n\n/**\n * Creates a new object built from the provided array and the key-generation\n * function.\n * @param {IArrayLike\x3cT\x3e} arr Array or array like object over\n *     which to iterate whose elements will be the values in the new object.\n * @param {?function(this:S, T, number, ?) : string} keyFunc The function to\n *     call for every element. This function takes 3 arguments (the element, the\n *     index and the array) and should return a string that will be used as the\n *     key for the element in the new object. If the function returns the same\n *     key for more than one element, the value for that key is\n *     implementation-defined.\n * @param {S\x3d} opt_obj The object to be used as the value of \x27this\x27\n *     within keyFunc.\n * @return {!Object\x3cT\x3e} The new object.\n * @template T,S\n */\ngoog.array.toObject \x3d function(arr, keyFunc, opt_obj) {\n  var ret \x3d {};\n  goog.array.forEach(arr, function(element, index) {\n    ret[keyFunc.call(/** @type {?} */ (opt_obj), element, index, arr)] \x3d\n        element;\n  });\n  return ret;\n};\n\n\n/**\n * Creates a range of numbers in an arithmetic progression.\n *\n * Range takes 1, 2, or 3 arguments:\n * \x3cpre\x3e\n * range(5) is the same as range(0, 5, 1) and produces [0, 1, 2, 3, 4]\n * range(2, 5) is the same as range(2, 5, 1) and produces [2, 3, 4]\n * range(-2, -5, -1) produces [-2, -3, -4]\n * range(-2, -5, 1) produces [], since stepping by 1 wouldn\x27t ever reach -5.\n * \x3c/pre\x3e\n *\n * @param {number} startOrEnd The starting value of the range if an end argument\n *     is provided. Otherwise, the start value is 0, and this is the end value.\n * @param {number\x3d} opt_end The optional end value of the range.\n * @param {number\x3d} opt_step The step size between range values. Defaults to 1\n *     if opt_step is undefined or 0.\n * @return {!Array\x3cnumber\x3e} An array of numbers for the requested range. May be\n *     an empty array if adding the step would not converge toward the end\n *     value.\n */\ngoog.array.range \x3d function(startOrEnd, opt_end, opt_step) {\n  var array \x3d [];\n  var start \x3d 0;\n  var end \x3d startOrEnd;\n  var step \x3d opt_step || 1;\n  if (opt_end !\x3d\x3d undefined) {\n    start \x3d startOrEnd;\n    end \x3d opt_end;\n  }\n\n  if (step * (end - start) \x3c 0) {\n    // Sign mismatch: start + step will never reach the end value.\n    return [];\n  }\n\n  if (step \x3e 0) {\n    for (var i \x3d start; i \x3c end; i +\x3d step) {\n      array.push(i);\n    }\n  } else {\n    for (var i \x3d start; i \x3e end; i +\x3d step) {\n      array.push(i);\n    }\n  }\n  return array;\n};\n\n\n/**\n * Returns an array consisting of the given value repeated N times.\n *\n * @param {VALUE} value The value to repeat.\n * @param {number} n The repeat count.\n * @return {!Array\x3cVALUE\x3e} An array with the repeated value.\n * @template VALUE\n */\ngoog.array.repeat \x3d function(value, n) {\n  var array \x3d [];\n  for (var i \x3d 0; i \x3c n; i++) {\n    array[i] \x3d value;\n  }\n  return array;\n};\n\n\n/**\n * Returns an array consisting of every argument with all arrays\n * expanded in-place recursively.\n *\n * @param {...*} var_args The values to flatten.\n * @return {!Array\x3c?\x3e} An array containing the flattened values.\n */\ngoog.array.flatten \x3d function(var_args) {\n  var CHUNK_SIZE \x3d 8192;\n\n  var result \x3d [];\n  for (var i \x3d 0; i \x3c arguments.length; i++) {\n    var element \x3d arguments[i];\n    if (goog.isArray(element)) {\n      for (var c \x3d 0; c \x3c element.length; c +\x3d CHUNK_SIZE) {\n        var chunk \x3d goog.array.slice(element, c, c + CHUNK_SIZE);\n        var recurseResult \x3d goog.array.flatten.apply(null, chunk);\n        for (var r \x3d 0; r \x3c recurseResult.length; r++) {\n          result.push(recurseResult[r]);\n        }\n      }\n    } else {\n      result.push(element);\n    }\n  }\n  return result;\n};\n\n\n/**\n * Rotates an array in-place. After calling this method, the element at\n * index i will be the element previously at index (i - n) %\n * array.length, for all values of i between 0 and array.length - 1,\n * inclusive.\n *\n * For example, suppose list comprises [t, a, n, k, s]. After invoking\n * rotate(array, 1) (or rotate(array, -4)), array will comprise [s, t, a, n, k].\n *\n * @param {!Array\x3cT\x3e} array The array to rotate.\n * @param {number} n The amount to rotate.\n * @return {!Array\x3cT\x3e} The array.\n * @template T\n */\ngoog.array.rotate \x3d function(array, n) {\n  goog.asserts.assert(array.length !\x3d null);\n\n  if (array.length) {\n    n %\x3d array.length;\n    if (n \x3e 0) {\n      Array.prototype.unshift.apply(array, array.splice(-n, n));\n    } else if (n \x3c 0) {\n      Array.prototype.push.apply(array, array.splice(0, -n));\n    }\n  }\n  return array;\n};\n\n\n/**\n * Moves one item of an array to a new position keeping the order of the rest\n * of the items. Example use case: keeping a list of JavaScript objects\n * synchronized with the corresponding list of DOM elements after one of the\n * elements has been dragged to a new position.\n * @param {!IArrayLike\x3c?\x3e} arr The array to modify.\n * @param {number} fromIndex Index of the item to move between 0 and\n *     {@code arr.length - 1}.\n * @param {number} toIndex Target index between 0 and {@code arr.length - 1}.\n */\ngoog.array.moveItem \x3d function(arr, fromIndex, toIndex) {\n  goog.asserts.assert(fromIndex \x3e\x3d 0 \x26\x26 fromIndex \x3c arr.length);\n  goog.asserts.assert(toIndex \x3e\x3d 0 \x26\x26 toIndex \x3c arr.length);\n  // Remove 1 item at fromIndex.\n  var removedItems \x3d Array.prototype.splice.call(arr, fromIndex, 1);\n  // Insert the removed item at toIndex.\n  Array.prototype.splice.call(arr, toIndex, 0, removedItems[0]);\n  // We don\x27t use goog.array.insertAt and goog.array.removeAt, because they\x27re\n  // significantly slower than splice.\n};\n\n\n/**\n * Creates a new array for which the element at position i is an array of the\n * ith element of the provided arrays.  The returned array will only be as long\n * as the shortest array provided; additional values are ignored.  For example,\n * the result of zipping [1, 2] and [3, 4, 5] is [[1,3], [2, 4]].\n *\n * This is similar to the zip() function in Python.  See {@link\n * http://docs.python.org/library/functions.html#zip}\n *\n * @param {...!IArrayLike\x3c?\x3e} var_args Arrays to be combined.\n * @return {!Array\x3c!Array\x3c?\x3e\x3e} A new array of arrays created from\n *     provided arrays.\n */\ngoog.array.zip \x3d function(var_args) {\n  if (!arguments.length) {\n    return [];\n  }\n  var result \x3d [];\n  var minLen \x3d arguments[0].length;\n  for (var i \x3d 1; i \x3c arguments.length; i++) {\n    if (arguments[i].length \x3c minLen) {\n      minLen \x3d arguments[i].length;\n    }\n  }\n  for (var i \x3d 0; i \x3c minLen; i++) {\n    var value \x3d [];\n    for (var j \x3d 0; j \x3c arguments.length; j++) {\n      value.push(arguments[j][i]);\n    }\n    result.push(value);\n  }\n  return result;\n};\n\n\n/**\n * Shuffles the values in the specified array using the Fisher-Yates in-place\n * shuffle (also known as the Knuth Shuffle). By default, calls Math.random()\n * and so resets the state of that random number generator. Similarly, may reset\n * the state of the any other specified random number generator.\n *\n * Runtime: O(n)\n *\n * @param {!Array\x3c?\x3e} arr The array to be shuffled.\n * @param {function():number\x3d} opt_randFn Optional random function to use for\n *     shuffling.\n *     Takes no arguments, and returns a random number on the interval [0, 1).\n *     Defaults to Math.random() using JavaScript\x27s built-in Math library.\n */\ngoog.array.shuffle \x3d function(arr, opt_randFn) {\n  var randFn \x3d opt_randFn || Math.random;\n\n  for (var i \x3d arr.length - 1; i \x3e 0; i--) {\n    // Choose a random array index in [0, i] (inclusive with i).\n    var j \x3d Math.floor(randFn() * (i + 1));\n\n    var tmp \x3d arr[i];\n    arr[i] \x3d arr[j];\n    arr[j] \x3d tmp;\n  }\n};\n\n\n/**\n * Returns a new array of elements from arr, based on the indexes of elements\n * provided by index_arr. For example, the result of index copying\n * [\x27a\x27, \x27b\x27, \x27c\x27] with index_arr [1,0,0,2] is [\x27b\x27, \x27a\x27, \x27a\x27, \x27c\x27].\n *\n * @param {!Array\x3cT\x3e} arr The array to get a indexed copy from.\n * @param {!Array\x3cnumber\x3e} index_arr An array of indexes to get from arr.\n * @return {!Array\x3cT\x3e} A new array of elements from arr in index_arr order.\n * @template T\n */\ngoog.array.copyByIndex \x3d function(arr, index_arr) {\n  var result \x3d [];\n  goog.array.forEach(index_arr, function(index) { result.push(arr[index]); });\n  return result;\n};\n\n\n/**\n * Maps each element of the input array into zero or more elements of the output\n * array.\n *\n * @param {!IArrayLike\x3cVALUE\x3e|string} arr Array or array like object\n *     over which to iterate.\n * @param {function(this:THIS, VALUE, number, ?): !Array\x3cRESULT\x3e} f The function\n *     to call for every element. This function takes 3 arguments (the element,\n *     the index and the array) and should return an array. The result will be\n *     used to extend a new array.\n * @param {THIS\x3d} opt_obj The object to be used as the value of \x27this\x27 within f.\n * @return {!Array\x3cRESULT\x3e} a new array with the concatenation of all arrays\n *     returned from f.\n * @template THIS, VALUE, RESULT\n */\ngoog.array.concatMap \x3d function(arr, f, opt_obj) {\n  return goog.array.concat.apply([], goog.array.map(arr, f, opt_obj));\n};\n");
SHADOW_ENV.evalLoad("goog.structs.structs.js", false , "// Copyright 2006 The Closure Library Authors. All Rights Reserved.\n//\n// Licensed under the Apache License, Version 2.0 (the \x22License\x22);\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//      http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an \x22AS-IS\x22 BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\n\n/**\n * @fileoverview Generics method for collection-like classes and objects.\n *\n * @author arv@google.com (Erik Arvidsson)\n *\n * This file contains functions to work with collections. It supports using\n * Map, Set, Array and Object and other classes that implement collection-like\n * methods.\n */\n\n\ngoog.provide(\x27goog.structs\x27);\n\ngoog.require(\x27goog.array\x27);\ngoog.require(\x27goog.object\x27);\n\n\n// We treat an object as a dictionary if it has getKeys or it is an object that\n// isn\x27t arrayLike.\n\n\n/**\n * Returns the number of values in the collection-like object.\n * @param {Object} col The collection-like object.\n * @return {number} The number of values in the collection-like object.\n */\ngoog.structs.getCount \x3d function(col) {\n  if (col.getCount \x26\x26 typeof col.getCount \x3d\x3d \x27function\x27) {\n    return col.getCount();\n  }\n  if (goog.isArrayLike(col) || goog.isString(col)) {\n    return col.length;\n  }\n  return goog.object.getCount(col);\n};\n\n\n/**\n * Returns the values of the collection-like object.\n * @param {Object} col The collection-like object.\n * @return {!Array\x3c?\x3e} The values in the collection-like object.\n */\ngoog.structs.getValues \x3d function(col) {\n  if (col.getValues \x26\x26 typeof col.getValues \x3d\x3d \x27function\x27) {\n    return col.getValues();\n  }\n  if (goog.isString(col)) {\n    return col.split(\x27\x27);\n  }\n  if (goog.isArrayLike(col)) {\n    var rv \x3d [];\n    var l \x3d col.length;\n    for (var i \x3d 0; i \x3c l; i++) {\n      rv.push(col[i]);\n    }\n    return rv;\n  }\n  return goog.object.getValues(col);\n};\n\n\n/**\n * Returns the keys of the collection. Some collections have no notion of\n * keys/indexes and this function will return undefined in those cases.\n * @param {Object} col The collection-like object.\n * @return {!Array|undefined} The keys in the collection.\n */\ngoog.structs.getKeys \x3d function(col) {\n  if (col.getKeys \x26\x26 typeof col.getKeys \x3d\x3d \x27function\x27) {\n    return col.getKeys();\n  }\n  // if we have getValues but no getKeys we know this is a key-less collection\n  if (col.getValues \x26\x26 typeof col.getValues \x3d\x3d \x27function\x27) {\n    return undefined;\n  }\n  if (goog.isArrayLike(col) || goog.isString(col)) {\n    var rv \x3d [];\n    var l \x3d col.length;\n    for (var i \x3d 0; i \x3c l; i++) {\n      rv.push(i);\n    }\n    return rv;\n  }\n\n  return goog.object.getKeys(col);\n};\n\n\n/**\n * Whether the collection contains the given value. This is O(n) and uses\n * equals (\x3d\x3d) to test the existence.\n * @param {Object} col The collection-like object.\n * @param {*} val The value to check for.\n * @return {boolean} True if the map contains the value.\n */\ngoog.structs.contains \x3d function(col, val) {\n  if (col.contains \x26\x26 typeof col.contains \x3d\x3d \x27function\x27) {\n    return col.contains(val);\n  }\n  if (col.containsValue \x26\x26 typeof col.containsValue \x3d\x3d \x27function\x27) {\n    return col.containsValue(val);\n  }\n  if (goog.isArrayLike(col) || goog.isString(col)) {\n    return goog.array.contains(/** @type {!Array\x3c?\x3e} */ (col), val);\n  }\n  return goog.object.containsValue(col, val);\n};\n\n\n/**\n * Whether the collection is empty.\n * @param {Object} col The collection-like object.\n * @return {boolean} True if empty.\n */\ngoog.structs.isEmpty \x3d function(col) {\n  if (col.isEmpty \x26\x26 typeof col.isEmpty \x3d\x3d \x27function\x27) {\n    return col.isEmpty();\n  }\n\n  // We do not use goog.string.isEmptyOrWhitespace because here we treat the\n  // string as\n  // collection and as such even whitespace matters\n\n  if (goog.isArrayLike(col) || goog.isString(col)) {\n    return goog.array.isEmpty(/** @type {!Array\x3c?\x3e} */ (col));\n  }\n  return goog.object.isEmpty(col);\n};\n\n\n/**\n * Removes all the elements from the collection.\n * @param {Object} col The collection-like object.\n */\ngoog.structs.clear \x3d function(col) {\n  // NOTE(arv): This should not contain strings because strings are immutable\n  if (col.clear \x26\x26 typeof col.clear \x3d\x3d \x27function\x27) {\n    col.clear();\n  } else if (goog.isArrayLike(col)) {\n    goog.array.clear(/** @type {IArrayLike\x3c?\x3e} */ (col));\n  } else {\n    goog.object.clear(col);\n  }\n};\n\n\n/**\n * Calls a function for each value in a collection. The function takes\n * three arguments; the value, the key and the collection.\n *\n * @param {S} col The collection-like object.\n * @param {function(this:T,?,?,S):?} f The function to call for every value.\n *     This function takes\n *     3 arguments (the value, the key or undefined if the collection has no\n *     notion of keys, and the collection) and the return value is irrelevant.\n * @param {T\x3d} opt_obj The object to be used as the value of \x27this\x27\n *     within {@code f}.\n * @template T,S\n * @deprecated Use a more specific method, e.g. goog.array.forEach,\n *     goog.object.forEach, or for-of.\n */\ngoog.structs.forEach \x3d function(col, f, opt_obj) {\n  if (col.forEach \x26\x26 typeof col.forEach \x3d\x3d \x27function\x27) {\n    col.forEach(f, opt_obj);\n  } else if (goog.isArrayLike(col) || goog.isString(col)) {\n    goog.array.forEach(/** @type {!Array\x3c?\x3e} */ (col), f, opt_obj);\n  } else {\n    var keys \x3d goog.structs.getKeys(col);\n    var values \x3d goog.structs.getValues(col);\n    var l \x3d values.length;\n    for (var i \x3d 0; i \x3c l; i++) {\n      f.call(/** @type {?} */ (opt_obj), values[i], keys \x26\x26 keys[i], col);\n    }\n  }\n};\n\n\n/**\n * Calls a function for every value in the collection. When a call returns true,\n * adds the value to a new collection (Array is returned by default).\n *\n * @param {S} col The collection-like object.\n * @param {function(this:T,?,?,S):boolean} f The function to call for every\n *     value. This function takes\n *     3 arguments (the value, the key or undefined if the collection has no\n *     notion of keys, and the collection) and should return a Boolean. If the\n *     return value is true the value is added to the result collection. If it\n *     is false the value is not included.\n * @param {T\x3d} opt_obj The object to be used as the value of \x27this\x27\n *     within {@code f}.\n * @return {!Object|!Array\x3c?\x3e} A new collection where the passed values are\n *     present. If col is a key-less collection an array is returned.  If col\n *     has keys and values a plain old JS object is returned.\n * @template T,S\n */\ngoog.structs.filter \x3d function(col, f, opt_obj) {\n  if (typeof col.filter \x3d\x3d \x27function\x27) {\n    return col.filter(f, opt_obj);\n  }\n  if (goog.isArrayLike(col) || goog.isString(col)) {\n    return goog.array.filter(/** @type {!Array\x3c?\x3e} */ (col), f, opt_obj);\n  }\n\n  var rv;\n  var keys \x3d goog.structs.getKeys(col);\n  var values \x3d goog.structs.getValues(col);\n  var l \x3d values.length;\n  if (keys) {\n    rv \x3d {};\n    for (var i \x3d 0; i \x3c l; i++) {\n      if (f.call(/** @type {?} */ (opt_obj), values[i], keys[i], col)) {\n        rv[keys[i]] \x3d values[i];\n      }\n    }\n  } else {\n    // We should not use goog.array.filter here since we want to make sure that\n    // the index is undefined as well as make sure that col is passed to the\n    // function.\n    rv \x3d [];\n    for (var i \x3d 0; i \x3c l; i++) {\n      if (f.call(opt_obj, values[i], undefined, col)) {\n        rv.push(values[i]);\n      }\n    }\n  }\n  return rv;\n};\n\n\n/**\n * Calls a function for every value in the collection and adds the result into a\n * new collection (defaults to creating a new Array).\n *\n * @param {S} col The collection-like object.\n * @param {function(this:T,?,?,S):V} f The function to call for every value.\n *     This function takes 3 arguments (the value, the key or undefined if the\n *     collection has no notion of keys, and the collection) and should return\n *     something. The result will be used as the value in the new collection.\n * @param {T\x3d} opt_obj  The object to be used as the value of \x27this\x27\n *     within {@code f}.\n * @return {!Object\x3cV\x3e|!Array\x3cV\x3e} A new collection with the new values.  If\n *     col is a key-less collection an array is returned.  If col has keys and\n *     values a plain old JS object is returned.\n * @template T,S,V\n */\ngoog.structs.map \x3d function(col, f, opt_obj) {\n  if (typeof col.map \x3d\x3d \x27function\x27) {\n    return col.map(f, opt_obj);\n  }\n  if (goog.isArrayLike(col) || goog.isString(col)) {\n    return goog.array.map(/** @type {!Array\x3c?\x3e} */ (col), f, opt_obj);\n  }\n\n  var rv;\n  var keys \x3d goog.structs.getKeys(col);\n  var values \x3d goog.structs.getValues(col);\n  var l \x3d values.length;\n  if (keys) {\n    rv \x3d {};\n    for (var i \x3d 0; i \x3c l; i++) {\n      rv[keys[i]] \x3d f.call(/** @type {?} */ (opt_obj), values[i], keys[i], col);\n    }\n  } else {\n    // We should not use goog.array.map here since we want to make sure that\n    // the index is undefined as well as make sure that col is passed to the\n    // function.\n    rv \x3d [];\n    for (var i \x3d 0; i \x3c l; i++) {\n      rv[i] \x3d f.call(/** @type {?} */ (opt_obj), values[i], undefined, col);\n    }\n  }\n  return rv;\n};\n\n\n/**\n * Calls f for each value in a collection. If any call returns true this returns\n * true (without checking the rest). If all returns false this returns false.\n *\n * @param {S} col The collection-like object.\n * @param {function(this:T,?,?,S):boolean} f The function to call for every\n *     value. This function takes 3 arguments (the value, the key or undefined\n *     if the collection has no notion of keys, and the collection) and should\n *     return a boolean.\n * @param {T\x3d} opt_obj  The object to be used as the value of \x27this\x27\n *     within {@code f}.\n * @return {boolean} True if any value passes the test.\n * @template T,S\n */\ngoog.structs.some \x3d function(col, f, opt_obj) {\n  if (typeof col.some \x3d\x3d \x27function\x27) {\n    return col.some(f, opt_obj);\n  }\n  if (goog.isArrayLike(col) || goog.isString(col)) {\n    return goog.array.some(/** @type {!Array\x3c?\x3e} */ (col), f, opt_obj);\n  }\n  var keys \x3d goog.structs.getKeys(col);\n  var values \x3d goog.structs.getValues(col);\n  var l \x3d values.length;\n  for (var i \x3d 0; i \x3c l; i++) {\n    if (f.call(/** @type {?} */ (opt_obj), values[i], keys \x26\x26 keys[i], col)) {\n      return true;\n    }\n  }\n  return false;\n};\n\n\n/**\n * Calls f for each value in a collection. If all calls return true this return\n * true this returns true. If any returns false this returns false at this point\n *  and does not continue to check the remaining values.\n *\n * @param {S} col The collection-like object.\n * @param {function(this:T,?,?,S):boolean} f The function to call for every\n *     value. This function takes 3 arguments (the value, the key or\n *     undefined if the collection has no notion of keys, and the collection)\n *     and should return a boolean.\n * @param {T\x3d} opt_obj  The object to be used as the value of \x27this\x27\n *     within {@code f}.\n * @return {boolean} True if all key-value pairs pass the test.\n * @template T,S\n */\ngoog.structs.every \x3d function(col, f, opt_obj) {\n  if (typeof col.every \x3d\x3d \x27function\x27) {\n    return col.every(f, opt_obj);\n  }\n  if (goog.isArrayLike(col) || goog.isString(col)) {\n    return goog.array.every(/** @type {!Array\x3c?\x3e} */ (col), f, opt_obj);\n  }\n  var keys \x3d goog.structs.getKeys(col);\n  var values \x3d goog.structs.getValues(col);\n  var l \x3d values.length;\n  for (var i \x3d 0; i \x3c l; i++) {\n    if (!f.call(/** @type {?} */ (opt_obj), values[i], keys \x26\x26 keys[i], col)) {\n      return false;\n    }\n  }\n  return true;\n};\n");
SHADOW_ENV.evalLoad("goog.functions.functions.js", false , "// Copyright 2008 The Closure Library Authors. All Rights Reserved.\n//\n// Licensed under the Apache License, Version 2.0 (the \x22License\x22);\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//      http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an \x22AS-IS\x22 BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\n\n/**\n * @fileoverview Utilities for creating functions. Loosely inspired by the\n * java classes: http://goo.gl/GM0Hmu and http://goo.gl/6k7nI8.\n *\n * @author nicksantos@google.com (Nick Santos)\n */\n\n\ngoog.provide(\x27goog.functions\x27);\n\n\n/**\n * Creates a function that always returns the same value.\n * @param {T} retValue The value to return.\n * @return {function():T} The new function.\n * @template T\n */\ngoog.functions.constant \x3d function(retValue) {\n  return function() { return retValue; };\n};\n\n\n/**\n * Always returns false.\n * @type {function(...): boolean}\n */\ngoog.functions.FALSE \x3d goog.functions.constant(false);\n\n\n/**\n * Always returns true.\n * @type {function(...): boolean}\n */\ngoog.functions.TRUE \x3d goog.functions.constant(true);\n\n\n/**\n * Always returns NULL.\n * @type {function(...): null}\n */\ngoog.functions.NULL \x3d goog.functions.constant(null);\n\n\n/**\n * A simple function that returns the first argument of whatever is passed\n * into it.\n * @param {T\x3d} opt_returnValue The single value that will be returned.\n * @param {...*} var_args Optional trailing arguments. These are ignored.\n * @return {T} The first argument passed in, or undefined if nothing was passed.\n * @template T\n */\ngoog.functions.identity \x3d function(opt_returnValue, var_args) {\n  return opt_returnValue;\n};\n\n\n/**\n * Creates a function that always throws an error with the given message.\n * @param {string} message The error message.\n * @return {!Function} The error-throwing function.\n */\ngoog.functions.error \x3d function(message) {\n  return function() { throw Error(message); };\n};\n\n\n/**\n * Creates a function that throws the given object.\n * @param {*} err An object to be thrown.\n * @return {!Function} The error-throwing function.\n */\ngoog.functions.fail \x3d function(err) {\n  return function() { throw err; };\n};\n\n\n/**\n * Given a function, create a function that keeps opt_numArgs arguments and\n * silently discards all additional arguments.\n * @param {Function} f The original function.\n * @param {number\x3d} opt_numArgs The number of arguments to keep. Defaults to 0.\n * @return {!Function} A version of f that only keeps the first opt_numArgs\n *     arguments.\n */\ngoog.functions.lock \x3d function(f, opt_numArgs) {\n  opt_numArgs \x3d opt_numArgs || 0;\n  return function() {\n    return f.apply(this, Array.prototype.slice.call(arguments, 0, opt_numArgs));\n  };\n};\n\n\n/**\n * Creates a function that returns its nth argument.\n * @param {number} n The position of the return argument.\n * @return {!Function} A new function.\n */\ngoog.functions.nth \x3d function(n) {\n  return function() { return arguments[n]; };\n};\n\n\n/**\n * Like goog.partial(), except that arguments are added after arguments to the\n * returned function.\n *\n * Usage:\n * function f(arg1, arg2, arg3, arg4) { ... }\n * var g \x3d goog.functions.partialRight(f, arg3, arg4);\n * g(arg1, arg2);\n *\n * @param {!Function} fn A function to partially apply.\n * @param {...*} var_args Additional arguments that are partially applied to fn\n *     at the end.\n * @return {!Function} A partially-applied form of the function goog.partial()\n *     was invoked as a method of.\n */\ngoog.functions.partialRight \x3d function(fn, var_args) {\n  var rightArgs \x3d Array.prototype.slice.call(arguments, 1);\n  return function() {\n    var newArgs \x3d Array.prototype.slice.call(arguments);\n    newArgs.push.apply(newArgs, rightArgs);\n    return fn.apply(this, newArgs);\n  };\n};\n\n\n/**\n * Given a function, create a new function that swallows its return value\n * and replaces it with a new one.\n * @param {Function} f A function.\n * @param {T} retValue A new return value.\n * @return {function(...?):T} A new function.\n * @template T\n */\ngoog.functions.withReturnValue \x3d function(f, retValue) {\n  return goog.functions.sequence(f, goog.functions.constant(retValue));\n};\n\n\n/**\n * Creates a function that returns whether its argument equals the given value.\n *\n * Example:\n * var key \x3d goog.object.findKey(obj, goog.functions.equalTo(\x27needle\x27));\n *\n * @param {*} value The value to compare to.\n * @param {boolean\x3d} opt_useLooseComparison Whether to use a loose (\x3d\x3d)\n *     comparison rather than a strict (\x3d\x3d\x3d) one. Defaults to false.\n * @return {function(*):boolean} The new function.\n */\ngoog.functions.equalTo \x3d function(value, opt_useLooseComparison) {\n  return function(other) {\n    return opt_useLooseComparison ? (value \x3d\x3d other) : (value \x3d\x3d\x3d other);\n  };\n};\n\n\n/**\n * Creates the composition of the functions passed in.\n * For example, (goog.functions.compose(f, g))(a) is equivalent to f(g(a)).\n * @param {function(...?):T} fn The final function.\n * @param {...Function} var_args A list of functions.\n * @return {function(...?):T} The composition of all inputs.\n * @template T\n */\ngoog.functions.compose \x3d function(fn, var_args) {\n  var functions \x3d arguments;\n  var length \x3d functions.length;\n  return function() {\n    var result;\n    if (length) {\n      result \x3d functions[length - 1].apply(this, arguments);\n    }\n\n    for (var i \x3d length - 2; i \x3e\x3d 0; i--) {\n      result \x3d functions[i].call(this, result);\n    }\n    return result;\n  };\n};\n\n\n/**\n * Creates a function that calls the functions passed in in sequence, and\n * returns the value of the last function. For example,\n * (goog.functions.sequence(f, g))(x) is equivalent to f(x),g(x).\n * @param {...Function} var_args A list of functions.\n * @return {!Function} A function that calls all inputs in sequence.\n */\ngoog.functions.sequence \x3d function(var_args) {\n  var functions \x3d arguments;\n  var length \x3d functions.length;\n  return function() {\n    var result;\n    for (var i \x3d 0; i \x3c length; i++) {\n      result \x3d functions[i].apply(this, arguments);\n    }\n    return result;\n  };\n};\n\n\n/**\n * Creates a function that returns true if each of its components evaluates\n * to true. The components are evaluated in order, and the evaluation will be\n * short-circuited as soon as a function returns false.\n * For example, (goog.functions.and(f, g))(x) is equivalent to f(x) \x26\x26 g(x).\n * @param {...Function} var_args A list of functions.\n * @return {function(...?):boolean} A function that ANDs its component\n *      functions.\n */\ngoog.functions.and \x3d function(var_args) {\n  var functions \x3d arguments;\n  var length \x3d functions.length;\n  return function() {\n    for (var i \x3d 0; i \x3c length; i++) {\n      if (!functions[i].apply(this, arguments)) {\n        return false;\n      }\n    }\n    return true;\n  };\n};\n\n\n/**\n * Creates a function that returns true if any of its components evaluates\n * to true. The components are evaluated in order, and the evaluation will be\n * short-circuited as soon as a function returns true.\n * For example, (goog.functions.or(f, g))(x) is equivalent to f(x) || g(x).\n * @param {...Function} var_args A list of functions.\n * @return {function(...?):boolean} A function that ORs its component\n *    functions.\n */\ngoog.functions.or \x3d function(var_args) {\n  var functions \x3d arguments;\n  var length \x3d functions.length;\n  return function() {\n    for (var i \x3d 0; i \x3c length; i++) {\n      if (functions[i].apply(this, arguments)) {\n        return true;\n      }\n    }\n    return false;\n  };\n};\n\n\n/**\n * Creates a function that returns the Boolean opposite of a provided function.\n * For example, (goog.functions.not(f))(x) is equivalent to !f(x).\n * @param {!Function} f The original function.\n * @return {function(...?):boolean} A function that delegates to f and returns\n * opposite.\n */\ngoog.functions.not \x3d function(f) {\n  return function() { return !f.apply(this, arguments); };\n};\n\n\n/**\n * Generic factory function to construct an object given the constructor\n * and the arguments. Intended to be bound to create object factories.\n *\n * Example:\n *\n * var factory \x3d goog.partial(goog.functions.create, Class);\n *\n * @param {function(new:T, ...)} constructor The constructor for the Object.\n * @param {...*} var_args The arguments to be passed to the constructor.\n * @return {T} A new instance of the class given in {@code constructor}.\n * @template T\n */\ngoog.functions.create \x3d function(constructor, var_args) {\n  /**\n   * @constructor\n   * @final\n   */\n  var temp \x3d function() {};\n  temp.prototype \x3d constructor.prototype;\n\n  // obj will have constructor\x27s prototype in its chain and\n  // \x27obj instanceof constructor\x27 will be true.\n  var obj \x3d new temp();\n\n  // obj is initialized by constructor.\n  // arguments is only array-like so lacks shift(), but can be used with\n  // the Array prototype function.\n  constructor.apply(obj, Array.prototype.slice.call(arguments, 1));\n  return obj;\n};\n\n\n/**\n * @define {boolean} Whether the return value cache should be used.\n *    This should only be used to disable caches when testing.\n */\ngoog.define(\x27goog.functions.CACHE_RETURN_VALUE\x27, true);\n\n\n/**\n * Gives a wrapper function that caches the return value of a parameterless\n * function when first called.\n *\n * When called for the first time, the given function is called and its\n * return value is cached (thus this is only appropriate for idempotent\n * functions).  Subsequent calls will return the cached return value. This\n * allows the evaluation of expensive functions to be delayed until first used.\n *\n * To cache the return values of functions with parameters, see goog.memoize.\n *\n * @param {function():T} fn A function to lazily evaluate.\n * @return {function():T} A wrapped version the function.\n * @template T\n */\ngoog.functions.cacheReturnValue \x3d function(fn) {\n  var called \x3d false;\n  var value;\n\n  return function() {\n    if (!goog.functions.CACHE_RETURN_VALUE) {\n      return fn();\n    }\n\n    if (!called) {\n      value \x3d fn();\n      called \x3d true;\n    }\n\n    return value;\n  };\n};\n\n\n/**\n * Wraps a function to allow it to be called, at most, once. All\n * additional calls are no-ops.\n *\n * This is particularly useful for initialization functions\n * that should be called, at most, once.\n *\n * @param {function():*} f Function to call.\n * @return {function():undefined} Wrapped function.\n */\ngoog.functions.once \x3d function(f) {\n  // Keep a reference to the function that we null out when we\x27re done with\n  // it -- that way, the function can be GC\x27d when we\x27re done with it.\n  var inner \x3d f;\n  return function() {\n    if (inner) {\n      var tmp \x3d inner;\n      inner \x3d null;\n      tmp();\n    }\n  };\n};\n\n\n/**\n * Wraps a function to allow it to be called, at most, once per interval\n * (specified in milliseconds). If the wrapper function is called N times within\n * that interval, only the Nth call will go through.\n *\n * This is particularly useful for batching up repeated actions where the\n * last action should win. This can be used, for example, for refreshing an\n * autocomplete pop-up every so often rather than updating with every keystroke,\n * since the final text typed by the user is the one that should produce the\n * final autocomplete results. For more stateful debouncing with support for\n * pausing, resuming, and canceling debounced actions, use {@code\n * goog.async.Debouncer}.\n *\n * @param {function(this:SCOPE, ...?)} f Function to call.\n * @param {number} interval Interval over which to debounce. The function will\n *     only be called after the full interval has elapsed since the last call.\n * @param {SCOPE\x3d} opt_scope Object in whose scope to call the function.\n * @return {function(...?): undefined} Wrapped function.\n * @template SCOPE\n */\ngoog.functions.debounce \x3d function(f, interval, opt_scope) {\n  var timeout \x3d 0;\n  return /** @type {function(...?)} */ (function(var_args) {\n    goog.global.clearTimeout(timeout);\n    var args \x3d arguments;\n    timeout \x3d goog.global.setTimeout(function() {\n      f.apply(opt_scope, args);\n    }, interval);\n  });\n};\n\n\n/**\n * Wraps a function to allow it to be called, at most, once per interval\n * (specified in milliseconds). If the wrapper function is called N times in\n * that interval, both the 1st and the Nth calls will go through.\n *\n * This is particularly useful for limiting repeated user requests where the\n * the last action should win, but you also don\x27t want to wait until the end of\n * the interval before sending a request out, as it leads to a perception of\n * slowness for the user.\n *\n * @param {function(this:SCOPE, ...?)} f Function to call.\n * @param {number} interval Interval over which to throttle. The function can\n *     only be called once per interval.\n * @param {SCOPE\x3d} opt_scope Object in whose scope to call the function.\n * @return {function(...?): undefined} Wrapped function.\n * @template SCOPE\n */\ngoog.functions.throttle \x3d function(f, interval, opt_scope) {\n  var timeout \x3d 0;\n  var shouldFire \x3d false;\n  var args \x3d [];\n\n  var handleTimeout \x3d function() {\n    timeout \x3d 0;\n    if (shouldFire) {\n      shouldFire \x3d false;\n      fire();\n    }\n  };\n\n  var fire \x3d function() {\n    timeout \x3d goog.global.setTimeout(handleTimeout, interval);\n    f.apply(opt_scope, args);\n  };\n\n  return /** @type {function(...?)} */ (function(var_args) {\n    args \x3d arguments;\n    if (!timeout) {\n      fire();\n    } else {\n      shouldFire \x3d true;\n    }\n  });\n};\n\n\n/**\n * Wraps a function to allow it to be called, at most, once per interval\n * (specified in milliseconds). If the wrapper function is called N times within\n * that interval, only the 1st call will go through.\n *\n * This is particularly useful for limiting repeated user requests where the\n * first request is guaranteed to have all the data required to perform the\n * final action, so there\x27s no need to wait until the end of the interval before\n * sending the request out.\n *\n * @param {function(this:SCOPE, ...?)} f Function to call.\n * @param {number} interval Interval over which to rate-limit. The function will\n *     only be called once per interval, and ignored for the remainer of the\n *     interval.\n * @param {SCOPE\x3d} opt_scope Object in whose scope to call the function.\n * @return {function(...?): undefined} Wrapped function.\n * @template SCOPE\n */\ngoog.functions.rateLimit \x3d function(f, interval, opt_scope) {\n  var timeout \x3d 0;\n\n  var handleTimeout \x3d function() {\n    timeout \x3d 0;\n  };\n\n  return /** @type {function(...?)} */ (function(var_args) {\n    if (!timeout) {\n      timeout \x3d goog.global.setTimeout(handleTimeout, interval);\n      f.apply(opt_scope, arguments);\n    }\n  });\n};\n");
SHADOW_ENV.evalLoad("goog.math.math.js", false , "// Copyright 2006 The Closure Library Authors. All Rights Reserved.\n//\n// Licensed under the Apache License, Version 2.0 (the \x22License\x22);\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//      http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an \x22AS-IS\x22 BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\n\n/**\n * @fileoverview Additional mathematical functions.\n */\n\ngoog.provide(\x27goog.math\x27);\n\ngoog.require(\x27goog.array\x27);\ngoog.require(\x27goog.asserts\x27);\n\n\n/**\n * Returns a random integer greater than or equal to 0 and less than {@code a}.\n * @param {number} a  The upper bound for the random integer (exclusive).\n * @return {number} A random integer N such that 0 \x3c\x3d N \x3c a.\n */\ngoog.math.randomInt \x3d function(a) {\n  return Math.floor(Math.random() * a);\n};\n\n\n/**\n * Returns a random number greater than or equal to {@code a} and less than\n * {@code b}.\n * @param {number} a  The lower bound for the random number (inclusive).\n * @param {number} b  The upper bound for the random number (exclusive).\n * @return {number} A random number N such that a \x3c\x3d N \x3c b.\n */\ngoog.math.uniformRandom \x3d function(a, b) {\n  return a + Math.random() * (b - a);\n};\n\n\n/**\n * Takes a number and clamps it to within the provided bounds.\n * @param {number} value The input number.\n * @param {number} min The minimum value to return.\n * @param {number} max The maximum value to return.\n * @return {number} The input number if it is within bounds, or the nearest\n *     number within the bounds.\n */\ngoog.math.clamp \x3d function(value, min, max) {\n  return Math.min(Math.max(value, min), max);\n};\n\n\n/**\n * The % operator in JavaScript returns the remainder of a / b, but differs from\n * some other languages in that the result will have the same sign as the\n * dividend. For example, -1 % 8 \x3d\x3d -1, whereas in some other languages\n * (such as Python) the result would be 7. This function emulates the more\n * correct modulo behavior, which is useful for certain applications such as\n * calculating an offset index in a circular list.\n *\n * @param {number} a The dividend.\n * @param {number} b The divisor.\n * @return {number} a % b where the result is between 0 and b (either 0 \x3c\x3d x \x3c b\n *     or b \x3c x \x3c\x3d 0, depending on the sign of b).\n */\ngoog.math.modulo \x3d function(a, b) {\n  var r \x3d a % b;\n  // If r and b differ in sign, add b to wrap the result to the correct sign.\n  return (r * b \x3c 0) ? r + b : r;\n};\n\n\n/**\n * Performs linear interpolation between values a and b. Returns the value\n * between a and b proportional to x (when x is between 0 and 1. When x is\n * outside this range, the return value is a linear extrapolation).\n * @param {number} a A number.\n * @param {number} b A number.\n * @param {number} x The proportion between a and b.\n * @return {number} The interpolated value between a and b.\n */\ngoog.math.lerp \x3d function(a, b, x) {\n  return a + x * (b - a);\n};\n\n\n/**\n * Tests whether the two values are equal to each other, within a certain\n * tolerance to adjust for floating point errors.\n * @param {number} a A number.\n * @param {number} b A number.\n * @param {number\x3d} opt_tolerance Optional tolerance range. Defaults\n *     to 0.000001. If specified, should be greater than 0.\n * @return {boolean} Whether {@code a} and {@code b} are nearly equal.\n */\ngoog.math.nearlyEquals \x3d function(a, b, opt_tolerance) {\n  return Math.abs(a - b) \x3c\x3d (opt_tolerance || 0.000001);\n};\n\n\n// TODO(user): Rename to normalizeAngle, retaining old name as deprecated\n// alias.\n/**\n * Normalizes an angle to be in range [0-360). Angles outside this range will\n * be normalized to be the equivalent angle with that range.\n * @param {number} angle Angle in degrees.\n * @return {number} Standardized angle.\n */\ngoog.math.standardAngle \x3d function(angle) {\n  return goog.math.modulo(angle, 360);\n};\n\n\n/**\n * Normalizes an angle to be in range [0-2*PI). Angles outside this range will\n * be normalized to be the equivalent angle with that range.\n * @param {number} angle Angle in radians.\n * @return {number} Standardized angle.\n */\ngoog.math.standardAngleInRadians \x3d function(angle) {\n  return goog.math.modulo(angle, 2 * Math.PI);\n};\n\n\n/**\n * Converts degrees to radians.\n * @param {number} angleDegrees Angle in degrees.\n * @return {number} Angle in radians.\n */\ngoog.math.toRadians \x3d function(angleDegrees) {\n  return angleDegrees * Math.PI / 180;\n};\n\n\n/**\n * Converts radians to degrees.\n * @param {number} angleRadians Angle in radians.\n * @return {number} Angle in degrees.\n */\ngoog.math.toDegrees \x3d function(angleRadians) {\n  return angleRadians * 180 / Math.PI;\n};\n\n\n/**\n * For a given angle and radius, finds the X portion of the offset.\n * @param {number} degrees Angle in degrees (zero points in +X direction).\n * @param {number} radius Radius.\n * @return {number} The x-distance for the angle and radius.\n */\ngoog.math.angleDx \x3d function(degrees, radius) {\n  return radius * Math.cos(goog.math.toRadians(degrees));\n};\n\n\n/**\n * For a given angle and radius, finds the Y portion of the offset.\n * @param {number} degrees Angle in degrees (zero points in +X direction).\n * @param {number} radius Radius.\n * @return {number} The y-distance for the angle and radius.\n */\ngoog.math.angleDy \x3d function(degrees, radius) {\n  return radius * Math.sin(goog.math.toRadians(degrees));\n};\n\n\n/**\n * Computes the angle between two points (x1,y1) and (x2,y2).\n * Angle zero points in the +X direction, 90 degrees points in the +Y\n * direction (down) and from there we grow clockwise towards 360 degrees.\n * @param {number} x1 x of first point.\n * @param {number} y1 y of first point.\n * @param {number} x2 x of second point.\n * @param {number} y2 y of second point.\n * @return {number} Standardized angle in degrees of the vector from\n *     x1,y1 to x2,y2.\n */\ngoog.math.angle \x3d function(x1, y1, x2, y2) {\n  return goog.math.standardAngle(\n      goog.math.toDegrees(Math.atan2(y2 - y1, x2 - x1)));\n};\n\n\n/**\n * Computes the difference between startAngle and endAngle (angles in degrees).\n * @param {number} startAngle  Start angle in degrees.\n * @param {number} endAngle  End angle in degrees.\n * @return {number} The number of degrees that when added to\n *     startAngle will result in endAngle. Positive numbers mean that the\n *     direction is clockwise. Negative numbers indicate a counter-clockwise\n *     direction.\n *     The shortest route (clockwise vs counter-clockwise) between the angles\n *     is used.\n *     When the difference is 180 degrees, the function returns 180 (not -180)\n *     angleDifference(30, 40) is 10, and angleDifference(40, 30) is -10.\n *     angleDifference(350, 10) is 20, and angleDifference(10, 350) is -20.\n */\ngoog.math.angleDifference \x3d function(startAngle, endAngle) {\n  var d \x3d\n      goog.math.standardAngle(endAngle) - goog.math.standardAngle(startAngle);\n  if (d \x3e 180) {\n    d \x3d d - 360;\n  } else if (d \x3c\x3d -180) {\n    d \x3d 360 + d;\n  }\n  return d;\n};\n\n\n/**\n * Returns the sign of a number as per the \x22sign\x22 or \x22signum\x22 function.\n * @param {number} x The number to take the sign of.\n * @return {number} -1 when negative, 1 when positive, 0 when 0. Preserves\n *     signed zeros and NaN.\n */\ngoog.math.sign \x3d function(x) {\n  if (x \x3e 0) {\n    return 1;\n  }\n  if (x \x3c 0) {\n    return -1;\n  }\n  return x;  // Preserves signed zeros and NaN.\n};\n\n\n/**\n * JavaScript implementation of Longest Common Subsequence problem.\n * http://en.wikipedia.org/wiki/Longest_common_subsequence\n *\n * Returns the longest possible array that is subarray of both of given arrays.\n *\n * @param {IArrayLike\x3cS\x3e} array1 First array of objects.\n * @param {IArrayLike\x3cT\x3e} array2 Second array of objects.\n * @param {Function\x3d} opt_compareFn Function that acts as a custom comparator\n *     for the array ojects. Function should return true if objects are equal,\n *     otherwise false.\n * @param {Function\x3d} opt_collectorFn Function used to decide what to return\n *     as a result subsequence. It accepts 2 arguments: index of common element\n *     in the first array and index in the second. The default function returns\n *     element from the first array.\n * @return {!Array\x3cS|T\x3e} A list of objects that are common to both arrays\n *     such that there is no common subsequence with size greater than the\n *     length of the list.\n * @template S,T\n */\ngoog.math.longestCommonSubsequence \x3d function(\n    array1, array2, opt_compareFn, opt_collectorFn) {\n\n  var compare \x3d opt_compareFn || function(a, b) { return a \x3d\x3d b; };\n\n  var collect \x3d opt_collectorFn || function(i1, i2) { return array1[i1]; };\n\n  var length1 \x3d array1.length;\n  var length2 \x3d array2.length;\n\n  var arr \x3d [];\n  for (var i \x3d 0; i \x3c length1 + 1; i++) {\n    arr[i] \x3d [];\n    arr[i][0] \x3d 0;\n  }\n\n  for (var j \x3d 0; j \x3c length2 + 1; j++) {\n    arr[0][j] \x3d 0;\n  }\n\n  for (i \x3d 1; i \x3c\x3d length1; i++) {\n    for (j \x3d 1; j \x3c\x3d length2; j++) {\n      if (compare(array1[i - 1], array2[j - 1])) {\n        arr[i][j] \x3d arr[i - 1][j - 1] + 1;\n      } else {\n        arr[i][j] \x3d Math.max(arr[i - 1][j], arr[i][j - 1]);\n      }\n    }\n  }\n\n  // Backtracking\n  var result \x3d [];\n  var i \x3d length1, j \x3d length2;\n  while (i \x3e 0 \x26\x26 j \x3e 0) {\n    if (compare(array1[i - 1], array2[j - 1])) {\n      result.unshift(collect(i - 1, j - 1));\n      i--;\n      j--;\n    } else {\n      if (arr[i - 1][j] \x3e arr[i][j - 1]) {\n        i--;\n      } else {\n        j--;\n      }\n    }\n  }\n\n  return result;\n};\n\n\n/**\n * Returns the sum of the arguments.\n * @param {...number} var_args Numbers to add.\n * @return {number} The sum of the arguments (0 if no arguments were provided,\n *     {@code NaN} if any of the arguments is not a valid number).\n */\ngoog.math.sum \x3d function(var_args) {\n  return /** @type {number} */ (\n      goog.array.reduce(\n          arguments, function(sum, value) { return sum + value; }, 0));\n};\n\n\n/**\n * Returns the arithmetic mean of the arguments.\n * @param {...number} var_args Numbers to average.\n * @return {number} The average of the arguments ({@code NaN} if no arguments\n *     were provided or any of the arguments is not a valid number).\n */\ngoog.math.average \x3d function(var_args) {\n  return goog.math.sum.apply(null, arguments) / arguments.length;\n};\n\n\n/**\n * Returns the unbiased sample variance of the arguments. For a definition,\n * see e.g. http://en.wikipedia.org/wiki/Variance\n * @param {...number} var_args Number samples to analyze.\n * @return {number} The unbiased sample variance of the arguments (0 if fewer\n *     than two samples were provided, or {@code NaN} if any of the samples is\n *     not a valid number).\n */\ngoog.math.sampleVariance \x3d function(var_args) {\n  var sampleSize \x3d arguments.length;\n  if (sampleSize \x3c 2) {\n    return 0;\n  }\n\n  var mean \x3d goog.math.average.apply(null, arguments);\n  var variance \x3d\n      goog.math.sum.apply(null, goog.array.map(arguments, function(val) {\n        return Math.pow(val - mean, 2);\n      })) / (sampleSize - 1);\n\n  return variance;\n};\n\n\n/**\n * Returns the sample standard deviation of the arguments.  For a definition of\n * sample standard deviation, see e.g.\n * http://en.wikipedia.org/wiki/Standard_deviation\n * @param {...number} var_args Number samples to analyze.\n * @return {number} The sample standard deviation of the arguments (0 if fewer\n *     than two samples were provided, or {@code NaN} if any of the samples is\n *     not a valid number).\n */\ngoog.math.standardDeviation \x3d function(var_args) {\n  return Math.sqrt(goog.math.sampleVariance.apply(null, arguments));\n};\n\n\n/**\n * Returns whether the supplied number represents an integer, i.e. that is has\n * no fractional component.  No range-checking is performed on the number.\n * @param {number} num The number to test.\n * @return {boolean} Whether {@code num} is an integer.\n */\ngoog.math.isInt \x3d function(num) {\n  return isFinite(num) \x26\x26 num % 1 \x3d\x3d 0;\n};\n\n\n/**\n * Returns whether the supplied number is finite and not NaN.\n * @param {number} num The number to test.\n * @return {boolean} Whether {@code num} is a finite number.\n * @deprecated Use {@link isFinite} instead.\n */\ngoog.math.isFiniteNumber \x3d function(num) {\n  return isFinite(num);\n};\n\n\n/**\n * @param {number} num The number to test.\n * @return {boolean} Whether it is negative zero.\n */\ngoog.math.isNegativeZero \x3d function(num) {\n  return num \x3d\x3d 0 \x26\x26 1 / num \x3c 0;\n};\n\n\n/**\n * Returns the precise value of floor(log10(num)).\n * Simpler implementations didn\x27t work because of floating point rounding\n * errors. For example\n * \x3cul\x3e\n * \x3cli\x3eMath.floor(Math.log(num) / Math.LN10) is off by one for num \x3d\x3d 1e+3.\n * \x3cli\x3eMath.floor(Math.log(num) * Math.LOG10E) is off by one for num \x3d\x3d 1e+15.\n * \x3cli\x3eMath.floor(Math.log10(num)) is off by one for num \x3d\x3d 1e+15 - 1.\n * \x3c/ul\x3e\n * @param {number} num A floating point number.\n * @return {number} Its logarithm to base 10 rounded down to the nearest\n *     integer if num \x3e 0. -Infinity if num \x3d\x3d 0. NaN if num \x3c 0.\n */\ngoog.math.log10Floor \x3d function(num) {\n  if (num \x3e 0) {\n    var x \x3d Math.round(Math.log(num) * Math.LOG10E);\n    return x - (parseFloat(\x271e\x27 + x) \x3e num ? 1 : 0);\n  }\n  return num \x3d\x3d 0 ? -Infinity : NaN;\n};\n\n\n/**\n * A tweaked variant of {@code Math.floor} which tolerates if the passed number\n * is infinitesimally smaller than the closest integer. It often happens with\n * the results of floating point calculations because of the finite precision\n * of the intermediate results. For example {@code Math.floor(Math.log(1000) /\n * Math.LN10) \x3d\x3d 2}, not 3 as one would expect.\n * @param {number} num A number.\n * @param {number\x3d} opt_epsilon An infinitesimally small positive number, the\n *     rounding error to tolerate.\n * @return {number} The largest integer less than or equal to {@code num}.\n */\ngoog.math.safeFloor \x3d function(num, opt_epsilon) {\n  goog.asserts.assert(!goog.isDef(opt_epsilon) || opt_epsilon \x3e 0);\n  return Math.floor(num + (opt_epsilon || 2e-15));\n};\n\n\n/**\n * A tweaked variant of {@code Math.ceil}. See {@code goog.math.safeFloor} for\n * details.\n * @param {number} num A number.\n * @param {number\x3d} opt_epsilon An infinitesimally small positive number, the\n *     rounding error to tolerate.\n * @return {number} The smallest integer greater than or equal to {@code num}.\n */\ngoog.math.safeCeil \x3d function(num, opt_epsilon) {\n  goog.asserts.assert(!goog.isDef(opt_epsilon) || opt_epsilon \x3e 0);\n  return Math.ceil(num - (opt_epsilon || 2e-15));\n};\n");
SHADOW_ENV.evalLoad("goog.iter.iter.js", false , "// Copyright 2007 The Closure Library Authors. All Rights Reserved.\n//\n// Licensed under the Apache License, Version 2.0 (the \x22License\x22);\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//      http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an \x22AS-IS\x22 BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\n\n/**\n * @fileoverview Python style iteration utilities.\n * @author arv@google.com (Erik Arvidsson)\n */\n\n\ngoog.provide(\x27goog.iter\x27);\ngoog.provide(\x27goog.iter.Iterable\x27);\ngoog.provide(\x27goog.iter.Iterator\x27);\ngoog.provide(\x27goog.iter.StopIteration\x27);\n\ngoog.require(\x27goog.array\x27);\ngoog.require(\x27goog.asserts\x27);\ngoog.require(\x27goog.functions\x27);\ngoog.require(\x27goog.math\x27);\n\n\n/**\n * @typedef {goog.iter.Iterator|{length:number}|{__iterator__}}\n */\ngoog.iter.Iterable;\n\n\n/**\n * Singleton Error object that is used to terminate iterations.\n * @const {!Error}\n */\ngoog.iter.StopIteration \x3d (\x27StopIteration\x27 in goog.global) ?\n    // For script engines that support legacy iterators.\n    goog.global[\x27StopIteration\x27] :\n    {message: \x27StopIteration\x27, stack: \x27\x27};\n\n\n\n/**\n * Class/interface for iterators.  An iterator needs to implement a {@code next}\n * method and it needs to throw a {@code goog.iter.StopIteration} when the\n * iteration passes beyond the end.  Iterators have no {@code hasNext} method.\n * It is recommended to always use the helper functions to iterate over the\n * iterator or in case you are only targeting JavaScript 1.7 for in loops.\n * @constructor\n * @template VALUE\n */\ngoog.iter.Iterator \x3d function() {};\n\n\n/**\n * Returns the next value of the iteration.  This will throw the object\n * {@see goog.iter#StopIteration} when the iteration passes the end.\n * @return {VALUE} Any object or value.\n */\ngoog.iter.Iterator.prototype.next \x3d function() {\n  throw goog.iter.StopIteration;\n};\n\n\n/**\n * Returns the {@code Iterator} object itself.  This is used to implement\n * the iterator protocol in JavaScript 1.7\n * @param {boolean\x3d} opt_keys  Whether to return the keys or values. Default is\n *     to only return the values.  This is being used by the for-in loop (true)\n *     and the for-each-in loop (false).  Even though the param gives a hint\n *     about what the iterator will return there is no guarantee that it will\n *     return the keys when true is passed.\n * @return {!goog.iter.Iterator\x3cVALUE\x3e} The object itself.\n */\ngoog.iter.Iterator.prototype.__iterator__ \x3d function(opt_keys) {\n  return this;\n};\n\n\n/**\n * Returns an iterator that knows how to iterate over the values in the object.\n * @param {goog.iter.Iterator\x3cVALUE\x3e|goog.iter.Iterable} iterable  If the\n *     object is an iterator it will be returned as is.  If the object has an\n *     {@code __iterator__} method that will be called to get the value\n *     iterator.  If the object is an array-like object we create an iterator\n *     for that.\n * @return {!goog.iter.Iterator\x3cVALUE\x3e} An iterator that knows how to iterate\n *     over the values in {@code iterable}.\n * @template VALUE\n */\ngoog.iter.toIterator \x3d function(iterable) {\n  if (iterable instanceof goog.iter.Iterator) {\n    return iterable;\n  }\n  if (typeof iterable.__iterator__ \x3d\x3d \x27function\x27) {\n    return iterable.__iterator__(false);\n  }\n  if (goog.isArrayLike(iterable)) {\n    var i \x3d 0;\n    var newIter \x3d new goog.iter.Iterator;\n    newIter.next \x3d function() {\n      while (true) {\n        if (i \x3e\x3d iterable.length) {\n          throw goog.iter.StopIteration;\n        }\n        // Don\x27t include deleted elements.\n        if (!(i in iterable)) {\n          i++;\n          continue;\n        }\n        return iterable[i++];\n      }\n    };\n    return newIter;\n  }\n\n\n  // TODO(arv): Should we fall back on goog.structs.getValues()?\n  throw Error(\x27Not implemented\x27);\n};\n\n\n/**\n * Calls a function for each element in the iterator with the element of the\n * iterator passed as argument.\n *\n * @param {goog.iter.Iterator\x3cVALUE\x3e|goog.iter.Iterable} iterable  The iterator\n *     to iterate over. If the iterable is an object {@code toIterator} will be\n *     called on it.\n * @param {function(this:THIS,VALUE,?,!goog.iter.Iterator\x3cVALUE\x3e)} f\n *     The function to call for every element.  This function takes 3 arguments\n *     (the element, undefined, and the iterator) and the return value is\n *     irrelevant.  The reason for passing undefined as the second argument is\n *     so that the same function can be used in {@see goog.array#forEach} as\n *     well as others.  The third parameter is of type \x22number\x22 for\n *     arraylike objects, undefined, otherwise.\n * @param {THIS\x3d} opt_obj  The object to be used as the value of \x27this\x27 within\n *     {@code f}.\n * @template THIS, VALUE\n */\ngoog.iter.forEach \x3d function(iterable, f, opt_obj) {\n  if (goog.isArrayLike(iterable)) {\n\n    try {\n      // NOTES: this passes the index number to the second parameter\n      // of the callback contrary to the documentation above.\n      goog.array.forEach(\n          /** @type {IArrayLike\x3c?\x3e} */ (iterable), f, opt_obj);\n    } catch (ex) {\n      if (ex !\x3d\x3d goog.iter.StopIteration) {\n        throw ex;\n      }\n    }\n  } else {\n    iterable \x3d goog.iter.toIterator(iterable);\n\n    try {\n      while (true) {\n        f.call(opt_obj, iterable.next(), undefined, iterable);\n      }\n    } catch (ex) {\n      if (ex !\x3d\x3d goog.iter.StopIteration) {\n        throw ex;\n      }\n    }\n  }\n};\n\n\n/**\n * Calls a function for every element in the iterator, and if the function\n * returns true adds the element to a new iterator.\n *\n * @param {goog.iter.Iterator\x3cVALUE\x3e|goog.iter.Iterable} iterable The iterator\n *     to iterate over.\n * @param {\n *     function(this:THIS,VALUE,undefined,!goog.iter.Iterator\x3cVALUE\x3e):boolean} f\n *     The function to call for every element. This function takes 3 arguments\n *     (the element, undefined, and the iterator) and should return a boolean.\n *     If the return value is true the element will be included in the returned\n *     iterator.  If it is false the element is not included.\n * @param {THIS\x3d} opt_obj The object to be used as the value of \x27this\x27 within\n *     {@code f}.\n * @return {!goog.iter.Iterator\x3cVALUE\x3e} A new iterator in which only elements\n *     that passed the test are present.\n * @template THIS, VALUE\n */\ngoog.iter.filter \x3d function(iterable, f, opt_obj) {\n  var iterator \x3d goog.iter.toIterator(iterable);\n  var newIter \x3d new goog.iter.Iterator;\n  newIter.next \x3d function() {\n    while (true) {\n      var val \x3d iterator.next();\n      if (f.call(opt_obj, val, undefined, iterator)) {\n        return val;\n      }\n    }\n  };\n  return newIter;\n};\n\n\n/**\n * Calls a function for every element in the iterator, and if the function\n * returns false adds the element to a new iterator.\n *\n * @param {goog.iter.Iterator\x3cVALUE\x3e|goog.iter.Iterable} iterable The iterator\n *     to iterate over.\n * @param {\n *     function(this:THIS,VALUE,undefined,!goog.iter.Iterator\x3cVALUE\x3e):boolean} f\n *     The function to call for every element. This function takes 3 arguments\n *     (the element, undefined, and the iterator) and should return a boolean.\n *     If the return value is false the element will be included in the returned\n *     iterator.  If it is true the element is not included.\n * @param {THIS\x3d} opt_obj The object to be used as the value of \x27this\x27 within\n *     {@code f}.\n * @return {!goog.iter.Iterator\x3cVALUE\x3e} A new iterator in which only elements\n *     that did not pass the test are present.\n * @template THIS, VALUE\n */\ngoog.iter.filterFalse \x3d function(iterable, f, opt_obj) {\n  return goog.iter.filter(iterable, goog.functions.not(f), opt_obj);\n};\n\n\n/**\n * Creates a new iterator that returns the values in a range.  This function\n * can take 1, 2 or 3 arguments:\n * \x3cpre\x3e\n * range(5) same as range(0, 5, 1)\n * range(2, 5) same as range(2, 5, 1)\n * \x3c/pre\x3e\n *\n * @param {number} startOrStop  The stop value if only one argument is provided.\n *     The start value if 2 or more arguments are provided.  If only one\n *     argument is used the start value is 0.\n * @param {number\x3d} opt_stop  The stop value.  If left out then the first\n *     argument is used as the stop value.\n * @param {number\x3d} opt_step  The number to increment with between each call to\n *     next.  This can be negative.\n * @return {!goog.iter.Iterator\x3cnumber\x3e} A new iterator that returns the values\n *     in the range.\n */\ngoog.iter.range \x3d function(startOrStop, opt_stop, opt_step) {\n  var start \x3d 0;\n  var stop \x3d startOrStop;\n  var step \x3d opt_step || 1;\n  if (arguments.length \x3e 1) {\n    start \x3d startOrStop;\n    stop \x3d opt_stop;\n  }\n  if (step \x3d\x3d 0) {\n    throw Error(\x27Range step argument must not be zero\x27);\n  }\n\n  var newIter \x3d new goog.iter.Iterator;\n  newIter.next \x3d function() {\n    if (step \x3e 0 \x26\x26 start \x3e\x3d stop || step \x3c 0 \x26\x26 start \x3c\x3d stop) {\n      throw goog.iter.StopIteration;\n    }\n    var rv \x3d start;\n    start +\x3d step;\n    return rv;\n  };\n  return newIter;\n};\n\n\n/**\n * Joins the values in a iterator with a delimiter.\n * @param {goog.iter.Iterator\x3cVALUE\x3e|goog.iter.Iterable} iterable The iterator\n *     to get the values from.\n * @param {string} deliminator  The text to put between the values.\n * @return {string} The joined value string.\n * @template VALUE\n */\ngoog.iter.join \x3d function(iterable, deliminator) {\n  return goog.iter.toArray(iterable).join(deliminator);\n};\n\n\n/**\n * For every element in the iterator call a function and return a new iterator\n * with that value.\n *\n * @param {!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable} iterable The\n *     iterator to iterate over.\n * @param {\n *     function(this:THIS,VALUE,undefined,!goog.iter.Iterator\x3cVALUE\x3e):RESULT} f\n *     The function to call for every element.  This function takes 3 arguments\n *     (the element, undefined, and the iterator) and should return a new value.\n * @param {THIS\x3d} opt_obj The object to be used as the value of \x27this\x27 within\n *     {@code f}.\n * @return {!goog.iter.Iterator\x3cRESULT\x3e} A new iterator that returns the\n *     results of applying the function to each element in the original\n *     iterator.\n * @template THIS, VALUE, RESULT\n */\ngoog.iter.map \x3d function(iterable, f, opt_obj) {\n  var iterator \x3d goog.iter.toIterator(iterable);\n  var newIter \x3d new goog.iter.Iterator;\n  newIter.next \x3d function() {\n    var val \x3d iterator.next();\n    return f.call(opt_obj, val, undefined, iterator);\n  };\n  return newIter;\n};\n\n\n/**\n * Passes every element of an iterator into a function and accumulates the\n * result.\n *\n * @param {goog.iter.Iterator\x3cVALUE\x3e|goog.iter.Iterable} iterable The iterator\n *     to iterate over.\n * @param {function(this:THIS,VALUE,VALUE):VALUE} f The function to call for\n *     every element. This function takes 2 arguments (the function\x27s previous\n *     result or the initial value, and the value of the current element).\n *     function(previousValue, currentElement) : newValue.\n * @param {VALUE} val The initial value to pass into the function on the first\n *     call.\n * @param {THIS\x3d} opt_obj  The object to be used as the value of \x27this\x27 within\n *     f.\n * @return {VALUE} Result of evaluating f repeatedly across the values of\n *     the iterator.\n * @template THIS, VALUE\n */\ngoog.iter.reduce \x3d function(iterable, f, val, opt_obj) {\n  var rval \x3d val;\n  goog.iter.forEach(\n      iterable, function(val) { rval \x3d f.call(opt_obj, rval, val); });\n  return rval;\n};\n\n\n/**\n * Goes through the values in the iterator. Calls f for each of these, and if\n * any of them returns true, this returns true (without checking the rest). If\n * all return false this will return false.\n *\n * @param {goog.iter.Iterator\x3cVALUE\x3e|goog.iter.Iterable} iterable The iterator\n *     object.\n * @param {\n *     function(this:THIS,VALUE,undefined,!goog.iter.Iterator\x3cVALUE\x3e):boolean} f\n *     The function to call for every value. This function takes 3 arguments\n *     (the value, undefined, and the iterator) and should return a boolean.\n * @param {THIS\x3d} opt_obj The object to be used as the value of \x27this\x27 within\n *     {@code f}.\n * @return {boolean} true if any value passes the test.\n * @template THIS, VALUE\n */\ngoog.iter.some \x3d function(iterable, f, opt_obj) {\n  iterable \x3d goog.iter.toIterator(iterable);\n\n  try {\n    while (true) {\n      if (f.call(opt_obj, iterable.next(), undefined, iterable)) {\n        return true;\n      }\n    }\n  } catch (ex) {\n    if (ex !\x3d\x3d goog.iter.StopIteration) {\n      throw ex;\n    }\n  }\n  return false;\n};\n\n\n/**\n * Goes through the values in the iterator. Calls f for each of these and if any\n * of them returns false this returns false (without checking the rest). If all\n * return true this will return true.\n *\n * @param {goog.iter.Iterator\x3cVALUE\x3e|goog.iter.Iterable} iterable The iterator\n *     object.\n * @param {\n *     function(this:THIS,VALUE,undefined,!goog.iter.Iterator\x3cVALUE\x3e):boolean} f\n *     The function to call for every value. This function takes 3 arguments\n *     (the value, undefined, and the iterator) and should return a boolean.\n * @param {THIS\x3d} opt_obj The object to be used as the value of \x27this\x27 within\n *     {@code f}.\n * @return {boolean} true if every value passes the test.\n * @template THIS, VALUE\n */\ngoog.iter.every \x3d function(iterable, f, opt_obj) {\n  iterable \x3d goog.iter.toIterator(iterable);\n\n  try {\n    while (true) {\n      if (!f.call(opt_obj, iterable.next(), undefined, iterable)) {\n        return false;\n      }\n    }\n  } catch (ex) {\n    if (ex !\x3d\x3d goog.iter.StopIteration) {\n      throw ex;\n    }\n  }\n  return true;\n};\n\n\n/**\n * Takes zero or more iterables and returns one iterator that will iterate over\n * them in the order chained.\n * @param {...!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable} var_args Any\n *     number of iterable objects.\n * @return {!goog.iter.Iterator\x3cVALUE\x3e} Returns a new iterator that will\n *     iterate over all the given iterables\x27 contents.\n * @template VALUE\n */\ngoog.iter.chain \x3d function(var_args) {\n  return goog.iter.chainFromIterable(arguments);\n};\n\n\n/**\n * Takes a single iterable containing zero or more iterables and returns one\n * iterator that will iterate over each one in the order given.\n * @see https://goo.gl/5NRp5d\n * @param {goog.iter.Iterable} iterable The iterable of iterables to chain.\n * @return {!goog.iter.Iterator\x3cVALUE\x3e} Returns a new iterator that will\n *     iterate over all the contents of the iterables contained within\n *     {@code iterable}.\n * @template VALUE\n */\ngoog.iter.chainFromIterable \x3d function(iterable) {\n  var iterator \x3d goog.iter.toIterator(iterable);\n  var iter \x3d new goog.iter.Iterator();\n  var current \x3d null;\n\n  iter.next \x3d function() {\n    while (true) {\n      if (current \x3d\x3d null) {\n        var it \x3d iterator.next();\n        current \x3d goog.iter.toIterator(it);\n      }\n      try {\n        return current.next();\n      } catch (ex) {\n        if (ex !\x3d\x3d goog.iter.StopIteration) {\n          throw ex;\n        }\n        current \x3d null;\n      }\n    }\n  };\n\n  return iter;\n};\n\n\n/**\n * Builds a new iterator that iterates over the original, but skips elements as\n * long as a supplied function returns true.\n * @param {goog.iter.Iterator\x3cVALUE\x3e|goog.iter.Iterable} iterable The iterator\n *     object.\n * @param {\n *     function(this:THIS,VALUE,undefined,!goog.iter.Iterator\x3cVALUE\x3e):boolean} f\n *     The function to call for every value. This function takes 3 arguments\n *     (the value, undefined, and the iterator) and should return a boolean.\n * @param {THIS\x3d} opt_obj The object to be used as the value of \x27this\x27 within\n *     {@code f}.\n * @return {!goog.iter.Iterator\x3cVALUE\x3e} A new iterator that drops elements from\n *     the original iterator as long as {@code f} is true.\n * @template THIS, VALUE\n */\ngoog.iter.dropWhile \x3d function(iterable, f, opt_obj) {\n  var iterator \x3d goog.iter.toIterator(iterable);\n  var newIter \x3d new goog.iter.Iterator;\n  var dropping \x3d true;\n  newIter.next \x3d function() {\n    while (true) {\n      var val \x3d iterator.next();\n      if (dropping \x26\x26 f.call(opt_obj, val, undefined, iterator)) {\n        continue;\n      } else {\n        dropping \x3d false;\n      }\n      return val;\n    }\n  };\n  return newIter;\n};\n\n\n/**\n * Builds a new iterator that iterates over the original, but only as long as a\n * supplied function returns true.\n * @param {goog.iter.Iterator\x3cVALUE\x3e|goog.iter.Iterable} iterable The iterator\n *     object.\n * @param {\n *     function(this:THIS,VALUE,undefined,!goog.iter.Iterator\x3cVALUE\x3e):boolean} f\n *     The function to call for every value. This function takes 3 arguments\n *     (the value, undefined, and the iterator) and should return a boolean.\n * @param {THIS\x3d} opt_obj This is used as the \x27this\x27 object in f when called.\n * @return {!goog.iter.Iterator\x3cVALUE\x3e} A new iterator that keeps elements in\n *     the original iterator as long as the function is true.\n * @template THIS, VALUE\n */\ngoog.iter.takeWhile \x3d function(iterable, f, opt_obj) {\n  var iterator \x3d goog.iter.toIterator(iterable);\n  var iter \x3d new goog.iter.Iterator();\n  iter.next \x3d function() {\n    var val \x3d iterator.next();\n    if (f.call(opt_obj, val, undefined, iterator)) {\n      return val;\n    }\n    throw goog.iter.StopIteration;\n  };\n  return iter;\n};\n\n\n/**\n * Converts the iterator to an array\n * @param {goog.iter.Iterator\x3cVALUE\x3e|goog.iter.Iterable} iterable The iterator\n *     to convert to an array.\n * @return {!Array\x3cVALUE\x3e} An array of the elements the iterator iterates over.\n * @template VALUE\n */\ngoog.iter.toArray \x3d function(iterable) {\n  // Fast path for array-like.\n  if (goog.isArrayLike(iterable)) {\n    return goog.array.toArray(/** @type {!IArrayLike\x3c?\x3e} */ (iterable));\n  }\n  iterable \x3d goog.iter.toIterator(iterable);\n  var array \x3d [];\n  goog.iter.forEach(iterable, function(val) { array.push(val); });\n  return array;\n};\n\n\n/**\n * Iterates over two iterables and returns true if they contain the same\n * sequence of elements and have the same length.\n * @param {!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable} iterable1 The first\n *     iterable object.\n * @param {!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable} iterable2 The second\n *     iterable object.\n * @param {function(VALUE,VALUE):boolean\x3d} opt_equalsFn Optional comparison\n *     function.\n *     Should take two arguments to compare, and return true if the arguments\n *     are equal. Defaults to {@link goog.array.defaultCompareEquality} which\n *     compares the elements using the built-in \x27\x3d\x3d\x3d\x27 operator.\n * @return {boolean} true if the iterables contain the same sequence of elements\n *     and have the same length.\n * @template VALUE\n */\ngoog.iter.equals \x3d function(iterable1, iterable2, opt_equalsFn) {\n  var fillValue \x3d {};\n  var pairs \x3d goog.iter.zipLongest(fillValue, iterable1, iterable2);\n  var equalsFn \x3d opt_equalsFn || goog.array.defaultCompareEquality;\n  return goog.iter.every(\n      pairs, function(pair) { return equalsFn(pair[0], pair[1]); });\n};\n\n\n/**\n * Advances the iterator to the next position, returning the given default value\n * instead of throwing an exception if the iterator has no more entries.\n * @param {goog.iter.Iterator\x3cVALUE\x3e|goog.iter.Iterable} iterable The iterable\n *     object.\n * @param {VALUE} defaultValue The value to return if the iterator is empty.\n * @return {VALUE} The next item in the iteration, or defaultValue if the\n *     iterator was empty.\n * @template VALUE\n */\ngoog.iter.nextOrValue \x3d function(iterable, defaultValue) {\n  try {\n    return goog.iter.toIterator(iterable).next();\n  } catch (e) {\n    if (e !\x3d goog.iter.StopIteration) {\n      throw e;\n    }\n    return defaultValue;\n  }\n};\n\n\n/**\n * Cartesian product of zero or more sets.  Gives an iterator that gives every\n * combination of one element chosen from each set.  For example,\n * ([1, 2], [3, 4]) gives ([1, 3], [1, 4], [2, 3], [2, 4]).\n * @see http://docs.python.org/library/itertools.html#itertools.product\n * @param {...!IArrayLike\x3cVALUE\x3e} var_args Zero or more sets, as\n *     arrays.\n * @return {!goog.iter.Iterator\x3c!Array\x3cVALUE\x3e\x3e} An iterator that gives each\n *     n-tuple (as an array).\n * @template VALUE\n */\ngoog.iter.product \x3d function(var_args) {\n  var someArrayEmpty \x3d\n      goog.array.some(arguments, function(arr) { return !arr.length; });\n\n  // An empty set in a cartesian product gives an empty set.\n  if (someArrayEmpty || !arguments.length) {\n    return new goog.iter.Iterator();\n  }\n\n  var iter \x3d new goog.iter.Iterator();\n  var arrays \x3d arguments;\n\n  // The first indices are [0, 0, ...]\n  var indicies \x3d goog.array.repeat(0, arrays.length);\n\n  iter.next \x3d function() {\n\n    if (indicies) {\n      var retVal \x3d goog.array.map(indicies, function(valueIndex, arrayIndex) {\n        return arrays[arrayIndex][valueIndex];\n      });\n\n      // Generate the next-largest indices for the next call.\n      // Increase the rightmost index. If it goes over, increase the next\n      // rightmost (like carry-over addition).\n      for (var i \x3d indicies.length - 1; i \x3e\x3d 0; i--) {\n        // Assertion prevents compiler warning below.\n        goog.asserts.assert(indicies);\n        if (indicies[i] \x3c arrays[i].length - 1) {\n          indicies[i]++;\n          break;\n        }\n\n        // We\x27re at the last indices (the last element of every array), so\n        // the iteration is over on the next call.\n        if (i \x3d\x3d 0) {\n          indicies \x3d null;\n          break;\n        }\n        // Reset the index in this column and loop back to increment the\n        // next one.\n        indicies[i] \x3d 0;\n      }\n      return retVal;\n    }\n\n    throw goog.iter.StopIteration;\n  };\n\n  return iter;\n};\n\n\n/**\n * Create an iterator to cycle over the iterable\x27s elements indefinitely.\n * For example, ([1, 2, 3]) would return : 1, 2, 3, 1, 2, 3, ...\n * @see: http://docs.python.org/library/itertools.html#itertools.cycle.\n * @param {!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable} iterable The\n *     iterable object.\n * @return {!goog.iter.Iterator\x3cVALUE\x3e} An iterator that iterates indefinitely\n *     over the values in {@code iterable}.\n * @template VALUE\n */\ngoog.iter.cycle \x3d function(iterable) {\n  var baseIterator \x3d goog.iter.toIterator(iterable);\n\n  // We maintain a cache to store the iterable elements as we iterate\n  // over them. The cache is used to return elements once we have\n  // iterated over the iterable once.\n  var cache \x3d [];\n  var cacheIndex \x3d 0;\n\n  var iter \x3d new goog.iter.Iterator();\n\n  // This flag is set after the iterable is iterated over once\n  var useCache \x3d false;\n\n  iter.next \x3d function() {\n    var returnElement \x3d null;\n\n    // Pull elements off the original iterator if not using cache\n    if (!useCache) {\n      try {\n        // Return the element from the iterable\n        returnElement \x3d baseIterator.next();\n        cache.push(returnElement);\n        return returnElement;\n      } catch (e) {\n        // If an exception other than StopIteration is thrown\n        // or if there are no elements to iterate over (the iterable was empty)\n        // throw an exception\n        if (e !\x3d goog.iter.StopIteration || goog.array.isEmpty(cache)) {\n          throw e;\n        }\n        // set useCache to true after we know that a \x27StopIteration\x27 exception\n        // was thrown and the cache is not empty (to handle the \x27empty iterable\x27\n        // use case)\n        useCache \x3d true;\n      }\n    }\n\n    returnElement \x3d cache[cacheIndex];\n    cacheIndex \x3d (cacheIndex + 1) % cache.length;\n\n    return returnElement;\n  };\n\n  return iter;\n};\n\n\n/**\n * Creates an iterator that counts indefinitely from a starting value.\n * @see http://docs.python.org/2/library/itertools.html#itertools.count\n * @param {number\x3d} opt_start The starting value. Default is 0.\n * @param {number\x3d} opt_step The number to increment with between each call to\n *     next. Negative and floating point numbers are allowed. Default is 1.\n * @return {!goog.iter.Iterator\x3cnumber\x3e} A new iterator that returns the values\n *     in the series.\n */\ngoog.iter.count \x3d function(opt_start, opt_step) {\n  var counter \x3d opt_start || 0;\n  var step \x3d goog.isDef(opt_step) ? opt_step : 1;\n  var iter \x3d new goog.iter.Iterator();\n\n  iter.next \x3d function() {\n    var returnValue \x3d counter;\n    counter +\x3d step;\n    return returnValue;\n  };\n\n  return iter;\n};\n\n\n/**\n * Creates an iterator that returns the same object or value repeatedly.\n * @param {VALUE} value Any object or value to repeat.\n * @return {!goog.iter.Iterator\x3cVALUE\x3e} A new iterator that returns the\n *     repeated value.\n * @template VALUE\n */\ngoog.iter.repeat \x3d function(value) {\n  var iter \x3d new goog.iter.Iterator();\n\n  iter.next \x3d goog.functions.constant(value);\n\n  return iter;\n};\n\n\n/**\n * Creates an iterator that returns running totals from the numbers in\n * {@code iterable}. For example, the array {@code [1, 2, 3, 4, 5]} yields\n * {@code 1 -\x3e 3 -\x3e 6 -\x3e 10 -\x3e 15}.\n * @see http://docs.python.org/3.2/library/itertools.html#itertools.accumulate\n * @param {!goog.iter.Iterable} iterable The iterable of numbers to\n *     accumulate.\n * @return {!goog.iter.Iterator\x3cnumber\x3e} A new iterator that returns the\n *     numbers in the series.\n */\ngoog.iter.accumulate \x3d function(iterable) {\n  var iterator \x3d goog.iter.toIterator(iterable);\n  var total \x3d 0;\n  var iter \x3d new goog.iter.Iterator();\n\n  iter.next \x3d function() {\n    total +\x3d iterator.next();\n    return total;\n  };\n\n  return iter;\n};\n\n\n/**\n * Creates an iterator that returns arrays containing the ith elements from the\n * provided iterables. The returned arrays will be the same size as the number\n * of iterables given in {@code var_args}. Once the shortest iterable is\n * exhausted, subsequent calls to {@code next()} will throw\n * {@code goog.iter.StopIteration}.\n * @see http://docs.python.org/2/library/itertools.html#itertools.izip\n * @param {...!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable} var_args Any\n *     number of iterable objects.\n * @return {!goog.iter.Iterator\x3c!Array\x3cVALUE\x3e\x3e} A new iterator that returns\n *     arrays of elements from the provided iterables.\n * @template VALUE\n */\ngoog.iter.zip \x3d function(var_args) {\n  var args \x3d arguments;\n  var iter \x3d new goog.iter.Iterator();\n\n  if (args.length \x3e 0) {\n    var iterators \x3d goog.array.map(args, goog.iter.toIterator);\n    iter.next \x3d function() {\n      var arr \x3d goog.array.map(iterators, function(it) { return it.next(); });\n      return arr;\n    };\n  }\n\n  return iter;\n};\n\n\n/**\n * Creates an iterator that returns arrays containing the ith elements from the\n * provided iterables. The returned arrays will be the same size as the number\n * of iterables given in {@code var_args}. Shorter iterables will be extended\n * with {@code fillValue}. Once the longest iterable is exhausted, subsequent\n * calls to {@code next()} will throw {@code goog.iter.StopIteration}.\n * @see http://docs.python.org/2/library/itertools.html#itertools.izip_longest\n * @param {VALUE} fillValue The object or value used to fill shorter iterables.\n * @param {...!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable} var_args Any\n *     number of iterable objects.\n * @return {!goog.iter.Iterator\x3c!Array\x3cVALUE\x3e\x3e} A new iterator that returns\n *     arrays of elements from the provided iterables.\n * @template VALUE\n */\ngoog.iter.zipLongest \x3d function(fillValue, var_args) {\n  var args \x3d goog.array.slice(arguments, 1);\n  var iter \x3d new goog.iter.Iterator();\n\n  if (args.length \x3e 0) {\n    var iterators \x3d goog.array.map(args, goog.iter.toIterator);\n\n    iter.next \x3d function() {\n      var iteratorsHaveValues \x3d false;  // false when all iterators are empty.\n      var arr \x3d goog.array.map(iterators, function(it) {\n        var returnValue;\n        try {\n          returnValue \x3d it.next();\n          // Iterator had a value, so we\x27ve not exhausted the iterators.\n          // Set flag accordingly.\n          iteratorsHaveValues \x3d true;\n        } catch (ex) {\n          if (ex !\x3d\x3d goog.iter.StopIteration) {\n            throw ex;\n          }\n          returnValue \x3d fillValue;\n        }\n        return returnValue;\n      });\n\n      if (!iteratorsHaveValues) {\n        throw goog.iter.StopIteration;\n      }\n      return arr;\n    };\n  }\n\n  return iter;\n};\n\n\n/**\n * Creates an iterator that filters {@code iterable} based on a series of\n * {@code selectors}. On each call to {@code next()}, one item is taken from\n * both the {@code iterable} and {@code selectors} iterators. If the item from\n * {@code selectors} evaluates to true, the item from {@code iterable} is given.\n * Otherwise, it is skipped. Once either {@code iterable} or {@code selectors}\n * is exhausted, subsequent calls to {@code next()} will throw\n * {@code goog.iter.StopIteration}.\n * @see http://docs.python.org/2/library/itertools.html#itertools.compress\n * @param {!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable} iterable The\n *     iterable to filter.\n * @param {!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable} selectors An\n *     iterable of items to be evaluated in a boolean context to determine if\n *     the corresponding element in {@code iterable} should be included in the\n *     result.\n * @return {!goog.iter.Iterator\x3cVALUE\x3e} A new iterator that returns the\n *     filtered values.\n * @template VALUE\n */\ngoog.iter.compress \x3d function(iterable, selectors) {\n  var selectorIterator \x3d goog.iter.toIterator(selectors);\n\n  return goog.iter.filter(\n      iterable, function() { return !!selectorIterator.next(); });\n};\n\n\n\n/**\n * Implements the {@code goog.iter.groupBy} iterator.\n * @param {!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable} iterable The\n *     iterable to group.\n * @param {function(VALUE): KEY\x3d} opt_keyFunc  Optional function for\n *     determining the key value for each group in the {@code iterable}. Default\n *     is the identity function.\n * @constructor\n * @extends {goog.iter.Iterator\x3c!Array\x3c?\x3e\x3e}\n * @template KEY, VALUE\n * @private\n */\ngoog.iter.GroupByIterator_ \x3d function(iterable, opt_keyFunc) {\n\n  /**\n   * The iterable to group, coerced to an iterator.\n   * @type {!goog.iter.Iterator}\n   */\n  this.iterator \x3d goog.iter.toIterator(iterable);\n\n  /**\n   * A function for determining the key value for each element in the iterable.\n   * If no function is provided, the identity function is used and returns the\n   * element unchanged.\n   * @type {function(VALUE): KEY}\n   */\n  this.keyFunc \x3d opt_keyFunc || goog.functions.identity;\n\n  /**\n   * The target key for determining the start of a group.\n   * @type {KEY}\n   */\n  this.targetKey;\n\n  /**\n   * The current key visited during iteration.\n   * @type {KEY}\n   */\n  this.currentKey;\n\n  /**\n   * The current value being added to the group.\n   * @type {VALUE}\n   */\n  this.currentValue;\n};\ngoog.inherits(goog.iter.GroupByIterator_, goog.iter.Iterator);\n\n\n/** @override */\ngoog.iter.GroupByIterator_.prototype.next \x3d function() {\n  while (this.currentKey \x3d\x3d this.targetKey) {\n    this.currentValue \x3d this.iterator.next();  // Exits on StopIteration\n    this.currentKey \x3d this.keyFunc(this.currentValue);\n  }\n  this.targetKey \x3d this.currentKey;\n  return [this.currentKey, this.groupItems_(this.targetKey)];\n};\n\n\n/**\n * Performs the grouping of objects using the given key.\n * @param {KEY} targetKey  The target key object for the group.\n * @return {!Array\x3cVALUE\x3e} An array of grouped objects.\n * @private\n */\ngoog.iter.GroupByIterator_.prototype.groupItems_ \x3d function(targetKey) {\n  var arr \x3d [];\n  while (this.currentKey \x3d\x3d targetKey) {\n    arr.push(this.currentValue);\n    try {\n      this.currentValue \x3d this.iterator.next();\n    } catch (ex) {\n      if (ex !\x3d\x3d goog.iter.StopIteration) {\n        throw ex;\n      }\n      break;\n    }\n    this.currentKey \x3d this.keyFunc(this.currentValue);\n  }\n  return arr;\n};\n\n\n/**\n * Creates an iterator that returns arrays containing elements from the\n * {@code iterable} grouped by a key value. For iterables with repeated\n * elements (i.e. sorted according to a particular key function), this function\n * has a {@code uniq}-like effect. For example, grouping the array:\n * {@code [A, B, B, C, C, A]} produces\n * {@code [A, [A]], [B, [B, B]], [C, [C, C]], [A, [A]]}.\n * @see http://docs.python.org/2/library/itertools.html#itertools.groupby\n * @param {!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable} iterable The\n *     iterable to group.\n * @param {function(VALUE): KEY\x3d} opt_keyFunc  Optional function for\n *     determining the key value for each group in the {@code iterable}. Default\n *     is the identity function.\n * @return {!goog.iter.Iterator\x3c!Array\x3c?\x3e\x3e} A new iterator that returns\n *     arrays of consecutive key and groups.\n * @template KEY, VALUE\n */\ngoog.iter.groupBy \x3d function(iterable, opt_keyFunc) {\n  return new goog.iter.GroupByIterator_(iterable, opt_keyFunc);\n};\n\n\n/**\n * Gives an iterator that gives the result of calling the given function\n * \x3ccode\x3ef\x3c/code\x3e with the arguments taken from the next element from\n * \x3ccode\x3eiterable\x3c/code\x3e (the elements are expected to also be iterables).\n *\n * Similar to {@see goog.iter#map} but allows the function to accept multiple\n * arguments from the iterable.\n *\n * @param {!goog.iter.Iterable} iterable The iterable of\n *     iterables to iterate over.\n * @param {function(this:THIS,...*):RESULT} f The function to call for every\n *     element.  This function takes N+2 arguments, where N represents the\n *     number of items from the next element of the iterable. The two\n *     additional arguments passed to the function are undefined and the\n *     iterator itself. The function should return a new value.\n * @param {THIS\x3d} opt_obj The object to be used as the value of \x27this\x27 within\n *     {@code f}.\n * @return {!goog.iter.Iterator\x3cRESULT\x3e} A new iterator that returns the\n *     results of applying the function to each element in the original\n *     iterator.\n * @template THIS, RESULT\n */\ngoog.iter.starMap \x3d function(iterable, f, opt_obj) {\n  var iterator \x3d goog.iter.toIterator(iterable);\n  var iter \x3d new goog.iter.Iterator();\n\n  iter.next \x3d function() {\n    var args \x3d goog.iter.toArray(iterator.next());\n    return f.apply(opt_obj, goog.array.concat(args, undefined, iterator));\n  };\n\n  return iter;\n};\n\n\n/**\n * Returns an array of iterators each of which can iterate over the values in\n * {@code iterable} without advancing the others.\n * @see http://docs.python.org/2/library/itertools.html#itertools.tee\n * @param {!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable} iterable The\n *     iterable to tee.\n * @param {number\x3d} opt_num  The number of iterators to create. Default is 2.\n * @return {!Array\x3cgoog.iter.Iterator\x3cVALUE\x3e\x3e} An array of iterators.\n * @template VALUE\n */\ngoog.iter.tee \x3d function(iterable, opt_num) {\n  var iterator \x3d goog.iter.toIterator(iterable);\n  var num \x3d goog.isNumber(opt_num) ? opt_num : 2;\n  var buffers \x3d\n      goog.array.map(goog.array.range(num), function() { return []; });\n\n  var addNextIteratorValueToBuffers \x3d function() {\n    var val \x3d iterator.next();\n    goog.array.forEach(buffers, function(buffer) { buffer.push(val); });\n  };\n\n  var createIterator \x3d function(buffer) {\n    // Each tee\x27d iterator has an associated buffer (initially empty). When a\n    // tee\x27d iterator\x27s buffer is empty, it calls\n    // addNextIteratorValueToBuffers(), adding the next value to all tee\x27d\n    // iterators\x27 buffers, and then returns that value. This allows each\n    // iterator to be advanced independently.\n    var iter \x3d new goog.iter.Iterator();\n\n    iter.next \x3d function() {\n      if (goog.array.isEmpty(buffer)) {\n        addNextIteratorValueToBuffers();\n      }\n      goog.asserts.assert(!goog.array.isEmpty(buffer));\n      return buffer.shift();\n    };\n\n    return iter;\n  };\n\n  return goog.array.map(buffers, createIterator);\n};\n\n\n/**\n * Creates an iterator that returns arrays containing a count and an element\n * obtained from the given {@code iterable}.\n * @see http://docs.python.org/2/library/functions.html#enumerate\n * @param {!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable} iterable The\n *     iterable to enumerate.\n * @param {number\x3d} opt_start  Optional starting value. Default is 0.\n * @return {!goog.iter.Iterator\x3c!Array\x3c?\x3e\x3e} A new iterator containing\n *     count/item pairs.\n * @template VALUE\n */\ngoog.iter.enumerate \x3d function(iterable, opt_start) {\n  return goog.iter.zip(goog.iter.count(opt_start), iterable);\n};\n\n\n/**\n * Creates an iterator that returns the first {@code limitSize} elements from an\n * iterable. If this number is greater than the number of elements in the\n * iterable, all the elements are returned.\n * @see http://goo.gl/V0sihp Inspired by the limit iterator in Guava.\n * @param {!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable} iterable The\n *     iterable to limit.\n * @param {number} limitSize  The maximum number of elements to return.\n * @return {!goog.iter.Iterator\x3cVALUE\x3e} A new iterator containing\n *     {@code limitSize} elements.\n * @template VALUE\n */\ngoog.iter.limit \x3d function(iterable, limitSize) {\n  goog.asserts.assert(goog.math.isInt(limitSize) \x26\x26 limitSize \x3e\x3d 0);\n\n  var iterator \x3d goog.iter.toIterator(iterable);\n\n  var iter \x3d new goog.iter.Iterator();\n  var remaining \x3d limitSize;\n\n  iter.next \x3d function() {\n    if (remaining-- \x3e 0) {\n      return iterator.next();\n    }\n    throw goog.iter.StopIteration;\n  };\n\n  return iter;\n};\n\n\n/**\n * Creates an iterator that is advanced {@code count} steps ahead. Consumed\n * values are silently discarded. If {@code count} is greater than the number\n * of elements in {@code iterable}, an empty iterator is returned. Subsequent\n * calls to {@code next()} will throw {@code goog.iter.StopIteration}.\n * @param {!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable} iterable The\n *     iterable to consume.\n * @param {number} count  The number of elements to consume from the iterator.\n * @return {!goog.iter.Iterator\x3cVALUE\x3e} An iterator advanced zero or more steps\n *     ahead.\n * @template VALUE\n */\ngoog.iter.consume \x3d function(iterable, count) {\n  goog.asserts.assert(goog.math.isInt(count) \x26\x26 count \x3e\x3d 0);\n\n  var iterator \x3d goog.iter.toIterator(iterable);\n\n  while (count-- \x3e 0) {\n    goog.iter.nextOrValue(iterator, null);\n  }\n\n  return iterator;\n};\n\n\n/**\n * Creates an iterator that returns a range of elements from an iterable.\n * Similar to {@see goog.array#slice} but does not support negative indexes.\n * @param {!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable} iterable The\n *     iterable to slice.\n * @param {number} start  The index of the first element to return.\n * @param {number\x3d} opt_end  The index after the last element to return. If\n *     defined, must be greater than or equal to {@code start}.\n * @return {!goog.iter.Iterator\x3cVALUE\x3e} A new iterator containing a slice of\n *     the original.\n * @template VALUE\n */\ngoog.iter.slice \x3d function(iterable, start, opt_end) {\n  goog.asserts.assert(goog.math.isInt(start) \x26\x26 start \x3e\x3d 0);\n\n  var iterator \x3d goog.iter.consume(iterable, start);\n\n  if (goog.isNumber(opt_end)) {\n    goog.asserts.assert(goog.math.isInt(opt_end) \x26\x26 opt_end \x3e\x3d start);\n    iterator \x3d goog.iter.limit(iterator, opt_end - start /* limitSize */);\n  }\n\n  return iterator;\n};\n\n\n/**\n * Checks an array for duplicate elements.\n * @param {?IArrayLike\x3cVALUE\x3e} arr The array to check for\n *     duplicates.\n * @return {boolean} True, if the array contains duplicates, false otherwise.\n * @private\n * @template VALUE\n */\n// TODO(user): Consider moving this into goog.array as a public function.\ngoog.iter.hasDuplicates_ \x3d function(arr) {\n  var deduped \x3d [];\n  goog.array.removeDuplicates(arr, deduped);\n  return arr.length !\x3d deduped.length;\n};\n\n\n/**\n * Creates an iterator that returns permutations of elements in\n * {@code iterable}.\n *\n * Permutations are obtained by taking the Cartesian product of\n * {@code opt_length} iterables and filtering out those with repeated\n * elements. For example, the permutations of {@code [1,2,3]} are\n * {@code [[1,2,3], [1,3,2], [2,1,3], [2,3,1], [3,1,2], [3,2,1]]}.\n * @see http://docs.python.org/2/library/itertools.html#itertools.permutations\n * @param {!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable} iterable The\n *     iterable from which to generate permutations.\n * @param {number\x3d} opt_length Length of each permutation. If omitted, defaults\n *     to the length of {@code iterable}.\n * @return {!goog.iter.Iterator\x3c!Array\x3cVALUE\x3e\x3e} A new iterator containing the\n *     permutations of {@code iterable}.\n * @template VALUE\n */\ngoog.iter.permutations \x3d function(iterable, opt_length) {\n  var elements \x3d goog.iter.toArray(iterable);\n  var length \x3d goog.isNumber(opt_length) ? opt_length : elements.length;\n\n  var sets \x3d goog.array.repeat(elements, length);\n  var product \x3d goog.iter.product.apply(undefined, sets);\n\n  return goog.iter.filter(\n      product, function(arr) { return !goog.iter.hasDuplicates_(arr); });\n};\n\n\n/**\n * Creates an iterator that returns combinations of elements from\n * {@code iterable}.\n *\n * Combinations are obtained by taking the {@see goog.iter#permutations} of\n * {@code iterable} and filtering those whose elements appear in the order they\n * are encountered in {@code iterable}. For example, the 3-length combinations\n * of {@code [0,1,2,3]} are {@code [[0,1,2], [0,1,3], [0,2,3], [1,2,3]]}.\n * @see http://docs.python.org/2/library/itertools.html#itertools.combinations\n * @param {!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable} iterable The\n *     iterable from which to generate combinations.\n * @param {number} length The length of each combination.\n * @return {!goog.iter.Iterator\x3c!Array\x3cVALUE\x3e\x3e} A new iterator containing\n *     combinations from the {@code iterable}.\n * @template VALUE\n */\ngoog.iter.combinations \x3d function(iterable, length) {\n  var elements \x3d goog.iter.toArray(iterable);\n  var indexes \x3d goog.iter.range(elements.length);\n  var indexIterator \x3d goog.iter.permutations(indexes, length);\n  // sortedIndexIterator will now give arrays of with the given length that\n  // indicate what indexes into \x22elements\x22 should be returned on each iteration.\n  var sortedIndexIterator \x3d goog.iter.filter(\n      indexIterator, function(arr) { return goog.array.isSorted(arr); });\n\n  var iter \x3d new goog.iter.Iterator();\n\n  function getIndexFromElements(index) { return elements[index]; }\n\n  iter.next \x3d function() {\n    return goog.array.map(sortedIndexIterator.next(), getIndexFromElements);\n  };\n\n  return iter;\n};\n\n\n/**\n * Creates an iterator that returns combinations of elements from\n * {@code iterable}, with repeated elements possible.\n *\n * Combinations are obtained by taking the Cartesian product of {@code length}\n * iterables and filtering those whose elements appear in the order they are\n * encountered in {@code iterable}. For example, the 2-length combinations of\n * {@code [1,2,3]} are {@code [[1,1], [1,2], [1,3], [2,2], [2,3], [3,3]]}.\n * @see https://goo.gl/C0yXe4\n * @see https://goo.gl/djOCsk\n * @param {!goog.iter.Iterator\x3cVALUE\x3e|!goog.iter.Iterable} iterable The\n *     iterable to combine.\n * @param {number} length The length of each combination.\n * @return {!goog.iter.Iterator\x3c!Array\x3cVALUE\x3e\x3e} A new iterator containing\n *     combinations from the {@code iterable}.\n * @template VALUE\n */\ngoog.iter.combinationsWithReplacement \x3d function(iterable, length) {\n  var elements \x3d goog.iter.toArray(iterable);\n  var indexes \x3d goog.array.range(elements.length);\n  var sets \x3d goog.array.repeat(indexes, length);\n  var indexIterator \x3d goog.iter.product.apply(undefined, sets);\n  // sortedIndexIterator will now give arrays of with the given length that\n  // indicate what indexes into \x22elements\x22 should be returned on each iteration.\n  var sortedIndexIterator \x3d goog.iter.filter(\n      indexIterator, function(arr) { return goog.array.isSorted(arr); });\n\n  var iter \x3d new goog.iter.Iterator();\n\n  function getIndexFromElements(index) { return elements[index]; }\n\n  iter.next \x3d function() {\n    return goog.array.map(\n        /** @type {!Array\x3cnumber\x3e} */\n        (sortedIndexIterator.next()), getIndexFromElements);\n  };\n\n  return iter;\n};\n");
SHADOW_ENV.evalLoad("goog.structs.map.js", false , "// Copyright 2006 The Closure Library Authors. All Rights Reserved.\n//\n// Licensed under the Apache License, Version 2.0 (the \x22License\x22);\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//      http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an \x22AS-IS\x22 BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\n\n/**\n * @fileoverview Datastructure: Hash Map.\n *\n * @author arv@google.com (Erik Arvidsson)\n *\n * This file contains an implementation of a Map structure. It implements a lot\n * of the methods used in goog.structs so those functions work on hashes. This\n * is best suited for complex key types. For simple keys such as numbers and\n * strings consider using the lighter-weight utilities in goog.object.\n */\n\n\ngoog.provide(\x27goog.structs.Map\x27);\n\ngoog.require(\x27goog.iter.Iterator\x27);\ngoog.require(\x27goog.iter.StopIteration\x27);\ngoog.require(\x27goog.object\x27);\n\n\n\n/**\n * Class for Hash Map datastructure.\n * @param {*\x3d} opt_map Map or Object to initialize the map with.\n * @param {...*} var_args If 2 or more arguments are present then they\n *     will be used as key-value pairs.\n * @constructor\n * @template K, V\n * @deprecated This type is misleading: use ES6 Map instead.\n */\ngoog.structs.Map \x3d function(opt_map, var_args) {\n\n  /**\n   * Underlying JS object used to implement the map.\n   * @private {!Object}\n   */\n  this.map_ \x3d {};\n\n  /**\n   * An array of keys. This is necessary for two reasons:\n   *   1. Iterating the keys using for (var key in this.map_) allocates an\n   *      object for every key in IE which is really bad for IE6 GC perf.\n   *   2. Without a side data structure, we would need to escape all the keys\n   *      as that would be the only way we could tell during iteration if the\n   *      key was an internal key or a property of the object.\n   *\n   * This array can contain deleted keys so it\x27s necessary to check the map\n   * as well to see if the key is still in the map (this doesn\x27t require a\n   * memory allocation in IE).\n   * @private {!Array\x3cstring\x3e}\n   */\n  this.keys_ \x3d [];\n\n  /**\n   * The number of key value pairs in the map.\n   * @private {number}\n   */\n  this.count_ \x3d 0;\n\n  /**\n   * Version used to detect changes while iterating.\n   * @private {number}\n   */\n  this.version_ \x3d 0;\n\n  var argLength \x3d arguments.length;\n\n  if (argLength \x3e 1) {\n    if (argLength % 2) {\n      throw Error(\x27Uneven number of arguments\x27);\n    }\n    for (var i \x3d 0; i \x3c argLength; i +\x3d 2) {\n      this.set(arguments[i], arguments[i + 1]);\n    }\n  } else if (opt_map) {\n    this.addAll(/** @type {Object} */ (opt_map));\n  }\n};\n\n\n/**\n * @return {number} The number of key-value pairs in the map.\n */\ngoog.structs.Map.prototype.getCount \x3d function() {\n  return this.count_;\n};\n\n\n/**\n * Returns the values of the map.\n * @return {!Array\x3cV\x3e} The values in the map.\n */\ngoog.structs.Map.prototype.getValues \x3d function() {\n  this.cleanupKeysArray_();\n\n  var rv \x3d [];\n  for (var i \x3d 0; i \x3c this.keys_.length; i++) {\n    var key \x3d this.keys_[i];\n    rv.push(this.map_[key]);\n  }\n  return rv;\n};\n\n\n/**\n * Returns the keys of the map.\n * @return {!Array\x3cstring\x3e} Array of string values.\n */\ngoog.structs.Map.prototype.getKeys \x3d function() {\n  this.cleanupKeysArray_();\n  return /** @type {!Array\x3cstring\x3e} */ (this.keys_.concat());\n};\n\n\n/**\n * Whether the map contains the given key.\n * @param {*} key The key to check for.\n * @return {boolean} Whether the map contains the key.\n */\ngoog.structs.Map.prototype.containsKey \x3d function(key) {\n  return goog.structs.Map.hasKey_(this.map_, key);\n};\n\n\n/**\n * Whether the map contains the given value. This is O(n).\n * @param {V} val The value to check for.\n * @return {boolean} Whether the map contains the value.\n */\ngoog.structs.Map.prototype.containsValue \x3d function(val) {\n  for (var i \x3d 0; i \x3c this.keys_.length; i++) {\n    var key \x3d this.keys_[i];\n    if (goog.structs.Map.hasKey_(this.map_, key) \x26\x26 this.map_[key] \x3d\x3d val) {\n      return true;\n    }\n  }\n  return false;\n};\n\n\n/**\n * Whether this map is equal to the argument map.\n * @param {goog.structs.Map} otherMap The map against which to test equality.\n * @param {function(V, V): boolean\x3d} opt_equalityFn Optional equality function\n *     to test equality of values. If not specified, this will test whether\n *     the values contained in each map are identical objects.\n * @return {boolean} Whether the maps are equal.\n */\ngoog.structs.Map.prototype.equals \x3d function(otherMap, opt_equalityFn) {\n  if (this \x3d\x3d\x3d otherMap) {\n    return true;\n  }\n\n  if (this.count_ !\x3d otherMap.getCount()) {\n    return false;\n  }\n\n  var equalityFn \x3d opt_equalityFn || goog.structs.Map.defaultEquals;\n\n  this.cleanupKeysArray_();\n  for (var key, i \x3d 0; key \x3d this.keys_[i]; i++) {\n    if (!equalityFn(this.get(key), otherMap.get(key))) {\n      return false;\n    }\n  }\n\n  return true;\n};\n\n\n/**\n * Default equality test for values.\n * @param {*} a The first value.\n * @param {*} b The second value.\n * @return {boolean} Whether a and b reference the same object.\n */\ngoog.structs.Map.defaultEquals \x3d function(a, b) {\n  return a \x3d\x3d\x3d b;\n};\n\n\n/**\n * @return {boolean} Whether the map is empty.\n */\ngoog.structs.Map.prototype.isEmpty \x3d function() {\n  return this.count_ \x3d\x3d 0;\n};\n\n\n/**\n * Removes all key-value pairs from the map.\n */\ngoog.structs.Map.prototype.clear \x3d function() {\n  this.map_ \x3d {};\n  this.keys_.length \x3d 0;\n  this.count_ \x3d 0;\n  this.version_ \x3d 0;\n};\n\n\n/**\n * Removes a key-value pair based on the key. This is O(logN) amortized due to\n * updating the keys array whenever the count becomes half the size of the keys\n * in the keys array.\n * @param {*} key  The key to remove.\n * @return {boolean} Whether object was removed.\n */\ngoog.structs.Map.prototype.remove \x3d function(key) {\n  if (goog.structs.Map.hasKey_(this.map_, key)) {\n    delete this.map_[key];\n    this.count_--;\n    this.version_++;\n\n    // clean up the keys array if the threshold is hit\n    if (this.keys_.length \x3e 2 * this.count_) {\n      this.cleanupKeysArray_();\n    }\n\n    return true;\n  }\n  return false;\n};\n\n\n/**\n * Cleans up the temp keys array by removing entries that are no longer in the\n * map.\n * @private\n */\ngoog.structs.Map.prototype.cleanupKeysArray_ \x3d function() {\n  if (this.count_ !\x3d this.keys_.length) {\n    // First remove keys that are no longer in the map.\n    var srcIndex \x3d 0;\n    var destIndex \x3d 0;\n    while (srcIndex \x3c this.keys_.length) {\n      var key \x3d this.keys_[srcIndex];\n      if (goog.structs.Map.hasKey_(this.map_, key)) {\n        this.keys_[destIndex++] \x3d key;\n      }\n      srcIndex++;\n    }\n    this.keys_.length \x3d destIndex;\n  }\n\n  if (this.count_ !\x3d this.keys_.length) {\n    // If the count still isn\x27t correct, that means we have duplicates. This can\n    // happen when the same key is added and removed multiple times. Now we have\n    // to allocate one extra Object to remove the duplicates. This could have\n    // been done in the first pass, but in the common case, we can avoid\n    // allocating an extra object by only doing this when necessary.\n    var seen \x3d {};\n    var srcIndex \x3d 0;\n    var destIndex \x3d 0;\n    while (srcIndex \x3c this.keys_.length) {\n      var key \x3d this.keys_[srcIndex];\n      if (!(goog.structs.Map.hasKey_(seen, key))) {\n        this.keys_[destIndex++] \x3d key;\n        seen[key] \x3d 1;\n      }\n      srcIndex++;\n    }\n    this.keys_.length \x3d destIndex;\n  }\n};\n\n\n/**\n * Returns the value for the given key.  If the key is not found and the default\n * value is not given this will return {@code undefined}.\n * @param {*} key The key to get the value for.\n * @param {DEFAULT\x3d} opt_val The value to return if no item is found for the\n *     given key, defaults to undefined.\n * @return {V|DEFAULT} The value for the given key.\n * @template DEFAULT\n */\ngoog.structs.Map.prototype.get \x3d function(key, opt_val) {\n  if (goog.structs.Map.hasKey_(this.map_, key)) {\n    return this.map_[key];\n  }\n  return opt_val;\n};\n\n\n/**\n * Adds a key-value pair to the map.\n * @param {*} key The key.\n * @param {V} value The value to add.\n * @return {*} Some subclasses return a value.\n */\ngoog.structs.Map.prototype.set \x3d function(key, value) {\n  if (!(goog.structs.Map.hasKey_(this.map_, key))) {\n    this.count_++;\n    // TODO(johnlenz): This class lies, it claims to return an array of string\n    // keys, but instead returns the original object used.\n    this.keys_.push(/** @type {?} */ (key));\n    // Only change the version if we add a new key.\n    this.version_++;\n  }\n  this.map_[key] \x3d value;\n};\n\n\n/**\n * Adds multiple key-value pairs from another goog.structs.Map or Object.\n * @param {Object} map  Object containing the data to add.\n */\ngoog.structs.Map.prototype.addAll \x3d function(map) {\n  var keys, values;\n  if (map instanceof goog.structs.Map) {\n    keys \x3d map.getKeys();\n    values \x3d map.getValues();\n  } else {\n    keys \x3d goog.object.getKeys(map);\n    values \x3d goog.object.getValues(map);\n  }\n  // we could use goog.array.forEach here but I don\x27t want to introduce that\n  // dependency just for this.\n  for (var i \x3d 0; i \x3c keys.length; i++) {\n    this.set(keys[i], values[i]);\n  }\n};\n\n\n/**\n * Calls the given function on each entry in the map.\n * @param {function(this:T, V, K, goog.structs.Map\x3cK,V\x3e)} f\n * @param {T\x3d} opt_obj The value of \x22this\x22 inside f.\n * @template T\n */\ngoog.structs.Map.prototype.forEach \x3d function(f, opt_obj) {\n  var keys \x3d this.getKeys();\n  for (var i \x3d 0; i \x3c keys.length; i++) {\n    var key \x3d keys[i];\n    var value \x3d this.get(key);\n    f.call(opt_obj, value, key, this);\n  }\n};\n\n\n/**\n * Clones a map and returns a new map.\n * @return {!goog.structs.Map} A new map with the same key-value pairs.\n */\ngoog.structs.Map.prototype.clone \x3d function() {\n  return new goog.structs.Map(this);\n};\n\n\n/**\n * Returns a new map in which all the keys and values are interchanged\n * (keys become values and values become keys). If multiple keys map to the\n * same value, the chosen transposed value is implementation-dependent.\n *\n * It acts very similarly to {goog.object.transpose(Object)}.\n *\n * @return {!goog.structs.Map} The transposed map.\n */\ngoog.structs.Map.prototype.transpose \x3d function() {\n  var transposed \x3d new goog.structs.Map();\n  for (var i \x3d 0; i \x3c this.keys_.length; i++) {\n    var key \x3d this.keys_[i];\n    var value \x3d this.map_[key];\n    transposed.set(value, key);\n  }\n\n  return transposed;\n};\n\n\n/**\n * @return {!Object} Object representation of the map.\n */\ngoog.structs.Map.prototype.toObject \x3d function() {\n  this.cleanupKeysArray_();\n  var obj \x3d {};\n  for (var i \x3d 0; i \x3c this.keys_.length; i++) {\n    var key \x3d this.keys_[i];\n    obj[key] \x3d this.map_[key];\n  }\n  return obj;\n};\n\n\n/**\n * Returns an iterator that iterates over the keys in the map.  Removal of keys\n * while iterating might have undesired side effects.\n * @return {!goog.iter.Iterator} An iterator over the keys in the map.\n */\ngoog.structs.Map.prototype.getKeyIterator \x3d function() {\n  return this.__iterator__(true);\n};\n\n\n/**\n * Returns an iterator that iterates over the values in the map.  Removal of\n * keys while iterating might have undesired side effects.\n * @return {!goog.iter.Iterator} An iterator over the values in the map.\n */\ngoog.structs.Map.prototype.getValueIterator \x3d function() {\n  return this.__iterator__(false);\n};\n\n\n/**\n * Returns an iterator that iterates over the values or the keys in the map.\n * This throws an exception if the map was mutated since the iterator was\n * created.\n * @param {boolean\x3d} opt_keys True to iterate over the keys. False to iterate\n *     over the values.  The default value is false.\n * @return {!goog.iter.Iterator} An iterator over the values or keys in the map.\n */\ngoog.structs.Map.prototype.__iterator__ \x3d function(opt_keys) {\n  // Clean up keys to minimize the risk of iterating over dead keys.\n  this.cleanupKeysArray_();\n\n  var i \x3d 0;\n  var version \x3d this.version_;\n  var selfObj \x3d this;\n\n  var newIter \x3d new goog.iter.Iterator;\n  newIter.next \x3d function() {\n    if (version !\x3d selfObj.version_) {\n      throw Error(\x27The map has changed since the iterator was created\x27);\n    }\n    if (i \x3e\x3d selfObj.keys_.length) {\n      throw goog.iter.StopIteration;\n    }\n    var key \x3d selfObj.keys_[i++];\n    return opt_keys ? key : selfObj.map_[key];\n  };\n  return newIter;\n};\n\n\n/**\n * Safe way to test for hasOwnProperty.  It even allows testing for\n * \x27hasOwnProperty\x27.\n * @param {Object} obj The object to test for presence of the given key.\n * @param {*} key The key to check for.\n * @return {boolean} Whether the object has the key.\n * @private\n */\ngoog.structs.Map.hasKey_ \x3d function(obj, key) {\n  return Object.prototype.hasOwnProperty.call(obj, key);\n};\n");
SHADOW_ENV.evalLoad("goog.uri.utils.js", false , "// Copyright 2008 The Closure Library Authors. All Rights Reserved.\n//\n// Licensed under the Apache License, Version 2.0 (the \x22License\x22);\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//      http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an \x22AS-IS\x22 BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\n\n/**\n * @fileoverview Simple utilities for dealing with URI strings.\n *\n * This is intended to be a lightweight alternative to constructing goog.Uri\n * objects.  Whereas goog.Uri adds several kilobytes to the binary regardless\n * of how much of its functionality you use, this is designed to be a set of\n * mostly-independent utilities so that the compiler includes only what is\n * necessary for the task.  Estimated savings of porting is 5k pre-gzip and\n * 1.5k post-gzip.  To ensure the savings remain, future developers should\n * avoid adding new functionality to existing functions, but instead create\n * new ones and factor out shared code.\n *\n * Many of these utilities have limited functionality, tailored to common\n * cases.  The query parameter utilities assume that the parameter keys are\n * already encoded, since most keys are compile-time alphanumeric strings.  The\n * query parameter mutation utilities also do not tolerate fragment identifiers.\n *\n * By design, these functions can be slower than goog.Uri equivalents.\n * Repeated calls to some of functions may be quadratic in behavior for IE,\n * although the effect is somewhat limited given the 2kb limit.\n *\n * One advantage of the limited functionality here is that this approach is\n * less sensitive to differences in URI encodings than goog.Uri, since these\n * functions operate on strings directly, rather than decoding them and\n * then re-encoding.\n *\n * Uses features of RFC 3986 for parsing/formatting URIs:\n *   http://www.ietf.org/rfc/rfc3986.txt\n *\n * @author gboyer@google.com (Garrett Boyer) - The \x22lightened\x22 design.\n * @author msamuel@google.com (Mike Samuel) - Domain knowledge and regexes.\n */\n\ngoog.provide(\x27goog.uri.utils\x27);\ngoog.provide(\x27goog.uri.utils.ComponentIndex\x27);\ngoog.provide(\x27goog.uri.utils.QueryArray\x27);\ngoog.provide(\x27goog.uri.utils.QueryValue\x27);\ngoog.provide(\x27goog.uri.utils.StandardQueryParam\x27);\n\ngoog.require(\x27goog.array\x27);\ngoog.require(\x27goog.asserts\x27);\ngoog.require(\x27goog.string\x27);\n\n\n/**\n * Character codes inlined to avoid object allocations due to charCode.\n * @enum {number}\n * @private\n */\ngoog.uri.utils.CharCode_ \x3d {\n  AMPERSAND: 38,\n  EQUAL: 61,\n  HASH: 35,\n  QUESTION: 63\n};\n\n\n/**\n * Builds a URI string from already-encoded parts.\n *\n * No encoding is performed.  Any component may be omitted as either null or\n * undefined.\n *\n * @param {?string\x3d} opt_scheme The scheme such as \x27http\x27.\n * @param {?string\x3d} opt_userInfo The user name before the \x27@\x27.\n * @param {?string\x3d} opt_domain The domain such as \x27www.google.com\x27, already\n *     URI-encoded.\n * @param {(string|number|null)\x3d} opt_port The port number.\n * @param {?string\x3d} opt_path The path, already URI-encoded.  If it is not\n *     empty, it must begin with a slash.\n * @param {?string\x3d} opt_queryData The URI-encoded query data.\n * @param {?string\x3d} opt_fragment The URI-encoded fragment identifier.\n * @return {string} The fully combined URI.\n */\ngoog.uri.utils.buildFromEncodedParts \x3d function(\n    opt_scheme, opt_userInfo, opt_domain, opt_port, opt_path, opt_queryData,\n    opt_fragment) {\n  var out \x3d \x27\x27;\n\n  if (opt_scheme) {\n    out +\x3d opt_scheme + \x27:\x27;\n  }\n\n  if (opt_domain) {\n    out +\x3d \x27//\x27;\n\n    if (opt_userInfo) {\n      out +\x3d opt_userInfo + \x27@\x27;\n    }\n\n    out +\x3d opt_domain;\n\n    if (opt_port) {\n      out +\x3d \x27:\x27 + opt_port;\n    }\n  }\n\n  if (opt_path) {\n    out +\x3d opt_path;\n  }\n\n  if (opt_queryData) {\n    out +\x3d \x27?\x27 + opt_queryData;\n  }\n\n  if (opt_fragment) {\n    out +\x3d \x27#\x27 + opt_fragment;\n  }\n\n  return out;\n};\n\n\n/**\n * A regular expression for breaking a URI into its component parts.\n *\n * {@link http://www.ietf.org/rfc/rfc3986.txt} says in Appendix B\n * As the \x22first-match-wins\x22 algorithm is identical to the \x22greedy\x22\n * disambiguation method used by POSIX regular expressions, it is natural and\n * commonplace to use a regular expression for parsing the potential five\n * components of a URI reference.\n *\n * The following line is the regular expression for breaking-down a\n * well-formed URI reference into its components.\n *\n * \x3cpre\x3e\n * ^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?\n *  12            3  4          5       6  7        8 9\n * \x3c/pre\x3e\n *\n * The numbers in the second line above are only to assist readability; they\n * indicate the reference points for each subexpression (i.e., each paired\n * parenthesis). We refer to the value matched for subexpression \x3cn\x3e as $\x3cn\x3e.\n * For example, matching the above expression to\n * \x3cpre\x3e\n *     http://www.ics.uci.edu/pub/ietf/uri/#Related\n * \x3c/pre\x3e\n * results in the following subexpression matches:\n * \x3cpre\x3e\n *    $1 \x3d http:\n *    $2 \x3d http\n *    $3 \x3d //www.ics.uci.edu\n *    $4 \x3d www.ics.uci.edu\n *    $5 \x3d /pub/ietf/uri/\n *    $6 \x3d \x3cundefined\x3e\n *    $7 \x3d \x3cundefined\x3e\n *    $8 \x3d #Related\n *    $9 \x3d Related\n * \x3c/pre\x3e\n * where \x3cundefined\x3e indicates that the component is not present, as is the\n * case for the query component in the above example. Therefore, we can\n * determine the value of the five components as\n * \x3cpre\x3e\n *    scheme    \x3d $2\n *    authority \x3d $4\n *    path      \x3d $5\n *    query     \x3d $7\n *    fragment  \x3d $9\n * \x3c/pre\x3e\n *\n * The regular expression has been modified slightly to expose the\n * userInfo, domain, and port separately from the authority.\n * The modified version yields\n * \x3cpre\x3e\n *    $1 \x3d http              scheme\n *    $2 \x3d \x3cundefined\x3e       userInfo -\\\n *    $3 \x3d www.ics.uci.edu   domain     | authority\n *    $4 \x3d \x3cundefined\x3e       port     -/\n *    $5 \x3d /pub/ietf/uri/    path\n *    $6 \x3d \x3cundefined\x3e       query without ?\n *    $7 \x3d Related           fragment without #\n * \x3c/pre\x3e\n * @type {!RegExp}\n * @private\n */\ngoog.uri.utils.splitRe_ \x3d new RegExp(\n    \x27^\x27 +\n    \x27(?:\x27 +\n    \x27([^:/?#.]+)\x27 +  // scheme - ignore special characters\n                     // used by other URL parts such as :,\n                     // ?, /, #, and .\n    \x27:)?\x27 +\n    \x27(?://\x27 +\n    \x27(?:([^/?#]*)@)?\x27 +  // userInfo\n    \x27([^/#?]*?)\x27 +       // domain\n    \x27(?::([0-9]+))?\x27 +   // port\n    \x27(?\x3d[/#?]|$)\x27 +      // authority-terminating character\n    \x27)?\x27 +\n    \x27([^?#]+)?\x27 +          // path\n    \x27(?:\\\\?([^#]*))?\x27 +    // query\n    \x27(?:#([\\\\s\\\\S]*))?\x27 +  // fragment\n    \x27$\x27);\n\n\n/**\n * The index of each URI component in the return value of goog.uri.utils.split.\n * @enum {number}\n */\ngoog.uri.utils.ComponentIndex \x3d {\n  SCHEME: 1,\n  USER_INFO: 2,\n  DOMAIN: 3,\n  PORT: 4,\n  PATH: 5,\n  QUERY_DATA: 6,\n  FRAGMENT: 7\n};\n\n\n/**\n * Splits a URI into its component parts.\n *\n * Each component can be accessed via the component indices; for example:\n * \x3cpre\x3e\n * goog.uri.utils.split(someStr)[goog.uri.utils.ComponentIndex.QUERY_DATA];\n * \x3c/pre\x3e\n *\n * @param {string} uri The URI string to examine.\n * @return {!Array\x3cstring|undefined\x3e} Each component still URI-encoded.\n *     Each component that is present will contain the encoded value, whereas\n *     components that are not present will be undefined or empty, depending\n *     on the browser\x27s regular expression implementation.  Never null, since\n *     arbitrary strings may still look like path names.\n */\ngoog.uri.utils.split \x3d function(uri) {\n  // See @return comment -- never null.\n  return /** @type {!Array\x3cstring|undefined\x3e} */ (\n      uri.match(goog.uri.utils.splitRe_));\n};\n\n\n/**\n * @param {?string} uri A possibly null string.\n * @param {boolean\x3d} opt_preserveReserved If true, percent-encoding of RFC-3986\n *     reserved characters will not be removed.\n * @return {?string} The string URI-decoded, or null if uri is null.\n * @private\n */\ngoog.uri.utils.decodeIfPossible_ \x3d function(uri, opt_preserveReserved) {\n  if (!uri) {\n    return uri;\n  }\n\n  return opt_preserveReserved ? decodeURI(uri) : decodeURIComponent(uri);\n};\n\n\n/**\n * Gets a URI component by index.\n *\n * It is preferred to use the getPathEncoded() variety of functions ahead,\n * since they are more readable.\n *\n * @param {goog.uri.utils.ComponentIndex} componentIndex The component index.\n * @param {string} uri The URI to examine.\n * @return {?string} The still-encoded component, or null if the component\n *     is not present.\n * @private\n */\ngoog.uri.utils.getComponentByIndex_ \x3d function(componentIndex, uri) {\n  // Convert undefined, null, and empty string into null.\n  return goog.uri.utils.split(uri)[componentIndex] || null;\n};\n\n\n/**\n * @param {string} uri The URI to examine.\n * @return {?string} The protocol or scheme, or null if none.  Does not\n *     include trailing colons or slashes.\n */\ngoog.uri.utils.getScheme \x3d function(uri) {\n  return goog.uri.utils.getComponentByIndex_(\n      goog.uri.utils.ComponentIndex.SCHEME, uri);\n};\n\n\n/**\n * Gets the effective scheme for the URL.  If the URL is relative then the\n * scheme is derived from the page\x27s location.\n * @param {string} uri The URI to examine.\n * @return {string} The protocol or scheme, always lower case.\n */\ngoog.uri.utils.getEffectiveScheme \x3d function(uri) {\n  var scheme \x3d goog.uri.utils.getScheme(uri);\n  if (!scheme \x26\x26 goog.global.self \x26\x26 goog.global.self.location) {\n    var protocol \x3d goog.global.self.location.protocol;\n    scheme \x3d protocol.substr(0, protocol.length - 1);\n  }\n  // NOTE: When called from a web worker in Firefox 3.5, location maybe null.\n  // All other browsers with web workers support self.location from the worker.\n  return scheme ? scheme.toLowerCase() : \x27\x27;\n};\n\n\n/**\n * @param {string} uri The URI to examine.\n * @return {?string} The user name still encoded, or null if none.\n */\ngoog.uri.utils.getUserInfoEncoded \x3d function(uri) {\n  return goog.uri.utils.getComponentByIndex_(\n      goog.uri.utils.ComponentIndex.USER_INFO, uri);\n};\n\n\n/**\n * @param {string} uri The URI to examine.\n * @return {?string} The decoded user info, or null if none.\n */\ngoog.uri.utils.getUserInfo \x3d function(uri) {\n  return goog.uri.utils.decodeIfPossible_(\n      goog.uri.utils.getUserInfoEncoded(uri));\n};\n\n\n/**\n * @param {string} uri The URI to examine.\n * @return {?string} The domain name still encoded, or null if none.\n */\ngoog.uri.utils.getDomainEncoded \x3d function(uri) {\n  return goog.uri.utils.getComponentByIndex_(\n      goog.uri.utils.ComponentIndex.DOMAIN, uri);\n};\n\n\n/**\n * @param {string} uri The URI to examine.\n * @return {?string} The decoded domain, or null if none.\n */\ngoog.uri.utils.getDomain \x3d function(uri) {\n  return goog.uri.utils.decodeIfPossible_(\n      goog.uri.utils.getDomainEncoded(uri), true /* opt_preserveReserved */);\n};\n\n\n/**\n * @param {string} uri The URI to examine.\n * @return {?number} The port number, or null if none.\n */\ngoog.uri.utils.getPort \x3d function(uri) {\n  // Coerce to a number.  If the result of getComponentByIndex_ is null or\n  // non-numeric, the number coersion yields NaN.  This will then return\n  // null for all non-numeric cases (though also zero, which isn\x27t a relevant\n  // port number).\n  return Number(\n             goog.uri.utils.getComponentByIndex_(\n                 goog.uri.utils.ComponentIndex.PORT, uri)) ||\n      null;\n};\n\n\n/**\n * @param {string} uri The URI to examine.\n * @return {?string} The path still encoded, or null if none. Includes the\n *     leading slash, if any.\n */\ngoog.uri.utils.getPathEncoded \x3d function(uri) {\n  return goog.uri.utils.getComponentByIndex_(\n      goog.uri.utils.ComponentIndex.PATH, uri);\n};\n\n\n/**\n * @param {string} uri The URI to examine.\n * @return {?string} The decoded path, or null if none.  Includes the leading\n *     slash, if any.\n */\ngoog.uri.utils.getPath \x3d function(uri) {\n  return goog.uri.utils.decodeIfPossible_(\n      goog.uri.utils.getPathEncoded(uri), true /* opt_preserveReserved */);\n};\n\n\n/**\n * @param {string} uri The URI to examine.\n * @return {?string} The query data still encoded, or null if none.  Does not\n *     include the question mark itself.\n */\ngoog.uri.utils.getQueryData \x3d function(uri) {\n  return goog.uri.utils.getComponentByIndex_(\n      goog.uri.utils.ComponentIndex.QUERY_DATA, uri);\n};\n\n\n/**\n * @param {string} uri The URI to examine.\n * @return {?string} The fragment identifier, or null if none.  Does not\n *     include the hash mark itself.\n */\ngoog.uri.utils.getFragmentEncoded \x3d function(uri) {\n  // The hash mark may not appear in any other part of the URL.\n  var hashIndex \x3d uri.indexOf(\x27#\x27);\n  return hashIndex \x3c 0 ? null : uri.substr(hashIndex + 1);\n};\n\n\n/**\n * @param {string} uri The URI to examine.\n * @param {?string} fragment The encoded fragment identifier, or null if none.\n *     Does not include the hash mark itself.\n * @return {string} The URI with the fragment set.\n */\ngoog.uri.utils.setFragmentEncoded \x3d function(uri, fragment) {\n  return goog.uri.utils.removeFragment(uri) + (fragment ? \x27#\x27 + fragment : \x27\x27);\n};\n\n\n/**\n * @param {string} uri The URI to examine.\n * @return {?string} The decoded fragment identifier, or null if none.  Does\n *     not include the hash mark.\n */\ngoog.uri.utils.getFragment \x3d function(uri) {\n  return goog.uri.utils.decodeIfPossible_(\n      goog.uri.utils.getFragmentEncoded(uri));\n};\n\n\n/**\n * Extracts everything up to the port of the URI.\n * @param {string} uri The URI string.\n * @return {string} Everything up to and including the port.\n */\ngoog.uri.utils.getHost \x3d function(uri) {\n  var pieces \x3d goog.uri.utils.split(uri);\n  return goog.uri.utils.buildFromEncodedParts(\n      pieces[goog.uri.utils.ComponentIndex.SCHEME],\n      pieces[goog.uri.utils.ComponentIndex.USER_INFO],\n      pieces[goog.uri.utils.ComponentIndex.DOMAIN],\n      pieces[goog.uri.utils.ComponentIndex.PORT]);\n};\n\n\n/**\n * Returns the origin for a given URL.\n * @param {string} uri The URI string.\n * @return {string} Everything up to and including the port.\n */\ngoog.uri.utils.getOrigin \x3d function(uri) {\n  var pieces \x3d goog.uri.utils.split(uri);\n  return goog.uri.utils.buildFromEncodedParts(\n      pieces[goog.uri.utils.ComponentIndex.SCHEME], null /* opt_userInfo */,\n      pieces[goog.uri.utils.ComponentIndex.DOMAIN],\n      pieces[goog.uri.utils.ComponentIndex.PORT]);\n};\n\n\n/**\n * Extracts the path of the URL and everything after.\n * @param {string} uri The URI string.\n * @return {string} The URI, starting at the path and including the query\n *     parameters and fragment identifier.\n */\ngoog.uri.utils.getPathAndAfter \x3d function(uri) {\n  var pieces \x3d goog.uri.utils.split(uri);\n  return goog.uri.utils.buildFromEncodedParts(\n      null, null, null, null, pieces[goog.uri.utils.ComponentIndex.PATH],\n      pieces[goog.uri.utils.ComponentIndex.QUERY_DATA],\n      pieces[goog.uri.utils.ComponentIndex.FRAGMENT]);\n};\n\n\n/**\n * Gets the URI with the fragment identifier removed.\n * @param {string} uri The URI to examine.\n * @return {string} Everything preceding the hash mark.\n */\ngoog.uri.utils.removeFragment \x3d function(uri) {\n  // The hash mark may not appear in any other part of the URL.\n  var hashIndex \x3d uri.indexOf(\x27#\x27);\n  return hashIndex \x3c 0 ? uri : uri.substr(0, hashIndex);\n};\n\n\n/**\n * Ensures that two URI\x27s have the exact same domain, scheme, and port.\n *\n * Unlike the version in goog.Uri, this checks protocol, and therefore is\n * suitable for checking against the browser\x27s same-origin policy.\n *\n * @param {string} uri1 The first URI.\n * @param {string} uri2 The second URI.\n * @return {boolean} Whether they have the same scheme, domain and port.\n */\ngoog.uri.utils.haveSameDomain \x3d function(uri1, uri2) {\n  var pieces1 \x3d goog.uri.utils.split(uri1);\n  var pieces2 \x3d goog.uri.utils.split(uri2);\n  return pieces1[goog.uri.utils.ComponentIndex.DOMAIN] \x3d\x3d\n      pieces2[goog.uri.utils.ComponentIndex.DOMAIN] \x26\x26\n      pieces1[goog.uri.utils.ComponentIndex.SCHEME] \x3d\x3d\n      pieces2[goog.uri.utils.ComponentIndex.SCHEME] \x26\x26\n      pieces1[goog.uri.utils.ComponentIndex.PORT] \x3d\x3d\n      pieces2[goog.uri.utils.ComponentIndex.PORT];\n};\n\n\n/**\n * Asserts that there are no fragment or query identifiers, only in uncompiled\n * mode.\n * @param {string} uri The URI to examine.\n * @private\n */\ngoog.uri.utils.assertNoFragmentsOrQueries_ \x3d function(uri) {\n  goog.asserts.assert(\n      uri.indexOf(\x27#\x27) \x3c 0 \x26\x26 uri.indexOf(\x27?\x27) \x3c 0,\n      \x27goog.uri.utils: Fragment or query identifiers are not supported: [%s]\x27,\n      uri);\n};\n\n\n/**\n * Supported query parameter values by the parameter serializing utilities.\n *\n * If a value is null or undefined, the key-value pair is skipped, as an easy\n * way to omit parameters conditionally.  Non-array parameters are converted\n * to a string and URI encoded.  Array values are expanded into multiple\n * \x26key\x3dvalue pairs, with each element stringized and URI-encoded.\n *\n * @typedef {*}\n */\ngoog.uri.utils.QueryValue;\n\n\n/**\n * An array representing a set of query parameters with alternating keys\n * and values.\n *\n * Keys are assumed to be URI encoded already and live at even indices.  See\n * goog.uri.utils.QueryValue for details on how parameter values are encoded.\n *\n * Example:\n * \x3cpre\x3e\n * var data \x3d [\n *   // Simple param: ?name\x3dBobBarker\n *   \x27name\x27, \x27BobBarker\x27,\n *   // Conditional param -- may be omitted entirely.\n *   \x27specialDietaryNeeds\x27, hasDietaryNeeds() ? getDietaryNeeds() : null,\n *   // Multi-valued param: \x26house\x3dLosAngeles\x26house\x3dNewYork\x26house\x3dnull\n *   \x27house\x27, [\x27LosAngeles\x27, \x27NewYork\x27, null]\n * ];\n * \x3c/pre\x3e\n *\n * @typedef {!Array\x3cstring|goog.uri.utils.QueryValue\x3e}\n */\ngoog.uri.utils.QueryArray;\n\n\n/**\n * Parses encoded query parameters and calls callback function for every\n * parameter found in the string.\n *\n * Missing value of parameter (e.g. \u201c\u2026\x26key\x26\u2026\u201d) is treated as if the value was an\n * empty string.  Keys may be empty strings (e.g. \u201c\u2026\x26\x3dvalue\x26\u2026\u201d) which also means\n * that \u201c\u2026\x26\x3d\x26\u2026\u201d and \u201c\u2026\x26\x26\u2026\u201d will result in an empty key and value.\n *\n * @param {string} encodedQuery Encoded query string excluding question mark at\n *     the beginning.\n * @param {function(string, string)} callback Function called for every\n *     parameter found in query string.  The first argument (name) will not be\n *     urldecoded (so the function is consistent with buildQueryData), but the\n *     second will.  If the parameter has no value (i.e. \u201c\x3d\u201d was not present)\n *     the second argument (value) will be an empty string.\n */\ngoog.uri.utils.parseQueryData \x3d function(encodedQuery, callback) {\n  if (!encodedQuery) {\n    return;\n  }\n  var pairs \x3d encodedQuery.split(\x27\x26\x27);\n  for (var i \x3d 0; i \x3c pairs.length; i++) {\n    var indexOfEquals \x3d pairs[i].indexOf(\x27\x3d\x27);\n    var name \x3d null;\n    var value \x3d null;\n    if (indexOfEquals \x3e\x3d 0) {\n      name \x3d pairs[i].substring(0, indexOfEquals);\n      value \x3d pairs[i].substring(indexOfEquals + 1);\n    } else {\n      name \x3d pairs[i];\n    }\n    callback(name, value ? goog.string.urlDecode(value) : \x27\x27);\n  }\n};\n\n\n/**\n * Split the URI into 3 parts where the [1] is the queryData without a leading\n * \x27?\x27. For example, the URI http://foo.com/bar?a\x3db#abc returns\n * [\x27http://foo.com/bar\x27,\x27a\x3db\x27,\x27#abc\x27].\n * @param {string} uri The URI to parse.\n * @return {!Array\x3cstring\x3e} An array representation of uri of length 3 where the\n *     middle value is the queryData without a leading \x27?\x27.\n * @private\n */\ngoog.uri.utils.splitQueryData_ \x3d function(uri) {\n  // Find the query data and and hash.\n  var hashIndex \x3d uri.indexOf(\x27#\x27);\n  if (hashIndex \x3c 0) {\n    hashIndex \x3d uri.length;\n  }\n  var questionIndex \x3d uri.indexOf(\x27?\x27);\n  var queryData;\n  if (questionIndex \x3c 0 || questionIndex \x3e hashIndex) {\n    questionIndex \x3d hashIndex;\n    queryData \x3d \x27\x27;\n  } else {\n    queryData \x3d uri.substring(questionIndex + 1, hashIndex);\n  }\n  return [uri.substr(0, questionIndex), queryData, uri.substr(hashIndex)];\n};\n\n\n/**\n * Join an array created by splitQueryData_ back into a URI.\n * @param {!Array\x3cstring\x3e} parts A URI in the form generated by splitQueryData_.\n * @return {string} The joined URI.\n * @private\n */\ngoog.uri.utils.joinQueryData_ \x3d function(parts) {\n  return parts[0] + (parts[1] ? \x27?\x27 + parts[1] : \x27\x27) + parts[2];\n};\n\n\n/**\n * @param {string} queryData\n * @param {string} newData\n * @return {string}\n * @private\n */\ngoog.uri.utils.appendQueryData_ \x3d function(queryData, newData) {\n  if (!newData) {\n    return queryData;\n  }\n  return queryData ? queryData + \x27\x26\x27 + newData : newData;\n};\n\n\n/**\n * @param {string} uri\n * @param {string} queryData\n * @return {string}\n * @private\n */\ngoog.uri.utils.appendQueryDataToUri_ \x3d function(uri, queryData) {\n  if (!queryData) {\n    return uri;\n  }\n  var parts \x3d goog.uri.utils.splitQueryData_(uri);\n  parts[1] \x3d goog.uri.utils.appendQueryData_(parts[1], queryData);\n  return goog.uri.utils.joinQueryData_(parts);\n};\n\n\n/**\n * Appends key\x3dvalue pairs to an array, supporting multi-valued objects.\n * @param {*} key The key prefix.\n * @param {goog.uri.utils.QueryValue} value The value to serialize.\n * @param {!Array\x3cstring\x3e} pairs The array to which the \x27key\x3dvalue\x27 strings\n *     should be appended.\n * @private\n */\ngoog.uri.utils.appendKeyValuePairs_ \x3d function(key, value, pairs) {\n  goog.asserts.assertString(key);\n  if (goog.isArray(value)) {\n    // Convince the compiler it\x27s an array.\n    goog.asserts.assertArray(value);\n    for (var j \x3d 0; j \x3c value.length; j++) {\n      // Convert to string explicitly, to short circuit the null and array\n      // logic in this function -- this ensures that null and undefined get\n      // written as literal \x27null\x27 and \x27undefined\x27, and arrays don\x27t get\n      // expanded out but instead encoded in the default way.\n      goog.uri.utils.appendKeyValuePairs_(key, String(value[j]), pairs);\n    }\n  } else if (value !\x3d null) {\n    // Skip a top-level null or undefined entirely.\n    pairs.push(\n        key +\n        // Check for empty string. Zero gets encoded into the url as literal\n        // strings.  For empty string, skip the equal sign, to be consistent\n        // with UriBuilder.java.\n        (value \x3d\x3d\x3d \x27\x27 ? \x27\x27 : \x27\x3d\x27 + goog.string.urlEncode(value)));\n  }\n};\n\n\n/**\n * Builds a query data string from a sequence of alternating keys and values.\n * Currently generates \x22\x26key\x26\x22 for empty args.\n *\n * @param {!IArrayLike\x3cstring|goog.uri.utils.QueryValue\x3e} keysAndValues\n *     Alternating keys and values. See the QueryArray typedef.\n * @param {number\x3d} opt_startIndex A start offset into the arary, defaults to 0.\n * @return {string} The encoded query string, in the form \x27a\x3d1\x26b\x3d2\x27.\n */\ngoog.uri.utils.buildQueryData \x3d function(keysAndValues, opt_startIndex) {\n  goog.asserts.assert(\n      Math.max(keysAndValues.length - (opt_startIndex || 0), 0) % 2 \x3d\x3d 0,\n      \x27goog.uri.utils: Key/value lists must be even in length.\x27);\n\n  var params \x3d [];\n  for (var i \x3d opt_startIndex || 0; i \x3c keysAndValues.length; i +\x3d 2) {\n    var key \x3d /** @type {string} */ (keysAndValues[i]);\n    goog.uri.utils.appendKeyValuePairs_(key, keysAndValues[i + 1], params);\n  }\n  return params.join(\x27\x26\x27);\n};\n\n\n/**\n * Builds a query data string from a map.\n * Currently generates \x22\x26key\x26\x22 for empty args.\n *\n * @param {!Object\x3cstring, goog.uri.utils.QueryValue\x3e} map An object where keys\n *     are URI-encoded parameter keys, and the values are arbitrary types\n *     or arrays. Keys with a null value are dropped.\n * @return {string} The encoded query string, in the form \x27a\x3d1\x26b\x3d2\x27.\n */\ngoog.uri.utils.buildQueryDataFromMap \x3d function(map) {\n  var params \x3d [];\n  for (var key in map) {\n    goog.uri.utils.appendKeyValuePairs_(key, map[key], params);\n  }\n  return params.join(\x27\x26\x27);\n};\n\n\n/**\n * Appends URI parameters to an existing URI.\n *\n * The variable arguments may contain alternating keys and values.  Keys are\n * assumed to be already URI encoded.  The values should not be URI-encoded,\n * and will instead be encoded by this function.\n * \x3cpre\x3e\n * appendParams(\x27http://www.foo.com?existing\x3dtrue\x27,\n *     \x27key1\x27, \x27value1\x27,\n *     \x27key2\x27, \x27value?willBeEncoded\x27,\n *     \x27key3\x27, [\x27valueA\x27, \x27valueB\x27, \x27valueC\x27],\n *     \x27key4\x27, null);\n * result: \x27http://www.foo.com?existing\x3dtrue\x26\x27 +\n *     \x27key1\x3dvalue1\x26\x27 +\n *     \x27key2\x3dvalue%3FwillBeEncoded\x26\x27 +\n *     \x27key3\x3dvalueA\x26key3\x3dvalueB\x26key3\x3dvalueC\x27\n * \x3c/pre\x3e\n *\n * A single call to this function will not exhibit quadratic behavior in IE,\n * whereas multiple repeated calls may, although the effect is limited by\n * fact that URL\x27s generally can\x27t exceed 2kb.\n *\n * @param {string} uri The original URI, which may already have query data.\n * @param {...(goog.uri.utils.QueryArray|goog.uri.utils.QueryValue)}\n * var_args\n *     An array or argument list conforming to goog.uri.utils.QueryArray.\n * @return {string} The URI with all query parameters added.\n */\ngoog.uri.utils.appendParams \x3d function(uri, var_args) {\n  var queryData \x3d arguments.length \x3d\x3d 2 ?\n      goog.uri.utils.buildQueryData(arguments[1], 0) :\n      goog.uri.utils.buildQueryData(arguments, 1);\n  return goog.uri.utils.appendQueryDataToUri_(uri, queryData);\n};\n\n\n/**\n * Appends query parameters from a map.\n *\n * @param {string} uri The original URI, which may already have query data.\n * @param {!Object\x3cgoog.uri.utils.QueryValue\x3e} map An object where keys are\n *     URI-encoded parameter keys, and the values are arbitrary types or arrays.\n *     Keys with a null value are dropped.\n * @return {string} The new parameters.\n */\ngoog.uri.utils.appendParamsFromMap \x3d function(uri, map) {\n  var queryData \x3d goog.uri.utils.buildQueryDataFromMap(map);\n  return goog.uri.utils.appendQueryDataToUri_(uri, queryData);\n};\n\n\n/**\n * Appends a single URI parameter.\n *\n * Repeated calls to this can exhibit quadratic behavior in IE6 due to the\n * way string append works, though it should be limited given the 2kb limit.\n *\n * @param {string} uri The original URI, which may already have query data.\n * @param {string} key The key, which must already be URI encoded.\n * @param {*\x3d} opt_value The value, which will be stringized and encoded\n *     (assumed not already to be encoded).  If omitted, undefined, or null, the\n *     key will be added as a valueless parameter.\n * @return {string} The URI with the query parameter added.\n */\ngoog.uri.utils.appendParam \x3d function(uri, key, opt_value) {\n  var value \x3d goog.isDefAndNotNull(opt_value) ?\n      \x27\x3d\x27 + goog.string.urlEncode(opt_value) :\n      \x27\x27;\n  return goog.uri.utils.appendQueryDataToUri_(uri, key + value);\n};\n\n\n/**\n * Finds the next instance of a query parameter with the specified name.\n *\n * Does not instantiate any objects.\n *\n * @param {string} uri The URI to search.  May contain a fragment identifier\n *     if opt_hashIndex is specified.\n * @param {number} startIndex The index to begin searching for the key at.  A\n *     match may be found even if this is one character after the ampersand.\n * @param {string} keyEncoded The URI-encoded key.\n * @param {number} hashOrEndIndex Index to stop looking at.  If a hash\n *     mark is present, it should be its index, otherwise it should be the\n *     length of the string.\n * @return {number} The position of the first character in the key\x27s name,\n *     immediately after either a question mark or a dot.\n * @private\n */\ngoog.uri.utils.findParam_ \x3d function(\n    uri, startIndex, keyEncoded, hashOrEndIndex) {\n  var index \x3d startIndex;\n  var keyLength \x3d keyEncoded.length;\n\n  // Search for the key itself and post-filter for surronuding punctuation,\n  // rather than expensively building a regexp.\n  while ((index \x3d uri.indexOf(keyEncoded, index)) \x3e\x3d 0 \x26\x26\n         index \x3c hashOrEndIndex) {\n    var precedingChar \x3d uri.charCodeAt(index - 1);\n    // Ensure that the preceding character is \x27\x26\x27 or \x27?\x27.\n    if (precedingChar \x3d\x3d goog.uri.utils.CharCode_.AMPERSAND ||\n        precedingChar \x3d\x3d goog.uri.utils.CharCode_.QUESTION) {\n      // Ensure the following character is \x27\x26\x27, \x27\x3d\x27, \x27#\x27, or NaN\n      // (end of string).\n      var followingChar \x3d uri.charCodeAt(index + keyLength);\n      if (!followingChar || followingChar \x3d\x3d goog.uri.utils.CharCode_.EQUAL ||\n          followingChar \x3d\x3d goog.uri.utils.CharCode_.AMPERSAND ||\n          followingChar \x3d\x3d goog.uri.utils.CharCode_.HASH) {\n        return index;\n      }\n    }\n    index +\x3d keyLength + 1;\n  }\n\n  return -1;\n};\n\n\n/**\n * Regular expression for finding a hash mark or end of string.\n * @type {RegExp}\n * @private\n */\ngoog.uri.utils.hashOrEndRe_ \x3d /#|$/;\n\n\n/**\n * Determines if the URI contains a specific key.\n *\n * Performs no object instantiations.\n *\n * @param {string} uri The URI to process.  May contain a fragment\n *     identifier.\n * @param {string} keyEncoded The URI-encoded key.  Case-sensitive.\n * @return {boolean} Whether the key is present.\n */\ngoog.uri.utils.hasParam \x3d function(uri, keyEncoded) {\n  return goog.uri.utils.findParam_(\n             uri, 0, keyEncoded, uri.search(goog.uri.utils.hashOrEndRe_)) \x3e\x3d 0;\n};\n\n\n/**\n * Gets the first value of a query parameter.\n * @param {string} uri The URI to process.  May contain a fragment.\n * @param {string} keyEncoded The URI-encoded key.  Case-sensitive.\n * @return {?string} The first value of the parameter (URI-decoded), or null\n *     if the parameter is not found.\n */\ngoog.uri.utils.getParamValue \x3d function(uri, keyEncoded) {\n  var hashOrEndIndex \x3d uri.search(goog.uri.utils.hashOrEndRe_);\n  var foundIndex \x3d\n      goog.uri.utils.findParam_(uri, 0, keyEncoded, hashOrEndIndex);\n\n  if (foundIndex \x3c 0) {\n    return null;\n  } else {\n    var endPosition \x3d uri.indexOf(\x27\x26\x27, foundIndex);\n    if (endPosition \x3c 0 || endPosition \x3e hashOrEndIndex) {\n      endPosition \x3d hashOrEndIndex;\n    }\n    // Progress forth to the end of the \x22key\x3d\x22 or \x22key\x26\x22 substring.\n    foundIndex +\x3d keyEncoded.length + 1;\n    // Use substr, because it (unlike substring) will return empty string\n    // if foundIndex \x3e endPosition.\n    return goog.string.urlDecode(\n        uri.substr(foundIndex, endPosition - foundIndex));\n  }\n};\n\n\n/**\n * Gets all values of a query parameter.\n * @param {string} uri The URI to process.  May contain a fragment.\n * @param {string} keyEncoded The URI-encoded key.  Case-sensitive.\n * @return {!Array\x3cstring\x3e} All URI-decoded values with the given key.\n *     If the key is not found, this will have length 0, but never be null.\n */\ngoog.uri.utils.getParamValues \x3d function(uri, keyEncoded) {\n  var hashOrEndIndex \x3d uri.search(goog.uri.utils.hashOrEndRe_);\n  var position \x3d 0;\n  var foundIndex;\n  var result \x3d [];\n\n  while ((foundIndex \x3d goog.uri.utils.findParam_(\n              uri, position, keyEncoded, hashOrEndIndex)) \x3e\x3d 0) {\n    // Find where this parameter ends, either the \x27\x26\x27 or the end of the\n    // query parameters.\n    position \x3d uri.indexOf(\x27\x26\x27, foundIndex);\n    if (position \x3c 0 || position \x3e hashOrEndIndex) {\n      position \x3d hashOrEndIndex;\n    }\n\n    // Progress forth to the end of the \x22key\x3d\x22 or \x22key\x26\x22 substring.\n    foundIndex +\x3d keyEncoded.length + 1;\n    // Use substr, because it (unlike substring) will return empty string\n    // if foundIndex \x3e position.\n    result.push(\n        goog.string.urlDecode(uri.substr(foundIndex, position - foundIndex)));\n  }\n\n  return result;\n};\n\n\n/**\n * Regexp to find trailing question marks and ampersands.\n * @type {RegExp}\n * @private\n */\ngoog.uri.utils.trailingQueryPunctuationRe_ \x3d /[?\x26]($|#)/;\n\n\n/**\n * Removes all instances of a query parameter.\n * @param {string} uri The URI to process.  Must not contain a fragment.\n * @param {string} keyEncoded The URI-encoded key.\n * @return {string} The URI with all instances of the parameter removed.\n */\ngoog.uri.utils.removeParam \x3d function(uri, keyEncoded) {\n  var hashOrEndIndex \x3d uri.search(goog.uri.utils.hashOrEndRe_);\n  var position \x3d 0;\n  var foundIndex;\n  var buffer \x3d [];\n\n  // Look for a query parameter.\n  while ((foundIndex \x3d goog.uri.utils.findParam_(\n              uri, position, keyEncoded, hashOrEndIndex)) \x3e\x3d 0) {\n    // Get the portion of the query string up to, but not including, the ?\n    // or \x26 starting the parameter.\n    buffer.push(uri.substring(position, foundIndex));\n    // Progress to immediately after the \x27\x26\x27.  If not found, go to the end.\n    // Avoid including the hash mark.\n    position \x3d Math.min(\n        (uri.indexOf(\x27\x26\x27, foundIndex) + 1) || hashOrEndIndex, hashOrEndIndex);\n  }\n\n  // Append everything that is remaining.\n  buffer.push(uri.substr(position));\n\n  // Join the buffer, and remove trailing punctuation that remains.\n  return buffer.join(\x27\x27).replace(\n      goog.uri.utils.trailingQueryPunctuationRe_, \x27$1\x27);\n};\n\n\n/**\n * Replaces all existing definitions of a parameter with a single definition.\n *\n * Repeated calls to this can exhibit quadratic behavior due to the need to\n * find existing instances and reconstruct the string, though it should be\n * limited given the 2kb limit.  Consider using appendParams or setParamsFromMap\n * to update multiple parameters in bulk.\n *\n * @param {string} uri The original URI, which may already have query data.\n * @param {string} keyEncoded The key, which must already be URI encoded.\n * @param {*} value The value, which will be stringized and encoded (assumed\n *     not already to be encoded).\n * @return {string} The URI with the query parameter added.\n */\ngoog.uri.utils.setParam \x3d function(uri, keyEncoded, value) {\n  return goog.uri.utils.appendParam(\n      goog.uri.utils.removeParam(uri, keyEncoded), keyEncoded, value);\n};\n\n\n/**\n * Effeciently set or remove multiple query parameters in a URI. Order of\n * unchanged parameters will not be modified, all updated parameters will be\n * appended to the end of the query. Params with values of null or undefined are\n * removed.\n *\n * @param {string} uri The URI to process.\n * @param {!Object\x3cstring, goog.uri.utils.QueryValue\x3e} params A list of\n *     parameters to update. If null or undefined, the param will be removed.\n * @return {string} An updated URI where the query data has been updated with\n *     the params.\n */\ngoog.uri.utils.setParamsFromMap \x3d function(uri, params) {\n  var parts \x3d goog.uri.utils.splitQueryData_(uri);\n  var queryData \x3d parts[1];\n  var buffer \x3d [];\n  if (queryData) {\n    goog.array.forEach(queryData.split(\x27\x26\x27), function(pair) {\n      var indexOfEquals \x3d pair.indexOf(\x27\x3d\x27);\n      var name \x3d indexOfEquals \x3e\x3d 0 ? pair.substr(0, indexOfEquals) : pair;\n      if (!params.hasOwnProperty(name)) {\n        buffer.push(pair);\n      }\n    });\n  }\n  parts[1] \x3d goog.uri.utils.appendQueryData_(\n      buffer.join(\x27\x26\x27), goog.uri.utils.buildQueryDataFromMap(params));\n  return goog.uri.utils.joinQueryData_(parts);\n};\n\n\n/**\n * Generates a URI path using a given URI and a path with checks to\n * prevent consecutive \x22//\x22. The baseUri passed in must not contain\n * query or fragment identifiers. The path to append may not contain query or\n * fragment identifiers.\n *\n * @param {string} baseUri URI to use as the base.\n * @param {string} path Path to append.\n * @return {string} Updated URI.\n */\ngoog.uri.utils.appendPath \x3d function(baseUri, path) {\n  goog.uri.utils.assertNoFragmentsOrQueries_(baseUri);\n\n  // Remove any trailing \x27/\x27\n  if (goog.string.endsWith(baseUri, \x27/\x27)) {\n    baseUri \x3d baseUri.substr(0, baseUri.length - 1);\n  }\n  // Remove any leading \x27/\x27\n  if (goog.string.startsWith(path, \x27/\x27)) {\n    path \x3d path.substr(1);\n  }\n  return goog.string.buildString(baseUri, \x27/\x27, path);\n};\n\n\n/**\n * Replaces the path.\n * @param {string} uri URI to use as the base.\n * @param {string} path New path.\n * @return {string} Updated URI.\n */\ngoog.uri.utils.setPath \x3d function(uri, path) {\n  // Add any missing \x27/\x27.\n  if (!goog.string.startsWith(path, \x27/\x27)) {\n    path \x3d \x27/\x27 + path;\n  }\n  var parts \x3d goog.uri.utils.split(uri);\n  return goog.uri.utils.buildFromEncodedParts(\n      parts[goog.uri.utils.ComponentIndex.SCHEME],\n      parts[goog.uri.utils.ComponentIndex.USER_INFO],\n      parts[goog.uri.utils.ComponentIndex.DOMAIN],\n      parts[goog.uri.utils.ComponentIndex.PORT], path,\n      parts[goog.uri.utils.ComponentIndex.QUERY_DATA],\n      parts[goog.uri.utils.ComponentIndex.FRAGMENT]);\n};\n\n\n/**\n * Standard supported query parameters.\n * @enum {string}\n */\ngoog.uri.utils.StandardQueryParam \x3d {\n\n  /** Unused parameter for unique-ifying. */\n  RANDOM: \x27zx\x27\n};\n\n\n/**\n * Sets the zx parameter of a URI to a random value.\n * @param {string} uri Any URI.\n * @return {string} That URI with the \x22zx\x22 parameter added or replaced to\n *     contain a random string.\n */\ngoog.uri.utils.makeUnique \x3d function(uri) {\n  return goog.uri.utils.setParam(\n      uri, goog.uri.utils.StandardQueryParam.RANDOM,\n      goog.string.getRandomString());\n};\n");
SHADOW_ENV.evalLoad("goog.uri.uri.js", false , "// Copyright 2006 The Closure Library Authors. All Rights Reserved.\n//\n// Licensed under the Apache License, Version 2.0 (the \x22License\x22);\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//      http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an \x22AS-IS\x22 BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\n\n/**\n * @fileoverview Class for parsing and formatting URIs.\n *\n * Use goog.Uri(string) to parse a URI string.  Use goog.Uri.create(...) to\n * create a new instance of the goog.Uri object from Uri parts.\n *\n * e.g: \x3ccode\x3evar myUri \x3d new goog.Uri(window.location);\x3c/code\x3e\n *\n * Implements RFC 3986 for parsing/formatting URIs.\n * http://www.ietf.org/rfc/rfc3986.txt\n *\n * Some changes have been made to the interface (more like .NETs), though the\n * internal representation is now of un-encoded parts, this will change the\n * behavior slightly.\n *\n * @author msamuel@google.com (Mike Samuel)\n */\n\ngoog.provide(\x27goog.Uri\x27);\ngoog.provide(\x27goog.Uri.QueryData\x27);\n\ngoog.require(\x27goog.array\x27);\ngoog.require(\x27goog.asserts\x27);\ngoog.require(\x27goog.string\x27);\ngoog.require(\x27goog.structs\x27);\ngoog.require(\x27goog.structs.Map\x27);\ngoog.require(\x27goog.uri.utils\x27);\ngoog.require(\x27goog.uri.utils.ComponentIndex\x27);\ngoog.require(\x27goog.uri.utils.StandardQueryParam\x27);\n\n\n\n/**\n * This class contains setters and getters for the parts of the URI.\n * The \x3ccode\x3egetXyz\x3c/code\x3e/\x3ccode\x3esetXyz\x3c/code\x3e methods return the decoded part\n * -- so\x3ccode\x3egoog.Uri.parse(\x27/foo%20bar\x27).getPath()\x3c/code\x3e will return the\n * decoded path, \x3ccode\x3e/foo bar\x3c/code\x3e.\n *\n * Reserved characters (see RFC 3986 section 2.2) can be present in\n * their percent-encoded form in scheme, domain, and path URI components and\n * will not be auto-decoded. For example:\n * \x3ccode\x3egoog.Uri.parse(\x27rel%61tive/path%2fto/resource\x27).getPath()\x3c/code\x3e will\n * return \x3ccode\x3erelative/path%2fto/resource\x3c/code\x3e.\n *\n * The constructor accepts an optional unparsed, raw URI string.  The parser\n * is relaxed, so special characters that aren\x27t escaped but don\x27t cause\n * ambiguities will not cause parse failures.\n *\n * All setters return \x3ccode\x3ethis\x3c/code\x3e and so may be chained, a la\n * \x3ccode\x3egoog.Uri.parse(\x27/foo\x27).setFragment(\x27part\x27).toString()\x3c/code\x3e.\n *\n * @param {*\x3d} opt_uri Optional string URI to parse\n *        (use goog.Uri.create() to create a URI from parts), or if\n *        a goog.Uri is passed, a clone is created.\n * @param {boolean\x3d} opt_ignoreCase If true, #getParameterValue will ignore\n * the case of the parameter name.\n *\n * @throws URIError If opt_uri is provided and URI is malformed (that is,\n *     if decodeURIComponent fails on any of the URI components).\n * @constructor\n * @struct\n */\ngoog.Uri \x3d function(opt_uri, opt_ignoreCase) {\n  /**\n   * Scheme such as \x22http\x22.\n   * @private {string}\n   */\n  this.scheme_ \x3d \x27\x27;\n\n  /**\n   * User credentials in the form \x22username:password\x22.\n   * @private {string}\n   */\n  this.userInfo_ \x3d \x27\x27;\n\n  /**\n   * Domain part, e.g. \x22www.google.com\x22.\n   * @private {string}\n   */\n  this.domain_ \x3d \x27\x27;\n\n  /**\n   * Port, e.g. 8080.\n   * @private {?number}\n   */\n  this.port_ \x3d null;\n\n  /**\n   * Path, e.g. \x22/tests/img.png\x22.\n   * @private {string}\n   */\n  this.path_ \x3d \x27\x27;\n\n  /**\n   * The fragment without the #.\n   * @private {string}\n   */\n  this.fragment_ \x3d \x27\x27;\n\n  /**\n   * Whether or not this Uri should be treated as Read Only.\n   * @private {boolean}\n   */\n  this.isReadOnly_ \x3d false;\n\n  /**\n   * Whether or not to ignore case when comparing query params.\n   * @private {boolean}\n   */\n  this.ignoreCase_ \x3d false;\n\n  /**\n   * Object representing query data.\n   * @private {!goog.Uri.QueryData}\n   */\n  this.queryData_;\n\n  // Parse in the uri string\n  var m;\n  if (opt_uri instanceof goog.Uri) {\n    this.ignoreCase_ \x3d\n        goog.isDef(opt_ignoreCase) ? opt_ignoreCase : opt_uri.getIgnoreCase();\n    this.setScheme(opt_uri.getScheme());\n    this.setUserInfo(opt_uri.getUserInfo());\n    this.setDomain(opt_uri.getDomain());\n    this.setPort(opt_uri.getPort());\n    this.setPath(opt_uri.getPath());\n    this.setQueryData(opt_uri.getQueryData().clone());\n    this.setFragment(opt_uri.getFragment());\n  } else if (opt_uri \x26\x26 (m \x3d goog.uri.utils.split(String(opt_uri)))) {\n    this.ignoreCase_ \x3d !!opt_ignoreCase;\n\n    // Set the parts -- decoding as we do so.\n    // COMPATIBILITY NOTE - In IE, unmatched fields may be empty strings,\n    // whereas in other browsers they will be undefined.\n    this.setScheme(m[goog.uri.utils.ComponentIndex.SCHEME] || \x27\x27, true);\n    this.setUserInfo(m[goog.uri.utils.ComponentIndex.USER_INFO] || \x27\x27, true);\n    this.setDomain(m[goog.uri.utils.ComponentIndex.DOMAIN] || \x27\x27, true);\n    this.setPort(m[goog.uri.utils.ComponentIndex.PORT]);\n    this.setPath(m[goog.uri.utils.ComponentIndex.PATH] || \x27\x27, true);\n    this.setQueryData(m[goog.uri.utils.ComponentIndex.QUERY_DATA] || \x27\x27, true);\n    this.setFragment(m[goog.uri.utils.ComponentIndex.FRAGMENT] || \x27\x27, true);\n\n  } else {\n    this.ignoreCase_ \x3d !!opt_ignoreCase;\n    this.queryData_ \x3d new goog.Uri.QueryData(null, null, this.ignoreCase_);\n  }\n};\n\n\n/**\n * If true, we preserve the type of query parameters set programmatically.\n *\n * This means that if you set a parameter to a boolean, and then call\n * getParameterValue, you will get a boolean back.\n *\n * If false, we will coerce parameters to strings, just as they would\n * appear in real URIs.\n *\n * TODO(nicksantos): Remove this once people have time to fix all tests.\n *\n * @type {boolean}\n */\ngoog.Uri.preserveParameterTypesCompatibilityFlag \x3d false;\n\n\n/**\n * Parameter name added to stop caching.\n * @type {string}\n */\ngoog.Uri.RANDOM_PARAM \x3d goog.uri.utils.StandardQueryParam.RANDOM;\n\n\n/**\n * @return {string} The string form of the url.\n * @override\n */\ngoog.Uri.prototype.toString \x3d function() {\n  var out \x3d [];\n\n  var scheme \x3d this.getScheme();\n  if (scheme) {\n    out.push(\n        goog.Uri.encodeSpecialChars_(\n            scheme, goog.Uri.reDisallowedInSchemeOrUserInfo_, true),\n        \x27:\x27);\n  }\n\n  var domain \x3d this.getDomain();\n  if (domain || scheme \x3d\x3d \x27file\x27) {\n    out.push(\x27//\x27);\n\n    var userInfo \x3d this.getUserInfo();\n    if (userInfo) {\n      out.push(\n          goog.Uri.encodeSpecialChars_(\n              userInfo, goog.Uri.reDisallowedInSchemeOrUserInfo_, true),\n          \x27@\x27);\n    }\n\n    out.push(goog.Uri.removeDoubleEncoding_(goog.string.urlEncode(domain)));\n\n    var port \x3d this.getPort();\n    if (port !\x3d null) {\n      out.push(\x27:\x27, String(port));\n    }\n  }\n\n  var path \x3d this.getPath();\n  if (path) {\n    if (this.hasDomain() \x26\x26 path.charAt(0) !\x3d \x27/\x27) {\n      out.push(\x27/\x27);\n    }\n    out.push(\n        goog.Uri.encodeSpecialChars_(\n            path, path.charAt(0) \x3d\x3d \x27/\x27 ? goog.Uri.reDisallowedInAbsolutePath_ :\n                                          goog.Uri.reDisallowedInRelativePath_,\n            true));\n  }\n\n  var query \x3d this.getEncodedQuery();\n  if (query) {\n    out.push(\x27?\x27, query);\n  }\n\n  var fragment \x3d this.getFragment();\n  if (fragment) {\n    out.push(\n        \x27#\x27, goog.Uri.encodeSpecialChars_(\n                 fragment, goog.Uri.reDisallowedInFragment_));\n  }\n  return out.join(\x27\x27);\n};\n\n\n/**\n * Resolves the given relative URI (a goog.Uri object), using the URI\n * represented by this instance as the base URI.\n *\n * There are several kinds of relative URIs:\x3cbr\x3e\n * 1. foo - replaces the last part of the path, the whole query and fragment\x3cbr\x3e\n * 2. /foo - replaces the the path, the query and fragment\x3cbr\x3e\n * 3. //foo - replaces everything from the domain on.  foo is a domain name\x3cbr\x3e\n * 4. ?foo - replace the query and fragment\x3cbr\x3e\n * 5. #foo - replace the fragment only\n *\n * Additionally, if relative URI has a non-empty path, all \x22..\x22 and \x22.\x22\n * segments will be resolved, as described in RFC 3986.\n *\n * @param {!goog.Uri} relativeUri The relative URI to resolve.\n * @return {!goog.Uri} The resolved URI.\n */\ngoog.Uri.prototype.resolve \x3d function(relativeUri) {\n\n  var absoluteUri \x3d this.clone();\n\n  // we satisfy these conditions by looking for the first part of relativeUri\n  // that is not blank and applying defaults to the rest\n\n  var overridden \x3d relativeUri.hasScheme();\n\n  if (overridden) {\n    absoluteUri.setScheme(relativeUri.getScheme());\n  } else {\n    overridden \x3d relativeUri.hasUserInfo();\n  }\n\n  if (overridden) {\n    absoluteUri.setUserInfo(relativeUri.getUserInfo());\n  } else {\n    overridden \x3d relativeUri.hasDomain();\n  }\n\n  if (overridden) {\n    absoluteUri.setDomain(relativeUri.getDomain());\n  } else {\n    overridden \x3d relativeUri.hasPort();\n  }\n\n  var path \x3d relativeUri.getPath();\n  if (overridden) {\n    absoluteUri.setPort(relativeUri.getPort());\n  } else {\n    overridden \x3d relativeUri.hasPath();\n    if (overridden) {\n      // resolve path properly\n      if (path.charAt(0) !\x3d \x27/\x27) {\n        // path is relative\n        if (this.hasDomain() \x26\x26 !this.hasPath()) {\n          // RFC 3986, section 5.2.3, case 1\n          path \x3d \x27/\x27 + path;\n        } else {\n          // RFC 3986, section 5.2.3, case 2\n          var lastSlashIndex \x3d absoluteUri.getPath().lastIndexOf(\x27/\x27);\n          if (lastSlashIndex !\x3d -1) {\n            path \x3d absoluteUri.getPath().substr(0, lastSlashIndex + 1) + path;\n          }\n        }\n      }\n      path \x3d goog.Uri.removeDotSegments(path);\n    }\n  }\n\n  if (overridden) {\n    absoluteUri.setPath(path);\n  } else {\n    overridden \x3d relativeUri.hasQuery();\n  }\n\n  if (overridden) {\n    absoluteUri.setQueryData(relativeUri.getQueryData().clone());\n  } else {\n    overridden \x3d relativeUri.hasFragment();\n  }\n\n  if (overridden) {\n    absoluteUri.setFragment(relativeUri.getFragment());\n  }\n\n  return absoluteUri;\n};\n\n\n/**\n * Clones the URI instance.\n * @return {!goog.Uri} New instance of the URI object.\n */\ngoog.Uri.prototype.clone \x3d function() {\n  return new goog.Uri(this);\n};\n\n\n/**\n * @return {string} The encoded scheme/protocol for the URI.\n */\ngoog.Uri.prototype.getScheme \x3d function() {\n  return this.scheme_;\n};\n\n\n/**\n * Sets the scheme/protocol.\n * @throws URIError If opt_decode is true and newScheme is malformed (that is,\n *     if decodeURIComponent fails).\n * @param {string} newScheme New scheme value.\n * @param {boolean\x3d} opt_decode Optional param for whether to decode new value.\n * @return {!goog.Uri} Reference to this URI object.\n */\ngoog.Uri.prototype.setScheme \x3d function(newScheme, opt_decode) {\n  this.enforceReadOnly();\n  this.scheme_ \x3d\n      opt_decode ? goog.Uri.decodeOrEmpty_(newScheme, true) : newScheme;\n\n  // remove an : at the end of the scheme so somebody can pass in\n  // window.location.protocol\n  if (this.scheme_) {\n    this.scheme_ \x3d this.scheme_.replace(/:$/, \x27\x27);\n  }\n  return this;\n};\n\n\n/**\n * @return {boolean} Whether the scheme has been set.\n */\ngoog.Uri.prototype.hasScheme \x3d function() {\n  return !!this.scheme_;\n};\n\n\n/**\n * @return {string} The decoded user info.\n */\ngoog.Uri.prototype.getUserInfo \x3d function() {\n  return this.userInfo_;\n};\n\n\n/**\n * Sets the userInfo.\n * @throws URIError If opt_decode is true and newUserInfo is malformed (that is,\n *     if decodeURIComponent fails).\n * @param {string} newUserInfo New userInfo value.\n * @param {boolean\x3d} opt_decode Optional param for whether to decode new value.\n * @return {!goog.Uri} Reference to this URI object.\n */\ngoog.Uri.prototype.setUserInfo \x3d function(newUserInfo, opt_decode) {\n  this.enforceReadOnly();\n  this.userInfo_ \x3d\n      opt_decode ? goog.Uri.decodeOrEmpty_(newUserInfo) : newUserInfo;\n  return this;\n};\n\n\n/**\n * @return {boolean} Whether the user info has been set.\n */\ngoog.Uri.prototype.hasUserInfo \x3d function() {\n  return !!this.userInfo_;\n};\n\n\n/**\n * @return {string} The decoded domain.\n */\ngoog.Uri.prototype.getDomain \x3d function() {\n  return this.domain_;\n};\n\n\n/**\n * Sets the domain.\n * @throws URIError If opt_decode is true and newDomain is malformed (that is,\n *     if decodeURIComponent fails).\n * @param {string} newDomain New domain value.\n * @param {boolean\x3d} opt_decode Optional param for whether to decode new value.\n * @return {!goog.Uri} Reference to this URI object.\n */\ngoog.Uri.prototype.setDomain \x3d function(newDomain, opt_decode) {\n  this.enforceReadOnly();\n  this.domain_ \x3d\n      opt_decode ? goog.Uri.decodeOrEmpty_(newDomain, true) : newDomain;\n  return this;\n};\n\n\n/**\n * @return {boolean} Whether the domain has been set.\n */\ngoog.Uri.prototype.hasDomain \x3d function() {\n  return !!this.domain_;\n};\n\n\n/**\n * @return {?number} The port number.\n */\ngoog.Uri.prototype.getPort \x3d function() {\n  return this.port_;\n};\n\n\n/**\n * Sets the port number.\n * @param {*} newPort Port number. Will be explicitly casted to a number.\n * @return {!goog.Uri} Reference to this URI object.\n */\ngoog.Uri.prototype.setPort \x3d function(newPort) {\n  this.enforceReadOnly();\n\n  if (newPort) {\n    newPort \x3d Number(newPort);\n    if (isNaN(newPort) || newPort \x3c 0) {\n      throw Error(\x27Bad port number \x27 + newPort);\n    }\n    this.port_ \x3d newPort;\n  } else {\n    this.port_ \x3d null;\n  }\n\n  return this;\n};\n\n\n/**\n * @return {boolean} Whether the port has been set.\n */\ngoog.Uri.prototype.hasPort \x3d function() {\n  return this.port_ !\x3d null;\n};\n\n\n/**\n  * @return {string} The decoded path.\n */\ngoog.Uri.prototype.getPath \x3d function() {\n  return this.path_;\n};\n\n\n/**\n * Sets the path.\n * @throws URIError If opt_decode is true and newPath is malformed (that is,\n *     if decodeURIComponent fails).\n * @param {string} newPath New path value.\n * @param {boolean\x3d} opt_decode Optional param for whether to decode new value.\n * @return {!goog.Uri} Reference to this URI object.\n */\ngoog.Uri.prototype.setPath \x3d function(newPath, opt_decode) {\n  this.enforceReadOnly();\n  this.path_ \x3d opt_decode ? goog.Uri.decodeOrEmpty_(newPath, true) : newPath;\n  return this;\n};\n\n\n/**\n * @return {boolean} Whether the path has been set.\n */\ngoog.Uri.prototype.hasPath \x3d function() {\n  return !!this.path_;\n};\n\n\n/**\n * @return {boolean} Whether the query string has been set.\n */\ngoog.Uri.prototype.hasQuery \x3d function() {\n  return this.queryData_.toString() !\x3d\x3d \x27\x27;\n};\n\n\n/**\n * Sets the query data.\n * @param {goog.Uri.QueryData|string|undefined} queryData QueryData object.\n * @param {boolean\x3d} opt_decode Optional param for whether to decode new value.\n *     Applies only if queryData is a string.\n * @return {!goog.Uri} Reference to this URI object.\n */\ngoog.Uri.prototype.setQueryData \x3d function(queryData, opt_decode) {\n  this.enforceReadOnly();\n\n  if (queryData instanceof goog.Uri.QueryData) {\n    this.queryData_ \x3d queryData;\n    this.queryData_.setIgnoreCase(this.ignoreCase_);\n  } else {\n    if (!opt_decode) {\n      // QueryData accepts encoded query string, so encode it if\n      // opt_decode flag is not true.\n      queryData \x3d goog.Uri.encodeSpecialChars_(\n          queryData, goog.Uri.reDisallowedInQuery_);\n    }\n    this.queryData_ \x3d new goog.Uri.QueryData(queryData, null, this.ignoreCase_);\n  }\n\n  return this;\n};\n\n\n/**\n * Sets the URI query.\n * @param {string} newQuery New query value.\n * @param {boolean\x3d} opt_decode Optional param for whether to decode new value.\n * @return {!goog.Uri} Reference to this URI object.\n */\ngoog.Uri.prototype.setQuery \x3d function(newQuery, opt_decode) {\n  return this.setQueryData(newQuery, opt_decode);\n};\n\n\n/**\n * @return {string} The encoded URI query, not including the ?.\n */\ngoog.Uri.prototype.getEncodedQuery \x3d function() {\n  return this.queryData_.toString();\n};\n\n\n/**\n * @return {string} The decoded URI query, not including the ?.\n */\ngoog.Uri.prototype.getDecodedQuery \x3d function() {\n  return this.queryData_.toDecodedString();\n};\n\n\n/**\n * Returns the query data.\n * @return {!goog.Uri.QueryData} QueryData object.\n */\ngoog.Uri.prototype.getQueryData \x3d function() {\n  return this.queryData_;\n};\n\n\n/**\n * @return {string} The encoded URI query, not including the ?.\n *\n * Warning: This method, unlike other getter methods, returns encoded\n * value, instead of decoded one.\n */\ngoog.Uri.prototype.getQuery \x3d function() {\n  return this.getEncodedQuery();\n};\n\n\n/**\n * Sets the value of the named query parameters, clearing previous values for\n * that key.\n *\n * @param {string} key The parameter to set.\n * @param {*} value The new value.\n * @return {!goog.Uri} Reference to this URI object.\n */\ngoog.Uri.prototype.setParameterValue \x3d function(key, value) {\n  this.enforceReadOnly();\n  this.queryData_.set(key, value);\n  return this;\n};\n\n\n/**\n * Sets the values of the named query parameters, clearing previous values for\n * that key.  Not new values will currently be moved to the end of the query\n * string.\n *\n * So, \x3ccode\x3egoog.Uri.parse(\x27foo?a\x3db\x26c\x3dd\x26e\x3df\x27).setParameterValues(\x27c\x27, [\x27new\x27])\n * \x3c/code\x3e yields \x3ctt\x3efoo?a\x3db\x26e\x3df\x26c\x3dnew\x3c/tt\x3e.\x3c/p\x3e\n *\n * @param {string} key The parameter to set.\n * @param {*} values The new values. If values is a single\n *     string then it will be treated as the sole value.\n * @return {!goog.Uri} Reference to this URI object.\n */\ngoog.Uri.prototype.setParameterValues \x3d function(key, values) {\n  this.enforceReadOnly();\n\n  if (!goog.isArray(values)) {\n    values \x3d [String(values)];\n  }\n\n  this.queryData_.setValues(key, values);\n\n  return this;\n};\n\n\n/**\n * Returns the value\x3cb\x3es\x3c/b\x3e for a given cgi parameter as a list of decoded\n * query parameter values.\n * @param {string} name The parameter to get values for.\n * @return {!Array\x3c?\x3e} The values for a given cgi parameter as a list of\n *     decoded query parameter values.\n */\ngoog.Uri.prototype.getParameterValues \x3d function(name) {\n  return this.queryData_.getValues(name);\n};\n\n\n/**\n * Returns the first value for a given cgi parameter or undefined if the given\n * parameter name does not appear in the query string.\n * @param {string} paramName Unescaped parameter name.\n * @return {string|undefined} The first value for a given cgi parameter or\n *     undefined if the given parameter name does not appear in the query\n *     string.\n */\ngoog.Uri.prototype.getParameterValue \x3d function(paramName) {\n  // NOTE(nicksantos): This type-cast is a lie when\n  // preserveParameterTypesCompatibilityFlag is set to true.\n  // But this should only be set to true in tests.\n  return /** @type {string|undefined} */ (this.queryData_.get(paramName));\n};\n\n\n/**\n * @return {string} The URI fragment, not including the #.\n */\ngoog.Uri.prototype.getFragment \x3d function() {\n  return this.fragment_;\n};\n\n\n/**\n * Sets the URI fragment.\n * @throws URIError If opt_decode is true and newFragment is malformed (that is,\n *     if decodeURIComponent fails).\n * @param {string} newFragment New fragment value.\n * @param {boolean\x3d} opt_decode Optional param for whether to decode new value.\n * @return {!goog.Uri} Reference to this URI object.\n */\ngoog.Uri.prototype.setFragment \x3d function(newFragment, opt_decode) {\n  this.enforceReadOnly();\n  this.fragment_ \x3d\n      opt_decode ? goog.Uri.decodeOrEmpty_(newFragment) : newFragment;\n  return this;\n};\n\n\n/**\n * @return {boolean} Whether the URI has a fragment set.\n */\ngoog.Uri.prototype.hasFragment \x3d function() {\n  return !!this.fragment_;\n};\n\n\n/**\n * Returns true if this has the same domain as that of uri2.\n * @param {!goog.Uri} uri2 The URI object to compare to.\n * @return {boolean} true if same domain; false otherwise.\n */\ngoog.Uri.prototype.hasSameDomainAs \x3d function(uri2) {\n  return ((!this.hasDomain() \x26\x26 !uri2.hasDomain()) ||\n          this.getDomain() \x3d\x3d uri2.getDomain()) \x26\x26\n      ((!this.hasPort() \x26\x26 !uri2.hasPort()) ||\n       this.getPort() \x3d\x3d uri2.getPort());\n};\n\n\n/**\n * Adds a random parameter to the Uri.\n * @return {!goog.Uri} Reference to this Uri object.\n */\ngoog.Uri.prototype.makeUnique \x3d function() {\n  this.enforceReadOnly();\n  this.setParameterValue(goog.Uri.RANDOM_PARAM, goog.string.getRandomString());\n\n  return this;\n};\n\n\n/**\n * Removes the named query parameter.\n *\n * @param {string} key The parameter to remove.\n * @return {!goog.Uri} Reference to this URI object.\n */\ngoog.Uri.prototype.removeParameter \x3d function(key) {\n  this.enforceReadOnly();\n  this.queryData_.remove(key);\n  return this;\n};\n\n\n/**\n * Sets whether Uri is read only. If this goog.Uri is read-only,\n * enforceReadOnly_ will be called at the start of any function that may modify\n * this Uri.\n * @param {boolean} isReadOnly whether this goog.Uri should be read only.\n * @return {!goog.Uri} Reference to this Uri object.\n */\ngoog.Uri.prototype.setReadOnly \x3d function(isReadOnly) {\n  this.isReadOnly_ \x3d isReadOnly;\n  return this;\n};\n\n\n/**\n * @return {boolean} Whether the URI is read only.\n */\ngoog.Uri.prototype.isReadOnly \x3d function() {\n  return this.isReadOnly_;\n};\n\n\n/**\n * Checks if this Uri has been marked as read only, and if so, throws an error.\n * This should be called whenever any modifying function is called.\n */\ngoog.Uri.prototype.enforceReadOnly \x3d function() {\n  if (this.isReadOnly_) {\n    throw Error(\x27Tried to modify a read-only Uri\x27);\n  }\n};\n\n\n/**\n * Sets whether to ignore case.\n * NOTE: If there are already key/value pairs in the QueryData, and\n * ignoreCase_ is set to false, the keys will all be lower-cased.\n * @param {boolean} ignoreCase whether this goog.Uri should ignore case.\n * @return {!goog.Uri} Reference to this Uri object.\n */\ngoog.Uri.prototype.setIgnoreCase \x3d function(ignoreCase) {\n  this.ignoreCase_ \x3d ignoreCase;\n  if (this.queryData_) {\n    this.queryData_.setIgnoreCase(ignoreCase);\n  }\n  return this;\n};\n\n\n/**\n * @return {boolean} Whether to ignore case.\n */\ngoog.Uri.prototype.getIgnoreCase \x3d function() {\n  return this.ignoreCase_;\n};\n\n\n//\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\n// Static members\n//\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\x3d\n\n\n/**\n * Creates a uri from the string form.  Basically an alias of new goog.Uri().\n * If a Uri object is passed to parse then it will return a clone of the object.\n *\n * @throws URIError If parsing the URI is malformed. The passed URI components\n *     should all be parseable by decodeURIComponent.\n * @param {*} uri Raw URI string or instance of Uri\n *     object.\n * @param {boolean\x3d} opt_ignoreCase Whether to ignore the case of parameter\n * names in #getParameterValue.\n * @return {!goog.Uri} The new URI object.\n */\ngoog.Uri.parse \x3d function(uri, opt_ignoreCase) {\n  return uri instanceof goog.Uri ? uri.clone() :\n                                   new goog.Uri(uri, opt_ignoreCase);\n};\n\n\n/**\n * Creates a new goog.Uri object from unencoded parts.\n *\n * @param {?string\x3d} opt_scheme Scheme/protocol or full URI to parse.\n * @param {?string\x3d} opt_userInfo username:password.\n * @param {?string\x3d} opt_domain www.google.com.\n * @param {?number\x3d} opt_port 9830.\n * @param {?string\x3d} opt_path /some/path/to/a/file.html.\n * @param {string|goog.Uri.QueryData\x3d} opt_query a\x3d1\x26b\x3d2.\n * @param {?string\x3d} opt_fragment The fragment without the #.\n * @param {boolean\x3d} opt_ignoreCase Whether to ignore parameter name case in\n *     #getParameterValue.\n *\n * @return {!goog.Uri} The new URI object.\n */\ngoog.Uri.create \x3d function(\n    opt_scheme, opt_userInfo, opt_domain, opt_port, opt_path, opt_query,\n    opt_fragment, opt_ignoreCase) {\n\n  var uri \x3d new goog.Uri(null, opt_ignoreCase);\n\n  // Only set the parts if they are defined and not empty strings.\n  opt_scheme \x26\x26 uri.setScheme(opt_scheme);\n  opt_userInfo \x26\x26 uri.setUserInfo(opt_userInfo);\n  opt_domain \x26\x26 uri.setDomain(opt_domain);\n  opt_port \x26\x26 uri.setPort(opt_port);\n  opt_path \x26\x26 uri.setPath(opt_path);\n  opt_query \x26\x26 uri.setQueryData(opt_query);\n  opt_fragment \x26\x26 uri.setFragment(opt_fragment);\n\n  return uri;\n};\n\n\n/**\n * Resolves a relative Uri against a base Uri, accepting both strings and\n * Uri objects.\n *\n * @param {*} base Base Uri.\n * @param {*} rel Relative Uri.\n * @return {!goog.Uri} Resolved uri.\n */\ngoog.Uri.resolve \x3d function(base, rel) {\n  if (!(base instanceof goog.Uri)) {\n    base \x3d goog.Uri.parse(base);\n  }\n\n  if (!(rel instanceof goog.Uri)) {\n    rel \x3d goog.Uri.parse(rel);\n  }\n\n  return base.resolve(rel);\n};\n\n\n/**\n * Removes dot segments in given path component, as described in\n * RFC 3986, section 5.2.4.\n *\n * @param {string} path A non-empty path component.\n * @return {string} Path component with removed dot segments.\n */\ngoog.Uri.removeDotSegments \x3d function(path) {\n  if (path \x3d\x3d \x27..\x27 || path \x3d\x3d \x27.\x27) {\n    return \x27\x27;\n\n  } else if (\n      !goog.string.contains(path, \x27./\x27) \x26\x26 !goog.string.contains(path, \x27/.\x27)) {\n    // This optimization detects uris which do not contain dot-segments,\n    // and as a consequence do not require any processing.\n    return path;\n\n  } else {\n    var leadingSlash \x3d goog.string.startsWith(path, \x27/\x27);\n    var segments \x3d path.split(\x27/\x27);\n    var out \x3d [];\n\n    for (var pos \x3d 0; pos \x3c segments.length;) {\n      var segment \x3d segments[pos++];\n\n      if (segment \x3d\x3d \x27.\x27) {\n        if (leadingSlash \x26\x26 pos \x3d\x3d segments.length) {\n          out.push(\x27\x27);\n        }\n      } else if (segment \x3d\x3d \x27..\x27) {\n        if (out.length \x3e 1 || out.length \x3d\x3d 1 \x26\x26 out[0] !\x3d \x27\x27) {\n          out.pop();\n        }\n        if (leadingSlash \x26\x26 pos \x3d\x3d segments.length) {\n          out.push(\x27\x27);\n        }\n      } else {\n        out.push(segment);\n        leadingSlash \x3d true;\n      }\n    }\n\n    return out.join(\x27/\x27);\n  }\n};\n\n\n/**\n * Decodes a value or returns the empty string if it isn\x27t defined or empty.\n * @throws URIError If decodeURIComponent fails to decode val.\n * @param {string|undefined} val Value to decode.\n * @param {boolean\x3d} opt_preserveReserved If true, restricted characters will\n *     not be decoded.\n * @return {string} Decoded value.\n * @private\n */\ngoog.Uri.decodeOrEmpty_ \x3d function(val, opt_preserveReserved) {\n  // Don\x27t use UrlDecode() here because val is not a query parameter.\n  if (!val) {\n    return \x27\x27;\n  }\n\n  // decodeURI has the same output for \x27%2f\x27 and \x27%252f\x27. We double encode %25\n  // so that we can distinguish between the 2 inputs. This is later undone by\n  // removeDoubleEncoding_.\n  return opt_preserveReserved ? decodeURI(val.replace(/%25/g, \x27%2525\x27)) :\n                                decodeURIComponent(val);\n};\n\n\n/**\n * If unescapedPart is non null, then escapes any characters in it that aren\x27t\n * valid characters in a url and also escapes any special characters that\n * appear in extra.\n *\n * @param {*} unescapedPart The string to encode.\n * @param {RegExp} extra A character set of characters in [\\01-\\177].\n * @param {boolean\x3d} opt_removeDoubleEncoding If true, remove double percent\n *     encoding.\n * @return {?string} null iff unescapedPart \x3d\x3d null.\n * @private\n */\ngoog.Uri.encodeSpecialChars_ \x3d function(\n    unescapedPart, extra, opt_removeDoubleEncoding) {\n  if (goog.isString(unescapedPart)) {\n    var encoded \x3d encodeURI(unescapedPart).replace(extra, goog.Uri.encodeChar_);\n    if (opt_removeDoubleEncoding) {\n      // encodeURI double-escapes %XX sequences used to represent restricted\n      // characters in some URI components, remove the double escaping here.\n      encoded \x3d goog.Uri.removeDoubleEncoding_(encoded);\n    }\n    return encoded;\n  }\n  return null;\n};\n\n\n/**\n * Converts a character in [\\01-\\177] to its unicode character equivalent.\n * @param {string} ch One character string.\n * @return {string} Encoded string.\n * @private\n */\ngoog.Uri.encodeChar_ \x3d function(ch) {\n  var n \x3d ch.charCodeAt(0);\n  return \x27%\x27 + ((n \x3e\x3e 4) \x26 0xf).toString(16) + (n \x26 0xf).toString(16);\n};\n\n\n/**\n * Removes double percent-encoding from a string.\n * @param  {string} doubleEncodedString String\n * @return {string} String with double encoding removed.\n * @private\n */\ngoog.Uri.removeDoubleEncoding_ \x3d function(doubleEncodedString) {\n  return doubleEncodedString.replace(/%25([0-9a-fA-F]{2})/g, \x27%$1\x27);\n};\n\n\n/**\n * Regular expression for characters that are disallowed in the scheme or\n * userInfo part of the URI.\n * @type {RegExp}\n * @private\n */\ngoog.Uri.reDisallowedInSchemeOrUserInfo_ \x3d /[#\\/\\?@]/g;\n\n\n/**\n * Regular expression for characters that are disallowed in a relative path.\n * Colon is included due to RFC 3986 3.3.\n * @type {RegExp}\n * @private\n */\ngoog.Uri.reDisallowedInRelativePath_ \x3d /[\\#\\?:]/g;\n\n\n/**\n * Regular expression for characters that are disallowed in an absolute path.\n * @type {RegExp}\n * @private\n */\ngoog.Uri.reDisallowedInAbsolutePath_ \x3d /[\\#\\?]/g;\n\n\n/**\n * Regular expression for characters that are disallowed in the query.\n * @type {RegExp}\n * @private\n */\ngoog.Uri.reDisallowedInQuery_ \x3d /[\\#\\?@]/g;\n\n\n/**\n * Regular expression for characters that are disallowed in the fragment.\n * @type {RegExp}\n * @private\n */\ngoog.Uri.reDisallowedInFragment_ \x3d /#/g;\n\n\n/**\n * Checks whether two URIs have the same domain.\n * @param {string} uri1String First URI string.\n * @param {string} uri2String Second URI string.\n * @return {boolean} true if the two URIs have the same domain; false otherwise.\n */\ngoog.Uri.haveSameDomain \x3d function(uri1String, uri2String) {\n  // Differs from goog.uri.utils.haveSameDomain, since this ignores scheme.\n  // TODO(gboyer): Have this just call goog.uri.util.haveSameDomain.\n  var pieces1 \x3d goog.uri.utils.split(uri1String);\n  var pieces2 \x3d goog.uri.utils.split(uri2String);\n  return pieces1[goog.uri.utils.ComponentIndex.DOMAIN] \x3d\x3d\n      pieces2[goog.uri.utils.ComponentIndex.DOMAIN] \x26\x26\n      pieces1[goog.uri.utils.ComponentIndex.PORT] \x3d\x3d\n      pieces2[goog.uri.utils.ComponentIndex.PORT];\n};\n\n\n\n/**\n * Class used to represent URI query parameters.  It is essentially a hash of\n * name-value pairs, though a name can be present more than once.\n *\n * Has the same interface as the collections in goog.structs.\n *\n * @param {?string\x3d} opt_query Optional encoded query string to parse into\n *     the object.\n * @param {goog.Uri\x3d} opt_uri Optional uri object that should have its\n *     cache invalidated when this object updates. Deprecated -- this\n *     is no longer required.\n * @param {boolean\x3d} opt_ignoreCase If true, ignore the case of the parameter\n *     name in #get.\n * @constructor\n * @struct\n * @final\n */\ngoog.Uri.QueryData \x3d function(opt_query, opt_uri, opt_ignoreCase) {\n  /**\n   * The map containing name/value or name/array-of-values pairs.\n   * May be null if it requires parsing from the query string.\n   *\n   * We need to use a Map because we cannot guarantee that the key names will\n   * not be problematic for IE.\n   *\n   * @private {goog.structs.Map\x3cstring, !Array\x3c*\x3e\x3e}\n   */\n  this.keyMap_ \x3d null;\n\n  /**\n   * The number of params, or null if it requires computing.\n   * @private {?number}\n   */\n  this.count_ \x3d null;\n\n  /**\n   * Encoded query string, or null if it requires computing from the key map.\n   * @private {?string}\n   */\n  this.encodedQuery_ \x3d opt_query || null;\n\n  /**\n   * If true, ignore the case of the parameter name in #get.\n   * @private {boolean}\n   */\n  this.ignoreCase_ \x3d !!opt_ignoreCase;\n};\n\n\n/**\n * If the underlying key map is not yet initialized, it parses the\n * query string and fills the map with parsed data.\n * @private\n */\ngoog.Uri.QueryData.prototype.ensureKeyMapInitialized_ \x3d function() {\n  if (!this.keyMap_) {\n    this.keyMap_ \x3d new goog.structs.Map();\n    this.count_ \x3d 0;\n    if (this.encodedQuery_) {\n      var self \x3d this;\n      goog.uri.utils.parseQueryData(this.encodedQuery_, function(name, value) {\n        self.add(goog.string.urlDecode(name), value);\n      });\n    }\n  }\n};\n\n\n/**\n * Creates a new query data instance from a map of names and values.\n *\n * @param {!goog.structs.Map\x3cstring, ?\x3e|!Object} map Map of string parameter\n *     names to parameter value. If parameter value is an array, it is\n *     treated as if the key maps to each individual value in the\n *     array.\n * @param {goog.Uri\x3d} opt_uri URI object that should have its cache\n *     invalidated when this object updates.\n * @param {boolean\x3d} opt_ignoreCase If true, ignore the case of the parameter\n *     name in #get.\n * @return {!goog.Uri.QueryData} The populated query data instance.\n */\ngoog.Uri.QueryData.createFromMap \x3d function(map, opt_uri, opt_ignoreCase) {\n  var keys \x3d goog.structs.getKeys(map);\n  if (typeof keys \x3d\x3d \x27undefined\x27) {\n    throw Error(\x27Keys are undefined\x27);\n  }\n\n  var queryData \x3d new goog.Uri.QueryData(null, null, opt_ignoreCase);\n  var values \x3d goog.structs.getValues(map);\n  for (var i \x3d 0; i \x3c keys.length; i++) {\n    var key \x3d keys[i];\n    var value \x3d values[i];\n    if (!goog.isArray(value)) {\n      queryData.add(key, value);\n    } else {\n      queryData.setValues(key, value);\n    }\n  }\n  return queryData;\n};\n\n\n/**\n * Creates a new query data instance from parallel arrays of parameter names\n * and values. Allows for duplicate parameter names. Throws an error if the\n * lengths of the arrays differ.\n *\n * @param {!Array\x3cstring\x3e} keys Parameter names.\n * @param {!Array\x3c?\x3e} values Parameter values.\n * @param {goog.Uri\x3d} opt_uri URI object that should have its cache\n *     invalidated when this object updates.\n * @param {boolean\x3d} opt_ignoreCase If true, ignore the case of the parameter\n *     name in #get.\n * @return {!goog.Uri.QueryData} The populated query data instance.\n */\ngoog.Uri.QueryData.createFromKeysValues \x3d function(\n    keys, values, opt_uri, opt_ignoreCase) {\n  if (keys.length !\x3d values.length) {\n    throw Error(\x27Mismatched lengths for keys/values\x27);\n  }\n  var queryData \x3d new goog.Uri.QueryData(null, null, opt_ignoreCase);\n  for (var i \x3d 0; i \x3c keys.length; i++) {\n    queryData.add(keys[i], values[i]);\n  }\n  return queryData;\n};\n\n\n/**\n * @return {?number} The number of parameters.\n */\ngoog.Uri.QueryData.prototype.getCount \x3d function() {\n  this.ensureKeyMapInitialized_();\n  return this.count_;\n};\n\n\n/**\n * Adds a key value pair.\n * @param {string} key Name.\n * @param {*} value Value.\n * @return {!goog.Uri.QueryData} Instance of this object.\n */\ngoog.Uri.QueryData.prototype.add \x3d function(key, value) {\n  this.ensureKeyMapInitialized_();\n  this.invalidateCache_();\n\n  key \x3d this.getKeyName_(key);\n  var values \x3d this.keyMap_.get(key);\n  if (!values) {\n    this.keyMap_.set(key, (values \x3d []));\n  }\n  values.push(value);\n  this.count_ \x3d goog.asserts.assertNumber(this.count_) + 1;\n  return this;\n};\n\n\n/**\n * Removes all the params with the given key.\n * @param {string} key Name.\n * @return {boolean} Whether any parameter was removed.\n */\ngoog.Uri.QueryData.prototype.remove \x3d function(key) {\n  this.ensureKeyMapInitialized_();\n\n  key \x3d this.getKeyName_(key);\n  if (this.keyMap_.containsKey(key)) {\n    this.invalidateCache_();\n\n    // Decrement parameter count.\n    this.count_ \x3d\n        goog.asserts.assertNumber(this.count_) - this.keyMap_.get(key).length;\n    return this.keyMap_.remove(key);\n  }\n  return false;\n};\n\n\n/**\n * Clears the parameters.\n */\ngoog.Uri.QueryData.prototype.clear \x3d function() {\n  this.invalidateCache_();\n  this.keyMap_ \x3d null;\n  this.count_ \x3d 0;\n};\n\n\n/**\n * @return {boolean} Whether we have any parameters.\n */\ngoog.Uri.QueryData.prototype.isEmpty \x3d function() {\n  this.ensureKeyMapInitialized_();\n  return this.count_ \x3d\x3d 0;\n};\n\n\n/**\n * Whether there is a parameter with the given name\n * @param {string} key The parameter name to check for.\n * @return {boolean} Whether there is a parameter with the given name.\n */\ngoog.Uri.QueryData.prototype.containsKey \x3d function(key) {\n  this.ensureKeyMapInitialized_();\n  key \x3d this.getKeyName_(key);\n  return this.keyMap_.containsKey(key);\n};\n\n\n/**\n * Whether there is a parameter with the given value.\n * @param {*} value The value to check for.\n * @return {boolean} Whether there is a parameter with the given value.\n */\ngoog.Uri.QueryData.prototype.containsValue \x3d function(value) {\n  // NOTE(arv): This solution goes through all the params even if it was the\n  // first param. We can get around this by not reusing code or by switching to\n  // iterators.\n  var vals \x3d this.getValues();\n  return goog.array.contains(vals, value);\n};\n\n\n/**\n * Runs a callback on every key-value pair in the map, including duplicate keys.\n * This won\x27t maintain original order when duplicate keys are interspersed (like\n * getKeys() / getValues()).\n * @param {function(this:SCOPE, ?, string, !goog.Uri.QueryData)} f\n * @param {SCOPE\x3d} opt_scope The value of \x22this\x22 inside f.\n * @template SCOPE\n */\ngoog.Uri.QueryData.prototype.forEach \x3d function(f, opt_scope) {\n  this.ensureKeyMapInitialized_();\n  this.keyMap_.forEach(function(values, key) {\n    goog.array.forEach(values, function(value) {\n      f.call(opt_scope, value, key, this);\n    }, this);\n  }, this);\n};\n\n\n/**\n * Returns all the keys of the parameters. If a key is used multiple times\n * it will be included multiple times in the returned array\n * @return {!Array\x3cstring\x3e} All the keys of the parameters.\n */\ngoog.Uri.QueryData.prototype.getKeys \x3d function() {\n  this.ensureKeyMapInitialized_();\n  // We need to get the values to know how many keys to add.\n  var vals \x3d this.keyMap_.getValues();\n  var keys \x3d this.keyMap_.getKeys();\n  var rv \x3d [];\n  for (var i \x3d 0; i \x3c keys.length; i++) {\n    var val \x3d vals[i];\n    for (var j \x3d 0; j \x3c val.length; j++) {\n      rv.push(keys[i]);\n    }\n  }\n  return rv;\n};\n\n\n/**\n * Returns all the values of the parameters with the given name. If the query\n * data has no such key this will return an empty array. If no key is given\n * all values wil be returned.\n * @param {string\x3d} opt_key The name of the parameter to get the values for.\n * @return {!Array\x3c?\x3e} All the values of the parameters with the given name.\n */\ngoog.Uri.QueryData.prototype.getValues \x3d function(opt_key) {\n  this.ensureKeyMapInitialized_();\n  var rv \x3d [];\n  if (goog.isString(opt_key)) {\n    if (this.containsKey(opt_key)) {\n      rv \x3d goog.array.concat(rv, this.keyMap_.get(this.getKeyName_(opt_key)));\n    }\n  } else {\n    // Return all values.\n    var values \x3d this.keyMap_.getValues();\n    for (var i \x3d 0; i \x3c values.length; i++) {\n      rv \x3d goog.array.concat(rv, values[i]);\n    }\n  }\n  return rv;\n};\n\n\n/**\n * Sets a key value pair and removes all other keys with the same value.\n *\n * @param {string} key Name.\n * @param {*} value Value.\n * @return {!goog.Uri.QueryData} Instance of this object.\n */\ngoog.Uri.QueryData.prototype.set \x3d function(key, value) {\n  this.ensureKeyMapInitialized_();\n  this.invalidateCache_();\n\n  // TODO(chrishenry): This could be better written as\n  // this.remove(key), this.add(key, value), but that would reorder\n  // the key (since the key is first removed and then added at the\n  // end) and we would have to fix unit tests that depend on key\n  // ordering.\n  key \x3d this.getKeyName_(key);\n  if (this.containsKey(key)) {\n    this.count_ \x3d\n        goog.asserts.assertNumber(this.count_) - this.keyMap_.get(key).length;\n  }\n  this.keyMap_.set(key, [value]);\n  this.count_ \x3d goog.asserts.assertNumber(this.count_) + 1;\n  return this;\n};\n\n\n/**\n * Returns the first value associated with the key. If the query data has no\n * such key this will return undefined or the optional default.\n * @param {string} key The name of the parameter to get the value for.\n * @param {*\x3d} opt_default The default value to return if the query data\n *     has no such key.\n * @return {*} The first string value associated with the key, or opt_default\n *     if there\x27s no value.\n */\ngoog.Uri.QueryData.prototype.get \x3d function(key, opt_default) {\n  var values \x3d key ? this.getValues(key) : [];\n  if (goog.Uri.preserveParameterTypesCompatibilityFlag) {\n    return values.length \x3e 0 ? values[0] : opt_default;\n  } else {\n    return values.length \x3e 0 ? String(values[0]) : opt_default;\n  }\n};\n\n\n/**\n * Sets the values for a key. If the key already exists, this will\n * override all of the existing values that correspond to the key.\n * @param {string} key The key to set values for.\n * @param {!Array\x3c?\x3e} values The values to set.\n */\ngoog.Uri.QueryData.prototype.setValues \x3d function(key, values) {\n  this.remove(key);\n\n  if (values.length \x3e 0) {\n    this.invalidateCache_();\n    this.keyMap_.set(this.getKeyName_(key), goog.array.clone(values));\n    this.count_ \x3d goog.asserts.assertNumber(this.count_) + values.length;\n  }\n};\n\n\n/**\n * @return {string} Encoded query string.\n * @override\n */\ngoog.Uri.QueryData.prototype.toString \x3d function() {\n  if (this.encodedQuery_) {\n    return this.encodedQuery_;\n  }\n\n  if (!this.keyMap_) {\n    return \x27\x27;\n  }\n\n  var sb \x3d [];\n\n  // In the past, we use this.getKeys() and this.getVals(), but that\n  // generates a lot of allocations as compared to simply iterating\n  // over the keys.\n  var keys \x3d this.keyMap_.getKeys();\n  for (var i \x3d 0; i \x3c keys.length; i++) {\n    var key \x3d keys[i];\n    var encodedKey \x3d goog.string.urlEncode(key);\n    var val \x3d this.getValues(key);\n    for (var j \x3d 0; j \x3c val.length; j++) {\n      var param \x3d encodedKey;\n      // Ensure that null and undefined are encoded into the url as\n      // literal strings.\n      if (val[j] !\x3d\x3d \x27\x27) {\n        param +\x3d \x27\x3d\x27 + goog.string.urlEncode(val[j]);\n      }\n      sb.push(param);\n    }\n  }\n\n  return this.encodedQuery_ \x3d sb.join(\x27\x26\x27);\n};\n\n\n/**\n * @throws URIError If URI is malformed (that is, if decodeURIComponent fails on\n *     any of the URI components).\n * @return {string} Decoded query string.\n */\ngoog.Uri.QueryData.prototype.toDecodedString \x3d function() {\n  return goog.Uri.decodeOrEmpty_(this.toString());\n};\n\n\n/**\n * Invalidate the cache.\n * @private\n */\ngoog.Uri.QueryData.prototype.invalidateCache_ \x3d function() {\n  this.encodedQuery_ \x3d null;\n};\n\n\n/**\n * Removes all keys that are not in the provided list. (Modifies this object.)\n * @param {Array\x3cstring\x3e} keys The desired keys.\n * @return {!goog.Uri.QueryData} a reference to this object.\n */\ngoog.Uri.QueryData.prototype.filterKeys \x3d function(keys) {\n  this.ensureKeyMapInitialized_();\n  this.keyMap_.forEach(function(value, key) {\n    if (!goog.array.contains(keys, key)) {\n      this.remove(key);\n    }\n  }, this);\n  return this;\n};\n\n\n/**\n * Clone the query data instance.\n * @return {!goog.Uri.QueryData} New instance of the QueryData object.\n */\ngoog.Uri.QueryData.prototype.clone \x3d function() {\n  var rv \x3d new goog.Uri.QueryData();\n  rv.encodedQuery_ \x3d this.encodedQuery_;\n  if (this.keyMap_) {\n    rv.keyMap_ \x3d this.keyMap_.clone();\n    rv.count_ \x3d this.count_;\n  }\n  return rv;\n};\n\n\n/**\n * Helper function to get the key name from a JavaScript object. Converts\n * the object to a string, and to lower case if necessary.\n * @private\n * @param {*} arg The object to get a key name from.\n * @return {string} valid key name which can be looked up in #keyMap_.\n */\ngoog.Uri.QueryData.prototype.getKeyName_ \x3d function(arg) {\n  var keyName \x3d String(arg);\n  if (this.ignoreCase_) {\n    keyName \x3d keyName.toLowerCase();\n  }\n  return keyName;\n};\n\n\n/**\n * Ignore case in parameter names.\n * NOTE: If there are already key/value pairs in the QueryData, and\n * ignoreCase_ is set to false, the keys will all be lower-cased.\n * @param {boolean} ignoreCase whether this goog.Uri should ignore case.\n */\ngoog.Uri.QueryData.prototype.setIgnoreCase \x3d function(ignoreCase) {\n  var resetKeys \x3d ignoreCase \x26\x26 !this.ignoreCase_;\n  if (resetKeys) {\n    this.ensureKeyMapInitialized_();\n    this.invalidateCache_();\n    this.keyMap_.forEach(function(value, key) {\n      var lowerCase \x3d key.toLowerCase();\n      if (key !\x3d lowerCase) {\n        this.remove(key);\n        this.setValues(lowerCase, value);\n      }\n    }, this);\n  }\n  this.ignoreCase_ \x3d ignoreCase;\n};\n\n\n/**\n * Extends a query data object with another query data or map like object. This\n * operates \x27in-place\x27, it does not create a new QueryData object.\n *\n * @param {...(?goog.Uri.QueryData|?goog.structs.Map\x3c?, ?\x3e|?Object)} var_args\n *     The object from which key value pairs will be copied.\n * @suppress {deprecated} Use deprecated goog.structs.forEach to allow different\n * types of parameters.\n */\ngoog.Uri.QueryData.prototype.extend \x3d function(var_args) {\n  for (var i \x3d 0; i \x3c arguments.length; i++) {\n    var data \x3d arguments[i];\n    goog.structs.forEach(\n        data, function(value, key) { this.add(key, value); }, this);\n  }\n};\n");
SHADOW_ENV.evalLoad("goog.string.stringbuffer.js", false , "// Copyright 2006 The Closure Library Authors. All Rights Reserved.\n//\n// Licensed under the Apache License, Version 2.0 (the \x22License\x22);\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//      http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an \x22AS-IS\x22 BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\n\n/**\n * @fileoverview Utility for fast string concatenation.\n */\n\ngoog.provide(\x27goog.string.StringBuffer\x27);\n\n\n\n/**\n * Utility class to facilitate string concatenation.\n *\n * @param {*\x3d} opt_a1 Optional first initial item to append.\n * @param {...*} var_args Other initial items to\n *     append, e.g., new goog.string.StringBuffer(\x27foo\x27, \x27bar\x27).\n * @constructor\n */\ngoog.string.StringBuffer \x3d function(opt_a1, var_args) {\n  if (opt_a1 !\x3d null) {\n    this.append.apply(this, arguments);\n  }\n};\n\n\n/**\n * Internal buffer for the string to be concatenated.\n * @type {string}\n * @private\n */\ngoog.string.StringBuffer.prototype.buffer_ \x3d \x27\x27;\n\n\n/**\n * Sets the contents of the string buffer object, replacing what\x27s currently\n * there.\n *\n * @param {*} s String to set.\n */\ngoog.string.StringBuffer.prototype.set \x3d function(s) {\n  this.buffer_ \x3d \x27\x27 + s;\n};\n\n\n/**\n * Appends one or more items to the buffer.\n *\n * Calling this with null, undefined, or empty arguments is an error.\n *\n * @param {*} a1 Required first string.\n * @param {*\x3d} opt_a2 Optional second string.\n * @param {...?} var_args Other items to append,\n *     e.g., sb.append(\x27foo\x27, \x27bar\x27, \x27baz\x27).\n * @return {!goog.string.StringBuffer} This same StringBuffer object.\n * @suppress {duplicate}\n */\ngoog.string.StringBuffer.prototype.append \x3d function(a1, opt_a2, var_args) {\n  // Use a1 directly to avoid arguments instantiation for single-arg case.\n  this.buffer_ +\x3d String(a1);\n  if (opt_a2 !\x3d null) {  // second argument is undefined (null \x3d\x3d undefined)\n    for (var i \x3d 1; i \x3c arguments.length; i++) {\n      this.buffer_ +\x3d arguments[i];\n    }\n  }\n  return this;\n};\n\n\n/**\n * Clears the internal buffer.\n */\ngoog.string.StringBuffer.prototype.clear \x3d function() {\n  this.buffer_ \x3d \x27\x27;\n};\n\n\n/**\n * @return {number} the length of the current contents of the buffer.\n */\ngoog.string.StringBuffer.prototype.getLength \x3d function() {\n  return this.buffer_.length;\n};\n\n\n/**\n * @return {string} The concatenated string.\n * @override\n */\ngoog.string.StringBuffer.prototype.toString \x3d function() {\n  return this.buffer_;\n};\n");
SHADOW_ENV.evalLoad("cljs.core.js", true , "goog.provide(\x27cljs.core\x27);\ngoog.require(\x27goog.math.Long\x27);\ngoog.require(\x27goog.math.Integer\x27);\ngoog.require(\x27goog.string\x27);\ngoog.require(\x27goog.object\x27);\ngoog.require(\x27goog.array\x27);\ngoog.require(\x27goog.Uri\x27);\ngoog.require(\x27goog.string.StringBuffer\x27);\ncljs.core._STAR_clojurescript_version_STAR_ \x3d \x221.10.339\x22;\ncljs.core._STAR_unchecked_if_STAR_ \x3d false;\ncljs.core._STAR_unchecked_arrays_STAR_ \x3d false;\ncljs.core._STAR_warn_on_infer_STAR_ \x3d false;\ncljs.core._STAR_unchecked_arrays_STAR_ \x3d true;\nif((typeof cljs !\x3d\x3d \x27undefined\x27) \x26\x26 (typeof cljs.core !\x3d\x3d \x27undefined\x27) \x26\x26 (typeof cljs.core.PROTOCOL_SENTINEL !\x3d\x3d \x27undefined\x27)){\n} else {\ncljs.core.PROTOCOL_SENTINEL \x3d ({});\n}\ncljs.core.MODULE_URIS \x3d null;\ncljs.core.MODULE_INFOS \x3d null;\n\n/** @define {string} */\ngoog.define(\x22cljs.core._STAR_target_STAR_\x22,\x22default\x22);\n/**\n * Var bound to the current namespace. Only used for bootstrapping.\n * @type {*}\n */\ncljs.core._STAR_ns_STAR_ \x3d null;\n/**\n * @type {*}\n */\ncljs.core._STAR_out_STAR_ \x3d null;\ncljs.core._STAR_assert_STAR_ \x3d true;\nif((typeof cljs !\x3d\x3d \x27undefined\x27) \x26\x26 (typeof cljs.core !\x3d\x3d \x27undefined\x27) \x26\x26 (typeof cljs.core._STAR_print_fn_STAR_ !\x3d\x3d \x27undefined\x27)){\n} else {\n/**\n * Each runtime environment provides a different way to print output.\n *   Whatever function *print-fn* is bound to will be passed any\n *   Strings which should be printed.\n */\ncljs.core._STAR_print_fn_STAR_ \x3d null;\n}\n/**\n * Arranges to have tap functions executed via the supplied f, a\n *   function of no arguments. Returns true if successful, false otherwise.\n */\ncljs.core._STAR_exec_tap_fn_STAR_ \x3d (function cljs$core$_STAR_exec_tap_fn_STAR_(f){\nvar and__3938__auto__ \x3d (typeof setTimeout !\x3d\x3d \x27undefined\x27);\nif(and__3938__auto__){\nvar and__3938__auto____$1 \x3d setTimeout(f,(0));\nif(cljs.core.truth_(and__3938__auto____$1)){\nreturn true;\n} else {\nreturn and__3938__auto____$1;\n}\n} else {\nreturn and__3938__auto__;\n}\n});\nif((typeof cljs !\x3d\x3d \x27undefined\x27) \x26\x26 (typeof cljs.core !\x3d\x3d \x27undefined\x27) \x26\x26 (typeof cljs.core._STAR_print_err_fn_STAR_ !\x3d\x3d \x27undefined\x27)){\n} else {\n/**\n * Each runtime environment provides a different way to print error output.\n *   Whatever function *print-err-fn* is bound to will be passed any\n *   Strings which should be printed.\n */\ncljs.core._STAR_print_err_fn_STAR_ \x3d null;\n}\n/**\n * Set *print-fn* to f.\n */\ncljs.core.set_print_fn_BANG_ \x3d (function cljs$core$set_print_fn_BANG_(f){\nreturn cljs.core._STAR_print_fn_STAR_ \x3d f;\n});\n/**\n * Set *print-err-fn* to f.\n */\ncljs.core.set_print_err_fn_BANG_ \x3d (function cljs$core$set_print_err_fn_BANG_(f){\nreturn cljs.core._STAR_print_err_fn_STAR_ \x3d f;\n});\n/**\n * When set to true, output will be flushed whenever a newline is printed.\n * \n *   Defaults to true.\n */\ncljs.core._STAR_flush_on_newline_STAR_ \x3d true;\n/**\n * When set to logical false will drop newlines from printing calls.\n *   This is to work around the implicit newlines emitted by standard JavaScript\n *   console objects.\n */\ncljs.core._STAR_print_newline_STAR_ \x3d true;\n/**\n * When set to logical false, strings and characters will be printed with\n *   non-alphanumeric characters converted to the appropriate escape sequences.\n * \n *   Defaults to true\n */\ncljs.core._STAR_print_readably_STAR_ \x3d true;\n/**\n * If set to logical true, when printing an object, its metadata will also\n *   be printed in a form that can be read back by the reader.\n * \n *   Defaults to false.\n */\ncljs.core._STAR_print_meta_STAR_ \x3d false;\n/**\n * When set to logical true, objects will be printed in a way that preserves\n *   their type when read in later.\n * \n *   Defaults to false.\n */\ncljs.core._STAR_print_dup_STAR_ \x3d false;\n/**\n * *print-namespace-maps* controls whether the printer will print\n *   namespace map literal syntax.\n * \n *   Defaults to false, but the REPL binds it to true.\n */\ncljs.core._STAR_print_namespace_maps_STAR_ \x3d false;\n/**\n * *print-length* controls how many items of each collection the\n *   printer will print. If it is bound to logical false, there is no\n *   limit. Otherwise, it must be bound to an integer indicating the maximum\n *   number of items of each collection to print. If a collection contains\n *   more items, the printer will print items up to the limit followed by\n *   \x27...\x27 to represent the remaining items. The root binding is nil\n *   indicating no limit.\n * @type {null|number}\n */\ncljs.core._STAR_print_length_STAR_ \x3d null;\n/**\n * *print-level* controls how many levels deep the printer will\n *   print nested objects. If it is bound to logical false, there is no\n *   limit. Otherwise, it must be bound to an integer indicating the maximum\n *   level to print. Each argument to print is at level 0; if an argument is a\n *   collection, its items are at level 1; and so on. If an object is a\n *   collection and is at a level greater than or equal to the value bound to\n *   *print-level*, the printer prints \x27#\x27 to represent it. The root binding\n *   is nil indicating no limit.\n * @type {null|number}\n */\ncljs.core._STAR_print_level_STAR_ \x3d null;\n/**\n * *print-fns-bodies* controls whether functions print their source or\n *  only their names.\n */\ncljs.core._STAR_print_fn_bodies_STAR_ \x3d false;\nif((typeof cljs !\x3d\x3d \x27undefined\x27) \x26\x26 (typeof cljs.core !\x3d\x3d \x27undefined\x27) \x26\x26 (typeof cljs.core._STAR_loaded_libs_STAR_ !\x3d\x3d \x27undefined\x27)){\n} else {\n/**\n * @type {*}\n */\ncljs.core._STAR_loaded_libs_STAR_ \x3d null;\n}\ncljs.core.pr_opts \x3d (function cljs$core$pr_opts(){\nreturn new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,\x22flush-on-newline\x22,\x22flush-on-newline\x22,-151457939),cljs.core._STAR_flush_on_newline_STAR_,new cljs.core.Keyword(null,\x22readably\x22,\x22readably\x22,1129599760),cljs.core._STAR_print_readably_STAR_,new cljs.core.Keyword(null,\x22meta\x22,\x22meta\x22,1499536964),cljs.core._STAR_print_meta_STAR_,new cljs.core.Keyword(null,\x22dup\x22,\x22dup\x22,556298533),cljs.core._STAR_print_dup_STAR_,new cljs.core.Keyword(null,\x22print-length\x22,\x22print-length\x22,1931866356),cljs.core._STAR_print_length_STAR_], null);\n});\n/**\n * Set *print-fn* to console.log\n */\ncljs.core.enable_console_print_BANG_ \x3d (function cljs$core$enable_console_print_BANG_(){\ncljs.core._STAR_print_newline_STAR_ \x3d false;\n\ncljs.core.set_print_fn_BANG_((function (){\nvar xs \x3d arguments;\nreturn console.log.apply(console,goog.array.clone(xs));\n}));\n\ncljs.core.set_print_err_fn_BANG_((function (){\nvar xs \x3d arguments;\nreturn console.error.apply(console,goog.array.clone(xs));\n}));\n\nreturn null;\n});\n/**\n * Internal - do not use!\n */\ncljs.core.truth_ \x3d (function cljs$core$truth_(x){\nreturn (x !\x3d null \x26\x26 x !\x3d\x3d false);\n});\ncljs.core.not_native \x3d null;\n\n/**\n * Tests if 2 arguments are the same object\n */\ncljs.core.identical_QMARK_ \x3d (function cljs$core$identical_QMARK_(x,y){\nreturn (x \x3d\x3d\x3d y);\n});\n/**\n * Returns true if x is nil, false otherwise.\n */\ncljs.core.nil_QMARK_ \x3d (function cljs$core$nil_QMARK_(x){\nreturn (x \x3d\x3d null);\n});\n/**\n * Returns true if x is a JavaScript array.\n */\ncljs.core.array_QMARK_ \x3d (function cljs$core$array_QMARK_(x){\nif((cljs.core._STAR_target_STAR_ \x3d\x3d\x3d \x22nodejs\x22)){\nreturn Array.isArray(x);\n} else {\nreturn (x instanceof Array);\n}\n});\n/**\n * Returns true if x is a JavaScript number.\n */\ncljs.core.number_QMARK_ \x3d (function cljs$core$number_QMARK_(x){\nreturn typeof x \x3d\x3d\x3d \x27number\x27;\n});\n/**\n * Returns true if x is logical false, false otherwise.\n */\ncljs.core.not \x3d (function cljs$core$not(x){\nif((x \x3d\x3d null)){\nreturn true;\n} else {\nif(x \x3d\x3d\x3d false){\nreturn true;\n} else {\nreturn false;\n\n}\n}\n});\n/**\n * Returns true if x is not nil, false otherwise.\n */\ncljs.core.some_QMARK_ \x3d (function cljs$core$some_QMARK_(x){\nreturn !((x \x3d\x3d null));\n});\n/**\n * Returns true if x\x27s constructor is Object\n */\ncljs.core.object_QMARK_ \x3d (function cljs$core$object_QMARK_(x){\nif(!((x \x3d\x3d null))){\nreturn (x.constructor \x3d\x3d\x3d Object);\n} else {\nreturn false;\n}\n});\n/**\n * Returns true if x is a JavaScript string.\n */\ncljs.core.string_QMARK_ \x3d (function cljs$core$string_QMARK_(x){\nreturn goog.isString(x);\n});\n/**\n * Returns true if x is a JavaScript string of length one.\n */\ncljs.core.char_QMARK_ \x3d (function cljs$core$char_QMARK_(x){\nreturn ((typeof x \x3d\x3d\x3d \x27string\x27) \x26\x26 (((1) \x3d\x3d\x3d x.length)));\n});\n/**\n * Returns true if given any argument.\n */\ncljs.core.any_QMARK_ \x3d (function cljs$core$any_QMARK_(x){\nreturn true;\n});\n/**\n * Internal - do not use!\n */\ncljs.core.native_satisfies_QMARK_ \x3d (function cljs$core$native_satisfies_QMARK_(p,x){\nvar x__$1 \x3d (((x \x3d\x3d null))?null:x);\nif((p[goog.typeOf(x__$1)])){\nreturn true;\n} else {\nif((p[\x22_\x22])){\nreturn true;\n} else {\nreturn false;\n\n}\n}\n});\ncljs.core.is_proto_ \x3d (function cljs$core$is_proto_(x){\nreturn (x.constructor.prototype \x3d\x3d\x3d x);\n});\n/**\n * When compiled for a command-line target, whatever function\n *   *main-cli-fn* is set to will be called with the command-line\n *   argv as arguments\n */\ncljs.core._STAR_main_cli_fn_STAR_ \x3d null;\n/**\n * A sequence of the supplied command line arguments, or nil if\n *   none were supplied\n */\ncljs.core._STAR_command_line_args_STAR_ \x3d null;\n/**\n * Return x\x27s constructor.\n */\ncljs.core.type \x3d (function cljs$core$type(x){\nif((x \x3d\x3d null)){\nreturn null;\n} else {\nreturn x.constructor;\n}\n});\ncljs.core.missing_protocol \x3d (function cljs$core$missing_protocol(proto,obj){\nvar ty \x3d cljs.core.type(obj);\nvar ty__$1 \x3d (cljs.core.truth_((function (){var and__3938__auto__ \x3d ty;\nif(cljs.core.truth_(and__3938__auto__)){\nreturn ty.cljs$lang$type;\n} else {\nreturn and__3938__auto__;\n}\n})())?ty.cljs$lang$ctorStr:goog.typeOf(obj));\nreturn (new Error([\x22No protocol method \x22,proto,\x22 defined for type \x22,ty__$1,\x22: \x22,obj].join(\x22\x22)));\n});\ncljs.core.type__GT_str \x3d (function cljs$core$type__GT_str(ty){\nvar temp__5455__auto__ \x3d ty.cljs$lang$ctorStr;\nif(cljs.core.truth_(temp__5455__auto__)){\nvar s \x3d temp__5455__auto__;\nreturn s;\n} else {\nreturn [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ty)].join(\x27\x27);\n}\n});\ncljs.core.load_file \x3d (function cljs$core$load_file(file){\nif(cljs.core.truth_(COMPILED)){\nreturn null;\n} else {\nreturn goog.nodeGlobalRequire(file);\n}\n});\nif((((typeof Symbol !\x3d\x3d \x27undefined\x27)) \x26\x26 ((goog.typeOf(Symbol) \x3d\x3d\x3d \x22function\x22)))){\ncljs.core.ITER_SYMBOL \x3d Symbol.iterator;\n} else {\ncljs.core.ITER_SYMBOL \x3d \x22@@iterator\x22;\n}\n/**\n * @enum {string}\n */\ncljs.core.CHAR_MAP \x3d ({\x22]\x22: \x22_RBRACK_\x22, \x22\x27\x22: \x22_SINGLEQUOTE_\x22, \x22\x3d\x22: \x22_EQ_\x22, \x22\\\x22\x22: \x22_DOUBLEQUOTE_\x22, \x22!\x22: \x22_BANG_\x22, \x22*\x22: \x22_STAR_\x22, \x22%\x22: \x22_PERCENT_\x22, \x22|\x22: \x22_BAR_\x22, \x22~\x22: \x22_TILDE_\x22, \x22/\x22: \x22_SLASH_\x22, \x22\\\\\x22: \x22_BSLASH_\x22, \x22-\x22: \x22_\x22, \x22?\x22: \x22_QMARK_\x22, \x22\x26\x22: \x22_AMPERSAND_\x22, \x22:\x22: \x22_COLON_\x22, \x22\x3c\x22: \x22_LT_\x22, \x22{\x22: \x22_LBRACE_\x22, \x22}\x22: \x22_RBRACE_\x22, \x22[\x22: \x22_LBRACK_\x22, \x22#\x22: \x22_SHARP_\x22, \x22^\x22: \x22_CARET_\x22, \x22+\x22: \x22_PLUS_\x22, \x22@\x22: \x22_CIRCA_\x22, \x22\x3e\x22: \x22_GT_\x22});\n/**\n * @enum {string}\n */\ncljs.core.DEMUNGE_MAP \x3d ({\x22_RBRACE_\x22: \x22}\x22, \x22_COLON_\x22: \x22:\x22, \x22_BANG_\x22: \x22!\x22, \x22_QMARK_\x22: \x22?\x22, \x22_BSLASH_\x22: \x22\\\\\\\\\x22, \x22_SLASH_\x22: \x22/\x22, \x22_PERCENT_\x22: \x22%\x22, \x22_PLUS_\x22: \x22+\x22, \x22_SHARP_\x22: \x22#\x22, \x22_LBRACE_\x22: \x22{\x22, \x22_BAR_\x22: \x22|\x22, \x22_LBRACK_\x22: \x22[\x22, \x22_EQ_\x22: \x22\x3d\x22, \x22_\x22: \x22-\x22, \x22_TILDE_\x22: \x22~\x22, \x22_RBRACK_\x22: \x22]\x22, \x22_GT_\x22: \x22\x3e\x22, \x22_SINGLEQUOTE_\x22: \x22\x27\x22, \x22_CIRCA_\x22: \x22@\x22, \x22_AMPERSAND_\x22: \x22\x26\x22, \x22_DOUBLEQUOTE_\x22: \x22\\\\\\\x22\x22, \x22_CARET_\x22: \x22^\x22, \x22_LT_\x22: \x22\x3c\x22, \x22_STAR_\x22: \x22*\x22});\ncljs.core.DEMUNGE_PATTERN \x3d null;\n/**\n * Returns highest resolution time offered by host in milliseconds.\n */\ncljs.core.system_time \x3d (function cljs$core$system_time(){\nif((((typeof performance !\x3d\x3d \x27undefined\x27)) \x26\x26 (!((performance.now \x3d\x3d null))))){\nreturn performance.now();\n} else {\nif((((typeof process !\x3d\x3d \x27undefined\x27)) \x26\x26 (!((process.hrtime \x3d\x3d null))))){\nvar t \x3d process.hrtime();\nreturn ((((t[(0)]) * 1.0E9) + (t[(1)])) / 1000000.0);\n} else {\nreturn (new Date()).getTime();\n\n}\n}\n});\n/**\n * Construct a JavaScript array of the specified dimensions. Accepts ignored\n *   type argument for compatibility with Clojure. Note that there is no efficient\n *   way to allocate multi-dimensional arrays in JavaScript; as such, this function\n *   will run in polynomial time when called with 3 or more arguments.\n */\ncljs.core.make_array \x3d (function cljs$core$make_array(var_args){\nvar G__29407 \x3d arguments.length;\nswitch (G__29407) {\ncase 1:\nreturn cljs.core.make_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.make_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___29409 \x3d arguments.length;\nvar i__4532__auto___29410 \x3d (0);\nwhile(true){\nif((i__4532__auto___29410 \x3c len__4531__auto___29409)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___29410]));\n\nvar G__29411 \x3d (i__4532__auto___29410 + (1));\ni__4532__auto___29410 \x3d G__29411;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.make_array.cljs$core$IFn$_invoke$arity$1 \x3d (function (size){\nreturn (new Array(size));\n});\n\ncljs.core.make_array.cljs$core$IFn$_invoke$arity$2 \x3d (function (type,size){\nreturn (new Array(size));\n});\n\ncljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic \x3d (function (type,size,more_sizes){\nvar dims \x3d more_sizes;\nvar dimarray \x3d (new Array(size));\nvar n__4408__auto___29412 \x3d dimarray.length;\nvar i_29413 \x3d (0);\nwhile(true){\nif((i_29413 \x3c n__4408__auto___29412)){\n(dimarray[i_29413] \x3d (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.make_array,null,dims) : cljs.core.apply.call(null,cljs.core.make_array,null,dims)));\n\nvar G__29414 \x3d (i_29413 + (1));\ni_29413 \x3d G__29414;\ncontinue;\n} else {\n}\nbreak;\n}\n\nreturn dimarray;\n});\n\n/** @this {Function} */\ncljs.core.make_array.cljs$lang$applyTo \x3d (function (seq29404){\nvar G__29405 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq29404) : cljs.core.first.call(null,seq29404));\nvar seq29404__$1 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq29404) : cljs.core.next.call(null,seq29404));\nvar G__29406 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq29404__$1) : cljs.core.first.call(null,seq29404__$1));\nvar seq29404__$2 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq29404__$1) : cljs.core.next.call(null,seq29404__$1));\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29405,G__29406,seq29404__$2);\n});\n\ncljs.core.make_array.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * Returns a javascript array, cloned from the passed in array\n */\ncljs.core.aclone \x3d (function cljs$core$aclone(arr){\nvar len \x3d arr.length;\nvar new_arr \x3d (new Array(len));\nvar n__4408__auto___29415 \x3d len;\nvar i_29416 \x3d (0);\nwhile(true){\nif((i_29416 \x3c n__4408__auto___29415)){\n(new_arr[i_29416] \x3d (arr[i_29416]));\n\nvar G__29417 \x3d (i_29416 + (1));\ni_29416 \x3d G__29417;\ncontinue;\n} else {\n}\nbreak;\n}\n\nreturn new_arr;\n});\n/**\n * Creates a new javascript array.\n * @param {...*} var_args\n */\ncljs.core.array \x3d (function cljs$core$array(var_args){\nvar a \x3d (new Array(arguments.length));\nvar i \x3d (0);\nwhile(true){\nif((i \x3c a.length)){\n(a[i] \x3d (arguments[i]));\n\nvar G__29418 \x3d (i + (1));\ni \x3d G__29418;\ncontinue;\n} else {\nreturn a;\n}\nbreak;\n}\n});\ncljs.core.maybe_warn \x3d (function cljs$core$maybe_warn(e){\nif(cljs.core.truth_(cljs.core._STAR_print_err_fn_STAR_)){\nreturn (cljs.core._STAR_print_err_fn_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.core._STAR_print_err_fn_STAR_.cljs$core$IFn$_invoke$arity$1(e) : cljs.core._STAR_print_err_fn_STAR_.call(null,e));\n} else {\nreturn null;\n}\n});\ncljs.core.checked_aget \x3d (function cljs$core$checked_aget(var_args){\nvar G__29423 \x3d arguments.length;\nswitch (G__29423) {\ncase 2:\nreturn cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___29429 \x3d arguments.length;\nvar i__4532__auto___29430 \x3d (0);\nwhile(true){\nif((i__4532__auto___29430 \x3c len__4531__auto___29429)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___29430]));\n\nvar G__29431 \x3d (i__4532__auto___29430 + (1));\ni__4532__auto___29430 \x3d G__29431;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2 \x3d (function (array,idx){\ntry{if(cljs.core.truth_((function (){var or__3949__auto__ \x3d cljs.core.array_QMARK_(array);\nif(or__3949__auto__){\nreturn or__3949__auto__;\n} else {\nreturn goog.isArrayLike(array);\n}\n})())){\n} else {\nthrow (new Error(\x22Assert failed: (or (array? array) (goog/isArrayLike array))\x22));\n}\n\nif(typeof idx \x3d\x3d\x3d \x27number\x27){\n} else {\nthrow (new Error(\x22Assert failed: (number? idx)\x22));\n}\n\nif(!((idx \x3c (0)))){\n} else {\nthrow (new Error(\x22Assert failed: (not (neg? idx))\x22));\n}\n\nif((idx \x3c array.length)){\n} else {\nthrow (new Error(\x22Assert failed: (\x3c idx (alength array))\x22));\n}\n}catch (e29424){var e_29432 \x3d e29424;\ncljs.core.maybe_warn(e_29432);\n}\nreturn (array[idx]);\n});\n\ncljs.core.checked_aget.cljs$core$IFn$_invoke$arity$variadic \x3d (function (array,idx,idxs){\nvar G__29425 \x3d cljs.core.checked_aget;\nvar G__29426 \x3d cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2(array,idx);\nvar G__29427 \x3d idxs;\nreturn (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__29425,G__29426,G__29427) : cljs.core.apply.call(null,G__29425,G__29426,G__29427));\n});\n\n/** @this {Function} */\ncljs.core.checked_aget.cljs$lang$applyTo \x3d (function (seq29420){\nvar G__29421 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq29420) : cljs.core.first.call(null,seq29420));\nvar seq29420__$1 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq29420) : cljs.core.next.call(null,seq29420));\nvar G__29422 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq29420__$1) : cljs.core.first.call(null,seq29420__$1));\nvar seq29420__$2 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq29420__$1) : cljs.core.next.call(null,seq29420__$1));\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29421,G__29422,seq29420__$2);\n});\n\ncljs.core.checked_aget.cljs$lang$maxFixedArity \x3d (2);\n\ncljs.core.checked_aset \x3d (function cljs$core$checked_aset(var_args){\nvar G__29438 \x3d arguments.length;\nswitch (G__29438) {\ncase 3:\nreturn cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___29445 \x3d arguments.length;\nvar i__4532__auto___29446 \x3d (0);\nwhile(true){\nif((i__4532__auto___29446 \x3c len__4531__auto___29445)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___29446]));\n\nvar G__29447 \x3d (i__4532__auto___29446 + (1));\ni__4532__auto___29446 \x3d G__29447;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((3)),(0),null));\nreturn cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.checked_aset.cljs$core$IFn$_invoke$arity$3 \x3d (function (array,idx,val){\ntry{if(cljs.core.truth_((function (){var or__3949__auto__ \x3d cljs.core.array_QMARK_(array);\nif(or__3949__auto__){\nreturn or__3949__auto__;\n} else {\nreturn goog.isArrayLike(array);\n}\n})())){\n} else {\nthrow (new Error(\x22Assert failed: (or (array? array) (goog/isArrayLike array))\x22));\n}\n\nif(typeof idx \x3d\x3d\x3d \x27number\x27){\n} else {\nthrow (new Error(\x22Assert failed: (number? idx)\x22));\n}\n\nif(!((idx \x3c (0)))){\n} else {\nthrow (new Error(\x22Assert failed: (not (neg? idx))\x22));\n}\n\nif((idx \x3c array.length)){\n} else {\nthrow (new Error(\x22Assert failed: (\x3c idx (alength array))\x22));\n}\n}catch (e29439){var e_29448 \x3d e29439;\ncljs.core.maybe_warn(e_29448);\n}\nreturn (array[idx] \x3d val);\n});\n\ncljs.core.checked_aset.cljs$core$IFn$_invoke$arity$variadic \x3d (function (array,idx,idx2,idxv){\nvar G__29440 \x3d cljs.core.checked_aset;\nvar G__29441 \x3d cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2(array,idx);\nvar G__29442 \x3d idx2;\nvar G__29443 \x3d idxv;\nreturn (cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__29440,G__29441,G__29442,G__29443) : cljs.core.apply.call(null,G__29440,G__29441,G__29442,G__29443));\n});\n\n/** @this {Function} */\ncljs.core.checked_aset.cljs$lang$applyTo \x3d (function (seq29434){\nvar G__29435 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq29434) : cljs.core.first.call(null,seq29434));\nvar seq29434__$1 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq29434) : cljs.core.next.call(null,seq29434));\nvar G__29436 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq29434__$1) : cljs.core.first.call(null,seq29434__$1));\nvar seq29434__$2 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq29434__$1) : cljs.core.next.call(null,seq29434__$1));\nvar G__29437 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq29434__$2) : cljs.core.first.call(null,seq29434__$2));\nvar seq29434__$3 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq29434__$2) : cljs.core.next.call(null,seq29434__$2));\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29435,G__29436,G__29437,seq29434__$3);\n});\n\ncljs.core.checked_aset.cljs$lang$maxFixedArity \x3d (3);\n\ncljs.core.checked_aget_SINGLEQUOTE_ \x3d (function cljs$core$checked_aget_SINGLEQUOTE_(var_args){\nvar G__29453 \x3d arguments.length;\nswitch (G__29453) {\ncase 2:\nreturn cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___29458 \x3d arguments.length;\nvar i__4532__auto___29459 \x3d (0);\nwhile(true){\nif((i__4532__auto___29459 \x3c len__4531__auto___29458)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___29459]));\n\nvar G__29460 \x3d (i__4532__auto___29459 + (1));\ni__4532__auto___29459 \x3d G__29460;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 \x3d (function (array,idx){\nif(cljs.core.truth_((function (){var or__3949__auto__ \x3d cljs.core.array_QMARK_(array);\nif(or__3949__auto__){\nreturn or__3949__auto__;\n} else {\nreturn goog.isArrayLike(array);\n}\n})())){\n} else {\nthrow (new Error(\x22Assert failed: (or (array? array) (goog/isArrayLike array))\x22));\n}\n\nif(typeof idx \x3d\x3d\x3d \x27number\x27){\n} else {\nthrow (new Error(\x22Assert failed: (number? idx)\x22));\n}\n\nif(!((idx \x3c (0)))){\n} else {\nthrow (new Error(\x22Assert failed: (not (neg? idx))\x22));\n}\n\nif((idx \x3c array.length)){\n} else {\nthrow (new Error(\x22Assert failed: (\x3c idx (alength array))\x22));\n}\n\nreturn (array[idx]);\n});\n\ncljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (array,idx,idxs){\nvar G__29454 \x3d cljs.core.checked_aget_SINGLEQUOTE_;\nvar G__29455 \x3d cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(array,idx);\nvar G__29456 \x3d idxs;\nreturn (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__29454,G__29455,G__29456) : cljs.core.apply.call(null,G__29454,G__29455,G__29456));\n});\n\n/** @this {Function} */\ncljs.core.checked_aget_SINGLEQUOTE_.cljs$lang$applyTo \x3d (function (seq29450){\nvar G__29451 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq29450) : cljs.core.first.call(null,seq29450));\nvar seq29450__$1 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq29450) : cljs.core.next.call(null,seq29450));\nvar G__29452 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq29450__$1) : cljs.core.first.call(null,seq29450__$1));\nvar seq29450__$2 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq29450__$1) : cljs.core.next.call(null,seq29450__$1));\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29451,G__29452,seq29450__$2);\n});\n\ncljs.core.checked_aget_SINGLEQUOTE_.cljs$lang$maxFixedArity \x3d (2);\n\ncljs.core.checked_aset_SINGLEQUOTE_ \x3d (function cljs$core$checked_aset_SINGLEQUOTE_(var_args){\nvar G__29466 \x3d arguments.length;\nswitch (G__29466) {\ncase 3:\nreturn cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___29472 \x3d arguments.length;\nvar i__4532__auto___29473 \x3d (0);\nwhile(true){\nif((i__4532__auto___29473 \x3c len__4531__auto___29472)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___29473]));\n\nvar G__29474 \x3d (i__4532__auto___29473 + (1));\ni__4532__auto___29473 \x3d G__29474;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((3)),(0),null));\nreturn cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$3 \x3d (function (array,idx,val){\nif(cljs.core.truth_((function (){var or__3949__auto__ \x3d cljs.core.array_QMARK_(array);\nif(or__3949__auto__){\nreturn or__3949__auto__;\n} else {\nreturn goog.isArrayLike(array);\n}\n})())){\n} else {\nthrow (new Error(\x22Assert failed: (or (array? array) (goog/isArrayLike array))\x22));\n}\n\nif(typeof idx \x3d\x3d\x3d \x27number\x27){\n} else {\nthrow (new Error(\x22Assert failed: (number? idx)\x22));\n}\n\nif(!((idx \x3c (0)))){\n} else {\nthrow (new Error(\x22Assert failed: (not (neg? idx))\x22));\n}\n\nif((idx \x3c array.length)){\n} else {\nthrow (new Error(\x22Assert failed: (\x3c idx (alength array))\x22));\n}\n\nreturn (array[idx] \x3d val);\n});\n\ncljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (array,idx,idx2,idxv){\nvar G__29467 \x3d cljs.core.checked_aset_SINGLEQUOTE_;\nvar G__29468 \x3d cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(array,idx);\nvar G__29469 \x3d idx2;\nvar G__29470 \x3d idxv;\nreturn (cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__29467,G__29468,G__29469,G__29470) : cljs.core.apply.call(null,G__29467,G__29468,G__29469,G__29470));\n});\n\n/** @this {Function} */\ncljs.core.checked_aset_SINGLEQUOTE_.cljs$lang$applyTo \x3d (function (seq29462){\nvar G__29463 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq29462) : cljs.core.first.call(null,seq29462));\nvar seq29462__$1 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq29462) : cljs.core.next.call(null,seq29462));\nvar G__29464 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq29462__$1) : cljs.core.first.call(null,seq29462__$1));\nvar seq29462__$2 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq29462__$1) : cljs.core.next.call(null,seq29462__$1));\nvar G__29465 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq29462__$2) : cljs.core.first.call(null,seq29462__$2));\nvar seq29462__$3 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq29462__$2) : cljs.core.next.call(null,seq29462__$2));\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29463,G__29464,G__29465,seq29462__$3);\n});\n\ncljs.core.checked_aset_SINGLEQUOTE_.cljs$lang$maxFixedArity \x3d (3);\n\n/**\n * Returns the value at the index/indices. Works on JavaScript arrays.\n */\ncljs.core.aget \x3d (function cljs$core$aget(var_args){\nvar G__29479 \x3d arguments.length;\nswitch (G__29479) {\ncase 2:\nreturn cljs.core.aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___29484 \x3d arguments.length;\nvar i__4532__auto___29485 \x3d (0);\nwhile(true){\nif((i__4532__auto___29485 \x3c len__4531__auto___29484)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___29485]));\n\nvar G__29486 \x3d (i__4532__auto___29485 + (1));\ni__4532__auto___29485 \x3d G__29486;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.aget.cljs$core$IFn$_invoke$arity$2 \x3d (function (array,idx){\nreturn (array[idx]);\n});\n\ncljs.core.aget.cljs$core$IFn$_invoke$arity$variadic \x3d (function (array,idx,idxs){\nvar G__29480 \x3d cljs.core.aget;\nvar G__29481 \x3d (array[idx]);\nvar G__29482 \x3d idxs;\nreturn (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__29480,G__29481,G__29482) : cljs.core.apply.call(null,G__29480,G__29481,G__29482));\n});\n\n/** @this {Function} */\ncljs.core.aget.cljs$lang$applyTo \x3d (function (seq29476){\nvar G__29477 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq29476) : cljs.core.first.call(null,seq29476));\nvar seq29476__$1 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq29476) : cljs.core.next.call(null,seq29476));\nvar G__29478 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq29476__$1) : cljs.core.first.call(null,seq29476__$1));\nvar seq29476__$2 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq29476__$1) : cljs.core.next.call(null,seq29476__$1));\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29477,G__29478,seq29476__$2);\n});\n\ncljs.core.aget.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * Sets the value at the index/indices. Works on JavaScript arrays.\n *   Returns val.\n */\ncljs.core.aset \x3d (function cljs$core$aset(var_args){\nvar G__29492 \x3d arguments.length;\nswitch (G__29492) {\ncase 3:\nreturn cljs.core.aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___29498 \x3d arguments.length;\nvar i__4532__auto___29499 \x3d (0);\nwhile(true){\nif((i__4532__auto___29499 \x3c len__4531__auto___29498)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___29499]));\n\nvar G__29500 \x3d (i__4532__auto___29499 + (1));\ni__4532__auto___29499 \x3d G__29500;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((3)),(0),null));\nreturn cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.aset.cljs$core$IFn$_invoke$arity$3 \x3d (function (array,idx,val){\nreturn (array[idx] \x3d val);\n});\n\ncljs.core.aset.cljs$core$IFn$_invoke$arity$variadic \x3d (function (array,idx,idx2,idxv){\nvar G__29493 \x3d cljs.core.aset;\nvar G__29494 \x3d (array[idx]);\nvar G__29495 \x3d idx2;\nvar G__29496 \x3d idxv;\nreturn (cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__29493,G__29494,G__29495,G__29496) : cljs.core.apply.call(null,G__29493,G__29494,G__29495,G__29496));\n});\n\n/** @this {Function} */\ncljs.core.aset.cljs$lang$applyTo \x3d (function (seq29488){\nvar G__29489 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq29488) : cljs.core.first.call(null,seq29488));\nvar seq29488__$1 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq29488) : cljs.core.next.call(null,seq29488));\nvar G__29490 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq29488__$1) : cljs.core.first.call(null,seq29488__$1));\nvar seq29488__$2 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq29488__$1) : cljs.core.next.call(null,seq29488__$1));\nvar G__29491 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq29488__$2) : cljs.core.first.call(null,seq29488__$2));\nvar seq29488__$3 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq29488__$2) : cljs.core.next.call(null,seq29488__$2));\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29489,G__29490,G__29491,seq29488__$3);\n});\n\ncljs.core.aset.cljs$lang$maxFixedArity \x3d (3);\n\n/**\n * Returns the length of the array. Works on arrays of all types.\n */\ncljs.core.alength \x3d (function cljs$core$alength(array){\nreturn array.length;\n});\n/**\n * Returns an array with components set to the values in aseq. Optional type\n *   argument accepted for compatibility with Clojure.\n */\ncljs.core.into_array \x3d (function cljs$core$into_array(var_args){\nvar G__29502 \x3d arguments.length;\nswitch (G__29502) {\ncase 1:\nreturn cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.into_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core.into_array.cljs$core$IFn$_invoke$arity$1 \x3d (function (aseq){\nreturn cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null,aseq);\n});\n\ncljs.core.into_array.cljs$core$IFn$_invoke$arity$2 \x3d (function (type,aseq){\nvar G__29503 \x3d (function (a,x){\na.push(x);\n\nreturn a;\n});\nvar G__29504 \x3d [];\nvar G__29505 \x3d aseq;\nreturn (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__29503,G__29504,G__29505) : cljs.core.reduce.call(null,G__29503,G__29504,G__29505));\n});\n\ncljs.core.into_array.cljs$lang$maxFixedArity \x3d 2;\n\n/**\n * Invoke JavaScript object method via string. Needed when the\n *   string is not a valid unquoted property name.\n */\ncljs.core.js_invoke \x3d (function cljs$core$js_invoke(var_args){\nvar args__4534__auto__ \x3d [];\nvar len__4531__auto___29510 \x3d arguments.length;\nvar i__4532__auto___29511 \x3d (0);\nwhile(true){\nif((i__4532__auto___29511 \x3c len__4531__auto___29510)){\nargs__4534__auto__.push((arguments[i__4532__auto___29511]));\n\nvar G__29512 \x3d (i__4532__auto___29511 + (1));\ni__4532__auto___29511 \x3d G__29512;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4535__auto__ \x3d ((((2) \x3c args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((2)),(0),null)):null);\nreturn cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4535__auto__);\n});\n\ncljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic \x3d (function (obj,s,args){\nreturn (obj[s]).apply(obj,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));\n});\n\ncljs.core.js_invoke.cljs$lang$maxFixedArity \x3d (2);\n\n/** @this {Function} */\ncljs.core.js_invoke.cljs$lang$applyTo \x3d (function (seq29507){\nvar G__29508 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq29507) : cljs.core.first.call(null,seq29507));\nvar seq29507__$1 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq29507) : cljs.core.next.call(null,seq29507));\nvar G__29509 \x3d (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq29507__$1) : cljs.core.first.call(null,seq29507__$1));\nvar seq29507__$2 \x3d (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq29507__$1) : cljs.core.next.call(null,seq29507__$1));\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29508,G__29509,seq29507__$2);\n});\n\n\n/**\n * Marker protocol\n * @interface\n */\ncljs.core.Fn \x3d function(){};\n\n\n/**\n * Protocol for adding the ability to invoke an object as a function.\n *   For example, a vector can also be used to look up a value:\n *   ([1 2 3 4] 1) \x3d\x3e 2\n * @interface\n */\ncljs.core.IFn \x3d function(){};\n\ncljs.core._invoke \x3d (function cljs$core$_invoke(var_args){\nvar G__29514 \x3d arguments.length;\nswitch (G__29514) {\ncase 1:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ncase 4:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));\n\nbreak;\ncase 5:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));\n\nbreak;\ncase 6:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));\n\nbreak;\ncase 7:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));\n\nbreak;\ncase 8:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));\n\nbreak;\ncase 9:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));\n\nbreak;\ncase 10:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));\n\nbreak;\ncase 11:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$11((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));\n\nbreak;\ncase 12:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$12((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));\n\nbreak;\ncase 13:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$13((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]));\n\nbreak;\ncase 14:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$14((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]));\n\nbreak;\ncase 15:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$15((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]));\n\nbreak;\ncase 16:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$16((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]));\n\nbreak;\ncase 17:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$17((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]));\n\nbreak;\ncase 18:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$18((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]));\n\nbreak;\ncase 19:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$19((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]));\n\nbreak;\ncase 20:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$20((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]));\n\nbreak;\ncase 21:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$21((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]));\n\nbreak;\ncase 22:\nreturn cljs.core._invoke.cljs$core$IFn$_invoke$arity$22((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]),(arguments[(21)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core._invoke.cljs$core$IFn$_invoke$arity$1 \x3d (function (this$){\nif(((!((this$ \x3d\x3d null))) \x26\x26 (!((this$.cljs$core$IFn$_invoke$arity$1 \x3d\x3d null))))){\nreturn this$.cljs$core$IFn$_invoke$arity$1(this$);\n} else {\nvar x__4243__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4244__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4244__auto__.call(null,this$));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._invoke[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__4244__auto____$1.call(null,this$));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n}\n});\n\ncljs.core._invoke.cljs$core$IFn$_invoke$arity$2 \x3d (function (this$,a){\nif(((!((this$ \x3d\x3d null))) \x26\x26 (!((this$.cljs$core$IFn$_invoke$arity$2 \x3d\x3d null))))){\nreturn this$.cljs$core$IFn$_invoke$arity$2(this$,a);\n} else {\nvar x__4243__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4244__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(this$,a) : m__4244__auto__.call(null,this$,a));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._invoke[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(this$,a) : m__4244__auto____$1.call(null,this$,a));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n}\n});\n\ncljs.core._invoke.cljs$core$IFn$_invoke$arity$3 \x3d (function (this$,a,b){\nif(((!((this$ \x3d\x3d null))) \x26\x26 (!((this$.cljs$core$IFn$_invoke$arity$3 \x3d\x3d null))))){\nreturn this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);\n} else {\nvar x__4243__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4244__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__4244__auto__.call(null,this$,a,b));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._invoke[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__4244__auto____$1.call(null,this$,a,b));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n}\n});\n\ncljs.core._invoke.cljs$core$IFn$_invoke$arity$4 \x3d (function (this$,a,b,c){\nif(((!((this$ \x3d\x3d null))) \x26\x26 (!((this$.cljs$core$IFn$_invoke$arity$4 \x3d\x3d null))))){\nreturn this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);\n} else {\nvar x__4243__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4244__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__4244__auto__.call(null,this$,a,b,c));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._invoke[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__4244__auto____$1.call(null,this$,a,b,c));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n}\n});\n\ncljs.core._invoke.cljs$core$IFn$_invoke$arity$5 \x3d (function (this$,a,b,c,d){\nif(((!((this$ \x3d\x3d null))) \x26\x26 (!((this$.cljs$core$IFn$_invoke$arity$5 \x3d\x3d null))))){\nreturn this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);\n} else {\nvar x__4243__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4244__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__4244__auto__.call(null,this$,a,b,c,d));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._invoke[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$5 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__4244__auto____$1.call(null,this$,a,b,c,d));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n}\n});\n\ncljs.core._invoke.cljs$core$IFn$_invoke$arity$6 \x3d (function (this$,a,b,c,d,e){\nif(((!((this$ \x3d\x3d null))) \x26\x26 (!((this$.cljs$core$IFn$_invoke$arity$6 \x3d\x3d null))))){\nreturn this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);\n} else {\nvar x__4243__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4244__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$6 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__4244__auto__.call(null,this$,a,b,c,d,e));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._invoke[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$6 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__4244__auto____$1.call(null,this$,a,b,c,d,e));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n}\n});\n\ncljs.core._invoke.cljs$core$IFn$_invoke$arity$7 \x3d (function (this$,a,b,c,d,e,f){\nif(((!((this$ \x3d\x3d null))) \x26\x26 (!((this$.cljs$core$IFn$_invoke$arity$7 \x3d\x3d null))))){\nreturn this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);\n} else {\nvar x__4243__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4244__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$7 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__4244__auto__.call(null,this$,a,b,c,d,e,f));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._invoke[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$7 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__4244__auto____$1.call(null,this$,a,b,c,d,e,f));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n}\n});\n\ncljs.core._invoke.cljs$core$IFn$_invoke$arity$8 \x3d (function (this$,a,b,c,d,e,f,g){\nif(((!((this$ \x3d\x3d null))) \x26\x26 (!((this$.cljs$core$IFn$_invoke$arity$8 \x3d\x3d null))))){\nreturn this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);\n} else {\nvar x__4243__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4244__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$8 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__4244__auto__.call(null,this$,a,b,c,d,e,f,g));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._invoke[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$8 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__4244__auto____$1.call(null,this$,a,b,c,d,e,f,g));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n}\n});\n\ncljs.core._invoke.cljs$core$IFn$_invoke$arity$9 \x3d (function (this$,a,b,c,d,e,f,g,h){\nif(((!((this$ \x3d\x3d null))) \x26\x26 (!((this$.cljs$core$IFn$_invoke$arity$9 \x3d\x3d null))))){\nreturn this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);\n} else {\nvar x__4243__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4244__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$9 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__4244__auto__.call(null,this$,a,b,c,d,e,f,g,h));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._invoke[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$9 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__4244__auto____$1.call(null,this$,a,b,c,d,e,f,g,h));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n}\n});\n\ncljs.core._invoke.cljs$core$IFn$_invoke$arity$10 \x3d (function (this$,a,b,c,d,e,f,g,h,i){\nif(((!((this$ \x3d\x3d null))) \x26\x26 (!((this$.cljs$core$IFn$_invoke$arity$10 \x3d\x3d null))))){\nreturn this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);\n} else {\nvar x__4243__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4244__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$10 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__4244__auto__.call(null,this$,a,b,c,d,e,f,g,h,i));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._invoke[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$10 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__4244__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n}\n});\n\ncljs.core._invoke.cljs$core$IFn$_invoke$arity$11 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j){\nif(((!((this$ \x3d\x3d null))) \x26\x26 (!((this$.cljs$core$IFn$_invoke$arity$11 \x3d\x3d null))))){\nreturn this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);\n} else {\nvar x__4243__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4244__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$11 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__4244__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._invoke[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$11 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__4244__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n}\n});\n\ncljs.core._invoke.cljs$core$IFn$_invoke$arity$12 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k){\nif(((!((this$ \x3d\x3d null))) \x26\x26 (!((this$.cljs$core$IFn$_invoke$arity$12 \x3d\x3d null))))){\nreturn this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);\n} else {\nvar x__4243__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4244__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$12 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__4244__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._invoke[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$12 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__4244__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n}\n});\n\ncljs.core._invoke.cljs$core$IFn$_invoke$arity$13 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){\nif(((!((this$ \x3d\x3d null))) \x26\x26 (!((this$.cljs$core$IFn$_invoke$arity$13 \x3d\x3d null))))){\nreturn this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);\n} else {\nvar x__4243__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4244__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$13 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__4244__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._invoke[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$13 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__4244__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n}\n});\n\ncljs.core._invoke.cljs$core$IFn$_invoke$arity$14 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){\nif(((!((this$ \x3d\x3d null))) \x26\x26 (!((this$.cljs$core$IFn$_invoke$arity$14 \x3d\x3d null))))){\nreturn this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);\n} else {\nvar x__4243__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4244__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$14 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__4244__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._invoke[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$14 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__4244__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n}\n});\n\ncljs.core._invoke.cljs$core$IFn$_invoke$arity$15 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){\nif(((!((this$ \x3d\x3d null))) \x26\x26 (!((this$.cljs$core$IFn$_invoke$arity$15 \x3d\x3d null))))){\nreturn this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);\n} else {\nvar x__4243__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4244__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$15 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__4244__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._invoke[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$15 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__4244__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n}\n});\n\ncljs.core._invoke.cljs$core$IFn$_invoke$arity$16 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){\nif(((!((this$ \x3d\x3d null))) \x26\x26 (!((this$.cljs$core$IFn$_invoke$arity$16 \x3d\x3d null))))){\nreturn this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);\n} else {\nvar x__4243__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4244__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$16 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__4244__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._invoke[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$16 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__4244__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n}\n});\n\ncljs.core._invoke.cljs$core$IFn$_invoke$arity$17 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){\nif(((!((this$ \x3d\x3d null))) \x26\x26 (!((this$.cljs$core$IFn$_invoke$arity$17 \x3d\x3d null))))){\nreturn this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);\n} else {\nvar x__4243__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4244__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$17 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__4244__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._invoke[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$17 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__4244__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n}\n});\n\ncljs.core._invoke.cljs$core$IFn$_invoke$arity$18 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){\nif(((!((this$ \x3d\x3d null))) \x26\x26 (!((this$.cljs$core$IFn$_invoke$arity$18 \x3d\x3d null))))){\nreturn this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);\n} else {\nvar x__4243__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4244__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$18 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__4244__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._invoke[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$18 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__4244__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n}\n});\n\ncljs.core._invoke.cljs$core$IFn$_invoke$arity$19 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){\nif(((!((this$ \x3d\x3d null))) \x26\x26 (!((this$.cljs$core$IFn$_invoke$arity$19 \x3d\x3d null))))){\nreturn this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);\n} else {\nvar x__4243__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4244__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$19 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__4244__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._invoke[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$19 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__4244__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n}\n});\n\ncljs.core._invoke.cljs$core$IFn$_invoke$arity$20 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){\nif(((!((this$ \x3d\x3d null))) \x26\x26 (!((this$.cljs$core$IFn$_invoke$arity$20 \x3d\x3d null))))){\nreturn this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);\n} else {\nvar x__4243__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4244__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$20 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__4244__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._invoke[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$20 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__4244__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n}\n});\n\ncljs.core._invoke.cljs$core$IFn$_invoke$arity$21 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){\nif(((!((this$ \x3d\x3d null))) \x26\x26 (!((this$.cljs$core$IFn$_invoke$arity$21 \x3d\x3d null))))){\nreturn this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);\n} else {\nvar x__4243__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4244__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$21 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__4244__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._invoke[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$21 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__4244__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n}\n});\n\ncljs.core._invoke.cljs$core$IFn$_invoke$arity$22 \x3d (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){\nif(((!((this$ \x3d\x3d null))) \x26\x26 (!((this$.cljs$core$IFn$_invoke$arity$22 \x3d\x3d null))))){\nreturn this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);\n} else {\nvar x__4243__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4244__auto__ \x3d (cljs.core._invoke[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$22 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__4244__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._invoke[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$22 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__4244__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));\n} else {\nthrow cljs.core.missing_protocol(\x22IFn.-invoke\x22,this$);\n}\n}\n}\n});\n\ncljs.core._invoke.cljs$lang$maxFixedArity \x3d 22;\n\n\n\n/**\n * Protocol for cloning a value.\n * @interface\n */\ncljs.core.ICloneable \x3d function(){};\n\n/**\n * Creates a clone of value.\n */\ncljs.core._clone \x3d (function cljs$core$_clone(value){\nif(((!((value \x3d\x3d null))) \x26\x26 (!((value.cljs$core$ICloneable$_clone$arity$1 \x3d\x3d null))))){\nreturn value.cljs$core$ICloneable$_clone$arity$1(value);\n} else {\nvar x__4243__auto__ \x3d (((value \x3d\x3d null))?null:value);\nvar m__4244__auto__ \x3d (cljs.core._clone[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__4244__auto__.call(null,value));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._clone[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(value) : m__4244__auto____$1.call(null,value));\n} else {\nthrow cljs.core.missing_protocol(\x22ICloneable.-clone\x22,value);\n}\n}\n}\n});\n\n\n/**\n * Protocol for adding the ability to count a collection in constant time.\n * @interface\n */\ncljs.core.ICounted \x3d function(){};\n\n/**\n * Calculates the count of coll in constant time. Used by cljs.core/count.\n */\ncljs.core._count \x3d (function cljs$core$_count(coll){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$ICounted$_count$arity$1 \x3d\x3d null))))){\nreturn coll.cljs$core$ICounted$_count$arity$1(coll);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._count[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto__.call(null,coll));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._count[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto____$1.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22ICounted.-count\x22,coll);\n}\n}\n}\n});\n\n\n/**\n * Protocol for creating an empty collection.\n * @interface\n */\ncljs.core.IEmptyableCollection \x3d function(){};\n\n/**\n * Returns an empty collection of the same category as coll. Used\n *   by cljs.core/empty.\n */\ncljs.core._empty \x3d (function cljs$core$_empty(coll){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$IEmptyableCollection$_empty$arity$1 \x3d\x3d null))))){\nreturn coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._empty[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto__.call(null,coll));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._empty[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto____$1.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22IEmptyableCollection.-empty\x22,coll);\n}\n}\n}\n});\n\n\n/**\n * Protocol for adding to a collection.\n * @interface\n */\ncljs.core.ICollection \x3d function(){};\n\n/**\n * Returns a new collection of coll with o added to it. The new item\n *   should be added to the most efficient place, e.g.\n *   (conj [1 2 3 4] 5) \x3d\x3e [1 2 3 4 5]\n *   (conj \x27(2 3 4 5) 1) \x3d\x3e \x27(1 2 3 4 5)\n */\ncljs.core._conj \x3d (function cljs$core$_conj(coll,o){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$ICollection$_conj$arity$2 \x3d\x3d null))))){\nreturn coll.cljs$core$ICollection$_conj$arity$2(coll,o);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._conj[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(coll,o) : m__4244__auto__.call(null,coll,o));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._conj[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,o) : m__4244__auto____$1.call(null,coll,o));\n} else {\nthrow cljs.core.missing_protocol(\x22ICollection.-conj\x22,coll);\n}\n}\n}\n});\n\n\n/**\n * Protocol for collections to provide indexed-based access to their items.\n * @interface\n */\ncljs.core.IIndexed \x3d function(){};\n\n/**\n * Returns the value at the index n in the collection coll.\n *   Returns not-found if index n is out of bounds and not-found is supplied.\n */\ncljs.core._nth \x3d (function cljs$core$_nth(var_args){\nvar G__29517 \x3d arguments.length;\nswitch (G__29517) {\ncase 2:\nreturn cljs.core._nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core._nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core._nth.cljs$core$IFn$_invoke$arity$2 \x3d (function (coll,n){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$IIndexed$_nth$arity$2 \x3d\x3d null))))){\nreturn coll.cljs$core$IIndexed$_nth$arity$2(coll,n);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._nth[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__4244__auto__.call(null,coll,n));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._nth[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,n) : m__4244__auto____$1.call(null,coll,n));\n} else {\nthrow cljs.core.missing_protocol(\x22IIndexed.-nth\x22,coll);\n}\n}\n}\n});\n\ncljs.core._nth.cljs$core$IFn$_invoke$arity$3 \x3d (function (coll,n,not_found){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$IIndexed$_nth$arity$3 \x3d\x3d null))))){\nreturn coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._nth[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__4244__auto__.call(null,coll,n,not_found));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._nth[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__4244__auto____$1.call(null,coll,n,not_found));\n} else {\nthrow cljs.core.missing_protocol(\x22IIndexed.-nth\x22,coll);\n}\n}\n}\n});\n\ncljs.core._nth.cljs$lang$maxFixedArity \x3d 3;\n\n\n\n/**\n * Marker protocol indicating an array sequence.\n * @interface\n */\ncljs.core.ASeq \x3d function(){};\n\n\n/**\n * Protocol for collections to provide access to their items as sequences.\n * @interface\n */\ncljs.core.ISeq \x3d function(){};\n\n/**\n * Returns the first item in the collection coll. Used by cljs.core/first.\n */\ncljs.core._first \x3d (function cljs$core$_first(coll){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$ISeq$_first$arity$1 \x3d\x3d null))))){\nreturn coll.cljs$core$ISeq$_first$arity$1(coll);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._first[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto__.call(null,coll));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._first[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto____$1.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22ISeq.-first\x22,coll);\n}\n}\n}\n});\n\n/**\n * Returns a new collection of coll without the first item. It should\n *   always return a seq, e.g.\n *   (rest []) \x3d\x3e ()\n *   (rest nil) \x3d\x3e ()\n */\ncljs.core._rest \x3d (function cljs$core$_rest(coll){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$ISeq$_rest$arity$1 \x3d\x3d null))))){\nreturn coll.cljs$core$ISeq$_rest$arity$1(coll);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._rest[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto__.call(null,coll));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._rest[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto____$1.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22ISeq.-rest\x22,coll);\n}\n}\n}\n});\n\n\n/**\n * Protocol for accessing the next items of a collection.\n * @interface\n */\ncljs.core.INext \x3d function(){};\n\n/**\n * Returns a new collection of coll without the first item. In contrast to\n *   rest, it should return nil if there are no more items, e.g.\n *   (next []) \x3d\x3e nil\n *   (next nil) \x3d\x3e nil\n */\ncljs.core._next \x3d (function cljs$core$_next(coll){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$INext$_next$arity$1 \x3d\x3d null))))){\nreturn coll.cljs$core$INext$_next$arity$1(coll);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._next[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto__.call(null,coll));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._next[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto____$1.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22INext.-next\x22,coll);\n}\n}\n}\n});\n\n\n/**\n * Protocol for looking up a value in a data structure.\n * @interface\n */\ncljs.core.ILookup \x3d function(){};\n\n/**\n * Use k to look up a value in o. If not-found is supplied and k is not\n *   a valid value that can be used for look up, not-found is returned.\n */\ncljs.core._lookup \x3d (function cljs$core$_lookup(var_args){\nvar G__29520 \x3d arguments.length;\nswitch (G__29520) {\ncase 2:\nreturn cljs.core._lookup.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core._lookup.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core._lookup.cljs$core$IFn$_invoke$arity$2 \x3d (function (o,k){\nif(((!((o \x3d\x3d null))) \x26\x26 (!((o.cljs$core$ILookup$_lookup$arity$2 \x3d\x3d null))))){\nreturn o.cljs$core$ILookup$_lookup$arity$2(o,k);\n} else {\nvar x__4243__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4244__auto__ \x3d (cljs.core._lookup[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(o,k) : m__4244__auto__.call(null,o,k));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._lookup[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(o,k) : m__4244__auto____$1.call(null,o,k));\n} else {\nthrow cljs.core.missing_protocol(\x22ILookup.-lookup\x22,o);\n}\n}\n}\n});\n\ncljs.core._lookup.cljs$core$IFn$_invoke$arity$3 \x3d (function (o,k,not_found){\nif(((!((o \x3d\x3d null))) \x26\x26 (!((o.cljs$core$ILookup$_lookup$arity$3 \x3d\x3d null))))){\nreturn o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);\n} else {\nvar x__4243__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4244__auto__ \x3d (cljs.core._lookup[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__4244__auto__.call(null,o,k,not_found));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._lookup[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__4244__auto____$1.call(null,o,k,not_found));\n} else {\nthrow cljs.core.missing_protocol(\x22ILookup.-lookup\x22,o);\n}\n}\n}\n});\n\ncljs.core._lookup.cljs$lang$maxFixedArity \x3d 3;\n\n\n\n/**\n * Protocol for adding associativity to collections.\n * @interface\n */\ncljs.core.IAssociative \x3d function(){};\n\n/**\n * Returns true if k is a key in coll.\n */\ncljs.core._contains_key_QMARK_ \x3d (function cljs$core$_contains_key_QMARK_(coll,k){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 \x3d\x3d null))))){\nreturn coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._contains_key_QMARK_[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__4244__auto__.call(null,coll,k));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._contains_key_QMARK_[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,k) : m__4244__auto____$1.call(null,coll,k));\n} else {\nthrow cljs.core.missing_protocol(\x22IAssociative.-contains-key?\x22,coll);\n}\n}\n}\n});\n\n/**\n * Returns a new collection of coll with a mapping from key k to\n *   value v added to it.\n */\ncljs.core._assoc \x3d (function cljs$core$_assoc(coll,k,v){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$IAssociative$_assoc$arity$3 \x3d\x3d null))))){\nreturn coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._assoc[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__4244__auto__.call(null,coll,k,v));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._assoc[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__4244__auto____$1.call(null,coll,k,v));\n} else {\nthrow cljs.core.missing_protocol(\x22IAssociative.-assoc\x22,coll);\n}\n}\n}\n});\n\n\n/**\n * Protocol for implementing entry finding in collections.\n * @interface\n */\ncljs.core.IFind \x3d function(){};\n\n/**\n * Returns the map entry for key, or nil if key not present.\n */\ncljs.core._find \x3d (function cljs$core$_find(coll,k){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$IFind$_find$arity$2 \x3d\x3d null))))){\nreturn coll.cljs$core$IFind$_find$arity$2(coll,k);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._find[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__4244__auto__.call(null,coll,k));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._find[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,k) : m__4244__auto____$1.call(null,coll,k));\n} else {\nthrow cljs.core.missing_protocol(\x22IFind.-find\x22,coll);\n}\n}\n}\n});\n\n\n/**\n * Protocol for adding mapping functionality to collections.\n * @interface\n */\ncljs.core.IMap \x3d function(){};\n\n/**\n * Returns a new collection of coll without the mapping for key k.\n */\ncljs.core._dissoc \x3d (function cljs$core$_dissoc(coll,k){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$IMap$_dissoc$arity$2 \x3d\x3d null))))){\nreturn coll.cljs$core$IMap$_dissoc$arity$2(coll,k);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._dissoc[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__4244__auto__.call(null,coll,k));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._dissoc[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,k) : m__4244__auto____$1.call(null,coll,k));\n} else {\nthrow cljs.core.missing_protocol(\x22IMap.-dissoc\x22,coll);\n}\n}\n}\n});\n\n\n/**\n * Protocol for examining a map entry.\n * @interface\n */\ncljs.core.IMapEntry \x3d function(){};\n\n/**\n * Returns the key of the map entry.\n */\ncljs.core._key \x3d (function cljs$core$_key(coll){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$IMapEntry$_key$arity$1 \x3d\x3d null))))){\nreturn coll.cljs$core$IMapEntry$_key$arity$1(coll);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._key[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto__.call(null,coll));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._key[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto____$1.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22IMapEntry.-key\x22,coll);\n}\n}\n}\n});\n\n/**\n * Returns the value of the map entry.\n */\ncljs.core._val \x3d (function cljs$core$_val(coll){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$IMapEntry$_val$arity$1 \x3d\x3d null))))){\nreturn coll.cljs$core$IMapEntry$_val$arity$1(coll);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._val[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto__.call(null,coll));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._val[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto____$1.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22IMapEntry.-val\x22,coll);\n}\n}\n}\n});\n\n\n/**\n * Protocol for adding set functionality to a collection.\n * @interface\n */\ncljs.core.ISet \x3d function(){};\n\n/**\n * Returns a new collection of coll that does not contain v.\n */\ncljs.core._disjoin \x3d (function cljs$core$_disjoin(coll,v){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$ISet$_disjoin$arity$2 \x3d\x3d null))))){\nreturn coll.cljs$core$ISet$_disjoin$arity$2(coll,v);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._disjoin[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(coll,v) : m__4244__auto__.call(null,coll,v));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._disjoin[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,v) : m__4244__auto____$1.call(null,coll,v));\n} else {\nthrow cljs.core.missing_protocol(\x22ISet.-disjoin\x22,coll);\n}\n}\n}\n});\n\n\n/**\n * Protocol for collections to provide access to their items as stacks. The top\n *   of the stack should be accessed in the most efficient way for the different\n *   data structures.\n * @interface\n */\ncljs.core.IStack \x3d function(){};\n\n/**\n * Returns the item from the top of the stack. Is used by cljs.core/peek.\n */\ncljs.core._peek \x3d (function cljs$core$_peek(coll){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$IStack$_peek$arity$1 \x3d\x3d null))))){\nreturn coll.cljs$core$IStack$_peek$arity$1(coll);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._peek[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto__.call(null,coll));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._peek[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto____$1.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22IStack.-peek\x22,coll);\n}\n}\n}\n});\n\n/**\n * Returns a new stack without the item on top of the stack. Is used\n *   by cljs.core/pop.\n */\ncljs.core._pop \x3d (function cljs$core$_pop(coll){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$IStack$_pop$arity$1 \x3d\x3d null))))){\nreturn coll.cljs$core$IStack$_pop$arity$1(coll);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._pop[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto__.call(null,coll));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._pop[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto____$1.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22IStack.-pop\x22,coll);\n}\n}\n}\n});\n\n\n/**\n * Protocol for adding vector functionality to collections.\n * @interface\n */\ncljs.core.IVector \x3d function(){};\n\n/**\n * Returns a new vector with value val added at position n.\n */\ncljs.core._assoc_n \x3d (function cljs$core$_assoc_n(coll,n,val){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$IVector$_assoc_n$arity$3 \x3d\x3d null))))){\nreturn coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._assoc_n[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__4244__auto__.call(null,coll,n,val));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._assoc_n[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__4244__auto____$1.call(null,coll,n,val));\n} else {\nthrow cljs.core.missing_protocol(\x22IVector.-assoc-n\x22,coll);\n}\n}\n}\n});\n\n\n/**\n * Protocol for adding dereference functionality to a reference.\n * @interface\n */\ncljs.core.IDeref \x3d function(){};\n\n/**\n * Returns the value of the reference o.\n */\ncljs.core._deref \x3d (function cljs$core$_deref(o){\nif(((!((o \x3d\x3d null))) \x26\x26 (!((o.cljs$core$IDeref$_deref$arity$1 \x3d\x3d null))))){\nreturn o.cljs$core$IDeref$_deref$arity$1(o);\n} else {\nvar x__4243__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4244__auto__ \x3d (cljs.core._deref[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4244__auto__.call(null,o));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._deref[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__4244__auto____$1.call(null,o));\n} else {\nthrow cljs.core.missing_protocol(\x22IDeref.-deref\x22,o);\n}\n}\n}\n});\n\n\n/**\n * @interface\n */\ncljs.core.IDerefWithTimeout \x3d function(){};\n\ncljs.core._deref_with_timeout \x3d (function cljs$core$_deref_with_timeout(o,msec,timeout_val){\nif(((!((o \x3d\x3d null))) \x26\x26 (!((o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3 \x3d\x3d null))))){\nreturn o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);\n} else {\nvar x__4243__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4244__auto__ \x3d (cljs.core._deref_with_timeout[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__4244__auto__.call(null,o,msec,timeout_val));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._deref_with_timeout[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__4244__auto____$1.call(null,o,msec,timeout_val));\n} else {\nthrow cljs.core.missing_protocol(\x22IDerefWithTimeout.-deref-with-timeout\x22,o);\n}\n}\n}\n});\n\n\n/**\n * Protocol for accessing the metadata of an object.\n * @interface\n */\ncljs.core.IMeta \x3d function(){};\n\n/**\n * Returns the metadata of object o.\n */\ncljs.core._meta \x3d (function cljs$core$_meta(o){\nif(((!((o \x3d\x3d null))) \x26\x26 (!((o.cljs$core$IMeta$_meta$arity$1 \x3d\x3d null))))){\nreturn o.cljs$core$IMeta$_meta$arity$1(o);\n} else {\nvar x__4243__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4244__auto__ \x3d (cljs.core._meta[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4244__auto__.call(null,o));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._meta[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__4244__auto____$1.call(null,o));\n} else {\nthrow cljs.core.missing_protocol(\x22IMeta.-meta\x22,o);\n}\n}\n}\n});\n\n\n/**\n * Protocol for adding metadata to an object.\n * @interface\n */\ncljs.core.IWithMeta \x3d function(){};\n\n/**\n * Returns a new object with value of o and metadata meta added to it.\n */\ncljs.core._with_meta \x3d (function cljs$core$_with_meta(o,meta){\nif(((!((o \x3d\x3d null))) \x26\x26 (!((o.cljs$core$IWithMeta$_with_meta$arity$2 \x3d\x3d null))))){\nreturn o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);\n} else {\nvar x__4243__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4244__auto__ \x3d (cljs.core._with_meta[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(o,meta) : m__4244__auto__.call(null,o,meta));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._with_meta[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(o,meta) : m__4244__auto____$1.call(null,o,meta));\n} else {\nthrow cljs.core.missing_protocol(\x22IWithMeta.-with-meta\x22,o);\n}\n}\n}\n});\n\n\n/**\n * Protocol for seq types that can reduce themselves.\n *   Called by cljs.core/reduce.\n * @interface\n */\ncljs.core.IReduce \x3d function(){};\n\n/**\n * f should be a function of 2 arguments. If start is not supplied,\n *   returns the result of applying f to the first 2 items in coll, then\n *   applying f to that result and the 3rd item, etc.\n */\ncljs.core._reduce \x3d (function cljs$core$_reduce(var_args){\nvar G__29523 \x3d arguments.length;\nswitch (G__29523) {\ncase 2:\nreturn cljs.core._reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core._reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core._reduce.cljs$core$IFn$_invoke$arity$2 \x3d (function (coll,f){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$IReduce$_reduce$arity$2 \x3d\x3d null))))){\nreturn coll.cljs$core$IReduce$_reduce$arity$2(coll,f);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._reduce[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(coll,f) : m__4244__auto__.call(null,coll,f));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._reduce[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,f) : m__4244__auto____$1.call(null,coll,f));\n} else {\nthrow cljs.core.missing_protocol(\x22IReduce.-reduce\x22,coll);\n}\n}\n}\n});\n\ncljs.core._reduce.cljs$core$IFn$_invoke$arity$3 \x3d (function (coll,f,start){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$IReduce$_reduce$arity$3 \x3d\x3d null))))){\nreturn coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._reduce[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__4244__auto__.call(null,coll,f,start));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._reduce[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__4244__auto____$1.call(null,coll,f,start));\n} else {\nthrow cljs.core.missing_protocol(\x22IReduce.-reduce\x22,coll);\n}\n}\n}\n});\n\ncljs.core._reduce.cljs$lang$maxFixedArity \x3d 3;\n\n\n\n/**\n * Protocol for associative types that can reduce themselves\n *   via a function of key and val. Called by cljs.core/reduce-kv.\n * @interface\n */\ncljs.core.IKVReduce \x3d function(){};\n\n/**\n * Reduces an associative collection and returns the result. f should be\n *   a function that takes three arguments.\n */\ncljs.core._kv_reduce \x3d (function cljs$core$_kv_reduce(coll,f,init){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$IKVReduce$_kv_reduce$arity$3 \x3d\x3d null))))){\nreturn coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._kv_reduce[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__4244__auto__.call(null,coll,f,init));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._kv_reduce[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__4244__auto____$1.call(null,coll,f,init));\n} else {\nthrow cljs.core.missing_protocol(\x22IKVReduce.-kv-reduce\x22,coll);\n}\n}\n}\n});\n\n\n/**\n * Protocol for adding value comparison functionality to a type.\n * @interface\n */\ncljs.core.IEquiv \x3d function(){};\n\n/**\n * Returns true if o and other are equal, false otherwise.\n */\ncljs.core._equiv \x3d (function cljs$core$_equiv(o,other){\nif(((!((o \x3d\x3d null))) \x26\x26 (!((o.cljs$core$IEquiv$_equiv$arity$2 \x3d\x3d null))))){\nreturn o.cljs$core$IEquiv$_equiv$arity$2(o,other);\n} else {\nvar x__4243__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4244__auto__ \x3d (cljs.core._equiv[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(o,other) : m__4244__auto__.call(null,o,other));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._equiv[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(o,other) : m__4244__auto____$1.call(null,o,other));\n} else {\nthrow cljs.core.missing_protocol(\x22IEquiv.-equiv\x22,o);\n}\n}\n}\n});\n\n\n/**\n * Protocol for adding hashing functionality to a type.\n * @interface\n */\ncljs.core.IHash \x3d function(){};\n\n/**\n * Returns the hash code of o.\n */\ncljs.core._hash \x3d (function cljs$core$_hash(o){\nif(((!((o \x3d\x3d null))) \x26\x26 (!((o.cljs$core$IHash$_hash$arity$1 \x3d\x3d null))))){\nreturn o.cljs$core$IHash$_hash$arity$1(o);\n} else {\nvar x__4243__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4244__auto__ \x3d (cljs.core._hash[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4244__auto__.call(null,o));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._hash[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__4244__auto____$1.call(null,o));\n} else {\nthrow cljs.core.missing_protocol(\x22IHash.-hash\x22,o);\n}\n}\n}\n});\n\n\n/**\n * Protocol for adding the ability to a type to be transformed into a sequence.\n * @interface\n */\ncljs.core.ISeqable \x3d function(){};\n\n/**\n * Returns a seq of o, or nil if o is empty.\n */\ncljs.core._seq \x3d (function cljs$core$_seq(o){\nif(((!((o \x3d\x3d null))) \x26\x26 (!((o.cljs$core$ISeqable$_seq$arity$1 \x3d\x3d null))))){\nreturn o.cljs$core$ISeqable$_seq$arity$1(o);\n} else {\nvar x__4243__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4244__auto__ \x3d (cljs.core._seq[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4244__auto__.call(null,o));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._seq[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__4244__auto____$1.call(null,o));\n} else {\nthrow cljs.core.missing_protocol(\x22ISeqable.-seq\x22,o);\n}\n}\n}\n});\n\n\n/**\n * Marker interface indicating a persistent collection of sequential items\n * @interface\n */\ncljs.core.ISequential \x3d function(){};\n\n\n/**\n * Marker interface indicating a persistent list\n * @interface\n */\ncljs.core.IList \x3d function(){};\n\n\n/**\n * Marker interface indicating a record object\n * @interface\n */\ncljs.core.IRecord \x3d function(){};\n\n\n/**\n * Protocol for reversing a seq.\n * @interface\n */\ncljs.core.IReversible \x3d function(){};\n\n/**\n * Returns a seq of the items in coll in reversed order.\n */\ncljs.core._rseq \x3d (function cljs$core$_rseq(coll){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$IReversible$_rseq$arity$1 \x3d\x3d null))))){\nreturn coll.cljs$core$IReversible$_rseq$arity$1(coll);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._rseq[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto__.call(null,coll));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._rseq[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto____$1.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22IReversible.-rseq\x22,coll);\n}\n}\n}\n});\n\n\n/**\n * Protocol for a collection which can represent their items\n *   in a sorted manner. \n * @interface\n */\ncljs.core.ISorted \x3d function(){};\n\n/**\n * Returns a sorted seq from coll in either ascending or descending order.\n */\ncljs.core._sorted_seq \x3d (function cljs$core$_sorted_seq(coll,ascending_QMARK_){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$ISorted$_sorted_seq$arity$2 \x3d\x3d null))))){\nreturn coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._sorted_seq[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__4244__auto__.call(null,coll,ascending_QMARK_));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._sorted_seq[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__4244__auto____$1.call(null,coll,ascending_QMARK_));\n} else {\nthrow cljs.core.missing_protocol(\x22ISorted.-sorted-seq\x22,coll);\n}\n}\n}\n});\n\n/**\n * Returns a sorted seq from coll in either ascending or descending order.\n *   If ascending is true, the result should contain all items which are \x3e or \x3e\x3d\n *   than k. If ascending is false, the result should contain all items which\n *   are \x3c or \x3c\x3d than k, e.g.\n *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) \x3d\x3e (3 4 5)\n *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) \x3d\x3e (3 2 1)\n */\ncljs.core._sorted_seq_from \x3d (function cljs$core$_sorted_seq_from(coll,k,ascending_QMARK_){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$ISorted$_sorted_seq_from$arity$3 \x3d\x3d null))))){\nreturn coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._sorted_seq_from[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__4244__auto__.call(null,coll,k,ascending_QMARK_));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._sorted_seq_from[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__4244__auto____$1.call(null,coll,k,ascending_QMARK_));\n} else {\nthrow cljs.core.missing_protocol(\x22ISorted.-sorted-seq-from\x22,coll);\n}\n}\n}\n});\n\n/**\n * Returns the key for entry.\n */\ncljs.core._entry_key \x3d (function cljs$core$_entry_key(coll,entry){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$ISorted$_entry_key$arity$2 \x3d\x3d null))))){\nreturn coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._entry_key[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__4244__auto__.call(null,coll,entry));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._entry_key[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__4244__auto____$1.call(null,coll,entry));\n} else {\nthrow cljs.core.missing_protocol(\x22ISorted.-entry-key\x22,coll);\n}\n}\n}\n});\n\n/**\n * Returns the comparator for coll.\n */\ncljs.core._comparator \x3d (function cljs$core$_comparator(coll){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$ISorted$_comparator$arity$1 \x3d\x3d null))))){\nreturn coll.cljs$core$ISorted$_comparator$arity$1(coll);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._comparator[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto__.call(null,coll));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._comparator[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto____$1.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22ISorted.-comparator\x22,coll);\n}\n}\n}\n});\n\n\n/**\n * Protocol for writing. Currently only implemented by StringBufferWriter.\n * @interface\n */\ncljs.core.IWriter \x3d function(){};\n\n/**\n * Writes s with writer and returns the result.\n */\ncljs.core._write \x3d (function cljs$core$_write(writer,s){\nif(((!((writer \x3d\x3d null))) \x26\x26 (!((writer.cljs$core$IWriter$_write$arity$2 \x3d\x3d null))))){\nreturn writer.cljs$core$IWriter$_write$arity$2(writer,s);\n} else {\nvar x__4243__auto__ \x3d (((writer \x3d\x3d null))?null:writer);\nvar m__4244__auto__ \x3d (cljs.core._write[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(writer,s) : m__4244__auto__.call(null,writer,s));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._write[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(writer,s) : m__4244__auto____$1.call(null,writer,s));\n} else {\nthrow cljs.core.missing_protocol(\x22IWriter.-write\x22,writer);\n}\n}\n}\n});\n\n/**\n * Flush writer.\n */\ncljs.core._flush \x3d (function cljs$core$_flush(writer){\nif(((!((writer \x3d\x3d null))) \x26\x26 (!((writer.cljs$core$IWriter$_flush$arity$1 \x3d\x3d null))))){\nreturn writer.cljs$core$IWriter$_flush$arity$1(writer);\n} else {\nvar x__4243__auto__ \x3d (((writer \x3d\x3d null))?null:writer);\nvar m__4244__auto__ \x3d (cljs.core._flush[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__4244__auto__.call(null,writer));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._flush[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(writer) : m__4244__auto____$1.call(null,writer));\n} else {\nthrow cljs.core.missing_protocol(\x22IWriter.-flush\x22,writer);\n}\n}\n}\n});\n\n\n/**\n * The old IPrintable protocol\x27s implementation consisted of building a giant\n * list of strings to concatenate.  This involved lots of concat calls,\n * intermediate vectors, and lazy-seqs, and was very slow in some older JS\n * engines.  IPrintWithWriter implements printing via the IWriter protocol, so it\n * be implemented efficiently in terms of e.g. a StringBuffer append.\n * @interface\n */\ncljs.core.IPrintWithWriter \x3d function(){};\n\ncljs.core._pr_writer \x3d (function cljs$core$_pr_writer(o,writer,opts){\nif(((!((o \x3d\x3d null))) \x26\x26 (!((o.cljs$core$IPrintWithWriter$_pr_writer$arity$3 \x3d\x3d null))))){\nreturn o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);\n} else {\nvar x__4243__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4244__auto__ \x3d (cljs.core._pr_writer[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__4244__auto__.call(null,o,writer,opts));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._pr_writer[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__4244__auto____$1.call(null,o,writer,opts));\n} else {\nthrow cljs.core.missing_protocol(\x22IPrintWithWriter.-pr-writer\x22,o);\n}\n}\n}\n});\n\n\n/**\n * Protocol for types which can have a deferred realization. Currently only\n *   implemented by Delay and LazySeq.\n * @interface\n */\ncljs.core.IPending \x3d function(){};\n\n/**\n * Returns true if a value for x has been produced, false otherwise.\n */\ncljs.core._realized_QMARK_ \x3d (function cljs$core$_realized_QMARK_(x){\nif(((!((x \x3d\x3d null))) \x26\x26 (!((x.cljs$core$IPending$_realized_QMARK_$arity$1 \x3d\x3d null))))){\nreturn x.cljs$core$IPending$_realized_QMARK_$arity$1(x);\n} else {\nvar x__4243__auto__ \x3d (((x \x3d\x3d null))?null:x);\nvar m__4244__auto__ \x3d (cljs.core._realized_QMARK_[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4244__auto__.call(null,x));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._realized_QMARK_[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__4244__auto____$1.call(null,x));\n} else {\nthrow cljs.core.missing_protocol(\x22IPending.-realized?\x22,x);\n}\n}\n}\n});\n\n\n/**\n * Protocol for types that can be watched. Currently only implemented by Atom.\n * @interface\n */\ncljs.core.IWatchable \x3d function(){};\n\n/**\n * Calls all watchers with this, oldval and newval.\n */\ncljs.core._notify_watches \x3d (function cljs$core$_notify_watches(this$,oldval,newval){\nif(((!((this$ \x3d\x3d null))) \x26\x26 (!((this$.cljs$core$IWatchable$_notify_watches$arity$3 \x3d\x3d null))))){\nreturn this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);\n} else {\nvar x__4243__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4244__auto__ \x3d (cljs.core._notify_watches[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__4244__auto__.call(null,this$,oldval,newval));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._notify_watches[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__4244__auto____$1.call(null,this$,oldval,newval));\n} else {\nthrow cljs.core.missing_protocol(\x22IWatchable.-notify-watches\x22,this$);\n}\n}\n}\n});\n\n/**\n * Adds a watcher function f to this. Keys must be unique per reference,\n *   and can be used to remove the watch with -remove-watch.\n */\ncljs.core._add_watch \x3d (function cljs$core$_add_watch(this$,key,f){\nif(((!((this$ \x3d\x3d null))) \x26\x26 (!((this$.cljs$core$IWatchable$_add_watch$arity$3 \x3d\x3d null))))){\nreturn this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);\n} else {\nvar x__4243__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4244__auto__ \x3d (cljs.core._add_watch[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__4244__auto__.call(null,this$,key,f));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._add_watch[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__4244__auto____$1.call(null,this$,key,f));\n} else {\nthrow cljs.core.missing_protocol(\x22IWatchable.-add-watch\x22,this$);\n}\n}\n}\n});\n\n/**\n * Removes watcher that corresponds to key from this.\n */\ncljs.core._remove_watch \x3d (function cljs$core$_remove_watch(this$,key){\nif(((!((this$ \x3d\x3d null))) \x26\x26 (!((this$.cljs$core$IWatchable$_remove_watch$arity$2 \x3d\x3d null))))){\nreturn this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);\n} else {\nvar x__4243__auto__ \x3d (((this$ \x3d\x3d null))?null:this$);\nvar m__4244__auto__ \x3d (cljs.core._remove_watch[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(this$,key) : m__4244__auto__.call(null,this$,key));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._remove_watch[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(this$,key) : m__4244__auto____$1.call(null,this$,key));\n} else {\nthrow cljs.core.missing_protocol(\x22IWatchable.-remove-watch\x22,this$);\n}\n}\n}\n});\n\n\n/**\n * Protocol for collections which can transformed to transients.\n * @interface\n */\ncljs.core.IEditableCollection \x3d function(){};\n\n/**\n * Returns a new, transient version of the collection, in constant time.\n */\ncljs.core._as_transient \x3d (function cljs$core$_as_transient(coll){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$IEditableCollection$_as_transient$arity$1 \x3d\x3d null))))){\nreturn coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._as_transient[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto__.call(null,coll));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._as_transient[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto____$1.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22IEditableCollection.-as-transient\x22,coll);\n}\n}\n}\n});\n\n\n/**\n * Protocol for adding basic functionality to transient collections.\n * @interface\n */\ncljs.core.ITransientCollection \x3d function(){};\n\n/**\n * Adds value val to tcoll and returns tcoll.\n */\ncljs.core._conj_BANG_ \x3d (function cljs$core$_conj_BANG_(tcoll,val){\nif(((!((tcoll \x3d\x3d null))) \x26\x26 (!((tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2 \x3d\x3d null))))){\nreturn tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);\n} else {\nvar x__4243__auto__ \x3d (((tcoll \x3d\x3d null))?null:tcoll);\nvar m__4244__auto__ \x3d (cljs.core._conj_BANG_[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__4244__auto__.call(null,tcoll,val));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._conj_BANG_[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__4244__auto____$1.call(null,tcoll,val));\n} else {\nthrow cljs.core.missing_protocol(\x22ITransientCollection.-conj!\x22,tcoll);\n}\n}\n}\n});\n\n/**\n * Creates a persistent data structure from tcoll and returns it.\n */\ncljs.core._persistent_BANG_ \x3d (function cljs$core$_persistent_BANG_(tcoll){\nif(((!((tcoll \x3d\x3d null))) \x26\x26 (!((tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 \x3d\x3d null))))){\nreturn tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);\n} else {\nvar x__4243__auto__ \x3d (((tcoll \x3d\x3d null))?null:tcoll);\nvar m__4244__auto__ \x3d (cljs.core._persistent_BANG_[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__4244__auto__.call(null,tcoll));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._persistent_BANG_[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(tcoll) : m__4244__auto____$1.call(null,tcoll));\n} else {\nthrow cljs.core.missing_protocol(\x22ITransientCollection.-persistent!\x22,tcoll);\n}\n}\n}\n});\n\n\n/**\n * Protocol for adding associativity to transient collections.\n * @interface\n */\ncljs.core.ITransientAssociative \x3d function(){};\n\n/**\n * Returns a new transient collection of tcoll with a mapping from key to\n *   val added to it.\n */\ncljs.core._assoc_BANG_ \x3d (function cljs$core$_assoc_BANG_(tcoll,key,val){\nif(((!((tcoll \x3d\x3d null))) \x26\x26 (!((tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 \x3d\x3d null))))){\nreturn tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);\n} else {\nvar x__4243__auto__ \x3d (((tcoll \x3d\x3d null))?null:tcoll);\nvar m__4244__auto__ \x3d (cljs.core._assoc_BANG_[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__4244__auto__.call(null,tcoll,key,val));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._assoc_BANG_[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__4244__auto____$1.call(null,tcoll,key,val));\n} else {\nthrow cljs.core.missing_protocol(\x22ITransientAssociative.-assoc!\x22,tcoll);\n}\n}\n}\n});\n\n\n/**\n * Protocol for adding mapping functionality to transient collections.\n * @interface\n */\ncljs.core.ITransientMap \x3d function(){};\n\n/**\n * Returns a new transient collection of tcoll without the mapping for key.\n */\ncljs.core._dissoc_BANG_ \x3d (function cljs$core$_dissoc_BANG_(tcoll,key){\nif(((!((tcoll \x3d\x3d null))) \x26\x26 (!((tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 \x3d\x3d null))))){\nreturn tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);\n} else {\nvar x__4243__auto__ \x3d (((tcoll \x3d\x3d null))?null:tcoll);\nvar m__4244__auto__ \x3d (cljs.core._dissoc_BANG_[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__4244__auto__.call(null,tcoll,key));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._dissoc_BANG_[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__4244__auto____$1.call(null,tcoll,key));\n} else {\nthrow cljs.core.missing_protocol(\x22ITransientMap.-dissoc!\x22,tcoll);\n}\n}\n}\n});\n\n\n/**\n * Protocol for adding vector functionality to transient collections.\n * @interface\n */\ncljs.core.ITransientVector \x3d function(){};\n\n/**\n * Returns tcoll with value val added at position n.\n */\ncljs.core._assoc_n_BANG_ \x3d (function cljs$core$_assoc_n_BANG_(tcoll,n,val){\nif(((!((tcoll \x3d\x3d null))) \x26\x26 (!((tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 \x3d\x3d null))))){\nreturn tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);\n} else {\nvar x__4243__auto__ \x3d (((tcoll \x3d\x3d null))?null:tcoll);\nvar m__4244__auto__ \x3d (cljs.core._assoc_n_BANG_[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__4244__auto__.call(null,tcoll,n,val));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._assoc_n_BANG_[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__4244__auto____$1.call(null,tcoll,n,val));\n} else {\nthrow cljs.core.missing_protocol(\x22ITransientVector.-assoc-n!\x22,tcoll);\n}\n}\n}\n});\n\n/**\n * Returns tcoll with the last item removed from it.\n */\ncljs.core._pop_BANG_ \x3d (function cljs$core$_pop_BANG_(tcoll){\nif(((!((tcoll \x3d\x3d null))) \x26\x26 (!((tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1 \x3d\x3d null))))){\nreturn tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);\n} else {\nvar x__4243__auto__ \x3d (((tcoll \x3d\x3d null))?null:tcoll);\nvar m__4244__auto__ \x3d (cljs.core._pop_BANG_[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__4244__auto__.call(null,tcoll));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._pop_BANG_[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(tcoll) : m__4244__auto____$1.call(null,tcoll));\n} else {\nthrow cljs.core.missing_protocol(\x22ITransientVector.-pop!\x22,tcoll);\n}\n}\n}\n});\n\n\n/**\n * Protocol for adding set functionality to a transient collection.\n * @interface\n */\ncljs.core.ITransientSet \x3d function(){};\n\n/**\n * Returns tcoll without v.\n */\ncljs.core._disjoin_BANG_ \x3d (function cljs$core$_disjoin_BANG_(tcoll,v){\nif(((!((tcoll \x3d\x3d null))) \x26\x26 (!((tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 \x3d\x3d null))))){\nreturn tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);\n} else {\nvar x__4243__auto__ \x3d (((tcoll \x3d\x3d null))?null:tcoll);\nvar m__4244__auto__ \x3d (cljs.core._disjoin_BANG_[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__4244__auto__.call(null,tcoll,v));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._disjoin_BANG_[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__4244__auto____$1.call(null,tcoll,v));\n} else {\nthrow cljs.core.missing_protocol(\x22ITransientSet.-disjoin!\x22,tcoll);\n}\n}\n}\n});\n\n\n/**\n * Protocol for values that can be compared.\n * @interface\n */\ncljs.core.IComparable \x3d function(){};\n\n/**\n * Returns a negative number, zero, or a positive number when x is logically\n *   \x27less than\x27, \x27equal to\x27, or \x27greater than\x27 y.\n */\ncljs.core._compare \x3d (function cljs$core$_compare(x,y){\nif(((!((x \x3d\x3d null))) \x26\x26 (!((x.cljs$core$IComparable$_compare$arity$2 \x3d\x3d null))))){\nreturn x.cljs$core$IComparable$_compare$arity$2(x,y);\n} else {\nvar x__4243__auto__ \x3d (((x \x3d\x3d null))?null:x);\nvar m__4244__auto__ \x3d (cljs.core._compare[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__4244__auto__.call(null,x,y));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._compare[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(x,y) : m__4244__auto____$1.call(null,x,y));\n} else {\nthrow cljs.core.missing_protocol(\x22IComparable.-compare\x22,x);\n}\n}\n}\n});\n\n\n/**\n * Protocol for accessing the items of a chunk.\n * @interface\n */\ncljs.core.IChunk \x3d function(){};\n\n/**\n * Return a new chunk of coll with the first item removed.\n */\ncljs.core._drop_first \x3d (function cljs$core$_drop_first(coll){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$IChunk$_drop_first$arity$1 \x3d\x3d null))))){\nreturn coll.cljs$core$IChunk$_drop_first$arity$1(coll);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._drop_first[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto__.call(null,coll));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._drop_first[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto____$1.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22IChunk.-drop-first\x22,coll);\n}\n}\n}\n});\n\n\n/**\n * Protocol for accessing a collection as sequential chunks.\n * @interface\n */\ncljs.core.IChunkedSeq \x3d function(){};\n\n/**\n * Returns the first chunk in coll.\n */\ncljs.core._chunked_first \x3d (function cljs$core$_chunked_first(coll){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$IChunkedSeq$_chunked_first$arity$1 \x3d\x3d null))))){\nreturn coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._chunked_first[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto__.call(null,coll));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._chunked_first[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto____$1.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22IChunkedSeq.-chunked-first\x22,coll);\n}\n}\n}\n});\n\n/**\n * Return a new collection of coll with the first chunk removed.\n */\ncljs.core._chunked_rest \x3d (function cljs$core$_chunked_rest(coll){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1 \x3d\x3d null))))){\nreturn coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._chunked_rest[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto__.call(null,coll));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._chunked_rest[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto____$1.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22IChunkedSeq.-chunked-rest\x22,coll);\n}\n}\n}\n});\n\n\n/**\n * Protocol for accessing the chunks of a collection.\n * @interface\n */\ncljs.core.IChunkedNext \x3d function(){};\n\n/**\n * Returns a new collection of coll without the first chunk.\n */\ncljs.core._chunked_next \x3d (function cljs$core$_chunked_next(coll){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$IChunkedNext$_chunked_next$arity$1 \x3d\x3d null))))){\nreturn coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._chunked_next[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto__.call(null,coll));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._chunked_next[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto____$1.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22IChunkedNext.-chunked-next\x22,coll);\n}\n}\n}\n});\n\n\n/**\n * Protocol for adding a name.\n * @interface\n */\ncljs.core.INamed \x3d function(){};\n\n/**\n * Returns the name String of x.\n */\ncljs.core._name \x3d (function cljs$core$_name(x){\nif(((!((x \x3d\x3d null))) \x26\x26 (!((x.cljs$core$INamed$_name$arity$1 \x3d\x3d null))))){\nreturn x.cljs$core$INamed$_name$arity$1(x);\n} else {\nvar x__4243__auto__ \x3d (((x \x3d\x3d null))?null:x);\nvar m__4244__auto__ \x3d (cljs.core._name[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4244__auto__.call(null,x));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._name[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__4244__auto____$1.call(null,x));\n} else {\nthrow cljs.core.missing_protocol(\x22INamed.-name\x22,x);\n}\n}\n}\n});\n\n/**\n * Returns the namespace String of x.\n */\ncljs.core._namespace \x3d (function cljs$core$_namespace(x){\nif(((!((x \x3d\x3d null))) \x26\x26 (!((x.cljs$core$INamed$_namespace$arity$1 \x3d\x3d null))))){\nreturn x.cljs$core$INamed$_namespace$arity$1(x);\n} else {\nvar x__4243__auto__ \x3d (((x \x3d\x3d null))?null:x);\nvar m__4244__auto__ \x3d (cljs.core._namespace[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4244__auto__.call(null,x));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._namespace[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__4244__auto____$1.call(null,x));\n} else {\nthrow cljs.core.missing_protocol(\x22INamed.-namespace\x22,x);\n}\n}\n}\n});\n\n\n/**\n * Marker protocol indicating an atom.\n * @interface\n */\ncljs.core.IAtom \x3d function(){};\n\n\n/**\n * Protocol for adding resetting functionality.\n * @interface\n */\ncljs.core.IReset \x3d function(){};\n\n/**\n * Sets the value of o to new-value.\n */\ncljs.core._reset_BANG_ \x3d (function cljs$core$_reset_BANG_(o,new_value){\nif(((!((o \x3d\x3d null))) \x26\x26 (!((o.cljs$core$IReset$_reset_BANG_$arity$2 \x3d\x3d null))))){\nreturn o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);\n} else {\nvar x__4243__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4244__auto__ \x3d (cljs.core._reset_BANG_[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__4244__auto__.call(null,o,new_value));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._reset_BANG_[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__4244__auto____$1.call(null,o,new_value));\n} else {\nthrow cljs.core.missing_protocol(\x22IReset.-reset!\x22,o);\n}\n}\n}\n});\n\n\n/**\n * Protocol for adding swapping functionality.\n * @interface\n */\ncljs.core.ISwap \x3d function(){};\n\n/**\n * Swaps the value of o to be (apply f current-value-of-atom args).\n */\ncljs.core._swap_BANG_ \x3d (function cljs$core$_swap_BANG_(var_args){\nvar G__29526 \x3d arguments.length;\nswitch (G__29526) {\ncase 2:\nreturn cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ncase 4:\nreturn cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));\n\nbreak;\ncase 5:\nreturn cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 \x3d (function (o,f){\nif(((!((o \x3d\x3d null))) \x26\x26 (!((o.cljs$core$ISwap$_swap_BANG_$arity$2 \x3d\x3d null))))){\nreturn o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);\n} else {\nvar x__4243__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4244__auto__ \x3d (cljs.core._swap_BANG_[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(o,f) : m__4244__auto__.call(null,o,f));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._swap_BANG_[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(o,f) : m__4244__auto____$1.call(null,o,f));\n} else {\nthrow cljs.core.missing_protocol(\x22ISwap.-swap!\x22,o);\n}\n}\n}\n});\n\ncljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 \x3d (function (o,f,a){\nif(((!((o \x3d\x3d null))) \x26\x26 (!((o.cljs$core$ISwap$_swap_BANG_$arity$3 \x3d\x3d null))))){\nreturn o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);\n} else {\nvar x__4243__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4244__auto__ \x3d (cljs.core._swap_BANG_[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__4244__auto__.call(null,o,f,a));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._swap_BANG_[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__4244__auto____$1.call(null,o,f,a));\n} else {\nthrow cljs.core.missing_protocol(\x22ISwap.-swap!\x22,o);\n}\n}\n}\n});\n\ncljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 \x3d (function (o,f,a,b){\nif(((!((o \x3d\x3d null))) \x26\x26 (!((o.cljs$core$ISwap$_swap_BANG_$arity$4 \x3d\x3d null))))){\nreturn o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);\n} else {\nvar x__4243__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4244__auto__ \x3d (cljs.core._swap_BANG_[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__4244__auto__.call(null,o,f,a,b));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._swap_BANG_[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__4244__auto____$1.call(null,o,f,a,b));\n} else {\nthrow cljs.core.missing_protocol(\x22ISwap.-swap!\x22,o);\n}\n}\n}\n});\n\ncljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 \x3d (function (o,f,a,b,xs){\nif(((!((o \x3d\x3d null))) \x26\x26 (!((o.cljs$core$ISwap$_swap_BANG_$arity$5 \x3d\x3d null))))){\nreturn o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);\n} else {\nvar x__4243__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4244__auto__ \x3d (cljs.core._swap_BANG_[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__4244__auto__.call(null,o,f,a,b,xs));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._swap_BANG_[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$5 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__4244__auto____$1.call(null,o,f,a,b,xs));\n} else {\nthrow cljs.core.missing_protocol(\x22ISwap.-swap!\x22,o);\n}\n}\n}\n});\n\ncljs.core._swap_BANG_.cljs$lang$maxFixedArity \x3d 5;\n\n\n\n/**\n * Protocol for adding volatile functionality.\n * @interface\n */\ncljs.core.IVolatile \x3d function(){};\n\n/**\n * Sets the value of volatile o to new-value without regard for the\n *   current value. Returns new-value.\n */\ncljs.core._vreset_BANG_ \x3d (function cljs$core$_vreset_BANG_(o,new_value){\nif(((!((o \x3d\x3d null))) \x26\x26 (!((o.cljs$core$IVolatile$_vreset_BANG_$arity$2 \x3d\x3d null))))){\nreturn o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);\n} else {\nvar x__4243__auto__ \x3d (((o \x3d\x3d null))?null:o);\nvar m__4244__auto__ \x3d (cljs.core._vreset_BANG_[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__4244__auto__.call(null,o,new_value));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._vreset_BANG_[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__4244__auto____$1.call(null,o,new_value));\n} else {\nthrow cljs.core.missing_protocol(\x22IVolatile.-vreset!\x22,o);\n}\n}\n}\n});\n\n\n/**\n * Protocol for iterating over a collection.\n * @interface\n */\ncljs.core.IIterable \x3d function(){};\n\n/**\n * Returns an iterator for coll.\n */\ncljs.core._iterator \x3d (function cljs$core$_iterator(coll){\nif(((!((coll \x3d\x3d null))) \x26\x26 (!((coll.cljs$core$IIterable$_iterator$arity$1 \x3d\x3d null))))){\nreturn coll.cljs$core$IIterable$_iterator$arity$1(coll);\n} else {\nvar x__4243__auto__ \x3d (((coll \x3d\x3d null))?null:coll);\nvar m__4244__auto__ \x3d (cljs.core._iterator[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto__.call(null,coll));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core._iterator[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4244__auto____$1.call(null,coll));\n} else {\nthrow cljs.core.missing_protocol(\x22IIterable.-iterator\x22,coll);\n}\n}\n}\n});\n\n\n/**\n* @constructor\n * @implements {cljs.core.IWriter}\n*/\ncljs.core.StringBufferWriter \x3d (function (sb){\nthis.sb \x3d sb;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 1073741824;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 0;\n});\ncljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 \x3d (function (_,s){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn self__.sb.append(s);\n});\n\ncljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn null;\n});\n\ncljs.core.StringBufferWriter.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22sb\x22,\x22sb\x22,-1249746442,null)], null);\n});\n\ncljs.core.StringBufferWriter.cljs$lang$type \x3d true;\n\ncljs.core.StringBufferWriter.cljs$lang$ctorStr \x3d \x22cljs.core/StringBufferWriter\x22;\n\ncljs.core.StringBufferWriter.cljs$lang$ctorPrWriter \x3d (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){\nreturn cljs.core._write(writer__4193__auto__,\x22cljs.core/StringBufferWriter\x22);\n});\n\n/**\n * Positional factory function for cljs.core/StringBufferWriter.\n */\ncljs.core.__GT_StringBufferWriter \x3d (function cljs$core$__GT_StringBufferWriter(sb){\nreturn (new cljs.core.StringBufferWriter(sb));\n});\n\n/**\n * Support so that collections can implement toString without\n * loading all the printing machinery.\n */\ncljs.core.pr_str_STAR_ \x3d (function cljs$core$pr_str_STAR_(obj){\nvar sb \x3d (new goog.string.StringBuffer());\nvar writer \x3d (new cljs.core.StringBufferWriter(sb));\nobj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,cljs.core.pr_opts());\n\nwriter.cljs$core$IWriter$_flush$arity$1(null);\n\nreturn [cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb)].join(\x27\x27);\n});\ncljs.core.int_rotate_left \x3d (function cljs$core$int_rotate_left(x,n){\nreturn ((x \x3c\x3c n) | (x \x3e\x3e\x3e (- n)));\n});\nif((((typeof Math !\x3d\x3d \x27undefined\x27) \x26\x26 (typeof Math.imul !\x3d\x3d \x27undefined\x27)) \x26\x26 (!((Math.imul((4294967295),(5)) \x3d\x3d\x3d (0)))))){\ncljs.core.imul \x3d (function cljs$core$imul(a,b){\nreturn Math.imul(a,b);\n});\n} else {\ncljs.core.imul \x3d (function cljs$core$imul(a,b){\nvar ah \x3d ((a \x3e\x3e\x3e (16)) \x26 (65535));\nvar al \x3d (a \x26 (65535));\nvar bh \x3d ((b \x3e\x3e\x3e (16)) \x26 (65535));\nvar bl \x3d (b \x26 (65535));\nreturn (((al * bl) + ((((ah * bl) + (al * bh)) \x3c\x3c (16)) \x3e\x3e\x3e (0))) | (0));\n});\n}\ncljs.core.m3_seed \x3d (0);\ncljs.core.m3_C1 \x3d ((3432918353) | (0));\ncljs.core.m3_C2 \x3d ((461845907) | (0));\ncljs.core.m3_mix_K1 \x3d (function cljs$core$m3_mix_K1(k1){\nreturn cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul((k1 | (0)),cljs.core.m3_C1),(15)),cljs.core.m3_C2);\n});\ncljs.core.m3_mix_H1 \x3d (function cljs$core$m3_mix_H1(h1,k1){\nreturn ((cljs.core.imul(cljs.core.int_rotate_left(((h1 | (0)) ^ (k1 | (0))),(13)),(5)) + ((3864292196) | (0))) | (0));\n});\ncljs.core.m3_fmix \x3d (function cljs$core$m3_fmix(h1,len){\nvar h1__$1 \x3d (h1 | (0));\nvar h1__$2 \x3d (h1__$1 ^ len);\nvar h1__$3 \x3d (h1__$2 ^ (h1__$2 \x3e\x3e\x3e (16)));\nvar h1__$4 \x3d cljs.core.imul(h1__$3,((2246822507) | (0)));\nvar h1__$5 \x3d (h1__$4 ^ (h1__$4 \x3e\x3e\x3e (13)));\nvar h1__$6 \x3d cljs.core.imul(h1__$5,((3266489909) | (0)));\nreturn (h1__$6 ^ (h1__$6 \x3e\x3e\x3e (16)));\n});\ncljs.core.m3_hash_int \x3d (function cljs$core$m3_hash_int(in$){\nif((in$ \x3d\x3d\x3d (0))){\nreturn in$;\n} else {\nvar k1 \x3d cljs.core.m3_mix_K1(in$);\nvar h1 \x3d cljs.core.m3_mix_H1(cljs.core.m3_seed,k1);\nreturn cljs.core.m3_fmix(h1,(4));\n}\n});\ncljs.core.m3_hash_unencoded_chars \x3d (function cljs$core$m3_hash_unencoded_chars(in$){\nvar h1 \x3d (function (){var i \x3d (1);\nvar h1 \x3d cljs.core.m3_seed;\nwhile(true){\nif((i \x3c in$.length)){\nvar G__29528 \x3d (i + (2));\nvar G__29529 \x3d cljs.core.m3_mix_H1(h1,cljs.core.m3_mix_K1((in$.charCodeAt((i - (1))) | (in$.charCodeAt(i) \x3c\x3c (16)))));\ni \x3d G__29528;\nh1 \x3d G__29529;\ncontinue;\n} else {\nreturn h1;\n}\nbreak;\n}\n})();\nvar h1__$1 \x3d ((((in$.length \x26 (1)) \x3d\x3d\x3d (1)))?(h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt((in$.length - (1))))):h1);\nreturn cljs.core.m3_fmix(h1__$1,cljs.core.imul((2),in$.length));\n});\n\n\n\ncljs.core.string_hash_cache \x3d {};\ncljs.core.string_hash_cache_count \x3d (0);\ncljs.core.hash_string_STAR_ \x3d (function cljs$core$hash_string_STAR_(s){\nif(!((s \x3d\x3d null))){\nvar len \x3d s.length;\nif((len \x3e (0))){\nvar i \x3d (0);\nvar hash \x3d (0);\nwhile(true){\nif((i \x3c len)){\nvar G__29532 \x3d (i + (1));\nvar G__29533 \x3d (cljs.core.imul((31),hash) + s.charCodeAt(i));\ni \x3d G__29532;\nhash \x3d G__29533;\ncontinue;\n} else {\nreturn hash;\n}\nbreak;\n}\n} else {\nreturn (0);\n}\n} else {\nreturn (0);\n}\n});\ncljs.core.add_to_string_hash_cache \x3d (function cljs$core$add_to_string_hash_cache(k){\nvar h \x3d cljs.core.hash_string_STAR_(k);\ngoog.object.set(cljs.core.string_hash_cache,k,h);\n\ncljs.core.string_hash_cache_count \x3d (cljs.core.string_hash_cache_count + (1));\n\nreturn h;\n});\ncljs.core.hash_string \x3d (function cljs$core$hash_string(k){\nif((cljs.core.string_hash_cache_count \x3e (255))){\ncljs.core.string_hash_cache \x3d {};\n\ncljs.core.string_hash_cache_count \x3d (0);\n} else {\n}\n\nif((k \x3d\x3d null)){\nreturn (0);\n} else {\nvar h \x3d (cljs.core.string_hash_cache[k]);\nif(typeof h \x3d\x3d\x3d \x27number\x27){\nreturn h;\n} else {\nreturn cljs.core.add_to_string_hash_cache(k);\n}\n}\n});\n/**\n * Returns the hash code of its argument. Note this is the hash code\n * consistent with \x3d.\n */\ncljs.core.hash \x3d (function cljs$core$hash(o){\nif(((!((o \x3d\x3d null)))?(((((o.cljs$lang$protocol_mask$partition0$ \x26 (4194304))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d o.cljs$core$IHash$))))?true:false):false)){\nreturn (o.cljs$core$IHash$_hash$arity$1(null) ^ (0));\n} else {\nif(typeof o \x3d\x3d\x3d \x27number\x27){\nif(cljs.core.truth_(isFinite(o))){\nreturn (Math.floor(o) % (2147483647));\n} else {\nvar G__29537 \x3d o;\nswitch (G__29537) {\ncase Infinity:\nreturn (2146435072);\n\nbreak;\ncase -Infinity:\nreturn (-1048576);\n\nbreak;\ndefault:\nreturn (2146959360);\n\n}\n}\n} else {\nif(o \x3d\x3d\x3d true){\nreturn (1231);\n} else {\nif(o \x3d\x3d\x3d false){\nreturn (1237);\n} else {\nif(typeof o \x3d\x3d\x3d \x27string\x27){\nreturn cljs.core.m3_hash_int(cljs.core.hash_string(o));\n} else {\nif((o instanceof Date)){\nreturn (o.valueOf() ^ (0));\n} else {\nif((o \x3d\x3d null)){\nreturn (0);\n} else {\nreturn (cljs.core._hash(o) ^ (0));\n\n}\n}\n}\n}\n}\n}\n}\n});\ncljs.core.hash_combine \x3d (function cljs$core$hash_combine(seed,hash){\nreturn (seed ^ (((hash + (2654435769)) + (seed \x3c\x3c (6))) + (seed \x3e\x3e (2))));\n});\n/**\n * Evaluates x and tests if it is an instance of the type\n *   c. Returns true or false\n */\ncljs.core.instance_QMARK_ \x3d (function cljs$core$instance_QMARK_(c,x){\nreturn (x instanceof c);\n});\n/**\n * Return true if x is a Symbol\n */\ncljs.core.symbol_QMARK_ \x3d (function cljs$core$symbol_QMARK_(x){\nreturn (x instanceof cljs.core.Symbol);\n});\ncljs.core.hash_symbol \x3d (function cljs$core$hash_symbol(sym){\nreturn cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name),cljs.core.hash_string(sym.ns));\n});\ncljs.core.compare_symbols \x3d (function cljs$core$compare_symbols(a,b){\nif((a.str \x3d\x3d\x3d b.str)){\nreturn (0);\n} else {\nif(cljs.core.truth_((function (){var and__3938__auto__ \x3d cljs.core.not(a.ns);\nif(and__3938__auto__){\nreturn b.ns;\n} else {\nreturn and__3938__auto__;\n}\n})())){\nreturn (-1);\n} else {\nif(cljs.core.truth_(a.ns)){\nif(cljs.core.not(b.ns)){\nreturn (1);\n} else {\nvar nsc \x3d (function (){var G__29539 \x3d a.ns;\nvar G__29540 \x3d b.ns;\nreturn goog.array.defaultCompare(G__29539,G__29540);\n})();\nif(((0) \x3d\x3d\x3d nsc)){\nvar G__29541 \x3d a.name;\nvar G__29542 \x3d b.name;\nreturn goog.array.defaultCompare(G__29541,G__29542);\n} else {\nreturn nsc;\n}\n}\n} else {\nvar G__29543 \x3d a.name;\nvar G__29544 \x3d b.name;\nreturn goog.array.defaultCompare(G__29543,G__29544);\n\n}\n}\n}\n});\n\n/**\n* @constructor\n * @implements {cljs.core.IEquiv}\n * @implements {cljs.core.IHash}\n * @implements {cljs.core.IFn}\n * @implements {cljs.core.INamed}\n * @implements {cljs.core.IMeta}\n * @implements {cljs.core.IPrintWithWriter}\n * @implements {cljs.core.IWithMeta}\n*/\ncljs.core.Symbol \x3d (function (ns,name,str,_hash,_meta){\nthis.ns \x3d ns;\nthis.name \x3d name;\nthis.str \x3d str;\nthis._hash \x3d _hash;\nthis._meta \x3d _meta;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 2154168321;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 4096;\n});\ncljs.core.Symbol.prototype.toString \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn self__.str;\n});\n\ncljs.core.Symbol.prototype.equiv \x3d (function (other){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn this$.cljs$core$IEquiv$_equiv$arity$2(null,other);\n});\n\ncljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 \x3d (function (_,other){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nif((other instanceof cljs.core.Symbol)){\nreturn (self__.str \x3d\x3d\x3d other.str);\n} else {\nreturn false;\n}\n});\n\ncljs.core.Symbol.prototype.call \x3d (function() {\nvar G__29546 \x3d null;\nvar G__29546__2 \x3d (function (self__,coll){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar sym \x3d self____$1;\nreturn (cljs.core.get.cljs$core$IFn$_invoke$arity$2 ? cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym) : cljs.core.get.call(null,coll,sym));\n});\nvar G__29546__3 \x3d (function (self__,coll,not_found){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar sym \x3d self____$1;\nreturn (cljs.core.get.cljs$core$IFn$_invoke$arity$3 ? cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found) : cljs.core.get.call(null,coll,sym,not_found));\n});\nG__29546 \x3d function(self__,coll,not_found){\nswitch(arguments.length){\ncase 2:\nreturn G__29546__2.call(this,self__,coll);\ncase 3:\nreturn G__29546__3.call(this,self__,coll,not_found);\n}\nthrow(new Error(\x27Invalid arity: \x27 + (arguments.length - 1)));\n};\nG__29546.cljs$core$IFn$_invoke$arity$2 \x3d G__29546__2;\nG__29546.cljs$core$IFn$_invoke$arity$3 \x3d G__29546__3;\nreturn G__29546;\n})()\n;\n\ncljs.core.Symbol.prototype.apply \x3d (function (self__,args29545){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nreturn self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args29545)));\n});\n\ncljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar sym \x3d this;\nreturn (cljs.core.get.cljs$core$IFn$_invoke$arity$2 ? cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym) : cljs.core.get.call(null,coll,sym));\n});\n\ncljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 \x3d (function (coll,not_found){\nvar self__ \x3d this;\nvar sym \x3d this;\nreturn (cljs.core.get.cljs$core$IFn$_invoke$arity$3 ? cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found) : cljs.core.get.call(null,coll,sym,not_found));\n});\n\ncljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn self__._meta;\n});\n\ncljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 \x3d (function (_,new_meta){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn (new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta));\n});\n\ncljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 \x3d (function (sym){\nvar self__ \x3d this;\nvar sym__$1 \x3d this;\nvar h__4061__auto__ \x3d self__._hash;\nif(!((h__4061__auto__ \x3d\x3d null))){\nreturn h__4061__auto__;\n} else {\nvar h__4061__auto____$1 \x3d cljs.core.hash_symbol(sym__$1);\nself__._hash \x3d h__4061__auto____$1;\n\nreturn h__4061__auto____$1;\n}\n});\n\ncljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn self__.name;\n});\n\ncljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn self__.ns;\n});\n\ncljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 \x3d (function (o,writer,_){\nvar self__ \x3d this;\nvar o__$1 \x3d this;\nreturn cljs.core._write(writer,self__.str);\n});\n\ncljs.core.Symbol.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22ns\x22,\x22ns\x22,2082130287,null),new cljs.core.Symbol(null,\x22name\x22,\x22name\x22,-810760592,null),new cljs.core.Symbol(null,\x22str\x22,\x22str\x22,-1564826950,null),cljs.core.with_meta(new cljs.core.Symbol(null,\x22_hash\x22,\x22_hash\x22,-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null)),new cljs.core.Symbol(null,\x22_meta\x22,\x22_meta\x22,-1716892533,null)], null);\n});\n\ncljs.core.Symbol.cljs$lang$type \x3d true;\n\ncljs.core.Symbol.cljs$lang$ctorStr \x3d \x22cljs.core/Symbol\x22;\n\ncljs.core.Symbol.cljs$lang$ctorPrWriter \x3d (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){\nreturn cljs.core._write(writer__4193__auto__,\x22cljs.core/Symbol\x22);\n});\n\n/**\n * Positional factory function for cljs.core/Symbol.\n */\ncljs.core.__GT_Symbol \x3d (function cljs$core$__GT_Symbol(ns,name,str,_hash,_meta){\nreturn (new cljs.core.Symbol(ns,name,str,_hash,_meta));\n});\n\n/**\n * Returns a Symbol with the given namespace and name.\n */\ncljs.core.symbol \x3d (function cljs$core$symbol(var_args){\nvar G__29548 \x3d arguments.length;\nswitch (G__29548) {\ncase 1:\nreturn cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.symbol.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core.symbol.cljs$core$IFn$_invoke$arity$1 \x3d (function (name){\nif((name instanceof cljs.core.Symbol)){\nreturn name;\n} else {\nvar idx \x3d name.indexOf(\x22/\x22);\nif((idx \x3c (1))){\nreturn cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null,name);\n} else {\nreturn cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(name.substring((0),idx),name.substring((idx + (1)),name.length));\n}\n}\n});\n\ncljs.core.symbol.cljs$core$IFn$_invoke$arity$2 \x3d (function (ns,name){\nvar sym_str \x3d ((!((ns \x3d\x3d null)))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),\x22/\x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(\x27\x27):name);\nreturn (new cljs.core.Symbol(ns,name,sym_str,null,null));\n});\n\ncljs.core.symbol.cljs$lang$maxFixedArity \x3d 2;\n\n\n/**\n* @constructor\n * @implements {cljs.core.IEquiv}\n * @implements {cljs.core.IHash}\n * @implements {cljs.core.IFn}\n * @implements {cljs.core.IMeta}\n * @implements {cljs.core.Fn}\n * @implements {cljs.core.IDeref}\n * @implements {cljs.core.IWithMeta}\n*/\ncljs.core.Var \x3d (function (val,sym,_meta){\nthis.val \x3d val;\nthis.sym \x3d sym;\nthis._meta \x3d _meta;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 6717441;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 0;\n});\ncljs.core.Var.prototype.isMacro \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).cljs$lang$macro;\n});\n\ncljs.core.Var.prototype.toString \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn [\x22#\x27\x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.sym)].join(\x27\x27);\n});\n\ncljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\n});\n\ncljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn self__._meta;\n});\n\ncljs.core.Var.prototype.cljs$core$IWithMeta$_with_meta$arity$2 \x3d (function (_,new_meta){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn (new cljs.core.Var(self__.val,self__.sym,new_meta));\n});\n\ncljs.core.Var.prototype.cljs$core$IEquiv$_equiv$arity$2 \x3d (function (this$,other){\nvar self__ \x3d this;\nvar this$__$1 \x3d this;\nif((other instanceof cljs.core.Var)){\nvar G__29551 \x3d this$__$1.sym;\nvar G__29552 \x3d other.sym;\nreturn (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(G__29551,G__29552) : cljs.core._EQ_.call(null,G__29551,G__29552));\n} else {\nreturn false;\n}\n});\n\ncljs.core.Var.prototype.cljs$core$IHash$_hash$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn cljs.core.hash_symbol(self__.sym);\n});\n\ncljs.core.Var.prototype.cljs$core$Fn$ \x3d cljs.core.PROTOCOL_SENTINEL;\n\ncljs.core.Var.prototype.call \x3d (function() {\nvar G__29639 \x3d null;\nvar G__29639__1 \x3d (function (self__){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nvar fexpr__29553 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29553.cljs$core$IFn$_invoke$arity$0 ? fexpr__29553.cljs$core$IFn$_invoke$arity$0() : fexpr__29553.call(null));\n});\nvar G__29639__2 \x3d (function (self__,a){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nvar fexpr__29554 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29554.cljs$core$IFn$_invoke$arity$1 ? fexpr__29554.cljs$core$IFn$_invoke$arity$1(a) : fexpr__29554.call(null,a));\n});\nvar G__29639__3 \x3d (function (self__,a,b){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nvar fexpr__29555 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29555.cljs$core$IFn$_invoke$arity$2 ? fexpr__29555.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__29555.call(null,a,b));\n});\nvar G__29639__4 \x3d (function (self__,a,b,c){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nvar fexpr__29556 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29556.cljs$core$IFn$_invoke$arity$3 ? fexpr__29556.cljs$core$IFn$_invoke$arity$3(a,b,c) : fexpr__29556.call(null,a,b,c));\n});\nvar G__29639__5 \x3d (function (self__,a,b,c,d){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nvar fexpr__29557 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29557.cljs$core$IFn$_invoke$arity$4 ? fexpr__29557.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : fexpr__29557.call(null,a,b,c,d));\n});\nvar G__29639__6 \x3d (function (self__,a,b,c,d,e){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nvar fexpr__29558 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29558.cljs$core$IFn$_invoke$arity$5 ? fexpr__29558.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : fexpr__29558.call(null,a,b,c,d,e));\n});\nvar G__29639__7 \x3d (function (self__,a,b,c,d,e,f){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nvar fexpr__29559 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29559.cljs$core$IFn$_invoke$arity$6 ? fexpr__29559.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : fexpr__29559.call(null,a,b,c,d,e,f));\n});\nvar G__29639__8 \x3d (function (self__,a,b,c,d,e,f,g){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nvar fexpr__29560 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29560.cljs$core$IFn$_invoke$arity$7 ? fexpr__29560.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : fexpr__29560.call(null,a,b,c,d,e,f,g));\n});\nvar G__29639__9 \x3d (function (self__,a,b,c,d,e,f,g,h){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nvar fexpr__29561 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29561.cljs$core$IFn$_invoke$arity$8 ? fexpr__29561.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : fexpr__29561.call(null,a,b,c,d,e,f,g,h));\n});\nvar G__29639__10 \x3d (function (self__,a,b,c,d,e,f,g,h,i){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nvar fexpr__29562 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29562.cljs$core$IFn$_invoke$arity$9 ? fexpr__29562.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : fexpr__29562.call(null,a,b,c,d,e,f,g,h,i));\n});\nvar G__29639__11 \x3d (function (self__,a,b,c,d,e,f,g,h,i,j){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nvar fexpr__29563 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29563.cljs$core$IFn$_invoke$arity$10 ? fexpr__29563.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : fexpr__29563.call(null,a,b,c,d,e,f,g,h,i,j));\n});\nvar G__29639__12 \x3d (function (self__,a,b,c,d,e,f,g,h,i,j,k){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nvar fexpr__29564 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29564.cljs$core$IFn$_invoke$arity$11 ? fexpr__29564.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : fexpr__29564.call(null,a,b,c,d,e,f,g,h,i,j,k));\n});\nvar G__29639__13 \x3d (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nvar fexpr__29565 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29565.cljs$core$IFn$_invoke$arity$12 ? fexpr__29565.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : fexpr__29565.call(null,a,b,c,d,e,f,g,h,i,j,k,l));\n});\nvar G__29639__14 \x3d (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nvar fexpr__29566 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29566.cljs$core$IFn$_invoke$arity$13 ? fexpr__29566.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : fexpr__29566.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));\n});\nvar G__29639__15 \x3d (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nvar fexpr__29567 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29567.cljs$core$IFn$_invoke$arity$14 ? fexpr__29567.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : fexpr__29567.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));\n});\nvar G__29639__16 \x3d (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nvar fexpr__29568 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29568.cljs$core$IFn$_invoke$arity$15 ? fexpr__29568.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : fexpr__29568.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));\n});\nvar G__29639__17 \x3d (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nvar fexpr__29569 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29569.cljs$core$IFn$_invoke$arity$16 ? fexpr__29569.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : fexpr__29569.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));\n});\nvar G__29639__18 \x3d (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nvar fexpr__29570 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29570.cljs$core$IFn$_invoke$arity$17 ? fexpr__29570.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : fexpr__29570.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));\n});\nvar G__29639__19 \x3d (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nvar fexpr__29571 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29571.cljs$core$IFn$_invoke$arity$18 ? fexpr__29571.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : fexpr__29571.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));\n});\nvar G__29639__20 \x3d (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nvar fexpr__29572 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29572.cljs$core$IFn$_invoke$arity$19 ? fexpr__29572.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : fexpr__29572.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));\n});\nvar G__29639__21 \x3d (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nvar fexpr__29573 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29573.cljs$core$IFn$_invoke$arity$20 ? fexpr__29573.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : fexpr__29573.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));\n});\nvar G__29639__22 \x3d (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nvar G__29574 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nvar G__29575 \x3d a;\nvar G__29576 \x3d b;\nvar G__29577 \x3d c;\nvar G__29578 \x3d d;\nvar G__29579 \x3d e;\nvar G__29580 \x3d f;\nvar G__29581 \x3d g;\nvar G__29582 \x3d h;\nvar G__29583 \x3d i;\nvar G__29584 \x3d j;\nvar G__29585 \x3d k;\nvar G__29586 \x3d l;\nvar G__29587 \x3d m;\nvar G__29588 \x3d n;\nvar G__29589 \x3d o;\nvar G__29590 \x3d p;\nvar G__29591 \x3d q;\nvar G__29592 \x3d r;\nvar G__29593 \x3d s;\nvar G__29594 \x3d t;\nvar G__29595 \x3d rest;\nreturn (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__29574,G__29575,G__29576,G__29577,G__29578,G__29579,G__29580,G__29581,G__29582,G__29583,G__29584,G__29585,G__29586,G__29587,G__29588,G__29589,G__29590,G__29591,G__29592,G__29593,G__29594,G__29595) : cljs.core.apply.call(null,G__29574,G__29575,G__29576,G__29577,G__29578,G__29579,G__29580,G__29581,G__29582,G__29583,G__29584,G__29585,G__29586,G__29587,G__29588,G__29589,G__29590,G__29591,G__29592,G__29593,G__29594,G__29595));\n});\nG__29639 \x3d function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){\nswitch(arguments.length){\ncase 1:\nreturn G__29639__1.call(this,self__);\ncase 2:\nreturn G__29639__2.call(this,self__,a);\ncase 3:\nreturn G__29639__3.call(this,self__,a,b);\ncase 4:\nreturn G__29639__4.call(this,self__,a,b,c);\ncase 5:\nreturn G__29639__5.call(this,self__,a,b,c,d);\ncase 6:\nreturn G__29639__6.call(this,self__,a,b,c,d,e);\ncase 7:\nreturn G__29639__7.call(this,self__,a,b,c,d,e,f);\ncase 8:\nreturn G__29639__8.call(this,self__,a,b,c,d,e,f,g);\ncase 9:\nreturn G__29639__9.call(this,self__,a,b,c,d,e,f,g,h);\ncase 10:\nreturn G__29639__10.call(this,self__,a,b,c,d,e,f,g,h,i);\ncase 11:\nreturn G__29639__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);\ncase 12:\nreturn G__29639__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);\ncase 13:\nreturn G__29639__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);\ncase 14:\nreturn G__29639__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);\ncase 15:\nreturn G__29639__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);\ncase 16:\nreturn G__29639__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);\ncase 17:\nreturn G__29639__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);\ncase 18:\nreturn G__29639__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);\ncase 19:\nreturn G__29639__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);\ncase 20:\nreturn G__29639__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);\ncase 21:\nreturn G__29639__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);\ncase 22:\nreturn G__29639__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);\n}\nthrow(new Error(\x27Invalid arity: \x27 + (arguments.length - 1)));\n};\nG__29639.cljs$core$IFn$_invoke$arity$1 \x3d G__29639__1;\nG__29639.cljs$core$IFn$_invoke$arity$2 \x3d G__29639__2;\nG__29639.cljs$core$IFn$_invoke$arity$3 \x3d G__29639__3;\nG__29639.cljs$core$IFn$_invoke$arity$4 \x3d G__29639__4;\nG__29639.cljs$core$IFn$_invoke$arity$5 \x3d G__29639__5;\nG__29639.cljs$core$IFn$_invoke$arity$6 \x3d G__29639__6;\nG__29639.cljs$core$IFn$_invoke$arity$7 \x3d G__29639__7;\nG__29639.cljs$core$IFn$_invoke$arity$8 \x3d G__29639__8;\nG__29639.cljs$core$IFn$_invoke$arity$9 \x3d G__29639__9;\nG__29639.cljs$core$IFn$_invoke$arity$10 \x3d G__29639__10;\nG__29639.cljs$core$IFn$_invoke$arity$11 \x3d G__29639__11;\nG__29639.cljs$core$IFn$_invoke$arity$12 \x3d G__29639__12;\nG__29639.cljs$core$IFn$_invoke$arity$13 \x3d G__29639__13;\nG__29639.cljs$core$IFn$_invoke$arity$14 \x3d G__29639__14;\nG__29639.cljs$core$IFn$_invoke$arity$15 \x3d G__29639__15;\nG__29639.cljs$core$IFn$_invoke$arity$16 \x3d G__29639__16;\nG__29639.cljs$core$IFn$_invoke$arity$17 \x3d G__29639__17;\nG__29639.cljs$core$IFn$_invoke$arity$18 \x3d G__29639__18;\nG__29639.cljs$core$IFn$_invoke$arity$19 \x3d G__29639__19;\nG__29639.cljs$core$IFn$_invoke$arity$20 \x3d G__29639__20;\nG__29639.cljs$core$IFn$_invoke$arity$21 \x3d G__29639__21;\nG__29639.cljs$core$IFn$_invoke$arity$22 \x3d G__29639__22;\nreturn G__29639;\n})()\n;\n\ncljs.core.Var.prototype.apply \x3d (function (self__,args29550){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nreturn self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args29550)));\n});\n\ncljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__29596 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29596.cljs$core$IFn$_invoke$arity$0 ? fexpr__29596.cljs$core$IFn$_invoke$arity$0() : fexpr__29596.call(null));\n});\n\ncljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 \x3d (function (a){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__29597 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29597.cljs$core$IFn$_invoke$arity$1 ? fexpr__29597.cljs$core$IFn$_invoke$arity$1(a) : fexpr__29597.call(null,a));\n});\n\ncljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 \x3d (function (a,b){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__29598 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29598.cljs$core$IFn$_invoke$arity$2 ? fexpr__29598.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__29598.call(null,a,b));\n});\n\ncljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 \x3d (function (a,b,c){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__29599 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29599.cljs$core$IFn$_invoke$arity$3 ? fexpr__29599.cljs$core$IFn$_invoke$arity$3(a,b,c) : fexpr__29599.call(null,a,b,c));\n});\n\ncljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 \x3d (function (a,b,c,d){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__29600 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29600.cljs$core$IFn$_invoke$arity$4 ? fexpr__29600.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : fexpr__29600.call(null,a,b,c,d));\n});\n\ncljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 \x3d (function (a,b,c,d,e){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__29601 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29601.cljs$core$IFn$_invoke$arity$5 ? fexpr__29601.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : fexpr__29601.call(null,a,b,c,d,e));\n});\n\ncljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 \x3d (function (a,b,c,d,e,f){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__29602 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29602.cljs$core$IFn$_invoke$arity$6 ? fexpr__29602.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : fexpr__29602.call(null,a,b,c,d,e,f));\n});\n\ncljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 \x3d (function (a,b,c,d,e,f,g){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__29603 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29603.cljs$core$IFn$_invoke$arity$7 ? fexpr__29603.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : fexpr__29603.call(null,a,b,c,d,e,f,g));\n});\n\ncljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 \x3d (function (a,b,c,d,e,f,g,h){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__29604 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29604.cljs$core$IFn$_invoke$arity$8 ? fexpr__29604.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : fexpr__29604.call(null,a,b,c,d,e,f,g,h));\n});\n\ncljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 \x3d (function (a,b,c,d,e,f,g,h,i){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__29605 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29605.cljs$core$IFn$_invoke$arity$9 ? fexpr__29605.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : fexpr__29605.call(null,a,b,c,d,e,f,g,h,i));\n});\n\ncljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 \x3d (function (a,b,c,d,e,f,g,h,i,j){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__29606 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29606.cljs$core$IFn$_invoke$arity$10 ? fexpr__29606.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : fexpr__29606.call(null,a,b,c,d,e,f,g,h,i,j));\n});\n\ncljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 \x3d (function (a,b,c,d,e,f,g,h,i,j,k){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__29607 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29607.cljs$core$IFn$_invoke$arity$11 ? fexpr__29607.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : fexpr__29607.call(null,a,b,c,d,e,f,g,h,i,j,k));\n});\n\ncljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__29608 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29608.cljs$core$IFn$_invoke$arity$12 ? fexpr__29608.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : fexpr__29608.call(null,a,b,c,d,e,f,g,h,i,j,k,l));\n});\n\ncljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__29609 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29609.cljs$core$IFn$_invoke$arity$13 ? fexpr__29609.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : fexpr__29609.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));\n});\n\ncljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__29610 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29610.cljs$core$IFn$_invoke$arity$14 ? fexpr__29610.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : fexpr__29610.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));\n});\n\ncljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__29611 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29611.cljs$core$IFn$_invoke$arity$15 ? fexpr__29611.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : fexpr__29611.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));\n});\n\ncljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__29612 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29612.cljs$core$IFn$_invoke$arity$16 ? fexpr__29612.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : fexpr__29612.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));\n});\n\ncljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__29613 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29613.cljs$core$IFn$_invoke$arity$17 ? fexpr__29613.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : fexpr__29613.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));\n});\n\ncljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__29614 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29614.cljs$core$IFn$_invoke$arity$18 ? fexpr__29614.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : fexpr__29614.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));\n});\n\ncljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__29615 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29615.cljs$core$IFn$_invoke$arity$19 ? fexpr__29615.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : fexpr__29615.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));\n});\n\ncljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar fexpr__29616 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nreturn (fexpr__29616.cljs$core$IFn$_invoke$arity$20 ? fexpr__29616.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : fexpr__29616.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));\n});\n\ncljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar G__29617 \x3d (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));\nvar G__29618 \x3d a;\nvar G__29619 \x3d b;\nvar G__29620 \x3d c;\nvar G__29621 \x3d d;\nvar G__29622 \x3d e;\nvar G__29623 \x3d f;\nvar G__29624 \x3d g;\nvar G__29625 \x3d h;\nvar G__29626 \x3d i;\nvar G__29627 \x3d j;\nvar G__29628 \x3d k;\nvar G__29629 \x3d l;\nvar G__29630 \x3d m;\nvar G__29631 \x3d n;\nvar G__29632 \x3d o;\nvar G__29633 \x3d p;\nvar G__29634 \x3d q;\nvar G__29635 \x3d r;\nvar G__29636 \x3d s;\nvar G__29637 \x3d t;\nvar G__29638 \x3d rest;\nreturn (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__29617,G__29618,G__29619,G__29620,G__29621,G__29622,G__29623,G__29624,G__29625,G__29626,G__29627,G__29628,G__29629,G__29630,G__29631,G__29632,G__29633,G__29634,G__29635,G__29636,G__29637,G__29638) : cljs.core.apply.call(null,G__29617,G__29618,G__29619,G__29620,G__29621,G__29622,G__29623,G__29624,G__29625,G__29626,G__29627,G__29628,G__29629,G__29630,G__29631,G__29632,G__29633,G__29634,G__29635,G__29636,G__29637,G__29638));\n});\n\ncljs.core.Var.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22val\x22,\x22val\x22,1769233139,null),new cljs.core.Symbol(null,\x22sym\x22,\x22sym\x22,195671222,null),new cljs.core.Symbol(null,\x22_meta\x22,\x22_meta\x22,-1716892533,null)], null);\n});\n\ncljs.core.Var.cljs$lang$type \x3d true;\n\ncljs.core.Var.cljs$lang$ctorStr \x3d \x22cljs.core/Var\x22;\n\ncljs.core.Var.cljs$lang$ctorPrWriter \x3d (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){\nreturn cljs.core._write(writer__4193__auto__,\x22cljs.core/Var\x22);\n});\n\n/**\n * Positional factory function for cljs.core/Var.\n */\ncljs.core.__GT_Var \x3d (function cljs$core$__GT_Var(val,sym,_meta){\nreturn (new cljs.core.Var(val,sym,_meta));\n});\n\n/**\n * Returns true if v is of type cljs.core.Var\n */\ncljs.core.var_QMARK_ \x3d (function cljs$core$var_QMARK_(v){\nreturn (v instanceof cljs.core.Var);\n});\n\n\n/**\n * Return true if x implements IIterable protocol.\n */\ncljs.core.iterable_QMARK_ \x3d (function cljs$core$iterable_QMARK_(x){\nif(!((x \x3d\x3d null))){\nif((((x.cljs$lang$protocol_mask$partition1$ \x26 (131072))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$IIterable$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition1$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);\n}\n});\n/**\n * Clone the supplied value which must implement ICloneable.\n */\ncljs.core.clone \x3d (function cljs$core$clone(value){\nreturn cljs.core._clone(value);\n});\n/**\n * Return true if x implements ICloneable protocol.\n */\ncljs.core.cloneable_QMARK_ \x3d (function cljs$core$cloneable_QMARK_(value){\nif(!((value \x3d\x3d null))){\nif((((value.cljs$lang$protocol_mask$partition1$ \x26 (8192))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d value.cljs$core$ICloneable$)))){\nreturn true;\n} else {\nif((!value.cljs$lang$protocol_mask$partition1$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);\n}\n});\n/**\n * Returns a seq on the collection. If the collection is\n *   empty, returns nil.  (seq nil) returns nil. seq also works on\n *   Strings.\n */\ncljs.core.seq \x3d (function cljs$core$seq(coll){\nif((coll \x3d\x3d null)){\nreturn null;\n} else {\nif(((!((coll \x3d\x3d null)))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (8388608))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$ISeqable$))))?true:false):false)){\nreturn coll.cljs$core$ISeqable$_seq$arity$1(null);\n} else {\nif(cljs.core.array_QMARK_(coll)){\nif((coll.length \x3d\x3d\x3d (0))){\nreturn null;\n} else {\nreturn (new cljs.core.IndexedSeq(coll,(0),null));\n}\n} else {\nif(typeof coll \x3d\x3d\x3d \x27string\x27){\nif((coll.length \x3d\x3d\x3d (0))){\nreturn null;\n} else {\nreturn (new cljs.core.IndexedSeq(coll,(0),null));\n}\n} else {\nif(cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,coll)){\nreturn cljs.core._seq(coll);\n} else {\nthrow (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll),\x22 is not ISeqable\x22].join(\x27\x27)));\n\n}\n}\n}\n}\n}\n});\n/**\n * Returns the first item in the collection. Calls seq on its\n *   argument. If coll is nil, returns nil.\n */\ncljs.core.first \x3d (function cljs$core$first(coll){\nif((coll \x3d\x3d null)){\nreturn null;\n} else {\nif(((!((coll \x3d\x3d null)))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (64))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$ISeq$))))?true:false):false)){\nreturn coll.cljs$core$ISeq$_first$arity$1(null);\n} else {\nvar s \x3d cljs.core.seq(coll);\nif((s \x3d\x3d null)){\nreturn null;\n} else {\nreturn cljs.core._first(s);\n}\n}\n}\n});\n/**\n * Returns a possibly empty seq of the items after the first. Calls seq on its\n *   argument.\n */\ncljs.core.rest \x3d (function cljs$core$rest(coll){\nif(!((coll \x3d\x3d null))){\nif(((!((coll \x3d\x3d null)))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (64))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$ISeq$))))?true:false):false)){\nreturn coll.cljs$core$ISeq$_rest$arity$1(null);\n} else {\nvar s \x3d cljs.core.seq(coll);\nif(s){\nreturn s.cljs$core$ISeq$_rest$arity$1(null);\n} else {\nreturn cljs.core.List.EMPTY;\n}\n}\n} else {\nreturn cljs.core.List.EMPTY;\n}\n});\n/**\n * Returns a seq of the items after the first. Calls seq on its\n *   argument.  If there are no more items, returns nil\n */\ncljs.core.next \x3d (function cljs$core$next(coll){\nif((coll \x3d\x3d null)){\nreturn null;\n} else {\nif(((!((coll \x3d\x3d null)))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (128))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$INext$))))?true:false):false)){\nreturn coll.cljs$core$INext$_next$arity$1(null);\n} else {\nreturn cljs.core.seq(cljs.core.rest(coll));\n}\n}\n});\n/**\n * Equality. Returns true if x equals y, false if not. Compares\n *   numbers and collections in a type-independent manner.  Clojure\x27s immutable data\n *   structures define -equiv (and thus \x3d) as a value, not an identity,\n *   comparison.\n */\ncljs.core._EQ_ \x3d (function cljs$core$_EQ_(var_args){\nvar G__29650 \x3d arguments.length;\nswitch (G__29650) {\ncase 1:\nreturn cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___29652 \x3d arguments.length;\nvar i__4532__auto___29653 \x3d (0);\nwhile(true){\nif((i__4532__auto___29653 \x3c len__4531__auto___29652)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___29653]));\n\nvar G__29654 \x3d (i__4532__auto___29653 + (1));\ni__4532__auto___29653 \x3d G__29654;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn true;\n});\n\ncljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nif((x \x3d\x3d null)){\nreturn (y \x3d\x3d null);\n} else {\nreturn (((x \x3d\x3d\x3d y)) || (cljs.core._equiv(x,y)));\n}\n});\n\ncljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nwhile(true){\nif(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){\nif(cljs.core.next(more)){\nvar G__29655 \x3d y;\nvar G__29656 \x3d cljs.core.first(more);\nvar G__29657 \x3d cljs.core.next(more);\nx \x3d G__29655;\ny \x3d G__29656;\nmore \x3d G__29657;\ncontinue;\n} else {\nreturn cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));\n}\n} else {\nreturn false;\n}\nbreak;\n}\n});\n\n/** @this {Function} */\ncljs.core._EQ_.cljs$lang$applyTo \x3d (function (seq29647){\nvar G__29648 \x3d cljs.core.first(seq29647);\nvar seq29647__$1 \x3d cljs.core.next(seq29647);\nvar G__29649 \x3d cljs.core.first(seq29647__$1);\nvar seq29647__$2 \x3d cljs.core.next(seq29647__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29648,G__29649,seq29647__$2);\n});\n\ncljs.core._EQ_.cljs$lang$maxFixedArity \x3d (2);\n\n\n/**\n* @constructor\n*/\ncljs.core.ES6Iterator \x3d (function (s){\nthis.s \x3d s;\n});\ncljs.core.ES6Iterator.prototype.next \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nif(!((self__.s \x3d\x3d null))){\nvar x \x3d cljs.core.first(self__.s);\nself__.s \x3d cljs.core.next(self__.s);\n\nreturn ({\x22value\x22: x, \x22done\x22: false});\n} else {\nreturn ({\x22value\x22: null, \x22done\x22: true});\n}\n});\n\ncljs.core.ES6Iterator.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,\x22s\x22,\x22s\x22,-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null))], null);\n});\n\ncljs.core.ES6Iterator.cljs$lang$type \x3d true;\n\ncljs.core.ES6Iterator.cljs$lang$ctorStr \x3d \x22cljs.core/ES6Iterator\x22;\n\ncljs.core.ES6Iterator.cljs$lang$ctorPrWriter \x3d (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){\nreturn cljs.core._write(writer__4193__auto__,\x22cljs.core/ES6Iterator\x22);\n});\n\n/**\n * Positional factory function for cljs.core/ES6Iterator.\n */\ncljs.core.__GT_ES6Iterator \x3d (function cljs$core$__GT_ES6Iterator(s){\nreturn (new cljs.core.ES6Iterator(s));\n});\n\n/**\n * EXPERIMENTAL: Return a ES2015 compatible iterator for coll.\n */\ncljs.core.es6_iterator \x3d (function cljs$core$es6_iterator(coll){\nreturn (new cljs.core.ES6Iterator(cljs.core.seq(coll)));\n});\n\n/**\n* @constructor\n * @implements {cljs.core.ISeq}\n * @implements {cljs.core.ISeqable}\n*/\ncljs.core.ES6IteratorSeq \x3d (function (value,iter,_rest){\nthis.value \x3d value;\nthis.iter \x3d iter;\nthis._rest \x3d _rest;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 8388672;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 0;\n});\ncljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 \x3d (function (this$){\nvar self__ \x3d this;\nvar this$__$1 \x3d this;\nreturn this$__$1;\n});\n\ncljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn self__.value;\n});\n\ncljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nif((self__._rest \x3d\x3d null)){\nself__._rest \x3d (cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(self__.iter) : cljs.core.es6_iterator_seq.call(null,self__.iter));\n} else {\n}\n\nreturn self__._rest;\n});\n\ncljs.core.ES6IteratorSeq.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22value\x22,\x22value\x22,1946509744,null),new cljs.core.Symbol(null,\x22iter\x22,\x22iter\x22,-1346195486,null),cljs.core.with_meta(new cljs.core.Symbol(null,\x22_rest\x22,\x22_rest\x22,-2100466189,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null))], null);\n});\n\ncljs.core.ES6IteratorSeq.cljs$lang$type \x3d true;\n\ncljs.core.ES6IteratorSeq.cljs$lang$ctorStr \x3d \x22cljs.core/ES6IteratorSeq\x22;\n\ncljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter \x3d (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){\nreturn cljs.core._write(writer__4193__auto__,\x22cljs.core/ES6IteratorSeq\x22);\n});\n\n/**\n * Positional factory function for cljs.core/ES6IteratorSeq.\n */\ncljs.core.__GT_ES6IteratorSeq \x3d (function cljs$core$__GT_ES6IteratorSeq(value,iter,_rest){\nreturn (new cljs.core.ES6IteratorSeq(value,iter,_rest));\n});\n\n/**\n * EXPERIMENTAL: Given an ES2015 compatible iterator return a seq.\n */\ncljs.core.es6_iterator_seq \x3d (function cljs$core$es6_iterator_seq(iter){\nvar v \x3d iter.next();\nif(cljs.core.truth_(v.done)){\nreturn cljs.core.List.EMPTY;\n} else {\nreturn (new cljs.core.ES6IteratorSeq(v.value,iter,null));\n}\n});\n/**\n * Mix final collection hash for ordered or unordered collections.\n * hash-basis is the combined collection hash, count is the number\n * of elements included in the basis. Note this is the hash code\n * consistent with \x3d, different from .hashCode.\n * See http://clojure.org/data_structures#hash for full algorithms.\n */\ncljs.core.mix_collection_hash \x3d (function cljs$core$mix_collection_hash(hash_basis,count){\nvar h1 \x3d cljs.core.m3_seed;\nvar k1 \x3d cljs.core.m3_mix_K1(hash_basis);\nvar h1__$1 \x3d cljs.core.m3_mix_H1(h1,k1);\nreturn cljs.core.m3_fmix(h1__$1,count);\n});\n/**\n * Returns the hash code, consistent with \x3d, for an external ordered\n * collection implementing Iterable.\n * See http://clojure.org/data_structures#hash for full algorithms.\n */\ncljs.core.hash_ordered_coll \x3d (function cljs$core$hash_ordered_coll(coll){\nvar n \x3d (0);\nvar hash_code \x3d (1);\nvar coll__$1 \x3d cljs.core.seq(coll);\nwhile(true){\nif(!((coll__$1 \x3d\x3d null))){\nvar G__29658 \x3d (n + (1));\nvar G__29659 \x3d ((cljs.core.imul((31),hash_code) + cljs.core.hash(cljs.core.first(coll__$1))) | (0));\nvar G__29660 \x3d cljs.core.next(coll__$1);\nn \x3d G__29658;\nhash_code \x3d G__29659;\ncoll__$1 \x3d G__29660;\ncontinue;\n} else {\nreturn cljs.core.mix_collection_hash(hash_code,n);\n}\nbreak;\n}\n});\ncljs.core.empty_ordered_hash \x3d cljs.core.mix_collection_hash((1),(0));\n/**\n * Returns the hash code, consistent with \x3d, for an external unordered\n * collection implementing Iterable. For maps, the iterator should\n * return map entries whose hash is computed as\n *   (hash-ordered-coll [k v]).\n * See http://clojure.org/data_structures#hash for full algorithms.\n */\ncljs.core.hash_unordered_coll \x3d (function cljs$core$hash_unordered_coll(coll){\nvar n \x3d (0);\nvar hash_code \x3d (0);\nvar coll__$1 \x3d cljs.core.seq(coll);\nwhile(true){\nif(!((coll__$1 \x3d\x3d null))){\nvar G__29661 \x3d (n + (1));\nvar G__29662 \x3d ((hash_code + cljs.core.hash(cljs.core.first(coll__$1))) | (0));\nvar G__29663 \x3d cljs.core.next(coll__$1);\nn \x3d G__29661;\nhash_code \x3d G__29662;\ncoll__$1 \x3d G__29663;\ncontinue;\n} else {\nreturn cljs.core.mix_collection_hash(hash_code,n);\n}\nbreak;\n}\n});\ncljs.core.empty_unordered_hash \x3d cljs.core.mix_collection_hash((0),(0));\n\n\ngoog.object.set(cljs.core.ICounted,\x22null\x22,true);\n\nvar G__29664_29667 \x3d cljs.core._count;\nvar G__29665_29668 \x3d \x22null\x22;\nvar G__29666_29669 \x3d ((function (G__29664_29667,G__29665_29668){\nreturn (function (_){\nreturn (0);\n});})(G__29664_29667,G__29665_29668))\n;\ngoog.object.set(G__29664_29667,G__29665_29668,G__29666_29669);\nDate.prototype.cljs$core$IEquiv$ \x3d cljs.core.PROTOCOL_SENTINEL;\n\nDate.prototype.cljs$core$IEquiv$_equiv$arity$2 \x3d (function (o,other){\nvar o__$1 \x3d this;\nreturn (((other instanceof Date)) \x26\x26 ((o__$1.valueOf() \x3d\x3d\x3d other.valueOf())));\n});\n\nDate.prototype.cljs$core$IComparable$ \x3d cljs.core.PROTOCOL_SENTINEL;\n\nDate.prototype.cljs$core$IComparable$_compare$arity$2 \x3d (function (this$,other){\nvar this$__$1 \x3d this;\nif((other instanceof Date)){\nvar G__29670 \x3d this$__$1.valueOf();\nvar G__29671 \x3d other.valueOf();\nreturn goog.array.defaultCompare(G__29670,G__29671);\n} else {\nthrow (new Error([\x22Cannot compare \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(this$__$1),\x22 to \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(other)].join(\x27\x27)));\n}\n});\n\n/**\n * @interface\n */\ncljs.core.Inst \x3d function(){};\n\ncljs.core.inst_ms_STAR_ \x3d (function cljs$core$inst_ms_STAR_(inst){\nif(((!((inst \x3d\x3d null))) \x26\x26 (!((inst.cljs$core$Inst$inst_ms_STAR_$arity$1 \x3d\x3d null))))){\nreturn inst.cljs$core$Inst$inst_ms_STAR_$arity$1(inst);\n} else {\nvar x__4243__auto__ \x3d (((inst \x3d\x3d null))?null:inst);\nvar m__4244__auto__ \x3d (cljs.core.inst_ms_STAR_[goog.typeOf(x__4243__auto__)]);\nif(!((m__4244__auto__ \x3d\x3d null))){\nreturn (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__4244__auto__.call(null,inst));\n} else {\nvar m__4244__auto____$1 \x3d (cljs.core.inst_ms_STAR_[\x22_\x22]);\nif(!((m__4244__auto____$1 \x3d\x3d null))){\nreturn (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(inst) : m__4244__auto____$1.call(null,inst));\n} else {\nthrow cljs.core.missing_protocol(\x22Inst.inst-ms*\x22,inst);\n}\n}\n}\n});\n\nDate.prototype.cljs$core$Inst$ \x3d cljs.core.PROTOCOL_SENTINEL;\n\nDate.prototype.cljs$core$Inst$inst_ms_STAR_$arity$1 \x3d (function (inst){\nvar inst__$1 \x3d this;\nreturn inst__$1.getTime();\n});\n/**\n * Return the number of milliseconds since January 1, 1970, 00:00:00 GMT\n */\ncljs.core.inst_ms \x3d (function cljs$core$inst_ms(inst){\nreturn cljs.core.inst_ms_STAR_(inst);\n});\n/**\n * Return true if x satisfies Inst\n */\ncljs.core.inst_QMARK_ \x3d (function cljs$core$inst_QMARK_(x){\nif(!((x \x3d\x3d null))){\nif(((false) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$Inst$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);\n}\n});\ngoog.object.set(cljs.core.IEquiv,\x22number\x22,true);\n\nvar G__29673_29676 \x3d cljs.core._equiv;\nvar G__29674_29677 \x3d \x22number\x22;\nvar G__29675_29678 \x3d ((function (G__29673_29676,G__29674_29677){\nreturn (function (x,o){\nreturn (x \x3d\x3d\x3d o);\n});})(G__29673_29676,G__29674_29677))\n;\ngoog.object.set(G__29673_29676,G__29674_29677,G__29675_29678);\ngoog.object.set(cljs.core.Fn,\x22function\x22,true);\n\ngoog.object.set(cljs.core.IMeta,\x22function\x22,true);\n\nvar G__29679_29682 \x3d cljs.core._meta;\nvar G__29680_29683 \x3d \x22function\x22;\nvar G__29681_29684 \x3d ((function (G__29679_29682,G__29680_29683){\nreturn (function (_){\nreturn null;\n});})(G__29679_29682,G__29680_29683))\n;\ngoog.object.set(G__29679_29682,G__29680_29683,G__29681_29684);\ngoog.object.set(cljs.core.IHash,\x22_\x22,true);\n\nvar G__29685_29688 \x3d cljs.core._hash;\nvar G__29686_29689 \x3d \x22_\x22;\nvar G__29687_29690 \x3d ((function (G__29685_29688,G__29686_29689){\nreturn (function (o){\nreturn goog.getUid(o);\n});})(G__29685_29688,G__29686_29689))\n;\ngoog.object.set(G__29685_29688,G__29686_29689,G__29687_29690);\n/**\n * Returns a number one greater than num.\n */\ncljs.core.inc \x3d (function cljs$core$inc(x){\nreturn (x + (1));\n});\n\n/**\n* @constructor\n * @implements {cljs.core.IDeref}\n*/\ncljs.core.Reduced \x3d (function (val){\nthis.val \x3d val;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 32768;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 0;\n});\ncljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 \x3d (function (o){\nvar self__ \x3d this;\nvar o__$1 \x3d this;\nreturn self__.val;\n});\n\ncljs.core.Reduced.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22val\x22,\x22val\x22,1769233139,null)], null);\n});\n\ncljs.core.Reduced.cljs$lang$type \x3d true;\n\ncljs.core.Reduced.cljs$lang$ctorStr \x3d \x22cljs.core/Reduced\x22;\n\ncljs.core.Reduced.cljs$lang$ctorPrWriter \x3d (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){\nreturn cljs.core._write(writer__4193__auto__,\x22cljs.core/Reduced\x22);\n});\n\n/**\n * Positional factory function for cljs.core/Reduced.\n */\ncljs.core.__GT_Reduced \x3d (function cljs$core$__GT_Reduced(val){\nreturn (new cljs.core.Reduced(val));\n});\n\n/**\n * Wraps x in a way such that a reduce will terminate with the value x\n */\ncljs.core.reduced \x3d (function cljs$core$reduced(x){\nreturn (new cljs.core.Reduced(x));\n});\n/**\n * Returns true if x is the result of a call to reduced\n */\ncljs.core.reduced_QMARK_ \x3d (function cljs$core$reduced_QMARK_(r){\nreturn (r instanceof cljs.core.Reduced);\n});\n/**\n * If x is already reduced?, returns it, else returns (reduced x)\n */\ncljs.core.ensure_reduced \x3d (function cljs$core$ensure_reduced(x){\nif(cljs.core.reduced_QMARK_(x)){\nreturn x;\n} else {\nreturn cljs.core.reduced(x);\n}\n});\n/**\n * If x is reduced?, returns (deref x), else returns x\n */\ncljs.core.unreduced \x3d (function cljs$core$unreduced(x){\nif(cljs.core.reduced_QMARK_(x)){\nreturn (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(x) : cljs.core.deref.call(null,x));\n} else {\nreturn x;\n}\n});\n/**\n * Also reader macro: @var/@atom/@delay. Returns the\n * most-recently-committed value of ref. When applied to a var\n * or atom, returns its current state. When applied to a delay, forces\n * it if not already forced. See also - realized?.\n */\ncljs.core.deref \x3d (function cljs$core$deref(o){\nreturn cljs.core._deref(o);\n});\n/**\n * Accepts any collection which satisfies the ICount and IIndexed protocols and\n * reduces them without incurring seq initialization\n */\ncljs.core.ci_reduce \x3d (function cljs$core$ci_reduce(var_args){\nvar G__29692 \x3d arguments.length;\nswitch (G__29692) {\ncase 2:\nreturn cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ncase 4:\nreturn cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 \x3d (function (cicoll,f){\nvar cnt \x3d cljs.core._count(cicoll);\nif((cnt \x3d\x3d\x3d (0))){\nreturn (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));\n} else {\nvar val \x3d cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,(0));\nvar n \x3d (1);\nwhile(true){\nif((n \x3c cnt)){\nvar nval \x3d (function (){var G__29693 \x3d val;\nvar G__29694 \x3d cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__29693,G__29694) : f.call(null,G__29693,G__29694));\n})();\nif(cljs.core.reduced_QMARK_(nval)){\nreturn cljs.core.deref(nval);\n} else {\nvar G__29700 \x3d nval;\nvar G__29701 \x3d (n + (1));\nval \x3d G__29700;\nn \x3d G__29701;\ncontinue;\n}\n} else {\nreturn val;\n}\nbreak;\n}\n}\n});\n\ncljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 \x3d (function (cicoll,f,val){\nvar cnt \x3d cljs.core._count(cicoll);\nvar val__$1 \x3d val;\nvar n \x3d (0);\nwhile(true){\nif((n \x3c cnt)){\nvar nval \x3d (function (){var G__29695 \x3d val__$1;\nvar G__29696 \x3d cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__29695,G__29696) : f.call(null,G__29695,G__29696));\n})();\nif(cljs.core.reduced_QMARK_(nval)){\nreturn cljs.core.deref(nval);\n} else {\nvar G__29702 \x3d nval;\nvar G__29703 \x3d (n + (1));\nval__$1 \x3d G__29702;\nn \x3d G__29703;\ncontinue;\n}\n} else {\nreturn val__$1;\n}\nbreak;\n}\n});\n\ncljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4 \x3d (function (cicoll,f,val,idx){\nvar cnt \x3d cljs.core._count(cicoll);\nvar val__$1 \x3d val;\nvar n \x3d idx;\nwhile(true){\nif((n \x3c cnt)){\nvar nval \x3d (function (){var G__29697 \x3d val__$1;\nvar G__29698 \x3d cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__29697,G__29698) : f.call(null,G__29697,G__29698));\n})();\nif(cljs.core.reduced_QMARK_(nval)){\nreturn cljs.core.deref(nval);\n} else {\nvar G__29704 \x3d nval;\nvar G__29705 \x3d (n + (1));\nval__$1 \x3d G__29704;\nn \x3d G__29705;\ncontinue;\n}\n} else {\nreturn val__$1;\n}\nbreak;\n}\n});\n\ncljs.core.ci_reduce.cljs$lang$maxFixedArity \x3d 4;\n\ncljs.core.array_reduce \x3d (function cljs$core$array_reduce(var_args){\nvar G__29707 \x3d arguments.length;\nswitch (G__29707) {\ncase 2:\nreturn cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ncase 4:\nreturn cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 \x3d (function (arr,f){\nvar cnt \x3d arr.length;\nif((arr.length \x3d\x3d\x3d (0))){\nreturn (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));\n} else {\nvar val \x3d (arr[(0)]);\nvar n \x3d (1);\nwhile(true){\nif((n \x3c cnt)){\nvar nval \x3d (function (){var G__29708 \x3d val;\nvar G__29709 \x3d (arr[n]);\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__29708,G__29709) : f.call(null,G__29708,G__29709));\n})();\nif(cljs.core.reduced_QMARK_(nval)){\nreturn cljs.core.deref(nval);\n} else {\nvar G__29715 \x3d nval;\nvar G__29716 \x3d (n + (1));\nval \x3d G__29715;\nn \x3d G__29716;\ncontinue;\n}\n} else {\nreturn val;\n}\nbreak;\n}\n}\n});\n\ncljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 \x3d (function (arr,f,val){\nvar cnt \x3d arr.length;\nvar val__$1 \x3d val;\nvar n \x3d (0);\nwhile(true){\nif((n \x3c cnt)){\nvar nval \x3d (function (){var G__29710 \x3d val__$1;\nvar G__29711 \x3d (arr[n]);\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__29710,G__29711) : f.call(null,G__29710,G__29711));\n})();\nif(cljs.core.reduced_QMARK_(nval)){\nreturn cljs.core.deref(nval);\n} else {\nvar G__29717 \x3d nval;\nvar G__29718 \x3d (n + (1));\nval__$1 \x3d G__29717;\nn \x3d G__29718;\ncontinue;\n}\n} else {\nreturn val__$1;\n}\nbreak;\n}\n});\n\ncljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 \x3d (function (arr,f,val,idx){\nvar cnt \x3d arr.length;\nvar val__$1 \x3d val;\nvar n \x3d idx;\nwhile(true){\nif((n \x3c cnt)){\nvar nval \x3d (function (){var G__29712 \x3d val__$1;\nvar G__29713 \x3d (arr[n]);\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__29712,G__29713) : f.call(null,G__29712,G__29713));\n})();\nif(cljs.core.reduced_QMARK_(nval)){\nreturn cljs.core.deref(nval);\n} else {\nvar G__29719 \x3d nval;\nvar G__29720 \x3d (n + (1));\nval__$1 \x3d G__29719;\nn \x3d G__29720;\ncontinue;\n}\n} else {\nreturn val__$1;\n}\nbreak;\n}\n});\n\ncljs.core.array_reduce.cljs$lang$maxFixedArity \x3d 4;\n\n\n\n\n\n\n\n/**\n * Returns true if coll implements count in constant time\n */\ncljs.core.counted_QMARK_ \x3d (function cljs$core$counted_QMARK_(x){\nif(!((x \x3d\x3d null))){\nif((((x.cljs$lang$protocol_mask$partition0$ \x26 (2))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$ICounted$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);\n}\n});\n/**\n * Returns true if coll implements nth in constant time\n */\ncljs.core.indexed_QMARK_ \x3d (function cljs$core$indexed_QMARK_(x){\nif(!((x \x3d\x3d null))){\nif((((x.cljs$lang$protocol_mask$partition0$ \x26 (16))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$IIndexed$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);\n}\n});\ncljs.core._indexOf \x3d (function cljs$core$_indexOf(var_args){\nvar G__29724 \x3d arguments.length;\nswitch (G__29724) {\ncase 2:\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core._indexOf.cljs$core$IFn$_invoke$arity$2 \x3d (function (coll,x){\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));\n});\n\ncljs.core._indexOf.cljs$core$IFn$_invoke$arity$3 \x3d (function (coll,x,start){\nvar len \x3d (cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll));\nif((start \x3e\x3d len)){\nreturn (-1);\n} else {\nvar idx \x3d (((start \x3e (0)))?start:(((start \x3c (0)))?(function (){var x__4037__auto__ \x3d (0);\nvar y__4038__auto__ \x3d (start + len);\nreturn ((x__4037__auto__ \x3e y__4038__auto__) ? x__4037__auto__ : y__4038__auto__);\n})():start\n));\nwhile(true){\nif((idx \x3c len)){\nif(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((cljs.core.nth.cljs$core$IFn$_invoke$arity$2 ? cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx) : cljs.core.nth.call(null,coll,idx)),x)){\nreturn idx;\n} else {\nvar G__29726 \x3d (idx + (1));\nidx \x3d G__29726;\ncontinue;\n}\n} else {\nreturn (-1);\n}\nbreak;\n}\n}\n});\n\ncljs.core._indexOf.cljs$lang$maxFixedArity \x3d 3;\n\ncljs.core._lastIndexOf \x3d (function cljs$core$_lastIndexOf(var_args){\nvar G__29728 \x3d arguments.length;\nswitch (G__29728) {\ncase 2:\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2 \x3d (function (coll,x){\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll)));\n});\n\ncljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3 \x3d (function (coll,x,start){\nvar len \x3d (cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll));\nif((len \x3d\x3d\x3d (0))){\nreturn (-1);\n} else {\nvar idx \x3d (((start \x3e (0)))?(function (){var x__4040__auto__ \x3d (len - (1));\nvar y__4041__auto__ \x3d start;\nreturn ((x__4040__auto__ \x3c y__4041__auto__) ? x__4040__auto__ : y__4041__auto__);\n})():(((start \x3c (0)))?(len + start):start\n));\nwhile(true){\nif((idx \x3e\x3d (0))){\nif(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((cljs.core.nth.cljs$core$IFn$_invoke$arity$2 ? cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx) : cljs.core.nth.call(null,coll,idx)),x)){\nreturn idx;\n} else {\nvar G__29730 \x3d (idx - (1));\nidx \x3d G__29730;\ncontinue;\n}\n} else {\nreturn (-1);\n}\nbreak;\n}\n}\n});\n\ncljs.core._lastIndexOf.cljs$lang$maxFixedArity \x3d 3;\n\n\n/**\n* @constructor\n*/\ncljs.core.IndexedSeqIterator \x3d (function (arr,i){\nthis.arr \x3d arr;\nthis.i \x3d i;\n});\ncljs.core.IndexedSeqIterator.prototype.hasNext \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.i \x3c self__.arr.length);\n});\n\ncljs.core.IndexedSeqIterator.prototype.next \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar ret \x3d (self__.arr[self__.i]);\nself__.i \x3d (self__.i + (1));\n\nreturn ret;\n});\n\ncljs.core.IndexedSeqIterator.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22arr\x22,\x22arr\x22,2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,\x22i\x22,\x22i\x22,253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null))], null);\n});\n\ncljs.core.IndexedSeqIterator.cljs$lang$type \x3d true;\n\ncljs.core.IndexedSeqIterator.cljs$lang$ctorStr \x3d \x22cljs.core/IndexedSeqIterator\x22;\n\ncljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter \x3d (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){\nreturn cljs.core._write(writer__4193__auto__,\x22cljs.core/IndexedSeqIterator\x22);\n});\n\n/**\n * Positional factory function for cljs.core/IndexedSeqIterator.\n */\ncljs.core.__GT_IndexedSeqIterator \x3d (function cljs$core$__GT_IndexedSeqIterator(arr,i){\nreturn (new cljs.core.IndexedSeqIterator(arr,i));\n});\n\n\n/**\n* @constructor\n * @implements {cljs.core.IIndexed}\n * @implements {cljs.core.IReversible}\n * @implements {cljs.core.IEquiv}\n * @implements {cljs.core.IHash}\n * @implements {cljs.core.ASeq}\n * @implements {cljs.core.ICollection}\n * @implements {cljs.core.IEmptyableCollection}\n * @implements {cljs.core.ICounted}\n * @implements {cljs.core.ISeq}\n * @implements {cljs.core.INext}\n * @implements {cljs.core.ISeqable}\n * @implements {cljs.core.IMeta}\n * @implements {cljs.core.ICloneable}\n * @implements {cljs.core.IIterable}\n * @implements {cljs.core.ISequential}\n * @implements {cljs.core.IWithMeta}\n * @implements {cljs.core.IReduce}\n*/\ncljs.core.IndexedSeq \x3d (function (arr,i,meta){\nthis.arr \x3d arr;\nthis.i \x3d i;\nthis.meta \x3d meta;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 166592766;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 139264;\n});\ncljs.core.IndexedSeq.prototype.toString \x3d (function (){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core.pr_str_STAR_(coll);\n});\n\ncljs.core.IndexedSeq.prototype.equiv \x3d (function (other){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn this$.cljs$core$IEquiv$_equiv$arity$2(null,other);\n});\n\ncljs.core.IndexedSeq.prototype.indexOf \x3d (function() {\nvar G__29731 \x3d null;\nvar G__29731__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));\n});\nvar G__29731__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__29731 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__29731__1.call(this,x);\ncase 2:\nreturn G__29731__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__29731.cljs$core$IFn$_invoke$arity$1 \x3d G__29731__1;\nG__29731.cljs$core$IFn$_invoke$arity$2 \x3d G__29731__2;\nreturn G__29731;\n})()\n;\n\ncljs.core.IndexedSeq.prototype.lastIndexOf \x3d (function() {\nvar G__29732 \x3d null;\nvar G__29732__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll)));\n});\nvar G__29732__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__29732 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__29732__1.call(this,x);\ncase 2:\nreturn G__29732__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__29732.cljs$core$IFn$_invoke$arity$1 \x3d G__29732__1;\nG__29732.cljs$core$IFn$_invoke$arity$2 \x3d G__29732__2;\nreturn G__29732;\n})()\n;\n\ncljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 \x3d (function (coll,n){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nvar i__$1 \x3d (n + self__.i);\nif(((((0) \x3c\x3d i__$1)) \x26\x26 ((i__$1 \x3c self__.arr.length)))){\nreturn (self__.arr[i__$1]);\n} else {\nthrow (new Error(\x22Index out of bounds\x22));\n}\n});\n\ncljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 \x3d (function (coll,n,not_found){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nvar i__$1 \x3d (n + self__.i);\nif(((((0) \x3c\x3d i__$1)) \x26\x26 ((i__$1 \x3c self__.arr.length)))){\nreturn (self__.arr[i__$1]);\n} else {\nreturn not_found;\n}\n});\n\ncljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (new cljs.core.IndexedSeqIterator(self__.arr,self__.i));\n});\n\ncljs.core.IndexedSeq.prototype.cljs$core$IMeta$_meta$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn self__.meta;\n});\n\ncljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn (new cljs.core.IndexedSeq(self__.arr,self__.i,self__.meta));\n});\n\ncljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nif(((self__.i + (1)) \x3c self__.arr.length)){\nreturn (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));\n} else {\nreturn null;\n}\n});\n\ncljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nvar x__4037__auto__ \x3d (0);\nvar y__4038__auto__ \x3d (self__.arr.length - self__.i);\nreturn ((x__4037__auto__ \x3e y__4038__auto__) ? x__4037__auto__ : y__4038__auto__);\n});\n\ncljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nvar c \x3d coll__$1.cljs$core$ICounted$_count$arity$1(null);\nif((c \x3e (0))){\nreturn (new cljs.core.RSeq(coll__$1,(c - (1)),null));\n} else {\nreturn null;\n}\n});\n\ncljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.hash_ordered_coll(coll__$1);\n});\n\ncljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 \x3d (function (coll,other){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(coll__$1,other) : cljs.core.equiv_sequential.call(null,coll__$1,other));\n});\n\ncljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.List.EMPTY;\n});\n\ncljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 \x3d (function (coll,f){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.i]),(self__.i + (1)));\n});\n\ncljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 \x3d (function (coll,f,start){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.i);\n});\n\ncljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn (self__.arr[self__.i]);\n});\n\ncljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nif(((self__.i + (1)) \x3c self__.arr.length)){\nreturn (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));\n} else {\nreturn cljs.core.List.EMPTY;\n}\n});\n\ncljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 \x3d (function (this$){\nvar self__ \x3d this;\nvar this$__$1 \x3d this;\nif((self__.i \x3c self__.arr.length)){\nreturn this$__$1;\n} else {\nreturn null;\n}\n});\n\ncljs.core.IndexedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 \x3d (function (coll,new_meta){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (new cljs.core.IndexedSeq(self__.arr,self__.i,new_meta));\n});\n\ncljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 \x3d (function (coll,o){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(o,coll__$1) : cljs.core.cons.call(null,o,coll__$1));\n});\n\ncljs.core.IndexedSeq.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22arr\x22,\x22arr\x22,2115492975,null),new cljs.core.Symbol(null,\x22i\x22,\x22i\x22,253690212,null),new cljs.core.Symbol(null,\x22meta\x22,\x22meta\x22,-1154898805,null)], null);\n});\n\ncljs.core.IndexedSeq.cljs$lang$type \x3d true;\n\ncljs.core.IndexedSeq.cljs$lang$ctorStr \x3d \x22cljs.core/IndexedSeq\x22;\n\ncljs.core.IndexedSeq.cljs$lang$ctorPrWriter \x3d (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){\nreturn cljs.core._write(writer__4193__auto__,\x22cljs.core/IndexedSeq\x22);\n});\n\n/**\n * Positional factory function for cljs.core/IndexedSeq.\n */\ncljs.core.__GT_IndexedSeq \x3d (function cljs$core$__GT_IndexedSeq(arr,i,meta){\nreturn (new cljs.core.IndexedSeq(arr,i,meta));\n});\n\nvar G__29733_29736 \x3d cljs.core.IndexedSeq.prototype;\nvar G__29734_29737 \x3d cljs.core.ITER_SYMBOL;\nvar G__29735_29738 \x3d ((function (G__29733_29736,G__29734_29737){\nreturn (function (){\nvar this__4470__auto__ \x3d this;\nreturn cljs.core.es6_iterator(this__4470__auto__);\n});})(G__29733_29736,G__29734_29737))\n;\ngoog.object.set(G__29733_29736,G__29734_29737,G__29735_29738);\n/**\n * Create seq from a primitive JavaScript Array-like.\n */\ncljs.core.prim_seq \x3d (function cljs$core$prim_seq(var_args){\nvar G__29740 \x3d arguments.length;\nswitch (G__29740) {\ncase 1:\nreturn cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 \x3d (function (prim){\nreturn cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim,(0));\n});\n\ncljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 \x3d (function (prim,i){\nif((i \x3c prim.length)){\nreturn (new cljs.core.IndexedSeq(prim,i,null));\n} else {\nreturn null;\n}\n});\n\ncljs.core.prim_seq.cljs$lang$maxFixedArity \x3d 2;\n\n/**\n * Create a seq from a JavaScript array.\n */\ncljs.core.array_seq \x3d (function cljs$core$array_seq(var_args){\nvar G__29743 \x3d arguments.length;\nswitch (G__29743) {\ncase 1:\nreturn cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 \x3d (function (array){\nreturn cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,(0));\n});\n\ncljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 \x3d (function (array,i){\nreturn cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,i);\n});\n\ncljs.core.array_seq.cljs$lang$maxFixedArity \x3d 2;\n\n\n\n/**\n* @constructor\n * @implements {cljs.core.IEquiv}\n * @implements {cljs.core.IHash}\n * @implements {cljs.core.ICollection}\n * @implements {cljs.core.IEmptyableCollection}\n * @implements {cljs.core.ICounted}\n * @implements {cljs.core.ISeq}\n * @implements {cljs.core.INext}\n * @implements {cljs.core.ISeqable}\n * @implements {cljs.core.IMeta}\n * @implements {cljs.core.ICloneable}\n * @implements {cljs.core.ISequential}\n * @implements {cljs.core.IWithMeta}\n * @implements {cljs.core.IReduce}\n*/\ncljs.core.RSeq \x3d (function (ci,i,meta){\nthis.ci \x3d ci;\nthis.i \x3d i;\nthis.meta \x3d meta;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 32374990;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 8192;\n});\ncljs.core.RSeq.prototype.toString \x3d (function (){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core.pr_str_STAR_(coll);\n});\n\ncljs.core.RSeq.prototype.equiv \x3d (function (other){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn this$.cljs$core$IEquiv$_equiv$arity$2(null,other);\n});\n\ncljs.core.RSeq.prototype.indexOf \x3d (function() {\nvar G__29745 \x3d null;\nvar G__29745__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));\n});\nvar G__29745__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__29745 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__29745__1.call(this,x);\ncase 2:\nreturn G__29745__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__29745.cljs$core$IFn$_invoke$arity$1 \x3d G__29745__1;\nG__29745.cljs$core$IFn$_invoke$arity$2 \x3d G__29745__2;\nreturn G__29745;\n})()\n;\n\ncljs.core.RSeq.prototype.lastIndexOf \x3d (function() {\nvar G__29746 \x3d null;\nvar G__29746__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll)));\n});\nvar G__29746__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__29746 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__29746__1.call(this,x);\ncase 2:\nreturn G__29746__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__29746.cljs$core$IFn$_invoke$arity$1 \x3d G__29746__1;\nG__29746.cljs$core$IFn$_invoke$arity$2 \x3d G__29746__2;\nreturn G__29746;\n})()\n;\n\ncljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn self__.meta;\n});\n\ncljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn (new cljs.core.RSeq(self__.ci,self__.i,self__.meta));\n});\n\ncljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((self__.i \x3e (0))){\nreturn (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));\n} else {\nreturn null;\n}\n});\n\ncljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (self__.i + (1));\n});\n\ncljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.hash_ordered_coll(coll__$1);\n});\n\ncljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 \x3d (function (coll,other){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(coll__$1,other) : cljs.core.equiv_sequential.call(null,coll__$1,other));\n});\n\ncljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);\n});\n\ncljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 \x3d (function (col,f){\nvar self__ \x3d this;\nvar col__$1 \x3d this;\nreturn (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,col__$1) : cljs.core.seq_reduce.call(null,f,col__$1));\n});\n\ncljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 \x3d (function (col,f,start){\nvar self__ \x3d this;\nvar col__$1 \x3d this;\nreturn (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,col__$1) : cljs.core.seq_reduce.call(null,f,start,col__$1));\n});\n\ncljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci,self__.i);\n});\n\ncljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((self__.i \x3e (0))){\nreturn (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));\n} else {\nreturn cljs.core.List.EMPTY;\n}\n});\n\ncljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn coll__$1;\n});\n\ncljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 \x3d (function (coll,new_meta){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (new cljs.core.RSeq(self__.ci,self__.i,new_meta));\n});\n\ncljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 \x3d (function (coll,o){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(o,coll__$1) : cljs.core.cons.call(null,o,coll__$1));\n});\n\ncljs.core.RSeq.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22ci\x22,\x22ci\x22,2049808339,null),new cljs.core.Symbol(null,\x22i\x22,\x22i\x22,253690212,null),new cljs.core.Symbol(null,\x22meta\x22,\x22meta\x22,-1154898805,null)], null);\n});\n\ncljs.core.RSeq.cljs$lang$type \x3d true;\n\ncljs.core.RSeq.cljs$lang$ctorStr \x3d \x22cljs.core/RSeq\x22;\n\ncljs.core.RSeq.cljs$lang$ctorPrWriter \x3d (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){\nreturn cljs.core._write(writer__4193__auto__,\x22cljs.core/RSeq\x22);\n});\n\n/**\n * Positional factory function for cljs.core/RSeq.\n */\ncljs.core.__GT_RSeq \x3d (function cljs$core$__GT_RSeq(ci,i,meta){\nreturn (new cljs.core.RSeq(ci,i,meta));\n});\n\nvar G__29747_29750 \x3d cljs.core.RSeq.prototype;\nvar G__29748_29751 \x3d cljs.core.ITER_SYMBOL;\nvar G__29749_29752 \x3d ((function (G__29747_29750,G__29748_29751){\nreturn (function (){\nvar this__4470__auto__ \x3d this;\nreturn cljs.core.es6_iterator(this__4470__auto__);\n});})(G__29747_29750,G__29748_29751))\n;\ngoog.object.set(G__29747_29750,G__29748_29751,G__29749_29752);\n/**\n * Same as (first (next x))\n */\ncljs.core.second \x3d (function cljs$core$second(coll){\nreturn cljs.core.first(cljs.core.next(coll));\n});\n/**\n * Same as (first (first x))\n */\ncljs.core.ffirst \x3d (function cljs$core$ffirst(coll){\nreturn cljs.core.first(cljs.core.first(coll));\n});\n/**\n * Same as (next (first x))\n */\ncljs.core.nfirst \x3d (function cljs$core$nfirst(coll){\nreturn cljs.core.next(cljs.core.first(coll));\n});\n/**\n * Same as (first (next x))\n */\ncljs.core.fnext \x3d (function cljs$core$fnext(coll){\nreturn cljs.core.first(cljs.core.next(coll));\n});\n/**\n * Same as (next (next x))\n */\ncljs.core.nnext \x3d (function cljs$core$nnext(coll){\nreturn cljs.core.next(cljs.core.next(coll));\n});\n/**\n * Return the last item in coll, in linear time\n */\ncljs.core.last \x3d (function cljs$core$last(s){\nwhile(true){\nvar sn \x3d cljs.core.next(s);\nif(!((sn \x3d\x3d null))){\nvar G__29753 \x3d sn;\ns \x3d G__29753;\ncontinue;\n} else {\nreturn cljs.core.first(s);\n}\nbreak;\n}\n});\ngoog.object.set(cljs.core.IEquiv,\x22_\x22,true);\n\nvar G__29754_29757 \x3d cljs.core._equiv;\nvar G__29755_29758 \x3d \x22_\x22;\nvar G__29756_29759 \x3d ((function (G__29754_29757,G__29755_29758){\nreturn (function (x,o){\nreturn (x \x3d\x3d\x3d o);\n});})(G__29754_29757,G__29755_29758))\n;\ngoog.object.set(G__29754_29757,G__29755_29758,G__29756_29759);\n/**\n * conj[oin]. Returns a new collection with the xs\n *   \x27added\x27. (conj nil item) returns (item).  The \x27addition\x27 may\n *   happen at different \x27places\x27 depending on the concrete type.\n */\ncljs.core.conj \x3d (function cljs$core$conj(var_args){\nvar G__29764 \x3d arguments.length;\nswitch (G__29764) {\ncase 0:\nreturn cljs.core.conj.cljs$core$IFn$_invoke$arity$0();\n\nbreak;\ncase 1:\nreturn cljs.core.conj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.conj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___29766 \x3d arguments.length;\nvar i__4532__auto___29767 \x3d (0);\nwhile(true){\nif((i__4532__auto___29767 \x3c len__4531__auto___29766)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___29767]));\n\nvar G__29768 \x3d (i__4532__auto___29767 + (1));\ni__4532__auto___29767 \x3d G__29768;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.conj.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nreturn cljs.core.PersistentVector.EMPTY;\n});\n\ncljs.core.conj.cljs$core$IFn$_invoke$arity$1 \x3d (function (coll){\nreturn coll;\n});\n\ncljs.core.conj.cljs$core$IFn$_invoke$arity$2 \x3d (function (coll,x){\nif(!((coll \x3d\x3d null))){\nreturn cljs.core._conj(coll,x);\n} else {\nreturn (new cljs.core.List(null,x,null,(1),null));\n}\n});\n\ncljs.core.conj.cljs$core$IFn$_invoke$arity$variadic \x3d (function (coll,x,xs){\nwhile(true){\nif(cljs.core.truth_(xs)){\nvar G__29769 \x3d cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);\nvar G__29770 \x3d cljs.core.first(xs);\nvar G__29771 \x3d cljs.core.next(xs);\ncoll \x3d G__29769;\nx \x3d G__29770;\nxs \x3d G__29771;\ncontinue;\n} else {\nreturn cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);\n}\nbreak;\n}\n});\n\n/** @this {Function} */\ncljs.core.conj.cljs$lang$applyTo \x3d (function (seq29761){\nvar G__29762 \x3d cljs.core.first(seq29761);\nvar seq29761__$1 \x3d cljs.core.next(seq29761);\nvar G__29763 \x3d cljs.core.first(seq29761__$1);\nvar seq29761__$2 \x3d cljs.core.next(seq29761__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29762,G__29763,seq29761__$2);\n});\n\ncljs.core.conj.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * Returns an empty collection of the same category as coll, or nil\n */\ncljs.core.empty \x3d (function cljs$core$empty(coll){\nif((coll \x3d\x3d null)){\nreturn null;\n} else {\nreturn cljs.core._empty(coll);\n}\n});\ncljs.core.accumulating_seq_count \x3d (function cljs$core$accumulating_seq_count(coll){\nvar s \x3d cljs.core.seq(coll);\nvar acc \x3d (0);\nwhile(true){\nif(cljs.core.counted_QMARK_(s)){\nreturn (acc + cljs.core._count(s));\n} else {\nvar G__29772 \x3d cljs.core.next(s);\nvar G__29773 \x3d (acc + (1));\ns \x3d G__29772;\nacc \x3d G__29773;\ncontinue;\n}\nbreak;\n}\n});\n/**\n * Returns the number of items in the collection. (count nil) returns\n *   0.  Also works on strings, arrays, and Maps\n */\ncljs.core.count \x3d (function cljs$core$count(coll){\nif(!((coll \x3d\x3d null))){\nif(((!((coll \x3d\x3d null)))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (2))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$ICounted$))))?true:false):false)){\nreturn coll.cljs$core$ICounted$_count$arity$1(null);\n} else {\nif(cljs.core.array_QMARK_(coll)){\nreturn coll.length;\n} else {\nif(typeof coll \x3d\x3d\x3d \x27string\x27){\nreturn coll.length;\n} else {\nif(((!((coll \x3d\x3d null)))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (8388608))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$ISeqable$))))?true:false):false)){\nreturn cljs.core.accumulating_seq_count(coll);\n} else {\nreturn cljs.core._count(coll);\n\n}\n}\n}\n}\n} else {\nreturn (0);\n}\n});\ncljs.core.linear_traversal_nth \x3d (function cljs$core$linear_traversal_nth(var_args){\nvar G__29777 \x3d arguments.length;\nswitch (G__29777) {\ncase 2:\nreturn cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 \x3d (function (coll,n){\nwhile(true){\nif((coll \x3d\x3d null)){\nthrow (new Error(\x22Index out of bounds\x22));\n} else {\nif((n \x3d\x3d\x3d (0))){\nif(cljs.core.seq(coll)){\nreturn cljs.core.first(coll);\n} else {\nthrow (new Error(\x22Index out of bounds\x22));\n}\n} else {\nif(cljs.core.indexed_QMARK_(coll)){\nreturn cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);\n} else {\nif(cljs.core.seq(coll)){\nvar G__29779 \x3d cljs.core.next(coll);\nvar G__29780 \x3d (n - (1));\ncoll \x3d G__29779;\nn \x3d G__29780;\ncontinue;\n} else {\nthrow (new Error(\x22Index out of bounds\x22));\n\n}\n}\n}\n}\nbreak;\n}\n});\n\ncljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 \x3d (function (coll,n,not_found){\nwhile(true){\nif((coll \x3d\x3d null)){\nreturn not_found;\n} else {\nif((n \x3d\x3d\x3d (0))){\nif(cljs.core.seq(coll)){\nreturn cljs.core.first(coll);\n} else {\nreturn not_found;\n}\n} else {\nif(cljs.core.indexed_QMARK_(coll)){\nreturn cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);\n} else {\nif(cljs.core.seq(coll)){\nvar G__29781 \x3d cljs.core.next(coll);\nvar G__29782 \x3d (n - (1));\nvar G__29783 \x3d not_found;\ncoll \x3d G__29781;\nn \x3d G__29782;\nnot_found \x3d G__29783;\ncontinue;\n} else {\nreturn not_found;\n\n}\n}\n}\n}\nbreak;\n}\n});\n\ncljs.core.linear_traversal_nth.cljs$lang$maxFixedArity \x3d 3;\n\n/**\n * Returns the value at the index. get returns nil if index out of\n *   bounds, nth throws an exception unless not-found is supplied.  nth\n *   also works for strings, arrays, regex Matchers and Lists, and,\n *   in O(n) time, for sequences.\n */\ncljs.core.nth \x3d (function cljs$core$nth(var_args){\nvar G__29785 \x3d arguments.length;\nswitch (G__29785) {\ncase 2:\nreturn cljs.core.nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core.nth.cljs$core$IFn$_invoke$arity$2 \x3d (function (coll,n){\nif(!(typeof n \x3d\x3d\x3d \x27number\x27)){\nthrow (new Error(\x22Index argument to nth must be a number\x22));\n} else {\nif((coll \x3d\x3d null)){\nreturn coll;\n} else {\nif(((!((coll \x3d\x3d null)))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (16))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$IIndexed$))))?true:false):false)){\nreturn coll.cljs$core$IIndexed$_nth$arity$2(null,n);\n} else {\nif(cljs.core.array_QMARK_(coll)){\nif((((n \x3e\x3d (0))) \x26\x26 ((n \x3c coll.length)))){\nreturn (coll[n]);\n} else {\nthrow (new Error(\x22Index out of bounds\x22));\n}\n} else {\nif(typeof coll \x3d\x3d\x3d \x27string\x27){\nif((((n \x3e\x3d (0))) \x26\x26 ((n \x3c coll.length)))){\nreturn coll.charAt(n);\n} else {\nthrow (new Error(\x22Index out of bounds\x22));\n}\n} else {\nif((function (){var or__3949__auto__ \x3d ((!((coll \x3d\x3d null)))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (64))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$ISeq$))))?true:false):false);\nif(or__3949__auto__){\nreturn or__3949__auto__;\n} else {\nif(!((coll \x3d\x3d null))){\nif((((coll.cljs$lang$protocol_mask$partition0$ \x26 (16777216))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$ISequential$)))){\nreturn true;\n} else {\nreturn false;\n}\n} else {\nreturn false;\n}\n}\n})()){\nreturn cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll,n);\n} else {\nif(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){\nreturn cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);\n} else {\nthrow (new Error([\x22nth not supported on this type \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join(\x27\x27)));\n\n}\n}\n}\n}\n}\n}\n}\n});\n\ncljs.core.nth.cljs$core$IFn$_invoke$arity$3 \x3d (function (coll,n,not_found){\nif(!(typeof n \x3d\x3d\x3d \x27number\x27)){\nthrow (new Error(\x22Index argument to nth must be a number.\x22));\n} else {\nif((coll \x3d\x3d null)){\nreturn not_found;\n} else {\nif(((!((coll \x3d\x3d null)))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (16))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$IIndexed$))))?true:false):false)){\nreturn coll.cljs$core$IIndexed$_nth$arity$3(null,n,not_found);\n} else {\nif(cljs.core.array_QMARK_(coll)){\nif((((n \x3e\x3d (0))) \x26\x26 ((n \x3c coll.length)))){\nreturn (coll[n]);\n} else {\nreturn not_found;\n}\n} else {\nif(typeof coll \x3d\x3d\x3d \x27string\x27){\nif((((n \x3e\x3d (0))) \x26\x26 ((n \x3c coll.length)))){\nreturn coll.charAt(n);\n} else {\nreturn not_found;\n}\n} else {\nif((function (){var or__3949__auto__ \x3d ((!((coll \x3d\x3d null)))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (64))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$ISeq$))))?true:false):false);\nif(or__3949__auto__){\nreturn or__3949__auto__;\n} else {\nif(!((coll \x3d\x3d null))){\nif((((coll.cljs$lang$protocol_mask$partition0$ \x26 (16777216))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$ISequential$)))){\nreturn true;\n} else {\nreturn false;\n}\n} else {\nreturn false;\n}\n}\n})()){\nreturn cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);\n} else {\nif(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){\nreturn cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);\n} else {\nthrow (new Error([\x22nth not supported on this type \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join(\x27\x27)));\n\n}\n}\n}\n}\n}\n}\n}\n});\n\ncljs.core.nth.cljs$lang$maxFixedArity \x3d 3;\n\n/**\n * Returns the nth rest of coll, coll when n is 0.\n */\ncljs.core.nthrest \x3d (function cljs$core$nthrest(coll,n){\nvar n__$1 \x3d n;\nvar xs \x3d coll;\nwhile(true){\nvar temp__5455__auto__ \x3d (((n__$1 \x3e (0))) \x26\x26 (cljs.core.seq(xs)));\nif(temp__5455__auto__){\nvar xs__$1 \x3d temp__5455__auto__;\nvar G__29795 \x3d (n__$1 - (1));\nvar G__29796 \x3d cljs.core.rest(xs__$1);\nn__$1 \x3d G__29795;\nxs \x3d G__29796;\ncontinue;\n} else {\nreturn xs;\n}\nbreak;\n}\n});\n/**\n * Returns the value mapped to key, not-found or nil if key not present.\n */\ncljs.core.get \x3d (function cljs$core$get(var_args){\nvar G__29798 \x3d arguments.length;\nswitch (G__29798) {\ncase 2:\nreturn cljs.core.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.get.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core.get.cljs$core$IFn$_invoke$arity$2 \x3d (function (o,k){\nif((o \x3d\x3d null)){\nreturn null;\n} else {\nif(((!((o \x3d\x3d null)))?(((((o.cljs$lang$protocol_mask$partition0$ \x26 (256))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d o.cljs$core$ILookup$))))?true:false):false)){\nreturn o.cljs$core$ILookup$_lookup$arity$2(null,k);\n} else {\nif(cljs.core.array_QMARK_(o)){\nif(((!((k \x3d\x3d null))) \x26\x26 ((k \x3c o.length)))){\nreturn (o[(k | (0))]);\n} else {\nreturn null;\n}\n} else {\nif(typeof o \x3d\x3d\x3d \x27string\x27){\nif(((!((k \x3d\x3d null))) \x26\x26 ((k \x3c o.length)))){\nreturn o.charAt((k | (0)));\n} else {\nreturn null;\n}\n} else {\nif(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){\nreturn cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o,k);\n} else {\nreturn null;\n\n}\n}\n}\n}\n}\n});\n\ncljs.core.get.cljs$core$IFn$_invoke$arity$3 \x3d (function (o,k,not_found){\nif(!((o \x3d\x3d null))){\nif(((!((o \x3d\x3d null)))?(((((o.cljs$lang$protocol_mask$partition0$ \x26 (256))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d o.cljs$core$ILookup$))))?true:false):false)){\nreturn o.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);\n} else {\nif(cljs.core.array_QMARK_(o)){\nif(((!((k \x3d\x3d null))) \x26\x26 ((k \x3e\x3d (0))) \x26\x26 ((k \x3c o.length)))){\nreturn (o[(k | (0))]);\n} else {\nreturn not_found;\n}\n} else {\nif(typeof o \x3d\x3d\x3d \x27string\x27){\nif(((!((k \x3d\x3d null))) \x26\x26 ((k \x3e\x3d (0))) \x26\x26 ((k \x3c o.length)))){\nreturn o.charAt((k | (0)));\n} else {\nreturn not_found;\n}\n} else {\nif(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){\nreturn cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o,k,not_found);\n} else {\nreturn not_found;\n\n}\n}\n}\n}\n} else {\nreturn not_found;\n}\n});\n\ncljs.core.get.cljs$lang$maxFixedArity \x3d 3;\n\n\n\n/**\n * assoc[iate]. When applied to a map, returns a new map of the\n * same (hashed/sorted) type, that contains the mapping of key(s) to\n * val(s). When applied to a vector, returns a new vector that\n * contains val at index.\n */\ncljs.core.assoc \x3d (function cljs$core$assoc(var_args){\nvar G__29807 \x3d arguments.length;\nswitch (G__29807) {\ncase 3:\nreturn cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___29809 \x3d arguments.length;\nvar i__4532__auto___29810 \x3d (0);\nwhile(true){\nif((i__4532__auto___29810 \x3c len__4531__auto___29809)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___29810]));\n\nvar G__29811 \x3d (i__4532__auto___29810 + (1));\ni__4532__auto___29810 \x3d G__29811;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((3)),(0),null));\nreturn cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.assoc.cljs$core$IFn$_invoke$arity$3 \x3d (function (coll,k,v){\nif(!((coll \x3d\x3d null))){\nreturn cljs.core._assoc(coll,k,v);\n} else {\nreturn cljs.core.PersistentArrayMap.createAsIfByAssoc([k,v]);\n}\n});\n\ncljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic \x3d (function (coll,k,v,kvs){\nwhile(true){\nvar ret \x3d cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll,k,v);\nif(cljs.core.truth_(kvs)){\nvar G__29812 \x3d ret;\nvar G__29813 \x3d cljs.core.first(kvs);\nvar G__29814 \x3d cljs.core.second(kvs);\nvar G__29815 \x3d cljs.core.nnext(kvs);\ncoll \x3d G__29812;\nk \x3d G__29813;\nv \x3d G__29814;\nkvs \x3d G__29815;\ncontinue;\n} else {\nreturn ret;\n}\nbreak;\n}\n});\n\n/** @this {Function} */\ncljs.core.assoc.cljs$lang$applyTo \x3d (function (seq29803){\nvar G__29804 \x3d cljs.core.first(seq29803);\nvar seq29803__$1 \x3d cljs.core.next(seq29803);\nvar G__29805 \x3d cljs.core.first(seq29803__$1);\nvar seq29803__$2 \x3d cljs.core.next(seq29803__$1);\nvar G__29806 \x3d cljs.core.first(seq29803__$2);\nvar seq29803__$3 \x3d cljs.core.next(seq29803__$2);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29804,G__29805,G__29806,seq29803__$3);\n});\n\ncljs.core.assoc.cljs$lang$maxFixedArity \x3d (3);\n\n/**\n * dissoc[iate]. Returns a new map of the same (hashed/sorted) type,\n *   that does not contain a mapping for key(s).\n */\ncljs.core.dissoc \x3d (function cljs$core$dissoc(var_args){\nvar G__29820 \x3d arguments.length;\nswitch (G__29820) {\ncase 1:\nreturn cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___29822 \x3d arguments.length;\nvar i__4532__auto___29823 \x3d (0);\nwhile(true){\nif((i__4532__auto___29823 \x3c len__4531__auto___29822)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___29823]));\n\nvar G__29824 \x3d (i__4532__auto___29823 + (1));\ni__4532__auto___29823 \x3d G__29824;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 \x3d (function (coll){\nreturn coll;\n});\n\ncljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 \x3d (function (coll,k){\nif((coll \x3d\x3d null)){\nreturn null;\n} else {\nreturn cljs.core._dissoc(coll,k);\n}\n});\n\ncljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic \x3d (function (coll,k,ks){\nwhile(true){\nif((coll \x3d\x3d null)){\nreturn null;\n} else {\nvar ret \x3d cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll,k);\nif(cljs.core.truth_(ks)){\nvar G__29825 \x3d ret;\nvar G__29826 \x3d cljs.core.first(ks);\nvar G__29827 \x3d cljs.core.next(ks);\ncoll \x3d G__29825;\nk \x3d G__29826;\nks \x3d G__29827;\ncontinue;\n} else {\nreturn ret;\n}\n}\nbreak;\n}\n});\n\n/** @this {Function} */\ncljs.core.dissoc.cljs$lang$applyTo \x3d (function (seq29817){\nvar G__29818 \x3d cljs.core.first(seq29817);\nvar seq29817__$1 \x3d cljs.core.next(seq29817);\nvar G__29819 \x3d cljs.core.first(seq29817__$1);\nvar seq29817__$2 \x3d cljs.core.next(seq29817__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29818,G__29819,seq29817__$2);\n});\n\ncljs.core.dissoc.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * Return true if f is a JavaScript function or satisfies the Fn protocol.\n */\ncljs.core.fn_QMARK_ \x3d (function cljs$core$fn_QMARK_(f){\nvar or__3949__auto__ \x3d goog.isFunction(f);\nif(or__3949__auto__){\nreturn or__3949__auto__;\n} else {\nif(!((f \x3d\x3d null))){\nif(((false) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d f.cljs$core$Fn$)))){\nreturn true;\n} else {\nif((!f.cljs$lang$protocol_mask$partition$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);\n}\n}\n});\n\n/**\n* @constructor\n * @implements {cljs.core.IFn}\n * @implements {cljs.core.IMeta}\n * @implements {cljs.core.Fn}\n * @implements {cljs.core.IWithMeta}\n*/\ncljs.core.MetaFn \x3d (function (afn,meta){\nthis.afn \x3d afn;\nthis.meta \x3d meta;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 393217;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 0;\n});\ncljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn self__.meta;\n});\n\ncljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 \x3d (function (_,new_meta){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn (new cljs.core.MetaFn(self__.afn,new_meta));\n});\n\ncljs.core.MetaFn.prototype.cljs$core$Fn$ \x3d cljs.core.PROTOCOL_SENTINEL;\n\ncljs.core.MetaFn.prototype.call \x3d (function() {\nvar G__29831 \x3d null;\nvar G__29831__1 \x3d (function (self__){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));\n});\nvar G__29831__2 \x3d (function (self__,a){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));\n});\nvar G__29831__3 \x3d (function (self__,a,b){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));\n});\nvar G__29831__4 \x3d (function (self__,a,b,c){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));\n});\nvar G__29831__5 \x3d (function (self__,a,b,c,d){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));\n});\nvar G__29831__6 \x3d (function (self__,a,b,c,d,e){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));\n});\nvar G__29831__7 \x3d (function (self__,a,b,c,d,e,f){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));\n});\nvar G__29831__8 \x3d (function (self__,a,b,c,d,e,f,g){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));\n});\nvar G__29831__9 \x3d (function (self__,a,b,c,d,e,f,g,h){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));\n});\nvar G__29831__10 \x3d (function (self__,a,b,c,d,e,f,g,h,i){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));\n});\nvar G__29831__11 \x3d (function (self__,a,b,c,d,e,f,g,h,i,j){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));\n});\nvar G__29831__12 \x3d (function (self__,a,b,c,d,e,f,g,h,i,j,k){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));\n});\nvar G__29831__13 \x3d (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));\n});\nvar G__29831__14 \x3d (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));\n});\nvar G__29831__15 \x3d (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));\n});\nvar G__29831__16 \x3d (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));\n});\nvar G__29831__17 \x3d (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));\n});\nvar G__29831__18 \x3d (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));\n});\nvar G__29831__19 \x3d (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));\n});\nvar G__29831__20 \x3d (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));\n});\nvar G__29831__21 \x3d (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));\n});\nvar G__29831__22 \x3d (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar _ \x3d self____$1;\nreturn (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : cljs.core.apply.call(null,self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));\n});\nG__29831 \x3d function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){\nswitch(arguments.length){\ncase 1:\nreturn G__29831__1.call(this,self__);\ncase 2:\nreturn G__29831__2.call(this,self__,a);\ncase 3:\nreturn G__29831__3.call(this,self__,a,b);\ncase 4:\nreturn G__29831__4.call(this,self__,a,b,c);\ncase 5:\nreturn G__29831__5.call(this,self__,a,b,c,d);\ncase 6:\nreturn G__29831__6.call(this,self__,a,b,c,d,e);\ncase 7:\nreturn G__29831__7.call(this,self__,a,b,c,d,e,f);\ncase 8:\nreturn G__29831__8.call(this,self__,a,b,c,d,e,f,g);\ncase 9:\nreturn G__29831__9.call(this,self__,a,b,c,d,e,f,g,h);\ncase 10:\nreturn G__29831__10.call(this,self__,a,b,c,d,e,f,g,h,i);\ncase 11:\nreturn G__29831__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);\ncase 12:\nreturn G__29831__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);\ncase 13:\nreturn G__29831__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);\ncase 14:\nreturn G__29831__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);\ncase 15:\nreturn G__29831__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);\ncase 16:\nreturn G__29831__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);\ncase 17:\nreturn G__29831__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);\ncase 18:\nreturn G__29831__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);\ncase 19:\nreturn G__29831__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);\ncase 20:\nreturn G__29831__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);\ncase 21:\nreturn G__29831__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);\ncase 22:\nreturn G__29831__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);\n}\nthrow(new Error(\x27Invalid arity: \x27 + (arguments.length - 1)));\n};\nG__29831.cljs$core$IFn$_invoke$arity$1 \x3d G__29831__1;\nG__29831.cljs$core$IFn$_invoke$arity$2 \x3d G__29831__2;\nG__29831.cljs$core$IFn$_invoke$arity$3 \x3d G__29831__3;\nG__29831.cljs$core$IFn$_invoke$arity$4 \x3d G__29831__4;\nG__29831.cljs$core$IFn$_invoke$arity$5 \x3d G__29831__5;\nG__29831.cljs$core$IFn$_invoke$arity$6 \x3d G__29831__6;\nG__29831.cljs$core$IFn$_invoke$arity$7 \x3d G__29831__7;\nG__29831.cljs$core$IFn$_invoke$arity$8 \x3d G__29831__8;\nG__29831.cljs$core$IFn$_invoke$arity$9 \x3d G__29831__9;\nG__29831.cljs$core$IFn$_invoke$arity$10 \x3d G__29831__10;\nG__29831.cljs$core$IFn$_invoke$arity$11 \x3d G__29831__11;\nG__29831.cljs$core$IFn$_invoke$arity$12 \x3d G__29831__12;\nG__29831.cljs$core$IFn$_invoke$arity$13 \x3d G__29831__13;\nG__29831.cljs$core$IFn$_invoke$arity$14 \x3d G__29831__14;\nG__29831.cljs$core$IFn$_invoke$arity$15 \x3d G__29831__15;\nG__29831.cljs$core$IFn$_invoke$arity$16 \x3d G__29831__16;\nG__29831.cljs$core$IFn$_invoke$arity$17 \x3d G__29831__17;\nG__29831.cljs$core$IFn$_invoke$arity$18 \x3d G__29831__18;\nG__29831.cljs$core$IFn$_invoke$arity$19 \x3d G__29831__19;\nG__29831.cljs$core$IFn$_invoke$arity$20 \x3d G__29831__20;\nG__29831.cljs$core$IFn$_invoke$arity$21 \x3d G__29831__21;\nG__29831.cljs$core$IFn$_invoke$arity$22 \x3d G__29831__22;\nreturn G__29831;\n})()\n;\n\ncljs.core.MetaFn.prototype.apply \x3d (function (self__,args29830){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nreturn self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args29830)));\n});\n\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));\n});\n\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 \x3d (function (a){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));\n});\n\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 \x3d (function (a,b){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));\n});\n\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 \x3d (function (a,b,c){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));\n});\n\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 \x3d (function (a,b,c,d){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));\n});\n\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 \x3d (function (a,b,c,d,e){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));\n});\n\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 \x3d (function (a,b,c,d,e,f){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));\n});\n\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 \x3d (function (a,b,c,d,e,f,g){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));\n});\n\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 \x3d (function (a,b,c,d,e,f,g,h){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));\n});\n\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 \x3d (function (a,b,c,d,e,f,g,h,i){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));\n});\n\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 \x3d (function (a,b,c,d,e,f,g,h,i,j){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));\n});\n\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 \x3d (function (a,b,c,d,e,f,g,h,i,j,k){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));\n});\n\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));\n});\n\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));\n});\n\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));\n});\n\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));\n});\n\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));\n});\n\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));\n});\n\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));\n});\n\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));\n});\n\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));\n});\n\ncljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 \x3d (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : cljs.core.apply.call(null,self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));\n});\n\ncljs.core.MetaFn.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22afn\x22,\x22afn\x22,216963467,null),new cljs.core.Symbol(null,\x22meta\x22,\x22meta\x22,-1154898805,null)], null);\n});\n\ncljs.core.MetaFn.cljs$lang$type \x3d true;\n\ncljs.core.MetaFn.cljs$lang$ctorStr \x3d \x22cljs.core/MetaFn\x22;\n\ncljs.core.MetaFn.cljs$lang$ctorPrWriter \x3d (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){\nreturn cljs.core._write(writer__4193__auto__,\x22cljs.core/MetaFn\x22);\n});\n\n/**\n * Positional factory function for cljs.core/MetaFn.\n */\ncljs.core.__GT_MetaFn \x3d (function cljs$core$__GT_MetaFn(afn,meta){\nreturn (new cljs.core.MetaFn(afn,meta));\n});\n\n/**\n * Returns an object of the same type and value as obj, with\n *   map m as its metadata.\n */\ncljs.core.with_meta \x3d (function cljs$core$with_meta(o,meta){\nif(goog.isFunction(o)){\nreturn (new cljs.core.MetaFn(o,meta));\n} else {\nif((o \x3d\x3d null)){\nreturn null;\n} else {\nreturn cljs.core._with_meta(o,meta);\n}\n}\n});\n/**\n * Returns the metadata of obj, returns nil if there is no metadata.\n */\ncljs.core.meta \x3d (function cljs$core$meta(o){\nif((function (){var and__3938__auto__ \x3d !((o \x3d\x3d null));\nif(and__3938__auto__){\nif(!((o \x3d\x3d null))){\nif((((o.cljs$lang$protocol_mask$partition0$ \x26 (131072))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d o.cljs$core$IMeta$)))){\nreturn true;\n} else {\nif((!o.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);\n}\n} else {\nreturn and__3938__auto__;\n}\n})()){\nreturn cljs.core._meta(o);\n} else {\nreturn null;\n}\n});\n/**\n * For a list or queue, same as first, for a vector, same as, but much\n *   more efficient than, last. If the collection is empty, returns nil.\n */\ncljs.core.peek \x3d (function cljs$core$peek(coll){\nif((coll \x3d\x3d null)){\nreturn null;\n} else {\nreturn cljs.core._peek(coll);\n}\n});\n/**\n * For a list or queue, returns a new list/queue without the first\n *   item, for a vector, returns a new vector without the last item.\n *   Note - not the same as next/butlast.\n */\ncljs.core.pop \x3d (function cljs$core$pop(coll){\nif((coll \x3d\x3d null)){\nreturn null;\n} else {\nreturn cljs.core._pop(coll);\n}\n});\n/**\n * disj[oin]. Returns a new set of the same (hashed/sorted) type, that\n *   does not contain key(s).\n */\ncljs.core.disj \x3d (function cljs$core$disj(var_args){\nvar G__29838 \x3d arguments.length;\nswitch (G__29838) {\ncase 1:\nreturn cljs.core.disj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.disj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___29840 \x3d arguments.length;\nvar i__4532__auto___29841 \x3d (0);\nwhile(true){\nif((i__4532__auto___29841 \x3c len__4531__auto___29840)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___29841]));\n\nvar G__29842 \x3d (i__4532__auto___29841 + (1));\ni__4532__auto___29841 \x3d G__29842;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.disj.cljs$core$IFn$_invoke$arity$1 \x3d (function (coll){\nreturn coll;\n});\n\ncljs.core.disj.cljs$core$IFn$_invoke$arity$2 \x3d (function (coll,k){\nif((coll \x3d\x3d null)){\nreturn null;\n} else {\nreturn cljs.core._disjoin(coll,k);\n}\n});\n\ncljs.core.disj.cljs$core$IFn$_invoke$arity$variadic \x3d (function (coll,k,ks){\nwhile(true){\nif((coll \x3d\x3d null)){\nreturn null;\n} else {\nvar ret \x3d cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll,k);\nif(cljs.core.truth_(ks)){\nvar G__29843 \x3d ret;\nvar G__29844 \x3d cljs.core.first(ks);\nvar G__29845 \x3d cljs.core.next(ks);\ncoll \x3d G__29843;\nk \x3d G__29844;\nks \x3d G__29845;\ncontinue;\n} else {\nreturn ret;\n}\n}\nbreak;\n}\n});\n\n/** @this {Function} */\ncljs.core.disj.cljs$lang$applyTo \x3d (function (seq29835){\nvar G__29836 \x3d cljs.core.first(seq29835);\nvar seq29835__$1 \x3d cljs.core.next(seq29835);\nvar G__29837 \x3d cljs.core.first(seq29835__$1);\nvar seq29835__$2 \x3d cljs.core.next(seq29835__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29836,G__29837,seq29835__$2);\n});\n\ncljs.core.disj.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * Returns true if coll has no items - same as (not (seq coll)).\n *   Please use the idiom (seq x) rather than (not (empty? x))\n */\ncljs.core.empty_QMARK_ \x3d (function cljs$core$empty_QMARK_(coll){\nreturn (((coll \x3d\x3d null)) || (cljs.core.not(cljs.core.seq(coll))));\n});\n/**\n * Returns true if x satisfies ICollection\n */\ncljs.core.coll_QMARK_ \x3d (function cljs$core$coll_QMARK_(x){\nif((x \x3d\x3d null)){\nreturn false;\n} else {\nif(!((x \x3d\x3d null))){\nif((((x.cljs$lang$protocol_mask$partition0$ \x26 (8))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$ICollection$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);\n}\n}\n});\n/**\n * Returns true if x satisfies ISet\n */\ncljs.core.set_QMARK_ \x3d (function cljs$core$set_QMARK_(x){\nif((x \x3d\x3d null)){\nreturn false;\n} else {\nif(!((x \x3d\x3d null))){\nif((((x.cljs$lang$protocol_mask$partition0$ \x26 (4096))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$ISet$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);\n}\n}\n});\n/**\n * Returns true if coll implements IAssociative\n */\ncljs.core.associative_QMARK_ \x3d (function cljs$core$associative_QMARK_(x){\nif(!((x \x3d\x3d null))){\nif((((x.cljs$lang$protocol_mask$partition0$ \x26 (512))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$IAssociative$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);\n}\n});\n/**\n * Returns true if coll implements IFind\n */\ncljs.core.ifind_QMARK_ \x3d (function cljs$core$ifind_QMARK_(x){\nif(!((x \x3d\x3d null))){\nif(((false) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$IFind$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IFind,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IFind,x);\n}\n});\n/**\n * Returns true if coll satisfies ISequential\n */\ncljs.core.sequential_QMARK_ \x3d (function cljs$core$sequential_QMARK_(x){\nif(!((x \x3d\x3d null))){\nif((((x.cljs$lang$protocol_mask$partition0$ \x26 (16777216))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$ISequential$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);\n}\n});\n/**\n * Returns true if coll satisfies ISorted\n */\ncljs.core.sorted_QMARK_ \x3d (function cljs$core$sorted_QMARK_(x){\nif(!((x \x3d\x3d null))){\nif((((x.cljs$lang$protocol_mask$partition0$ \x26 (268435456))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$ISorted$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);\n}\n});\n/**\n * Returns true if coll satisfies IReduce\n */\ncljs.core.reduceable_QMARK_ \x3d (function cljs$core$reduceable_QMARK_(x){\nif(!((x \x3d\x3d null))){\nif((((x.cljs$lang$protocol_mask$partition0$ \x26 (524288))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$IReduce$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);\n}\n});\n/**\n * Return true if x satisfies IMap\n */\ncljs.core.map_QMARK_ \x3d (function cljs$core$map_QMARK_(x){\nif((x \x3d\x3d null)){\nreturn false;\n} else {\nif(!((x \x3d\x3d null))){\nif((((x.cljs$lang$protocol_mask$partition0$ \x26 (1024))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$IMap$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);\n}\n}\n});\n/**\n * Return true if x satisfies IRecord\n */\ncljs.core.record_QMARK_ \x3d (function cljs$core$record_QMARK_(x){\nif(!((x \x3d\x3d null))){\nif((((x.cljs$lang$protocol_mask$partition0$ \x26 (67108864))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$IRecord$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);\n}\n});\n/**\n * Return true if x satisfies IVector\n */\ncljs.core.vector_QMARK_ \x3d (function cljs$core$vector_QMARK_(x){\nif(!((x \x3d\x3d null))){\nif((((x.cljs$lang$protocol_mask$partition0$ \x26 (16384))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$IVector$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);\n}\n});\n\n/**\n * Return true if x is satisfies IChunkedSeq.\n */\ncljs.core.chunked_seq_QMARK_ \x3d (function cljs$core$chunked_seq_QMARK_(x){\nif(!((x \x3d\x3d null))){\nif((((x.cljs$lang$protocol_mask$partition1$ \x26 (512))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$IChunkedSeq$)))){\nreturn true;\n} else {\nreturn false;\n}\n} else {\nreturn false;\n}\n});\n/**\n * Create JavaSript object from an even number arguments representing\n *   interleaved keys and values.\n */\ncljs.core.js_obj \x3d (function cljs$core$js_obj(var_args){\nvar G__29859 \x3d arguments.length;\nswitch (G__29859) {\ncase 0:\nreturn cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___29863 \x3d arguments.length;\nvar i__4532__auto___29864 \x3d (0);\nwhile(true){\nif((i__4532__auto___29864 \x3c len__4531__auto___29863)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___29864]));\n\nvar G__29865 \x3d (i__4532__auto___29864 + (1));\ni__4532__auto___29864 \x3d G__29865;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((0)),(0),null));\nreturn cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__4547__auto__);\n\n}\n});\n\ncljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nreturn {};\n});\n\ncljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic \x3d (function (keyvals){\nreturn (cljs.core.apply.cljs$core$IFn$_invoke$arity$2 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(goog.object.create,keyvals) : cljs.core.apply.call(null,goog.object.create,keyvals));\n});\n\n/** @this {Function} */\ncljs.core.js_obj.cljs$lang$applyTo \x3d (function (seq29858){\nvar self__4519__auto__ \x3d this;\nreturn self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29858));\n});\n\ncljs.core.js_obj.cljs$lang$maxFixedArity \x3d (0);\n\n/**\n * Return the JavaScript keys for an object.\n */\ncljs.core.js_keys \x3d (function cljs$core$js_keys(obj){\nreturn goog.object.getKeys(obj);\n});\n/**\n * Delete a property from a JavaScript object.\n *   Returns true upon success, false otherwise.\n */\ncljs.core.js_delete \x3d (function cljs$core$js_delete(obj,key){\nreturn delete obj[key];\n});\ncljs.core.array_copy \x3d (function cljs$core$array_copy(from,i,to,j,len){\nvar i__$1 \x3d i;\nvar j__$1 \x3d j;\nvar len__$1 \x3d len;\nwhile(true){\nif((len__$1 \x3d\x3d\x3d (0))){\nreturn to;\n} else {\n(to[j__$1] \x3d (from[i__$1]));\n\nvar G__29866 \x3d (i__$1 + (1));\nvar G__29867 \x3d (j__$1 + (1));\nvar G__29868 \x3d (len__$1 - (1));\ni__$1 \x3d G__29866;\nj__$1 \x3d G__29867;\nlen__$1 \x3d G__29868;\ncontinue;\n}\nbreak;\n}\n});\ncljs.core.array_copy_downward \x3d (function cljs$core$array_copy_downward(from,i,to,j,len){\nvar i__$1 \x3d (i + (len - (1)));\nvar j__$1 \x3d (j + (len - (1)));\nvar len__$1 \x3d len;\nwhile(true){\nif((len__$1 \x3d\x3d\x3d (0))){\nreturn to;\n} else {\n(to[j__$1] \x3d (from[i__$1]));\n\nvar G__29869 \x3d (i__$1 - (1));\nvar G__29870 \x3d (j__$1 - (1));\nvar G__29871 \x3d (len__$1 - (1));\ni__$1 \x3d G__29869;\nj__$1 \x3d G__29870;\nlen__$1 \x3d G__29871;\ncontinue;\n}\nbreak;\n}\n});\ncljs.core.lookup_sentinel \x3d {};\n/**\n * Returns true if x is the value false, false otherwise.\n */\ncljs.core.false_QMARK_ \x3d (function cljs$core$false_QMARK_(x){\nreturn x \x3d\x3d\x3d false;\n});\n/**\n * Returns true if x is the value true, false otherwise.\n */\ncljs.core.true_QMARK_ \x3d (function cljs$core$true_QMARK_(x){\nreturn x \x3d\x3d\x3d true;\n});\n/**\n * Return true if x is a Boolean\n */\ncljs.core.boolean_QMARK_ \x3d (function cljs$core$boolean_QMARK_(x){\nreturn ((x \x3d\x3d\x3d true) || (x \x3d\x3d\x3d false));\n});\n/**\n * Returns true if x identical to the JavaScript undefined value.\n */\ncljs.core.undefined_QMARK_ \x3d (function cljs$core$undefined_QMARK_(x){\nreturn (void 0 \x3d\x3d\x3d x);\n});\n/**\n * Return true if s satisfies ISeq\n */\ncljs.core.seq_QMARK_ \x3d (function cljs$core$seq_QMARK_(s){\nif((s \x3d\x3d null)){\nreturn false;\n} else {\nif(!((s \x3d\x3d null))){\nif((((s.cljs$lang$protocol_mask$partition0$ \x26 (64))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d s.cljs$core$ISeq$)))){\nreturn true;\n} else {\nif((!s.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);\n}\n}\n});\n/**\n * Return true if the seq function is supported for s\n */\ncljs.core.seqable_QMARK_ \x3d (function cljs$core$seqable_QMARK_(s){\nvar or__3949__auto__ \x3d ((!((s \x3d\x3d null)))?(((((s.cljs$lang$protocol_mask$partition0$ \x26 (8388608))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d s.cljs$core$ISeqable$))))?true:(((!s.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s));\nif(or__3949__auto__){\nreturn or__3949__auto__;\n} else {\nreturn ((cljs.core.array_QMARK_(s)) || (typeof s \x3d\x3d\x3d \x27string\x27));\n}\n});\n/**\n * Coerce to boolean\n */\ncljs.core.boolean$ \x3d (function cljs$core$boolean(x){\nif((x \x3d\x3d null)){\nreturn false;\n} else {\nif(x \x3d\x3d\x3d false){\nreturn false;\n} else {\nreturn true;\n\n}\n}\n});\n/**\n * Returns true if f returns true for fn? or satisfies IFn.\n */\ncljs.core.ifn_QMARK_ \x3d (function cljs$core$ifn_QMARK_(f){\nvar or__3949__auto__ \x3d cljs.core.fn_QMARK_(f);\nif(or__3949__auto__){\nreturn or__3949__auto__;\n} else {\nif(!((f \x3d\x3d null))){\nif((((f.cljs$lang$protocol_mask$partition0$ \x26 (1))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d f.cljs$core$IFn$)))){\nreturn true;\n} else {\nif((!f.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);\n}\n}\n});\n/**\n * Returns true if n is a JavaScript number with no decimal part.\n */\ncljs.core.integer_QMARK_ \x3d (function cljs$core$integer_QMARK_(n){\nreturn ((typeof n \x3d\x3d\x3d \x27number\x27) \x26\x26 (!(isNaN(n))) \x26\x26 (!((n \x3d\x3d\x3d Infinity))) \x26\x26 ((parseFloat(n) \x3d\x3d\x3d parseInt(n,(10)))));\n});\n/**\n * Return true if x satisfies integer? or is an instance of goog.math.Integer\n * or goog.math.Long.\n */\ncljs.core.int_QMARK_ \x3d (function cljs$core$int_QMARK_(x){\nreturn ((cljs.core.integer_QMARK_(x)) || ((x instanceof goog.math.Integer)) || ((x instanceof goog.math.Long)));\n});\n/**\n * Return true if x satisfies int? and is positive.\n */\ncljs.core.pos_int_QMARK_ \x3d (function cljs$core$pos_int_QMARK_(x){\nif(cljs.core.integer_QMARK_(x)){\nreturn (x \x3e (0));\n} else {\nif((x instanceof goog.math.Integer)){\nreturn ((cljs.core.not(x.isNegative())) \x26\x26 (cljs.core.not(x.isZero())));\n} else {\nif((x instanceof goog.math.Long)){\nreturn ((cljs.core.not(x.isNegative())) \x26\x26 (cljs.core.not(x.isZero())));\n} else {\nreturn false;\n\n}\n}\n}\n});\n/**\n * Return true if x satisfies int? and is negative.\n */\ncljs.core.neg_int_QMARK_ \x3d (function cljs$core$neg_int_QMARK_(x){\nif(cljs.core.integer_QMARK_(x)){\nreturn (x \x3c (0));\n} else {\nif((x instanceof goog.math.Integer)){\nreturn x.isNegative();\n} else {\nif((x instanceof goog.math.Long)){\nreturn x.isNegative();\n} else {\nreturn false;\n\n}\n}\n}\n});\n/**\n * Return true if x satisfies int? and is a natural integer value.\n */\ncljs.core.nat_int_QMARK_ \x3d (function cljs$core$nat_int_QMARK_(x){\nif(cljs.core.integer_QMARK_(x)){\nreturn !((x \x3c (0)));\n} else {\nif((x instanceof goog.math.Integer)){\nreturn cljs.core.not(x.isNegative());\n} else {\nif((x instanceof goog.math.Long)){\nreturn cljs.core.not(x.isNegative());\n} else {\nreturn false;\n\n}\n}\n}\n});\n/**\n * Returns true for JavaScript numbers, false otherwise.\n */\ncljs.core.float_QMARK_ \x3d (function cljs$core$float_QMARK_(x){\nreturn typeof x \x3d\x3d\x3d \x27number\x27;\n});\n/**\n * Returns true for JavaScript numbers, false otherwise.\n */\ncljs.core.double_QMARK_ \x3d (function cljs$core$double_QMARK_(x){\nreturn typeof x \x3d\x3d\x3d \x27number\x27;\n});\n/**\n * Returns true for Infinity and -Infinity values.\n */\ncljs.core.infinite_QMARK_ \x3d (function cljs$core$infinite_QMARK_(x){\nreturn (((x \x3d\x3d\x3d Number.POSITIVE_INFINITY)) || ((x \x3d\x3d\x3d Number.NEGATIVE_INFINITY)));\n});\n/**\n * Returns true if key is present in the given collection, otherwise\n *   returns false.  Note that for numerically indexed collections like\n *   vectors and arrays, this tests if the numeric key is within the\n *   range of indexes. \x27contains?\x27 operates constant or logarithmic time;\n *   it will not perform a linear search for a value.  See also \x27some\x27.\n */\ncljs.core.contains_QMARK_ \x3d (function cljs$core$contains_QMARK_(coll,v){\nif((cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,v,cljs.core.lookup_sentinel) \x3d\x3d\x3d cljs.core.lookup_sentinel)){\nreturn false;\n} else {\nreturn true;\n}\n});\n/**\n * Returns the map entry for key, or nil if key not present.\n */\ncljs.core.find \x3d (function cljs$core$find(coll,k){\nif(cljs.core.ifind_QMARK_(coll)){\nreturn cljs.core._find(coll,k);\n} else {\nif(((!((coll \x3d\x3d null))) \x26\x26 (cljs.core.associative_QMARK_(coll)) \x26\x26 (cljs.core.contains_QMARK_(coll,k)))){\nreturn (new cljs.core.MapEntry(k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,k),null));\n} else {\nreturn null;\n}\n}\n});\n/**\n * Returns true if no two of the arguments are \x3d\n */\ncljs.core.distinct_QMARK_ \x3d (function cljs$core$distinct_QMARK_(var_args){\nvar G__29883 \x3d arguments.length;\nswitch (G__29883) {\ncase 1:\nreturn cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___29885 \x3d arguments.length;\nvar i__4532__auto___29886 \x3d (0);\nwhile(true){\nif((i__4532__auto___29886 \x3c len__4531__auto___29885)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___29886]));\n\nvar G__29887 \x3d (i__4532__auto___29886 + (1));\ni__4532__auto___29886 \x3d G__29887;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn true;\n});\n\ncljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));\n});\n\ncljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nif(!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y))){\nvar s \x3d cljs.core.PersistentHashSet.createAsIfByAssoc([x,y]);\nvar xs \x3d more;\nwhile(true){\nvar x__$1 \x3d cljs.core.first(xs);\nvar etc \x3d cljs.core.next(xs);\nif(cljs.core.truth_(xs)){\nif(cljs.core.contains_QMARK_(s,x__$1)){\nreturn false;\n} else {\nvar G__29888 \x3d cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,x__$1);\nvar G__29889 \x3d etc;\ns \x3d G__29888;\nxs \x3d G__29889;\ncontinue;\n}\n} else {\nreturn true;\n}\nbreak;\n}\n} else {\nreturn false;\n}\n});\n\n/** @this {Function} */\ncljs.core.distinct_QMARK_.cljs$lang$applyTo \x3d (function (seq29880){\nvar G__29881 \x3d cljs.core.first(seq29880);\nvar seq29880__$1 \x3d cljs.core.next(seq29880);\nvar G__29882 \x3d cljs.core.first(seq29880__$1);\nvar seq29880__$2 \x3d cljs.core.next(seq29880__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29881,G__29882,seq29880__$2);\n});\n\ncljs.core.distinct_QMARK_.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * Comparator. Returns a negative number, zero, or a positive number\n *   when x is logically \x27less than\x27, \x27equal to\x27, or \x27greater than\x27\n *   y. Uses IComparable if available and google.array.defaultCompare for objects\n *  of the same type and special-cases nil to be less than any other object.\n */\ncljs.core.compare \x3d (function cljs$core$compare(x,y){\nif((x \x3d\x3d\x3d y)){\nreturn (0);\n} else {\nif((x \x3d\x3d null)){\nreturn (-1);\n} else {\nif((y \x3d\x3d null)){\nreturn (1);\n} else {\nif(typeof x \x3d\x3d\x3d \x27number\x27){\nif(typeof y \x3d\x3d\x3d \x27number\x27){\nreturn goog.array.defaultCompare(x,y);\n} else {\nthrow (new Error([\x22Cannot compare \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),\x22 to \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join(\x27\x27)));\n}\n} else {\nif(((!((x \x3d\x3d null)))?(((((x.cljs$lang$protocol_mask$partition1$ \x26 (2048))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$IComparable$))))?true:(((!x.cljs$lang$protocol_mask$partition1$))?cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x))){\nreturn cljs.core._compare(x,y);\n} else {\nif(((((typeof x \x3d\x3d\x3d \x27string\x27) || (cljs.core.array_QMARK_(x)) || (x \x3d\x3d\x3d true) || (x \x3d\x3d\x3d false))) \x26\x26 ((cljs.core.type(x) \x3d\x3d\x3d cljs.core.type(y))))){\nreturn goog.array.defaultCompare(x,y);\n} else {\nthrow (new Error([\x22Cannot compare \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),\x22 to \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join(\x27\x27)));\n}\n\n}\n}\n}\n}\n}\n});\n/**\n * Compare indexed collection.\n */\ncljs.core.compare_indexed \x3d (function cljs$core$compare_indexed(var_args){\nvar G__29892 \x3d arguments.length;\nswitch (G__29892) {\ncase 2:\nreturn cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 4:\nreturn cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 \x3d (function (xs,ys){\nvar xl \x3d cljs.core.count(xs);\nvar yl \x3d cljs.core.count(ys);\nif((xl \x3c yl)){\nreturn (-1);\n} else {\nif((xl \x3e yl)){\nreturn (1);\n} else {\nif((xl \x3d\x3d\x3d (0))){\nreturn (0);\n} else {\nreturn cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs,ys,xl,(0));\n\n}\n}\n}\n});\n\ncljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 \x3d (function (xs,ys,len,n){\nwhile(true){\nvar d \x3d cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs,n),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys,n));\nif((((d \x3d\x3d\x3d (0))) \x26\x26 (((n + (1)) \x3c len)))){\nvar G__29894 \x3d xs;\nvar G__29895 \x3d ys;\nvar G__29896 \x3d len;\nvar G__29897 \x3d (n + (1));\nxs \x3d G__29894;\nys \x3d G__29895;\nlen \x3d G__29896;\nn \x3d G__29897;\ncontinue;\n} else {\nreturn d;\n}\nbreak;\n}\n});\n\ncljs.core.compare_indexed.cljs$lang$maxFixedArity \x3d 4;\n\n/**\n * Given a fn that might be boolean valued or a comparator,\n * return a fn that is a comparator.\n */\ncljs.core.fn__GT_comparator \x3d (function cljs$core$fn__GT_comparator(f){\nif(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,cljs.core.compare)){\nreturn cljs.core.compare;\n} else {\nreturn (function (x,y){\nvar r \x3d (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));\nif(typeof r \x3d\x3d\x3d \x27number\x27){\nreturn r;\n} else {\nif(cljs.core.truth_(r)){\nreturn (-1);\n} else {\nif(cljs.core.truth_((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(y,x) : f.call(null,y,x)))){\nreturn (1);\n} else {\nreturn (0);\n}\n}\n}\n});\n}\n});\n/**\n * Returns a sorted sequence of the items in coll. Comp can be\n * boolean-valued comparison function, or a -/0/+ valued comparator.\n * Comp defaults to compare.\n */\ncljs.core.sort \x3d (function cljs$core$sort(var_args){\nvar G__29899 \x3d arguments.length;\nswitch (G__29899) {\ncase 1:\nreturn cljs.core.sort.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.sort.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core.sort.cljs$core$IFn$_invoke$arity$1 \x3d (function (coll){\nreturn cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,coll);\n});\n\ncljs.core.sort.cljs$core$IFn$_invoke$arity$2 \x3d (function (comp,coll){\nif(cljs.core.seq(coll)){\nvar a \x3d (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.to_array.call(null,coll));\nvar G__29900_29903 \x3d a;\nvar G__29901_29904 \x3d cljs.core.fn__GT_comparator(comp);\ngoog.array.stableSort(G__29900_29903,G__29901_29904);\n\nreturn cljs.core.seq(a);\n} else {\nreturn cljs.core.List.EMPTY;\n}\n});\n\ncljs.core.sort.cljs$lang$maxFixedArity \x3d 2;\n\n/**\n * Returns a sorted sequence of the items in coll, where the sort\n * order is determined by comparing (keyfn item).  Comp can be\n * boolean-valued comparison function, or a -/0/+ valued comparator.\n * Comp defaults to compare.\n */\ncljs.core.sort_by \x3d (function cljs$core$sort_by(var_args){\nvar G__29906 \x3d arguments.length;\nswitch (G__29906) {\ncase 2:\nreturn cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 \x3d (function (keyfn,coll){\nreturn cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,cljs.core.compare,coll);\n});\n\ncljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 \x3d (function (keyfn,comp,coll){\nreturn cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (x,y){\nvar G__29908 \x3d (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(x) : keyfn.call(null,x));\nvar G__29909 \x3d (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(y) : keyfn.call(null,y));\nvar fexpr__29907 \x3d cljs.core.fn__GT_comparator(comp);\nreturn (fexpr__29907.cljs$core$IFn$_invoke$arity$2 ? fexpr__29907.cljs$core$IFn$_invoke$arity$2(G__29908,G__29909) : fexpr__29907.call(null,G__29908,G__29909));\n}),coll);\n});\n\ncljs.core.sort_by.cljs$lang$maxFixedArity \x3d 3;\n\ncljs.core.seq_reduce \x3d (function cljs$core$seq_reduce(var_args){\nvar G__29912 \x3d arguments.length;\nswitch (G__29912) {\ncase 2:\nreturn cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 \x3d (function (f,coll){\nvar temp__5455__auto__ \x3d cljs.core.seq(coll);\nif(temp__5455__auto__){\nvar s \x3d temp__5455__auto__;\nvar G__29913 \x3d f;\nvar G__29914 \x3d cljs.core.first(s);\nvar G__29915 \x3d cljs.core.next(s);\nreturn (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__29913,G__29914,G__29915) : cljs.core.reduce.call(null,G__29913,G__29914,G__29915));\n} else {\nreturn (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));\n}\n});\n\ncljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 \x3d (function (f,val,coll){\nvar val__$1 \x3d val;\nvar coll__$1 \x3d cljs.core.seq(coll);\nwhile(true){\nif(coll__$1){\nvar nval \x3d (function (){var G__29916 \x3d val__$1;\nvar G__29917 \x3d cljs.core.first(coll__$1);\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__29916,G__29917) : f.call(null,G__29916,G__29917));\n})();\nif(cljs.core.reduced_QMARK_(nval)){\nreturn cljs.core.deref(nval);\n} else {\nvar G__29919 \x3d nval;\nvar G__29920 \x3d cljs.core.next(coll__$1);\nval__$1 \x3d G__29919;\ncoll__$1 \x3d G__29920;\ncontinue;\n}\n} else {\nreturn val__$1;\n}\nbreak;\n}\n});\n\ncljs.core.seq_reduce.cljs$lang$maxFixedArity \x3d 3;\n\n/**\n * Return a random permutation of coll\n */\ncljs.core.shuffle \x3d (function cljs$core$shuffle(coll){\nvar a \x3d (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.to_array.call(null,coll));\ngoog.array.shuffle(a);\n\nreturn (cljs.core.vec.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vec.cljs$core$IFn$_invoke$arity$1(a) : cljs.core.vec.call(null,a));\n});\ncljs.core.iter_reduce \x3d (function cljs$core$iter_reduce(var_args){\nvar G__29922 \x3d arguments.length;\nswitch (G__29922) {\ncase 2:\nreturn cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2 \x3d (function (coll,f){\nvar iter \x3d cljs.core._iterator(coll);\nif(cljs.core.truth_(iter.hasNext())){\nvar init \x3d iter.next();\nvar acc \x3d init;\nwhile(true){\nif(iter.hasNext()){\nvar nacc \x3d (function (){var G__29923 \x3d acc;\nvar G__29924 \x3d iter.next();\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__29923,G__29924) : f.call(null,G__29923,G__29924));\n})();\nif(cljs.core.reduced_QMARK_(nacc)){\nreturn cljs.core.deref(nacc);\n} else {\nvar G__29928 \x3d nacc;\nacc \x3d G__29928;\ncontinue;\n}\n} else {\nreturn acc;\n}\nbreak;\n}\n} else {\nreturn (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));\n}\n});\n\ncljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3 \x3d (function (coll,f,init){\nvar iter \x3d cljs.core._iterator(coll);\nvar acc \x3d init;\nwhile(true){\nif(iter.hasNext()){\nvar nacc \x3d (function (){var G__29925 \x3d acc;\nvar G__29926 \x3d iter.next();\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__29925,G__29926) : f.call(null,G__29925,G__29926));\n})();\nif(cljs.core.reduced_QMARK_(nacc)){\nreturn cljs.core.deref(nacc);\n} else {\nvar G__29929 \x3d nacc;\nacc \x3d G__29929;\ncontinue;\n}\n} else {\nreturn acc;\n}\nbreak;\n}\n});\n\ncljs.core.iter_reduce.cljs$lang$maxFixedArity \x3d 3;\n\n/**\n * f should be a function of 2 arguments. If val is not supplied,\n *   returns the result of applying f to the first 2 items in coll, then\n *   applying f to that result and the 3rd item, etc. If coll contains no\n *   items, f must accept no arguments as well, and reduce returns the\n *   result of calling f with no arguments.  If coll has only 1 item, it\n *   is returned and f is not called.  If val is supplied, returns the\n *   result of applying f to val and the first item in coll, then\n *   applying f to that result and the 2nd item, etc. If coll contains no\n *   items, returns val and f is not called.\n */\ncljs.core.reduce \x3d (function cljs$core$reduce(var_args){\nvar G__29931 \x3d arguments.length;\nswitch (G__29931) {\ncase 2:\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core.reduce.cljs$core$IFn$_invoke$arity$2 \x3d (function (f,coll){\nif(((!((coll \x3d\x3d null)))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (524288))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$IReduce$))))?true:false):false)){\nreturn coll.cljs$core$IReduce$_reduce$arity$2(null,f);\n} else {\nif(cljs.core.array_QMARK_(coll)){\nreturn cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);\n} else {\nif(typeof coll \x3d\x3d\x3d \x27string\x27){\nreturn cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);\n} else {\nif(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){\nreturn cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll,f);\n} else {\nif(cljs.core.iterable_QMARK_(coll)){\nreturn cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);\n} else {\nreturn cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll);\n\n}\n}\n}\n}\n}\n});\n\ncljs.core.reduce.cljs$core$IFn$_invoke$arity$3 \x3d (function (f,val,coll){\nif(((!((coll \x3d\x3d null)))?(((((coll.cljs$lang$protocol_mask$partition0$ \x26 (524288))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$IReduce$))))?true:false):false)){\nreturn coll.cljs$core$IReduce$_reduce$arity$3(null,f,val);\n} else {\nif(cljs.core.array_QMARK_(coll)){\nreturn cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);\n} else {\nif(typeof coll \x3d\x3d\x3d \x27string\x27){\nreturn cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);\n} else {\nif(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){\nreturn cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);\n} else {\nif(cljs.core.iterable_QMARK_(coll)){\nreturn cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);\n} else {\nreturn cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,val,coll);\n\n}\n}\n}\n}\n}\n});\n\ncljs.core.reduce.cljs$lang$maxFixedArity \x3d 3;\n\n/**\n * Reduces an associative collection. f should be a function of 3\n *   arguments. Returns the result of applying f to init, the first key\n *   and the first value in coll, then applying f to that result and the\n *   2nd key and value, etc. If coll contains no entries, returns init\n *   and f is not called. Note that reduce-kv is supported on vectors,\n *   where the keys will be the ordinals.\n */\ncljs.core.reduce_kv \x3d (function cljs$core$reduce_kv(f,init,coll){\nif(!((coll \x3d\x3d null))){\nreturn cljs.core._kv_reduce(coll,f,init);\n} else {\nreturn init;\n}\n});\n/**\n * Returns its argument.\n */\ncljs.core.identity \x3d (function cljs$core$identity(x){\nreturn x;\n});\n/**\n * Takes a reducing function f of 2 args and returns a fn suitable for\n *   transduce by adding an arity-1 signature that calls cf (default -\n *   identity) on the result argument.\n */\ncljs.core.completing \x3d (function cljs$core$completing(var_args){\nvar G__29936 \x3d arguments.length;\nswitch (G__29936) {\ncase 1:\nreturn cljs.core.completing.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.completing.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core.completing.cljs$core$IFn$_invoke$arity$1 \x3d (function (f){\nreturn cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f,cljs.core.identity);\n});\n\ncljs.core.completing.cljs$core$IFn$_invoke$arity$2 \x3d (function (f,cf){\nreturn (function() {\nvar G__29938 \x3d null;\nvar G__29938__0 \x3d (function (){\nreturn (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));\n});\nvar G__29938__1 \x3d (function (x){\nreturn (cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(x) : cf.call(null,x));\n});\nvar G__29938__2 \x3d (function (x,y){\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));\n});\nG__29938 \x3d function(x,y){\nswitch(arguments.length){\ncase 0:\nreturn G__29938__0.call(this);\ncase 1:\nreturn G__29938__1.call(this,x);\ncase 2:\nreturn G__29938__2.call(this,x,y);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__29938.cljs$core$IFn$_invoke$arity$0 \x3d G__29938__0;\nG__29938.cljs$core$IFn$_invoke$arity$1 \x3d G__29938__1;\nG__29938.cljs$core$IFn$_invoke$arity$2 \x3d G__29938__2;\nreturn G__29938;\n})()\n});\n\ncljs.core.completing.cljs$lang$maxFixedArity \x3d 2;\n\n/**\n * reduce with a transformation of f (xf). If init is not\n *   supplied, (f) will be called to produce it. f should be a reducing\n *   step function that accepts both 1 and 2 arguments, if it accepts\n *   only 2 you can add the arity-1 with \x27completing\x27. Returns the result\n *   of applying (the transformed) xf to init and the first item in coll,\n *   then applying xf to that result and the 2nd item, etc. If coll\n *   contains no items, returns init and f is not called. Note that\n *   certain transforms may inject or skip items.\n */\ncljs.core.transduce \x3d (function cljs$core$transduce(var_args){\nvar G__29940 \x3d arguments.length;\nswitch (G__29940) {\ncase 3:\nreturn cljs.core.transduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ncase 4:\nreturn cljs.core.transduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core.transduce.cljs$core$IFn$_invoke$arity$3 \x3d (function (xform,f,coll){\nreturn cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,f,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),coll);\n});\n\ncljs.core.transduce.cljs$core$IFn$_invoke$arity$4 \x3d (function (xform,f,init,coll){\nvar f__$1 \x3d (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));\nvar ret \x3d cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1,init,coll);\nreturn (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(ret) : f__$1.call(null,ret));\n});\n\ncljs.core.transduce.cljs$lang$maxFixedArity \x3d 4;\n\n/**\n * Returns the sum of nums. (+) returns 0.\n */\ncljs.core._PLUS_ \x3d (function cljs$core$_PLUS_(var_args){\nvar G__29946 \x3d arguments.length;\nswitch (G__29946) {\ncase 0:\nreturn cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();\n\nbreak;\ncase 1:\nreturn cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___29948 \x3d arguments.length;\nvar i__4532__auto___29949 \x3d (0);\nwhile(true){\nif((i__4532__auto___29949 \x3c len__4531__auto___29948)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___29949]));\n\nvar G__29950 \x3d (i__4532__auto___29949 + (1));\ni__4532__auto___29949 \x3d G__29950;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nreturn (0);\n});\n\ncljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn x;\n});\n\ncljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x + y);\n});\n\ncljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(x + y),more);\n});\n\n/** @this {Function} */\ncljs.core._PLUS_.cljs$lang$applyTo \x3d (function (seq29943){\nvar G__29944 \x3d cljs.core.first(seq29943);\nvar seq29943__$1 \x3d cljs.core.next(seq29943);\nvar G__29945 \x3d cljs.core.first(seq29943__$1);\nvar seq29943__$2 \x3d cljs.core.next(seq29943__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29944,G__29945,seq29943__$2);\n});\n\ncljs.core._PLUS_.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * If no ys are supplied, returns the negation of x, else subtracts\n *   the ys from x and returns the result.\n */\ncljs.core._ \x3d (function cljs$core$_(var_args){\nvar G__29955 \x3d arguments.length;\nswitch (G__29955) {\ncase 1:\nreturn cljs.core._.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core._.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___29957 \x3d arguments.length;\nvar i__4532__auto___29958 \x3d (0);\nwhile(true){\nif((i__4532__auto___29958 \x3c len__4531__auto___29957)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___29958]));\n\nvar G__29959 \x3d (i__4532__auto___29958 + (1));\ni__4532__auto___29958 \x3d G__29959;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core._.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn (- x);\n});\n\ncljs.core._.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x - y);\n});\n\ncljs.core._.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._,(x - y),more);\n});\n\n/** @this {Function} */\ncljs.core._.cljs$lang$applyTo \x3d (function (seq29952){\nvar G__29953 \x3d cljs.core.first(seq29952);\nvar seq29952__$1 \x3d cljs.core.next(seq29952);\nvar G__29954 \x3d cljs.core.first(seq29952__$1);\nvar seq29952__$2 \x3d cljs.core.next(seq29952__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29953,G__29954,seq29952__$2);\n});\n\ncljs.core._.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * Returns the product of nums. (*) returns 1.\n */\ncljs.core._STAR_ \x3d (function cljs$core$_STAR_(var_args){\nvar G__29964 \x3d arguments.length;\nswitch (G__29964) {\ncase 0:\nreturn cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();\n\nbreak;\ncase 1:\nreturn cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___29966 \x3d arguments.length;\nvar i__4532__auto___29967 \x3d (0);\nwhile(true){\nif((i__4532__auto___29967 \x3c len__4531__auto___29966)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___29967]));\n\nvar G__29968 \x3d (i__4532__auto___29967 + (1));\ni__4532__auto___29967 \x3d G__29968;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nreturn (1);\n});\n\ncljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn x;\n});\n\ncljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x * y);\n});\n\ncljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,(x * y),more);\n});\n\n/** @this {Function} */\ncljs.core._STAR_.cljs$lang$applyTo \x3d (function (seq29961){\nvar G__29962 \x3d cljs.core.first(seq29961);\nvar seq29961__$1 \x3d cljs.core.next(seq29961);\nvar G__29963 \x3d cljs.core.first(seq29961__$1);\nvar seq29961__$2 \x3d cljs.core.next(seq29961__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29962,G__29963,seq29961__$2);\n});\n\ncljs.core._STAR_.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * If no denominators are supplied, returns 1/numerator,\n *   else returns numerator divided by all of the denominators.\n */\ncljs.core._SLASH_ \x3d (function cljs$core$_SLASH_(var_args){\nvar G__29973 \x3d arguments.length;\nswitch (G__29973) {\ncase 1:\nreturn cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___29975 \x3d arguments.length;\nvar i__4532__auto___29976 \x3d (0);\nwhile(true){\nif((i__4532__auto___29976 \x3c len__4531__auto___29975)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___29976]));\n\nvar G__29977 \x3d (i__4532__auto___29976 + (1));\ni__4532__auto___29976 \x3d G__29977;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn ((1) / x);\n});\n\ncljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x / y);\n});\n\ncljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(x / y),more);\n});\n\n/** @this {Function} */\ncljs.core._SLASH_.cljs$lang$applyTo \x3d (function (seq29970){\nvar G__29971 \x3d cljs.core.first(seq29970);\nvar seq29970__$1 \x3d cljs.core.next(seq29970);\nvar G__29972 \x3d cljs.core.first(seq29970__$1);\nvar seq29970__$2 \x3d cljs.core.next(seq29970__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29971,G__29972,seq29970__$2);\n});\n\ncljs.core._SLASH_.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * Returns non-nil if nums are in monotonically increasing order,\n *   otherwise false.\n */\ncljs.core._LT_ \x3d (function cljs$core$_LT_(var_args){\nvar G__29982 \x3d arguments.length;\nswitch (G__29982) {\ncase 1:\nreturn cljs.core._LT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core._LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___29984 \x3d arguments.length;\nvar i__4532__auto___29985 \x3d (0);\nwhile(true){\nif((i__4532__auto___29985 \x3c len__4531__auto___29984)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___29985]));\n\nvar G__29986 \x3d (i__4532__auto___29985 + (1));\ni__4532__auto___29985 \x3d G__29986;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core._LT_.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn true;\n});\n\ncljs.core._LT_.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x \x3c y);\n});\n\ncljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nwhile(true){\nif((x \x3c y)){\nif(cljs.core.next(more)){\nvar G__29987 \x3d y;\nvar G__29988 \x3d cljs.core.first(more);\nvar G__29989 \x3d cljs.core.next(more);\nx \x3d G__29987;\ny \x3d G__29988;\nmore \x3d G__29989;\ncontinue;\n} else {\nreturn (y \x3c cljs.core.first(more));\n}\n} else {\nreturn false;\n}\nbreak;\n}\n});\n\n/** @this {Function} */\ncljs.core._LT_.cljs$lang$applyTo \x3d (function (seq29979){\nvar G__29980 \x3d cljs.core.first(seq29979);\nvar seq29979__$1 \x3d cljs.core.next(seq29979);\nvar G__29981 \x3d cljs.core.first(seq29979__$1);\nvar seq29979__$2 \x3d cljs.core.next(seq29979__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29980,G__29981,seq29979__$2);\n});\n\ncljs.core._LT_.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * Returns non-nil if nums are in monotonically non-decreasing order,\n *   otherwise false.\n */\ncljs.core._LT__EQ_ \x3d (function cljs$core$_LT__EQ_(var_args){\nvar G__29994 \x3d arguments.length;\nswitch (G__29994) {\ncase 1:\nreturn cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___29996 \x3d arguments.length;\nvar i__4532__auto___29997 \x3d (0);\nwhile(true){\nif((i__4532__auto___29997 \x3c len__4531__auto___29996)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___29997]));\n\nvar G__29998 \x3d (i__4532__auto___29997 + (1));\ni__4532__auto___29997 \x3d G__29998;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn true;\n});\n\ncljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x \x3c\x3d y);\n});\n\ncljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nwhile(true){\nif((x \x3c\x3d y)){\nif(cljs.core.next(more)){\nvar G__29999 \x3d y;\nvar G__30000 \x3d cljs.core.first(more);\nvar G__30001 \x3d cljs.core.next(more);\nx \x3d G__29999;\ny \x3d G__30000;\nmore \x3d G__30001;\ncontinue;\n} else {\nreturn (y \x3c\x3d cljs.core.first(more));\n}\n} else {\nreturn false;\n}\nbreak;\n}\n});\n\n/** @this {Function} */\ncljs.core._LT__EQ_.cljs$lang$applyTo \x3d (function (seq29991){\nvar G__29992 \x3d cljs.core.first(seq29991);\nvar seq29991__$1 \x3d cljs.core.next(seq29991);\nvar G__29993 \x3d cljs.core.first(seq29991__$1);\nvar seq29991__$2 \x3d cljs.core.next(seq29991__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29992,G__29993,seq29991__$2);\n});\n\ncljs.core._LT__EQ_.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * Returns non-nil if nums are in monotonically decreasing order,\n *   otherwise false.\n */\ncljs.core._GT_ \x3d (function cljs$core$_GT_(var_args){\nvar G__30006 \x3d arguments.length;\nswitch (G__30006) {\ncase 1:\nreturn cljs.core._GT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core._GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___30008 \x3d arguments.length;\nvar i__4532__auto___30009 \x3d (0);\nwhile(true){\nif((i__4532__auto___30009 \x3c len__4531__auto___30008)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___30009]));\n\nvar G__30010 \x3d (i__4532__auto___30009 + (1));\ni__4532__auto___30009 \x3d G__30010;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core._GT_.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn true;\n});\n\ncljs.core._GT_.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x \x3e y);\n});\n\ncljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nwhile(true){\nif((x \x3e y)){\nif(cljs.core.next(more)){\nvar G__30011 \x3d y;\nvar G__30012 \x3d cljs.core.first(more);\nvar G__30013 \x3d cljs.core.next(more);\nx \x3d G__30011;\ny \x3d G__30012;\nmore \x3d G__30013;\ncontinue;\n} else {\nreturn (y \x3e cljs.core.first(more));\n}\n} else {\nreturn false;\n}\nbreak;\n}\n});\n\n/** @this {Function} */\ncljs.core._GT_.cljs$lang$applyTo \x3d (function (seq30003){\nvar G__30004 \x3d cljs.core.first(seq30003);\nvar seq30003__$1 \x3d cljs.core.next(seq30003);\nvar G__30005 \x3d cljs.core.first(seq30003__$1);\nvar seq30003__$2 \x3d cljs.core.next(seq30003__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30004,G__30005,seq30003__$2);\n});\n\ncljs.core._GT_.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * Returns non-nil if nums are in monotonically non-increasing order,\n *   otherwise false.\n */\ncljs.core._GT__EQ_ \x3d (function cljs$core$_GT__EQ_(var_args){\nvar G__30018 \x3d arguments.length;\nswitch (G__30018) {\ncase 1:\nreturn cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___30020 \x3d arguments.length;\nvar i__4532__auto___30021 \x3d (0);\nwhile(true){\nif((i__4532__auto___30021 \x3c len__4531__auto___30020)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___30021]));\n\nvar G__30022 \x3d (i__4532__auto___30021 + (1));\ni__4532__auto___30021 \x3d G__30022;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn true;\n});\n\ncljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x \x3e\x3d y);\n});\n\ncljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nwhile(true){\nif((x \x3e\x3d y)){\nif(cljs.core.next(more)){\nvar G__30023 \x3d y;\nvar G__30024 \x3d cljs.core.first(more);\nvar G__30025 \x3d cljs.core.next(more);\nx \x3d G__30023;\ny \x3d G__30024;\nmore \x3d G__30025;\ncontinue;\n} else {\nreturn (y \x3e\x3d cljs.core.first(more));\n}\n} else {\nreturn false;\n}\nbreak;\n}\n});\n\n/** @this {Function} */\ncljs.core._GT__EQ_.cljs$lang$applyTo \x3d (function (seq30015){\nvar G__30016 \x3d cljs.core.first(seq30015);\nvar seq30015__$1 \x3d cljs.core.next(seq30015);\nvar G__30017 \x3d cljs.core.first(seq30015__$1);\nvar seq30015__$2 \x3d cljs.core.next(seq30015__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30016,G__30017,seq30015__$2);\n});\n\ncljs.core._GT__EQ_.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * Returns a number one less than num.\n */\ncljs.core.dec \x3d (function cljs$core$dec(x){\nreturn (x - (1));\n});\n/**\n * Returns the greatest of the nums.\n */\ncljs.core.max \x3d (function cljs$core$max(var_args){\nvar G__30030 \x3d arguments.length;\nswitch (G__30030) {\ncase 1:\nreturn cljs.core.max.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.max.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___30032 \x3d arguments.length;\nvar i__4532__auto___30033 \x3d (0);\nwhile(true){\nif((i__4532__auto___30033 \x3c len__4531__auto___30032)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___30033]));\n\nvar G__30034 \x3d (i__4532__auto___30033 + (1));\ni__4532__auto___30033 \x3d G__30034;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.max.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn x;\n});\n\ncljs.core.max.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nvar x__4037__auto__ \x3d x;\nvar y__4038__auto__ \x3d y;\nreturn ((x__4037__auto__ \x3e y__4038__auto__) ? x__4037__auto__ : y__4038__auto__);\n});\n\ncljs.core.max.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(function (){var x__4037__auto__ \x3d x;\nvar y__4038__auto__ \x3d y;\nreturn ((x__4037__auto__ \x3e y__4038__auto__) ? x__4037__auto__ : y__4038__auto__);\n})(),more);\n});\n\n/** @this {Function} */\ncljs.core.max.cljs$lang$applyTo \x3d (function (seq30027){\nvar G__30028 \x3d cljs.core.first(seq30027);\nvar seq30027__$1 \x3d cljs.core.next(seq30027);\nvar G__30029 \x3d cljs.core.first(seq30027__$1);\nvar seq30027__$2 \x3d cljs.core.next(seq30027__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30028,G__30029,seq30027__$2);\n});\n\ncljs.core.max.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * Returns the least of the nums.\n */\ncljs.core.min \x3d (function cljs$core$min(var_args){\nvar G__30039 \x3d arguments.length;\nswitch (G__30039) {\ncase 1:\nreturn cljs.core.min.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.min.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___30041 \x3d arguments.length;\nvar i__4532__auto___30042 \x3d (0);\nwhile(true){\nif((i__4532__auto___30042 \x3c len__4531__auto___30041)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___30042]));\n\nvar G__30043 \x3d (i__4532__auto___30042 + (1));\ni__4532__auto___30042 \x3d G__30043;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.min.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn x;\n});\n\ncljs.core.min.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nvar x__4040__auto__ \x3d x;\nvar y__4041__auto__ \x3d y;\nreturn ((x__4040__auto__ \x3c y__4041__auto__) ? x__4040__auto__ : y__4041__auto__);\n});\n\ncljs.core.min.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min,(function (){var x__4040__auto__ \x3d x;\nvar y__4041__auto__ \x3d y;\nreturn ((x__4040__auto__ \x3c y__4041__auto__) ? x__4040__auto__ : y__4041__auto__);\n})(),more);\n});\n\n/** @this {Function} */\ncljs.core.min.cljs$lang$applyTo \x3d (function (seq30036){\nvar G__30037 \x3d cljs.core.first(seq30036);\nvar seq30036__$1 \x3d cljs.core.next(seq30036);\nvar G__30038 \x3d cljs.core.first(seq30036__$1);\nvar seq30036__$2 \x3d cljs.core.next(seq30036__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30037,G__30038,seq30036__$2);\n});\n\ncljs.core.min.cljs$lang$maxFixedArity \x3d (2);\n\ncljs.core.byte$ \x3d (function cljs$core$byte(x){\nreturn x;\n});\n/**\n * Coerce to char\n */\ncljs.core.char$ \x3d (function cljs$core$char(x){\nif(typeof x \x3d\x3d\x3d \x27number\x27){\nreturn String.fromCharCode(x);\n} else {\nif(((typeof x \x3d\x3d\x3d \x27string\x27) \x26\x26 ((x.length \x3d\x3d\x3d (1))))){\nreturn x;\n} else {\nthrow (new Error(\x22Argument to char must be a character or number\x22));\n\n}\n}\n});\ncljs.core.short$ \x3d (function cljs$core$short(x){\nreturn x;\n});\ncljs.core.float$ \x3d (function cljs$core$float(x){\nreturn x;\n});\ncljs.core.double$ \x3d (function cljs$core$double(x){\nreturn x;\n});\ncljs.core.unchecked_byte \x3d (function cljs$core$unchecked_byte(x){\nreturn x;\n});\ncljs.core.unchecked_char \x3d (function cljs$core$unchecked_char(x){\nreturn x;\n});\ncljs.core.unchecked_short \x3d (function cljs$core$unchecked_short(x){\nreturn x;\n});\ncljs.core.unchecked_float \x3d (function cljs$core$unchecked_float(x){\nreturn x;\n});\ncljs.core.unchecked_double \x3d (function cljs$core$unchecked_double(x){\nreturn x;\n});\n/**\n * Returns the sum of nums. (+) returns 0.\n */\ncljs.core.unchecked_add \x3d (function cljs$core$unchecked_add(var_args){\nvar G__30048 \x3d arguments.length;\nswitch (G__30048) {\ncase 0:\nreturn cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();\n\nbreak;\ncase 1:\nreturn cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___30050 \x3d arguments.length;\nvar i__4532__auto___30051 \x3d (0);\nwhile(true){\nif((i__4532__auto___30051 \x3c len__4531__auto___30050)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___30051]));\n\nvar G__30052 \x3d (i__4532__auto___30051 + (1));\ni__4532__auto___30051 \x3d G__30052;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nreturn (0);\n});\n\ncljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn x;\n});\n\ncljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x + y);\n});\n\ncljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add,(x + y),more);\n});\n\n/** @this {Function} */\ncljs.core.unchecked_add.cljs$lang$applyTo \x3d (function (seq30045){\nvar G__30046 \x3d cljs.core.first(seq30045);\nvar seq30045__$1 \x3d cljs.core.next(seq30045);\nvar G__30047 \x3d cljs.core.first(seq30045__$1);\nvar seq30045__$2 \x3d cljs.core.next(seq30045__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30046,G__30047,seq30045__$2);\n});\n\ncljs.core.unchecked_add.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * Returns the sum of nums. (+) returns 0.\n */\ncljs.core.unchecked_add_int \x3d (function cljs$core$unchecked_add_int(var_args){\nvar G__30057 \x3d arguments.length;\nswitch (G__30057) {\ncase 0:\nreturn cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();\n\nbreak;\ncase 1:\nreturn cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___30059 \x3d arguments.length;\nvar i__4532__auto___30060 \x3d (0);\nwhile(true){\nif((i__4532__auto___30060 \x3c len__4531__auto___30059)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___30060]));\n\nvar G__30061 \x3d (i__4532__auto___30060 + (1));\ni__4532__auto___30060 \x3d G__30061;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nreturn (0);\n});\n\ncljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn x;\n});\n\ncljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x + y);\n});\n\ncljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int,(x + y),more);\n});\n\n/** @this {Function} */\ncljs.core.unchecked_add_int.cljs$lang$applyTo \x3d (function (seq30054){\nvar G__30055 \x3d cljs.core.first(seq30054);\nvar seq30054__$1 \x3d cljs.core.next(seq30054);\nvar G__30056 \x3d cljs.core.first(seq30054__$1);\nvar seq30054__$2 \x3d cljs.core.next(seq30054__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30055,G__30056,seq30054__$2);\n});\n\ncljs.core.unchecked_add_int.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * Returns a number one less than x, an int.\n */\ncljs.core.unchecked_dec \x3d (function cljs$core$unchecked_dec(x){\nreturn (x - (1));\n});\n/**\n * Returns a number one less than x, an int.\n */\ncljs.core.unchecked_dec_int \x3d (function cljs$core$unchecked_dec_int(x){\nreturn (x - (1));\n});\n/**\n * If no denominators are supplied, returns 1/numerator,\n *   else returns numerator divided by all of the denominators.\n */\ncljs.core.unchecked_divide_int \x3d (function cljs$core$unchecked_divide_int(var_args){\nvar G__30066 \x3d arguments.length;\nswitch (G__30066) {\ncase 1:\nreturn cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___30068 \x3d arguments.length;\nvar i__4532__auto___30069 \x3d (0);\nwhile(true){\nif((i__4532__auto___30069 \x3c len__4531__auto___30068)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___30069]));\n\nvar G__30070 \x3d (i__4532__auto___30069 + (1));\ni__4532__auto___30069 \x3d G__30070;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn ((1) / x);\n});\n\ncljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x / y);\n});\n\ncljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int,(x / y),more);\n});\n\n/** @this {Function} */\ncljs.core.unchecked_divide_int.cljs$lang$applyTo \x3d (function (seq30063){\nvar G__30064 \x3d cljs.core.first(seq30063);\nvar seq30063__$1 \x3d cljs.core.next(seq30063);\nvar G__30065 \x3d cljs.core.first(seq30063__$1);\nvar seq30063__$2 \x3d cljs.core.next(seq30063__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30064,G__30065,seq30063__$2);\n});\n\ncljs.core.unchecked_divide_int.cljs$lang$maxFixedArity \x3d (2);\n\ncljs.core.unchecked_inc \x3d (function cljs$core$unchecked_inc(x){\nreturn (x + (1));\n});\ncljs.core.unchecked_inc_int \x3d (function cljs$core$unchecked_inc_int(x){\nreturn (x + (1));\n});\n/**\n * Returns the product of nums. (*) returns 1.\n */\ncljs.core.unchecked_multiply \x3d (function cljs$core$unchecked_multiply(var_args){\nvar G__30075 \x3d arguments.length;\nswitch (G__30075) {\ncase 0:\nreturn cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();\n\nbreak;\ncase 1:\nreturn cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___30077 \x3d arguments.length;\nvar i__4532__auto___30078 \x3d (0);\nwhile(true){\nif((i__4532__auto___30078 \x3c len__4531__auto___30077)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___30078]));\n\nvar G__30079 \x3d (i__4532__auto___30078 + (1));\ni__4532__auto___30078 \x3d G__30079;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nreturn (1);\n});\n\ncljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn x;\n});\n\ncljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x * y);\n});\n\ncljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply,(x * y),more);\n});\n\n/** @this {Function} */\ncljs.core.unchecked_multiply.cljs$lang$applyTo \x3d (function (seq30072){\nvar G__30073 \x3d cljs.core.first(seq30072);\nvar seq30072__$1 \x3d cljs.core.next(seq30072);\nvar G__30074 \x3d cljs.core.first(seq30072__$1);\nvar seq30072__$2 \x3d cljs.core.next(seq30072__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30073,G__30074,seq30072__$2);\n});\n\ncljs.core.unchecked_multiply.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * Returns the product of nums. (*) returns 1.\n */\ncljs.core.unchecked_multiply_int \x3d (function cljs$core$unchecked_multiply_int(var_args){\nvar G__30084 \x3d arguments.length;\nswitch (G__30084) {\ncase 0:\nreturn cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();\n\nbreak;\ncase 1:\nreturn cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___30086 \x3d arguments.length;\nvar i__4532__auto___30087 \x3d (0);\nwhile(true){\nif((i__4532__auto___30087 \x3c len__4531__auto___30086)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___30087]));\n\nvar G__30088 \x3d (i__4532__auto___30087 + (1));\ni__4532__auto___30087 \x3d G__30088;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nreturn (1);\n});\n\ncljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn x;\n});\n\ncljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x * y);\n});\n\ncljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int,(x * y),more);\n});\n\n/** @this {Function} */\ncljs.core.unchecked_multiply_int.cljs$lang$applyTo \x3d (function (seq30081){\nvar G__30082 \x3d cljs.core.first(seq30081);\nvar seq30081__$1 \x3d cljs.core.next(seq30081);\nvar G__30083 \x3d cljs.core.first(seq30081__$1);\nvar seq30081__$2 \x3d cljs.core.next(seq30081__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30082,G__30083,seq30081__$2);\n});\n\ncljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity \x3d (2);\n\ncljs.core.unchecked_negate \x3d (function cljs$core$unchecked_negate(x){\nreturn (- x);\n});\ncljs.core.unchecked_negate_int \x3d (function cljs$core$unchecked_negate_int(x){\nreturn (- x);\n});\ncljs.core.unchecked_remainder_int \x3d (function cljs$core$unchecked_remainder_int(x,n){\nreturn (cljs.core.mod.cljs$core$IFn$_invoke$arity$2 ? cljs.core.mod.cljs$core$IFn$_invoke$arity$2(x,n) : cljs.core.mod.call(null,x,n));\n});\n/**\n * If no ys are supplied, returns the negation of x, else subtracts\n *   the ys from x and returns the result.\n */\ncljs.core.unchecked_subtract \x3d (function cljs$core$unchecked_subtract(var_args){\nvar G__30093 \x3d arguments.length;\nswitch (G__30093) {\ncase 1:\nreturn cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___30095 \x3d arguments.length;\nvar i__4532__auto___30096 \x3d (0);\nwhile(true){\nif((i__4532__auto___30096 \x3c len__4531__auto___30095)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___30096]));\n\nvar G__30097 \x3d (i__4532__auto___30096 + (1));\ni__4532__auto___30096 \x3d G__30097;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn (- x);\n});\n\ncljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x - y);\n});\n\ncljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract,(x - y),more);\n});\n\n/** @this {Function} */\ncljs.core.unchecked_subtract.cljs$lang$applyTo \x3d (function (seq30090){\nvar G__30091 \x3d cljs.core.first(seq30090);\nvar seq30090__$1 \x3d cljs.core.next(seq30090);\nvar G__30092 \x3d cljs.core.first(seq30090__$1);\nvar seq30090__$2 \x3d cljs.core.next(seq30090__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30091,G__30092,seq30090__$2);\n});\n\ncljs.core.unchecked_subtract.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * If no ys are supplied, returns the negation of x, else subtracts\n *   the ys from x and returns the result.\n */\ncljs.core.unchecked_subtract_int \x3d (function cljs$core$unchecked_subtract_int(var_args){\nvar G__30102 \x3d arguments.length;\nswitch (G__30102) {\ncase 1:\nreturn cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___30104 \x3d arguments.length;\nvar i__4532__auto___30105 \x3d (0);\nwhile(true){\nif((i__4532__auto___30105 \x3c len__4531__auto___30104)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___30105]));\n\nvar G__30106 \x3d (i__4532__auto___30105 + (1));\ni__4532__auto___30105 \x3d G__30106;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn (- x);\n});\n\ncljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x - y);\n});\n\ncljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int,(x - y),more);\n});\n\n/** @this {Function} */\ncljs.core.unchecked_subtract_int.cljs$lang$applyTo \x3d (function (seq30099){\nvar G__30100 \x3d cljs.core.first(seq30099);\nvar seq30099__$1 \x3d cljs.core.next(seq30099);\nvar G__30101 \x3d cljs.core.first(seq30099__$1);\nvar seq30099__$2 \x3d cljs.core.next(seq30099__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30100,G__30101,seq30099__$2);\n});\n\ncljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity \x3d (2);\n\ncljs.core.fix \x3d (function cljs$core$fix(q){\nif((q \x3e\x3d (0))){\nreturn Math.floor(q);\n} else {\nreturn Math.ceil(q);\n}\n});\n/**\n * Coerce to int by stripping decimal places.\n */\ncljs.core.int$ \x3d (function cljs$core$int(x){\nreturn (x | (0));\n});\n/**\n * Coerce to int by stripping decimal places.\n */\ncljs.core.unchecked_int \x3d (function cljs$core$unchecked_int(x){\nreturn cljs.core.fix(x);\n});\n/**\n * Coerce to long by stripping decimal places. Identical to `int\x27.\n */\ncljs.core.long$ \x3d (function cljs$core$long(x){\nreturn cljs.core.fix(x);\n});\n/**\n * Coerce to long by stripping decimal places. Identical to `int\x27.\n */\ncljs.core.unchecked_long \x3d (function cljs$core$unchecked_long(x){\nreturn cljs.core.fix(x);\n});\ncljs.core.booleans \x3d (function cljs$core$booleans(x){\nreturn x;\n});\ncljs.core.bytes \x3d (function cljs$core$bytes(x){\nreturn x;\n});\ncljs.core.chars \x3d (function cljs$core$chars(x){\nreturn x;\n});\ncljs.core.shorts \x3d (function cljs$core$shorts(x){\nreturn x;\n});\ncljs.core.ints \x3d (function cljs$core$ints(x){\nreturn x;\n});\ncljs.core.floats \x3d (function cljs$core$floats(x){\nreturn x;\n});\ncljs.core.doubles \x3d (function cljs$core$doubles(x){\nreturn x;\n});\ncljs.core.longs \x3d (function cljs$core$longs(x){\nreturn x;\n});\n/**\n * Modulus of num and div with original javascript behavior. i.e. bug for negative numbers\n */\ncljs.core.js_mod \x3d (function cljs$core$js_mod(n,d){\nreturn (n % d);\n});\n/**\n * Modulus of num and div. Truncates toward negative infinity.\n */\ncljs.core.mod \x3d (function cljs$core$mod(n,d){\nreturn (((n % d) + d) % d);\n});\n/**\n * quot[ient] of dividing numerator by denominator.\n */\ncljs.core.quot \x3d (function cljs$core$quot(n,d){\nvar rem \x3d (n % d);\nreturn cljs.core.fix(((n - rem) / d));\n});\n/**\n * remainder of dividing numerator by denominator.\n */\ncljs.core.rem \x3d (function cljs$core$rem(n,d){\nvar q \x3d cljs.core.quot(n,d);\nreturn (n - (d * q));\n});\n/**\n * Bitwise exclusive or\n */\ncljs.core.bit_xor \x3d (function cljs$core$bit_xor(var_args){\nvar G__30111 \x3d arguments.length;\nswitch (G__30111) {\ncase 2:\nreturn cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___30113 \x3d arguments.length;\nvar i__4532__auto___30114 \x3d (0);\nwhile(true){\nif((i__4532__auto___30114 \x3c len__4531__auto___30113)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___30114]));\n\nvar G__30115 \x3d (i__4532__auto___30114 + (1));\ni__4532__auto___30114 \x3d G__30115;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x ^ y);\n});\n\ncljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor,(x ^ y),more);\n});\n\n/** @this {Function} */\ncljs.core.bit_xor.cljs$lang$applyTo \x3d (function (seq30108){\nvar G__30109 \x3d cljs.core.first(seq30108);\nvar seq30108__$1 \x3d cljs.core.next(seq30108);\nvar G__30110 \x3d cljs.core.first(seq30108__$1);\nvar seq30108__$2 \x3d cljs.core.next(seq30108__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30109,G__30110,seq30108__$2);\n});\n\ncljs.core.bit_xor.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * Bitwise and\n */\ncljs.core.bit_and \x3d (function cljs$core$bit_and(var_args){\nvar G__30120 \x3d arguments.length;\nswitch (G__30120) {\ncase 2:\nreturn cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___30122 \x3d arguments.length;\nvar i__4532__auto___30123 \x3d (0);\nwhile(true){\nif((i__4532__auto___30123 \x3c len__4531__auto___30122)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___30123]));\n\nvar G__30124 \x3d (i__4532__auto___30123 + (1));\ni__4532__auto___30123 \x3d G__30124;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x \x26 y);\n});\n\ncljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and,(x \x26 y),more);\n});\n\n/** @this {Function} */\ncljs.core.bit_and.cljs$lang$applyTo \x3d (function (seq30117){\nvar G__30118 \x3d cljs.core.first(seq30117);\nvar seq30117__$1 \x3d cljs.core.next(seq30117);\nvar G__30119 \x3d cljs.core.first(seq30117__$1);\nvar seq30117__$2 \x3d cljs.core.next(seq30117__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30118,G__30119,seq30117__$2);\n});\n\ncljs.core.bit_and.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * Bitwise or\n */\ncljs.core.bit_or \x3d (function cljs$core$bit_or(var_args){\nvar G__30129 \x3d arguments.length;\nswitch (G__30129) {\ncase 2:\nreturn cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___30131 \x3d arguments.length;\nvar i__4532__auto___30132 \x3d (0);\nwhile(true){\nif((i__4532__auto___30132 \x3c len__4531__auto___30131)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___30132]));\n\nvar G__30133 \x3d (i__4532__auto___30132 + (1));\ni__4532__auto___30132 \x3d G__30133;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x | y);\n});\n\ncljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or,(x | y),more);\n});\n\n/** @this {Function} */\ncljs.core.bit_or.cljs$lang$applyTo \x3d (function (seq30126){\nvar G__30127 \x3d cljs.core.first(seq30126);\nvar seq30126__$1 \x3d cljs.core.next(seq30126);\nvar G__30128 \x3d cljs.core.first(seq30126__$1);\nvar seq30126__$2 \x3d cljs.core.next(seq30126__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30127,G__30128,seq30126__$2);\n});\n\ncljs.core.bit_or.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * Bitwise and with complement\n */\ncljs.core.bit_and_not \x3d (function cljs$core$bit_and_not(var_args){\nvar G__30138 \x3d arguments.length;\nswitch (G__30138) {\ncase 2:\nreturn cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___30140 \x3d arguments.length;\nvar i__4532__auto___30141 \x3d (0);\nwhile(true){\nif((i__4532__auto___30141 \x3c len__4531__auto___30140)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___30141]));\n\nvar G__30142 \x3d (i__4532__auto___30141 + (1));\ni__4532__auto___30141 \x3d G__30142;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (x \x26 ~y);\n});\n\ncljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not,(x \x26 ~y),more);\n});\n\n/** @this {Function} */\ncljs.core.bit_and_not.cljs$lang$applyTo \x3d (function (seq30135){\nvar G__30136 \x3d cljs.core.first(seq30135);\nvar seq30135__$1 \x3d cljs.core.next(seq30135);\nvar G__30137 \x3d cljs.core.first(seq30135__$1);\nvar seq30135__$2 \x3d cljs.core.next(seq30135__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30136,G__30137,seq30135__$2);\n});\n\ncljs.core.bit_and_not.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * Clear bit at index n\n */\ncljs.core.bit_clear \x3d (function cljs$core$bit_clear(x,n){\nreturn (x \x26 ~(1 \x3c\x3c n));\n});\n/**\n * Flip bit at index n\n */\ncljs.core.bit_flip \x3d (function cljs$core$bit_flip(x,n){\nreturn (x ^ (1 \x3c\x3c n));\n});\n/**\n * Bitwise complement\n */\ncljs.core.bit_not \x3d (function cljs$core$bit_not(x){\nreturn (~ x);\n});\n/**\n * Set bit at index n\n */\ncljs.core.bit_set \x3d (function cljs$core$bit_set(x,n){\nreturn (x | (1 \x3c\x3c n));\n});\n/**\n * Test bit at index n\n */\ncljs.core.bit_test \x3d (function cljs$core$bit_test(x,n){\nreturn ((x \x26 (1 \x3c\x3c n)) !\x3d 0);\n});\n/**\n * Bitwise shift left\n */\ncljs.core.bit_shift_left \x3d (function cljs$core$bit_shift_left(x,n){\nreturn (x \x3c\x3c n);\n});\n/**\n * Bitwise shift right\n */\ncljs.core.bit_shift_right \x3d (function cljs$core$bit_shift_right(x,n){\nreturn (x \x3e\x3e n);\n});\n/**\n * DEPRECATED: Bitwise shift right with zero fill\n */\ncljs.core.bit_shift_right_zero_fill \x3d (function cljs$core$bit_shift_right_zero_fill(x,n){\nreturn (x \x3e\x3e\x3e n);\n});\n/**\n * Bitwise shift right with zero fill\n */\ncljs.core.unsigned_bit_shift_right \x3d (function cljs$core$unsigned_bit_shift_right(x,n){\nreturn (x \x3e\x3e\x3e n);\n});\n/**\n * Counts the number of bits set in n\n */\ncljs.core.bit_count \x3d (function cljs$core$bit_count(v){\nvar v__$1 \x3d (v - ((v \x3e\x3e (1)) \x26 (1431655765)));\nvar v__$2 \x3d ((v__$1 \x26 (858993459)) + ((v__$1 \x3e\x3e (2)) \x26 (858993459)));\nreturn ((((v__$2 + (v__$2 \x3e\x3e (4))) \x26 (252645135)) * (16843009)) \x3e\x3e (24));\n});\n/**\n * Returns non-nil if nums all have the equivalent\n *   value, otherwise false. Behavior on non nums is\n *   undefined.\n */\ncljs.core._EQ__EQ_ \x3d (function cljs$core$_EQ__EQ_(var_args){\nvar G__30147 \x3d arguments.length;\nswitch (G__30147) {\ncase 1:\nreturn cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___30149 \x3d arguments.length;\nvar i__4532__auto___30150 \x3d (0);\nwhile(true){\nif((i__4532__auto___30150 \x3c len__4531__auto___30149)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___30150]));\n\nvar G__30151 \x3d (i__4532__auto___30150 + (1));\ni__4532__auto___30150 \x3d G__30151;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn true;\n});\n\ncljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn cljs.core._equiv(x,y);\n});\n\ncljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,more){\nwhile(true){\nif((x \x3d\x3d\x3d y)){\nif(cljs.core.next(more)){\nvar G__30152 \x3d y;\nvar G__30153 \x3d cljs.core.first(more);\nvar G__30154 \x3d cljs.core.next(more);\nx \x3d G__30152;\ny \x3d G__30153;\nmore \x3d G__30154;\ncontinue;\n} else {\nreturn (y \x3d\x3d\x3d cljs.core.first(more));\n}\n} else {\nreturn false;\n}\nbreak;\n}\n});\n\n/** @this {Function} */\ncljs.core._EQ__EQ_.cljs$lang$applyTo \x3d (function (seq30144){\nvar G__30145 \x3d cljs.core.first(seq30144);\nvar seq30144__$1 \x3d cljs.core.next(seq30144);\nvar G__30146 \x3d cljs.core.first(seq30144__$1);\nvar seq30144__$2 \x3d cljs.core.next(seq30144__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30145,G__30146,seq30144__$2);\n});\n\ncljs.core._EQ__EQ_.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * Returns true if num is greater than zero, else false\n */\ncljs.core.pos_QMARK_ \x3d (function cljs$core$pos_QMARK_(x){\nreturn (x \x3e (0));\n});\n/**\n * Returns true if num is zero, else false\n */\ncljs.core.zero_QMARK_ \x3d (function cljs$core$zero_QMARK_(x){\nreturn (x \x3d\x3d\x3d (0));\n});\n/**\n * Returns true if num is less than zero, else false\n */\ncljs.core.neg_QMARK_ \x3d (function cljs$core$neg_QMARK_(x){\nreturn (x \x3c (0));\n});\n/**\n * Returns the nth next of coll, (seq coll) when n is 0.\n */\ncljs.core.nthnext \x3d (function cljs$core$nthnext(coll,n){\nvar n__$1 \x3d n;\nvar xs \x3d cljs.core.seq(coll);\nwhile(true){\nif(((xs) \x26\x26 ((n__$1 \x3e (0))))){\nvar G__30155 \x3d (n__$1 - (1));\nvar G__30156 \x3d cljs.core.next(xs);\nn__$1 \x3d G__30155;\nxs \x3d G__30156;\ncontinue;\n} else {\nreturn xs;\n}\nbreak;\n}\n});\n/**\n * With no args, returns the empty string. With one arg x, returns\n *   x.toString().  (str nil) returns the empty string. With more than\n *   one arg, returns the concatenation of the str values of the args.\n */\ncljs.core.str \x3d (function cljs$core$str(var_args){\nvar G__30160 \x3d arguments.length;\nswitch (G__30160) {\ncase 0:\nreturn cljs.core.str.cljs$core$IFn$_invoke$arity$0();\n\nbreak;\ncase 1:\nreturn cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___30162 \x3d arguments.length;\nvar i__4532__auto___30163 \x3d (0);\nwhile(true){\nif((i__4532__auto___30163 \x3c len__4531__auto___30162)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___30163]));\n\nvar G__30164 \x3d (i__4532__auto___30163 + (1));\ni__4532__auto___30163 \x3d G__30164;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((1)),(0),null));\nreturn cljs.core.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.str.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nreturn \x22\x22;\n});\n\ncljs.core.str.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nif((x \x3d\x3d null)){\nreturn \x22\x22;\n} else {\nreturn [x].join(\x22\x22);\n}\n});\n\ncljs.core.str.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,ys){\nvar sb \x3d (new goog.string.StringBuffer([cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(\x27\x27)));\nvar more \x3d ys;\nwhile(true){\nif(cljs.core.truth_(more)){\nvar G__30165 \x3d sb.append([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(more))].join(\x27\x27));\nvar G__30166 \x3d cljs.core.next(more);\nsb \x3d G__30165;\nmore \x3d G__30166;\ncontinue;\n} else {\nreturn sb.toString();\n}\nbreak;\n}\n});\n\n/** @this {Function} */\ncljs.core.str.cljs$lang$applyTo \x3d (function (seq30158){\nvar G__30159 \x3d cljs.core.first(seq30158);\nvar seq30158__$1 \x3d cljs.core.next(seq30158);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30159,seq30158__$1);\n});\n\ncljs.core.str.cljs$lang$maxFixedArity \x3d (1);\n\n/**\n * Returns the substring of s beginning at start inclusive, and ending\n *   at end (defaults to length of string), exclusive.\n */\ncljs.core.subs \x3d (function cljs$core$subs(var_args){\nvar G__30168 \x3d arguments.length;\nswitch (G__30168) {\ncase 2:\nreturn cljs.core.subs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.subs.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core.subs.cljs$core$IFn$_invoke$arity$2 \x3d (function (s,start){\nreturn s.substring(start);\n});\n\ncljs.core.subs.cljs$core$IFn$_invoke$arity$3 \x3d (function (s,start,end){\nreturn s.substring(start,end);\n});\n\ncljs.core.subs.cljs$lang$maxFixedArity \x3d 3;\n\n\n/**\n * Assumes x is sequential. Returns true if x equals y, otherwise\n *   returns false.\n */\ncljs.core.equiv_sequential \x3d (function cljs$core$equiv_sequential(x,y){\nreturn cljs.core.boolean$(((cljs.core.sequential_QMARK_(y))?((((cljs.core.counted_QMARK_(x)) \x26\x26 (cljs.core.counted_QMARK_(y)) \x26\x26 (!((cljs.core.count(x) \x3d\x3d\x3d cljs.core.count(y))))))?false:(function (){var xs \x3d cljs.core.seq(x);\nvar ys \x3d cljs.core.seq(y);\nwhile(true){\nif((xs \x3d\x3d null)){\nreturn (ys \x3d\x3d null);\n} else {\nif((ys \x3d\x3d null)){\nreturn false;\n} else {\nif(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs),cljs.core.first(ys))){\nvar G__30170 \x3d cljs.core.next(xs);\nvar G__30171 \x3d cljs.core.next(ys);\nxs \x3d G__30170;\nys \x3d G__30171;\ncontinue;\n} else {\nreturn false;\n\n}\n}\n}\nbreak;\n}\n})()):null));\n});\ncljs.core.hash_coll \x3d (function cljs$core$hash_coll(coll){\nif(cljs.core.seq(coll)){\nvar res \x3d cljs.core.hash(cljs.core.first(coll));\nvar s \x3d cljs.core.next(coll);\nwhile(true){\nif((s \x3d\x3d null)){\nreturn res;\n} else {\nvar G__30172 \x3d cljs.core.hash_combine(res,cljs.core.hash(cljs.core.first(s)));\nvar G__30173 \x3d cljs.core.next(s);\nres \x3d G__30172;\ns \x3d G__30173;\ncontinue;\n}\nbreak;\n}\n} else {\nreturn (0);\n}\n});\n\ncljs.core.hash_imap \x3d (function cljs$core$hash_imap(m){\nvar h \x3d (0);\nvar s \x3d cljs.core.seq(m);\nwhile(true){\nif(s){\nvar e \x3d cljs.core.first(s);\nvar G__30174 \x3d ((h + (cljs.core.hash((cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null,e))) ^ cljs.core.hash((cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null,e))))) % (4503599627370496));\nvar G__30175 \x3d cljs.core.next(s);\nh \x3d G__30174;\ns \x3d G__30175;\ncontinue;\n} else {\nreturn h;\n}\nbreak;\n}\n});\ncljs.core.hash_iset \x3d (function cljs$core$hash_iset(s){\nvar h \x3d (0);\nvar s__$1 \x3d cljs.core.seq(s);\nwhile(true){\nif(s__$1){\nvar e \x3d cljs.core.first(s__$1);\nvar G__30176 \x3d ((h + cljs.core.hash(e)) % (4503599627370496));\nvar G__30177 \x3d cljs.core.next(s__$1);\nh \x3d G__30176;\ns__$1 \x3d G__30177;\ncontinue;\n} else {\nreturn h;\n}\nbreak;\n}\n});\n\n\n/**\n * Takes a JavaScript object and a map of names to functions and\n *   attaches said functions as methods on the object.  Any references to\n *   JavaScript\x27s implicit this (via the this-as macro) will resolve to the\n *   object that the function is attached.\n */\ncljs.core.extend_object_BANG_ \x3d (function cljs$core$extend_object_BANG_(obj,fn_map){\nvar seq__30178_30188 \x3d cljs.core.seq(fn_map);\nvar chunk__30179_30189 \x3d null;\nvar count__30180_30190 \x3d (0);\nvar i__30181_30191 \x3d (0);\nwhile(true){\nif((i__30181_30191 \x3c count__30180_30190)){\nvar vec__30182_30192 \x3d chunk__30179_30189.cljs$core$IIndexed$_nth$arity$2(null,i__30181_30191);\nvar key_name_30193 \x3d cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30182_30192,(0),null);\nvar f_30194 \x3d cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30182_30192,(1),null);\nvar str_name_30195 \x3d (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(key_name_30193) : cljs.core.name.call(null,key_name_30193));\ngoog.object.set(obj,str_name_30195,f_30194);\n\n\nvar G__30196 \x3d seq__30178_30188;\nvar G__30197 \x3d chunk__30179_30189;\nvar G__30198 \x3d count__30180_30190;\nvar G__30199 \x3d (i__30181_30191 + (1));\nseq__30178_30188 \x3d G__30196;\nchunk__30179_30189 \x3d G__30197;\ncount__30180_30190 \x3d G__30198;\ni__30181_30191 \x3d G__30199;\ncontinue;\n} else {\nvar temp__5457__auto___30200 \x3d cljs.core.seq(seq__30178_30188);\nif(temp__5457__auto___30200){\nvar seq__30178_30201__$1 \x3d temp__5457__auto___30200;\nif(cljs.core.chunked_seq_QMARK_(seq__30178_30201__$1)){\nvar c__4351__auto___30202 \x3d (cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1(seq__30178_30201__$1) : cljs.core.chunk_first.call(null,seq__30178_30201__$1));\nvar G__30203 \x3d (cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1(seq__30178_30201__$1) : cljs.core.chunk_rest.call(null,seq__30178_30201__$1));\nvar G__30204 \x3d c__4351__auto___30202;\nvar G__30205 \x3d cljs.core.count(c__4351__auto___30202);\nvar G__30206 \x3d (0);\nseq__30178_30188 \x3d G__30203;\nchunk__30179_30189 \x3d G__30204;\ncount__30180_30190 \x3d G__30205;\ni__30181_30191 \x3d G__30206;\ncontinue;\n} else {\nvar vec__30185_30207 \x3d cljs.core.first(seq__30178_30201__$1);\nvar key_name_30208 \x3d cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30185_30207,(0),null);\nvar f_30209 \x3d cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30185_30207,(1),null);\nvar str_name_30210 \x3d (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(key_name_30208) : cljs.core.name.call(null,key_name_30208));\ngoog.object.set(obj,str_name_30210,f_30209);\n\n\nvar G__30211 \x3d cljs.core.next(seq__30178_30201__$1);\nvar G__30212 \x3d null;\nvar G__30213 \x3d (0);\nvar G__30214 \x3d (0);\nseq__30178_30188 \x3d G__30211;\nchunk__30179_30189 \x3d G__30212;\ncount__30180_30190 \x3d G__30213;\ni__30181_30191 \x3d G__30214;\ncontinue;\n}\n} else {\n}\n}\nbreak;\n}\n\nreturn obj;\n});\n\n/**\n* @constructor\n * @implements {cljs.core.IList}\n * @implements {cljs.core.IEquiv}\n * @implements {cljs.core.IHash}\n * @implements {cljs.core.ASeq}\n * @implements {cljs.core.ICollection}\n * @implements {cljs.core.IEmptyableCollection}\n * @implements {cljs.core.ICounted}\n * @implements {cljs.core.ISeq}\n * @implements {cljs.core.INext}\n * @implements {cljs.core.ISeqable}\n * @implements {cljs.core.IMeta}\n * @implements {cljs.core.ICloneable}\n * @implements {cljs.core.IStack}\n * @implements {cljs.core.ISequential}\n * @implements {cljs.core.IWithMeta}\n * @implements {cljs.core.IReduce}\n*/\ncljs.core.List \x3d (function (meta,first,rest,count,__hash){\nthis.meta \x3d meta;\nthis.first \x3d first;\nthis.rest \x3d rest;\nthis.count \x3d count;\nthis.__hash \x3d __hash;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 65937646;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 8192;\n});\ncljs.core.List.prototype.toString \x3d (function (){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core.pr_str_STAR_(coll);\n});\n\ncljs.core.List.prototype.equiv \x3d (function (other){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn this$.cljs$core$IEquiv$_equiv$arity$2(null,other);\n});\n\ncljs.core.List.prototype.indexOf \x3d (function() {\nvar G__30215 \x3d null;\nvar G__30215__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));\n});\nvar G__30215__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__30215 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__30215__1.call(this,x);\ncase 2:\nreturn G__30215__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__30215.cljs$core$IFn$_invoke$arity$1 \x3d G__30215__1;\nG__30215.cljs$core$IFn$_invoke$arity$2 \x3d G__30215__2;\nreturn G__30215;\n})()\n;\n\ncljs.core.List.prototype.lastIndexOf \x3d (function() {\nvar G__30216 \x3d null;\nvar G__30216__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,self__.count);\n});\nvar G__30216__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__30216 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__30216__1.call(this,x);\ncase 2:\nreturn G__30216__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__30216.cljs$core$IFn$_invoke$arity$1 \x3d G__30216__1;\nG__30216.cljs$core$IFn$_invoke$arity$2 \x3d G__30216__2;\nreturn G__30216;\n})()\n;\n\ncljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn self__.meta;\n});\n\ncljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn (new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash));\n});\n\ncljs.core.List.prototype.cljs$core$INext$_next$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((self__.count \x3d\x3d\x3d (1))){\nreturn null;\n} else {\nreturn self__.rest;\n}\n});\n\ncljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn self__.count;\n});\n\ncljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn self__.first;\n});\n\ncljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn coll__$1.cljs$core$ISeq$_rest$arity$1(null);\n});\n\ncljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nvar h__4061__auto__ \x3d self__.__hash;\nif(!((h__4061__auto__ \x3d\x3d null))){\nreturn h__4061__auto__;\n} else {\nvar h__4061__auto____$1 \x3d cljs.core.hash_ordered_coll(coll__$1);\nself__.__hash \x3d h__4061__auto____$1;\n\nreturn h__4061__auto____$1;\n}\n});\n\ncljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 \x3d (function (coll,other){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.equiv_sequential(coll__$1,other);\n});\n\ncljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);\n});\n\ncljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 \x3d (function (coll,f){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);\n});\n\ncljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 \x3d (function (coll,f,start){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);\n});\n\ncljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn self__.first;\n});\n\ncljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((self__.count \x3d\x3d\x3d (1))){\nreturn cljs.core.List.EMPTY;\n} else {\nreturn self__.rest;\n}\n});\n\ncljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn coll__$1;\n});\n\ncljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 \x3d (function (coll,meta__$1){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (new cljs.core.List(meta__$1,self__.first,self__.rest,self__.count,self__.__hash));\n});\n\ncljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 \x3d (function (coll,o){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (new cljs.core.List(self__.meta,o,coll__$1,(self__.count + (1)),null));\n});\n\ncljs.core.List.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22meta\x22,\x22meta\x22,-1154898805,null),new cljs.core.Symbol(null,\x22first\x22,\x22first\x22,996428481,null),new cljs.core.Symbol(null,\x22rest\x22,\x22rest\x22,398835108,null),new cljs.core.Symbol(null,\x22count\x22,\x22count\x22,-514511684,null),cljs.core.with_meta(new cljs.core.Symbol(null,\x22__hash\x22,\x22__hash\x22,-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null))], null);\n});\n\ncljs.core.List.cljs$lang$type \x3d true;\n\ncljs.core.List.cljs$lang$ctorStr \x3d \x22cljs.core/List\x22;\n\ncljs.core.List.cljs$lang$ctorPrWriter \x3d (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){\nreturn cljs.core._write(writer__4193__auto__,\x22cljs.core/List\x22);\n});\n\n/**\n * Positional factory function for cljs.core/List.\n */\ncljs.core.__GT_List \x3d (function cljs$core$__GT_List(meta,first,rest,count,__hash){\nreturn (new cljs.core.List(meta,first,rest,count,__hash));\n});\n\n/**\n * Returns true if x implements IList\n */\ncljs.core.list_QMARK_ \x3d (function cljs$core$list_QMARK_(x){\nif(!((x \x3d\x3d null))){\nif((((x.cljs$lang$protocol_mask$partition0$ \x26 (33554432))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$IList$)))){\nreturn true;\n} else {\nif((!x.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);\n}\n});\nvar G__30218_30221 \x3d cljs.core.List.prototype;\nvar G__30219_30222 \x3d cljs.core.ITER_SYMBOL;\nvar G__30220_30223 \x3d ((function (G__30218_30221,G__30219_30222){\nreturn (function (){\nvar this__4470__auto__ \x3d this;\nreturn cljs.core.es6_iterator(this__4470__auto__);\n});})(G__30218_30221,G__30219_30222))\n;\ngoog.object.set(G__30218_30221,G__30219_30222,G__30220_30223);\n\n/**\n* @constructor\n * @implements {cljs.core.IList}\n * @implements {cljs.core.IEquiv}\n * @implements {cljs.core.IHash}\n * @implements {cljs.core.ICollection}\n * @implements {cljs.core.IEmptyableCollection}\n * @implements {cljs.core.ICounted}\n * @implements {cljs.core.ISeq}\n * @implements {cljs.core.INext}\n * @implements {cljs.core.ISeqable}\n * @implements {cljs.core.IMeta}\n * @implements {cljs.core.ICloneable}\n * @implements {cljs.core.IStack}\n * @implements {cljs.core.ISequential}\n * @implements {cljs.core.IWithMeta}\n * @implements {cljs.core.IReduce}\n*/\ncljs.core.EmptyList \x3d (function (meta){\nthis.meta \x3d meta;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 65937614;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 8192;\n});\ncljs.core.EmptyList.prototype.toString \x3d (function (){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core.pr_str_STAR_(coll);\n});\n\ncljs.core.EmptyList.prototype.equiv \x3d (function (other){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn this$.cljs$core$IEquiv$_equiv$arity$2(null,other);\n});\n\ncljs.core.EmptyList.prototype.indexOf \x3d (function() {\nvar G__30224 \x3d null;\nvar G__30224__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));\n});\nvar G__30224__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__30224 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__30224__1.call(this,x);\ncase 2:\nreturn G__30224__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__30224.cljs$core$IFn$_invoke$arity$1 \x3d G__30224__1;\nG__30224.cljs$core$IFn$_invoke$arity$2 \x3d G__30224__2;\nreturn G__30224;\n})()\n;\n\ncljs.core.EmptyList.prototype.lastIndexOf \x3d (function() {\nvar G__30225 \x3d null;\nvar G__30225__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));\n});\nvar G__30225__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__30225 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__30225__1.call(this,x);\ncase 2:\nreturn G__30225__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__30225.cljs$core$IFn$_invoke$arity$1 \x3d G__30225__1;\nG__30225.cljs$core$IFn$_invoke$arity$2 \x3d G__30225__2;\nreturn G__30225;\n})()\n;\n\ncljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn self__.meta;\n});\n\ncljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn (new cljs.core.EmptyList(self__.meta));\n});\n\ncljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn null;\n});\n\ncljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (0);\n});\n\ncljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn null;\n});\n\ncljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nthrow (new Error(\x22Can\x27t pop empty list\x22));\n});\n\ncljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.empty_ordered_hash;\n});\n\ncljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 \x3d (function (coll,other){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif(((cljs.core.list_QMARK_(other)) || (cljs.core.sequential_QMARK_(other)))){\nreturn (cljs.core.seq(other) \x3d\x3d null);\n} else {\nreturn false;\n}\n});\n\ncljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn coll__$1;\n});\n\ncljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 \x3d (function (coll,f){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);\n});\n\ncljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 \x3d (function (coll,f,start){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);\n});\n\ncljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn null;\n});\n\ncljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.List.EMPTY;\n});\n\ncljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn null;\n});\n\ncljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 \x3d (function (coll,meta__$1){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (new cljs.core.EmptyList(meta__$1));\n});\n\ncljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 \x3d (function (coll,o){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (new cljs.core.List(self__.meta,o,null,(1),null));\n});\n\ncljs.core.EmptyList.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22meta\x22,\x22meta\x22,-1154898805,null)], null);\n});\n\ncljs.core.EmptyList.cljs$lang$type \x3d true;\n\ncljs.core.EmptyList.cljs$lang$ctorStr \x3d \x22cljs.core/EmptyList\x22;\n\ncljs.core.EmptyList.cljs$lang$ctorPrWriter \x3d (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){\nreturn cljs.core._write(writer__4193__auto__,\x22cljs.core/EmptyList\x22);\n});\n\n/**\n * Positional factory function for cljs.core/EmptyList.\n */\ncljs.core.__GT_EmptyList \x3d (function cljs$core$__GT_EmptyList(meta){\nreturn (new cljs.core.EmptyList(meta));\n});\n\ncljs.core.List.EMPTY \x3d (new cljs.core.EmptyList(null));\nvar G__30226_30229 \x3d cljs.core.EmptyList.prototype;\nvar G__30227_30230 \x3d cljs.core.ITER_SYMBOL;\nvar G__30228_30231 \x3d ((function (G__30226_30229,G__30227_30230){\nreturn (function (){\nvar this__4470__auto__ \x3d this;\nreturn cljs.core.es6_iterator(this__4470__auto__);\n});})(G__30226_30229,G__30227_30230))\n;\ngoog.object.set(G__30226_30229,G__30227_30230,G__30228_30231);\n/**\n * Returns true if coll satisfies? IReversible.\n */\ncljs.core.reversible_QMARK_ \x3d (function cljs$core$reversible_QMARK_(coll){\nif(!((coll \x3d\x3d null))){\nif((((coll.cljs$lang$protocol_mask$partition0$ \x26 (134217728))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$IReversible$)))){\nreturn true;\n} else {\nif((!coll.cljs$lang$protocol_mask$partition0$)){\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);\n} else {\nreturn false;\n}\n}\n} else {\nreturn cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);\n}\n});\n/**\n * Returns, in constant time, a seq of the items in rev (which\n *   can be a vector or sorted-map), in reverse order. If rev is empty returns nil\n */\ncljs.core.rseq \x3d (function cljs$core$rseq(rev){\nreturn cljs.core._rseq(rev);\n});\n/**\n * Returns a seq of the items in coll in reverse order. Not lazy.\n */\ncljs.core.reverse \x3d (function cljs$core$reverse(coll){\nif(cljs.core.reversible_QMARK_(coll)){\nvar or__3949__auto__ \x3d cljs.core.rseq(coll);\nif(or__3949__auto__){\nreturn or__3949__auto__;\n} else {\nreturn cljs.core.List.EMPTY;\n}\n} else {\nreturn cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,coll);\n}\n});\n/**\n * Creates a new list containing the items.\n */\ncljs.core.list \x3d (function cljs$core$list(var_args){\nvar args__4534__auto__ \x3d [];\nvar len__4531__auto___30234 \x3d arguments.length;\nvar i__4532__auto___30235 \x3d (0);\nwhile(true){\nif((i__4532__auto___30235 \x3c len__4531__auto___30234)){\nargs__4534__auto__.push((arguments[i__4532__auto___30235]));\n\nvar G__30236 \x3d (i__4532__auto___30235 + (1));\ni__4532__auto___30235 \x3d G__30236;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4535__auto__ \x3d ((((0) \x3c args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);\nreturn cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);\n});\n\ncljs.core.list.cljs$core$IFn$_invoke$arity$variadic \x3d (function (xs){\nvar arr \x3d (((((xs instanceof cljs.core.IndexedSeq)) \x26\x26 ((xs.i \x3d\x3d\x3d (0)))))?xs.arr:(function (){var arr \x3d [];\nvar xs__$1 \x3d xs;\nwhile(true){\nif(!((xs__$1 \x3d\x3d null))){\narr.push(xs__$1.cljs$core$ISeq$_first$arity$1(null));\n\nvar G__30237 \x3d xs__$1.cljs$core$INext$_next$arity$1(null);\nxs__$1 \x3d G__30237;\ncontinue;\n} else {\nreturn arr;\n}\nbreak;\n}\n})());\nvar i \x3d arr.length;\nvar r \x3d cljs.core.List.EMPTY;\nwhile(true){\nif((i \x3e (0))){\nvar G__30238 \x3d (i - (1));\nvar G__30239 \x3d r.cljs$core$ICollection$_conj$arity$2(null,(arr[(i - (1))]));\ni \x3d G__30238;\nr \x3d G__30239;\ncontinue;\n} else {\nreturn r;\n}\nbreak;\n}\n});\n\ncljs.core.list.cljs$lang$maxFixedArity \x3d (0);\n\n/** @this {Function} */\ncljs.core.list.cljs$lang$applyTo \x3d (function (seq30233){\nvar self__4519__auto__ \x3d this;\nreturn self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq30233));\n});\n\n\n/**\n* @constructor\n * @implements {cljs.core.IList}\n * @implements {cljs.core.IEquiv}\n * @implements {cljs.core.IHash}\n * @implements {cljs.core.ASeq}\n * @implements {cljs.core.ICollection}\n * @implements {cljs.core.IEmptyableCollection}\n * @implements {cljs.core.ISeq}\n * @implements {cljs.core.INext}\n * @implements {cljs.core.ISeqable}\n * @implements {cljs.core.IMeta}\n * @implements {cljs.core.ICloneable}\n * @implements {cljs.core.ISequential}\n * @implements {cljs.core.IWithMeta}\n * @implements {cljs.core.IReduce}\n*/\ncljs.core.Cons \x3d (function (meta,first,rest,__hash){\nthis.meta \x3d meta;\nthis.first \x3d first;\nthis.rest \x3d rest;\nthis.__hash \x3d __hash;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 65929452;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 8192;\n});\ncljs.core.Cons.prototype.toString \x3d (function (){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core.pr_str_STAR_(coll);\n});\n\ncljs.core.Cons.prototype.equiv \x3d (function (other){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn this$.cljs$core$IEquiv$_equiv$arity$2(null,other);\n});\n\ncljs.core.Cons.prototype.indexOf \x3d (function() {\nvar G__30240 \x3d null;\nvar G__30240__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));\n});\nvar G__30240__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__30240 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__30240__1.call(this,x);\ncase 2:\nreturn G__30240__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__30240.cljs$core$IFn$_invoke$arity$1 \x3d G__30240__1;\nG__30240.cljs$core$IFn$_invoke$arity$2 \x3d G__30240__2;\nreturn G__30240;\n})()\n;\n\ncljs.core.Cons.prototype.lastIndexOf \x3d (function() {\nvar G__30241 \x3d null;\nvar G__30241__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));\n});\nvar G__30241__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__30241 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__30241__1.call(this,x);\ncase 2:\nreturn G__30241__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__30241.cljs$core$IFn$_invoke$arity$1 \x3d G__30241__1;\nG__30241.cljs$core$IFn$_invoke$arity$2 \x3d G__30241__2;\nreturn G__30241;\n})()\n;\n\ncljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn self__.meta;\n});\n\ncljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn (new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash));\n});\n\ncljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((self__.rest \x3d\x3d null)){\nreturn null;\n} else {\nreturn cljs.core.seq(self__.rest);\n}\n});\n\ncljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nvar h__4061__auto__ \x3d self__.__hash;\nif(!((h__4061__auto__ \x3d\x3d null))){\nreturn h__4061__auto__;\n} else {\nvar h__4061__auto____$1 \x3d cljs.core.hash_ordered_coll(coll__$1);\nself__.__hash \x3d h__4061__auto____$1;\n\nreturn h__4061__auto____$1;\n}\n});\n\ncljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 \x3d (function (coll,other){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.equiv_sequential(coll__$1,other);\n});\n\ncljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);\n});\n\ncljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 \x3d (function (coll,f){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);\n});\n\ncljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 \x3d (function (coll,f,start){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);\n});\n\ncljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn self__.first;\n});\n\ncljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((self__.rest \x3d\x3d null)){\nreturn cljs.core.List.EMPTY;\n} else {\nreturn self__.rest;\n}\n});\n\ncljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn coll__$1;\n});\n\ncljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 \x3d (function (coll,meta__$1){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (new cljs.core.Cons(meta__$1,self__.first,self__.rest,self__.__hash));\n});\n\ncljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 \x3d (function (coll,o){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (new cljs.core.Cons(null,o,coll__$1,null));\n});\n\ncljs.core.Cons.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22meta\x22,\x22meta\x22,-1154898805,null),new cljs.core.Symbol(null,\x22first\x22,\x22first\x22,996428481,null),new cljs.core.Symbol(null,\x22rest\x22,\x22rest\x22,398835108,null),cljs.core.with_meta(new cljs.core.Symbol(null,\x22__hash\x22,\x22__hash\x22,-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null))], null);\n});\n\ncljs.core.Cons.cljs$lang$type \x3d true;\n\ncljs.core.Cons.cljs$lang$ctorStr \x3d \x22cljs.core/Cons\x22;\n\ncljs.core.Cons.cljs$lang$ctorPrWriter \x3d (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){\nreturn cljs.core._write(writer__4193__auto__,\x22cljs.core/Cons\x22);\n});\n\n/**\n * Positional factory function for cljs.core/Cons.\n */\ncljs.core.__GT_Cons \x3d (function cljs$core$__GT_Cons(meta,first,rest,__hash){\nreturn (new cljs.core.Cons(meta,first,rest,__hash));\n});\n\nvar G__30242_30245 \x3d cljs.core.Cons.prototype;\nvar G__30243_30246 \x3d cljs.core.ITER_SYMBOL;\nvar G__30244_30247 \x3d ((function (G__30242_30245,G__30243_30246){\nreturn (function (){\nvar this__4470__auto__ \x3d this;\nreturn cljs.core.es6_iterator(this__4470__auto__);\n});})(G__30242_30245,G__30243_30246))\n;\ngoog.object.set(G__30242_30245,G__30243_30246,G__30244_30247);\n/**\n * Returns a new seq where x is the first element and coll is the rest.\n */\ncljs.core.cons \x3d (function cljs$core$cons(x,coll){\nif((function (){var or__3949__auto__ \x3d (coll \x3d\x3d null);\nif(or__3949__auto__){\nreturn or__3949__auto__;\n} else {\nif(!((coll \x3d\x3d null))){\nif((((coll.cljs$lang$protocol_mask$partition0$ \x26 (64))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d coll.cljs$core$ISeq$)))){\nreturn true;\n} else {\nreturn false;\n}\n} else {\nreturn false;\n}\n}\n})()){\nreturn (new cljs.core.Cons(null,x,coll,null));\n} else {\nreturn (new cljs.core.Cons(null,x,cljs.core.seq(coll),null));\n}\n});\ncljs.core.hash_keyword \x3d (function cljs$core$hash_keyword(k){\nreturn ((cljs.core.hash_symbol(k) + (2654435769)) | (0));\n});\ncljs.core.compare_keywords \x3d (function cljs$core$compare_keywords(a,b){\nif((a.fqn \x3d\x3d\x3d b.fqn)){\nreturn (0);\n} else {\nif(cljs.core.truth_((function (){var and__3938__auto__ \x3d cljs.core.not(a.ns);\nif(and__3938__auto__){\nreturn b.ns;\n} else {\nreturn and__3938__auto__;\n}\n})())){\nreturn (-1);\n} else {\nif(cljs.core.truth_(a.ns)){\nif(cljs.core.not(b.ns)){\nreturn (1);\n} else {\nvar nsc \x3d (function (){var G__30250 \x3d a.ns;\nvar G__30251 \x3d b.ns;\nreturn goog.array.defaultCompare(G__30250,G__30251);\n})();\nif(((0) \x3d\x3d\x3d nsc)){\nvar G__30252 \x3d a.name;\nvar G__30253 \x3d b.name;\nreturn goog.array.defaultCompare(G__30252,G__30253);\n} else {\nreturn nsc;\n}\n}\n} else {\nvar G__30254 \x3d a.name;\nvar G__30255 \x3d b.name;\nreturn goog.array.defaultCompare(G__30254,G__30255);\n\n}\n}\n}\n});\n\n/**\n* @constructor\n * @implements {cljs.core.IEquiv}\n * @implements {cljs.core.IHash}\n * @implements {cljs.core.IFn}\n * @implements {cljs.core.INamed}\n * @implements {cljs.core.IPrintWithWriter}\n*/\ncljs.core.Keyword \x3d (function (ns,name,fqn,_hash){\nthis.ns \x3d ns;\nthis.name \x3d name;\nthis.fqn \x3d fqn;\nthis._hash \x3d _hash;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 2153775105;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 4096;\n});\ncljs.core.Keyword.prototype.toString \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nreturn [\x22:\x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join(\x27\x27);\n});\n\ncljs.core.Keyword.prototype.equiv \x3d (function (other){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn this$.cljs$core$IEquiv$_equiv$arity$2(null,other);\n});\n\ncljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 \x3d (function (_,other){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nif((other instanceof cljs.core.Keyword)){\nreturn (self__.fqn \x3d\x3d\x3d other.fqn);\n} else {\nreturn false;\n}\n});\n\ncljs.core.Keyword.prototype.call \x3d (function() {\nvar G__30257 \x3d null;\nvar G__30257__2 \x3d (function (self__,coll){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar kw \x3d self____$1;\nreturn cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);\n});\nvar G__30257__3 \x3d (function (self__,coll,not_found){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nvar kw \x3d self____$1;\nreturn cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);\n});\nG__30257 \x3d function(self__,coll,not_found){\nswitch(arguments.length){\ncase 2:\nreturn G__30257__2.call(this,self__,coll);\ncase 3:\nreturn G__30257__3.call(this,self__,coll,not_found);\n}\nthrow(new Error(\x27Invalid arity: \x27 + (arguments.length - 1)));\n};\nG__30257.cljs$core$IFn$_invoke$arity$2 \x3d G__30257__2;\nG__30257.cljs$core$IFn$_invoke$arity$3 \x3d G__30257__3;\nreturn G__30257;\n})()\n;\n\ncljs.core.Keyword.prototype.apply \x3d (function (self__,args30256){\nvar self__ \x3d this;\nvar self____$1 \x3d this;\nreturn self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args30256)));\n});\n\ncljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar kw \x3d this;\nreturn cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);\n});\n\ncljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 \x3d (function (coll,not_found){\nvar self__ \x3d this;\nvar kw \x3d this;\nreturn cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);\n});\n\ncljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 \x3d (function (this$){\nvar self__ \x3d this;\nvar this$__$1 \x3d this;\nvar h__4061__auto__ \x3d self__._hash;\nif(!((h__4061__auto__ \x3d\x3d null))){\nreturn h__4061__auto__;\n} else {\nvar h__4061__auto____$1 \x3d cljs.core.hash_keyword(this$__$1);\nself__._hash \x3d h__4061__auto____$1;\n\nreturn h__4061__auto____$1;\n}\n});\n\ncljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn self__.name;\n});\n\ncljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn self__.ns;\n});\n\ncljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 \x3d (function (o,writer,_){\nvar self__ \x3d this;\nvar o__$1 \x3d this;\nreturn cljs.core._write(writer,[\x22:\x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join(\x27\x27));\n});\n\ncljs.core.Keyword.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22ns\x22,\x22ns\x22,2082130287,null),new cljs.core.Symbol(null,\x22name\x22,\x22name\x22,-810760592,null),new cljs.core.Symbol(null,\x22fqn\x22,\x22fqn\x22,-1749334463,null),cljs.core.with_meta(new cljs.core.Symbol(null,\x22_hash\x22,\x22_hash\x22,-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null))], null);\n});\n\ncljs.core.Keyword.cljs$lang$type \x3d true;\n\ncljs.core.Keyword.cljs$lang$ctorStr \x3d \x22cljs.core/Keyword\x22;\n\ncljs.core.Keyword.cljs$lang$ctorPrWriter \x3d (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){\nreturn cljs.core._write(writer__4193__auto__,\x22cljs.core/Keyword\x22);\n});\n\n/**\n * Positional factory function for cljs.core/Keyword.\n */\ncljs.core.__GT_Keyword \x3d (function cljs$core$__GT_Keyword(ns,name,fqn,_hash){\nreturn (new cljs.core.Keyword(ns,name,fqn,_hash));\n});\n\n/**\n * Return true if x is a Keyword\n */\ncljs.core.keyword_QMARK_ \x3d (function cljs$core$keyword_QMARK_(x){\nreturn (x instanceof cljs.core.Keyword);\n});\n/**\n * Efficient test to determine that two keywords are identical.\n */\ncljs.core.keyword_identical_QMARK_ \x3d (function cljs$core$keyword_identical_QMARK_(x,y){\nif((x \x3d\x3d\x3d y)){\nreturn true;\n} else {\nif((((x instanceof cljs.core.Keyword)) \x26\x26 ((y instanceof cljs.core.Keyword)))){\nreturn (x.fqn \x3d\x3d\x3d y.fqn);\n} else {\nreturn false;\n}\n}\n});\n/**\n * Efficient test to determine that two symbols are identical.\n */\ncljs.core.symbol_identical_QMARK_ \x3d (function cljs$core$symbol_identical_QMARK_(x,y){\nif((x \x3d\x3d\x3d y)){\nreturn true;\n} else {\nif((((x instanceof cljs.core.Symbol)) \x26\x26 ((y instanceof cljs.core.Symbol)))){\nreturn (x.str \x3d\x3d\x3d y.str);\n} else {\nreturn false;\n}\n}\n});\n/**\n * Returns the namespace String of a symbol or keyword, or nil if not present.\n */\ncljs.core.namespace \x3d (function cljs$core$namespace(x){\nif(((!((x \x3d\x3d null)))?(((((x.cljs$lang$protocol_mask$partition1$ \x26 (4096))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d x.cljs$core$INamed$))))?true:false):false)){\nreturn x.cljs$core$INamed$_namespace$arity$1(null);\n} else {\nthrow (new Error([\x22Doesn\x27t support namespace: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(\x27\x27)));\n}\n});\n/**\n * Return true if x is a symbol or keyword\n */\ncljs.core.ident_QMARK_ \x3d (function cljs$core$ident_QMARK_(x){\nreturn (((x instanceof cljs.core.Keyword)) || ((x instanceof cljs.core.Symbol)));\n});\n/**\n * Return true if x is a symbol or keyword without a namespace\n */\ncljs.core.simple_ident_QMARK_ \x3d (function cljs$core$simple_ident_QMARK_(x){\nreturn ((cljs.core.ident_QMARK_(x)) \x26\x26 ((cljs.core.namespace(x) \x3d\x3d null)));\n});\n/**\n * Return true if x is a symbol or keyword with a namespace\n */\ncljs.core.qualified_ident_QMARK_ \x3d (function cljs$core$qualified_ident_QMARK_(x){\nreturn cljs.core.boolean$((function (){var and__3938__auto__ \x3d cljs.core.ident_QMARK_(x);\nif(and__3938__auto__){\nvar and__3938__auto____$1 \x3d cljs.core.namespace(x);\nif(cljs.core.truth_(and__3938__auto____$1)){\nreturn true;\n} else {\nreturn and__3938__auto____$1;\n}\n} else {\nreturn and__3938__auto__;\n}\n})());\n});\n/**\n * Return true if x is a symbol without a namespace\n */\ncljs.core.simple_symbol_QMARK_ \x3d (function cljs$core$simple_symbol_QMARK_(x){\nreturn (((x instanceof cljs.core.Symbol)) \x26\x26 ((cljs.core.namespace(x) \x3d\x3d null)));\n});\n/**\n * Return true if x is a symbol with a namespace\n */\ncljs.core.qualified_symbol_QMARK_ \x3d (function cljs$core$qualified_symbol_QMARK_(x){\nreturn cljs.core.boolean$((function (){var and__3938__auto__ \x3d (x instanceof cljs.core.Symbol);\nif(and__3938__auto__){\nvar and__3938__auto____$1 \x3d cljs.core.namespace(x);\nif(cljs.core.truth_(and__3938__auto____$1)){\nreturn true;\n} else {\nreturn and__3938__auto____$1;\n}\n} else {\nreturn and__3938__auto__;\n}\n})());\n});\n/**\n * Return true if x is a keyword without a namespace\n */\ncljs.core.simple_keyword_QMARK_ \x3d (function cljs$core$simple_keyword_QMARK_(x){\nreturn (((x instanceof cljs.core.Keyword)) \x26\x26 ((cljs.core.namespace(x) \x3d\x3d null)));\n});\n/**\n * Return true if x is a keyword with a namespace\n */\ncljs.core.qualified_keyword_QMARK_ \x3d (function cljs$core$qualified_keyword_QMARK_(x){\nreturn cljs.core.boolean$((function (){var and__3938__auto__ \x3d (x instanceof cljs.core.Keyword);\nif(and__3938__auto__){\nvar and__3938__auto____$1 \x3d cljs.core.namespace(x);\nif(cljs.core.truth_(and__3938__auto____$1)){\nreturn true;\n} else {\nreturn and__3938__auto____$1;\n}\n} else {\nreturn and__3938__auto__;\n}\n})());\n});\n/**\n * Returns a Keyword with the given namespace and name.  Do not use :\n *   in the keyword strings, it will be added automatically.\n */\ncljs.core.keyword \x3d (function cljs$core$keyword(var_args){\nvar G__30260 \x3d arguments.length;\nswitch (G__30260) {\ncase 1:\nreturn cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.keyword.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core.keyword.cljs$core$IFn$_invoke$arity$1 \x3d (function (name){\nif((name instanceof cljs.core.Keyword)){\nreturn name;\n} else {\nif((name instanceof cljs.core.Symbol)){\nreturn (new cljs.core.Keyword(cljs.core.namespace(name),(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null,name)),name.str,null));\n} else {\nif(typeof name \x3d\x3d\x3d \x27string\x27){\nvar parts \x3d name.split(\x22/\x22);\nif((parts.length \x3d\x3d\x3d (2))){\nreturn (new cljs.core.Keyword((parts[(0)]),(parts[(1)]),name,null));\n} else {\nreturn (new cljs.core.Keyword(null,(parts[(0)]),name,null));\n}\n} else {\nreturn null;\n}\n}\n}\n});\n\ncljs.core.keyword.cljs$core$IFn$_invoke$arity$2 \x3d (function (ns,name){\nvar ns__$1 \x3d (((ns instanceof cljs.core.Keyword))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(ns) : cljs.core.name.call(null,ns)):(((ns instanceof cljs.core.Symbol))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(ns) : cljs.core.name.call(null,ns)):ns\n));\nvar name__$1 \x3d (((name instanceof cljs.core.Keyword))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null,name)):(((name instanceof cljs.core.Symbol))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null,name)):name\n));\nreturn (new cljs.core.Keyword(ns__$1,name__$1,[cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(ns__$1)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns__$1),\x22/\x22].join(\x27\x27):null)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(name__$1)].join(\x27\x27),null));\n});\n\ncljs.core.keyword.cljs$lang$maxFixedArity \x3d 2;\n\n\n/**\n* @constructor\n * @implements {cljs.core.IEquiv}\n * @implements {cljs.core.IHash}\n * @implements {cljs.core.ICollection}\n * @implements {cljs.core.IPending}\n * @implements {cljs.core.IEmptyableCollection}\n * @implements {cljs.core.ISeq}\n * @implements {cljs.core.INext}\n * @implements {cljs.core.ISeqable}\n * @implements {cljs.core.IMeta}\n * @implements {cljs.core.ISequential}\n * @implements {cljs.core.IWithMeta}\n * @implements {cljs.core.IReduce}\n*/\ncljs.core.LazySeq \x3d (function (meta,fn,s,__hash){\nthis.meta \x3d meta;\nthis.fn \x3d fn;\nthis.s \x3d s;\nthis.__hash \x3d __hash;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 32374988;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 1;\n});\ncljs.core.LazySeq.prototype.toString \x3d (function (){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core.pr_str_STAR_(coll);\n});\n\ncljs.core.LazySeq.prototype.equiv \x3d (function (other){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn this$.cljs$core$IEquiv$_equiv$arity$2(null,other);\n});\n\ncljs.core.LazySeq.prototype.sval \x3d (function (){\nvar self__ \x3d this;\nvar coll \x3d this;\nif((self__.fn \x3d\x3d null)){\nreturn self__.s;\n} else {\nself__.s \x3d (self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null));\n\nself__.fn \x3d null;\n\nreturn self__.s;\n}\n});\n\ncljs.core.LazySeq.prototype.indexOf \x3d (function() {\nvar G__30262 \x3d null;\nvar G__30262__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));\n});\nvar G__30262__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__30262 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__30262__1.call(this,x);\ncase 2:\nreturn G__30262__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__30262.cljs$core$IFn$_invoke$arity$1 \x3d G__30262__1;\nG__30262.cljs$core$IFn$_invoke$arity$2 \x3d G__30262__2;\nreturn G__30262;\n})()\n;\n\ncljs.core.LazySeq.prototype.lastIndexOf \x3d (function() {\nvar G__30263 \x3d null;\nvar G__30263__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));\n});\nvar G__30263__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__30263 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__30263__1.call(this,x);\ncase 2:\nreturn G__30263__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__30263.cljs$core$IFn$_invoke$arity$1 \x3d G__30263__1;\nG__30263.cljs$core$IFn$_invoke$arity$2 \x3d G__30263__2;\nreturn G__30263;\n})()\n;\n\ncljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn self__.meta;\n});\n\ncljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\ncoll__$1.cljs$core$ISeqable$_seq$arity$1(null);\n\nif((self__.s \x3d\x3d null)){\nreturn null;\n} else {\nreturn cljs.core.next(self__.s);\n}\n});\n\ncljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nvar h__4061__auto__ \x3d self__.__hash;\nif(!((h__4061__auto__ \x3d\x3d null))){\nreturn h__4061__auto__;\n} else {\nvar h__4061__auto____$1 \x3d cljs.core.hash_ordered_coll(coll__$1);\nself__.__hash \x3d h__4061__auto____$1;\n\nreturn h__4061__auto____$1;\n}\n});\n\ncljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 \x3d (function (coll,other){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.equiv_sequential(coll__$1,other);\n});\n\ncljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);\n});\n\ncljs.core.LazySeq.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.not(self__.fn);\n});\n\ncljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 \x3d (function (coll,f){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);\n});\n\ncljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 \x3d (function (coll,f,start){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);\n});\n\ncljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\ncoll__$1.cljs$core$ISeqable$_seq$arity$1(null);\n\nif((self__.s \x3d\x3d null)){\nreturn null;\n} else {\nreturn cljs.core.first(self__.s);\n}\n});\n\ncljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\ncoll__$1.cljs$core$ISeqable$_seq$arity$1(null);\n\nif(!((self__.s \x3d\x3d null))){\nreturn cljs.core.rest(self__.s);\n} else {\nreturn cljs.core.List.EMPTY;\n}\n});\n\ncljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\ncoll__$1.sval();\n\nif((self__.s \x3d\x3d null)){\nreturn null;\n} else {\nvar ls \x3d self__.s;\nwhile(true){\nif((ls instanceof cljs.core.LazySeq)){\nvar G__30264 \x3d ls.sval();\nls \x3d G__30264;\ncontinue;\n} else {\nself__.s \x3d ls;\n\nreturn cljs.core.seq(self__.s);\n}\nbreak;\n}\n}\n});\n\ncljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 \x3d (function (coll,meta__$1){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (new cljs.core.LazySeq(meta__$1,((function (coll__$1){\nreturn (function (){\nreturn coll__$1.cljs$core$ISeqable$_seq$arity$1(null);\n});})(coll__$1))\n,null,self__.__hash));\n});\n\ncljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 \x3d (function (coll,o){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.cons(o,coll__$1);\n});\n\ncljs.core.LazySeq.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22meta\x22,\x22meta\x22,-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,\x22fn\x22,\x22fn\x22,465265323,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,\x22s\x22,\x22s\x22,-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,\x22__hash\x22,\x22__hash\x22,-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null))], null);\n});\n\ncljs.core.LazySeq.cljs$lang$type \x3d true;\n\ncljs.core.LazySeq.cljs$lang$ctorStr \x3d \x22cljs.core/LazySeq\x22;\n\ncljs.core.LazySeq.cljs$lang$ctorPrWriter \x3d (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){\nreturn cljs.core._write(writer__4193__auto__,\x22cljs.core/LazySeq\x22);\n});\n\n/**\n * Positional factory function for cljs.core/LazySeq.\n */\ncljs.core.__GT_LazySeq \x3d (function cljs$core$__GT_LazySeq(meta,fn,s,__hash){\nreturn (new cljs.core.LazySeq(meta,fn,s,__hash));\n});\n\nvar G__30265_30268 \x3d cljs.core.LazySeq.prototype;\nvar G__30266_30269 \x3d cljs.core.ITER_SYMBOL;\nvar G__30267_30270 \x3d ((function (G__30265_30268,G__30266_30269){\nreturn (function (){\nvar this__4470__auto__ \x3d this;\nreturn cljs.core.es6_iterator(this__4470__auto__);\n});})(G__30265_30268,G__30266_30269))\n;\ngoog.object.set(G__30265_30268,G__30266_30269,G__30267_30270);\n\n/**\n* @constructor\n * @implements {cljs.core.ICounted}\n*/\ncljs.core.ChunkBuffer \x3d (function (buf,end){\nthis.buf \x3d buf;\nthis.end \x3d end;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 2;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 0;\n});\ncljs.core.ChunkBuffer.prototype.add \x3d (function (o){\nvar self__ \x3d this;\nvar _ \x3d this;\n(self__.buf[self__.end] \x3d o);\n\nreturn self__.end \x3d (self__.end + (1));\n});\n\ncljs.core.ChunkBuffer.prototype.chunk \x3d (function (){\nvar self__ \x3d this;\nvar _ \x3d this;\nvar ret \x3d (new cljs.core.ArrayChunk(self__.buf,(0),self__.end));\nself__.buf \x3d null;\n\nreturn ret;\n});\n\ncljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn self__.end;\n});\n\ncljs.core.ChunkBuffer.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,\x22buf\x22,\x22buf\x22,1426618187,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,\x22end\x22,\x22end\x22,1372345569,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null))], null);\n});\n\ncljs.core.ChunkBuffer.cljs$lang$type \x3d true;\n\ncljs.core.ChunkBuffer.cljs$lang$ctorStr \x3d \x22cljs.core/ChunkBuffer\x22;\n\ncljs.core.ChunkBuffer.cljs$lang$ctorPrWriter \x3d (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){\nreturn cljs.core._write(writer__4193__auto__,\x22cljs.core/ChunkBuffer\x22);\n});\n\n/**\n * Positional factory function for cljs.core/ChunkBuffer.\n */\ncljs.core.__GT_ChunkBuffer \x3d (function cljs$core$__GT_ChunkBuffer(buf,end){\nreturn (new cljs.core.ChunkBuffer(buf,end));\n});\n\ncljs.core.chunk_buffer \x3d (function cljs$core$chunk_buffer(capacity){\nreturn (new cljs.core.ChunkBuffer((new Array(capacity)),(0)));\n});\n\n/**\n* @constructor\n * @implements {cljs.core.IIndexed}\n * @implements {cljs.core.ICounted}\n * @implements {cljs.core.IChunk}\n * @implements {cljs.core.IReduce}\n*/\ncljs.core.ArrayChunk \x3d (function (arr,off,end){\nthis.arr \x3d arr;\nthis.off \x3d off;\nthis.end \x3d end;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 524306;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 0;\n});\ncljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 \x3d (function (_){\nvar self__ \x3d this;\nvar ___$1 \x3d this;\nreturn (self__.end - self__.off);\n});\n\ncljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 \x3d (function (coll,i){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (self__.arr[(self__.off + i)]);\n});\n\ncljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 \x3d (function (coll,i,not_found){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((((i \x3e\x3d (0))) \x26\x26 ((i \x3c (self__.end - self__.off))))){\nreturn (self__.arr[(self__.off + i)]);\n} else {\nreturn not_found;\n}\n});\n\ncljs.core.ArrayChunk.prototype.cljs$core$IChunk$ \x3d cljs.core.PROTOCOL_SENTINEL;\n\ncljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((self__.off \x3d\x3d\x3d self__.end)){\nthrow (new Error(\x22-drop-first of empty chunk\x22));\n} else {\nreturn (new cljs.core.ArrayChunk(self__.arr,(self__.off + (1)),self__.end));\n}\n});\n\ncljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 \x3d (function (coll,f){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.off]),(self__.off + (1)));\n});\n\ncljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 \x3d (function (coll,f,start){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.off);\n});\n\ncljs.core.ArrayChunk.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22arr\x22,\x22arr\x22,2115492975,null),new cljs.core.Symbol(null,\x22off\x22,\x22off\x22,-2047994980,null),new cljs.core.Symbol(null,\x22end\x22,\x22end\x22,1372345569,null)], null);\n});\n\ncljs.core.ArrayChunk.cljs$lang$type \x3d true;\n\ncljs.core.ArrayChunk.cljs$lang$ctorStr \x3d \x22cljs.core/ArrayChunk\x22;\n\ncljs.core.ArrayChunk.cljs$lang$ctorPrWriter \x3d (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){\nreturn cljs.core._write(writer__4193__auto__,\x22cljs.core/ArrayChunk\x22);\n});\n\n/**\n * Positional factory function for cljs.core/ArrayChunk.\n */\ncljs.core.__GT_ArrayChunk \x3d (function cljs$core$__GT_ArrayChunk(arr,off,end){\nreturn (new cljs.core.ArrayChunk(arr,off,end));\n});\n\ncljs.core.array_chunk \x3d (function cljs$core$array_chunk(var_args){\nvar G__30272 \x3d arguments.length;\nswitch (G__30272) {\ncase 1:\nreturn cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 \x3d (function (arr){\nreturn (new cljs.core.ArrayChunk(arr,(0),arr.length));\n});\n\ncljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 \x3d (function (arr,off){\nreturn (new cljs.core.ArrayChunk(arr,off,arr.length));\n});\n\ncljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 \x3d (function (arr,off,end){\nreturn (new cljs.core.ArrayChunk(arr,off,end));\n});\n\ncljs.core.array_chunk.cljs$lang$maxFixedArity \x3d 3;\n\n\n/**\n* @constructor\n * @implements {cljs.core.IEquiv}\n * @implements {cljs.core.IHash}\n * @implements {cljs.core.ASeq}\n * @implements {cljs.core.ICollection}\n * @implements {cljs.core.IChunkedNext}\n * @implements {cljs.core.IEmptyableCollection}\n * @implements {cljs.core.ISeq}\n * @implements {cljs.core.INext}\n * @implements {cljs.core.ISeqable}\n * @implements {cljs.core.IMeta}\n * @implements {cljs.core.IChunkedSeq}\n * @implements {cljs.core.ISequential}\n * @implements {cljs.core.IWithMeta}\n*/\ncljs.core.ChunkedCons \x3d (function (chunk,more,meta,__hash){\nthis.chunk \x3d chunk;\nthis.more \x3d more;\nthis.meta \x3d meta;\nthis.__hash \x3d __hash;\nthis.cljs$lang$protocol_mask$partition0$ \x3d 31850732;\nthis.cljs$lang$protocol_mask$partition1$ \x3d 1536;\n});\ncljs.core.ChunkedCons.prototype.toString \x3d (function (){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core.pr_str_STAR_(coll);\n});\n\ncljs.core.ChunkedCons.prototype.equiv \x3d (function (other){\nvar self__ \x3d this;\nvar this$ \x3d this;\nreturn this$.cljs$core$IEquiv$_equiv$arity$2(null,other);\n});\n\ncljs.core.ChunkedCons.prototype.indexOf \x3d (function() {\nvar G__30274 \x3d null;\nvar G__30274__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));\n});\nvar G__30274__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__30274 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__30274__1.call(this,x);\ncase 2:\nreturn G__30274__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__30274.cljs$core$IFn$_invoke$arity$1 \x3d G__30274__1;\nG__30274.cljs$core$IFn$_invoke$arity$2 \x3d G__30274__2;\nreturn G__30274;\n})()\n;\n\ncljs.core.ChunkedCons.prototype.lastIndexOf \x3d (function() {\nvar G__30275 \x3d null;\nvar G__30275__1 \x3d (function (x){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));\n});\nvar G__30275__2 \x3d (function (x,start){\nvar self__ \x3d this;\nvar coll \x3d this;\nreturn cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);\n});\nG__30275 \x3d function(x,start){\nswitch(arguments.length){\ncase 1:\nreturn G__30275__1.call(this,x);\ncase 2:\nreturn G__30275__2.call(this,x,start);\n}\nthrow(new Error(\x27Invalid arity: \x27 + arguments.length));\n};\nG__30275.cljs$core$IFn$_invoke$arity$1 \x3d G__30275__1;\nG__30275.cljs$core$IFn$_invoke$arity$2 \x3d G__30275__2;\nreturn G__30275;\n})()\n;\n\ncljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn self__.meta;\n});\n\ncljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((cljs.core._count(self__.chunk) \x3e (1))){\nreturn (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));\n} else {\nvar more__$1 \x3d cljs.core._seq(self__.more);\nif((more__$1 \x3d\x3d null)){\nreturn null;\n} else {\nreturn more__$1;\n}\n}\n});\n\ncljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nvar h__4061__auto__ \x3d self__.__hash;\nif(!((h__4061__auto__ \x3d\x3d null))){\nreturn h__4061__auto__;\n} else {\nvar h__4061__auto____$1 \x3d cljs.core.hash_ordered_coll(coll__$1);\nself__.__hash \x3d h__4061__auto____$1;\n\nreturn h__4061__auto____$1;\n}\n});\n\ncljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 \x3d (function (coll,other){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core.equiv_sequential(coll__$1,other);\n});\n\ncljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);\n});\n\ncljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk,(0));\n});\n\ncljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((cljs.core._count(self__.chunk) \x3e (1))){\nreturn (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));\n} else {\nif((self__.more \x3d\x3d null)){\nreturn cljs.core.List.EMPTY;\n} else {\nreturn self__.more;\n}\n}\n});\n\ncljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn coll__$1;\n});\n\ncljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn self__.chunk;\n});\n\ncljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((self__.more \x3d\x3d null)){\nreturn cljs.core.List.EMPTY;\n} else {\nreturn self__.more;\n}\n});\n\ncljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 \x3d (function (coll,m){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nreturn (new cljs.core.ChunkedCons(self__.chunk,self__.more,m,self__.__hash));\n});\n\ncljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 \x3d (function (this$,o){\nvar self__ \x3d this;\nvar this$__$1 \x3d this;\nreturn cljs.core.cons(o,this$__$1);\n});\n\ncljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 \x3d (function (coll){\nvar self__ \x3d this;\nvar coll__$1 \x3d this;\nif((self__.more \x3d\x3d null)){\nreturn null;\n} else {\nreturn self__.more;\n}\n});\n\ncljs.core.ChunkedCons.getBasis \x3d (function (){\nreturn new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,\x22chunk\x22,\x22chunk\x22,449371907,null),new cljs.core.Symbol(null,\x22more\x22,\x22more\x22,-418290273,null),new cljs.core.Symbol(null,\x22meta\x22,\x22meta\x22,-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,\x22__hash\x22,\x22__hash\x22,-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,\x22mutable\x22,\x22mutable\x22,875778266),true], null))], null);\n});\n\ncljs.core.ChunkedCons.cljs$lang$type \x3d true;\n\ncljs.core.ChunkedCons.cljs$lang$ctorStr \x3d \x22cljs.core/ChunkedCons\x22;\n\ncljs.core.ChunkedCons.cljs$lang$ctorPrWriter \x3d (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){\nreturn cljs.core._write(writer__4193__auto__,\x22cljs.core/ChunkedCons\x22);\n});\n\n/**\n * Positional factory function for cljs.core/ChunkedCons.\n */\ncljs.core.__GT_ChunkedCons \x3d (function cljs$core$__GT_ChunkedCons(chunk,more,meta,__hash){\nreturn (new cljs.core.ChunkedCons(chunk,more,meta,__hash));\n});\n\nvar G__30276_30279 \x3d cljs.core.ChunkedCons.prototype;\nvar G__30277_30280 \x3d cljs.core.ITER_SYMBOL;\nvar G__30278_30281 \x3d ((function (G__30276_30279,G__30277_30280){\nreturn (function (){\nvar this__4470__auto__ \x3d this;\nreturn cljs.core.es6_iterator(this__4470__auto__);\n});})(G__30276_30279,G__30277_30280))\n;\ngoog.object.set(G__30276_30279,G__30277_30280,G__30278_30281);\ncljs.core.chunk_cons \x3d (function cljs$core$chunk_cons(chunk,rest){\nif((cljs.core._count(chunk) \x3d\x3d\x3d (0))){\nreturn rest;\n} else {\nreturn (new cljs.core.ChunkedCons(chunk,rest,null,null));\n}\n});\ncljs.core.chunk_append \x3d (function cljs$core$chunk_append(b,x){\nreturn b.add(x);\n});\ncljs.core.chunk \x3d (function cljs$core$chunk(b){\nreturn b.chunk();\n});\ncljs.core.chunk_first \x3d (function cljs$core$chunk_first(s){\nreturn cljs.core._chunked_first(s);\n});\ncljs.core.chunk_rest \x3d (function cljs$core$chunk_rest(s){\nreturn cljs.core._chunked_rest(s);\n});\ncljs.core.chunk_next \x3d (function cljs$core$chunk_next(s){\nif(((!((s \x3d\x3d null)))?(((((s.cljs$lang$protocol_mask$partition1$ \x26 (1024))) || ((cljs.core.PROTOCOL_SENTINEL \x3d\x3d\x3d s.cljs$core$IChunkedNext$))))?true:false):false)){\nreturn cljs.core._chunked_next(s);\n} else {\nreturn cljs.core.seq(cljs.core._chunked_rest(s));\n}\n});\n/**\n * Naive impl of to-array as a start.\n */\ncljs.core.to_array \x3d (function cljs$core$to_array(s){\nvar ary \x3d [];\nvar s__$1 \x3d cljs.core.seq(s);\nwhile(true){\nif(!((s__$1 \x3d\x3d null))){\nary.push(cljs.core.first(s__$1));\n\nvar G__30283 \x3d cljs.core.next(s__$1);\ns__$1 \x3d G__30283;\ncontinue;\n} else {\nreturn ary;\n}\nbreak;\n}\n});\n/**\n * Returns a (potentially-ragged) 2-dimensional array\n *   containing the contents of coll.\n */\ncljs.core.to_array_2d \x3d (function cljs$core$to_array_2d(coll){\nvar ret \x3d (new Array(cljs.core.count(coll)));\nvar i_30284 \x3d (0);\nvar xs_30285 \x3d cljs.core.seq(coll);\nwhile(true){\nif((xs_30285 \x3d\x3d null)){\n} else {\n(ret[i_30284] \x3d cljs.core.to_array(cljs.core.first(xs_30285)));\n\nvar G__30286 \x3d (i_30284 + (1));\nvar G__30287 \x3d cljs.core.next(xs_30285);\ni_30284 \x3d G__30286;\nxs_30285 \x3d G__30287;\ncontinue;\n}\nbreak;\n}\n\nreturn ret;\n});\n/**\n * Creates an array of ints. Does not coerce array, provided for compatibility\n *   with Clojure.\n */\ncljs.core.int_array \x3d (function cljs$core$int_array(var_args){\nvar G__30289 \x3d arguments.length;\nswitch (G__30289) {\ncase 1:\nreturn cljs.core.int_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.int_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core.int_array.cljs$core$IFn$_invoke$arity$1 \x3d (function (size_or_seq){\nif(typeof size_or_seq \x3d\x3d\x3d \x27number\x27){\nreturn cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);\n} else {\nreturn cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);\n}\n});\n\ncljs.core.int_array.cljs$core$IFn$_invoke$arity$2 \x3d (function (size,init_val_or_seq){\nvar a \x3d (new Array(size));\nif(cljs.core.seq_QMARK_(init_val_or_seq)){\nvar s \x3d cljs.core.seq(init_val_or_seq);\nvar i \x3d (0);\nvar s__$1 \x3d s;\nwhile(true){\nif(((s__$1) \x26\x26 ((i \x3c size)))){\n(a[i] \x3d cljs.core.first(s__$1));\n\nvar G__30291 \x3d (i + (1));\nvar G__30292 \x3d cljs.core.next(s__$1);\ni \x3d G__30291;\ns__$1 \x3d G__30292;\ncontinue;\n} else {\nreturn a;\n}\nbreak;\n}\n} else {\nvar n__4408__auto___30293 \x3d size;\nvar i_30294 \x3d (0);\nwhile(true){\nif((i_30294 \x3c n__4408__auto___30293)){\n(a[i_30294] \x3d init_val_or_seq);\n\nvar G__30295 \x3d (i_30294 + (1));\ni_30294 \x3d G__30295;\ncontinue;\n} else {\n}\nbreak;\n}\n\nreturn a;\n}\n});\n\ncljs.core.int_array.cljs$lang$maxFixedArity \x3d 2;\n\n/**\n * Creates an array of longs. Does not coerce array, provided for compatibility\n *   with Clojure.\n */\ncljs.core.long_array \x3d (function cljs$core$long_array(var_args){\nvar G__30297 \x3d arguments.length;\nswitch (G__30297) {\ncase 1:\nreturn cljs.core.long_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.long_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core.long_array.cljs$core$IFn$_invoke$arity$1 \x3d (function (size_or_seq){\nif(typeof size_or_seq \x3d\x3d\x3d \x27number\x27){\nreturn cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);\n} else {\nreturn cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);\n}\n});\n\ncljs.core.long_array.cljs$core$IFn$_invoke$arity$2 \x3d (function (size,init_val_or_seq){\nvar a \x3d (new Array(size));\nif(cljs.core.seq_QMARK_(init_val_or_seq)){\nvar s \x3d cljs.core.seq(init_val_or_seq);\nvar i \x3d (0);\nvar s__$1 \x3d s;\nwhile(true){\nif(((s__$1) \x26\x26 ((i \x3c size)))){\n(a[i] \x3d cljs.core.first(s__$1));\n\nvar G__30299 \x3d (i + (1));\nvar G__30300 \x3d cljs.core.next(s__$1);\ni \x3d G__30299;\ns__$1 \x3d G__30300;\ncontinue;\n} else {\nreturn a;\n}\nbreak;\n}\n} else {\nvar n__4408__auto___30301 \x3d size;\nvar i_30302 \x3d (0);\nwhile(true){\nif((i_30302 \x3c n__4408__auto___30301)){\n(a[i_30302] \x3d init_val_or_seq);\n\nvar G__30303 \x3d (i_30302 + (1));\ni_30302 \x3d G__30303;\ncontinue;\n} else {\n}\nbreak;\n}\n\nreturn a;\n}\n});\n\ncljs.core.long_array.cljs$lang$maxFixedArity \x3d 2;\n\n/**\n * Creates an array of doubles. Does not coerce array, provided for compatibility\n *   with Clojure.\n */\ncljs.core.double_array \x3d (function cljs$core$double_array(var_args){\nvar G__30305 \x3d arguments.length;\nswitch (G__30305) {\ncase 1:\nreturn cljs.core.double_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.double_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core.double_array.cljs$core$IFn$_invoke$arity$1 \x3d (function (size_or_seq){\nif(typeof size_or_seq \x3d\x3d\x3d \x27number\x27){\nreturn cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);\n} else {\nreturn cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);\n}\n});\n\ncljs.core.double_array.cljs$core$IFn$_invoke$arity$2 \x3d (function (size,init_val_or_seq){\nvar a \x3d (new Array(size));\nif(cljs.core.seq_QMARK_(init_val_or_seq)){\nvar s \x3d cljs.core.seq(init_val_or_seq);\nvar i \x3d (0);\nvar s__$1 \x3d s;\nwhile(true){\nif(((s__$1) \x26\x26 ((i \x3c size)))){\n(a[i] \x3d cljs.core.first(s__$1));\n\nvar G__30307 \x3d (i + (1));\nvar G__30308 \x3d cljs.core.next(s__$1);\ni \x3d G__30307;\ns__$1 \x3d G__30308;\ncontinue;\n} else {\nreturn a;\n}\nbreak;\n}\n} else {\nvar n__4408__auto___30309 \x3d size;\nvar i_30310 \x3d (0);\nwhile(true){\nif((i_30310 \x3c n__4408__auto___30309)){\n(a[i_30310] \x3d init_val_or_seq);\n\nvar G__30311 \x3d (i_30310 + (1));\ni_30310 \x3d G__30311;\ncontinue;\n} else {\n}\nbreak;\n}\n\nreturn a;\n}\n});\n\ncljs.core.double_array.cljs$lang$maxFixedArity \x3d 2;\n\n/**\n * Creates an array of objects. Does not coerce array, provided for compatibility\n *   with Clojure.\n */\ncljs.core.object_array \x3d (function cljs$core$object_array(var_args){\nvar G__30313 \x3d arguments.length;\nswitch (G__30313) {\ncase 1:\nreturn cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.object_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core.object_array.cljs$core$IFn$_invoke$arity$1 \x3d (function (size_or_seq){\nif(typeof size_or_seq \x3d\x3d\x3d \x27number\x27){\nreturn cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);\n} else {\nreturn cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);\n}\n});\n\ncljs.core.object_array.cljs$core$IFn$_invoke$arity$2 \x3d (function (size,init_val_or_seq){\nvar a \x3d (new Array(size));\nif(cljs.core.seq_QMARK_(init_val_or_seq)){\nvar s \x3d cljs.core.seq(init_val_or_seq);\nvar i \x3d (0);\nvar s__$1 \x3d s;\nwhile(true){\nif(((s__$1) \x26\x26 ((i \x3c size)))){\n(a[i] \x3d cljs.core.first(s__$1));\n\nvar G__30315 \x3d (i + (1));\nvar G__30316 \x3d cljs.core.next(s__$1);\ni \x3d G__30315;\ns__$1 \x3d G__30316;\ncontinue;\n} else {\nreturn a;\n}\nbreak;\n}\n} else {\nvar n__4408__auto___30317 \x3d size;\nvar i_30318 \x3d (0);\nwhile(true){\nif((i_30318 \x3c n__4408__auto___30317)){\n(a[i_30318] \x3d init_val_or_seq);\n\nvar G__30319 \x3d (i_30318 + (1));\ni_30318 \x3d G__30319;\ncontinue;\n} else {\n}\nbreak;\n}\n\nreturn a;\n}\n});\n\ncljs.core.object_array.cljs$lang$maxFixedArity \x3d 2;\n\n/**\n * If coll is counted? returns its count, else will count at most the first n\n * elements of coll using its seq\n */\ncljs.core.bounded_count \x3d (function cljs$core$bounded_count(n,coll){\nif(cljs.core.counted_QMARK_(coll)){\nreturn cljs.core.count(coll);\n} else {\nvar i \x3d (0);\nvar s \x3d cljs.core.seq(coll);\nwhile(true){\nif(((!((s \x3d\x3d null))) \x26\x26 ((i \x3c n)))){\nvar G__30320 \x3d (i + (1));\nvar G__30321 \x3d cljs.core.next(s);\ni \x3d G__30320;\ns \x3d G__30321;\ncontinue;\n} else {\nreturn i;\n}\nbreak;\n}\n}\n});\ncljs.core.spread \x3d (function cljs$core$spread(arglist){\nif((arglist \x3d\x3d null)){\nreturn null;\n} else {\nvar n \x3d cljs.core.next(arglist);\nif((n \x3d\x3d null)){\nreturn cljs.core.seq(cljs.core.first(arglist));\n} else {\nreturn cljs.core.cons(cljs.core.first(arglist),(cljs.core.spread.cljs$core$IFn$_invoke$arity$1 ? cljs.core.spread.cljs$core$IFn$_invoke$arity$1(n) : cljs.core.spread.call(null,n)));\n}\n}\n});\n/**\n * Returns a lazy seq representing the concatenation of the elements in the supplied colls.\n */\ncljs.core.concat \x3d (function cljs$core$concat(var_args){\nvar G__30326 \x3d arguments.length;\nswitch (G__30326) {\ncase 0:\nreturn cljs.core.concat.cljs$core$IFn$_invoke$arity$0();\n\nbreak;\ncase 1:\nreturn cljs.core.concat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.concat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___30328 \x3d arguments.length;\nvar i__4532__auto___30329 \x3d (0);\nwhile(true){\nif((i__4532__auto___30329 \x3c len__4531__auto___30328)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___30329]));\n\nvar G__30330 \x3d (i__4532__auto___30329 + (1));\ni__4532__auto___30329 \x3d G__30330;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.concat.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nreturn (new cljs.core.LazySeq(null,(function (){\nreturn null;\n}),null,null));\n});\n\ncljs.core.concat.cljs$core$IFn$_invoke$arity$1 \x3d (function (x){\nreturn (new cljs.core.LazySeq(null,(function (){\nreturn x;\n}),null,null));\n});\n\ncljs.core.concat.cljs$core$IFn$_invoke$arity$2 \x3d (function (x,y){\nreturn (new cljs.core.LazySeq(null,(function (){\nvar s \x3d cljs.core.seq(x);\nif(s){\nif(cljs.core.chunked_seq_QMARK_(s)){\nreturn cljs.core.chunk_cons(cljs.core.chunk_first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s),y));\n} else {\nreturn cljs.core.cons(cljs.core.first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s),y));\n}\n} else {\nreturn y;\n}\n}),null,null));\n});\n\ncljs.core.concat.cljs$core$IFn$_invoke$arity$variadic \x3d (function (x,y,zs){\nvar cat \x3d (function cljs$core$cat(xys,zs__$1){\nreturn (new cljs.core.LazySeq(null,(function (){\nvar xys__$1 \x3d cljs.core.seq(xys);\nif(xys__$1){\nif(cljs.core.chunked_seq_QMARK_(xys__$1)){\nreturn cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1),cljs$core$cat(cljs.core.chunk_rest(xys__$1),zs__$1));\n} else {\nreturn cljs.core.cons(cljs.core.first(xys__$1),cljs$core$cat(cljs.core.rest(xys__$1),zs__$1));\n}\n} else {\nif(cljs.core.truth_(zs__$1)){\nreturn cljs$core$cat(cljs.core.first(zs__$1),cljs.core.next(zs__$1));\n} else {\nreturn null;\n}\n}\n}),null,null));\n});\nreturn cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x,y),zs);\n});\n\n/** @this {Function} */\ncljs.core.concat.cljs$lang$applyTo \x3d (function (seq30323){\nvar G__30324 \x3d cljs.core.first(seq30323);\nvar seq30323__$1 \x3d cljs.core.next(seq30323);\nvar G__30325 \x3d cljs.core.first(seq30323__$1);\nvar seq30323__$2 \x3d cljs.core.next(seq30323__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30324,G__30325,seq30323__$2);\n});\n\ncljs.core.concat.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * Creates a new list containing the items prepended to the rest, the\n *   last of which will be treated as a sequence.\n */\ncljs.core.list_STAR_ \x3d (function cljs$core$list_STAR_(var_args){\nvar G__30337 \x3d arguments.length;\nswitch (G__30337) {\ncase 1:\nreturn cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ncase 4:\nreturn cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___30339 \x3d arguments.length;\nvar i__4532__auto___30340 \x3d (0);\nwhile(true){\nif((i__4532__auto___30340 \x3c len__4531__auto___30339)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___30340]));\n\nvar G__30341 \x3d (i__4532__auto___30340 + (1));\ni__4532__auto___30340 \x3d G__30341;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((4)),(0),null));\nreturn cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 \x3d (function (args){\nreturn cljs.core.seq(args);\n});\n\ncljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 \x3d (function (a,args){\nreturn cljs.core.cons(a,args);\n});\n\ncljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 \x3d (function (a,b,args){\nreturn cljs.core.cons(a,cljs.core.cons(b,args));\n});\n\ncljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 \x3d (function (a,b,c,args){\nreturn cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,args)));\n});\n\ncljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (a,b,c,d,more){\nreturn cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(more)))));\n});\n\n/** @this {Function} */\ncljs.core.list_STAR_.cljs$lang$applyTo \x3d (function (seq30332){\nvar G__30333 \x3d cljs.core.first(seq30332);\nvar seq30332__$1 \x3d cljs.core.next(seq30332);\nvar G__30334 \x3d cljs.core.first(seq30332__$1);\nvar seq30332__$2 \x3d cljs.core.next(seq30332__$1);\nvar G__30335 \x3d cljs.core.first(seq30332__$2);\nvar seq30332__$3 \x3d cljs.core.next(seq30332__$2);\nvar G__30336 \x3d cljs.core.first(seq30332__$3);\nvar seq30332__$4 \x3d cljs.core.next(seq30332__$3);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30333,G__30334,G__30335,G__30336,seq30332__$4);\n});\n\ncljs.core.list_STAR_.cljs$lang$maxFixedArity \x3d (4);\n\n/**\n * Returns a new, transient version of the collection, in constant time.\n */\ncljs.core.transient$ \x3d (function cljs$core$transient(coll){\nreturn cljs.core._as_transient(coll);\n});\n/**\n * Returns a new, persistent version of the transient collection, in\n *   constant time. The transient collection cannot be used after this\n *   call, any such use will throw an exception.\n */\ncljs.core.persistent_BANG_ \x3d (function cljs$core$persistent_BANG_(tcoll){\nreturn cljs.core._persistent_BANG_(tcoll);\n});\n/**\n * Adds val to the transient collection, and return tcoll. The \x27addition\x27\n *   may happen at different \x27places\x27 depending on the concrete type.\n */\ncljs.core.conj_BANG_ \x3d (function cljs$core$conj_BANG_(var_args){\nvar G__30346 \x3d arguments.length;\nswitch (G__30346) {\ncase 0:\nreturn cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();\n\nbreak;\ncase 1:\nreturn cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));\n\nbreak;\ncase 2:\nreturn cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___30348 \x3d arguments.length;\nvar i__4532__auto___30349 \x3d (0);\nwhile(true){\nif((i__4532__auto___30349 \x3c len__4531__auto___30348)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___30349]));\n\nvar G__30350 \x3d (i__4532__auto___30349 + (1));\ni__4532__auto___30349 \x3d G__30350;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 \x3d (function (){\nreturn cljs.core.transient$(cljs.core.PersistentVector.EMPTY);\n});\n\ncljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 \x3d (function (tcoll){\nreturn tcoll;\n});\n\ncljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 \x3d (function (tcoll,val){\nreturn cljs.core._conj_BANG_(tcoll,val);\n});\n\ncljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (tcoll,val,vals){\nwhile(true){\nvar ntcoll \x3d cljs.core._conj_BANG_(tcoll,val);\nif(cljs.core.truth_(vals)){\nvar G__30351 \x3d ntcoll;\nvar G__30352 \x3d cljs.core.first(vals);\nvar G__30353 \x3d cljs.core.next(vals);\ntcoll \x3d G__30351;\nval \x3d G__30352;\nvals \x3d G__30353;\ncontinue;\n} else {\nreturn ntcoll;\n}\nbreak;\n}\n});\n\n/** @this {Function} */\ncljs.core.conj_BANG_.cljs$lang$applyTo \x3d (function (seq30343){\nvar G__30344 \x3d cljs.core.first(seq30343);\nvar seq30343__$1 \x3d cljs.core.next(seq30343);\nvar G__30345 \x3d cljs.core.first(seq30343__$1);\nvar seq30343__$2 \x3d cljs.core.next(seq30343__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30344,G__30345,seq30343__$2);\n});\n\ncljs.core.conj_BANG_.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * When applied to a transient map, adds mapping of key(s) to\n *   val(s). When applied to a transient vector, sets the val at index.\n *   Note - index must be \x3c\x3d (count vector). Returns coll.\n */\ncljs.core.assoc_BANG_ \x3d (function cljs$core$assoc_BANG_(var_args){\nvar G__30359 \x3d arguments.length;\nswitch (G__30359) {\ncase 3:\nreturn cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___30361 \x3d arguments.length;\nvar i__4532__auto___30362 \x3d (0);\nwhile(true){\nif((i__4532__auto___30362 \x3c len__4531__auto___30361)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___30362]));\n\nvar G__30363 \x3d (i__4532__auto___30362 + (1));\ni__4532__auto___30362 \x3d G__30363;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((3)),(0),null));\nreturn cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 \x3d (function (tcoll,key,val){\nreturn cljs.core._assoc_BANG_(tcoll,key,val);\n});\n\ncljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (tcoll,key,val,kvs){\nwhile(true){\nvar ntcoll \x3d cljs.core._assoc_BANG_(tcoll,key,val);\nif(cljs.core.truth_(kvs)){\nvar G__30364 \x3d ntcoll;\nvar G__30365 \x3d cljs.core.first(kvs);\nvar G__30366 \x3d cljs.core.second(kvs);\nvar G__30367 \x3d cljs.core.nnext(kvs);\ntcoll \x3d G__30364;\nkey \x3d G__30365;\nval \x3d G__30366;\nkvs \x3d G__30367;\ncontinue;\n} else {\nreturn ntcoll;\n}\nbreak;\n}\n});\n\n/** @this {Function} */\ncljs.core.assoc_BANG_.cljs$lang$applyTo \x3d (function (seq30355){\nvar G__30356 \x3d cljs.core.first(seq30355);\nvar seq30355__$1 \x3d cljs.core.next(seq30355);\nvar G__30357 \x3d cljs.core.first(seq30355__$1);\nvar seq30355__$2 \x3d cljs.core.next(seq30355__$1);\nvar G__30358 \x3d cljs.core.first(seq30355__$2);\nvar seq30355__$3 \x3d cljs.core.next(seq30355__$2);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30356,G__30357,G__30358,seq30355__$3);\n});\n\ncljs.core.assoc_BANG_.cljs$lang$maxFixedArity \x3d (3);\n\n/**\n * Returns a transient map that doesn\x27t contain a mapping for key(s).\n */\ncljs.core.dissoc_BANG_ \x3d (function cljs$core$dissoc_BANG_(var_args){\nvar G__30372 \x3d arguments.length;\nswitch (G__30372) {\ncase 2:\nreturn cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___30374 \x3d arguments.length;\nvar i__4532__auto___30375 \x3d (0);\nwhile(true){\nif((i__4532__auto___30375 \x3c len__4531__auto___30374)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___30375]));\n\nvar G__30376 \x3d (i__4532__auto___30375 + (1));\ni__4532__auto___30375 \x3d G__30376;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 \x3d (function (tcoll,key){\nreturn cljs.core._dissoc_BANG_(tcoll,key);\n});\n\ncljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (tcoll,key,ks){\nwhile(true){\nvar ntcoll \x3d cljs.core._dissoc_BANG_(tcoll,key);\nif(cljs.core.truth_(ks)){\nvar G__30377 \x3d ntcoll;\nvar G__30378 \x3d cljs.core.first(ks);\nvar G__30379 \x3d cljs.core.next(ks);\ntcoll \x3d G__30377;\nkey \x3d G__30378;\nks \x3d G__30379;\ncontinue;\n} else {\nreturn ntcoll;\n}\nbreak;\n}\n});\n\n/** @this {Function} */\ncljs.core.dissoc_BANG_.cljs$lang$applyTo \x3d (function (seq30369){\nvar G__30370 \x3d cljs.core.first(seq30369);\nvar seq30369__$1 \x3d cljs.core.next(seq30369);\nvar G__30371 \x3d cljs.core.first(seq30369__$1);\nvar seq30369__$2 \x3d cljs.core.next(seq30369__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30370,G__30371,seq30369__$2);\n});\n\ncljs.core.dissoc_BANG_.cljs$lang$maxFixedArity \x3d (2);\n\n/**\n * Removes the last item from a transient vector. If\n *   the collection is empty, throws an exception. Returns tcoll\n */\ncljs.core.pop_BANG_ \x3d (function cljs$core$pop_BANG_(tcoll){\nreturn cljs.core._pop_BANG_(tcoll);\n});\n/**\n * disj[oin]. Returns a transient set of the same (hashed/sorted) type, that\n *   does not contain key(s).\n */\ncljs.core.disj_BANG_ \x3d (function cljs$core$disj_BANG_(var_args){\nvar G__30384 \x3d arguments.length;\nswitch (G__30384) {\ncase 2:\nreturn cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ndefault:\nvar args_arr__4546__auto__ \x3d [];\nvar len__4531__auto___30386 \x3d arguments.length;\nvar i__4532__auto___30387 \x3d (0);\nwhile(true){\nif((i__4532__auto___30387 \x3c len__4531__auto___30386)){\nargs_arr__4546__auto__.push((arguments[i__4532__auto___30387]));\n\nvar G__30388 \x3d (i__4532__auto___30387 + (1));\ni__4532__auto___30387 \x3d G__30388;\ncontinue;\n} else {\n}\nbreak;\n}\n\nvar argseq__4547__auto__ \x3d (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));\nreturn cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);\n\n}\n});\n\ncljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 \x3d (function (tcoll,val){\nreturn cljs.core._disjoin_BANG_(tcoll,val);\n});\n\ncljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic \x3d (function (tcoll,val,vals){\nwhile(true){\nvar ntcoll \x3d cljs.core._disjoin_BANG_(tcoll,val);\nif(cljs.core.truth_(vals)){\nvar G__30389 \x3d ntcoll;\nvar G__30390 \x3d cljs.core.first(vals);\nvar G__30391 \x3d cljs.core.next(vals);\ntcoll \x3d G__30389;\nval \x3d G__30390;\nvals \x3d G__30391;\ncontinue;\n} else {\nreturn ntcoll;\n}\nbreak;\n}\n});\n\n/** @this {Function} */\ncljs.core.disj_BANG_.cljs$lang$applyTo \x3d (function (seq30381){\nvar G__30382 \x3d cljs.core.first(seq30381);\nvar seq30381__$1 \x3d cljs.core.next(seq30381);\nvar G__30383 \x3d cljs.core.first(seq30381__$1);\nvar seq30381__$2 \x3d cljs.core.next(seq30381__$1);\nvar self__4518__auto__ \x3d this;\nreturn self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30382,G__30383,seq30381__$2);\n});\n\ncljs.core.disj_BANG_.cljs$lang$maxFixedArity \x3d (2);\n\n\ncljs.core.apply_to \x3d (function cljs$core$apply_to(f,argc,args){\nvar args__$1 \x3d cljs.core.seq(args);\nif((argc \x3d\x3d\x3d (0))){\nreturn (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));\n} else {\nvar a1059 \x3d cljs.core._first(args__$1);\nvar args__$2 \x3d cljs.core._rest(args__$1);\nif((argc \x3d\x3d\x3d (1))){\nreturn (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(a1059) : f.call(null,a1059));\n} else {\nvar b1060 \x3d cljs.core._first(args__$2);\nvar args__$3 \x3d cljs.core._rest(args__$2);\nif((argc \x3d\x3d\x3d (2))){\nreturn (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(a1059,b1060) : f.call(null,a1059,b1060));\n} else {\nvar c1061 \x3d cljs.core._first(args__$3);\nvar args__$4 \x3d cljs.core._rest(args__$3);\nif((argc \x3d\x3d\x3d (3))){\nreturn (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(a1059,b1060,c1061) : f.call(null,a1059,b1060,c1061));\n} else {\nvar d1062 \x3d cljs.core._first(args__$4);\nvar args__$5 \x3d cljs.core._rest(args__$4);\nif((argc \x3d\x3d\x3d (4))){\nreturn (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(a1059,b1060,c1061,d1062) : f.call(null,a1059,b1060,c1061,d1062));\n} else {\nvar e1063 \x3d cljs.core._first(args__$5);\nvar args__$6 \x3d cljs.core._rest(args__$5);\nif((argc \x3d\x3d\x3d (5))){\nreturn (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(a1059,b1060,c1061,d1062,e1063) : f.call(null,a1059,b1060,c1061,d1062,e1063));\n} else {\nvar f1064 \x3d cljs.core._first(args__$6);\nvar args__$7 \x3d cljs.core._rest(args__$6);\nif((argc \x3d\x3d\x3d (6))){\nreturn (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(a1059,b1060,c1061,d1062,e1063,f1064) : f.call(null,a1059,b1060,c1061,d1062,e1063,f1064));\n} else {\nvar g1065 \x3d cljs.core._first(args__$7);\nvar args__$8 \x3d cljs.core._rest(args__$7);\nif((argc \x3d\x3d\x3d (7))){\nreturn (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(a1059,b1060,c1061,d1062,e1063,f1064,g1065) : f.call(null,a1059,b1060,c1061,d1062,e1063,f1064,g1065));\n} else {\nvar h1066 \x3d cljs.core._first(args__$8);\nvar args__$9 \x3d cljs.core._rest(args__$8);\nif((argc \x3d\x3d\x3d (8))){\nreturn (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(a1059,b1060,c1061,d1062,e1063,f1064,g1065,h1066) : f.call(null,a1059,b1060,c1061,d1062,e1063,f1064,g1065,h1066));\n} else {\nvar i1067 \x3d cljs.core._first(args__$9);\nvar args__$10 \x3d cljs.core._rest(args__$9);\nif((argc \x3d\x3d\x3d (9))){\nreturn (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(a1059,b1060,c1061,d1062,e1063,f1064,g1065,h1066,i1067) : f.call(null,a1059,b1060,c1061,d1062,e1063,f1064,g1065,h1066,i1067));\n} else {\nvar j1068 \x3d cljs.core._first(args__$10);\nvar args__$11 \x3d cljs.core._rest(args__$10);\nif((argc \x3d\x3d\x3d (10))){\nreturn (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(a1059,b1060,c1061,d1062,e1063,f1064,g1065,h1066,i1067,j1068) : f.call(null,a1059,b1060,c1061,d1062,e1063,f1064,g1065,h1066,i1067,j1068));\n} else {\nvar k1069 \x3d cljs.core._first(args__$11);\nvar args__$12 \x3d cljs.core._rest(args__$11);\nif((argc \x3d\x3d\x3d (11))){\nreturn (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(a1059,b1060,c1061,d1062,e1063,f1064,g1065,h1066,i1067,j1068,k1069) : f.call(null,a1059,b1060,c1061,d1062,e1063,f1064,g1065,h1066,i1067,j1068,k1069));\n} else {\nvar l1070 \x3d cljs.core._first(args__$12);\nvar args__$13 \x3d cljs.core._rest(args__$12);\nif((argc \x3d\x3d\x3d (12))){\nreturn (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(a1059,b1060,c1061,d1062,e1063,f1064,g1065,h1066,i1067,j1068,k1069,l1070) : f.call(null,a1059,b1060,c1061,d1062,e1063,f1064,g1065,h1066,i1067,j1068,k1069,l1070));\n} else {\nvar m1071 \x3d cljs.core._first(args__$13);\nvar args__$14 \x3d cljs.core._rest(args__$13);\nif((argc \x3d\x3d\x3d (13))){\nreturn (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(a1059,b1060,c1061,d1062,e1063,f1064,g1065,h1066,i1067,j1068,k1069,l1070,m1071) : f.call(null,a1059,b1060,c1061,d1062,e1063,f1064,g1065,h1066,i1067,j1068,k1069,l1070,m1071));\n} else {\nvar n1072 \x3d cljs.core._first(args__$14);\nvar args__$15 \x3d cljs.core._rest(args__$14);\nif((argc \x3d\x3d\x3d (14))){\nreturn (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(a1059,b1060,c1061,d1062,e1063,f1064,g1065,h1066,i1067,j1068,k1069,l1070,m1071,n1072) : f.call(null,a1059,b1060,c1061,d1062,e1063,f1064,g1065,h1066,i1067,j1068,k1069,l1070,m1071,n1072));\n} else {\nvar o1073 \x3d cljs.core._first(args__$15);\nvar args__$16 \x3d cljs.core._rest(args__$15);\nif((argc \x3d\x3d\x3d (15))){\nreturn (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(a1059,b1060,c1061,d1062,e1063,f1064,g1065,h1066,i1067,j1068,k1069,l1070,m1071,n1072,o1073) : f.call(null,a1059,b1060,c1061,d1062,e1063,f1064,g1065,h1066,i1067,j1068,k1069,l1070,m1071,n1072,o1073));\n} else {\nvar p1074 \x3d cljs.core._first(args__$16);\nvar args__$17 \x3d cljs.core._rest(args__$16);\nif((argc \x3d\x3d\x3d (16))){\nreturn (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(a1059,b1060,c1061,d1062,e1063,f1064,g1065,h1066,i1067,j1068,k1069,l1070,m1071,n1072,o1073,p1074) : f.call(null,a1059,b1060,c1061,d1062,e1063,f1064,g1065,h1066,i1067,j1068,k1069,l1070,m1071,n1072,o1073,p1074));\n} else {\nvar q1075 \x3d cljs.core._first(args__$17);\nvar args__$18 \x3d cljs.core._rest(args__$17);\nif((argc \x3d\x3d\x3d (17))){\nreturn (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(a1059,b1060,c1061,d1062,e1063,f1064,g1065,h1066,i1067,j1068,k1069,l1070,m1071,n1072,o1073,p1074,q1075) : f.call(null,a1059,b1060,c1061,d1062,e1063,f1064,g1065,h1066,i1067,j1068,k1069,l1070,m1071,n1072,o1073,p1074,q1075));\n} else {\nvar r1076 \x3d cljs.core._first(args__$18);\nvar args__$19 \x3d cljs.core._rest(args__$18);\nif((argc \x3d\x3d\x3d (18))){\nreturn (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(a1059,b1060,c1061,d1062,e1063,f1064,g1065,h1066,i1067,j1068,k1069,l1070,m1071,n1072,o1073,p1074,q1075,r1076) : f.call(null,a1059,b1060,c1061,d1062,e1063,f1064,g1065,h1066,i1067,j1068,k1069,l1070,m1071,n1072,o1073,p1074,q1075,r1076));\n} else {\nvar s1077 \x3d cljs.core._first(args__$19);\nvar args__$20 \x3d cljs.core._rest(args__$19);\nif((argc \x3d\x3d\x3d (19))){\nreturn (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(a1059,b1060,c1061,d1062,e1063,f1064,g1065,h1066,i1067,j1068,k1069,l1070,m1071,n1072,o1073,p1074,q1075,r1076,s1077) : f.call(null,a1059,b1060,c1061,d1062,e1063,f1064,g1065,h1066,i1067,j1068,k1069,l1070,m1071,n1072,o1073,p1074,q1075,r1076,s1077));\n} else {\nvar t1078 \x3d cljs.core._first(args__$20);\nvar args__$21 \x3d cljs.core._rest(args__$20);\nif((argc \x3d\x3d\x3d (20))){\nreturn (f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(a1059,b1060,c1061,d1062,e1063,f1064,g1065,h1066,i1067,j1068,k1069,l1070,m1071,n1072,o1073,p1074,q1075,r1076,s1077,t1078) : f.call(null,a1059,b1060,c1061,d1062,e1063,f1064,g1065,h1066,i1067,j1068,k1069,l1070,m1071,n1072,o1073,p1074,q1075,r1076,s1077,t1078));\n} else {\nthrow (new Error(\x22Only up to 20 arguments supported on functions\x22));\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\n});\n\n/**\n * Internal. DO NOT USE!\n *   Assumes args was already called with seq beforehand!\n */\ncljs.core.apply_to_simple \x3d (function cljs$core$apply_to_simple(var_args){\nvar G__30393 \x3d arguments.length;\nswitch (G__30393) {\ncase 2:\nreturn cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));\n\nbreak;\ncase 3:\nreturn cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));\n\nbreak;\ncase 4:\nreturn cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));\n\nbreak;\ncase 5:\nreturn cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));\n\nbreak;\ncase 6:\nreturn cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));\n\nbreak;\ndefault:\nthrow (new Error([\x22Invalid arity: \x22,cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(\x27\x27)));\n\n}\n});\n\ncljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2 \x3d (function (f,args){\nif((args \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$0){\nreturn f.cljs$core$IFn$_invoke$arity$0();\n} else {\nreturn f.call(f);\n}\n} else {\nreturn cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(f,cljs.core._first(args),cljs.core.next(args));\n}\n});\n\ncljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3 \x3d (function (f,a0,args){\nif((args \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$1){\nreturn f.cljs$core$IFn$_invoke$arity$1(a0);\n} else {\nreturn f.call(f,a0);\n}\n} else {\nreturn cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(f,a0,cljs.core._first(args),cljs.core.next(args));\n}\n});\n\ncljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4 \x3d (function (f,a0,a1,args){\nif((args \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$2){\nreturn f.cljs$core$IFn$_invoke$arity$2(a0,a1);\n} else {\nreturn f.call(f,a0,a1);\n}\n} else {\nreturn cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(f,a0,a1,cljs.core._first(args),cljs.core.next(args));\n}\n});\n\ncljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5 \x3d (function (f,a0,a1,a2,args){\nif((args \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$3){\nreturn f.cljs$core$IFn$_invoke$arity$3(a0,a1,a2);\n} else {\nreturn f.call(f,a0,a1,a2);\n}\n} else {\nreturn cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(f,a0,a1,a2,cljs.core._first(args),cljs.core.next(args));\n}\n});\n\ncljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6 \x3d (function (f,a0,a1,a2,a3,args){\nif((args \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$4){\nreturn f.cljs$core$IFn$_invoke$arity$4(a0,a1,a2,a3);\n} else {\nreturn f.call(f,a0,a1,a2,a3);\n}\n} else {\nvar a4 \x3d cljs.core._first(args);\nvar next_4 \x3d cljs.core.next(args);\nif((next_4 \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$5){\nreturn f.cljs$core$IFn$_invoke$arity$5(a0,a1,a2,a3,a4);\n} else {\nreturn f.call(f,a0,a1,a2,a3,a4);\n}\n} else {\nvar a5 \x3d cljs.core._first(next_4);\nvar next_5 \x3d cljs.core.next(next_4);\nif((next_5 \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$6){\nreturn f.cljs$core$IFn$_invoke$arity$6(a0,a1,a2,a3,a4,a5);\n} else {\nreturn f.call(f,a0,a1,a2,a3,a4,a5);\n}\n} else {\nvar a6 \x3d cljs.core._first(next_5);\nvar next_6 \x3d cljs.core.next(next_5);\nif((next_6 \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$7){\nreturn f.cljs$core$IFn$_invoke$arity$7(a0,a1,a2,a3,a4,a5,a6);\n} else {\nreturn f.call(f,a0,a1,a2,a3,a4,a5,a6);\n}\n} else {\nvar a7 \x3d cljs.core._first(next_6);\nvar next_7 \x3d cljs.core.next(next_6);\nif((next_7 \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$8){\nreturn f.cljs$core$IFn$_invoke$arity$8(a0,a1,a2,a3,a4,a5,a6,a7);\n} else {\nreturn f.call(f,a0,a1,a2,a3,a4,a5,a6,a7);\n}\n} else {\nvar a8 \x3d cljs.core._first(next_7);\nvar next_8 \x3d cljs.core.next(next_7);\nif((next_8 \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$9){\nreturn f.cljs$core$IFn$_invoke$arity$9(a0,a1,a2,a3,a4,a5,a6,a7,a8);\n} else {\nreturn f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8);\n}\n} else {\nvar a9 \x3d cljs.core._first(next_8);\nvar next_9 \x3d cljs.core.next(next_8);\nif((next_9 \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$10){\nreturn f.cljs$core$IFn$_invoke$arity$10(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);\n} else {\nreturn f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);\n}\n} else {\nvar a10 \x3d cljs.core._first(next_9);\nvar next_10 \x3d cljs.core.next(next_9);\nif((next_10 \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$11){\nreturn f.cljs$core$IFn$_invoke$arity$11(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);\n} else {\nreturn f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);\n}\n} else {\nvar a11 \x3d cljs.core._first(next_10);\nvar next_11 \x3d cljs.core.next(next_10);\nif((next_11 \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$12){\nreturn f.cljs$core$IFn$_invoke$arity$12(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);\n} else {\nreturn f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);\n}\n} else {\nvar a12 \x3d cljs.core._first(next_11);\nvar next_12 \x3d cljs.core.next(next_11);\nif((next_12 \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$13){\nreturn f.cljs$core$IFn$_invoke$arity$13(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);\n} else {\nreturn f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);\n}\n} else {\nvar a13 \x3d cljs.core._first(next_12);\nvar next_13 \x3d cljs.core.next(next_12);\nif((next_13 \x3d\x3d null)){\nif(f.cljs$core$IFn$_invoke$arity$14){\nreturn f.cljs$core$IFn$_invoke$arity$14(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13);\n} else {\nreturn f.call(f,a0,a1,a2,a3,a4,a5,a6,a7