/*
 * Decompiled with CFR 0.152.
 */
package com.workiva.eva.client;

import clojure.java.api.Clojure;
import clojure.lang.IFn;
import clojure.lang.Keyword;
import com.workiva.eva.client.Connection;
import com.workiva.eva.client.Database;
import com.workiva.eva.client.EvaContext;
import com.workiva.eva.client.exceptions.EvaClientException;
import eva.Peer;
import eva.Util;
import java.util.Map;

public class Client {
    private static final IFn tempid;

    private Client() {
    }

    public static Connection connect(Map<Keyword, String> config2) {
        return new Connection(config2.get(Keyword.intern((String)"tenant")), config2.get(Keyword.intern((String)"category")), config2.get(Keyword.intern((String)"label")));
    }

    public static <T> T query(Object q2, Object ... args) throws EvaClientException {
        return Client.query(new EvaContext(), q2, args);
    }

    public static <T> T query(EvaContext ctx, Object q2, Object ... args) throws EvaClientException {
        Database db2 = null;
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof Database)) continue;
            db2 = (Database)args[i];
        }
        return (T)db2.query(ctx, q2, args);
    }

    public static <T> T query(String q2, Object ... args) throws EvaClientException {
        return Client.query(new EvaContext(), Util.read((String)q2), args);
    }

    public static <T> T query(EvaContext ctx, String q2, Object ... args) throws EvaClientException {
        return Client.query(ctx, Util.read((String)q2), args);
    }

    public static Long toTxEid(Long tx) {
        return Peer.toTxEid((Long)tx);
    }

    public static Object tempid(Object partition) {
        return tempid.invoke(partition);
    }

    public static Object tempid(Object partition, long idNumber) {
        return tempid.invoke(partition, (Object)idNumber);
    }

    static {
        IFn require = Clojure.var((Object)"clojure.core", (Object)"require");
        require.invoke(Clojure.read((String)"eva.client.core"));
        tempid = Clojure.var((Object)"eva.client.core", (Object)"tempid");
    }
}

