/*
 * Decompiled with CFR 0.152.
 */
package com.workiva.eva.client;

import clojure.java.api.Clojure;
import clojure.lang.IFn;
import clojure.lang.Keyword;
import clojure.lang.PersistentArrayMap;
import clojure.lang.PersistentVector;
import com.workiva.eva.client.Connection;
import com.workiva.eva.client.Database;
import com.workiva.eva.client.exceptions.ReferenceException;
import eva.Datom;
import eva.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdnSerializer {
    private static final Logger logger = LoggerFactory.getLogger(EdnSerializer.class);
    private static final IFn datomFunction;
    private static final IFn dbFn;
    private static final IFn prnStrVar;
    private Map<String, Function> deserializers;
    private static final Keyword LABEL_KEY;
    private static final Keyword AS_OF_KEY;
    private static final Keyword AS_OF_T_KEY;
    private static final Keyword BASIS_T_KEY;
    private static final Keyword SNAPSHOT_T_KEY;

    public EdnSerializer(final String tenant, final String category) {
        this.deserializers = new HashMap<String, Function>(){
            {
                this.put("eva.functions.DBFn", param -> EdnSerializer.createDBFn(param));
                this.put("datom", param -> EdnSerializer.createDatom(param));
                this.put("eva.client.service/snapshot-ref", param -> EdnSerializer.createDbRef(param, tenant, category));
                this.put("eva.client.service/connection-ref", param -> EdnSerializer.createConnRef(param, tenant, category));
                this.put("object", param -> EdnSerializer.this.objectStringifier(param));
            }
        };
    }

    private String objectStringifier(Object obj) {
        logger.warn("Converting #object EDN tag to String.");
        return obj.toString();
    }

    public String serialize(Object obj) {
        return (String)prnStrVar.invoke(obj);
    }

    public <T> T deserialize(String obj) {
        return (T)Util.read(this.deserializers, (String)obj);
    }

    private static Object createDBFn(Object param) {
        PersistentArrayMap dbFnMap = (PersistentArrayMap)param;
        return dbFn.invoke((Object)dbFnMap);
    }

    private static Datom createDatom(Object param) {
        PersistentVector datomVec = (PersistentVector)param;
        return (Datom)datomFunction.applyTo(datomVec.seq());
    }

    private static Database createDbRef(Object param, String tenant, String category) {
        if (param instanceof Map) {
            Map dbMap = (Map)param;
            String label2 = (String)dbMap.get(LABEL_KEY);
            Long asOf = (Long)dbMap.get(AS_OF_KEY);
            Long asOfT = (Long)dbMap.get(AS_OF_T_KEY);
            Long basisT = (Long)dbMap.get(BASIS_T_KEY);
            Long snapshotT = (Long)dbMap.get(SNAPSHOT_T_KEY);
            return new Database(tenant, category, label2, asOf, false, asOfT, basisT, snapshotT);
        }
        throw new ReferenceException("Unsupported Database Reference type");
    }

    private static Connection createConnRef(Object param, String tenant, String category) {
        if (param instanceof Map) {
            Map connMap = (Map)param;
            Keyword labelKey = Keyword.intern((String)"label");
            String label2 = (String)connMap.get(labelKey);
            return new Connection(tenant, category, label2);
        }
        throw new ReferenceException("Unsupported Connection Reference type");
    }

    static {
        prnStrVar = Clojure.var((Object)"clojure.core", (Object)"pr-str");
        LABEL_KEY = Keyword.intern((String)"label");
        AS_OF_KEY = Keyword.intern((String)"as-of");
        AS_OF_T_KEY = Keyword.intern((String)"as-of-t");
        BASIS_T_KEY = Keyword.intern((String)"basis-t");
        SNAPSHOT_T_KEY = Keyword.intern((String)"snapshot-t");
        IFn require = Clojure.var((Object)"clojure.core", (Object)"require");
        require.invoke(Clojure.read((String)"eva.datom"));
        datomFunction = Clojure.var((Object)"eva.datom", (Object)"datom");
        require.invoke(Clojure.read((String)"eva.functions"));
        dbFn = Clojure.var((Object)"eva.functions", (Object)"compile-db-fn");
        require.invoke(Clojure.read((String)"eva.client.reference"));
        require.invoke(Clojure.read((String)"eva.client.inline_function"));
        require.invoke(Clojure.read((String)"eva.client.functions"));
    }
}

