/*
 * Decompiled with CFR 0.152.
 */
package com.workiva.eva.client;

import com.workiva.eva.client.HttpTracingCarrier;
import io.opentracing.SpanContext;
import io.opentracing.propagation.Format;
import io.opentracing.util.GlobalTracer;
import java.util.UUID;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(EvaContext.class);
    private final String correlationId;
    private SpanContext spanContext;

    public EvaContext() {
        this(UUID.randomUUID().toString());
        LOGGER.warn(String.format("Correlation ID was not provided to Eva Client Library! Generating one to correlate Eva and ECS logs - %s", this.correlationId));
    }

    public EvaContext(String correlationId) {
        this.correlationId = correlationId;
    }

    public EvaContext(String correlationId, SpanContext spanContext) {
        this(correlationId);
        this.setSpanContext(spanContext);
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setSpanContext(SpanContext spanContext) {
        this.spanContext = spanContext;
    }

    public SpanContext getSpanContext() {
        return this.spanContext;
    }

    void addTracingHeaders(HttpRequestBase request) {
        if (this.spanContext != null) {
            GlobalTracer.get().inject(this.spanContext, Format.Builtin.HTTP_HEADERS, (Object)new HttpTracingCarrier(request));
        }
    }
}

