/*
 * Decompiled with CFR 0.152.
 */
package com.workiva.eva.client;

import com.workiva.eva.client.EvaClient;
import com.workiva.eva.client.EvaHttpClientHelper;
import com.workiva.eva.client.exceptions.EvaClientException;
import java.io.IOException;
import java.util.concurrent.Future;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaHttpClient
extends EvaClient {
    private static final Logger logger = LoggerFactory.getLogger(EvaHttpClient.class);
    private CloseableHttpAsyncClient asyncClient;
    private final String url;

    public EvaHttpClient(String url) throws EvaClientException {
        DefaultConnectingIOReactor ioReactor;
        this.url = url;
        try {
            ioReactor = new DefaultConnectingIOReactor();
        }
        catch (IOException e) {
            throw new EvaClientException("Unable to create Eva Http Client.", e.getCause());
        }
        PoolingNHttpClientConnectionManager asyncConnectionManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
        this.asyncClient = HttpAsyncClients.custom().setConnectionManager((NHttpClientConnectionManager)asyncConnectionManager).build();
        this.asyncClient.start();
    }

    @Override
    public void close() throws IOException {
        this.asyncClient.close();
        EvaClient.evaClient = null;
    }

    @Override
    EvaHttpClientHelper buildClientHelper(String tenant, String category, String label2) {
        return new EvaHttpClientHelper(this.url, tenant, category, label2);
    }

    Future<HttpResponse> execute(Object requestObj) {
        HttpRequestBase request = (HttpRequestBase)requestObj;
        logger.debug("Request uri: {}", (Object)request.getURI());
        Future result = this.asyncClient.execute((HttpUriRequest)request, (FutureCallback)new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse response) {
                logger.debug("Client Service responded with status code: {}", (Object)response.getStatusLine().getStatusCode());
            }

            public void failed(Exception e) {
                logger.error("Eva Http Client request encountered an error.", (Throwable)e);
            }

            public void cancelled() {
                logger.warn("Eva Http Client request was cancelled.");
            }
        });
        return result;
    }
}

