/*
 * Decompiled with CFR 0.152.
 */
package com.workiva.eva.client;

import com.workiva.eva.client.EvaClientHelper;
import com.workiva.eva.client.EvaContext;
import com.workiva.eva.client.Reference;
import io.opentracing.SpanContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.http.Header;

public abstract class RequestBuilder<T extends RequestBuilder<T, V>, V> {
    private String correlationId;
    private SpanContext spanContext = null;
    private EvaContext ctx;
    private List<Header> headers = new ArrayList<Header>();
    protected EvaClientHelper clientHelper;

    protected RequestBuilder(Reference reference2) {
        this.clientHelper = reference2.clientHelper;
    }

    public T withRequestHeaders(Header ... headers) {
        return this.withRequestHeaders(Arrays.asList(headers));
    }

    public T withRequestHeaders(List<Header> headers) {
        this.headers.addAll(headers);
        return (T)this;
    }

    public T withRequestHeader(Header header2) {
        this.headers.add(header2);
        return (T)this;
    }

    public T withCorrelationId(String correlationId) {
        this.correlationId = correlationId;
        return (T)this;
    }

    public T withSpanContext(SpanContext spanContext) {
        this.spanContext = spanContext;
        return (T)this;
    }

    protected List<Header> getRequestHeaders() {
        return this.headers;
    }

    protected EvaContext buildContext() {
        if (this.correlationId == null) {
            this.ctx = new EvaContext();
            this.ctx.setSpanContext(this.spanContext);
        } else {
            this.ctx = new EvaContext(this.correlationId);
        }
        return this.ctx;
    }

    public abstract V execute();
}

