goog.provide('shadow.dom');
goog.require('cljs.core');
goog.require('goog.dom');
goog.require('goog.dom.forms');
goog.require('goog.dom.classlist');
goog.require('goog.style');
goog.require('goog.style.transition');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('cljs.core.async');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
var x__4487__auto__ = (((this$ == null))?null:this$);
var m__4488__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,this$);
} else {
var m__4485__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IElement.-to-dom",this$);
}
}
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
var x__4487__auto__ = (((this$ == null))?null:this$);
var m__4488__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,this$);
} else {
var m__4485__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"SVGElement.-to-svg",this$);
}
}
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons.call(null,(coll[idx]),shadow.dom.lazy_native_coll_seq.call(null,coll,(idx + (1))));
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4185__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq.call(null,self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return shadow.dom._to_dom.call(null,el);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__46162 = arguments.length;
switch (G__46162) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node.call(null,root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__46167 = arguments.length;
switch (G__46167) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__46174 = arguments.length;
switch (G__46174) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node.call(null,el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__46182 = arguments.length;
switch (G__46182) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.call(null,e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.call(null,e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__46203 = arguments.length;
switch (G__46203) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node.call(null,el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node.call(null,parent),shadow.dom.dom_node.call(null,el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__46218 = arguments.length;
switch (G__46218) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node.call(null,el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class.call(null,el,cls);
} else {
return shadow.dom.remove_class.call(null,el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4185__auto__ = (!((typeof document !== 'undefined')));
if(or__4185__auto__){
return or__4185__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return handler.call(null,e,el);
}));
}catch (e46229){if((e46229 instanceof Object)){
var e = e46229;
return console.log("didnt support attachEvent",el,e);
} else {
throw e46229;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4185__auto__ = (!((typeof document !== 'undefined')));
if(or__4185__auto__){
return or__4185__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__46242 = cljs.core.seq.call(null,shadow.dom.query.call(null,selector,root_el));
var chunk__46243 = null;
var count__46244 = (0);
var i__46245 = (0);
while(true){
if((i__46245 < count__46244)){
var el = cljs.core._nth.call(null,chunk__46243,i__46245);
var handler_47125__$1 = ((function (seq__46242,chunk__46243,count__46244,i__46245,el){
return (function (e){
return handler.call(null,e,el);
});})(seq__46242,chunk__46243,count__46244,i__46245,el))
;
shadow.dom.dom_listen.call(null,el,cljs.core.name.call(null,ev),handler_47125__$1);


var G__47128 = seq__46242;
var G__47129 = chunk__46243;
var G__47130 = count__46244;
var G__47131 = (i__46245 + (1));
seq__46242 = G__47128;
chunk__46243 = G__47129;
count__46244 = G__47130;
i__46245 = G__47131;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__46242);
if(temp__5735__auto__){
var seq__46242__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46242__$1)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,seq__46242__$1);
var G__47134 = cljs.core.chunk_rest.call(null,seq__46242__$1);
var G__47135 = c__4609__auto__;
var G__47136 = cljs.core.count.call(null,c__4609__auto__);
var G__47137 = (0);
seq__46242 = G__47134;
chunk__46243 = G__47135;
count__46244 = G__47136;
i__46245 = G__47137;
continue;
} else {
var el = cljs.core.first.call(null,seq__46242__$1);
var handler_47139__$1 = ((function (seq__46242,chunk__46243,count__46244,i__46245,el,seq__46242__$1,temp__5735__auto__){
return (function (e){
return handler.call(null,e,el);
});})(seq__46242,chunk__46243,count__46244,i__46245,el,seq__46242__$1,temp__5735__auto__))
;
shadow.dom.dom_listen.call(null,el,cljs.core.name.call(null,ev),handler_47139__$1);


var G__47140 = cljs.core.next.call(null,seq__46242__$1);
var G__47141 = null;
var G__47142 = (0);
var G__47143 = (0);
seq__46242 = G__47140;
chunk__46243 = G__47141;
count__46244 = G__47142;
i__46245 = G__47143;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__46268 = arguments.length;
switch (G__46268) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.call(null,el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_.call(null,ev)){
return shadow.dom.on_query.call(null,el,cljs.core.first.call(null,ev),cljs.core.second.call(null,ev),handler);
} else {
var handler__$1 = (function (e){
return handler.call(null,e,el);
});
return shadow.dom.dom_listen.call(null,shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove.call(null,shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__46285 = cljs.core.seq.call(null,events);
var chunk__46286 = null;
var count__46287 = (0);
var i__46288 = (0);
while(true){
if((i__46288 < count__46287)){
var vec__46308 = cljs.core._nth.call(null,chunk__46286,i__46288);
var k = cljs.core.nth.call(null,vec__46308,(0),null);
var v = cljs.core.nth.call(null,vec__46308,(1),null);
shadow.dom.on.call(null,el,k,v);


var G__47158 = seq__46285;
var G__47159 = chunk__46286;
var G__47160 = count__46287;
var G__47161 = (i__46288 + (1));
seq__46285 = G__47158;
chunk__46286 = G__47159;
count__46287 = G__47160;
i__46288 = G__47161;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__46285);
if(temp__5735__auto__){
var seq__46285__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46285__$1)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,seq__46285__$1);
var G__47163 = cljs.core.chunk_rest.call(null,seq__46285__$1);
var G__47164 = c__4609__auto__;
var G__47165 = cljs.core.count.call(null,c__4609__auto__);
var G__47166 = (0);
seq__46285 = G__47163;
chunk__46286 = G__47164;
count__46287 = G__47165;
i__46288 = G__47166;
continue;
} else {
var vec__46316 = cljs.core.first.call(null,seq__46285__$1);
var k = cljs.core.nth.call(null,vec__46316,(0),null);
var v = cljs.core.nth.call(null,vec__46316,(1),null);
shadow.dom.on.call(null,el,k,v);


var G__47170 = cljs.core.next.call(null,seq__46285__$1);
var G__47171 = null;
var G__47172 = (0);
var G__47173 = (0);
seq__46285 = G__47170;
chunk__46286 = G__47171;
count__46287 = G__47172;
i__46288 = G__47173;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node.call(null,el);
var seq__46326 = cljs.core.seq.call(null,styles);
var chunk__46327 = null;
var count__46328 = (0);
var i__46329 = (0);
while(true){
if((i__46329 < count__46328)){
var vec__46349 = cljs.core._nth.call(null,chunk__46327,i__46329);
var k = cljs.core.nth.call(null,vec__46349,(0),null);
var v = cljs.core.nth.call(null,vec__46349,(1),null);
goog.style.setStyle(dom,cljs.core.name.call(null,k),(((v == null))?"":v));


var G__47175 = seq__46326;
var G__47176 = chunk__46327;
var G__47177 = count__46328;
var G__47178 = (i__46329 + (1));
seq__46326 = G__47175;
chunk__46327 = G__47176;
count__46328 = G__47177;
i__46329 = G__47178;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__46326);
if(temp__5735__auto__){
var seq__46326__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46326__$1)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,seq__46326__$1);
var G__47180 = cljs.core.chunk_rest.call(null,seq__46326__$1);
var G__47181 = c__4609__auto__;
var G__47182 = cljs.core.count.call(null,c__4609__auto__);
var G__47183 = (0);
seq__46326 = G__47180;
chunk__46327 = G__47181;
count__46328 = G__47182;
i__46329 = G__47183;
continue;
} else {
var vec__46358 = cljs.core.first.call(null,seq__46326__$1);
var k = cljs.core.nth.call(null,vec__46358,(0),null);
var v = cljs.core.nth.call(null,vec__46358,(1),null);
goog.style.setStyle(dom,cljs.core.name.call(null,k),(((v == null))?"":v));


var G__47187 = cljs.core.next.call(null,seq__46326__$1);
var G__47188 = null;
var G__47189 = (0);
var G__47190 = (0);
seq__46326 = G__47187;
chunk__46327 = G__47188;
count__46328 = G__47189;
i__46329 = G__47190;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__46368_47193 = key;
var G__46368_47194__$1 = (((G__46368_47193 instanceof cljs.core.Keyword))?G__46368_47193.fqn:null);
switch (G__46368_47194__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners.call(null,el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_.call(null,value)){
shadow.dom.set_style.call(null,el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_47203 = cljs.core.name.call(null,key);
if(cljs.core.truth_((function (){var or__4185__auto__ = goog.string.startsWith(ks_47203,"data-");
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return goog.string.startsWith(ks_47203,"aria-");
}
})())){
el.setAttribute(ks_47203,value);
} else {
(el[ks_47203] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv.call(null,(function (el__$1,key,value){
shadow.dom.set_attr_STAR_.call(null,el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node.call(null,el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_.call(null,shadow.dom.dom_node.call(null,el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq.call(null,current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name.call(null,spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.call(null,(-1),fdot)) && (cljs.core._EQ_.call(null,(-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.call(null,(-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace.call(null,spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.call(null,(-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace.call(null,spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__46403){
var map__46404 = p__46403;
var map__46404__$1 = (((((!((map__46404 == null))))?(((((map__46404.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46404.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46404):map__46404);
var props = map__46404__$1;
var class$ = cljs.core.get.call(null,map__46404__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__46411 = shadow.dom.parse_tag.call(null,tag_def);
var tag_name = cljs.core.nth.call(null,vec__46411,(0),null);
var tag_id = cljs.core.nth.call(null,vec__46411,(1),null);
var tag_classes = cljs.core.nth.call(null,vec__46411,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string.call(null,class$,tag_classes));
} else {
}

var G__46416 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs.call(null,G__46416,cljs.core.dissoc.call(null,props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__46416;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__46425 = arguments.length;
switch (G__46425) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5735__auto__ = shadow.dom.dom_node.call(null,node);
if(cljs.core.truth_(temp__5735__auto__)){
var n = temp__5735__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5735__auto__ = shadow.dom.dom_node.call(null,node);
if(cljs.core.truth_(temp__5735__auto__)){
var n = temp__5735__auto__;
shadow.dom.dom_node.call(null,el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__46443){
var vec__46445 = p__46443;
var seq__46446 = cljs.core.seq.call(null,vec__46445);
var first__46447 = cljs.core.first.call(null,seq__46446);
var seq__46446__$1 = cljs.core.next.call(null,seq__46446);
var nn = first__46447;
var first__46447__$1 = cljs.core.first.call(null,seq__46446__$1);
var seq__46446__$2 = cljs.core.next.call(null,seq__46446__$1);
var np = first__46447__$1;
var nc = seq__46446__$2;
var node = vec__46445;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.call(null,"invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [create_fn.call(null,nn,cljs.core.PersistentArrayMap.EMPTY),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_.call(null,np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [create_fn.call(null,nn,np),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [create_fn.call(null,nn,cljs.core.PersistentArrayMap.EMPTY),cljs.core.conj.call(null,nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__46463 = shadow.dom.destructure_node.call(null,shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.call(null,vec__46463,(0),null);
var node_children = cljs.core.nth.call(null,vec__46463,(1),null);
var seq__46467_47240 = cljs.core.seq.call(null,node_children);
var chunk__46468_47241 = null;
var count__46469_47242 = (0);
var i__46470_47243 = (0);
while(true){
if((i__46470_47243 < count__46469_47242)){
var child_struct_47245 = cljs.core._nth.call(null,chunk__46468_47241,i__46470_47243);
var children_47246 = shadow.dom.dom_node.call(null,child_struct_47245);
if(cljs.core.seq_QMARK_.call(null,children_47246)){
var seq__46529_47247 = cljs.core.seq.call(null,cljs.core.map.call(null,shadow.dom.dom_node,children_47246));
var chunk__46532_47248 = null;
var count__46533_47249 = (0);
var i__46534_47250 = (0);
while(true){
if((i__46534_47250 < count__46533_47249)){
var child_47251 = cljs.core._nth.call(null,chunk__46532_47248,i__46534_47250);
if(cljs.core.truth_(child_47251)){
shadow.dom.append.call(null,node,child_47251);


var G__47252 = seq__46529_47247;
var G__47253 = chunk__46532_47248;
var G__47254 = count__46533_47249;
var G__47255 = (i__46534_47250 + (1));
seq__46529_47247 = G__47252;
chunk__46532_47248 = G__47253;
count__46533_47249 = G__47254;
i__46534_47250 = G__47255;
continue;
} else {
var G__47257 = seq__46529_47247;
var G__47258 = chunk__46532_47248;
var G__47259 = count__46533_47249;
var G__47260 = (i__46534_47250 + (1));
seq__46529_47247 = G__47257;
chunk__46532_47248 = G__47258;
count__46533_47249 = G__47259;
i__46534_47250 = G__47260;
continue;
}
} else {
var temp__5735__auto___47261 = cljs.core.seq.call(null,seq__46529_47247);
if(temp__5735__auto___47261){
var seq__46529_47264__$1 = temp__5735__auto___47261;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46529_47264__$1)){
var c__4609__auto___47265 = cljs.core.chunk_first.call(null,seq__46529_47264__$1);
var G__47267 = cljs.core.chunk_rest.call(null,seq__46529_47264__$1);
var G__47268 = c__4609__auto___47265;
var G__47269 = cljs.core.count.call(null,c__4609__auto___47265);
var G__47270 = (0);
seq__46529_47247 = G__47267;
chunk__46532_47248 = G__47268;
count__46533_47249 = G__47269;
i__46534_47250 = G__47270;
continue;
} else {
var child_47272 = cljs.core.first.call(null,seq__46529_47264__$1);
if(cljs.core.truth_(child_47272)){
shadow.dom.append.call(null,node,child_47272);


var G__47273 = cljs.core.next.call(null,seq__46529_47264__$1);
var G__47274 = null;
var G__47275 = (0);
var G__47276 = (0);
seq__46529_47247 = G__47273;
chunk__46532_47248 = G__47274;
count__46533_47249 = G__47275;
i__46534_47250 = G__47276;
continue;
} else {
var G__47277 = cljs.core.next.call(null,seq__46529_47264__$1);
var G__47278 = null;
var G__47279 = (0);
var G__47280 = (0);
seq__46529_47247 = G__47277;
chunk__46532_47248 = G__47278;
count__46533_47249 = G__47279;
i__46534_47250 = G__47280;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.call(null,node,children_47246);
}


var G__47281 = seq__46467_47240;
var G__47282 = chunk__46468_47241;
var G__47283 = count__46469_47242;
var G__47284 = (i__46470_47243 + (1));
seq__46467_47240 = G__47281;
chunk__46468_47241 = G__47282;
count__46469_47242 = G__47283;
i__46470_47243 = G__47284;
continue;
} else {
var temp__5735__auto___47286 = cljs.core.seq.call(null,seq__46467_47240);
if(temp__5735__auto___47286){
var seq__46467_47288__$1 = temp__5735__auto___47286;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46467_47288__$1)){
var c__4609__auto___47289 = cljs.core.chunk_first.call(null,seq__46467_47288__$1);
var G__47290 = cljs.core.chunk_rest.call(null,seq__46467_47288__$1);
var G__47291 = c__4609__auto___47289;
var G__47292 = cljs.core.count.call(null,c__4609__auto___47289);
var G__47293 = (0);
seq__46467_47240 = G__47290;
chunk__46468_47241 = G__47291;
count__46469_47242 = G__47292;
i__46470_47243 = G__47293;
continue;
} else {
var child_struct_47294 = cljs.core.first.call(null,seq__46467_47288__$1);
var children_47295 = shadow.dom.dom_node.call(null,child_struct_47294);
if(cljs.core.seq_QMARK_.call(null,children_47295)){
var seq__46559_47296 = cljs.core.seq.call(null,cljs.core.map.call(null,shadow.dom.dom_node,children_47295));
var chunk__46561_47297 = null;
var count__46562_47298 = (0);
var i__46563_47299 = (0);
while(true){
if((i__46563_47299 < count__46562_47298)){
var child_47301 = cljs.core._nth.call(null,chunk__46561_47297,i__46563_47299);
if(cljs.core.truth_(child_47301)){
shadow.dom.append.call(null,node,child_47301);


var G__47302 = seq__46559_47296;
var G__47303 = chunk__46561_47297;
var G__47304 = count__46562_47298;
var G__47305 = (i__46563_47299 + (1));
seq__46559_47296 = G__47302;
chunk__46561_47297 = G__47303;
count__46562_47298 = G__47304;
i__46563_47299 = G__47305;
continue;
} else {
var G__47306 = seq__46559_47296;
var G__47307 = chunk__46561_47297;
var G__47308 = count__46562_47298;
var G__47309 = (i__46563_47299 + (1));
seq__46559_47296 = G__47306;
chunk__46561_47297 = G__47307;
count__46562_47298 = G__47308;
i__46563_47299 = G__47309;
continue;
}
} else {
var temp__5735__auto___47310__$1 = cljs.core.seq.call(null,seq__46559_47296);
if(temp__5735__auto___47310__$1){
var seq__46559_47312__$1 = temp__5735__auto___47310__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46559_47312__$1)){
var c__4609__auto___47313 = cljs.core.chunk_first.call(null,seq__46559_47312__$1);
var G__47315 = cljs.core.chunk_rest.call(null,seq__46559_47312__$1);
var G__47316 = c__4609__auto___47313;
var G__47317 = cljs.core.count.call(null,c__4609__auto___47313);
var G__47318 = (0);
seq__46559_47296 = G__47315;
chunk__46561_47297 = G__47316;
count__46562_47298 = G__47317;
i__46563_47299 = G__47318;
continue;
} else {
var child_47321 = cljs.core.first.call(null,seq__46559_47312__$1);
if(cljs.core.truth_(child_47321)){
shadow.dom.append.call(null,node,child_47321);


var G__47322 = cljs.core.next.call(null,seq__46559_47312__$1);
var G__47323 = null;
var G__47324 = (0);
var G__47325 = (0);
seq__46559_47296 = G__47322;
chunk__46561_47297 = G__47323;
count__46562_47298 = G__47324;
i__46563_47299 = G__47325;
continue;
} else {
var G__47326 = cljs.core.next.call(null,seq__46559_47312__$1);
var G__47327 = null;
var G__47328 = (0);
var G__47329 = (0);
seq__46559_47296 = G__47326;
chunk__46561_47297 = G__47327;
count__46562_47298 = G__47328;
i__46563_47299 = G__47329;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.call(null,node,children_47295);
}


var G__47331 = cljs.core.next.call(null,seq__46467_47288__$1);
var G__47332 = null;
var G__47333 = (0);
var G__47334 = (0);
seq__46467_47240 = G__47331;
chunk__46468_47241 = G__47332;
count__46469_47242 = G__47333;
i__46470_47243 = G__47334;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node.call(null,this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.call(null,shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node.call(null,node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__46589 = cljs.core.seq.call(null,node);
var chunk__46590 = null;
var count__46591 = (0);
var i__46592 = (0);
while(true){
if((i__46592 < count__46591)){
var n = cljs.core._nth.call(null,chunk__46590,i__46592);
shadow.dom.remove.call(null,n);


var G__47342 = seq__46589;
var G__47343 = chunk__46590;
var G__47344 = count__46591;
var G__47345 = (i__46592 + (1));
seq__46589 = G__47342;
chunk__46590 = G__47343;
count__46591 = G__47344;
i__46592 = G__47345;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__46589);
if(temp__5735__auto__){
var seq__46589__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46589__$1)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,seq__46589__$1);
var G__47346 = cljs.core.chunk_rest.call(null,seq__46589__$1);
var G__47347 = c__4609__auto__;
var G__47348 = cljs.core.count.call(null,c__4609__auto__);
var G__47349 = (0);
seq__46589 = G__47346;
chunk__46590 = G__47347;
count__46591 = G__47348;
i__46592 = G__47349;
continue;
} else {
var n = cljs.core.first.call(null,seq__46589__$1);
shadow.dom.remove.call(null,n);


var G__47350 = cljs.core.next.call(null,seq__46589__$1);
var G__47351 = null;
var G__47352 = (0);
var G__47353 = (0);
seq__46589 = G__47350;
chunk__46590 = G__47351;
count__46591 = G__47352;
i__46592 = G__47353;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node.call(null,new$),shadow.dom.dom_node.call(null,old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__46609 = arguments.length;
switch (G__46609) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node.call(null,el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node.call(null,el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__46616 = arguments.length;
switch (G__46616) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.call(null,el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node.call(null,el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node.call(null,el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__46631 = arguments.length;
switch (G__46631) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node.call(null,el).getAttribute(cljs.core.name.call(null,key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4185__auto__ = shadow.dom.dom_node.call(null,el).getAttribute(cljs.core.name.call(null,key));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node.call(null,el).removeAttribute(cljs.core.name.call(null,key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node.call(null,el).getAttribute(["data-",cljs.core.name.call(null,key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node.call(null,el).setAttribute(["data-",cljs.core.name.call(null,key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node.call(null,node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node.call(null,node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4795__auto__ = [];
var len__4789__auto___47367 = arguments.length;
var i__4790__auto___47368 = (0);
while(true){
if((i__4790__auto___47368 < len__4789__auto___47367)){
args__4795__auto__.push((arguments[i__4790__auto___47368]));

var G__47373 = (i__4790__auto___47368 + (1));
i__4790__auto___47368 = G__47373;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((0) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4796__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__46670_47375 = cljs.core.seq.call(null,nodes);
var chunk__46671_47376 = null;
var count__46672_47377 = (0);
var i__46673_47378 = (0);
while(true){
if((i__46673_47378 < count__46672_47377)){
var node_47379 = cljs.core._nth.call(null,chunk__46671_47376,i__46673_47378);
fragment.appendChild(shadow.dom._to_dom.call(null,node_47379));


var G__47380 = seq__46670_47375;
var G__47381 = chunk__46671_47376;
var G__47382 = count__46672_47377;
var G__47383 = (i__46673_47378 + (1));
seq__46670_47375 = G__47380;
chunk__46671_47376 = G__47381;
count__46672_47377 = G__47382;
i__46673_47378 = G__47383;
continue;
} else {
var temp__5735__auto___47384 = cljs.core.seq.call(null,seq__46670_47375);
if(temp__5735__auto___47384){
var seq__46670_47385__$1 = temp__5735__auto___47384;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46670_47385__$1)){
var c__4609__auto___47387 = cljs.core.chunk_first.call(null,seq__46670_47385__$1);
var G__47388 = cljs.core.chunk_rest.call(null,seq__46670_47385__$1);
var G__47389 = c__4609__auto___47387;
var G__47390 = cljs.core.count.call(null,c__4609__auto___47387);
var G__47391 = (0);
seq__46670_47375 = G__47388;
chunk__46671_47376 = G__47389;
count__46672_47377 = G__47390;
i__46673_47378 = G__47391;
continue;
} else {
var node_47392 = cljs.core.first.call(null,seq__46670_47385__$1);
fragment.appendChild(shadow.dom._to_dom.call(null,node_47392));


var G__47393 = cljs.core.next.call(null,seq__46670_47385__$1);
var G__47394 = null;
var G__47395 = (0);
var G__47396 = (0);
seq__46670_47375 = G__47393;
chunk__46671_47376 = G__47394;
count__46672_47377 = G__47395;
i__46673_47378 = G__47396;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq46646){
var self__4777__auto__ = this;
return self__4777__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq46646));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq.call(null,/<script[^>]*?>(.+?)<\/script>/,s);
var seq__46686_47398 = cljs.core.seq.call(null,scripts);
var chunk__46687_47399 = null;
var count__46688_47400 = (0);
var i__46689_47401 = (0);
while(true){
if((i__46689_47401 < count__46688_47400)){
var vec__46700_47402 = cljs.core._nth.call(null,chunk__46687_47399,i__46689_47401);
var script_tag_47403 = cljs.core.nth.call(null,vec__46700_47402,(0),null);
var script_body_47404 = cljs.core.nth.call(null,vec__46700_47402,(1),null);
eval(script_body_47404);


var G__47406 = seq__46686_47398;
var G__47407 = chunk__46687_47399;
var G__47408 = count__46688_47400;
var G__47409 = (i__46689_47401 + (1));
seq__46686_47398 = G__47406;
chunk__46687_47399 = G__47407;
count__46688_47400 = G__47408;
i__46689_47401 = G__47409;
continue;
} else {
var temp__5735__auto___47410 = cljs.core.seq.call(null,seq__46686_47398);
if(temp__5735__auto___47410){
var seq__46686_47411__$1 = temp__5735__auto___47410;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46686_47411__$1)){
var c__4609__auto___47412 = cljs.core.chunk_first.call(null,seq__46686_47411__$1);
var G__47413 = cljs.core.chunk_rest.call(null,seq__46686_47411__$1);
var G__47414 = c__4609__auto___47412;
var G__47415 = cljs.core.count.call(null,c__4609__auto___47412);
var G__47416 = (0);
seq__46686_47398 = G__47413;
chunk__46687_47399 = G__47414;
count__46688_47400 = G__47415;
i__46689_47401 = G__47416;
continue;
} else {
var vec__46705_47418 = cljs.core.first.call(null,seq__46686_47411__$1);
var script_tag_47419 = cljs.core.nth.call(null,vec__46705_47418,(0),null);
var script_body_47420 = cljs.core.nth.call(null,vec__46705_47418,(1),null);
eval(script_body_47420);


var G__47422 = cljs.core.next.call(null,seq__46686_47411__$1);
var G__47423 = null;
var G__47424 = (0);
var G__47425 = (0);
seq__46686_47398 = G__47422;
chunk__46687_47399 = G__47423;
count__46688_47400 = G__47424;
i__46689_47401 = G__47425;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.call(null,(function (s__$1,p__46709){
var vec__46711 = p__46709;
var script_tag = cljs.core.nth.call(null,vec__46711,(0),null);
var script_body = cljs.core.nth.call(null,vec__46711,(1),null);
return clojure.string.replace.call(null,s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node.call(null,el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__46733 = arguments.length;
switch (G__46733) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,tag),cljs.core.name.call(null,cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node.call(null,dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node.call(null,dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name.call(null,style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node.call(null,el);
return shadow.dom.remove_style_STAR_.call(null,el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node.call(null,el);
var seq__46743 = cljs.core.seq.call(null,style_keys);
var chunk__46744 = null;
var count__46745 = (0);
var i__46746 = (0);
while(true){
if((i__46746 < count__46745)){
var it = cljs.core._nth.call(null,chunk__46744,i__46746);
shadow.dom.remove_style_STAR_.call(null,el__$1,it);


var G__47436 = seq__46743;
var G__47437 = chunk__46744;
var G__47438 = count__46745;
var G__47439 = (i__46746 + (1));
seq__46743 = G__47436;
chunk__46744 = G__47437;
count__46745 = G__47438;
i__46746 = G__47439;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__46743);
if(temp__5735__auto__){
var seq__46743__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46743__$1)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,seq__46743__$1);
var G__47445 = cljs.core.chunk_rest.call(null,seq__46743__$1);
var G__47446 = c__4609__auto__;
var G__47447 = cljs.core.count.call(null,c__4609__auto__);
var G__47448 = (0);
seq__46743 = G__47445;
chunk__46744 = G__47446;
count__46745 = G__47447;
i__46746 = G__47448;
continue;
} else {
var it = cljs.core.first.call(null,seq__46743__$1);
shadow.dom.remove_style_STAR_.call(null,el__$1,it);


var G__47452 = cljs.core.next.call(null,seq__46743__$1);
var G__47453 = null;
var G__47454 = (0);
var G__47455 = (0);
seq__46743 = G__47452;
chunk__46744 = G__47453;
count__46745 = G__47454;
i__46746 = G__47455;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4439__auto__,k__4440__auto__){
var self__ = this;
var this__4439__auto____$1 = this;
return this__4439__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4440__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4441__auto__,k46759,else__4442__auto__){
var self__ = this;
var this__4441__auto____$1 = this;
var G__46765 = k46759;
var G__46765__$1 = (((G__46765 instanceof cljs.core.Keyword))?G__46765.fqn:null);
switch (G__46765__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k46759,else__4442__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4458__auto__,f__4459__auto__,init__4460__auto__){
var self__ = this;
var this__4458__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4461__auto__,p__46769){
var vec__46770 = p__46769;
var k__4462__auto__ = cljs.core.nth.call(null,vec__46770,(0),null);
var v__4463__auto__ = cljs.core.nth.call(null,vec__46770,(1),null);
return f__4459__auto__.call(null,ret__4461__auto__,k__4462__auto__,v__4463__auto__);
}),init__4460__auto__,this__4458__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4453__auto__,writer__4454__auto__,opts__4455__auto__){
var self__ = this;
var this__4453__auto____$1 = this;
var pr_pair__4456__auto__ = (function (keyval__4457__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4454__auto__,cljs.core.pr_writer,""," ","",opts__4455__auto__,keyval__4457__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4454__auto__,pr_pair__4456__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4455__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__46758){
var self__ = this;
var G__46758__$1 = this;
return (new cljs.core.RecordIter((0),G__46758__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4437__auto__){
var self__ = this;
var this__4437__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4434__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4443__auto__){
var self__ = this;
var this__4443__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4435__auto__){
var self__ = this;
var this__4435__auto____$1 = this;
var h__4297__auto__ = self__.__hash;
if((!((h__4297__auto__ == null)))){
return h__4297__auto__;
} else {
var h__4297__auto____$1 = (function (coll__4436__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll.call(null,coll__4436__auto__));
}).call(null,this__4435__auto____$1);
(self__.__hash = h__4297__auto____$1);

return h__4297__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this46760,other46761){
var self__ = this;
var this46760__$1 = this;
return (((!((other46761 == null)))) && ((this46760__$1.constructor === other46761.constructor)) && (cljs.core._EQ_.call(null,this46760__$1.x,other46761.x)) && (cljs.core._EQ_.call(null,this46760__$1.y,other46761.y)) && (cljs.core._EQ_.call(null,this46760__$1.__extmap,other46761.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4448__auto__,k__4449__auto__){
var self__ = this;
var this__4448__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4449__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4448__auto____$1),self__.__meta),k__4449__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4449__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4446__auto__,k__4447__auto__,G__46758){
var self__ = this;
var this__4446__auto____$1 = this;
var pred__46783 = cljs.core.keyword_identical_QMARK_;
var expr__46784 = k__4447__auto__;
if(cljs.core.truth_(pred__46783.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__46784))){
return (new shadow.dom.Coordinate(G__46758,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__46783.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__46784))){
return (new shadow.dom.Coordinate(self__.x,G__46758,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4447__auto__,G__46758),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4451__auto__){
var self__ = this;
var this__4451__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4438__auto__,G__46758){
var self__ = this;
var this__4438__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__46758,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4444__auto__,entry__4445__auto__){
var self__ = this;
var this__4444__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4445__auto__)){
return this__4444__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4445__auto__,(0)),cljs.core._nth.call(null,entry__4445__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4444__auto____$1,entry__4445__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4482__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4482__auto__,writer__4483__auto__){
return cljs.core._write.call(null,writer__4483__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__46762){
var extmap__4478__auto__ = (function (){var G__46798 = cljs.core.dissoc.call(null,G__46762,new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776));
if(cljs.core.record_QMARK_.call(null,G__46762)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__46798);
} else {
return G__46798;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__46762),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__46762),null,cljs.core.not_empty.call(null,extmap__4478__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node.call(null,el));
return shadow.dom.__GT_Coordinate.call(null,pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node.call(null,el));
return shadow.dom.__GT_Coordinate.call(null,pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node.call(null,el));
return shadow.dom.__GT_Coordinate.call(null,pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4439__auto__,k__4440__auto__){
var self__ = this;
var this__4439__auto____$1 = this;
return this__4439__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4440__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4441__auto__,k46809,else__4442__auto__){
var self__ = this;
var this__4441__auto____$1 = this;
var G__46824 = k46809;
var G__46824__$1 = (((G__46824 instanceof cljs.core.Keyword))?G__46824.fqn:null);
switch (G__46824__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k46809,else__4442__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4458__auto__,f__4459__auto__,init__4460__auto__){
var self__ = this;
var this__4458__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4461__auto__,p__46831){
var vec__46833 = p__46831;
var k__4462__auto__ = cljs.core.nth.call(null,vec__46833,(0),null);
var v__4463__auto__ = cljs.core.nth.call(null,vec__46833,(1),null);
return f__4459__auto__.call(null,ret__4461__auto__,k__4462__auto__,v__4463__auto__);
}),init__4460__auto__,this__4458__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4453__auto__,writer__4454__auto__,opts__4455__auto__){
var self__ = this;
var this__4453__auto____$1 = this;
var pr_pair__4456__auto__ = (function (keyval__4457__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4454__auto__,cljs.core.pr_writer,""," ","",opts__4455__auto__,keyval__4457__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4454__auto__,pr_pair__4456__auto__,"#shadow.dom.Size{",", ","}",opts__4455__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__46808){
var self__ = this;
var G__46808__$1 = this;
return (new cljs.core.RecordIter((0),G__46808__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4437__auto__){
var self__ = this;
var this__4437__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4434__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4443__auto__){
var self__ = this;
var this__4443__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4435__auto__){
var self__ = this;
var this__4435__auto____$1 = this;
var h__4297__auto__ = self__.__hash;
if((!((h__4297__auto__ == null)))){
return h__4297__auto__;
} else {
var h__4297__auto____$1 = (function (coll__4436__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll.call(null,coll__4436__auto__));
}).call(null,this__4435__auto____$1);
(self__.__hash = h__4297__auto____$1);

return h__4297__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this46810,other46811){
var self__ = this;
var this46810__$1 = this;
return (((!((other46811 == null)))) && ((this46810__$1.constructor === other46811.constructor)) && (cljs.core._EQ_.call(null,this46810__$1.w,other46811.w)) && (cljs.core._EQ_.call(null,this46810__$1.h,other46811.h)) && (cljs.core._EQ_.call(null,this46810__$1.__extmap,other46811.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4448__auto__,k__4449__auto__){
var self__ = this;
var this__4448__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4449__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4448__auto____$1),self__.__meta),k__4449__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4449__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4446__auto__,k__4447__auto__,G__46808){
var self__ = this;
var this__4446__auto____$1 = this;
var pred__46860 = cljs.core.keyword_identical_QMARK_;
var expr__46861 = k__4447__auto__;
if(cljs.core.truth_(pred__46860.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__46861))){
return (new shadow.dom.Size(G__46808,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__46860.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__46861))){
return (new shadow.dom.Size(self__.w,G__46808,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4447__auto__,G__46808),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4451__auto__){
var self__ = this;
var this__4451__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4438__auto__,G__46808){
var self__ = this;
var this__4438__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__46808,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4444__auto__,entry__4445__auto__){
var self__ = this;
var this__4444__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4445__auto__)){
return this__4444__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4445__auto__,(0)),cljs.core._nth.call(null,entry__4445__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4444__auto____$1,entry__4445__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4482__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4482__auto__,writer__4483__auto__){
return cljs.core._write.call(null,writer__4483__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__46814){
var extmap__4478__auto__ = (function (){var G__46870 = cljs.core.dissoc.call(null,G__46814,new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740));
if(cljs.core.record_QMARK_.call(null,G__46814)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__46870);
} else {
return G__46870;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__46814),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__46814),null,cljs.core.not_empty.call(null,extmap__4478__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj.call(null,goog.style.getSize(shadow.dom.dom_node.call(null,el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size.call(null,el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj.call(null,goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node.call(null,el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node.call(null,el);
var opts = (native$["options"]);
var a__4663__auto__ = opts;
var l__4664__auto__ = a__4663__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4664__auto__)){
var G__47532 = (i + (1));
var G__47533 = cljs.core.conj.call(null,ret,(opts[i]["value"]));
i = G__47532;
ret = G__47533;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_.call(null,query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.call(null,"&",cljs.core.map.call(null,(function (p__46883){
var vec__46884 = p__46883;
var k = cljs.core.nth.call(null,vec__46884,(0),null);
var v = cljs.core.nth.call(null,vec__46884,(1),null);
return [cljs.core.name.call(null,k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__46890 = arguments.length;
switch (G__46890) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.call(null,path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url.call(null,path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node.call(null,el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node.call(null,new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node.call(null,ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node.call(null,new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node.call(null,ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5733__auto__ = shadow.dom.dom_node.call(null,ref).firstChild;
if(cljs.core.truth_(temp__5733__auto__)){
var child = temp__5733__auto__;
return shadow.dom.insert_before.call(null,child,new$);
} else {
return shadow.dom.append.call(null,ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node.call(null,el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__47565 = ps;
var G__47566 = (i + (1));
el__$1 = G__47565;
i = G__47566;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node.call(null,el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent.call(null,el);
if(cljs.core.truth_(parent)){
return cljs.core.cons.call(null,parent,(new cljs.core.LazySeq(null,(function (){
return shadow.dom.parents.call(null,parent);
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node.call(null,el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node.call(null,el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node.call(null,el));
});
shadow.dom.xmlns = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__46903 = shadow.dom.parse_tag.call(null,tag_def);
var tag_name = cljs.core.nth.call(null,vec__46903,(0),null);
var tag_id = cljs.core.nth.call(null,vec__46903,(1),null);
var tag_classes = cljs.core.nth.call(null,vec__46903,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string.call(null,new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__46908_47578 = cljs.core.seq.call(null,props);
var chunk__46909_47579 = null;
var count__46910_47580 = (0);
var i__46911_47581 = (0);
while(true){
if((i__46911_47581 < count__46910_47580)){
var vec__46927_47582 = cljs.core._nth.call(null,chunk__46909_47579,i__46911_47581);
var k_47583 = cljs.core.nth.call(null,vec__46927_47582,(0),null);
var v_47584 = cljs.core.nth.call(null,vec__46927_47582,(1),null);
el.setAttributeNS((function (){var temp__5735__auto__ = cljs.core.namespace.call(null,k_47583);
if(cljs.core.truth_(temp__5735__auto__)){
var ns = temp__5735__auto__;
return cljs.core.get.call(null,cljs.core.deref.call(null,shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name.call(null,k_47583),v_47584);


var G__47585 = seq__46908_47578;
var G__47586 = chunk__46909_47579;
var G__47587 = count__46910_47580;
var G__47588 = (i__46911_47581 + (1));
seq__46908_47578 = G__47585;
chunk__46909_47579 = G__47586;
count__46910_47580 = G__47587;
i__46911_47581 = G__47588;
continue;
} else {
var temp__5735__auto___47589 = cljs.core.seq.call(null,seq__46908_47578);
if(temp__5735__auto___47589){
var seq__46908_47591__$1 = temp__5735__auto___47589;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46908_47591__$1)){
var c__4609__auto___47592 = cljs.core.chunk_first.call(null,seq__46908_47591__$1);
var G__47593 = cljs.core.chunk_rest.call(null,seq__46908_47591__$1);
var G__47594 = c__4609__auto___47592;
var G__47595 = cljs.core.count.call(null,c__4609__auto___47592);
var G__47596 = (0);
seq__46908_47578 = G__47593;
chunk__46909_47579 = G__47594;
count__46910_47580 = G__47595;
i__46911_47581 = G__47596;
continue;
} else {
var vec__46933_47600 = cljs.core.first.call(null,seq__46908_47591__$1);
var k_47601 = cljs.core.nth.call(null,vec__46933_47600,(0),null);
var v_47602 = cljs.core.nth.call(null,vec__46933_47600,(1),null);
el.setAttributeNS((function (){var temp__5735__auto____$1 = cljs.core.namespace.call(null,k_47601);
if(cljs.core.truth_(temp__5735__auto____$1)){
var ns = temp__5735__auto____$1;
return cljs.core.get.call(null,cljs.core.deref.call(null,shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name.call(null,k_47601),v_47602);


var G__47604 = cljs.core.next.call(null,seq__46908_47591__$1);
var G__47605 = null;
var G__47606 = (0);
var G__47607 = (0);
seq__46908_47578 = G__47604;
chunk__46909_47579 = G__47605;
count__46910_47580 = G__47606;
i__46911_47581 = G__47607;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return shadow.dom._to_svg.call(null,el);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__46941 = shadow.dom.destructure_node.call(null,shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.call(null,vec__46941,(0),null);
var node_children = cljs.core.nth.call(null,vec__46941,(1),null);
var seq__46944_47608 = cljs.core.seq.call(null,node_children);
var chunk__46946_47609 = null;
var count__46947_47610 = (0);
var i__46948_47611 = (0);
while(true){
if((i__46948_47611 < count__46947_47610)){
var child_struct_47612 = cljs.core._nth.call(null,chunk__46946_47609,i__46948_47611);
if((!((child_struct_47612 == null)))){
if(typeof child_struct_47612 === 'string'){
var text_47613 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_47613),child_struct_47612].join(''));
} else {
var children_47614 = shadow.dom.svg_node.call(null,child_struct_47612);
if(cljs.core.seq_QMARK_.call(null,children_47614)){
var seq__46980_47615 = cljs.core.seq.call(null,children_47614);
var chunk__46982_47616 = null;
var count__46983_47617 = (0);
var i__46984_47618 = (0);
while(true){
if((i__46984_47618 < count__46983_47617)){
var child_47619 = cljs.core._nth.call(null,chunk__46982_47616,i__46984_47618);
if(cljs.core.truth_(child_47619)){
node.appendChild(child_47619);


var G__47620 = seq__46980_47615;
var G__47621 = chunk__46982_47616;
var G__47622 = count__46983_47617;
var G__47623 = (i__46984_47618 + (1));
seq__46980_47615 = G__47620;
chunk__46982_47616 = G__47621;
count__46983_47617 = G__47622;
i__46984_47618 = G__47623;
continue;
} else {
var G__47624 = seq__46980_47615;
var G__47625 = chunk__46982_47616;
var G__47626 = count__46983_47617;
var G__47627 = (i__46984_47618 + (1));
seq__46980_47615 = G__47624;
chunk__46982_47616 = G__47625;
count__46983_47617 = G__47626;
i__46984_47618 = G__47627;
continue;
}
} else {
var temp__5735__auto___47628 = cljs.core.seq.call(null,seq__46980_47615);
if(temp__5735__auto___47628){
var seq__46980_47629__$1 = temp__5735__auto___47628;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46980_47629__$1)){
var c__4609__auto___47630 = cljs.core.chunk_first.call(null,seq__46980_47629__$1);
var G__47631 = cljs.core.chunk_rest.call(null,seq__46980_47629__$1);
var G__47632 = c__4609__auto___47630;
var G__47633 = cljs.core.count.call(null,c__4609__auto___47630);
var G__47634 = (0);
seq__46980_47615 = G__47631;
chunk__46982_47616 = G__47632;
count__46983_47617 = G__47633;
i__46984_47618 = G__47634;
continue;
} else {
var child_47635 = cljs.core.first.call(null,seq__46980_47629__$1);
if(cljs.core.truth_(child_47635)){
node.appendChild(child_47635);


var G__47636 = cljs.core.next.call(null,seq__46980_47629__$1);
var G__47637 = null;
var G__47638 = (0);
var G__47639 = (0);
seq__46980_47615 = G__47636;
chunk__46982_47616 = G__47637;
count__46983_47617 = G__47638;
i__46984_47618 = G__47639;
continue;
} else {
var G__47640 = cljs.core.next.call(null,seq__46980_47629__$1);
var G__47641 = null;
var G__47642 = (0);
var G__47643 = (0);
seq__46980_47615 = G__47640;
chunk__46982_47616 = G__47641;
count__46983_47617 = G__47642;
i__46984_47618 = G__47643;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_47614);
}
}


var G__47644 = seq__46944_47608;
var G__47645 = chunk__46946_47609;
var G__47646 = count__46947_47610;
var G__47647 = (i__46948_47611 + (1));
seq__46944_47608 = G__47644;
chunk__46946_47609 = G__47645;
count__46947_47610 = G__47646;
i__46948_47611 = G__47647;
continue;
} else {
var G__47648 = seq__46944_47608;
var G__47649 = chunk__46946_47609;
var G__47650 = count__46947_47610;
var G__47651 = (i__46948_47611 + (1));
seq__46944_47608 = G__47648;
chunk__46946_47609 = G__47649;
count__46947_47610 = G__47650;
i__46948_47611 = G__47651;
continue;
}
} else {
var temp__5735__auto___47653 = cljs.core.seq.call(null,seq__46944_47608);
if(temp__5735__auto___47653){
var seq__46944_47654__$1 = temp__5735__auto___47653;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46944_47654__$1)){
var c__4609__auto___47655 = cljs.core.chunk_first.call(null,seq__46944_47654__$1);
var G__47657 = cljs.core.chunk_rest.call(null,seq__46944_47654__$1);
var G__47658 = c__4609__auto___47655;
var G__47659 = cljs.core.count.call(null,c__4609__auto___47655);
var G__47660 = (0);
seq__46944_47608 = G__47657;
chunk__46946_47609 = G__47658;
count__46947_47610 = G__47659;
i__46948_47611 = G__47660;
continue;
} else {
var child_struct_47661 = cljs.core.first.call(null,seq__46944_47654__$1);
if((!((child_struct_47661 == null)))){
if(typeof child_struct_47661 === 'string'){
var text_47662 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_47662),child_struct_47661].join(''));
} else {
var children_47663 = shadow.dom.svg_node.call(null,child_struct_47661);
if(cljs.core.seq_QMARK_.call(null,children_47663)){
var seq__47001_47664 = cljs.core.seq.call(null,children_47663);
var chunk__47003_47665 = null;
var count__47004_47666 = (0);
var i__47005_47667 = (0);
while(true){
if((i__47005_47667 < count__47004_47666)){
var child_47668 = cljs.core._nth.call(null,chunk__47003_47665,i__47005_47667);
if(cljs.core.truth_(child_47668)){
node.appendChild(child_47668);


var G__47669 = seq__47001_47664;
var G__47670 = chunk__47003_47665;
var G__47671 = count__47004_47666;
var G__47672 = (i__47005_47667 + (1));
seq__47001_47664 = G__47669;
chunk__47003_47665 = G__47670;
count__47004_47666 = G__47671;
i__47005_47667 = G__47672;
continue;
} else {
var G__47673 = seq__47001_47664;
var G__47674 = chunk__47003_47665;
var G__47675 = count__47004_47666;
var G__47676 = (i__47005_47667 + (1));
seq__47001_47664 = G__47673;
chunk__47003_47665 = G__47674;
count__47004_47666 = G__47675;
i__47005_47667 = G__47676;
continue;
}
} else {
var temp__5735__auto___47677__$1 = cljs.core.seq.call(null,seq__47001_47664);
if(temp__5735__auto___47677__$1){
var seq__47001_47678__$1 = temp__5735__auto___47677__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47001_47678__$1)){
var c__4609__auto___47679 = cljs.core.chunk_first.call(null,seq__47001_47678__$1);
var G__47681 = cljs.core.chunk_rest.call(null,seq__47001_47678__$1);
var G__47682 = c__4609__auto___47679;
var G__47683 = cljs.core.count.call(null,c__4609__auto___47679);
var G__47684 = (0);
seq__47001_47664 = G__47681;
chunk__47003_47665 = G__47682;
count__47004_47666 = G__47683;
i__47005_47667 = G__47684;
continue;
} else {
var child_47685 = cljs.core.first.call(null,seq__47001_47678__$1);
if(cljs.core.truth_(child_47685)){
node.appendChild(child_47685);


var G__47686 = cljs.core.next.call(null,seq__47001_47678__$1);
var G__47687 = null;
var G__47688 = (0);
var G__47689 = (0);
seq__47001_47664 = G__47686;
chunk__47003_47665 = G__47687;
count__47004_47666 = G__47688;
i__47005_47667 = G__47689;
continue;
} else {
var G__47690 = cljs.core.next.call(null,seq__47001_47678__$1);
var G__47691 = null;
var G__47692 = (0);
var G__47693 = (0);
seq__47001_47664 = G__47690;
chunk__47003_47665 = G__47691;
count__47004_47666 = G__47692;
i__47005_47667 = G__47693;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_47663);
}
}


var G__47695 = cljs.core.next.call(null,seq__46944_47654__$1);
var G__47696 = null;
var G__47697 = (0);
var G__47698 = (0);
seq__46944_47608 = G__47695;
chunk__46946_47609 = G__47696;
count__46947_47610 = G__47697;
i__46948_47611 = G__47698;
continue;
} else {
var G__47702 = cljs.core.next.call(null,seq__46944_47654__$1);
var G__47703 = null;
var G__47704 = (0);
var G__47705 = (0);
seq__46944_47608 = G__47702;
chunk__46946_47609 = G__47703;
count__46947_47610 = G__47704;
i__46948_47611 = G__47705;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.call(null,"strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node.call(null,this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.call(null,shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4795__auto__ = [];
var len__4789__auto___47714 = arguments.length;
var i__4790__auto___47715 = (0);
while(true){
if((i__4790__auto___47715 < len__4789__auto___47714)){
args__4795__auto__.push((arguments[i__4790__auto___47715]));

var G__47716 = (i__4790__auto___47715 + (1));
i__4790__auto___47715 = G__47716;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg.call(null,cljs.core.vec.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq47029){
var G__47030 = cljs.core.first.call(null,seq47029);
var seq47029__$1 = cljs.core.next.call(null,seq47029);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47030,seq47029__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__47050 = arguments.length;
switch (G__47050) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.call(null,el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.call(null,el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer.call(null,(1));
var chan = cljs.core.async.chan.call(null,buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.call(null,chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler.call(null,el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_.call(null,chan);
} else {
return null;
}
});
shadow.dom.dom_listen.call(null,shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,event),event_fn);

if(cljs.core.truth_((function (){var and__4174__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4174__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4174__auto__;
}
})())){
var c__43103__auto___47724 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__43110__auto__ = (function (){var switch__42759__auto__ = (function (state_47067){
var state_val_47068 = (state_47067[(1)]);
if((state_val_47068 === (1))){
var state_47067__$1 = state_47067;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47067__$1,(2),once_or_cleanup);
} else {
if((state_val_47068 === (2))){
var inst_47064 = (state_47067[(2)]);
var inst_47065 = shadow.dom.remove_event_handler.call(null,el,event,event_fn);
var state_47067__$1 = (function (){var statearr_47073 = state_47067;
(statearr_47073[(7)] = inst_47064);

return statearr_47073;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47067__$1,inst_47065);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__42760__auto__ = null;
var shadow$dom$state_machine__42760__auto____0 = (function (){
var statearr_47077 = [null,null,null,null,null,null,null,null];
(statearr_47077[(0)] = shadow$dom$state_machine__42760__auto__);

(statearr_47077[(1)] = (1));

return statearr_47077;
});
var shadow$dom$state_machine__42760__auto____1 = (function (state_47067){
while(true){
var ret_value__42761__auto__ = (function (){try{while(true){
var result__42762__auto__ = switch__42759__auto__.call(null,state_47067);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42762__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42762__auto__;
}
break;
}
}catch (e47078){if((e47078 instanceof Object)){
var ex__42763__auto__ = e47078;
var statearr_47079_47729 = state_47067;
(statearr_47079_47729[(5)] = ex__42763__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47067);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47078;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42761__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47730 = state_47067;
state_47067 = G__47730;
continue;
} else {
return ret_value__42761__auto__;
}
break;
}
});
shadow$dom$state_machine__42760__auto__ = function(state_47067){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__42760__auto____0.call(this);
case 1:
return shadow$dom$state_machine__42760__auto____1.call(this,state_47067);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__42760__auto____0;
shadow$dom$state_machine__42760__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__42760__auto____1;
return shadow$dom$state_machine__42760__auto__;
})()
})();
var state__43111__auto__ = (function (){var statearr_47082 = f__43110__auto__.call(null);
(statearr_47082[(6)] = c__43103__auto___47724);

return statearr_47082;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43111__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
