goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__42702 = arguments.length;
switch (G__42702) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async42706 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42706 = (function (f,blockable,meta42707){
this.f = f;
this.blockable = blockable;
this.meta42707 = meta42707;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async42706.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42708,meta42707__$1){
var self__ = this;
var _42708__$1 = this;
return (new cljs.core.async.t_cljs$core$async42706(self__.f,self__.blockable,meta42707__$1));
}));

(cljs.core.async.t_cljs$core$async42706.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42708){
var self__ = this;
var _42708__$1 = this;
return self__.meta42707;
}));

(cljs.core.async.t_cljs$core$async42706.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42706.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async42706.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async42706.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async42706.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta42707","meta42707",883194632,null)], null);
}));

(cljs.core.async.t_cljs$core$async42706.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async42706.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42706");

(cljs.core.async.t_cljs$core$async42706.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"cljs.core.async/t_cljs$core$async42706");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async42706.
 */
cljs.core.async.__GT_t_cljs$core$async42706 = (function cljs$core$async$__GT_t_cljs$core$async42706(f__$1,blockable__$1,meta42707){
return (new cljs.core.async.t_cljs$core$async42706(f__$1,blockable__$1,meta42707));
});

}

return (new cljs.core.async.t_cljs$core$async42706(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__42777 = arguments.length;
switch (G__42777) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__42835 = arguments.length;
switch (G__42835) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__42851 = arguments.length;
switch (G__42851) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_45903 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_45903);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,val_45903);
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__42895 = arguments.length;
switch (G__42895) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,ret);
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4666__auto___45924 = n;
var x_45926 = (0);
while(true){
if((x_45926 < n__4666__auto___45924)){
(a[x_45926] = x_45926);

var G__45928 = (x_45926 + (1));
x_45926 = G__45928;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async42921 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42921 = (function (flag,meta42922){
this.flag = flag;
this.meta42922 = meta42922;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async42921.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42923,meta42922__$1){
var self__ = this;
var _42923__$1 = this;
return (new cljs.core.async.t_cljs$core$async42921(self__.flag,meta42922__$1));
}));

(cljs.core.async.t_cljs$core$async42921.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42923){
var self__ = this;
var _42923__$1 = this;
return self__.meta42922;
}));

(cljs.core.async.t_cljs$core$async42921.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42921.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async42921.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async42921.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async42921.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta42922","meta42922",-481857359,null)], null);
}));

(cljs.core.async.t_cljs$core$async42921.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async42921.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42921");

(cljs.core.async.t_cljs$core$async42921.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"cljs.core.async/t_cljs$core$async42921");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async42921.
 */
cljs.core.async.__GT_t_cljs$core$async42921 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async42921(flag__$1,meta42922){
return (new cljs.core.async.t_cljs$core$async42921(flag__$1,meta42922));
});

}

return (new cljs.core.async.t_cljs$core$async42921(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async42973 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42973 = (function (flag,cb,meta42974){
this.flag = flag;
this.cb = cb;
this.meta42974 = meta42974;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async42973.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42975,meta42974__$1){
var self__ = this;
var _42975__$1 = this;
return (new cljs.core.async.t_cljs$core$async42973(self__.flag,self__.cb,meta42974__$1));
}));

(cljs.core.async.t_cljs$core$async42973.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42975){
var self__ = this;
var _42975__$1 = this;
return self__.meta42974;
}));

(cljs.core.async.t_cljs$core$async42973.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42973.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async42973.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async42973.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async42973.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta42974","meta42974",1811822493,null)], null);
}));

(cljs.core.async.t_cljs$core$async42973.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async42973.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42973");

(cljs.core.async.t_cljs$core$async42973.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"cljs.core.async/t_cljs$core$async42973");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async42973.
 */
cljs.core.async.__GT_t_cljs$core$async42973 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async42973(flag__$1,cb__$1,meta42974){
return (new cljs.core.async.t_cljs$core$async42973(flag__$1,cb__$1,meta42974));
});

}

return (new cljs.core.async.t_cljs$core$async42973(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count.call(null,ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__43010_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__43010_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__43012_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__43012_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4185__auto__ = wport;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return port;
}
})()], null));
} else {
var G__45965 = (i + (1));
i = G__45965;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4185__auto__ = ret;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4174__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___45972 = arguments.length;
var i__4790__auto___45975 = (0);
while(true){
if((i__4790__auto___45975 < len__4789__auto___45972)){
args__4795__auto__.push((arguments[i__4790__auto___45975]));

var G__45978 = (i__4790__auto___45975 + (1));
i__4790__auto___45975 = G__45978;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__43059){
var map__43060 = p__43059;
var map__43060__$1 = (((((!((map__43060 == null))))?(((((map__43060.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43060.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43060):map__43060);
var opts = map__43060__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq43045){
var G__43046 = cljs.core.first.call(null,seq43045);
var seq43045__$1 = cljs.core.next.call(null,seq43045);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43046,seq43045__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__43074 = arguments.length;
switch (G__43074) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__42559__auto___46018 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42560__auto__ = (function (){var switch__42266__auto__ = (function (state_43138){
var state_val_43140 = (state_43138[(1)]);
if((state_val_43140 === (7))){
var inst_43131 = (state_43138[(2)]);
var state_43138__$1 = state_43138;
var statearr_43156_46025 = state_43138__$1;
(statearr_43156_46025[(2)] = inst_43131);

(statearr_43156_46025[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43140 === (1))){
var state_43138__$1 = state_43138;
var statearr_43157_46027 = state_43138__$1;
(statearr_43157_46027[(2)] = null);

(statearr_43157_46027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43140 === (4))){
var inst_43110 = (state_43138[(7)]);
var inst_43110__$1 = (state_43138[(2)]);
var inst_43111 = (inst_43110__$1 == null);
var state_43138__$1 = (function (){var statearr_43160 = state_43138;
(statearr_43160[(7)] = inst_43110__$1);

return statearr_43160;
})();
if(cljs.core.truth_(inst_43111)){
var statearr_43161_46030 = state_43138__$1;
(statearr_43161_46030[(1)] = (5));

} else {
var statearr_43162_46033 = state_43138__$1;
(statearr_43162_46033[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43140 === (13))){
var state_43138__$1 = state_43138;
var statearr_43164_46034 = state_43138__$1;
(statearr_43164_46034[(2)] = null);

(statearr_43164_46034[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43140 === (6))){
var inst_43110 = (state_43138[(7)]);
var state_43138__$1 = state_43138;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_43138__$1,(11),to,inst_43110);
} else {
if((state_val_43140 === (3))){
var inst_43133 = (state_43138[(2)]);
var state_43138__$1 = state_43138;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43138__$1,inst_43133);
} else {
if((state_val_43140 === (12))){
var state_43138__$1 = state_43138;
var statearr_43166_46040 = state_43138__$1;
(statearr_43166_46040[(2)] = null);

(statearr_43166_46040[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43140 === (2))){
var state_43138__$1 = state_43138;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43138__$1,(4),from);
} else {
if((state_val_43140 === (11))){
var inst_43124 = (state_43138[(2)]);
var state_43138__$1 = state_43138;
if(cljs.core.truth_(inst_43124)){
var statearr_43168_46047 = state_43138__$1;
(statearr_43168_46047[(1)] = (12));

} else {
var statearr_43172_46052 = state_43138__$1;
(statearr_43172_46052[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43140 === (9))){
var state_43138__$1 = state_43138;
var statearr_43173_46055 = state_43138__$1;
(statearr_43173_46055[(2)] = null);

(statearr_43173_46055[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43140 === (5))){
var state_43138__$1 = state_43138;
if(cljs.core.truth_(close_QMARK_)){
var statearr_43174_46056 = state_43138__$1;
(statearr_43174_46056[(1)] = (8));

} else {
var statearr_43175_46057 = state_43138__$1;
(statearr_43175_46057[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43140 === (14))){
var inst_43129 = (state_43138[(2)]);
var state_43138__$1 = state_43138;
var statearr_43176_46059 = state_43138__$1;
(statearr_43176_46059[(2)] = inst_43129);

(statearr_43176_46059[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43140 === (10))){
var inst_43121 = (state_43138[(2)]);
var state_43138__$1 = state_43138;
var statearr_43180_46060 = state_43138__$1;
(statearr_43180_46060[(2)] = inst_43121);

(statearr_43180_46060[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43140 === (8))){
var inst_43117 = cljs.core.async.close_BANG_.call(null,to);
var state_43138__$1 = state_43138;
var statearr_43181_46061 = state_43138__$1;
(statearr_43181_46061[(2)] = inst_43117);

(statearr_43181_46061[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42267__auto__ = null;
var cljs$core$async$state_machine__42267__auto____0 = (function (){
var statearr_43182 = [null,null,null,null,null,null,null,null];
(statearr_43182[(0)] = cljs$core$async$state_machine__42267__auto__);

(statearr_43182[(1)] = (1));

return statearr_43182;
});
var cljs$core$async$state_machine__42267__auto____1 = (function (state_43138){
while(true){
var ret_value__42268__auto__ = (function (){try{while(true){
var result__42269__auto__ = switch__42266__auto__.call(null,state_43138);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42269__auto__;
}
break;
}
}catch (e43183){var ex__42270__auto__ = e43183;
var statearr_43184_46066 = state_43138;
(statearr_43184_46066[(2)] = ex__42270__auto__);


if(cljs.core.seq.call(null,(state_43138[(4)]))){
var statearr_43185_46067 = state_43138;
(statearr_43185_46067[(1)] = cljs.core.first.call(null,(state_43138[(4)])));

} else {
throw ex__42270__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46070 = state_43138;
state_43138 = G__46070;
continue;
} else {
return ret_value__42268__auto__;
}
break;
}
});
cljs$core$async$state_machine__42267__auto__ = function(state_43138){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42267__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42267__auto____1.call(this,state_43138);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42267__auto____0;
cljs$core$async$state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42267__auto____1;
return cljs$core$async$state_machine__42267__auto__;
})()
})();
var state__42561__auto__ = (function (){var statearr_43186 = f__42560__auto__.call(null);
(statearr_43186[(6)] = c__42559__auto___46018);

return statearr_43186;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42561__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = (function (p__43190){
var vec__43191 = p__43190;
var v = cljs.core.nth.call(null,vec__43191,(0),null);
var p = cljs.core.nth.call(null,vec__43191,(1),null);
var job = vec__43191;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__42559__auto___46078 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42560__auto__ = (function (){var switch__42266__auto__ = (function (state_43198){
var state_val_43199 = (state_43198[(1)]);
if((state_val_43199 === (1))){
var state_43198__$1 = state_43198;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_43198__$1,(2),res,v);
} else {
if((state_val_43199 === (2))){
var inst_43195 = (state_43198[(2)]);
var inst_43196 = cljs.core.async.close_BANG_.call(null,res);
var state_43198__$1 = (function (){var statearr_43205 = state_43198;
(statearr_43205[(7)] = inst_43195);

return statearr_43205;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43198__$1,inst_43196);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____0 = (function (){
var statearr_43206 = [null,null,null,null,null,null,null,null];
(statearr_43206[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__);

(statearr_43206[(1)] = (1));

return statearr_43206;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____1 = (function (state_43198){
while(true){
var ret_value__42268__auto__ = (function (){try{while(true){
var result__42269__auto__ = switch__42266__auto__.call(null,state_43198);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42269__auto__;
}
break;
}
}catch (e43207){var ex__42270__auto__ = e43207;
var statearr_43208_46082 = state_43198;
(statearr_43208_46082[(2)] = ex__42270__auto__);


if(cljs.core.seq.call(null,(state_43198[(4)]))){
var statearr_43209_46083 = state_43198;
(statearr_43209_46083[(1)] = cljs.core.first.call(null,(state_43198[(4)])));

} else {
throw ex__42270__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46091 = state_43198;
state_43198 = G__46091;
continue;
} else {
return ret_value__42268__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__ = function(state_43198){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____1.call(this,state_43198);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__;
})()
})();
var state__42561__auto__ = (function (){var statearr_43212 = f__42560__auto__.call(null);
(statearr_43212[(6)] = c__42559__auto___46078);

return statearr_43212;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42561__auto__);
}));


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var async = (function (p__43213){
var vec__43215 = p__43213;
var v = cljs.core.nth.call(null,vec__43215,(0),null);
var p = cljs.core.nth.call(null,vec__43215,(1),null);
var job = vec__43215;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var n__4666__auto___46095 = n;
var __46096 = (0);
while(true){
if((__46096 < n__4666__auto___46095)){
var G__43221_46097 = type;
var G__43221_46098__$1 = (((G__43221_46097 instanceof cljs.core.Keyword))?G__43221_46097.fqn:null);
switch (G__43221_46098__$1) {
case "compute":
var c__42559__auto___46100 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__46096,c__42559__auto___46100,G__43221_46097,G__43221_46098__$1,n__4666__auto___46095,jobs,results,process,async){
return (function (){
var f__42560__auto__ = (function (){var switch__42266__auto__ = ((function (__46096,c__42559__auto___46100,G__43221_46097,G__43221_46098__$1,n__4666__auto___46095,jobs,results,process,async){
return (function (state_43240){
var state_val_43241 = (state_43240[(1)]);
if((state_val_43241 === (1))){
var state_43240__$1 = state_43240;
var statearr_43247_46105 = state_43240__$1;
(statearr_43247_46105[(2)] = null);

(statearr_43247_46105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43241 === (2))){
var state_43240__$1 = state_43240;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43240__$1,(4),jobs);
} else {
if((state_val_43241 === (3))){
var inst_43236 = (state_43240[(2)]);
var state_43240__$1 = state_43240;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43240__$1,inst_43236);
} else {
if((state_val_43241 === (4))){
var inst_43228 = (state_43240[(2)]);
var inst_43229 = process.call(null,inst_43228);
var state_43240__$1 = state_43240;
if(cljs.core.truth_(inst_43229)){
var statearr_43248_46106 = state_43240__$1;
(statearr_43248_46106[(1)] = (5));

} else {
var statearr_43252_46107 = state_43240__$1;
(statearr_43252_46107[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43241 === (5))){
var state_43240__$1 = state_43240;
var statearr_43254_46109 = state_43240__$1;
(statearr_43254_46109[(2)] = null);

(statearr_43254_46109[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43241 === (6))){
var state_43240__$1 = state_43240;
var statearr_43256_46111 = state_43240__$1;
(statearr_43256_46111[(2)] = null);

(statearr_43256_46111[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43241 === (7))){
var inst_43234 = (state_43240[(2)]);
var state_43240__$1 = state_43240;
var statearr_43257_46113 = state_43240__$1;
(statearr_43257_46113[(2)] = inst_43234);

(statearr_43257_46113[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__46096,c__42559__auto___46100,G__43221_46097,G__43221_46098__$1,n__4666__auto___46095,jobs,results,process,async))
;
return ((function (__46096,switch__42266__auto__,c__42559__auto___46100,G__43221_46097,G__43221_46098__$1,n__4666__auto___46095,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____0 = (function (){
var statearr_43258 = [null,null,null,null,null,null,null];
(statearr_43258[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__);

(statearr_43258[(1)] = (1));

return statearr_43258;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____1 = (function (state_43240){
while(true){
var ret_value__42268__auto__ = (function (){try{while(true){
var result__42269__auto__ = switch__42266__auto__.call(null,state_43240);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42269__auto__;
}
break;
}
}catch (e43259){var ex__42270__auto__ = e43259;
var statearr_43260_46121 = state_43240;
(statearr_43260_46121[(2)] = ex__42270__auto__);


if(cljs.core.seq.call(null,(state_43240[(4)]))){
var statearr_43261_46122 = state_43240;
(statearr_43261_46122[(1)] = cljs.core.first.call(null,(state_43240[(4)])));

} else {
throw ex__42270__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46123 = state_43240;
state_43240 = G__46123;
continue;
} else {
return ret_value__42268__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__ = function(state_43240){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____1.call(this,state_43240);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__;
})()
;})(__46096,switch__42266__auto__,c__42559__auto___46100,G__43221_46097,G__43221_46098__$1,n__4666__auto___46095,jobs,results,process,async))
})();
var state__42561__auto__ = (function (){var statearr_43262 = f__42560__auto__.call(null);
(statearr_43262[(6)] = c__42559__auto___46100);

return statearr_43262;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42561__auto__);
});})(__46096,c__42559__auto___46100,G__43221_46097,G__43221_46098__$1,n__4666__auto___46095,jobs,results,process,async))
);


break;
case "async":
var c__42559__auto___46125 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__46096,c__42559__auto___46125,G__43221_46097,G__43221_46098__$1,n__4666__auto___46095,jobs,results,process,async){
return (function (){
var f__42560__auto__ = (function (){var switch__42266__auto__ = ((function (__46096,c__42559__auto___46125,G__43221_46097,G__43221_46098__$1,n__4666__auto___46095,jobs,results,process,async){
return (function (state_43278){
var state_val_43279 = (state_43278[(1)]);
if((state_val_43279 === (1))){
var state_43278__$1 = state_43278;
var statearr_43283_46129 = state_43278__$1;
(statearr_43283_46129[(2)] = null);

(statearr_43283_46129[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43279 === (2))){
var state_43278__$1 = state_43278;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43278__$1,(4),jobs);
} else {
if((state_val_43279 === (3))){
var inst_43276 = (state_43278[(2)]);
var state_43278__$1 = state_43278;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43278__$1,inst_43276);
} else {
if((state_val_43279 === (4))){
var inst_43268 = (state_43278[(2)]);
var inst_43269 = async.call(null,inst_43268);
var state_43278__$1 = state_43278;
if(cljs.core.truth_(inst_43269)){
var statearr_43287_46136 = state_43278__$1;
(statearr_43287_46136[(1)] = (5));

} else {
var statearr_43288_46137 = state_43278__$1;
(statearr_43288_46137[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43279 === (5))){
var state_43278__$1 = state_43278;
var statearr_43290_46138 = state_43278__$1;
(statearr_43290_46138[(2)] = null);

(statearr_43290_46138[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43279 === (6))){
var state_43278__$1 = state_43278;
var statearr_43291_46139 = state_43278__$1;
(statearr_43291_46139[(2)] = null);

(statearr_43291_46139[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43279 === (7))){
var inst_43274 = (state_43278[(2)]);
var state_43278__$1 = state_43278;
var statearr_43292_46141 = state_43278__$1;
(statearr_43292_46141[(2)] = inst_43274);

(statearr_43292_46141[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__46096,c__42559__auto___46125,G__43221_46097,G__43221_46098__$1,n__4666__auto___46095,jobs,results,process,async))
;
return ((function (__46096,switch__42266__auto__,c__42559__auto___46125,G__43221_46097,G__43221_46098__$1,n__4666__auto___46095,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____0 = (function (){
var statearr_43297 = [null,null,null,null,null,null,null];
(statearr_43297[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__);

(statearr_43297[(1)] = (1));

return statearr_43297;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____1 = (function (state_43278){
while(true){
var ret_value__42268__auto__ = (function (){try{while(true){
var result__42269__auto__ = switch__42266__auto__.call(null,state_43278);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42269__auto__;
}
break;
}
}catch (e43298){var ex__42270__auto__ = e43298;
var statearr_43299_46151 = state_43278;
(statearr_43299_46151[(2)] = ex__42270__auto__);


if(cljs.core.seq.call(null,(state_43278[(4)]))){
var statearr_43301_46152 = state_43278;
(statearr_43301_46152[(1)] = cljs.core.first.call(null,(state_43278[(4)])));

} else {
throw ex__42270__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46157 = state_43278;
state_43278 = G__46157;
continue;
} else {
return ret_value__42268__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__ = function(state_43278){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____1.call(this,state_43278);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__;
})()
;})(__46096,switch__42266__auto__,c__42559__auto___46125,G__43221_46097,G__43221_46098__$1,n__4666__auto___46095,jobs,results,process,async))
})();
var state__42561__auto__ = (function (){var statearr_43309 = f__42560__auto__.call(null);
(statearr_43309[(6)] = c__42559__auto___46125);

return statearr_43309;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42561__auto__);
});})(__46096,c__42559__auto___46125,G__43221_46097,G__43221_46098__$1,n__4666__auto___46095,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__43221_46098__$1)].join('')));

}

var G__46165 = (__46096 + (1));
__46096 = G__46165;
continue;
} else {
}
break;
}

var c__42559__auto___46166 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42560__auto__ = (function (){var switch__42266__auto__ = (function (state_43352){
var state_val_43353 = (state_43352[(1)]);
if((state_val_43353 === (7))){
var inst_43339 = (state_43352[(2)]);
var state_43352__$1 = state_43352;
var statearr_43391_46173 = state_43352__$1;
(statearr_43391_46173[(2)] = inst_43339);

(statearr_43391_46173[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43353 === (1))){
var state_43352__$1 = state_43352;
var statearr_43395_46198 = state_43352__$1;
(statearr_43395_46198[(2)] = null);

(statearr_43395_46198[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43353 === (4))){
var inst_43317 = (state_43352[(7)]);
var inst_43317__$1 = (state_43352[(2)]);
var inst_43318 = (inst_43317__$1 == null);
var state_43352__$1 = (function (){var statearr_43400 = state_43352;
(statearr_43400[(7)] = inst_43317__$1);

return statearr_43400;
})();
if(cljs.core.truth_(inst_43318)){
var statearr_43403_46204 = state_43352__$1;
(statearr_43403_46204[(1)] = (5));

} else {
var statearr_43404_46205 = state_43352__$1;
(statearr_43404_46205[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43353 === (6))){
var inst_43317 = (state_43352[(7)]);
var inst_43322 = (state_43352[(8)]);
var inst_43322__$1 = cljs.core.async.chan.call(null,(1));
var inst_43323 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43325 = [inst_43317,inst_43322__$1];
var inst_43327 = (new cljs.core.PersistentVector(null,2,(5),inst_43323,inst_43325,null));
var state_43352__$1 = (function (){var statearr_43409 = state_43352;
(statearr_43409[(8)] = inst_43322__$1);

return statearr_43409;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_43352__$1,(8),jobs,inst_43327);
} else {
if((state_val_43353 === (3))){
var inst_43341 = (state_43352[(2)]);
var state_43352__$1 = state_43352;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43352__$1,inst_43341);
} else {
if((state_val_43353 === (2))){
var state_43352__$1 = state_43352;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43352__$1,(4),from);
} else {
if((state_val_43353 === (9))){
var inst_43332 = (state_43352[(2)]);
var state_43352__$1 = (function (){var statearr_43413 = state_43352;
(statearr_43413[(9)] = inst_43332);

return statearr_43413;
})();
var statearr_43414_46213 = state_43352__$1;
(statearr_43414_46213[(2)] = null);

(statearr_43414_46213[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43353 === (5))){
var inst_43320 = cljs.core.async.close_BANG_.call(null,jobs);
var state_43352__$1 = state_43352;
var statearr_43417_46215 = state_43352__$1;
(statearr_43417_46215[(2)] = inst_43320);

(statearr_43417_46215[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43353 === (8))){
var inst_43322 = (state_43352[(8)]);
var inst_43330 = (state_43352[(2)]);
var state_43352__$1 = (function (){var statearr_43421 = state_43352;
(statearr_43421[(10)] = inst_43330);

return statearr_43421;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_43352__$1,(9),results,inst_43322);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____0 = (function (){
var statearr_43422 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_43422[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__);

(statearr_43422[(1)] = (1));

return statearr_43422;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____1 = (function (state_43352){
while(true){
var ret_value__42268__auto__ = (function (){try{while(true){
var result__42269__auto__ = switch__42266__auto__.call(null,state_43352);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42269__auto__;
}
break;
}
}catch (e43423){var ex__42270__auto__ = e43423;
var statearr_43424_46226 = state_43352;
(statearr_43424_46226[(2)] = ex__42270__auto__);


if(cljs.core.seq.call(null,(state_43352[(4)]))){
var statearr_43425_46227 = state_43352;
(statearr_43425_46227[(1)] = cljs.core.first.call(null,(state_43352[(4)])));

} else {
throw ex__42270__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46230 = state_43352;
state_43352 = G__46230;
continue;
} else {
return ret_value__42268__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__ = function(state_43352){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____1.call(this,state_43352);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__;
})()
})();
var state__42561__auto__ = (function (){var statearr_43429 = f__42560__auto__.call(null);
(statearr_43429[(6)] = c__42559__auto___46166);

return statearr_43429;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42561__auto__);
}));


var c__42559__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42560__auto__ = (function (){var switch__42266__auto__ = (function (state_43478){
var state_val_43480 = (state_43478[(1)]);
if((state_val_43480 === (7))){
var inst_43473 = (state_43478[(2)]);
var state_43478__$1 = state_43478;
var statearr_43485_46236 = state_43478__$1;
(statearr_43485_46236[(2)] = inst_43473);

(statearr_43485_46236[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43480 === (20))){
var state_43478__$1 = state_43478;
var statearr_43487_46239 = state_43478__$1;
(statearr_43487_46239[(2)] = null);

(statearr_43487_46239[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43480 === (1))){
var state_43478__$1 = state_43478;
var statearr_43489_46241 = state_43478__$1;
(statearr_43489_46241[(2)] = null);

(statearr_43489_46241[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43480 === (4))){
var inst_43433 = (state_43478[(7)]);
var inst_43433__$1 = (state_43478[(2)]);
var inst_43434 = (inst_43433__$1 == null);
var state_43478__$1 = (function (){var statearr_43490 = state_43478;
(statearr_43490[(7)] = inst_43433__$1);

return statearr_43490;
})();
if(cljs.core.truth_(inst_43434)){
var statearr_43492_46246 = state_43478__$1;
(statearr_43492_46246[(1)] = (5));

} else {
var statearr_43493_46250 = state_43478__$1;
(statearr_43493_46250[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43480 === (15))){
var inst_43451 = (state_43478[(8)]);
var state_43478__$1 = state_43478;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_43478__$1,(18),to,inst_43451);
} else {
if((state_val_43480 === (21))){
var inst_43468 = (state_43478[(2)]);
var state_43478__$1 = state_43478;
var statearr_43497_46254 = state_43478__$1;
(statearr_43497_46254[(2)] = inst_43468);

(statearr_43497_46254[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43480 === (13))){
var inst_43470 = (state_43478[(2)]);
var state_43478__$1 = (function (){var statearr_43499 = state_43478;
(statearr_43499[(9)] = inst_43470);

return statearr_43499;
})();
var statearr_43500_46257 = state_43478__$1;
(statearr_43500_46257[(2)] = null);

(statearr_43500_46257[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43480 === (6))){
var inst_43433 = (state_43478[(7)]);
var state_43478__$1 = state_43478;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43478__$1,(11),inst_43433);
} else {
if((state_val_43480 === (17))){
var inst_43461 = (state_43478[(2)]);
var state_43478__$1 = state_43478;
if(cljs.core.truth_(inst_43461)){
var statearr_43502_46260 = state_43478__$1;
(statearr_43502_46260[(1)] = (19));

} else {
var statearr_43503_46261 = state_43478__$1;
(statearr_43503_46261[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43480 === (3))){
var inst_43475 = (state_43478[(2)]);
var state_43478__$1 = state_43478;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43478__$1,inst_43475);
} else {
if((state_val_43480 === (12))){
var inst_43443 = (state_43478[(10)]);
var state_43478__$1 = state_43478;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43478__$1,(14),inst_43443);
} else {
if((state_val_43480 === (2))){
var state_43478__$1 = state_43478;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43478__$1,(4),results);
} else {
if((state_val_43480 === (19))){
var state_43478__$1 = state_43478;
var statearr_43505_46266 = state_43478__$1;
(statearr_43505_46266[(2)] = null);

(statearr_43505_46266[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43480 === (11))){
var inst_43443 = (state_43478[(2)]);
var state_43478__$1 = (function (){var statearr_43509 = state_43478;
(statearr_43509[(10)] = inst_43443);

return statearr_43509;
})();
var statearr_43510_46267 = state_43478__$1;
(statearr_43510_46267[(2)] = null);

(statearr_43510_46267[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43480 === (9))){
var state_43478__$1 = state_43478;
var statearr_43513_46270 = state_43478__$1;
(statearr_43513_46270[(2)] = null);

(statearr_43513_46270[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43480 === (5))){
var state_43478__$1 = state_43478;
if(cljs.core.truth_(close_QMARK_)){
var statearr_43514_46272 = state_43478__$1;
(statearr_43514_46272[(1)] = (8));

} else {
var statearr_43515_46274 = state_43478__$1;
(statearr_43515_46274[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43480 === (14))){
var inst_43451 = (state_43478[(8)]);
var inst_43451__$1 = (state_43478[(2)]);
var inst_43454 = (inst_43451__$1 == null);
var inst_43455 = cljs.core.not.call(null,inst_43454);
var state_43478__$1 = (function (){var statearr_43516 = state_43478;
(statearr_43516[(8)] = inst_43451__$1);

return statearr_43516;
})();
if(inst_43455){
var statearr_43517_46277 = state_43478__$1;
(statearr_43517_46277[(1)] = (15));

} else {
var statearr_43521_46280 = state_43478__$1;
(statearr_43521_46280[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43480 === (16))){
var state_43478__$1 = state_43478;
var statearr_43522_46293 = state_43478__$1;
(statearr_43522_46293[(2)] = false);

(statearr_43522_46293[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43480 === (10))){
var inst_43440 = (state_43478[(2)]);
var state_43478__$1 = state_43478;
var statearr_43526_46300 = state_43478__$1;
(statearr_43526_46300[(2)] = inst_43440);

(statearr_43526_46300[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43480 === (18))){
var inst_43458 = (state_43478[(2)]);
var state_43478__$1 = state_43478;
var statearr_43527_46302 = state_43478__$1;
(statearr_43527_46302[(2)] = inst_43458);

(statearr_43527_46302[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43480 === (8))){
var inst_43437 = cljs.core.async.close_BANG_.call(null,to);
var state_43478__$1 = state_43478;
var statearr_43528_46306 = state_43478__$1;
(statearr_43528_46306[(2)] = inst_43437);

(statearr_43528_46306[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____0 = (function (){
var statearr_43532 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_43532[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__);

(statearr_43532[(1)] = (1));

return statearr_43532;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____1 = (function (state_43478){
while(true){
var ret_value__42268__auto__ = (function (){try{while(true){
var result__42269__auto__ = switch__42266__auto__.call(null,state_43478);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42269__auto__;
}
break;
}
}catch (e43535){var ex__42270__auto__ = e43535;
var statearr_43536_46314 = state_43478;
(statearr_43536_46314[(2)] = ex__42270__auto__);


if(cljs.core.seq.call(null,(state_43478[(4)]))){
var statearr_43537_46322 = state_43478;
(statearr_43537_46322[(1)] = cljs.core.first.call(null,(state_43478[(4)])));

} else {
throw ex__42270__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46335 = state_43478;
state_43478 = G__46335;
continue;
} else {
return ret_value__42268__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__ = function(state_43478){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____1.call(this,state_43478);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42267__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42267__auto__;
})()
})();
var state__42561__auto__ = (function (){var statearr_43541 = f__42560__auto__.call(null);
(statearr_43541[(6)] = c__42559__auto__);

return statearr_43541;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42561__auto__);
}));

return c__42559__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__43551 = arguments.length;
switch (G__43551) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__43556 = arguments.length;
switch (G__43556) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__43566 = arguments.length;
switch (G__43566) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__42559__auto___46400 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42560__auto__ = (function (){var switch__42266__auto__ = (function (state_43604){
var state_val_43606 = (state_43604[(1)]);
if((state_val_43606 === (7))){
var inst_43597 = (state_43604[(2)]);
var state_43604__$1 = state_43604;
var statearr_43613_46402 = state_43604__$1;
(statearr_43613_46402[(2)] = inst_43597);

(statearr_43613_46402[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43606 === (1))){
var state_43604__$1 = state_43604;
var statearr_43615_46404 = state_43604__$1;
(statearr_43615_46404[(2)] = null);

(statearr_43615_46404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43606 === (4))){
var inst_43577 = (state_43604[(7)]);
var inst_43577__$1 = (state_43604[(2)]);
var inst_43578 = (inst_43577__$1 == null);
var state_43604__$1 = (function (){var statearr_43617 = state_43604;
(statearr_43617[(7)] = inst_43577__$1);

return statearr_43617;
})();
if(cljs.core.truth_(inst_43578)){
var statearr_43619_46411 = state_43604__$1;
(statearr_43619_46411[(1)] = (5));

} else {
var statearr_43620_46413 = state_43604__$1;
(statearr_43620_46413[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43606 === (13))){
var state_43604__$1 = state_43604;
var statearr_43622_46415 = state_43604__$1;
(statearr_43622_46415[(2)] = null);

(statearr_43622_46415[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43606 === (6))){
var inst_43577 = (state_43604[(7)]);
var inst_43584 = p.call(null,inst_43577);
var state_43604__$1 = state_43604;
if(cljs.core.truth_(inst_43584)){
var statearr_43625_46422 = state_43604__$1;
(statearr_43625_46422[(1)] = (9));

} else {
var statearr_43627_46424 = state_43604__$1;
(statearr_43627_46424[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43606 === (3))){
var inst_43602 = (state_43604[(2)]);
var state_43604__$1 = state_43604;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43604__$1,inst_43602);
} else {
if((state_val_43606 === (12))){
var state_43604__$1 = state_43604;
var statearr_43630_46430 = state_43604__$1;
(statearr_43630_46430[(2)] = null);

(statearr_43630_46430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43606 === (2))){
var state_43604__$1 = state_43604;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43604__$1,(4),ch);
} else {
if((state_val_43606 === (11))){
var inst_43577 = (state_43604[(7)]);
var inst_43588 = (state_43604[(2)]);
var state_43604__$1 = state_43604;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_43604__$1,(8),inst_43588,inst_43577);
} else {
if((state_val_43606 === (9))){
var state_43604__$1 = state_43604;
var statearr_43637_46437 = state_43604__$1;
(statearr_43637_46437[(2)] = tc);

(statearr_43637_46437[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43606 === (5))){
var inst_43580 = cljs.core.async.close_BANG_.call(null,tc);
var inst_43582 = cljs.core.async.close_BANG_.call(null,fc);
var state_43604__$1 = (function (){var statearr_43641 = state_43604;
(statearr_43641[(8)] = inst_43580);

return statearr_43641;
})();
var statearr_43642_46440 = state_43604__$1;
(statearr_43642_46440[(2)] = inst_43582);

(statearr_43642_46440[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43606 === (14))){
var inst_43595 = (state_43604[(2)]);
var state_43604__$1 = state_43604;
var statearr_43649_46443 = state_43604__$1;
(statearr_43649_46443[(2)] = inst_43595);

(statearr_43649_46443[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43606 === (10))){
var state_43604__$1 = state_43604;
var statearr_43650_46445 = state_43604__$1;
(statearr_43650_46445[(2)] = fc);

(statearr_43650_46445[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43606 === (8))){
var inst_43590 = (state_43604[(2)]);
var state_43604__$1 = state_43604;
if(cljs.core.truth_(inst_43590)){
var statearr_43652_46448 = state_43604__$1;
(statearr_43652_46448[(1)] = (12));

} else {
var statearr_43655_46450 = state_43604__$1;
(statearr_43655_46450[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42267__auto__ = null;
var cljs$core$async$state_machine__42267__auto____0 = (function (){
var statearr_43661 = [null,null,null,null,null,null,null,null,null];
(statearr_43661[(0)] = cljs$core$async$state_machine__42267__auto__);

(statearr_43661[(1)] = (1));

return statearr_43661;
});
var cljs$core$async$state_machine__42267__auto____1 = (function (state_43604){
while(true){
var ret_value__42268__auto__ = (function (){try{while(true){
var result__42269__auto__ = switch__42266__auto__.call(null,state_43604);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42269__auto__;
}
break;
}
}catch (e43665){var ex__42270__auto__ = e43665;
var statearr_43666_46460 = state_43604;
(statearr_43666_46460[(2)] = ex__42270__auto__);


if(cljs.core.seq.call(null,(state_43604[(4)]))){
var statearr_43667_46462 = state_43604;
(statearr_43667_46462[(1)] = cljs.core.first.call(null,(state_43604[(4)])));

} else {
throw ex__42270__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46466 = state_43604;
state_43604 = G__46466;
continue;
} else {
return ret_value__42268__auto__;
}
break;
}
});
cljs$core$async$state_machine__42267__auto__ = function(state_43604){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42267__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42267__auto____1.call(this,state_43604);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42267__auto____0;
cljs$core$async$state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42267__auto____1;
return cljs$core$async$state_machine__42267__auto__;
})()
})();
var state__42561__auto__ = (function (){var statearr_43669 = f__42560__auto__.call(null);
(statearr_43669[(6)] = c__42559__auto___46400);

return statearr_43669;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42561__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__42559__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42560__auto__ = (function (){var switch__42266__auto__ = (function (state_43707){
var state_val_43708 = (state_43707[(1)]);
if((state_val_43708 === (7))){
var inst_43702 = (state_43707[(2)]);
var state_43707__$1 = state_43707;
var statearr_43714_46475 = state_43707__$1;
(statearr_43714_46475[(2)] = inst_43702);

(statearr_43714_46475[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43708 === (1))){
var inst_43674 = init;
var inst_43679 = inst_43674;
var state_43707__$1 = (function (){var statearr_43715 = state_43707;
(statearr_43715[(7)] = inst_43679);

return statearr_43715;
})();
var statearr_43716_46477 = state_43707__$1;
(statearr_43716_46477[(2)] = null);

(statearr_43716_46477[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43708 === (4))){
var inst_43684 = (state_43707[(8)]);
var inst_43684__$1 = (state_43707[(2)]);
var inst_43687 = (inst_43684__$1 == null);
var state_43707__$1 = (function (){var statearr_43721 = state_43707;
(statearr_43721[(8)] = inst_43684__$1);

return statearr_43721;
})();
if(cljs.core.truth_(inst_43687)){
var statearr_43722_46486 = state_43707__$1;
(statearr_43722_46486[(1)] = (5));

} else {
var statearr_43724_46487 = state_43707__$1;
(statearr_43724_46487[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43708 === (6))){
var inst_43679 = (state_43707[(7)]);
var inst_43692 = (state_43707[(9)]);
var inst_43684 = (state_43707[(8)]);
var inst_43692__$1 = f.call(null,inst_43679,inst_43684);
var inst_43693 = cljs.core.reduced_QMARK_.call(null,inst_43692__$1);
var state_43707__$1 = (function (){var statearr_43728 = state_43707;
(statearr_43728[(9)] = inst_43692__$1);

return statearr_43728;
})();
if(inst_43693){
var statearr_43734_46501 = state_43707__$1;
(statearr_43734_46501[(1)] = (8));

} else {
var statearr_43735_46502 = state_43707__$1;
(statearr_43735_46502[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43708 === (3))){
var inst_43704 = (state_43707[(2)]);
var state_43707__$1 = state_43707;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43707__$1,inst_43704);
} else {
if((state_val_43708 === (2))){
var state_43707__$1 = state_43707;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43707__$1,(4),ch);
} else {
if((state_val_43708 === (9))){
var inst_43692 = (state_43707[(9)]);
var inst_43679 = inst_43692;
var state_43707__$1 = (function (){var statearr_43739 = state_43707;
(statearr_43739[(7)] = inst_43679);

return statearr_43739;
})();
var statearr_43740_46513 = state_43707__$1;
(statearr_43740_46513[(2)] = null);

(statearr_43740_46513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43708 === (5))){
var inst_43679 = (state_43707[(7)]);
var state_43707__$1 = state_43707;
var statearr_43744_46520 = state_43707__$1;
(statearr_43744_46520[(2)] = inst_43679);

(statearr_43744_46520[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43708 === (10))){
var inst_43700 = (state_43707[(2)]);
var state_43707__$1 = state_43707;
var statearr_43747_46539 = state_43707__$1;
(statearr_43747_46539[(2)] = inst_43700);

(statearr_43747_46539[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43708 === (8))){
var inst_43692 = (state_43707[(9)]);
var inst_43696 = cljs.core.deref.call(null,inst_43692);
var state_43707__$1 = state_43707;
var statearr_43755_46547 = state_43707__$1;
(statearr_43755_46547[(2)] = inst_43696);

(statearr_43755_46547[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__42267__auto__ = null;
var cljs$core$async$reduce_$_state_machine__42267__auto____0 = (function (){
var statearr_43758 = [null,null,null,null,null,null,null,null,null,null];
(statearr_43758[(0)] = cljs$core$async$reduce_$_state_machine__42267__auto__);

(statearr_43758[(1)] = (1));

return statearr_43758;
});
var cljs$core$async$reduce_$_state_machine__42267__auto____1 = (function (state_43707){
while(true){
var ret_value__42268__auto__ = (function (){try{while(true){
var result__42269__auto__ = switch__42266__auto__.call(null,state_43707);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42269__auto__;
}
break;
}
}catch (e43759){var ex__42270__auto__ = e43759;
var statearr_43761_46575 = state_43707;
(statearr_43761_46575[(2)] = ex__42270__auto__);


if(cljs.core.seq.call(null,(state_43707[(4)]))){
var statearr_43768_46580 = state_43707;
(statearr_43768_46580[(1)] = cljs.core.first.call(null,(state_43707[(4)])));

} else {
throw ex__42270__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46590 = state_43707;
state_43707 = G__46590;
continue;
} else {
return ret_value__42268__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__42267__auto__ = function(state_43707){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__42267__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__42267__auto____1.call(this,state_43707);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__42267__auto____0;
cljs$core$async$reduce_$_state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__42267__auto____1;
return cljs$core$async$reduce_$_state_machine__42267__auto__;
})()
})();
var state__42561__auto__ = (function (){var statearr_43777 = f__42560__auto__.call(null);
(statearr_43777[(6)] = c__42559__auto__);

return statearr_43777;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42561__auto__);
}));

return c__42559__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__42559__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42560__auto__ = (function (){var switch__42266__auto__ = (function (state_43787){
var state_val_43788 = (state_43787[(1)]);
if((state_val_43788 === (1))){
var inst_43781 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_43787__$1 = state_43787;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43787__$1,(2),inst_43781);
} else {
if((state_val_43788 === (2))){
var inst_43783 = (state_43787[(2)]);
var inst_43784 = f__$1.call(null,inst_43783);
var state_43787__$1 = state_43787;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43787__$1,inst_43784);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__42267__auto__ = null;
var cljs$core$async$transduce_$_state_machine__42267__auto____0 = (function (){
var statearr_43805 = [null,null,null,null,null,null,null];
(statearr_43805[(0)] = cljs$core$async$transduce_$_state_machine__42267__auto__);

(statearr_43805[(1)] = (1));

return statearr_43805;
});
var cljs$core$async$transduce_$_state_machine__42267__auto____1 = (function (state_43787){
while(true){
var ret_value__42268__auto__ = (function (){try{while(true){
var result__42269__auto__ = switch__42266__auto__.call(null,state_43787);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42269__auto__;
}
break;
}
}catch (e43806){var ex__42270__auto__ = e43806;
var statearr_43807_46679 = state_43787;
(statearr_43807_46679[(2)] = ex__42270__auto__);


if(cljs.core.seq.call(null,(state_43787[(4)]))){
var statearr_43809_46683 = state_43787;
(statearr_43809_46683[(1)] = cljs.core.first.call(null,(state_43787[(4)])));

} else {
throw ex__42270__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46695 = state_43787;
state_43787 = G__46695;
continue;
} else {
return ret_value__42268__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__42267__auto__ = function(state_43787){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__42267__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__42267__auto____1.call(this,state_43787);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__42267__auto____0;
cljs$core$async$transduce_$_state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__42267__auto____1;
return cljs$core$async$transduce_$_state_machine__42267__auto__;
})()
})();
var state__42561__auto__ = (function (){var statearr_43814 = f__42560__auto__.call(null);
(statearr_43814[(6)] = c__42559__auto__);

return statearr_43814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42561__auto__);
}));

return c__42559__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__43823 = arguments.length;
switch (G__43823) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__42559__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42560__auto__ = (function (){var switch__42266__auto__ = (function (state_43861){
var state_val_43862 = (state_43861[(1)]);
if((state_val_43862 === (7))){
var inst_43839 = (state_43861[(2)]);
var state_43861__$1 = state_43861;
var statearr_43867_46751 = state_43861__$1;
(statearr_43867_46751[(2)] = inst_43839);

(statearr_43867_46751[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43862 === (1))){
var inst_43829 = cljs.core.seq.call(null,coll);
var inst_43831 = inst_43829;
var state_43861__$1 = (function (){var statearr_43868 = state_43861;
(statearr_43868[(7)] = inst_43831);

return statearr_43868;
})();
var statearr_43869_46771 = state_43861__$1;
(statearr_43869_46771[(2)] = null);

(statearr_43869_46771[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43862 === (4))){
var inst_43831 = (state_43861[(7)]);
var inst_43837 = cljs.core.first.call(null,inst_43831);
var state_43861__$1 = state_43861;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_43861__$1,(7),ch,inst_43837);
} else {
if((state_val_43862 === (13))){
var inst_43853 = (state_43861[(2)]);
var state_43861__$1 = state_43861;
var statearr_43872_46774 = state_43861__$1;
(statearr_43872_46774[(2)] = inst_43853);

(statearr_43872_46774[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43862 === (6))){
var inst_43842 = (state_43861[(2)]);
var state_43861__$1 = state_43861;
if(cljs.core.truth_(inst_43842)){
var statearr_43876_46775 = state_43861__$1;
(statearr_43876_46775[(1)] = (8));

} else {
var statearr_43877_46776 = state_43861__$1;
(statearr_43877_46776[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43862 === (3))){
var inst_43857 = (state_43861[(2)]);
var state_43861__$1 = state_43861;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43861__$1,inst_43857);
} else {
if((state_val_43862 === (12))){
var state_43861__$1 = state_43861;
var statearr_43878_46778 = state_43861__$1;
(statearr_43878_46778[(2)] = null);

(statearr_43878_46778[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43862 === (2))){
var inst_43831 = (state_43861[(7)]);
var state_43861__$1 = state_43861;
if(cljs.core.truth_(inst_43831)){
var statearr_43880_46780 = state_43861__$1;
(statearr_43880_46780[(1)] = (4));

} else {
var statearr_43881_46781 = state_43861__$1;
(statearr_43881_46781[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43862 === (11))){
var inst_43849 = cljs.core.async.close_BANG_.call(null,ch);
var state_43861__$1 = state_43861;
var statearr_43883_46782 = state_43861__$1;
(statearr_43883_46782[(2)] = inst_43849);

(statearr_43883_46782[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43862 === (9))){
var state_43861__$1 = state_43861;
if(cljs.core.truth_(close_QMARK_)){
var statearr_43884_46783 = state_43861__$1;
(statearr_43884_46783[(1)] = (11));

} else {
var statearr_43885_46784 = state_43861__$1;
(statearr_43885_46784[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43862 === (5))){
var inst_43831 = (state_43861[(7)]);
var state_43861__$1 = state_43861;
var statearr_43886_46786 = state_43861__$1;
(statearr_43886_46786[(2)] = inst_43831);

(statearr_43886_46786[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43862 === (10))){
var inst_43855 = (state_43861[(2)]);
var state_43861__$1 = state_43861;
var statearr_43887_46788 = state_43861__$1;
(statearr_43887_46788[(2)] = inst_43855);

(statearr_43887_46788[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43862 === (8))){
var inst_43831 = (state_43861[(7)]);
var inst_43844 = cljs.core.next.call(null,inst_43831);
var inst_43831__$1 = inst_43844;
var state_43861__$1 = (function (){var statearr_43895 = state_43861;
(statearr_43895[(7)] = inst_43831__$1);

return statearr_43895;
})();
var statearr_43897_46790 = state_43861__$1;
(statearr_43897_46790[(2)] = null);

(statearr_43897_46790[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42267__auto__ = null;
var cljs$core$async$state_machine__42267__auto____0 = (function (){
var statearr_43905 = [null,null,null,null,null,null,null,null];
(statearr_43905[(0)] = cljs$core$async$state_machine__42267__auto__);

(statearr_43905[(1)] = (1));

return statearr_43905;
});
var cljs$core$async$state_machine__42267__auto____1 = (function (state_43861){
while(true){
var ret_value__42268__auto__ = (function (){try{while(true){
var result__42269__auto__ = switch__42266__auto__.call(null,state_43861);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42269__auto__;
}
break;
}
}catch (e43906){var ex__42270__auto__ = e43906;
var statearr_43907_46793 = state_43861;
(statearr_43907_46793[(2)] = ex__42270__auto__);


if(cljs.core.seq.call(null,(state_43861[(4)]))){
var statearr_43908_46794 = state_43861;
(statearr_43908_46794[(1)] = cljs.core.first.call(null,(state_43861[(4)])));

} else {
throw ex__42270__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46797 = state_43861;
state_43861 = G__46797;
continue;
} else {
return ret_value__42268__auto__;
}
break;
}
});
cljs$core$async$state_machine__42267__auto__ = function(state_43861){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42267__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42267__auto____1.call(this,state_43861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42267__auto____0;
cljs$core$async$state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42267__auto____1;
return cljs$core$async$state_machine__42267__auto__;
})()
})();
var state__42561__auto__ = (function (){var statearr_43913 = f__42560__auto__.call(null);
(statearr_43913[(6)] = c__42559__auto__);

return statearr_43913;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42561__auto__);
}));

return c__42559__auto__;
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4487__auto__ = (((_ == null))?null:_);
var m__4488__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,_);
} else {
var m__4485__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4485__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,m,ch);
} else {
var m__4485__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,m);
} else {
var m__4485__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43975 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43975 = (function (ch,cs,meta43976){
this.ch = ch;
this.cs = cs;
this.meta43976 = meta43976;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43975.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43977,meta43976__$1){
var self__ = this;
var _43977__$1 = this;
return (new cljs.core.async.t_cljs$core$async43975(self__.ch,self__.cs,meta43976__$1));
}));

(cljs.core.async.t_cljs$core$async43975.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43977){
var self__ = this;
var _43977__$1 = this;
return self__.meta43976;
}));

(cljs.core.async.t_cljs$core$async43975.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43975.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async43975.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43975.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async43975.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async43975.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async43975.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta43976","meta43976",1328974896,null)], null);
}));

(cljs.core.async.t_cljs$core$async43975.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43975.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43975");

(cljs.core.async.t_cljs$core$async43975.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"cljs.core.async/t_cljs$core$async43975");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43975.
 */
cljs.core.async.__GT_t_cljs$core$async43975 = (function cljs$core$async$mult_$___GT_t_cljs$core$async43975(ch__$1,cs__$1,meta43976){
return (new cljs.core.async.t_cljs$core$async43975(ch__$1,cs__$1,meta43976));
});

}

return (new cljs.core.async.t_cljs$core$async43975(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});
var c__42559__auto___46850 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42560__auto__ = (function (){var switch__42266__auto__ = (function (state_44155){
var state_val_44156 = (state_44155[(1)]);
if((state_val_44156 === (7))){
var inst_44151 = (state_44155[(2)]);
var state_44155__$1 = state_44155;
var statearr_44173_46862 = state_44155__$1;
(statearr_44173_46862[(2)] = inst_44151);

(statearr_44173_46862[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (20))){
var inst_44037 = (state_44155[(7)]);
var inst_44053 = cljs.core.first.call(null,inst_44037);
var inst_44054 = cljs.core.nth.call(null,inst_44053,(0),null);
var inst_44055 = cljs.core.nth.call(null,inst_44053,(1),null);
var state_44155__$1 = (function (){var statearr_44175 = state_44155;
(statearr_44175[(8)] = inst_44054);

return statearr_44175;
})();
if(cljs.core.truth_(inst_44055)){
var statearr_44181_46868 = state_44155__$1;
(statearr_44181_46868[(1)] = (22));

} else {
var statearr_44183_46869 = state_44155__$1;
(statearr_44183_46869[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (27))){
var inst_44087 = (state_44155[(9)]);
var inst_44094 = (state_44155[(10)]);
var inst_44000 = (state_44155[(11)]);
var inst_44089 = (state_44155[(12)]);
var inst_44094__$1 = cljs.core._nth.call(null,inst_44087,inst_44089);
var inst_44095 = cljs.core.async.put_BANG_.call(null,inst_44094__$1,inst_44000,done);
var state_44155__$1 = (function (){var statearr_44187 = state_44155;
(statearr_44187[(10)] = inst_44094__$1);

return statearr_44187;
})();
if(cljs.core.truth_(inst_44095)){
var statearr_44188_46879 = state_44155__$1;
(statearr_44188_46879[(1)] = (30));

} else {
var statearr_44189_46880 = state_44155__$1;
(statearr_44189_46880[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (1))){
var state_44155__$1 = state_44155;
var statearr_44199_46881 = state_44155__$1;
(statearr_44199_46881[(2)] = null);

(statearr_44199_46881[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (24))){
var inst_44037 = (state_44155[(7)]);
var inst_44064 = (state_44155[(2)]);
var inst_44065 = cljs.core.next.call(null,inst_44037);
var inst_44013 = inst_44065;
var inst_44014 = null;
var inst_44015 = (0);
var inst_44016 = (0);
var state_44155__$1 = (function (){var statearr_44203 = state_44155;
(statearr_44203[(13)] = inst_44064);

(statearr_44203[(14)] = inst_44013);

(statearr_44203[(15)] = inst_44015);

(statearr_44203[(16)] = inst_44014);

(statearr_44203[(17)] = inst_44016);

return statearr_44203;
})();
var statearr_44205_46886 = state_44155__$1;
(statearr_44205_46886[(2)] = null);

(statearr_44205_46886[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (39))){
var state_44155__$1 = state_44155;
var statearr_44215_46901 = state_44155__$1;
(statearr_44215_46901[(2)] = null);

(statearr_44215_46901[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (4))){
var inst_44000 = (state_44155[(11)]);
var inst_44000__$1 = (state_44155[(2)]);
var inst_44001 = (inst_44000__$1 == null);
var state_44155__$1 = (function (){var statearr_44219 = state_44155;
(statearr_44219[(11)] = inst_44000__$1);

return statearr_44219;
})();
if(cljs.core.truth_(inst_44001)){
var statearr_44220_46911 = state_44155__$1;
(statearr_44220_46911[(1)] = (5));

} else {
var statearr_44222_46913 = state_44155__$1;
(statearr_44222_46913[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (15))){
var inst_44013 = (state_44155[(14)]);
var inst_44015 = (state_44155[(15)]);
var inst_44014 = (state_44155[(16)]);
var inst_44016 = (state_44155[(17)]);
var inst_44033 = (state_44155[(2)]);
var inst_44034 = (inst_44016 + (1));
var tmp44212 = inst_44013;
var tmp44213 = inst_44015;
var tmp44214 = inst_44014;
var inst_44013__$1 = tmp44212;
var inst_44014__$1 = tmp44214;
var inst_44015__$1 = tmp44213;
var inst_44016__$1 = inst_44034;
var state_44155__$1 = (function (){var statearr_44228 = state_44155;
(statearr_44228[(14)] = inst_44013__$1);

(statearr_44228[(15)] = inst_44015__$1);

(statearr_44228[(16)] = inst_44014__$1);

(statearr_44228[(18)] = inst_44033);

(statearr_44228[(17)] = inst_44016__$1);

return statearr_44228;
})();
var statearr_44229_46941 = state_44155__$1;
(statearr_44229_46941[(2)] = null);

(statearr_44229_46941[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (21))){
var inst_44068 = (state_44155[(2)]);
var state_44155__$1 = state_44155;
var statearr_44235_46945 = state_44155__$1;
(statearr_44235_46945[(2)] = inst_44068);

(statearr_44235_46945[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (31))){
var inst_44094 = (state_44155[(10)]);
var inst_44098 = cljs.core.async.untap_STAR_.call(null,m,inst_44094);
var state_44155__$1 = state_44155;
var statearr_44236_46961 = state_44155__$1;
(statearr_44236_46961[(2)] = inst_44098);

(statearr_44236_46961[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (32))){
var inst_44087 = (state_44155[(9)]);
var inst_44088 = (state_44155[(19)]);
var inst_44089 = (state_44155[(12)]);
var inst_44086 = (state_44155[(20)]);
var inst_44101 = (state_44155[(2)]);
var inst_44105 = (inst_44089 + (1));
var tmp44232 = inst_44087;
var tmp44233 = inst_44088;
var tmp44234 = inst_44086;
var inst_44086__$1 = tmp44234;
var inst_44087__$1 = tmp44232;
var inst_44088__$1 = tmp44233;
var inst_44089__$1 = inst_44105;
var state_44155__$1 = (function (){var statearr_44242 = state_44155;
(statearr_44242[(9)] = inst_44087__$1);

(statearr_44242[(19)] = inst_44088__$1);

(statearr_44242[(21)] = inst_44101);

(statearr_44242[(12)] = inst_44089__$1);

(statearr_44242[(20)] = inst_44086__$1);

return statearr_44242;
})();
var statearr_44244_47010 = state_44155__$1;
(statearr_44244_47010[(2)] = null);

(statearr_44244_47010[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (40))){
var inst_44119 = (state_44155[(22)]);
var inst_44124 = cljs.core.async.untap_STAR_.call(null,m,inst_44119);
var state_44155__$1 = state_44155;
var statearr_44245_47018 = state_44155__$1;
(statearr_44245_47018[(2)] = inst_44124);

(statearr_44245_47018[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (33))){
var inst_44109 = (state_44155[(23)]);
var inst_44112 = cljs.core.chunked_seq_QMARK_.call(null,inst_44109);
var state_44155__$1 = state_44155;
if(inst_44112){
var statearr_44248_47022 = state_44155__$1;
(statearr_44248_47022[(1)] = (36));

} else {
var statearr_44249_47023 = state_44155__$1;
(statearr_44249_47023[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (13))){
var inst_44026 = (state_44155[(24)]);
var inst_44030 = cljs.core.async.close_BANG_.call(null,inst_44026);
var state_44155__$1 = state_44155;
var statearr_44250_47026 = state_44155__$1;
(statearr_44250_47026[(2)] = inst_44030);

(statearr_44250_47026[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (22))){
var inst_44054 = (state_44155[(8)]);
var inst_44061 = cljs.core.async.close_BANG_.call(null,inst_44054);
var state_44155__$1 = state_44155;
var statearr_44251_47031 = state_44155__$1;
(statearr_44251_47031[(2)] = inst_44061);

(statearr_44251_47031[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (36))){
var inst_44109 = (state_44155[(23)]);
var inst_44114 = cljs.core.chunk_first.call(null,inst_44109);
var inst_44115 = cljs.core.chunk_rest.call(null,inst_44109);
var inst_44116 = cljs.core.count.call(null,inst_44114);
var inst_44086 = inst_44115;
var inst_44087 = inst_44114;
var inst_44088 = inst_44116;
var inst_44089 = (0);
var state_44155__$1 = (function (){var statearr_44252 = state_44155;
(statearr_44252[(9)] = inst_44087);

(statearr_44252[(19)] = inst_44088);

(statearr_44252[(12)] = inst_44089);

(statearr_44252[(20)] = inst_44086);

return statearr_44252;
})();
var statearr_44253_47039 = state_44155__$1;
(statearr_44253_47039[(2)] = null);

(statearr_44253_47039[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (41))){
var inst_44109 = (state_44155[(23)]);
var inst_44126 = (state_44155[(2)]);
var inst_44127 = cljs.core.next.call(null,inst_44109);
var inst_44086 = inst_44127;
var inst_44087 = null;
var inst_44088 = (0);
var inst_44089 = (0);
var state_44155__$1 = (function (){var statearr_44257 = state_44155;
(statearr_44257[(9)] = inst_44087);

(statearr_44257[(19)] = inst_44088);

(statearr_44257[(12)] = inst_44089);

(statearr_44257[(20)] = inst_44086);

(statearr_44257[(25)] = inst_44126);

return statearr_44257;
})();
var statearr_44258_47067 = state_44155__$1;
(statearr_44258_47067[(2)] = null);

(statearr_44258_47067[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (43))){
var state_44155__$1 = state_44155;
var statearr_44260_47074 = state_44155__$1;
(statearr_44260_47074[(2)] = null);

(statearr_44260_47074[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (29))){
var inst_44139 = (state_44155[(2)]);
var state_44155__$1 = state_44155;
var statearr_44263_47087 = state_44155__$1;
(statearr_44263_47087[(2)] = inst_44139);

(statearr_44263_47087[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (44))){
var inst_44148 = (state_44155[(2)]);
var state_44155__$1 = (function (){var statearr_44266 = state_44155;
(statearr_44266[(26)] = inst_44148);

return statearr_44266;
})();
var statearr_44267_47117 = state_44155__$1;
(statearr_44267_47117[(2)] = null);

(statearr_44267_47117[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (6))){
var inst_44078 = (state_44155[(27)]);
var inst_44077 = cljs.core.deref.call(null,cs);
var inst_44078__$1 = cljs.core.keys.call(null,inst_44077);
var inst_44079 = cljs.core.count.call(null,inst_44078__$1);
var inst_44080 = cljs.core.reset_BANG_.call(null,dctr,inst_44079);
var inst_44085 = cljs.core.seq.call(null,inst_44078__$1);
var inst_44086 = inst_44085;
var inst_44087 = null;
var inst_44088 = (0);
var inst_44089 = (0);
var state_44155__$1 = (function (){var statearr_44268 = state_44155;
(statearr_44268[(9)] = inst_44087);

(statearr_44268[(27)] = inst_44078__$1);

(statearr_44268[(19)] = inst_44088);

(statearr_44268[(28)] = inst_44080);

(statearr_44268[(12)] = inst_44089);

(statearr_44268[(20)] = inst_44086);

return statearr_44268;
})();
var statearr_44269_47162 = state_44155__$1;
(statearr_44269_47162[(2)] = null);

(statearr_44269_47162[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (28))){
var inst_44109 = (state_44155[(23)]);
var inst_44086 = (state_44155[(20)]);
var inst_44109__$1 = cljs.core.seq.call(null,inst_44086);
var state_44155__$1 = (function (){var statearr_44271 = state_44155;
(statearr_44271[(23)] = inst_44109__$1);

return statearr_44271;
})();
if(inst_44109__$1){
var statearr_44273_47170 = state_44155__$1;
(statearr_44273_47170[(1)] = (33));

} else {
var statearr_44274_47171 = state_44155__$1;
(statearr_44274_47171[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (25))){
var inst_44088 = (state_44155[(19)]);
var inst_44089 = (state_44155[(12)]);
var inst_44091 = (inst_44089 < inst_44088);
var inst_44092 = inst_44091;
var state_44155__$1 = state_44155;
if(cljs.core.truth_(inst_44092)){
var statearr_44276_47177 = state_44155__$1;
(statearr_44276_47177[(1)] = (27));

} else {
var statearr_44278_47178 = state_44155__$1;
(statearr_44278_47178[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (34))){
var state_44155__$1 = state_44155;
var statearr_44279_47182 = state_44155__$1;
(statearr_44279_47182[(2)] = null);

(statearr_44279_47182[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (17))){
var state_44155__$1 = state_44155;
var statearr_44282_47184 = state_44155__$1;
(statearr_44282_47184[(2)] = null);

(statearr_44282_47184[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (3))){
var inst_44153 = (state_44155[(2)]);
var state_44155__$1 = state_44155;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44155__$1,inst_44153);
} else {
if((state_val_44156 === (12))){
var inst_44073 = (state_44155[(2)]);
var state_44155__$1 = state_44155;
var statearr_44283_47189 = state_44155__$1;
(statearr_44283_47189[(2)] = inst_44073);

(statearr_44283_47189[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (2))){
var state_44155__$1 = state_44155;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44155__$1,(4),ch);
} else {
if((state_val_44156 === (23))){
var state_44155__$1 = state_44155;
var statearr_44284_47192 = state_44155__$1;
(statearr_44284_47192[(2)] = null);

(statearr_44284_47192[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (35))){
var inst_44137 = (state_44155[(2)]);
var state_44155__$1 = state_44155;
var statearr_44286_47194 = state_44155__$1;
(statearr_44286_47194[(2)] = inst_44137);

(statearr_44286_47194[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (19))){
var inst_44037 = (state_44155[(7)]);
var inst_44043 = cljs.core.chunk_first.call(null,inst_44037);
var inst_44044 = cljs.core.chunk_rest.call(null,inst_44037);
var inst_44045 = cljs.core.count.call(null,inst_44043);
var inst_44013 = inst_44044;
var inst_44014 = inst_44043;
var inst_44015 = inst_44045;
var inst_44016 = (0);
var state_44155__$1 = (function (){var statearr_44290 = state_44155;
(statearr_44290[(14)] = inst_44013);

(statearr_44290[(15)] = inst_44015);

(statearr_44290[(16)] = inst_44014);

(statearr_44290[(17)] = inst_44016);

return statearr_44290;
})();
var statearr_44291_47200 = state_44155__$1;
(statearr_44291_47200[(2)] = null);

(statearr_44291_47200[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (11))){
var inst_44013 = (state_44155[(14)]);
var inst_44037 = (state_44155[(7)]);
var inst_44037__$1 = cljs.core.seq.call(null,inst_44013);
var state_44155__$1 = (function (){var statearr_44303 = state_44155;
(statearr_44303[(7)] = inst_44037__$1);

return statearr_44303;
})();
if(inst_44037__$1){
var statearr_44308_47204 = state_44155__$1;
(statearr_44308_47204[(1)] = (16));

} else {
var statearr_44310_47205 = state_44155__$1;
(statearr_44310_47205[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (9))){
var inst_44075 = (state_44155[(2)]);
var state_44155__$1 = state_44155;
var statearr_44318_47207 = state_44155__$1;
(statearr_44318_47207[(2)] = inst_44075);

(statearr_44318_47207[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (5))){
var inst_44007 = cljs.core.deref.call(null,cs);
var inst_44008 = cljs.core.seq.call(null,inst_44007);
var inst_44013 = inst_44008;
var inst_44014 = null;
var inst_44015 = (0);
var inst_44016 = (0);
var state_44155__$1 = (function (){var statearr_44330 = state_44155;
(statearr_44330[(14)] = inst_44013);

(statearr_44330[(15)] = inst_44015);

(statearr_44330[(16)] = inst_44014);

(statearr_44330[(17)] = inst_44016);

return statearr_44330;
})();
var statearr_44333_47213 = state_44155__$1;
(statearr_44333_47213[(2)] = null);

(statearr_44333_47213[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (14))){
var state_44155__$1 = state_44155;
var statearr_44343_47217 = state_44155__$1;
(statearr_44343_47217[(2)] = null);

(statearr_44343_47217[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (45))){
var inst_44145 = (state_44155[(2)]);
var state_44155__$1 = state_44155;
var statearr_44344_47222 = state_44155__$1;
(statearr_44344_47222[(2)] = inst_44145);

(statearr_44344_47222[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (26))){
var inst_44078 = (state_44155[(27)]);
var inst_44141 = (state_44155[(2)]);
var inst_44142 = cljs.core.seq.call(null,inst_44078);
var state_44155__$1 = (function (){var statearr_44359 = state_44155;
(statearr_44359[(29)] = inst_44141);

return statearr_44359;
})();
if(inst_44142){
var statearr_44364_47226 = state_44155__$1;
(statearr_44364_47226[(1)] = (42));

} else {
var statearr_44368_47227 = state_44155__$1;
(statearr_44368_47227[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (16))){
var inst_44037 = (state_44155[(7)]);
var inst_44041 = cljs.core.chunked_seq_QMARK_.call(null,inst_44037);
var state_44155__$1 = state_44155;
if(inst_44041){
var statearr_44379_47230 = state_44155__$1;
(statearr_44379_47230[(1)] = (19));

} else {
var statearr_44380_47232 = state_44155__$1;
(statearr_44380_47232[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (38))){
var inst_44134 = (state_44155[(2)]);
var state_44155__$1 = state_44155;
var statearr_44382_47233 = state_44155__$1;
(statearr_44382_47233[(2)] = inst_44134);

(statearr_44382_47233[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (30))){
var state_44155__$1 = state_44155;
var statearr_44384_47234 = state_44155__$1;
(statearr_44384_47234[(2)] = null);

(statearr_44384_47234[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (10))){
var inst_44014 = (state_44155[(16)]);
var inst_44016 = (state_44155[(17)]);
var inst_44024 = cljs.core._nth.call(null,inst_44014,inst_44016);
var inst_44026 = cljs.core.nth.call(null,inst_44024,(0),null);
var inst_44028 = cljs.core.nth.call(null,inst_44024,(1),null);
var state_44155__$1 = (function (){var statearr_44389 = state_44155;
(statearr_44389[(24)] = inst_44026);

return statearr_44389;
})();
if(cljs.core.truth_(inst_44028)){
var statearr_44390_47236 = state_44155__$1;
(statearr_44390_47236[(1)] = (13));

} else {
var statearr_44391_47237 = state_44155__$1;
(statearr_44391_47237[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (18))){
var inst_44071 = (state_44155[(2)]);
var state_44155__$1 = state_44155;
var statearr_44392_47238 = state_44155__$1;
(statearr_44392_47238[(2)] = inst_44071);

(statearr_44392_47238[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (42))){
var state_44155__$1 = state_44155;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44155__$1,(45),dchan);
} else {
if((state_val_44156 === (37))){
var inst_44109 = (state_44155[(23)]);
var inst_44119 = (state_44155[(22)]);
var inst_44000 = (state_44155[(11)]);
var inst_44119__$1 = cljs.core.first.call(null,inst_44109);
var inst_44121 = cljs.core.async.put_BANG_.call(null,inst_44119__$1,inst_44000,done);
var state_44155__$1 = (function (){var statearr_44393 = state_44155;
(statearr_44393[(22)] = inst_44119__$1);

return statearr_44393;
})();
if(cljs.core.truth_(inst_44121)){
var statearr_44394_47240 = state_44155__$1;
(statearr_44394_47240[(1)] = (39));

} else {
var statearr_44395_47241 = state_44155__$1;
(statearr_44395_47241[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44156 === (8))){
var inst_44015 = (state_44155[(15)]);
var inst_44016 = (state_44155[(17)]);
var inst_44018 = (inst_44016 < inst_44015);
var inst_44019 = inst_44018;
var state_44155__$1 = state_44155;
if(cljs.core.truth_(inst_44019)){
var statearr_44396_47275 = state_44155__$1;
(statearr_44396_47275[(1)] = (10));

} else {
var statearr_44397_47276 = state_44155__$1;
(statearr_44397_47276[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__42267__auto__ = null;
var cljs$core$async$mult_$_state_machine__42267__auto____0 = (function (){
var statearr_44409 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44409[(0)] = cljs$core$async$mult_$_state_machine__42267__auto__);

(statearr_44409[(1)] = (1));

return statearr_44409;
});
var cljs$core$async$mult_$_state_machine__42267__auto____1 = (function (state_44155){
while(true){
var ret_value__42268__auto__ = (function (){try{while(true){
var result__42269__auto__ = switch__42266__auto__.call(null,state_44155);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42269__auto__;
}
break;
}
}catch (e44410){var ex__42270__auto__ = e44410;
var statearr_44412_47283 = state_44155;
(statearr_44412_47283[(2)] = ex__42270__auto__);


if(cljs.core.seq.call(null,(state_44155[(4)]))){
var statearr_44414_47285 = state_44155;
(statearr_44414_47285[(1)] = cljs.core.first.call(null,(state_44155[(4)])));

} else {
throw ex__42270__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47289 = state_44155;
state_44155 = G__47289;
continue;
} else {
return ret_value__42268__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__42267__auto__ = function(state_44155){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__42267__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__42267__auto____1.call(this,state_44155);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__42267__auto____0;
cljs$core$async$mult_$_state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__42267__auto____1;
return cljs$core$async$mult_$_state_machine__42267__auto__;
})()
})();
var state__42561__auto__ = (function (){var statearr_44421 = f__42560__auto__.call(null);
(statearr_44421[(6)] = c__42559__auto___46850);

return statearr_44421;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42561__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__44423 = arguments.length;
switch (G__44423) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,m,ch);
} else {
var m__4485__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,m,ch);
} else {
var m__4485__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,m);
} else {
var m__4485__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,m,state_map);
} else {
var m__4485__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,m,mode);
} else {
var m__4485__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___47471 = arguments.length;
var i__4790__auto___47472 = (0);
while(true){
if((i__4790__auto___47472 < len__4789__auto___47471)){
args__4795__auto__.push((arguments[i__4790__auto___47472]));

var G__47474 = (i__4790__auto___47472 + (1));
i__4790__auto___47472 = G__47474;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((3) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4796__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__44468){
var map__44469 = p__44468;
var map__44469__$1 = (((((!((map__44469 == null))))?(((((map__44469.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44469.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44469):map__44469);
var opts = map__44469__$1;
var statearr_44475_47514 = state;
(statearr_44475_47514[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts.call(null,(function (val){
var statearr_44481_47527 = state;
(statearr_44481_47527[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_44482_47533 = state;
(statearr_44482_47533[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq44462){
var G__44463 = cljs.core.first.call(null,seq44462);
var seq44462__$1 = cljs.core.next.call(null,seq44462);
var G__44464 = cljs.core.first.call(null,seq44462__$1);
var seq44462__$2 = cljs.core.next.call(null,seq44462__$1);
var G__44465 = cljs.core.first.call(null,seq44462__$2);
var seq44462__$3 = cljs.core.next.call(null,seq44462__$2);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44463,G__44464,G__44465,seq44462__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null,cljs.core.async.sliding_buffer.call(null,(1)));
var changed = (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv.call(null,(function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44488 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44488 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta44489){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta44489 = meta44489;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44488.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44490,meta44489__$1){
var self__ = this;
var _44490__$1 = this;
return (new cljs.core.async.t_cljs$core$async44488(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta44489__$1));
}));

(cljs.core.async.t_cljs$core$async44488.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44490){
var self__ = this;
var _44490__$1 = this;
return self__.meta44489;
}));

(cljs.core.async.t_cljs$core$async44488.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44488.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async44488.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44488.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async44488.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async44488.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async44488.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async44488.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async44488.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta44489","meta44489",430345114,null)], null);
}));

(cljs.core.async.t_cljs$core$async44488.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44488.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44488");

(cljs.core.async.t_cljs$core$async44488.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"cljs.core.async/t_cljs$core$async44488");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44488.
 */
cljs.core.async.__GT_t_cljs$core$async44488 = (function cljs$core$async$mix_$___GT_t_cljs$core$async44488(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta44489){
return (new cljs.core.async.t_cljs$core$async44488(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta44489));
});

}

return (new cljs.core.async.t_cljs$core$async44488(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__42559__auto___47620 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42560__auto__ = (function (){var switch__42266__auto__ = (function (state_44631){
var state_val_44632 = (state_44631[(1)]);
if((state_val_44632 === (7))){
var inst_44532 = (state_44631[(2)]);
var state_44631__$1 = state_44631;
var statearr_44639_47625 = state_44631__$1;
(statearr_44639_47625[(2)] = inst_44532);

(statearr_44639_47625[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (20))){
var inst_44548 = (state_44631[(7)]);
var state_44631__$1 = state_44631;
var statearr_44640_47630 = state_44631__$1;
(statearr_44640_47630[(2)] = inst_44548);

(statearr_44640_47630[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (27))){
var state_44631__$1 = state_44631;
var statearr_44642_47633 = state_44631__$1;
(statearr_44642_47633[(2)] = null);

(statearr_44642_47633[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (1))){
var inst_44519 = (state_44631[(8)]);
var inst_44519__$1 = calc_state.call(null);
var inst_44521 = (inst_44519__$1 == null);
var inst_44522 = cljs.core.not.call(null,inst_44521);
var state_44631__$1 = (function (){var statearr_44645 = state_44631;
(statearr_44645[(8)] = inst_44519__$1);

return statearr_44645;
})();
if(inst_44522){
var statearr_44646_47637 = state_44631__$1;
(statearr_44646_47637[(1)] = (2));

} else {
var statearr_44648_47639 = state_44631__$1;
(statearr_44648_47639[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (24))){
var inst_44587 = (state_44631[(9)]);
var inst_44578 = (state_44631[(10)]);
var inst_44601 = (state_44631[(11)]);
var inst_44601__$1 = inst_44578.call(null,inst_44587);
var state_44631__$1 = (function (){var statearr_44655 = state_44631;
(statearr_44655[(11)] = inst_44601__$1);

return statearr_44655;
})();
if(cljs.core.truth_(inst_44601__$1)){
var statearr_44656_47641 = state_44631__$1;
(statearr_44656_47641[(1)] = (29));

} else {
var statearr_44658_47643 = state_44631__$1;
(statearr_44658_47643[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (4))){
var inst_44535 = (state_44631[(2)]);
var state_44631__$1 = state_44631;
if(cljs.core.truth_(inst_44535)){
var statearr_44659_47645 = state_44631__$1;
(statearr_44659_47645[(1)] = (8));

} else {
var statearr_44660_47646 = state_44631__$1;
(statearr_44660_47646[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (15))){
var inst_44568 = (state_44631[(2)]);
var state_44631__$1 = state_44631;
if(cljs.core.truth_(inst_44568)){
var statearr_44661_47649 = state_44631__$1;
(statearr_44661_47649[(1)] = (19));

} else {
var statearr_44662_47652 = state_44631__$1;
(statearr_44662_47652[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (21))){
var inst_44577 = (state_44631[(12)]);
var inst_44577__$1 = (state_44631[(2)]);
var inst_44578 = cljs.core.get.call(null,inst_44577__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_44579 = cljs.core.get.call(null,inst_44577__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_44580 = cljs.core.get.call(null,inst_44577__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_44631__$1 = (function (){var statearr_44668 = state_44631;
(statearr_44668[(12)] = inst_44577__$1);

(statearr_44668[(10)] = inst_44578);

(statearr_44668[(13)] = inst_44579);

return statearr_44668;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_44631__$1,(22),inst_44580);
} else {
if((state_val_44632 === (31))){
var inst_44610 = (state_44631[(2)]);
var state_44631__$1 = state_44631;
if(cljs.core.truth_(inst_44610)){
var statearr_44670_47661 = state_44631__$1;
(statearr_44670_47661[(1)] = (32));

} else {
var statearr_44671_47662 = state_44631__$1;
(statearr_44671_47662[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (32))){
var inst_44586 = (state_44631[(14)]);
var state_44631__$1 = state_44631;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44631__$1,(35),out,inst_44586);
} else {
if((state_val_44632 === (33))){
var inst_44577 = (state_44631[(12)]);
var inst_44548 = inst_44577;
var state_44631__$1 = (function (){var statearr_44673 = state_44631;
(statearr_44673[(7)] = inst_44548);

return statearr_44673;
})();
var statearr_44674_47667 = state_44631__$1;
(statearr_44674_47667[(2)] = null);

(statearr_44674_47667[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (13))){
var inst_44548 = (state_44631[(7)]);
var inst_44556 = inst_44548.cljs$lang$protocol_mask$partition0$;
var inst_44557 = (inst_44556 & (64));
var inst_44558 = inst_44548.cljs$core$ISeq$;
var inst_44559 = (cljs.core.PROTOCOL_SENTINEL === inst_44558);
var inst_44560 = ((inst_44557) || (inst_44559));
var state_44631__$1 = state_44631;
if(cljs.core.truth_(inst_44560)){
var statearr_44675_47670 = state_44631__$1;
(statearr_44675_47670[(1)] = (16));

} else {
var statearr_44679_47672 = state_44631__$1;
(statearr_44679_47672[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (22))){
var inst_44586 = (state_44631[(14)]);
var inst_44587 = (state_44631[(9)]);
var inst_44585 = (state_44631[(2)]);
var inst_44586__$1 = cljs.core.nth.call(null,inst_44585,(0),null);
var inst_44587__$1 = cljs.core.nth.call(null,inst_44585,(1),null);
var inst_44588 = (inst_44586__$1 == null);
var inst_44589 = cljs.core._EQ_.call(null,inst_44587__$1,change);
var inst_44590 = ((inst_44588) || (inst_44589));
var state_44631__$1 = (function (){var statearr_44682 = state_44631;
(statearr_44682[(14)] = inst_44586__$1);

(statearr_44682[(9)] = inst_44587__$1);

return statearr_44682;
})();
if(cljs.core.truth_(inst_44590)){
var statearr_44683_47678 = state_44631__$1;
(statearr_44683_47678[(1)] = (23));

} else {
var statearr_44684_47679 = state_44631__$1;
(statearr_44684_47679[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (36))){
var inst_44577 = (state_44631[(12)]);
var inst_44548 = inst_44577;
var state_44631__$1 = (function (){var statearr_44685 = state_44631;
(statearr_44685[(7)] = inst_44548);

return statearr_44685;
})();
var statearr_44688_47682 = state_44631__$1;
(statearr_44688_47682[(2)] = null);

(statearr_44688_47682[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (29))){
var inst_44601 = (state_44631[(11)]);
var state_44631__$1 = state_44631;
var statearr_44689_47684 = state_44631__$1;
(statearr_44689_47684[(2)] = inst_44601);

(statearr_44689_47684[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (6))){
var state_44631__$1 = state_44631;
var statearr_44690_47686 = state_44631__$1;
(statearr_44690_47686[(2)] = false);

(statearr_44690_47686[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (28))){
var inst_44597 = (state_44631[(2)]);
var inst_44598 = calc_state.call(null);
var inst_44548 = inst_44598;
var state_44631__$1 = (function (){var statearr_44691 = state_44631;
(statearr_44691[(7)] = inst_44548);

(statearr_44691[(15)] = inst_44597);

return statearr_44691;
})();
var statearr_44692_47695 = state_44631__$1;
(statearr_44692_47695[(2)] = null);

(statearr_44692_47695[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (25))){
var inst_44624 = (state_44631[(2)]);
var state_44631__$1 = state_44631;
var statearr_44693_47697 = state_44631__$1;
(statearr_44693_47697[(2)] = inst_44624);

(statearr_44693_47697[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (34))){
var inst_44622 = (state_44631[(2)]);
var state_44631__$1 = state_44631;
var statearr_44694_47700 = state_44631__$1;
(statearr_44694_47700[(2)] = inst_44622);

(statearr_44694_47700[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (17))){
var state_44631__$1 = state_44631;
var statearr_44695_47702 = state_44631__$1;
(statearr_44695_47702[(2)] = false);

(statearr_44695_47702[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (3))){
var state_44631__$1 = state_44631;
var statearr_44696_47704 = state_44631__$1;
(statearr_44696_47704[(2)] = false);

(statearr_44696_47704[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (12))){
var inst_44626 = (state_44631[(2)]);
var state_44631__$1 = state_44631;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44631__$1,inst_44626);
} else {
if((state_val_44632 === (2))){
var inst_44519 = (state_44631[(8)]);
var inst_44524 = inst_44519.cljs$lang$protocol_mask$partition0$;
var inst_44525 = (inst_44524 & (64));
var inst_44526 = inst_44519.cljs$core$ISeq$;
var inst_44527 = (cljs.core.PROTOCOL_SENTINEL === inst_44526);
var inst_44528 = ((inst_44525) || (inst_44527));
var state_44631__$1 = state_44631;
if(cljs.core.truth_(inst_44528)){
var statearr_44701_47711 = state_44631__$1;
(statearr_44701_47711[(1)] = (5));

} else {
var statearr_44702_47713 = state_44631__$1;
(statearr_44702_47713[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (23))){
var inst_44586 = (state_44631[(14)]);
var inst_44592 = (inst_44586 == null);
var state_44631__$1 = state_44631;
if(cljs.core.truth_(inst_44592)){
var statearr_44703_47716 = state_44631__$1;
(statearr_44703_47716[(1)] = (26));

} else {
var statearr_44704_47717 = state_44631__$1;
(statearr_44704_47717[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (35))){
var inst_44613 = (state_44631[(2)]);
var state_44631__$1 = state_44631;
if(cljs.core.truth_(inst_44613)){
var statearr_44705_47722 = state_44631__$1;
(statearr_44705_47722[(1)] = (36));

} else {
var statearr_44706_47723 = state_44631__$1;
(statearr_44706_47723[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (19))){
var inst_44548 = (state_44631[(7)]);
var inst_44574 = cljs.core.apply.call(null,cljs.core.hash_map,inst_44548);
var state_44631__$1 = state_44631;
var statearr_44707_47730 = state_44631__$1;
(statearr_44707_47730[(2)] = inst_44574);

(statearr_44707_47730[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (11))){
var inst_44548 = (state_44631[(7)]);
var inst_44552 = (inst_44548 == null);
var inst_44553 = cljs.core.not.call(null,inst_44552);
var state_44631__$1 = state_44631;
if(inst_44553){
var statearr_44708_47736 = state_44631__$1;
(statearr_44708_47736[(1)] = (13));

} else {
var statearr_44709_47738 = state_44631__$1;
(statearr_44709_47738[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (9))){
var inst_44519 = (state_44631[(8)]);
var state_44631__$1 = state_44631;
var statearr_44710_47740 = state_44631__$1;
(statearr_44710_47740[(2)] = inst_44519);

(statearr_44710_47740[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (5))){
var state_44631__$1 = state_44631;
var statearr_44711_47745 = state_44631__$1;
(statearr_44711_47745[(2)] = true);

(statearr_44711_47745[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (14))){
var state_44631__$1 = state_44631;
var statearr_44712_47748 = state_44631__$1;
(statearr_44712_47748[(2)] = false);

(statearr_44712_47748[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (26))){
var inst_44587 = (state_44631[(9)]);
var inst_44594 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_44587);
var state_44631__$1 = state_44631;
var statearr_44714_47753 = state_44631__$1;
(statearr_44714_47753[(2)] = inst_44594);

(statearr_44714_47753[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (16))){
var state_44631__$1 = state_44631;
var statearr_44716_47755 = state_44631__$1;
(statearr_44716_47755[(2)] = true);

(statearr_44716_47755[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (38))){
var inst_44618 = (state_44631[(2)]);
var state_44631__$1 = state_44631;
var statearr_44717_47759 = state_44631__$1;
(statearr_44717_47759[(2)] = inst_44618);

(statearr_44717_47759[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (30))){
var inst_44587 = (state_44631[(9)]);
var inst_44578 = (state_44631[(10)]);
var inst_44579 = (state_44631[(13)]);
var inst_44605 = cljs.core.empty_QMARK_.call(null,inst_44578);
var inst_44606 = inst_44579.call(null,inst_44587);
var inst_44607 = cljs.core.not.call(null,inst_44606);
var inst_44608 = ((inst_44605) && (inst_44607));
var state_44631__$1 = state_44631;
var statearr_44718_47767 = state_44631__$1;
(statearr_44718_47767[(2)] = inst_44608);

(statearr_44718_47767[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (10))){
var inst_44519 = (state_44631[(8)]);
var inst_44544 = (state_44631[(2)]);
var inst_44545 = cljs.core.get.call(null,inst_44544,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_44546 = cljs.core.get.call(null,inst_44544,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_44547 = cljs.core.get.call(null,inst_44544,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_44548 = inst_44519;
var state_44631__$1 = (function (){var statearr_44719 = state_44631;
(statearr_44719[(16)] = inst_44547);

(statearr_44719[(17)] = inst_44545);

(statearr_44719[(18)] = inst_44546);

(statearr_44719[(7)] = inst_44548);

return statearr_44719;
})();
var statearr_44720_47770 = state_44631__$1;
(statearr_44720_47770[(2)] = null);

(statearr_44720_47770[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (18))){
var inst_44565 = (state_44631[(2)]);
var state_44631__$1 = state_44631;
var statearr_44721_47772 = state_44631__$1;
(statearr_44721_47772[(2)] = inst_44565);

(statearr_44721_47772[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (37))){
var state_44631__$1 = state_44631;
var statearr_44725_47775 = state_44631__$1;
(statearr_44725_47775[(2)] = null);

(statearr_44725_47775[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44632 === (8))){
var inst_44519 = (state_44631[(8)]);
var inst_44541 = cljs.core.apply.call(null,cljs.core.hash_map,inst_44519);
var state_44631__$1 = state_44631;
var statearr_44731_47778 = state_44631__$1;
(statearr_44731_47778[(2)] = inst_44541);

(statearr_44731_47778[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__42267__auto__ = null;
var cljs$core$async$mix_$_state_machine__42267__auto____0 = (function (){
var statearr_44733 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44733[(0)] = cljs$core$async$mix_$_state_machine__42267__auto__);

(statearr_44733[(1)] = (1));

return statearr_44733;
});
var cljs$core$async$mix_$_state_machine__42267__auto____1 = (function (state_44631){
while(true){
var ret_value__42268__auto__ = (function (){try{while(true){
var result__42269__auto__ = switch__42266__auto__.call(null,state_44631);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42269__auto__;
}
break;
}
}catch (e44734){var ex__42270__auto__ = e44734;
var statearr_44735_47800 = state_44631;
(statearr_44735_47800[(2)] = ex__42270__auto__);


if(cljs.core.seq.call(null,(state_44631[(4)]))){
var statearr_44736_47802 = state_44631;
(statearr_44736_47802[(1)] = cljs.core.first.call(null,(state_44631[(4)])));

} else {
throw ex__42270__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47814 = state_44631;
state_44631 = G__47814;
continue;
} else {
return ret_value__42268__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__42267__auto__ = function(state_44631){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__42267__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__42267__auto____1.call(this,state_44631);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__42267__auto____0;
cljs$core$async$mix_$_state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__42267__auto____1;
return cljs$core$async$mix_$_state_machine__42267__auto__;
})()
})();
var state__42561__auto__ = (function (){var statearr_44738 = f__42560__auto__.call(null);
(statearr_44738[(6)] = c__42559__auto___47620);

return statearr_44738;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42561__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4487__auto__ = (((p == null))?null:p);
var m__4488__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4485__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4487__auto__ = (((p == null))?null:p);
var m__4488__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,p,v,ch);
} else {
var m__4485__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__44770 = arguments.length;
switch (G__44770) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4487__auto__ = (((p == null))?null:p);
var m__4488__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,p);
} else {
var m__4485__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4487__auto__ = (((p == null))?null:p);
var m__4488__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,p,v);
} else {
var m__4485__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__44783 = arguments.length;
switch (G__44783) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4185__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,(function (p1__44781_SHARP_){
if(cljs.core.truth_(p1__44781_SHARP_.call(null,topic))){
return p1__44781_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__44781_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44793 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44793 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta44794){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta44794 = meta44794;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44793.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44795,meta44794__$1){
var self__ = this;
var _44795__$1 = this;
return (new cljs.core.async.t_cljs$core$async44793(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta44794__$1));
}));

(cljs.core.async.t_cljs$core$async44793.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44795){
var self__ = this;
var _44795__$1 = this;
return self__.meta44794;
}));

(cljs.core.async.t_cljs$core$async44793.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44793.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async44793.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44793.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async44793.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async44793.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async44793.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async44793.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta44794","meta44794",-398853776,null)], null);
}));

(cljs.core.async.t_cljs$core$async44793.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44793.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44793");

(cljs.core.async.t_cljs$core$async44793.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"cljs.core.async/t_cljs$core$async44793");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44793.
 */
cljs.core.async.__GT_t_cljs$core$async44793 = (function cljs$core$async$__GT_t_cljs$core$async44793(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta44794){
return (new cljs.core.async.t_cljs$core$async44793(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta44794));
});

}

return (new cljs.core.async.t_cljs$core$async44793(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__42559__auto___48018 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42560__auto__ = (function (){var switch__42266__auto__ = (function (state_44901){
var state_val_44902 = (state_44901[(1)]);
if((state_val_44902 === (7))){
var inst_44897 = (state_44901[(2)]);
var state_44901__$1 = state_44901;
var statearr_44908_48022 = state_44901__$1;
(statearr_44908_48022[(2)] = inst_44897);

(statearr_44908_48022[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44902 === (20))){
var state_44901__$1 = state_44901;
var statearr_44909_48024 = state_44901__$1;
(statearr_44909_48024[(2)] = null);

(statearr_44909_48024[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44902 === (1))){
var state_44901__$1 = state_44901;
var statearr_44910_48029 = state_44901__$1;
(statearr_44910_48029[(2)] = null);

(statearr_44910_48029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44902 === (24))){
var inst_44878 = (state_44901[(7)]);
var inst_44889 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_44878);
var state_44901__$1 = state_44901;
var statearr_44911_48034 = state_44901__$1;
(statearr_44911_48034[(2)] = inst_44889);

(statearr_44911_48034[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44902 === (4))){
var inst_44818 = (state_44901[(8)]);
var inst_44818__$1 = (state_44901[(2)]);
var inst_44826 = (inst_44818__$1 == null);
var state_44901__$1 = (function (){var statearr_44912 = state_44901;
(statearr_44912[(8)] = inst_44818__$1);

return statearr_44912;
})();
if(cljs.core.truth_(inst_44826)){
var statearr_44913_48041 = state_44901__$1;
(statearr_44913_48041[(1)] = (5));

} else {
var statearr_44914_48044 = state_44901__$1;
(statearr_44914_48044[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44902 === (15))){
var inst_44871 = (state_44901[(2)]);
var state_44901__$1 = state_44901;
var statearr_44915_48051 = state_44901__$1;
(statearr_44915_48051[(2)] = inst_44871);

(statearr_44915_48051[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44902 === (21))){
var inst_44894 = (state_44901[(2)]);
var state_44901__$1 = (function (){var statearr_44916 = state_44901;
(statearr_44916[(9)] = inst_44894);

return statearr_44916;
})();
var statearr_44917_48056 = state_44901__$1;
(statearr_44917_48056[(2)] = null);

(statearr_44917_48056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44902 === (13))){
var inst_44851 = (state_44901[(10)]);
var inst_44855 = cljs.core.chunked_seq_QMARK_.call(null,inst_44851);
var state_44901__$1 = state_44901;
if(inst_44855){
var statearr_44919_48068 = state_44901__$1;
(statearr_44919_48068[(1)] = (16));

} else {
var statearr_44920_48069 = state_44901__$1;
(statearr_44920_48069[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44902 === (22))){
var inst_44885 = (state_44901[(2)]);
var state_44901__$1 = state_44901;
if(cljs.core.truth_(inst_44885)){
var statearr_44923_48071 = state_44901__$1;
(statearr_44923_48071[(1)] = (23));

} else {
var statearr_44924_48075 = state_44901__$1;
(statearr_44924_48075[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44902 === (6))){
var inst_44878 = (state_44901[(7)]);
var inst_44818 = (state_44901[(8)]);
var inst_44880 = (state_44901[(11)]);
var inst_44878__$1 = topic_fn.call(null,inst_44818);
var inst_44879 = cljs.core.deref.call(null,mults);
var inst_44880__$1 = cljs.core.get.call(null,inst_44879,inst_44878__$1);
var state_44901__$1 = (function (){var statearr_44926 = state_44901;
(statearr_44926[(7)] = inst_44878__$1);

(statearr_44926[(11)] = inst_44880__$1);

return statearr_44926;
})();
if(cljs.core.truth_(inst_44880__$1)){
var statearr_44927_48090 = state_44901__$1;
(statearr_44927_48090[(1)] = (19));

} else {
var statearr_44930_48091 = state_44901__$1;
(statearr_44930_48091[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44902 === (25))){
var inst_44891 = (state_44901[(2)]);
var state_44901__$1 = state_44901;
var statearr_44936_48097 = state_44901__$1;
(statearr_44936_48097[(2)] = inst_44891);

(statearr_44936_48097[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44902 === (17))){
var inst_44851 = (state_44901[(10)]);
var inst_44862 = cljs.core.first.call(null,inst_44851);
var inst_44863 = cljs.core.async.muxch_STAR_.call(null,inst_44862);
var inst_44864 = cljs.core.async.close_BANG_.call(null,inst_44863);
var inst_44865 = cljs.core.next.call(null,inst_44851);
var inst_44836 = inst_44865;
var inst_44837 = null;
var inst_44838 = (0);
var inst_44839 = (0);
var state_44901__$1 = (function (){var statearr_44939 = state_44901;
(statearr_44939[(12)] = inst_44839);

(statearr_44939[(13)] = inst_44836);

(statearr_44939[(14)] = inst_44864);

(statearr_44939[(15)] = inst_44837);

(statearr_44939[(16)] = inst_44838);

return statearr_44939;
})();
var statearr_44940_48106 = state_44901__$1;
(statearr_44940_48106[(2)] = null);

(statearr_44940_48106[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44902 === (3))){
var inst_44899 = (state_44901[(2)]);
var state_44901__$1 = state_44901;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44901__$1,inst_44899);
} else {
if((state_val_44902 === (12))){
var inst_44873 = (state_44901[(2)]);
var state_44901__$1 = state_44901;
var statearr_44946_48114 = state_44901__$1;
(statearr_44946_48114[(2)] = inst_44873);

(statearr_44946_48114[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44902 === (2))){
var state_44901__$1 = state_44901;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44901__$1,(4),ch);
} else {
if((state_val_44902 === (23))){
var state_44901__$1 = state_44901;
var statearr_44947_48118 = state_44901__$1;
(statearr_44947_48118[(2)] = null);

(statearr_44947_48118[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44902 === (19))){
var inst_44818 = (state_44901[(8)]);
var inst_44880 = (state_44901[(11)]);
var inst_44883 = cljs.core.async.muxch_STAR_.call(null,inst_44880);
var state_44901__$1 = state_44901;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44901__$1,(22),inst_44883,inst_44818);
} else {
if((state_val_44902 === (11))){
var inst_44836 = (state_44901[(13)]);
var inst_44851 = (state_44901[(10)]);
var inst_44851__$1 = cljs.core.seq.call(null,inst_44836);
var state_44901__$1 = (function (){var statearr_44952 = state_44901;
(statearr_44952[(10)] = inst_44851__$1);

return statearr_44952;
})();
if(inst_44851__$1){
var statearr_44954_48122 = state_44901__$1;
(statearr_44954_48122[(1)] = (13));

} else {
var statearr_44955_48124 = state_44901__$1;
(statearr_44955_48124[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44902 === (9))){
var inst_44875 = (state_44901[(2)]);
var state_44901__$1 = state_44901;
var statearr_44958_48130 = state_44901__$1;
(statearr_44958_48130[(2)] = inst_44875);

(statearr_44958_48130[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44902 === (5))){
var inst_44833 = cljs.core.deref.call(null,mults);
var inst_44834 = cljs.core.vals.call(null,inst_44833);
var inst_44835 = cljs.core.seq.call(null,inst_44834);
var inst_44836 = inst_44835;
var inst_44837 = null;
var inst_44838 = (0);
var inst_44839 = (0);
var state_44901__$1 = (function (){var statearr_44963 = state_44901;
(statearr_44963[(12)] = inst_44839);

(statearr_44963[(13)] = inst_44836);

(statearr_44963[(15)] = inst_44837);

(statearr_44963[(16)] = inst_44838);

return statearr_44963;
})();
var statearr_44965_48143 = state_44901__$1;
(statearr_44965_48143[(2)] = null);

(statearr_44965_48143[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44902 === (14))){
var state_44901__$1 = state_44901;
var statearr_44969_48144 = state_44901__$1;
(statearr_44969_48144[(2)] = null);

(statearr_44969_48144[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44902 === (16))){
var inst_44851 = (state_44901[(10)]);
var inst_44857 = cljs.core.chunk_first.call(null,inst_44851);
var inst_44858 = cljs.core.chunk_rest.call(null,inst_44851);
var inst_44859 = cljs.core.count.call(null,inst_44857);
var inst_44836 = inst_44858;
var inst_44837 = inst_44857;
var inst_44838 = inst_44859;
var inst_44839 = (0);
var state_44901__$1 = (function (){var statearr_44976 = state_44901;
(statearr_44976[(12)] = inst_44839);

(statearr_44976[(13)] = inst_44836);

(statearr_44976[(15)] = inst_44837);

(statearr_44976[(16)] = inst_44838);

return statearr_44976;
})();
var statearr_44978_48150 = state_44901__$1;
(statearr_44978_48150[(2)] = null);

(statearr_44978_48150[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44902 === (10))){
var inst_44839 = (state_44901[(12)]);
var inst_44836 = (state_44901[(13)]);
var inst_44837 = (state_44901[(15)]);
var inst_44838 = (state_44901[(16)]);
var inst_44844 = cljs.core._nth.call(null,inst_44837,inst_44839);
var inst_44845 = cljs.core.async.muxch_STAR_.call(null,inst_44844);
var inst_44846 = cljs.core.async.close_BANG_.call(null,inst_44845);
var inst_44847 = (inst_44839 + (1));
var tmp44966 = inst_44836;
var tmp44967 = inst_44837;
var tmp44968 = inst_44838;
var inst_44836__$1 = tmp44966;
var inst_44837__$1 = tmp44967;
var inst_44838__$1 = tmp44968;
var inst_44839__$1 = inst_44847;
var state_44901__$1 = (function (){var statearr_44983 = state_44901;
(statearr_44983[(12)] = inst_44839__$1);

(statearr_44983[(13)] = inst_44836__$1);

(statearr_44983[(15)] = inst_44837__$1);

(statearr_44983[(16)] = inst_44838__$1);

(statearr_44983[(17)] = inst_44846);

return statearr_44983;
})();
var statearr_44984_48160 = state_44901__$1;
(statearr_44984_48160[(2)] = null);

(statearr_44984_48160[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44902 === (18))){
var inst_44868 = (state_44901[(2)]);
var state_44901__$1 = state_44901;
var statearr_44988_48180 = state_44901__$1;
(statearr_44988_48180[(2)] = inst_44868);

(statearr_44988_48180[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44902 === (8))){
var inst_44839 = (state_44901[(12)]);
var inst_44838 = (state_44901[(16)]);
var inst_44841 = (inst_44839 < inst_44838);
var inst_44842 = inst_44841;
var state_44901__$1 = state_44901;
if(cljs.core.truth_(inst_44842)){
var statearr_44991_48185 = state_44901__$1;
(statearr_44991_48185[(1)] = (10));

} else {
var statearr_44993_48192 = state_44901__$1;
(statearr_44993_48192[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42267__auto__ = null;
var cljs$core$async$state_machine__42267__auto____0 = (function (){
var statearr_44995 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44995[(0)] = cljs$core$async$state_machine__42267__auto__);

(statearr_44995[(1)] = (1));

return statearr_44995;
});
var cljs$core$async$state_machine__42267__auto____1 = (function (state_44901){
while(true){
var ret_value__42268__auto__ = (function (){try{while(true){
var result__42269__auto__ = switch__42266__auto__.call(null,state_44901);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42269__auto__;
}
break;
}
}catch (e45001){var ex__42270__auto__ = e45001;
var statearr_45002_48216 = state_44901;
(statearr_45002_48216[(2)] = ex__42270__auto__);


if(cljs.core.seq.call(null,(state_44901[(4)]))){
var statearr_45003_48219 = state_44901;
(statearr_45003_48219[(1)] = cljs.core.first.call(null,(state_44901[(4)])));

} else {
throw ex__42270__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48225 = state_44901;
state_44901 = G__48225;
continue;
} else {
return ret_value__42268__auto__;
}
break;
}
});
cljs$core$async$state_machine__42267__auto__ = function(state_44901){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42267__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42267__auto____1.call(this,state_44901);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42267__auto____0;
cljs$core$async$state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42267__auto____1;
return cljs$core$async$state_machine__42267__auto__;
})()
})();
var state__42561__auto__ = (function (){var statearr_45006 = f__42560__auto__.call(null);
(statearr_45006[(6)] = c__42559__auto___48018);

return statearr_45006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42561__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__45011 = arguments.length;
switch (G__45011) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__45028 = arguments.length;
switch (G__45028) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__45035 = arguments.length;
switch (G__45035) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,(function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.call(null,cnt));
var c__42559__auto___48386 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42560__auto__ = (function (){var switch__42266__auto__ = (function (state_45097){
var state_val_45098 = (state_45097[(1)]);
if((state_val_45098 === (7))){
var state_45097__$1 = state_45097;
var statearr_45100_48407 = state_45097__$1;
(statearr_45100_48407[(2)] = null);

(statearr_45100_48407[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45098 === (1))){
var state_45097__$1 = state_45097;
var statearr_45101_48416 = state_45097__$1;
(statearr_45101_48416[(2)] = null);

(statearr_45101_48416[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45098 === (4))){
var inst_45043 = (state_45097[(7)]);
var inst_45042 = (state_45097[(8)]);
var inst_45045 = (inst_45043 < inst_45042);
var state_45097__$1 = state_45097;
if(cljs.core.truth_(inst_45045)){
var statearr_45107_48448 = state_45097__$1;
(statearr_45107_48448[(1)] = (6));

} else {
var statearr_45108_48451 = state_45097__$1;
(statearr_45108_48451[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45098 === (15))){
var inst_45080 = (state_45097[(9)]);
var inst_45085 = cljs.core.apply.call(null,f,inst_45080);
var state_45097__$1 = state_45097;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45097__$1,(17),out,inst_45085);
} else {
if((state_val_45098 === (13))){
var inst_45080 = (state_45097[(9)]);
var inst_45080__$1 = (state_45097[(2)]);
var inst_45081 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_45080__$1);
var state_45097__$1 = (function (){var statearr_45110 = state_45097;
(statearr_45110[(9)] = inst_45080__$1);

return statearr_45110;
})();
if(cljs.core.truth_(inst_45081)){
var statearr_45111_48476 = state_45097__$1;
(statearr_45111_48476[(1)] = (14));

} else {
var statearr_45112_48485 = state_45097__$1;
(statearr_45112_48485[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45098 === (6))){
var state_45097__$1 = state_45097;
var statearr_45117_48490 = state_45097__$1;
(statearr_45117_48490[(2)] = null);

(statearr_45117_48490[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45098 === (17))){
var inst_45087 = (state_45097[(2)]);
var state_45097__$1 = (function (){var statearr_45125 = state_45097;
(statearr_45125[(10)] = inst_45087);

return statearr_45125;
})();
var statearr_45126_48507 = state_45097__$1;
(statearr_45126_48507[(2)] = null);

(statearr_45126_48507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45098 === (3))){
var inst_45092 = (state_45097[(2)]);
var state_45097__$1 = state_45097;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45097__$1,inst_45092);
} else {
if((state_val_45098 === (12))){
var _ = (function (){var statearr_45129 = state_45097;
(statearr_45129[(4)] = cljs.core.rest.call(null,(state_45097[(4)])));

return statearr_45129;
})();
var state_45097__$1 = state_45097;
var ex45124 = (state_45097__$1[(2)]);
var statearr_45131_48525 = state_45097__$1;
(statearr_45131_48525[(5)] = ex45124);


if((ex45124 instanceof Object)){
var statearr_45133_48529 = state_45097__$1;
(statearr_45133_48529[(1)] = (11));

(statearr_45133_48529[(5)] = null);

} else {
throw ex45124;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45098 === (2))){
var inst_45041 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_45042 = cnt;
var inst_45043 = (0);
var state_45097__$1 = (function (){var statearr_45135 = state_45097;
(statearr_45135[(7)] = inst_45043);

(statearr_45135[(11)] = inst_45041);

(statearr_45135[(8)] = inst_45042);

return statearr_45135;
})();
var statearr_45136_48560 = state_45097__$1;
(statearr_45136_48560[(2)] = null);

(statearr_45136_48560[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45098 === (11))){
var inst_45052 = (state_45097[(2)]);
var inst_45053 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_45097__$1 = (function (){var statearr_45138 = state_45097;
(statearr_45138[(12)] = inst_45052);

return statearr_45138;
})();
var statearr_45139_48579 = state_45097__$1;
(statearr_45139_48579[(2)] = inst_45053);

(statearr_45139_48579[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45098 === (9))){
var inst_45043 = (state_45097[(7)]);
var _ = (function (){var statearr_45140 = state_45097;
(statearr_45140[(4)] = cljs.core.cons.call(null,(12),(state_45097[(4)])));

return statearr_45140;
})();
var inst_45062 = chs__$1.call(null,inst_45043);
var inst_45063 = done.call(null,inst_45043);
var inst_45064 = cljs.core.async.take_BANG_.call(null,inst_45062,inst_45063);
var ___$1 = (function (){var statearr_45141 = state_45097;
(statearr_45141[(4)] = cljs.core.rest.call(null,(state_45097[(4)])));

return statearr_45141;
})();
var state_45097__$1 = state_45097;
var statearr_45142_48613 = state_45097__$1;
(statearr_45142_48613[(2)] = inst_45064);

(statearr_45142_48613[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45098 === (5))){
var inst_45074 = (state_45097[(2)]);
var state_45097__$1 = (function (){var statearr_45144 = state_45097;
(statearr_45144[(13)] = inst_45074);

return statearr_45144;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45097__$1,(13),dchan);
} else {
if((state_val_45098 === (14))){
var inst_45083 = cljs.core.async.close_BANG_.call(null,out);
var state_45097__$1 = state_45097;
var statearr_45147_48635 = state_45097__$1;
(statearr_45147_48635[(2)] = inst_45083);

(statearr_45147_48635[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45098 === (16))){
var inst_45090 = (state_45097[(2)]);
var state_45097__$1 = state_45097;
var statearr_45148_48661 = state_45097__$1;
(statearr_45148_48661[(2)] = inst_45090);

(statearr_45148_48661[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45098 === (10))){
var inst_45043 = (state_45097[(7)]);
var inst_45067 = (state_45097[(2)]);
var inst_45068 = (inst_45043 + (1));
var inst_45043__$1 = inst_45068;
var state_45097__$1 = (function (){var statearr_45149 = state_45097;
(statearr_45149[(7)] = inst_45043__$1);

(statearr_45149[(14)] = inst_45067);

return statearr_45149;
})();
var statearr_45152_48678 = state_45097__$1;
(statearr_45152_48678[(2)] = null);

(statearr_45152_48678[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45098 === (8))){
var inst_45072 = (state_45097[(2)]);
var state_45097__$1 = state_45097;
var statearr_45154_48679 = state_45097__$1;
(statearr_45154_48679[(2)] = inst_45072);

(statearr_45154_48679[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42267__auto__ = null;
var cljs$core$async$state_machine__42267__auto____0 = (function (){
var statearr_45155 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45155[(0)] = cljs$core$async$state_machine__42267__auto__);

(statearr_45155[(1)] = (1));

return statearr_45155;
});
var cljs$core$async$state_machine__42267__auto____1 = (function (state_45097){
while(true){
var ret_value__42268__auto__ = (function (){try{while(true){
var result__42269__auto__ = switch__42266__auto__.call(null,state_45097);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42269__auto__;
}
break;
}
}catch (e45156){var ex__42270__auto__ = e45156;
var statearr_45157_48690 = state_45097;
(statearr_45157_48690[(2)] = ex__42270__auto__);


if(cljs.core.seq.call(null,(state_45097[(4)]))){
var statearr_45158_48700 = state_45097;
(statearr_45158_48700[(1)] = cljs.core.first.call(null,(state_45097[(4)])));

} else {
throw ex__42270__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48712 = state_45097;
state_45097 = G__48712;
continue;
} else {
return ret_value__42268__auto__;
}
break;
}
});
cljs$core$async$state_machine__42267__auto__ = function(state_45097){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42267__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42267__auto____1.call(this,state_45097);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42267__auto____0;
cljs$core$async$state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42267__auto____1;
return cljs$core$async$state_machine__42267__auto__;
})()
})();
var state__42561__auto__ = (function (){var statearr_45163 = f__42560__auto__.call(null);
(statearr_45163[(6)] = c__42559__auto___48386);

return statearr_45163;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42561__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__45175 = arguments.length;
switch (G__45175) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42559__auto___48771 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42560__auto__ = (function (){var switch__42266__auto__ = (function (state_45224){
var state_val_45225 = (state_45224[(1)]);
if((state_val_45225 === (7))){
var inst_45196 = (state_45224[(7)]);
var inst_45195 = (state_45224[(8)]);
var inst_45195__$1 = (state_45224[(2)]);
var inst_45196__$1 = cljs.core.nth.call(null,inst_45195__$1,(0),null);
var inst_45198 = cljs.core.nth.call(null,inst_45195__$1,(1),null);
var inst_45199 = (inst_45196__$1 == null);
var state_45224__$1 = (function (){var statearr_45229 = state_45224;
(statearr_45229[(9)] = inst_45198);

(statearr_45229[(7)] = inst_45196__$1);

(statearr_45229[(8)] = inst_45195__$1);

return statearr_45229;
})();
if(cljs.core.truth_(inst_45199)){
var statearr_45230_48816 = state_45224__$1;
(statearr_45230_48816[(1)] = (8));

} else {
var statearr_45231_48825 = state_45224__$1;
(statearr_45231_48825[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45225 === (1))){
var inst_45181 = cljs.core.vec.call(null,chs);
var inst_45182 = inst_45181;
var state_45224__$1 = (function (){var statearr_45232 = state_45224;
(statearr_45232[(10)] = inst_45182);

return statearr_45232;
})();
var statearr_45236_48846 = state_45224__$1;
(statearr_45236_48846[(2)] = null);

(statearr_45236_48846[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45225 === (4))){
var inst_45182 = (state_45224[(10)]);
var state_45224__$1 = state_45224;
return cljs.core.async.ioc_alts_BANG_.call(null,state_45224__$1,(7),inst_45182);
} else {
if((state_val_45225 === (6))){
var inst_45220 = (state_45224[(2)]);
var state_45224__$1 = state_45224;
var statearr_45237_48870 = state_45224__$1;
(statearr_45237_48870[(2)] = inst_45220);

(statearr_45237_48870[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45225 === (3))){
var inst_45222 = (state_45224[(2)]);
var state_45224__$1 = state_45224;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45224__$1,inst_45222);
} else {
if((state_val_45225 === (2))){
var inst_45182 = (state_45224[(10)]);
var inst_45188 = cljs.core.count.call(null,inst_45182);
var inst_45189 = (inst_45188 > (0));
var state_45224__$1 = state_45224;
if(cljs.core.truth_(inst_45189)){
var statearr_45239_48911 = state_45224__$1;
(statearr_45239_48911[(1)] = (4));

} else {
var statearr_45240_48916 = state_45224__$1;
(statearr_45240_48916[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45225 === (11))){
var inst_45182 = (state_45224[(10)]);
var inst_45213 = (state_45224[(2)]);
var tmp45238 = inst_45182;
var inst_45182__$1 = tmp45238;
var state_45224__$1 = (function (){var statearr_45242 = state_45224;
(statearr_45242[(10)] = inst_45182__$1);

(statearr_45242[(11)] = inst_45213);

return statearr_45242;
})();
var statearr_45243_48932 = state_45224__$1;
(statearr_45243_48932[(2)] = null);

(statearr_45243_48932[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45225 === (9))){
var inst_45196 = (state_45224[(7)]);
var state_45224__$1 = state_45224;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45224__$1,(11),out,inst_45196);
} else {
if((state_val_45225 === (5))){
var inst_45218 = cljs.core.async.close_BANG_.call(null,out);
var state_45224__$1 = state_45224;
var statearr_45244_48949 = state_45224__$1;
(statearr_45244_48949[(2)] = inst_45218);

(statearr_45244_48949[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45225 === (10))){
var inst_45216 = (state_45224[(2)]);
var state_45224__$1 = state_45224;
var statearr_45245_48962 = state_45224__$1;
(statearr_45245_48962[(2)] = inst_45216);

(statearr_45245_48962[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45225 === (8))){
var inst_45198 = (state_45224[(9)]);
var inst_45182 = (state_45224[(10)]);
var inst_45196 = (state_45224[(7)]);
var inst_45195 = (state_45224[(8)]);
var inst_45204 = (function (){var cs = inst_45182;
var vec__45191 = inst_45195;
var v = inst_45196;
var c = inst_45198;
return (function (p1__45169_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__45169_SHARP_);
});
})();
var inst_45209 = cljs.core.filterv.call(null,inst_45204,inst_45182);
var inst_45182__$1 = inst_45209;
var state_45224__$1 = (function (){var statearr_45247 = state_45224;
(statearr_45247[(10)] = inst_45182__$1);

return statearr_45247;
})();
var statearr_45248_49020 = state_45224__$1;
(statearr_45248_49020[(2)] = null);

(statearr_45248_49020[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42267__auto__ = null;
var cljs$core$async$state_machine__42267__auto____0 = (function (){
var statearr_45249 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45249[(0)] = cljs$core$async$state_machine__42267__auto__);

(statearr_45249[(1)] = (1));

return statearr_45249;
});
var cljs$core$async$state_machine__42267__auto____1 = (function (state_45224){
while(true){
var ret_value__42268__auto__ = (function (){try{while(true){
var result__42269__auto__ = switch__42266__auto__.call(null,state_45224);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42269__auto__;
}
break;
}
}catch (e45250){var ex__42270__auto__ = e45250;
var statearr_45251_49057 = state_45224;
(statearr_45251_49057[(2)] = ex__42270__auto__);


if(cljs.core.seq.call(null,(state_45224[(4)]))){
var statearr_45252_49061 = state_45224;
(statearr_45252_49061[(1)] = cljs.core.first.call(null,(state_45224[(4)])));

} else {
throw ex__42270__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49068 = state_45224;
state_45224 = G__49068;
continue;
} else {
return ret_value__42268__auto__;
}
break;
}
});
cljs$core$async$state_machine__42267__auto__ = function(state_45224){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42267__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42267__auto____1.call(this,state_45224);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42267__auto____0;
cljs$core$async$state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42267__auto____1;
return cljs$core$async$state_machine__42267__auto__;
})()
})();
var state__42561__auto__ = (function (){var statearr_45255 = f__42560__auto__.call(null);
(statearr_45255[(6)] = c__42559__auto___48771);

return statearr_45255;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42561__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__45264 = arguments.length;
switch (G__45264) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42559__auto___49094 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42560__auto__ = (function (){var switch__42266__auto__ = (function (state_45288){
var state_val_45289 = (state_45288[(1)]);
if((state_val_45289 === (7))){
var inst_45270 = (state_45288[(7)]);
var inst_45270__$1 = (state_45288[(2)]);
var inst_45271 = (inst_45270__$1 == null);
var inst_45272 = cljs.core.not.call(null,inst_45271);
var state_45288__$1 = (function (){var statearr_45291 = state_45288;
(statearr_45291[(7)] = inst_45270__$1);

return statearr_45291;
})();
if(inst_45272){
var statearr_45295_49103 = state_45288__$1;
(statearr_45295_49103[(1)] = (8));

} else {
var statearr_45296_49105 = state_45288__$1;
(statearr_45296_49105[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45289 === (1))){
var inst_45265 = (0);
var state_45288__$1 = (function (){var statearr_45297 = state_45288;
(statearr_45297[(8)] = inst_45265);

return statearr_45297;
})();
var statearr_45298_49106 = state_45288__$1;
(statearr_45298_49106[(2)] = null);

(statearr_45298_49106[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45289 === (4))){
var state_45288__$1 = state_45288;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45288__$1,(7),ch);
} else {
if((state_val_45289 === (6))){
var inst_45283 = (state_45288[(2)]);
var state_45288__$1 = state_45288;
var statearr_45301_49111 = state_45288__$1;
(statearr_45301_49111[(2)] = inst_45283);

(statearr_45301_49111[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45289 === (3))){
var inst_45285 = (state_45288[(2)]);
var inst_45286 = cljs.core.async.close_BANG_.call(null,out);
var state_45288__$1 = (function (){var statearr_45306 = state_45288;
(statearr_45306[(9)] = inst_45285);

return statearr_45306;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45288__$1,inst_45286);
} else {
if((state_val_45289 === (2))){
var inst_45265 = (state_45288[(8)]);
var inst_45267 = (inst_45265 < n);
var state_45288__$1 = state_45288;
if(cljs.core.truth_(inst_45267)){
var statearr_45311_49122 = state_45288__$1;
(statearr_45311_49122[(1)] = (4));

} else {
var statearr_45313_49123 = state_45288__$1;
(statearr_45313_49123[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45289 === (11))){
var inst_45265 = (state_45288[(8)]);
var inst_45275 = (state_45288[(2)]);
var inst_45276 = (inst_45265 + (1));
var inst_45265__$1 = inst_45276;
var state_45288__$1 = (function (){var statearr_45315 = state_45288;
(statearr_45315[(10)] = inst_45275);

(statearr_45315[(8)] = inst_45265__$1);

return statearr_45315;
})();
var statearr_45320_49135 = state_45288__$1;
(statearr_45320_49135[(2)] = null);

(statearr_45320_49135[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45289 === (9))){
var state_45288__$1 = state_45288;
var statearr_45321_49144 = state_45288__$1;
(statearr_45321_49144[(2)] = null);

(statearr_45321_49144[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45289 === (5))){
var state_45288__$1 = state_45288;
var statearr_45322_49145 = state_45288__$1;
(statearr_45322_49145[(2)] = null);

(statearr_45322_49145[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45289 === (10))){
var inst_45280 = (state_45288[(2)]);
var state_45288__$1 = state_45288;
var statearr_45323_49155 = state_45288__$1;
(statearr_45323_49155[(2)] = inst_45280);

(statearr_45323_49155[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45289 === (8))){
var inst_45270 = (state_45288[(7)]);
var state_45288__$1 = state_45288;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45288__$1,(11),out,inst_45270);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42267__auto__ = null;
var cljs$core$async$state_machine__42267__auto____0 = (function (){
var statearr_45324 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_45324[(0)] = cljs$core$async$state_machine__42267__auto__);

(statearr_45324[(1)] = (1));

return statearr_45324;
});
var cljs$core$async$state_machine__42267__auto____1 = (function (state_45288){
while(true){
var ret_value__42268__auto__ = (function (){try{while(true){
var result__42269__auto__ = switch__42266__auto__.call(null,state_45288);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42269__auto__;
}
break;
}
}catch (e45325){var ex__42270__auto__ = e45325;
var statearr_45326_49167 = state_45288;
(statearr_45326_49167[(2)] = ex__42270__auto__);


if(cljs.core.seq.call(null,(state_45288[(4)]))){
var statearr_45327_49171 = state_45288;
(statearr_45327_49171[(1)] = cljs.core.first.call(null,(state_45288[(4)])));

} else {
throw ex__42270__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49177 = state_45288;
state_45288 = G__49177;
continue;
} else {
return ret_value__42268__auto__;
}
break;
}
});
cljs$core$async$state_machine__42267__auto__ = function(state_45288){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42267__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42267__auto____1.call(this,state_45288);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42267__auto____0;
cljs$core$async$state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42267__auto____1;
return cljs$core$async$state_machine__42267__auto__;
})()
})();
var state__42561__auto__ = (function (){var statearr_45328 = f__42560__auto__.call(null);
(statearr_45328[(6)] = c__42559__auto___49094);

return statearr_45328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42561__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45330 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45330 = (function (f,ch,meta45331){
this.f = f;
this.ch = ch;
this.meta45331 = meta45331;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45330.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45332,meta45331__$1){
var self__ = this;
var _45332__$1 = this;
return (new cljs.core.async.t_cljs$core$async45330(self__.f,self__.ch,meta45331__$1));
}));

(cljs.core.async.t_cljs$core$async45330.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45332){
var self__ = this;
var _45332__$1 = this;
return self__.meta45331;
}));

(cljs.core.async.t_cljs$core$async45330.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45330.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async45330.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async45330.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45330.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45334 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45334 = (function (f,ch,meta45331,_,fn1,meta45335){
this.f = f;
this.ch = ch;
this.meta45331 = meta45331;
this._ = _;
this.fn1 = fn1;
this.meta45335 = meta45335;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45334.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45336,meta45335__$1){
var self__ = this;
var _45336__$1 = this;
return (new cljs.core.async.t_cljs$core$async45334(self__.f,self__.ch,self__.meta45331,self__._,self__.fn1,meta45335__$1));
}));

(cljs.core.async.t_cljs$core$async45334.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45336){
var self__ = this;
var _45336__$1 = this;
return self__.meta45335;
}));

(cljs.core.async.t_cljs$core$async45334.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45334.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
}));

(cljs.core.async.t_cljs$core$async45334.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async45334.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return (function (p1__45329_SHARP_){
return f1.call(null,(((p1__45329_SHARP_ == null))?null:self__.f.call(null,p1__45329_SHARP_)));
});
}));

(cljs.core.async.t_cljs$core$async45334.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45331","meta45331",1164420619,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async45330","cljs.core.async/t_cljs$core$async45330",-226672093,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta45335","meta45335",1967467044,null)], null);
}));

(cljs.core.async.t_cljs$core$async45334.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45334.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45334");

(cljs.core.async.t_cljs$core$async45334.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"cljs.core.async/t_cljs$core$async45334");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45334.
 */
cljs.core.async.__GT_t_cljs$core$async45334 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async45334(f__$1,ch__$1,meta45331__$1,___$2,fn1__$1,meta45335){
return (new cljs.core.async.t_cljs$core$async45334(f__$1,ch__$1,meta45331__$1,___$2,fn1__$1,meta45335));
});

}

return (new cljs.core.async.t_cljs$core$async45334(self__.f,self__.ch,self__.meta45331,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4174__auto__ = ret;
if(cljs.core.truth_(and__4174__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4174__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async45330.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45330.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async45330.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45331","meta45331",1164420619,null)], null);
}));

(cljs.core.async.t_cljs$core$async45330.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45330.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45330");

(cljs.core.async.t_cljs$core$async45330.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"cljs.core.async/t_cljs$core$async45330");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45330.
 */
cljs.core.async.__GT_t_cljs$core$async45330 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async45330(f__$1,ch__$1,meta45331){
return (new cljs.core.async.t_cljs$core$async45330(f__$1,ch__$1,meta45331));
});

}

return (new cljs.core.async.t_cljs$core$async45330(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45340 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45340 = (function (f,ch,meta45341){
this.f = f;
this.ch = ch;
this.meta45341 = meta45341;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45340.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45342,meta45341__$1){
var self__ = this;
var _45342__$1 = this;
return (new cljs.core.async.t_cljs$core$async45340(self__.f,self__.ch,meta45341__$1));
}));

(cljs.core.async.t_cljs$core$async45340.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45342){
var self__ = this;
var _45342__$1 = this;
return self__.meta45341;
}));

(cljs.core.async.t_cljs$core$async45340.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45340.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async45340.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45340.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async45340.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45340.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
}));

(cljs.core.async.t_cljs$core$async45340.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45341","meta45341",-994915226,null)], null);
}));

(cljs.core.async.t_cljs$core$async45340.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45340.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45340");

(cljs.core.async.t_cljs$core$async45340.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"cljs.core.async/t_cljs$core$async45340");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45340.
 */
cljs.core.async.__GT_t_cljs$core$async45340 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async45340(f__$1,ch__$1,meta45341){
return (new cljs.core.async.t_cljs$core$async45340(f__$1,ch__$1,meta45341));
});

}

return (new cljs.core.async.t_cljs$core$async45340(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45344 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45344 = (function (p,ch,meta45345){
this.p = p;
this.ch = ch;
this.meta45345 = meta45345;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45344.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45346,meta45345__$1){
var self__ = this;
var _45346__$1 = this;
return (new cljs.core.async.t_cljs$core$async45344(self__.p,self__.ch,meta45345__$1));
}));

(cljs.core.async.t_cljs$core$async45344.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45346){
var self__ = this;
var _45346__$1 = this;
return self__.meta45345;
}));

(cljs.core.async.t_cljs$core$async45344.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45344.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async45344.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async45344.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45344.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async45344.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45344.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async45344.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45345","meta45345",-1669299821,null)], null);
}));

(cljs.core.async.t_cljs$core$async45344.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45344.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45344");

(cljs.core.async.t_cljs$core$async45344.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"cljs.core.async/t_cljs$core$async45344");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45344.
 */
cljs.core.async.__GT_t_cljs$core$async45344 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async45344(p__$1,ch__$1,meta45345){
return (new cljs.core.async.t_cljs$core$async45344(p__$1,ch__$1,meta45345));
});

}

return (new cljs.core.async.t_cljs$core$async45344(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__45355 = arguments.length;
switch (G__45355) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42559__auto___49326 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42560__auto__ = (function (){var switch__42266__auto__ = (function (state_45381){
var state_val_45382 = (state_45381[(1)]);
if((state_val_45382 === (7))){
var inst_45377 = (state_45381[(2)]);
var state_45381__$1 = state_45381;
var statearr_45387_49332 = state_45381__$1;
(statearr_45387_49332[(2)] = inst_45377);

(statearr_45387_49332[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45382 === (1))){
var state_45381__$1 = state_45381;
var statearr_45392_49335 = state_45381__$1;
(statearr_45392_49335[(2)] = null);

(statearr_45392_49335[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45382 === (4))){
var inst_45360 = (state_45381[(7)]);
var inst_45360__$1 = (state_45381[(2)]);
var inst_45361 = (inst_45360__$1 == null);
var state_45381__$1 = (function (){var statearr_45393 = state_45381;
(statearr_45393[(7)] = inst_45360__$1);

return statearr_45393;
})();
if(cljs.core.truth_(inst_45361)){
var statearr_45395_49342 = state_45381__$1;
(statearr_45395_49342[(1)] = (5));

} else {
var statearr_45396_49344 = state_45381__$1;
(statearr_45396_49344[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45382 === (6))){
var inst_45360 = (state_45381[(7)]);
var inst_45366 = p.call(null,inst_45360);
var state_45381__$1 = state_45381;
if(cljs.core.truth_(inst_45366)){
var statearr_45399_49346 = state_45381__$1;
(statearr_45399_49346[(1)] = (8));

} else {
var statearr_45400_49348 = state_45381__$1;
(statearr_45400_49348[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45382 === (3))){
var inst_45379 = (state_45381[(2)]);
var state_45381__$1 = state_45381;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45381__$1,inst_45379);
} else {
if((state_val_45382 === (2))){
var state_45381__$1 = state_45381;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45381__$1,(4),ch);
} else {
if((state_val_45382 === (11))){
var inst_45370 = (state_45381[(2)]);
var state_45381__$1 = state_45381;
var statearr_45402_49352 = state_45381__$1;
(statearr_45402_49352[(2)] = inst_45370);

(statearr_45402_49352[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45382 === (9))){
var state_45381__$1 = state_45381;
var statearr_45409_49355 = state_45381__$1;
(statearr_45409_49355[(2)] = null);

(statearr_45409_49355[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45382 === (5))){
var inst_45364 = cljs.core.async.close_BANG_.call(null,out);
var state_45381__$1 = state_45381;
var statearr_45410_49360 = state_45381__$1;
(statearr_45410_49360[(2)] = inst_45364);

(statearr_45410_49360[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45382 === (10))){
var inst_45373 = (state_45381[(2)]);
var state_45381__$1 = (function (){var statearr_45413 = state_45381;
(statearr_45413[(8)] = inst_45373);

return statearr_45413;
})();
var statearr_45414_49366 = state_45381__$1;
(statearr_45414_49366[(2)] = null);

(statearr_45414_49366[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45382 === (8))){
var inst_45360 = (state_45381[(7)]);
var state_45381__$1 = state_45381;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45381__$1,(11),out,inst_45360);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42267__auto__ = null;
var cljs$core$async$state_machine__42267__auto____0 = (function (){
var statearr_45416 = [null,null,null,null,null,null,null,null,null];
(statearr_45416[(0)] = cljs$core$async$state_machine__42267__auto__);

(statearr_45416[(1)] = (1));

return statearr_45416;
});
var cljs$core$async$state_machine__42267__auto____1 = (function (state_45381){
while(true){
var ret_value__42268__auto__ = (function (){try{while(true){
var result__42269__auto__ = switch__42266__auto__.call(null,state_45381);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42269__auto__;
}
break;
}
}catch (e45417){var ex__42270__auto__ = e45417;
var statearr_45418_49384 = state_45381;
(statearr_45418_49384[(2)] = ex__42270__auto__);


if(cljs.core.seq.call(null,(state_45381[(4)]))){
var statearr_45419_49386 = state_45381;
(statearr_45419_49386[(1)] = cljs.core.first.call(null,(state_45381[(4)])));

} else {
throw ex__42270__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49391 = state_45381;
state_45381 = G__49391;
continue;
} else {
return ret_value__42268__auto__;
}
break;
}
});
cljs$core$async$state_machine__42267__auto__ = function(state_45381){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42267__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42267__auto____1.call(this,state_45381);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42267__auto____0;
cljs$core$async$state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42267__auto____1;
return cljs$core$async$state_machine__42267__auto__;
})()
})();
var state__42561__auto__ = (function (){var statearr_45420 = f__42560__auto__.call(null);
(statearr_45420[(6)] = c__42559__auto___49326);

return statearr_45420;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42561__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__45424 = arguments.length;
switch (G__45424) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__42559__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42560__auto__ = (function (){var switch__42266__auto__ = (function (state_45489){
var state_val_45490 = (state_45489[(1)]);
if((state_val_45490 === (7))){
var inst_45485 = (state_45489[(2)]);
var state_45489__$1 = state_45489;
var statearr_45493_49412 = state_45489__$1;
(statearr_45493_49412[(2)] = inst_45485);

(statearr_45493_49412[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45490 === (20))){
var inst_45454 = (state_45489[(7)]);
var inst_45465 = (state_45489[(2)]);
var inst_45466 = cljs.core.next.call(null,inst_45454);
var inst_45440 = inst_45466;
var inst_45441 = null;
var inst_45442 = (0);
var inst_45443 = (0);
var state_45489__$1 = (function (){var statearr_45495 = state_45489;
(statearr_45495[(8)] = inst_45443);

(statearr_45495[(9)] = inst_45440);

(statearr_45495[(10)] = inst_45442);

(statearr_45495[(11)] = inst_45441);

(statearr_45495[(12)] = inst_45465);

return statearr_45495;
})();
var statearr_45496_49419 = state_45489__$1;
(statearr_45496_49419[(2)] = null);

(statearr_45496_49419[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45490 === (1))){
var state_45489__$1 = state_45489;
var statearr_45500_49422 = state_45489__$1;
(statearr_45500_49422[(2)] = null);

(statearr_45500_49422[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45490 === (4))){
var inst_45429 = (state_45489[(13)]);
var inst_45429__$1 = (state_45489[(2)]);
var inst_45430 = (inst_45429__$1 == null);
var state_45489__$1 = (function (){var statearr_45502 = state_45489;
(statearr_45502[(13)] = inst_45429__$1);

return statearr_45502;
})();
if(cljs.core.truth_(inst_45430)){
var statearr_45503_49429 = state_45489__$1;
(statearr_45503_49429[(1)] = (5));

} else {
var statearr_45504_49431 = state_45489__$1;
(statearr_45504_49431[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45490 === (15))){
var state_45489__$1 = state_45489;
var statearr_45513_49433 = state_45489__$1;
(statearr_45513_49433[(2)] = null);

(statearr_45513_49433[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45490 === (21))){
var state_45489__$1 = state_45489;
var statearr_45514_49436 = state_45489__$1;
(statearr_45514_49436[(2)] = null);

(statearr_45514_49436[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45490 === (13))){
var inst_45443 = (state_45489[(8)]);
var inst_45440 = (state_45489[(9)]);
var inst_45442 = (state_45489[(10)]);
var inst_45441 = (state_45489[(11)]);
var inst_45450 = (state_45489[(2)]);
var inst_45451 = (inst_45443 + (1));
var tmp45509 = inst_45440;
var tmp45510 = inst_45442;
var tmp45511 = inst_45441;
var inst_45440__$1 = tmp45509;
var inst_45441__$1 = tmp45511;
var inst_45442__$1 = tmp45510;
var inst_45443__$1 = inst_45451;
var state_45489__$1 = (function (){var statearr_45527 = state_45489;
(statearr_45527[(8)] = inst_45443__$1);

(statearr_45527[(9)] = inst_45440__$1);

(statearr_45527[(10)] = inst_45442__$1);

(statearr_45527[(11)] = inst_45441__$1);

(statearr_45527[(14)] = inst_45450);

return statearr_45527;
})();
var statearr_45530_49441 = state_45489__$1;
(statearr_45530_49441[(2)] = null);

(statearr_45530_49441[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45490 === (22))){
var state_45489__$1 = state_45489;
var statearr_45532_49447 = state_45489__$1;
(statearr_45532_49447[(2)] = null);

(statearr_45532_49447[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45490 === (6))){
var inst_45429 = (state_45489[(13)]);
var inst_45438 = f.call(null,inst_45429);
var inst_45439 = cljs.core.seq.call(null,inst_45438);
var inst_45440 = inst_45439;
var inst_45441 = null;
var inst_45442 = (0);
var inst_45443 = (0);
var state_45489__$1 = (function (){var statearr_45537 = state_45489;
(statearr_45537[(8)] = inst_45443);

(statearr_45537[(9)] = inst_45440);

(statearr_45537[(10)] = inst_45442);

(statearr_45537[(11)] = inst_45441);

return statearr_45537;
})();
var statearr_45539_49461 = state_45489__$1;
(statearr_45539_49461[(2)] = null);

(statearr_45539_49461[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45490 === (17))){
var inst_45454 = (state_45489[(7)]);
var inst_45458 = cljs.core.chunk_first.call(null,inst_45454);
var inst_45459 = cljs.core.chunk_rest.call(null,inst_45454);
var inst_45460 = cljs.core.count.call(null,inst_45458);
var inst_45440 = inst_45459;
var inst_45441 = inst_45458;
var inst_45442 = inst_45460;
var inst_45443 = (0);
var state_45489__$1 = (function (){var statearr_45541 = state_45489;
(statearr_45541[(8)] = inst_45443);

(statearr_45541[(9)] = inst_45440);

(statearr_45541[(10)] = inst_45442);

(statearr_45541[(11)] = inst_45441);

return statearr_45541;
})();
var statearr_45542_49466 = state_45489__$1;
(statearr_45542_49466[(2)] = null);

(statearr_45542_49466[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45490 === (3))){
var inst_45487 = (state_45489[(2)]);
var state_45489__$1 = state_45489;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45489__$1,inst_45487);
} else {
if((state_val_45490 === (12))){
var inst_45474 = (state_45489[(2)]);
var state_45489__$1 = state_45489;
var statearr_45545_49472 = state_45489__$1;
(statearr_45545_49472[(2)] = inst_45474);

(statearr_45545_49472[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45490 === (2))){
var state_45489__$1 = state_45489;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45489__$1,(4),in$);
} else {
if((state_val_45490 === (23))){
var inst_45483 = (state_45489[(2)]);
var state_45489__$1 = state_45489;
var statearr_45549_49477 = state_45489__$1;
(statearr_45549_49477[(2)] = inst_45483);

(statearr_45549_49477[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45490 === (19))){
var inst_45469 = (state_45489[(2)]);
var state_45489__$1 = state_45489;
var statearr_45550_49480 = state_45489__$1;
(statearr_45550_49480[(2)] = inst_45469);

(statearr_45550_49480[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45490 === (11))){
var inst_45454 = (state_45489[(7)]);
var inst_45440 = (state_45489[(9)]);
var inst_45454__$1 = cljs.core.seq.call(null,inst_45440);
var state_45489__$1 = (function (){var statearr_45553 = state_45489;
(statearr_45553[(7)] = inst_45454__$1);

return statearr_45553;
})();
if(inst_45454__$1){
var statearr_45554_49484 = state_45489__$1;
(statearr_45554_49484[(1)] = (14));

} else {
var statearr_45555_49485 = state_45489__$1;
(statearr_45555_49485[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45490 === (9))){
var inst_45476 = (state_45489[(2)]);
var inst_45477 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_45489__$1 = (function (){var statearr_45556 = state_45489;
(statearr_45556[(15)] = inst_45476);

return statearr_45556;
})();
if(cljs.core.truth_(inst_45477)){
var statearr_45557_49490 = state_45489__$1;
(statearr_45557_49490[(1)] = (21));

} else {
var statearr_45559_49491 = state_45489__$1;
(statearr_45559_49491[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45490 === (5))){
var inst_45432 = cljs.core.async.close_BANG_.call(null,out);
var state_45489__$1 = state_45489;
var statearr_45562_49493 = state_45489__$1;
(statearr_45562_49493[(2)] = inst_45432);

(statearr_45562_49493[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45490 === (14))){
var inst_45454 = (state_45489[(7)]);
var inst_45456 = cljs.core.chunked_seq_QMARK_.call(null,inst_45454);
var state_45489__$1 = state_45489;
if(inst_45456){
var statearr_45564_49495 = state_45489__$1;
(statearr_45564_49495[(1)] = (17));

} else {
var statearr_45565_49497 = state_45489__$1;
(statearr_45565_49497[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45490 === (16))){
var inst_45472 = (state_45489[(2)]);
var state_45489__$1 = state_45489;
var statearr_45566_49501 = state_45489__$1;
(statearr_45566_49501[(2)] = inst_45472);

(statearr_45566_49501[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45490 === (10))){
var inst_45443 = (state_45489[(8)]);
var inst_45441 = (state_45489[(11)]);
var inst_45448 = cljs.core._nth.call(null,inst_45441,inst_45443);
var state_45489__$1 = state_45489;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45489__$1,(13),out,inst_45448);
} else {
if((state_val_45490 === (18))){
var inst_45454 = (state_45489[(7)]);
var inst_45463 = cljs.core.first.call(null,inst_45454);
var state_45489__$1 = state_45489;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45489__$1,(20),out,inst_45463);
} else {
if((state_val_45490 === (8))){
var inst_45443 = (state_45489[(8)]);
var inst_45442 = (state_45489[(10)]);
var inst_45445 = (inst_45443 < inst_45442);
var inst_45446 = inst_45445;
var state_45489__$1 = state_45489;
if(cljs.core.truth_(inst_45446)){
var statearr_45569_49511 = state_45489__$1;
(statearr_45569_49511[(1)] = (10));

} else {
var statearr_45570_49513 = state_45489__$1;
(statearr_45570_49513[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__42267__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__42267__auto____0 = (function (){
var statearr_45571 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45571[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__42267__auto__);

(statearr_45571[(1)] = (1));

return statearr_45571;
});
var cljs$core$async$mapcat_STAR__$_state_machine__42267__auto____1 = (function (state_45489){
while(true){
var ret_value__42268__auto__ = (function (){try{while(true){
var result__42269__auto__ = switch__42266__auto__.call(null,state_45489);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42269__auto__;
}
break;
}
}catch (e45572){var ex__42270__auto__ = e45572;
var statearr_45573_49521 = state_45489;
(statearr_45573_49521[(2)] = ex__42270__auto__);


if(cljs.core.seq.call(null,(state_45489[(4)]))){
var statearr_45575_49523 = state_45489;
(statearr_45575_49523[(1)] = cljs.core.first.call(null,(state_45489[(4)])));

} else {
throw ex__42270__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49525 = state_45489;
state_45489 = G__49525;
continue;
} else {
return ret_value__42268__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__42267__auto__ = function(state_45489){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__42267__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__42267__auto____1.call(this,state_45489);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__42267__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__42267__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__42267__auto__;
})()
})();
var state__42561__auto__ = (function (){var statearr_45577 = f__42560__auto__.call(null);
(statearr_45577[(6)] = c__42559__auto__);

return statearr_45577;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42561__auto__);
}));

return c__42559__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__45579 = arguments.length;
switch (G__45579) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__45588 = arguments.length;
switch (G__45588) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__45593 = arguments.length;
switch (G__45593) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42559__auto___49569 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42560__auto__ = (function (){var switch__42266__auto__ = (function (state_45618){
var state_val_45619 = (state_45618[(1)]);
if((state_val_45619 === (7))){
var inst_45613 = (state_45618[(2)]);
var state_45618__$1 = state_45618;
var statearr_45621_49572 = state_45618__$1;
(statearr_45621_49572[(2)] = inst_45613);

(statearr_45621_49572[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45619 === (1))){
var inst_45595 = null;
var state_45618__$1 = (function (){var statearr_45622 = state_45618;
(statearr_45622[(7)] = inst_45595);

return statearr_45622;
})();
var statearr_45623_49581 = state_45618__$1;
(statearr_45623_49581[(2)] = null);

(statearr_45623_49581[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45619 === (4))){
var inst_45598 = (state_45618[(8)]);
var inst_45598__$1 = (state_45618[(2)]);
var inst_45599 = (inst_45598__$1 == null);
var inst_45600 = cljs.core.not.call(null,inst_45599);
var state_45618__$1 = (function (){var statearr_45627 = state_45618;
(statearr_45627[(8)] = inst_45598__$1);

return statearr_45627;
})();
if(inst_45600){
var statearr_45628_49590 = state_45618__$1;
(statearr_45628_49590[(1)] = (5));

} else {
var statearr_45629_49591 = state_45618__$1;
(statearr_45629_49591[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45619 === (6))){
var state_45618__$1 = state_45618;
var statearr_45630_49597 = state_45618__$1;
(statearr_45630_49597[(2)] = null);

(statearr_45630_49597[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45619 === (3))){
var inst_45615 = (state_45618[(2)]);
var inst_45616 = cljs.core.async.close_BANG_.call(null,out);
var state_45618__$1 = (function (){var statearr_45631 = state_45618;
(statearr_45631[(9)] = inst_45615);

return statearr_45631;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45618__$1,inst_45616);
} else {
if((state_val_45619 === (2))){
var state_45618__$1 = state_45618;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45618__$1,(4),ch);
} else {
if((state_val_45619 === (11))){
var inst_45598 = (state_45618[(8)]);
var inst_45607 = (state_45618[(2)]);
var inst_45595 = inst_45598;
var state_45618__$1 = (function (){var statearr_45632 = state_45618;
(statearr_45632[(10)] = inst_45607);

(statearr_45632[(7)] = inst_45595);

return statearr_45632;
})();
var statearr_45633_49607 = state_45618__$1;
(statearr_45633_49607[(2)] = null);

(statearr_45633_49607[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45619 === (9))){
var inst_45598 = (state_45618[(8)]);
var state_45618__$1 = state_45618;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45618__$1,(11),out,inst_45598);
} else {
if((state_val_45619 === (5))){
var inst_45595 = (state_45618[(7)]);
var inst_45598 = (state_45618[(8)]);
var inst_45602 = cljs.core._EQ_.call(null,inst_45598,inst_45595);
var state_45618__$1 = state_45618;
if(inst_45602){
var statearr_45635_49615 = state_45618__$1;
(statearr_45635_49615[(1)] = (8));

} else {
var statearr_45636_49617 = state_45618__$1;
(statearr_45636_49617[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45619 === (10))){
var inst_45610 = (state_45618[(2)]);
var state_45618__$1 = state_45618;
var statearr_45637_49624 = state_45618__$1;
(statearr_45637_49624[(2)] = inst_45610);

(statearr_45637_49624[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45619 === (8))){
var inst_45595 = (state_45618[(7)]);
var tmp45634 = inst_45595;
var inst_45595__$1 = tmp45634;
var state_45618__$1 = (function (){var statearr_45638 = state_45618;
(statearr_45638[(7)] = inst_45595__$1);

return statearr_45638;
})();
var statearr_45641_49631 = state_45618__$1;
(statearr_45641_49631[(2)] = null);

(statearr_45641_49631[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42267__auto__ = null;
var cljs$core$async$state_machine__42267__auto____0 = (function (){
var statearr_45647 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_45647[(0)] = cljs$core$async$state_machine__42267__auto__);

(statearr_45647[(1)] = (1));

return statearr_45647;
});
var cljs$core$async$state_machine__42267__auto____1 = (function (state_45618){
while(true){
var ret_value__42268__auto__ = (function (){try{while(true){
var result__42269__auto__ = switch__42266__auto__.call(null,state_45618);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42269__auto__;
}
break;
}
}catch (e45650){var ex__42270__auto__ = e45650;
var statearr_45651_49635 = state_45618;
(statearr_45651_49635[(2)] = ex__42270__auto__);


if(cljs.core.seq.call(null,(state_45618[(4)]))){
var statearr_45652_49636 = state_45618;
(statearr_45652_49636[(1)] = cljs.core.first.call(null,(state_45618[(4)])));

} else {
throw ex__42270__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49640 = state_45618;
state_45618 = G__49640;
continue;
} else {
return ret_value__42268__auto__;
}
break;
}
});
cljs$core$async$state_machine__42267__auto__ = function(state_45618){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42267__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42267__auto____1.call(this,state_45618);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42267__auto____0;
cljs$core$async$state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42267__auto____1;
return cljs$core$async$state_machine__42267__auto__;
})()
})();
var state__42561__auto__ = (function (){var statearr_45653 = f__42560__auto__.call(null);
(statearr_45653[(6)] = c__42559__auto___49569);

return statearr_45653;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42561__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__45664 = arguments.length;
switch (G__45664) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42559__auto___49652 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42560__auto__ = (function (){var switch__42266__auto__ = (function (state_45708){
var state_val_45709 = (state_45708[(1)]);
if((state_val_45709 === (7))){
var inst_45704 = (state_45708[(2)]);
var state_45708__$1 = state_45708;
var statearr_45714_49656 = state_45708__$1;
(statearr_45714_49656[(2)] = inst_45704);

(statearr_45714_49656[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45709 === (1))){
var inst_45671 = (new Array(n));
var inst_45672 = inst_45671;
var inst_45673 = (0);
var state_45708__$1 = (function (){var statearr_45716 = state_45708;
(statearr_45716[(7)] = inst_45673);

(statearr_45716[(8)] = inst_45672);

return statearr_45716;
})();
var statearr_45717_49659 = state_45708__$1;
(statearr_45717_49659[(2)] = null);

(statearr_45717_49659[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45709 === (4))){
var inst_45676 = (state_45708[(9)]);
var inst_45676__$1 = (state_45708[(2)]);
var inst_45677 = (inst_45676__$1 == null);
var inst_45678 = cljs.core.not.call(null,inst_45677);
var state_45708__$1 = (function (){var statearr_45718 = state_45708;
(statearr_45718[(9)] = inst_45676__$1);

return statearr_45718;
})();
if(inst_45678){
var statearr_45719_49665 = state_45708__$1;
(statearr_45719_49665[(1)] = (5));

} else {
var statearr_45720_49666 = state_45708__$1;
(statearr_45720_49666[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45709 === (15))){
var inst_45698 = (state_45708[(2)]);
var state_45708__$1 = state_45708;
var statearr_45722_49668 = state_45708__$1;
(statearr_45722_49668[(2)] = inst_45698);

(statearr_45722_49668[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45709 === (13))){
var state_45708__$1 = state_45708;
var statearr_45723_49670 = state_45708__$1;
(statearr_45723_49670[(2)] = null);

(statearr_45723_49670[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45709 === (6))){
var inst_45673 = (state_45708[(7)]);
var inst_45694 = (inst_45673 > (0));
var state_45708__$1 = state_45708;
if(cljs.core.truth_(inst_45694)){
var statearr_45724_49673 = state_45708__$1;
(statearr_45724_49673[(1)] = (12));

} else {
var statearr_45725_49676 = state_45708__$1;
(statearr_45725_49676[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45709 === (3))){
var inst_45706 = (state_45708[(2)]);
var state_45708__$1 = state_45708;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45708__$1,inst_45706);
} else {
if((state_val_45709 === (12))){
var inst_45672 = (state_45708[(8)]);
var inst_45696 = cljs.core.vec.call(null,inst_45672);
var state_45708__$1 = state_45708;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45708__$1,(15),out,inst_45696);
} else {
if((state_val_45709 === (2))){
var state_45708__$1 = state_45708;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45708__$1,(4),ch);
} else {
if((state_val_45709 === (11))){
var inst_45688 = (state_45708[(2)]);
var inst_45689 = (new Array(n));
var inst_45672 = inst_45689;
var inst_45673 = (0);
var state_45708__$1 = (function (){var statearr_45729 = state_45708;
(statearr_45729[(7)] = inst_45673);

(statearr_45729[(10)] = inst_45688);

(statearr_45729[(8)] = inst_45672);

return statearr_45729;
})();
var statearr_45732_49686 = state_45708__$1;
(statearr_45732_49686[(2)] = null);

(statearr_45732_49686[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45709 === (9))){
var inst_45672 = (state_45708[(8)]);
var inst_45686 = cljs.core.vec.call(null,inst_45672);
var state_45708__$1 = state_45708;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45708__$1,(11),out,inst_45686);
} else {
if((state_val_45709 === (5))){
var inst_45673 = (state_45708[(7)]);
var inst_45676 = (state_45708[(9)]);
var inst_45681 = (state_45708[(11)]);
var inst_45672 = (state_45708[(8)]);
var inst_45680 = (inst_45672[inst_45673] = inst_45676);
var inst_45681__$1 = (inst_45673 + (1));
var inst_45682 = (inst_45681__$1 < n);
var state_45708__$1 = (function (){var statearr_45733 = state_45708;
(statearr_45733[(11)] = inst_45681__$1);

(statearr_45733[(12)] = inst_45680);

return statearr_45733;
})();
if(cljs.core.truth_(inst_45682)){
var statearr_45734_49694 = state_45708__$1;
(statearr_45734_49694[(1)] = (8));

} else {
var statearr_45735_49695 = state_45708__$1;
(statearr_45735_49695[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45709 === (14))){
var inst_45701 = (state_45708[(2)]);
var inst_45702 = cljs.core.async.close_BANG_.call(null,out);
var state_45708__$1 = (function (){var statearr_45737 = state_45708;
(statearr_45737[(13)] = inst_45701);

return statearr_45737;
})();
var statearr_45738_49701 = state_45708__$1;
(statearr_45738_49701[(2)] = inst_45702);

(statearr_45738_49701[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45709 === (10))){
var inst_45692 = (state_45708[(2)]);
var state_45708__$1 = state_45708;
var statearr_45739_49710 = state_45708__$1;
(statearr_45739_49710[(2)] = inst_45692);

(statearr_45739_49710[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45709 === (8))){
var inst_45681 = (state_45708[(11)]);
var inst_45672 = (state_45708[(8)]);
var tmp45736 = inst_45672;
var inst_45672__$1 = tmp45736;
var inst_45673 = inst_45681;
var state_45708__$1 = (function (){var statearr_45741 = state_45708;
(statearr_45741[(7)] = inst_45673);

(statearr_45741[(8)] = inst_45672__$1);

return statearr_45741;
})();
var statearr_45743_49722 = state_45708__$1;
(statearr_45743_49722[(2)] = null);

(statearr_45743_49722[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42267__auto__ = null;
var cljs$core$async$state_machine__42267__auto____0 = (function (){
var statearr_45748 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45748[(0)] = cljs$core$async$state_machine__42267__auto__);

(statearr_45748[(1)] = (1));

return statearr_45748;
});
var cljs$core$async$state_machine__42267__auto____1 = (function (state_45708){
while(true){
var ret_value__42268__auto__ = (function (){try{while(true){
var result__42269__auto__ = switch__42266__auto__.call(null,state_45708);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42269__auto__;
}
break;
}
}catch (e45751){var ex__42270__auto__ = e45751;
var statearr_45752_49745 = state_45708;
(statearr_45752_49745[(2)] = ex__42270__auto__);


if(cljs.core.seq.call(null,(state_45708[(4)]))){
var statearr_45754_49751 = state_45708;
(statearr_45754_49751[(1)] = cljs.core.first.call(null,(state_45708[(4)])));

} else {
throw ex__42270__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49759 = state_45708;
state_45708 = G__49759;
continue;
} else {
return ret_value__42268__auto__;
}
break;
}
});
cljs$core$async$state_machine__42267__auto__ = function(state_45708){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42267__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42267__auto____1.call(this,state_45708);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42267__auto____0;
cljs$core$async$state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42267__auto____1;
return cljs$core$async$state_machine__42267__auto__;
})()
})();
var state__42561__auto__ = (function (){var statearr_45755 = f__42560__auto__.call(null);
(statearr_45755[(6)] = c__42559__auto___49652);

return statearr_45755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42561__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__45766 = arguments.length;
switch (G__45766) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42559__auto___49797 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42560__auto__ = (function (){var switch__42266__auto__ = (function (state_45825){
var state_val_45826 = (state_45825[(1)]);
if((state_val_45826 === (7))){
var inst_45821 = (state_45825[(2)]);
var state_45825__$1 = state_45825;
var statearr_45827_49805 = state_45825__$1;
(statearr_45827_49805[(2)] = inst_45821);

(statearr_45827_49805[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45826 === (1))){
var inst_45782 = [];
var inst_45783 = inst_45782;
var inst_45784 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_45825__$1 = (function (){var statearr_45829 = state_45825;
(statearr_45829[(7)] = inst_45783);

(statearr_45829[(8)] = inst_45784);

return statearr_45829;
})();
var statearr_45832_49817 = state_45825__$1;
(statearr_45832_49817[(2)] = null);

(statearr_45832_49817[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45826 === (4))){
var inst_45787 = (state_45825[(9)]);
var inst_45787__$1 = (state_45825[(2)]);
var inst_45789 = (inst_45787__$1 == null);
var inst_45790 = cljs.core.not.call(null,inst_45789);
var state_45825__$1 = (function (){var statearr_45833 = state_45825;
(statearr_45833[(9)] = inst_45787__$1);

return statearr_45833;
})();
if(inst_45790){
var statearr_45834_49831 = state_45825__$1;
(statearr_45834_49831[(1)] = (5));

} else {
var statearr_45835_49832 = state_45825__$1;
(statearr_45835_49832[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45826 === (15))){
var inst_45815 = (state_45825[(2)]);
var state_45825__$1 = state_45825;
var statearr_45836_49833 = state_45825__$1;
(statearr_45836_49833[(2)] = inst_45815);

(statearr_45836_49833[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45826 === (13))){
var state_45825__$1 = state_45825;
var statearr_45837_49838 = state_45825__$1;
(statearr_45837_49838[(2)] = null);

(statearr_45837_49838[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45826 === (6))){
var inst_45783 = (state_45825[(7)]);
var inst_45810 = inst_45783.length;
var inst_45811 = (inst_45810 > (0));
var state_45825__$1 = state_45825;
if(cljs.core.truth_(inst_45811)){
var statearr_45838_49845 = state_45825__$1;
(statearr_45838_49845[(1)] = (12));

} else {
var statearr_45839_49847 = state_45825__$1;
(statearr_45839_49847[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45826 === (3))){
var inst_45823 = (state_45825[(2)]);
var state_45825__$1 = state_45825;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45825__$1,inst_45823);
} else {
if((state_val_45826 === (12))){
var inst_45783 = (state_45825[(7)]);
var inst_45813 = cljs.core.vec.call(null,inst_45783);
var state_45825__$1 = state_45825;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45825__$1,(15),out,inst_45813);
} else {
if((state_val_45826 === (2))){
var state_45825__$1 = state_45825;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45825__$1,(4),ch);
} else {
if((state_val_45826 === (11))){
var inst_45787 = (state_45825[(9)]);
var inst_45792 = (state_45825[(10)]);
var inst_45803 = (state_45825[(2)]);
var inst_45804 = [];
var inst_45805 = inst_45804.push(inst_45787);
var inst_45783 = inst_45804;
var inst_45784 = inst_45792;
var state_45825__$1 = (function (){var statearr_45841 = state_45825;
(statearr_45841[(7)] = inst_45783);

(statearr_45841[(11)] = inst_45805);

(statearr_45841[(12)] = inst_45803);

(statearr_45841[(8)] = inst_45784);

return statearr_45841;
})();
var statearr_45843_49866 = state_45825__$1;
(statearr_45843_49866[(2)] = null);

(statearr_45843_49866[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45826 === (9))){
var inst_45783 = (state_45825[(7)]);
var inst_45801 = cljs.core.vec.call(null,inst_45783);
var state_45825__$1 = state_45825;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45825__$1,(11),out,inst_45801);
} else {
if((state_val_45826 === (5))){
var inst_45787 = (state_45825[(9)]);
var inst_45784 = (state_45825[(8)]);
var inst_45792 = (state_45825[(10)]);
var inst_45792__$1 = f.call(null,inst_45787);
var inst_45794 = cljs.core._EQ_.call(null,inst_45792__$1,inst_45784);
var inst_45795 = cljs.core.keyword_identical_QMARK_.call(null,inst_45784,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_45796 = ((inst_45794) || (inst_45795));
var state_45825__$1 = (function (){var statearr_45844 = state_45825;
(statearr_45844[(10)] = inst_45792__$1);

return statearr_45844;
})();
if(cljs.core.truth_(inst_45796)){
var statearr_45847_49876 = state_45825__$1;
(statearr_45847_49876[(1)] = (8));

} else {
var statearr_45849_49878 = state_45825__$1;
(statearr_45849_49878[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45826 === (14))){
var inst_45818 = (state_45825[(2)]);
var inst_45819 = cljs.core.async.close_BANG_.call(null,out);
var state_45825__$1 = (function (){var statearr_45851 = state_45825;
(statearr_45851[(13)] = inst_45818);

return statearr_45851;
})();
var statearr_45852_49882 = state_45825__$1;
(statearr_45852_49882[(2)] = inst_45819);

(statearr_45852_49882[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45826 === (10))){
var inst_45808 = (state_45825[(2)]);
var state_45825__$1 = state_45825;
var statearr_45855_49888 = state_45825__$1;
(statearr_45855_49888[(2)] = inst_45808);

(statearr_45855_49888[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45826 === (8))){
var inst_45783 = (state_45825[(7)]);
var inst_45787 = (state_45825[(9)]);
var inst_45792 = (state_45825[(10)]);
var inst_45798 = inst_45783.push(inst_45787);
var tmp45850 = inst_45783;
var inst_45783__$1 = tmp45850;
var inst_45784 = inst_45792;
var state_45825__$1 = (function (){var statearr_45856 = state_45825;
(statearr_45856[(7)] = inst_45783__$1);

(statearr_45856[(14)] = inst_45798);

(statearr_45856[(8)] = inst_45784);

return statearr_45856;
})();
var statearr_45857_49897 = state_45825__$1;
(statearr_45857_49897[(2)] = null);

(statearr_45857_49897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42267__auto__ = null;
var cljs$core$async$state_machine__42267__auto____0 = (function (){
var statearr_45858 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45858[(0)] = cljs$core$async$state_machine__42267__auto__);

(statearr_45858[(1)] = (1));

return statearr_45858;
});
var cljs$core$async$state_machine__42267__auto____1 = (function (state_45825){
while(true){
var ret_value__42268__auto__ = (function (){try{while(true){
var result__42269__auto__ = switch__42266__auto__.call(null,state_45825);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42269__auto__;
}
break;
}
}catch (e45859){var ex__42270__auto__ = e45859;
var statearr_45861_49906 = state_45825;
(statearr_45861_49906[(2)] = ex__42270__auto__);


if(cljs.core.seq.call(null,(state_45825[(4)]))){
var statearr_45865_49910 = state_45825;
(statearr_45865_49910[(1)] = cljs.core.first.call(null,(state_45825[(4)])));

} else {
throw ex__42270__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49915 = state_45825;
state_45825 = G__49915;
continue;
} else {
return ret_value__42268__auto__;
}
break;
}
});
cljs$core$async$state_machine__42267__auto__ = function(state_45825){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42267__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42267__auto____1.call(this,state_45825);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42267__auto____0;
cljs$core$async$state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42267__auto____1;
return cljs$core$async$state_machine__42267__auto__;
})()
})();
var state__42561__auto__ = (function (){var statearr_45867 = f__42560__auto__.call(null);
(statearr_45867[(6)] = c__42559__auto___49797);

return statearr_45867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42561__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
