goog.provide('shadow.dom');
goog.require('cljs.core');
goog.require('goog.dom');
goog.require('goog.dom.forms');
goog.require('goog.dom.classlist');
goog.require('goog.style');
goog.require('goog.style.transition');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('cljs.core.async');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
var x__4487__auto__ = (((this$ == null))?null:this$);
var m__4488__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,this$);
} else {
var m__4485__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IElement.-to-dom",this$);
}
}
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
var x__4487__auto__ = (((this$ == null))?null:this$);
var m__4488__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,this$);
} else {
var m__4485__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"SVGElement.-to-svg",this$);
}
}
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons.call(null,(coll[idx]),shadow.dom.lazy_native_coll_seq.call(null,coll,(idx + (1))));
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4185__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq.call(null,self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return shadow.dom._to_dom.call(null,el);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__46240 = arguments.length;
switch (G__46240) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node.call(null,root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__46253 = arguments.length;
switch (G__46253) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__46265 = arguments.length;
switch (G__46265) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node.call(null,el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__46275 = arguments.length;
switch (G__46275) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.call(null,e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.call(null,e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__46311 = arguments.length;
switch (G__46311) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node.call(null,el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node.call(null,parent),shadow.dom.dom_node.call(null,el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__46381 = arguments.length;
switch (G__46381) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node.call(null,el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class.call(null,el,cls);
} else {
return shadow.dom.remove_class.call(null,el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4185__auto__ = (!((typeof document !== 'undefined')));
if(or__4185__auto__){
return or__4185__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return handler.call(null,e,el);
}));
}catch (e46398){if((e46398 instanceof Object)){
var e = e46398;
return console.log("didnt support attachEvent",el,e);
} else {
throw e46398;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4185__auto__ = (!((typeof document !== 'undefined')));
if(or__4185__auto__){
return or__4185__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__46416 = cljs.core.seq.call(null,shadow.dom.query.call(null,selector,root_el));
var chunk__46417 = null;
var count__46418 = (0);
var i__46419 = (0);
while(true){
if((i__46419 < count__46418)){
var el = cljs.core._nth.call(null,chunk__46417,i__46419);
var handler_49529__$1 = ((function (seq__46416,chunk__46417,count__46418,i__46419,el){
return (function (e){
return handler.call(null,e,el);
});})(seq__46416,chunk__46417,count__46418,i__46419,el))
;
shadow.dom.dom_listen.call(null,el,cljs.core.name.call(null,ev),handler_49529__$1);


var G__49532 = seq__46416;
var G__49533 = chunk__46417;
var G__49534 = count__46418;
var G__49535 = (i__46419 + (1));
seq__46416 = G__49532;
chunk__46417 = G__49533;
count__46418 = G__49534;
i__46419 = G__49535;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__46416);
if(temp__5735__auto__){
var seq__46416__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46416__$1)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,seq__46416__$1);
var G__49540 = cljs.core.chunk_rest.call(null,seq__46416__$1);
var G__49541 = c__4609__auto__;
var G__49542 = cljs.core.count.call(null,c__4609__auto__);
var G__49543 = (0);
seq__46416 = G__49540;
chunk__46417 = G__49541;
count__46418 = G__49542;
i__46419 = G__49543;
continue;
} else {
var el = cljs.core.first.call(null,seq__46416__$1);
var handler_49546__$1 = ((function (seq__46416,chunk__46417,count__46418,i__46419,el,seq__46416__$1,temp__5735__auto__){
return (function (e){
return handler.call(null,e,el);
});})(seq__46416,chunk__46417,count__46418,i__46419,el,seq__46416__$1,temp__5735__auto__))
;
shadow.dom.dom_listen.call(null,el,cljs.core.name.call(null,ev),handler_49546__$1);


var G__49551 = cljs.core.next.call(null,seq__46416__$1);
var G__49552 = null;
var G__49553 = (0);
var G__49554 = (0);
seq__46416 = G__49551;
chunk__46417 = G__49552;
count__46418 = G__49553;
i__46419 = G__49554;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__46459 = arguments.length;
switch (G__46459) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.call(null,el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_.call(null,ev)){
return shadow.dom.on_query.call(null,el,cljs.core.first.call(null,ev),cljs.core.second.call(null,ev),handler);
} else {
var handler__$1 = (function (e){
return handler.call(null,e,el);
});
return shadow.dom.dom_listen.call(null,shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove.call(null,shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__46488 = cljs.core.seq.call(null,events);
var chunk__46489 = null;
var count__46490 = (0);
var i__46491 = (0);
while(true){
if((i__46491 < count__46490)){
var vec__46515 = cljs.core._nth.call(null,chunk__46489,i__46491);
var k = cljs.core.nth.call(null,vec__46515,(0),null);
var v = cljs.core.nth.call(null,vec__46515,(1),null);
shadow.dom.on.call(null,el,k,v);


var G__49577 = seq__46488;
var G__49578 = chunk__46489;
var G__49579 = count__46490;
var G__49580 = (i__46491 + (1));
seq__46488 = G__49577;
chunk__46489 = G__49578;
count__46490 = G__49579;
i__46491 = G__49580;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__46488);
if(temp__5735__auto__){
var seq__46488__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46488__$1)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,seq__46488__$1);
var G__49584 = cljs.core.chunk_rest.call(null,seq__46488__$1);
var G__49585 = c__4609__auto__;
var G__49586 = cljs.core.count.call(null,c__4609__auto__);
var G__49587 = (0);
seq__46488 = G__49584;
chunk__46489 = G__49585;
count__46490 = G__49586;
i__46491 = G__49587;
continue;
} else {
var vec__46541 = cljs.core.first.call(null,seq__46488__$1);
var k = cljs.core.nth.call(null,vec__46541,(0),null);
var v = cljs.core.nth.call(null,vec__46541,(1),null);
shadow.dom.on.call(null,el,k,v);


var G__49592 = cljs.core.next.call(null,seq__46488__$1);
var G__49593 = null;
var G__49594 = (0);
var G__49595 = (0);
seq__46488 = G__49592;
chunk__46489 = G__49593;
count__46490 = G__49594;
i__46491 = G__49595;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node.call(null,el);
var seq__46562 = cljs.core.seq.call(null,styles);
var chunk__46563 = null;
var count__46564 = (0);
var i__46565 = (0);
while(true){
if((i__46565 < count__46564)){
var vec__46644 = cljs.core._nth.call(null,chunk__46563,i__46565);
var k = cljs.core.nth.call(null,vec__46644,(0),null);
var v = cljs.core.nth.call(null,vec__46644,(1),null);
goog.style.setStyle(dom,cljs.core.name.call(null,k),(((v == null))?"":v));


var G__49602 = seq__46562;
var G__49603 = chunk__46563;
var G__49604 = count__46564;
var G__49605 = (i__46565 + (1));
seq__46562 = G__49602;
chunk__46563 = G__49603;
count__46564 = G__49604;
i__46565 = G__49605;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__46562);
if(temp__5735__auto__){
var seq__46562__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46562__$1)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,seq__46562__$1);
var G__49610 = cljs.core.chunk_rest.call(null,seq__46562__$1);
var G__49611 = c__4609__auto__;
var G__49612 = cljs.core.count.call(null,c__4609__auto__);
var G__49613 = (0);
seq__46562 = G__49610;
chunk__46563 = G__49611;
count__46564 = G__49612;
i__46565 = G__49613;
continue;
} else {
var vec__46672 = cljs.core.first.call(null,seq__46562__$1);
var k = cljs.core.nth.call(null,vec__46672,(0),null);
var v = cljs.core.nth.call(null,vec__46672,(1),null);
goog.style.setStyle(dom,cljs.core.name.call(null,k),(((v == null))?"":v));


var G__49618 = cljs.core.next.call(null,seq__46562__$1);
var G__49619 = null;
var G__49620 = (0);
var G__49621 = (0);
seq__46562 = G__49618;
chunk__46563 = G__49619;
count__46564 = G__49620;
i__46565 = G__49621;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__46719_49625 = key;
var G__46719_49626__$1 = (((G__46719_49625 instanceof cljs.core.Keyword))?G__46719_49625.fqn:null);
switch (G__46719_49626__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners.call(null,el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_.call(null,value)){
shadow.dom.set_style.call(null,el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_49643 = cljs.core.name.call(null,key);
if(cljs.core.truth_((function (){var or__4185__auto__ = goog.string.startsWith(ks_49643,"data-");
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return goog.string.startsWith(ks_49643,"aria-");
}
})())){
el.setAttribute(ks_49643,value);
} else {
(el[ks_49643] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv.call(null,(function (el__$1,key,value){
shadow.dom.set_attr_STAR_.call(null,el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node.call(null,el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_.call(null,shadow.dom.dom_node.call(null,el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq.call(null,current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name.call(null,spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.call(null,(-1),fdot)) && (cljs.core._EQ_.call(null,(-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.call(null,(-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace.call(null,spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.call(null,(-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace.call(null,spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__46799){
var map__46800 = p__46799;
var map__46800__$1 = (((((!((map__46800 == null))))?(((((map__46800.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46800.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46800):map__46800);
var props = map__46800__$1;
var class$ = cljs.core.get.call(null,map__46800__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__46803 = shadow.dom.parse_tag.call(null,tag_def);
var tag_name = cljs.core.nth.call(null,vec__46803,(0),null);
var tag_id = cljs.core.nth.call(null,vec__46803,(1),null);
var tag_classes = cljs.core.nth.call(null,vec__46803,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string.call(null,class$,tag_classes));
} else {
}

var G__46808 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs.call(null,G__46808,cljs.core.dissoc.call(null,props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__46808;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__46815 = arguments.length;
switch (G__46815) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5735__auto__ = shadow.dom.dom_node.call(null,node);
if(cljs.core.truth_(temp__5735__auto__)){
var n = temp__5735__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5735__auto__ = shadow.dom.dom_node.call(null,node);
if(cljs.core.truth_(temp__5735__auto__)){
var n = temp__5735__auto__;
shadow.dom.dom_node.call(null,el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__46827){
var vec__46828 = p__46827;
var seq__46829 = cljs.core.seq.call(null,vec__46828);
var first__46830 = cljs.core.first.call(null,seq__46829);
var seq__46829__$1 = cljs.core.next.call(null,seq__46829);
var nn = first__46830;
var first__46830__$1 = cljs.core.first.call(null,seq__46829__$1);
var seq__46829__$2 = cljs.core.next.call(null,seq__46829__$1);
var np = first__46830__$1;
var nc = seq__46829__$2;
var node = vec__46828;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.call(null,"invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [create_fn.call(null,nn,cljs.core.PersistentArrayMap.EMPTY),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_.call(null,np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [create_fn.call(null,nn,np),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [create_fn.call(null,nn,cljs.core.PersistentArrayMap.EMPTY),cljs.core.conj.call(null,nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__46840 = shadow.dom.destructure_node.call(null,shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.call(null,vec__46840,(0),null);
var node_children = cljs.core.nth.call(null,vec__46840,(1),null);
var seq__46843_49704 = cljs.core.seq.call(null,node_children);
var chunk__46844_49705 = null;
var count__46845_49706 = (0);
var i__46846_49707 = (0);
while(true){
if((i__46846_49707 < count__46845_49706)){
var child_struct_49711 = cljs.core._nth.call(null,chunk__46844_49705,i__46846_49707);
var children_49712 = shadow.dom.dom_node.call(null,child_struct_49711);
if(cljs.core.seq_QMARK_.call(null,children_49712)){
var seq__47001_49714 = cljs.core.seq.call(null,cljs.core.map.call(null,shadow.dom.dom_node,children_49712));
var chunk__47003_49715 = null;
var count__47004_49716 = (0);
var i__47005_49717 = (0);
while(true){
if((i__47005_49717 < count__47004_49716)){
var child_49719 = cljs.core._nth.call(null,chunk__47003_49715,i__47005_49717);
if(cljs.core.truth_(child_49719)){
shadow.dom.append.call(null,node,child_49719);


var G__49724 = seq__47001_49714;
var G__49725 = chunk__47003_49715;
var G__49726 = count__47004_49716;
var G__49727 = (i__47005_49717 + (1));
seq__47001_49714 = G__49724;
chunk__47003_49715 = G__49725;
count__47004_49716 = G__49726;
i__47005_49717 = G__49727;
continue;
} else {
var G__49729 = seq__47001_49714;
var G__49730 = chunk__47003_49715;
var G__49731 = count__47004_49716;
var G__49732 = (i__47005_49717 + (1));
seq__47001_49714 = G__49729;
chunk__47003_49715 = G__49730;
count__47004_49716 = G__49731;
i__47005_49717 = G__49732;
continue;
}
} else {
var temp__5735__auto___49734 = cljs.core.seq.call(null,seq__47001_49714);
if(temp__5735__auto___49734){
var seq__47001_49737__$1 = temp__5735__auto___49734;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47001_49737__$1)){
var c__4609__auto___49739 = cljs.core.chunk_first.call(null,seq__47001_49737__$1);
var G__49740 = cljs.core.chunk_rest.call(null,seq__47001_49737__$1);
var G__49741 = c__4609__auto___49739;
var G__49742 = cljs.core.count.call(null,c__4609__auto___49739);
var G__49743 = (0);
seq__47001_49714 = G__49740;
chunk__47003_49715 = G__49741;
count__47004_49716 = G__49742;
i__47005_49717 = G__49743;
continue;
} else {
var child_49744 = cljs.core.first.call(null,seq__47001_49737__$1);
if(cljs.core.truth_(child_49744)){
shadow.dom.append.call(null,node,child_49744);


var G__49747 = cljs.core.next.call(null,seq__47001_49737__$1);
var G__49748 = null;
var G__49749 = (0);
var G__49750 = (0);
seq__47001_49714 = G__49747;
chunk__47003_49715 = G__49748;
count__47004_49716 = G__49749;
i__47005_49717 = G__49750;
continue;
} else {
var G__49755 = cljs.core.next.call(null,seq__47001_49737__$1);
var G__49756 = null;
var G__49757 = (0);
var G__49758 = (0);
seq__47001_49714 = G__49755;
chunk__47003_49715 = G__49756;
count__47004_49716 = G__49757;
i__47005_49717 = G__49758;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.call(null,node,children_49712);
}


var G__49760 = seq__46843_49704;
var G__49761 = chunk__46844_49705;
var G__49762 = count__46845_49706;
var G__49763 = (i__46846_49707 + (1));
seq__46843_49704 = G__49760;
chunk__46844_49705 = G__49761;
count__46845_49706 = G__49762;
i__46846_49707 = G__49763;
continue;
} else {
var temp__5735__auto___49765 = cljs.core.seq.call(null,seq__46843_49704);
if(temp__5735__auto___49765){
var seq__46843_49766__$1 = temp__5735__auto___49765;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46843_49766__$1)){
var c__4609__auto___49767 = cljs.core.chunk_first.call(null,seq__46843_49766__$1);
var G__49768 = cljs.core.chunk_rest.call(null,seq__46843_49766__$1);
var G__49769 = c__4609__auto___49767;
var G__49770 = cljs.core.count.call(null,c__4609__auto___49767);
var G__49771 = (0);
seq__46843_49704 = G__49768;
chunk__46844_49705 = G__49769;
count__46845_49706 = G__49770;
i__46846_49707 = G__49771;
continue;
} else {
var child_struct_49774 = cljs.core.first.call(null,seq__46843_49766__$1);
var children_49777 = shadow.dom.dom_node.call(null,child_struct_49774);
if(cljs.core.seq_QMARK_.call(null,children_49777)){
var seq__47109_49779 = cljs.core.seq.call(null,cljs.core.map.call(null,shadow.dom.dom_node,children_49777));
var chunk__47111_49780 = null;
var count__47112_49781 = (0);
var i__47113_49782 = (0);
while(true){
if((i__47113_49782 < count__47112_49781)){
var child_49786 = cljs.core._nth.call(null,chunk__47111_49780,i__47113_49782);
if(cljs.core.truth_(child_49786)){
shadow.dom.append.call(null,node,child_49786);


var G__49789 = seq__47109_49779;
var G__49790 = chunk__47111_49780;
var G__49791 = count__47112_49781;
var G__49792 = (i__47113_49782 + (1));
seq__47109_49779 = G__49789;
chunk__47111_49780 = G__49790;
count__47112_49781 = G__49791;
i__47113_49782 = G__49792;
continue;
} else {
var G__49793 = seq__47109_49779;
var G__49794 = chunk__47111_49780;
var G__49795 = count__47112_49781;
var G__49796 = (i__47113_49782 + (1));
seq__47109_49779 = G__49793;
chunk__47111_49780 = G__49794;
count__47112_49781 = G__49795;
i__47113_49782 = G__49796;
continue;
}
} else {
var temp__5735__auto___49798__$1 = cljs.core.seq.call(null,seq__47109_49779);
if(temp__5735__auto___49798__$1){
var seq__47109_49799__$1 = temp__5735__auto___49798__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47109_49799__$1)){
var c__4609__auto___49800 = cljs.core.chunk_first.call(null,seq__47109_49799__$1);
var G__49801 = cljs.core.chunk_rest.call(null,seq__47109_49799__$1);
var G__49802 = c__4609__auto___49800;
var G__49803 = cljs.core.count.call(null,c__4609__auto___49800);
var G__49804 = (0);
seq__47109_49779 = G__49801;
chunk__47111_49780 = G__49802;
count__47112_49781 = G__49803;
i__47113_49782 = G__49804;
continue;
} else {
var child_49806 = cljs.core.first.call(null,seq__47109_49799__$1);
if(cljs.core.truth_(child_49806)){
shadow.dom.append.call(null,node,child_49806);


var G__49807 = cljs.core.next.call(null,seq__47109_49799__$1);
var G__49808 = null;
var G__49809 = (0);
var G__49810 = (0);
seq__47109_49779 = G__49807;
chunk__47111_49780 = G__49808;
count__47112_49781 = G__49809;
i__47113_49782 = G__49810;
continue;
} else {
var G__49813 = cljs.core.next.call(null,seq__47109_49799__$1);
var G__49814 = null;
var G__49815 = (0);
var G__49816 = (0);
seq__47109_49779 = G__49813;
chunk__47111_49780 = G__49814;
count__47112_49781 = G__49815;
i__47113_49782 = G__49816;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.call(null,node,children_49777);
}


var G__49822 = cljs.core.next.call(null,seq__46843_49766__$1);
var G__49823 = null;
var G__49824 = (0);
var G__49825 = (0);
seq__46843_49704 = G__49822;
chunk__46844_49705 = G__49823;
count__46845_49706 = G__49824;
i__46846_49707 = G__49825;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node.call(null,this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.call(null,shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node.call(null,node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__47218 = cljs.core.seq.call(null,node);
var chunk__47219 = null;
var count__47220 = (0);
var i__47221 = (0);
while(true){
if((i__47221 < count__47220)){
var n = cljs.core._nth.call(null,chunk__47219,i__47221);
shadow.dom.remove.call(null,n);


var G__49849 = seq__47218;
var G__49850 = chunk__47219;
var G__49851 = count__47220;
var G__49852 = (i__47221 + (1));
seq__47218 = G__49849;
chunk__47219 = G__49850;
count__47220 = G__49851;
i__47221 = G__49852;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__47218);
if(temp__5735__auto__){
var seq__47218__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47218__$1)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,seq__47218__$1);
var G__49855 = cljs.core.chunk_rest.call(null,seq__47218__$1);
var G__49856 = c__4609__auto__;
var G__49857 = cljs.core.count.call(null,c__4609__auto__);
var G__49858 = (0);
seq__47218 = G__49855;
chunk__47219 = G__49856;
count__47220 = G__49857;
i__47221 = G__49858;
continue;
} else {
var n = cljs.core.first.call(null,seq__47218__$1);
shadow.dom.remove.call(null,n);


var G__49861 = cljs.core.next.call(null,seq__47218__$1);
var G__49862 = null;
var G__49863 = (0);
var G__49864 = (0);
seq__47218 = G__49861;
chunk__47219 = G__49862;
count__47220 = G__49863;
i__47221 = G__49864;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node.call(null,new$),shadow.dom.dom_node.call(null,old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__47245 = arguments.length;
switch (G__47245) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node.call(null,el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node.call(null,el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__47277 = arguments.length;
switch (G__47277) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.call(null,el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node.call(null,el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node.call(null,el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__47314 = arguments.length;
switch (G__47314) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node.call(null,el).getAttribute(cljs.core.name.call(null,key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4185__auto__ = shadow.dom.dom_node.call(null,el).getAttribute(cljs.core.name.call(null,key));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node.call(null,el).removeAttribute(cljs.core.name.call(null,key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node.call(null,el).getAttribute(["data-",cljs.core.name.call(null,key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node.call(null,el).setAttribute(["data-",cljs.core.name.call(null,key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node.call(null,node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node.call(null,node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4795__auto__ = [];
var len__4789__auto___49905 = arguments.length;
var i__4790__auto___49908 = (0);
while(true){
if((i__4790__auto___49908 < len__4789__auto___49905)){
args__4795__auto__.push((arguments[i__4790__auto___49908]));

var G__49911 = (i__4790__auto___49908 + (1));
i__4790__auto___49908 = G__49911;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((0) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4796__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__47510_49916 = cljs.core.seq.call(null,nodes);
var chunk__47511_49917 = null;
var count__47512_49918 = (0);
var i__47513_49919 = (0);
while(true){
if((i__47513_49919 < count__47512_49918)){
var node_49921 = cljs.core._nth.call(null,chunk__47511_49917,i__47513_49919);
fragment.appendChild(shadow.dom._to_dom.call(null,node_49921));


var G__49923 = seq__47510_49916;
var G__49924 = chunk__47511_49917;
var G__49925 = count__47512_49918;
var G__49926 = (i__47513_49919 + (1));
seq__47510_49916 = G__49923;
chunk__47511_49917 = G__49924;
count__47512_49918 = G__49925;
i__47513_49919 = G__49926;
continue;
} else {
var temp__5735__auto___49928 = cljs.core.seq.call(null,seq__47510_49916);
if(temp__5735__auto___49928){
var seq__47510_49929__$1 = temp__5735__auto___49928;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47510_49929__$1)){
var c__4609__auto___49931 = cljs.core.chunk_first.call(null,seq__47510_49929__$1);
var G__49932 = cljs.core.chunk_rest.call(null,seq__47510_49929__$1);
var G__49933 = c__4609__auto___49931;
var G__49934 = cljs.core.count.call(null,c__4609__auto___49931);
var G__49935 = (0);
seq__47510_49916 = G__49932;
chunk__47511_49917 = G__49933;
count__47512_49918 = G__49934;
i__47513_49919 = G__49935;
continue;
} else {
var node_49938 = cljs.core.first.call(null,seq__47510_49929__$1);
fragment.appendChild(shadow.dom._to_dom.call(null,node_49938));


var G__49940 = cljs.core.next.call(null,seq__47510_49929__$1);
var G__49941 = null;
var G__49942 = (0);
var G__49943 = (0);
seq__47510_49916 = G__49940;
chunk__47511_49917 = G__49941;
count__47512_49918 = G__49942;
i__47513_49919 = G__49943;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq47457){
var self__4777__auto__ = this;
return self__4777__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq47457));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq.call(null,/<script[^>]*?>(.+?)<\/script>/,s);
var seq__47575_49950 = cljs.core.seq.call(null,scripts);
var chunk__47576_49951 = null;
var count__47577_49952 = (0);
var i__47578_49953 = (0);
while(true){
if((i__47578_49953 < count__47577_49952)){
var vec__47592_49958 = cljs.core._nth.call(null,chunk__47576_49951,i__47578_49953);
var script_tag_49959 = cljs.core.nth.call(null,vec__47592_49958,(0),null);
var script_body_49961 = cljs.core.nth.call(null,vec__47592_49958,(1),null);
eval(script_body_49961);


var G__49963 = seq__47575_49950;
var G__49964 = chunk__47576_49951;
var G__49965 = count__47577_49952;
var G__49966 = (i__47578_49953 + (1));
seq__47575_49950 = G__49963;
chunk__47576_49951 = G__49964;
count__47577_49952 = G__49965;
i__47578_49953 = G__49966;
continue;
} else {
var temp__5735__auto___49968 = cljs.core.seq.call(null,seq__47575_49950);
if(temp__5735__auto___49968){
var seq__47575_49970__$1 = temp__5735__auto___49968;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47575_49970__$1)){
var c__4609__auto___49972 = cljs.core.chunk_first.call(null,seq__47575_49970__$1);
var G__49974 = cljs.core.chunk_rest.call(null,seq__47575_49970__$1);
var G__49975 = c__4609__auto___49972;
var G__49976 = cljs.core.count.call(null,c__4609__auto___49972);
var G__49977 = (0);
seq__47575_49950 = G__49974;
chunk__47576_49951 = G__49975;
count__47577_49952 = G__49976;
i__47578_49953 = G__49977;
continue;
} else {
var vec__47601_49979 = cljs.core.first.call(null,seq__47575_49970__$1);
var script_tag_49980 = cljs.core.nth.call(null,vec__47601_49979,(0),null);
var script_body_49981 = cljs.core.nth.call(null,vec__47601_49979,(1),null);
eval(script_body_49981);


var G__49984 = cljs.core.next.call(null,seq__47575_49970__$1);
var G__49985 = null;
var G__49986 = (0);
var G__49987 = (0);
seq__47575_49950 = G__49984;
chunk__47576_49951 = G__49985;
count__47577_49952 = G__49986;
i__47578_49953 = G__49987;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.call(null,(function (s__$1,p__47608){
var vec__47610 = p__47608;
var script_tag = cljs.core.nth.call(null,vec__47610,(0),null);
var script_body = cljs.core.nth.call(null,vec__47610,(1),null);
return clojure.string.replace.call(null,s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node.call(null,el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__47642 = arguments.length;
switch (G__47642) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,tag),cljs.core.name.call(null,cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node.call(null,dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node.call(null,dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name.call(null,style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node.call(null,el);
return shadow.dom.remove_style_STAR_.call(null,el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node.call(null,el);
var seq__47689 = cljs.core.seq.call(null,style_keys);
var chunk__47690 = null;
var count__47691 = (0);
var i__47692 = (0);
while(true){
if((i__47692 < count__47691)){
var it = cljs.core._nth.call(null,chunk__47690,i__47692);
shadow.dom.remove_style_STAR_.call(null,el__$1,it);


var G__50016 = seq__47689;
var G__50017 = chunk__47690;
var G__50018 = count__47691;
var G__50019 = (i__47692 + (1));
seq__47689 = G__50016;
chunk__47690 = G__50017;
count__47691 = G__50018;
i__47692 = G__50019;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__47689);
if(temp__5735__auto__){
var seq__47689__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47689__$1)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,seq__47689__$1);
var G__50020 = cljs.core.chunk_rest.call(null,seq__47689__$1);
var G__50021 = c__4609__auto__;
var G__50022 = cljs.core.count.call(null,c__4609__auto__);
var G__50023 = (0);
seq__47689 = G__50020;
chunk__47690 = G__50021;
count__47691 = G__50022;
i__47692 = G__50023;
continue;
} else {
var it = cljs.core.first.call(null,seq__47689__$1);
shadow.dom.remove_style_STAR_.call(null,el__$1,it);


var G__50026 = cljs.core.next.call(null,seq__47689__$1);
var G__50027 = null;
var G__50028 = (0);
var G__50029 = (0);
seq__47689 = G__50026;
chunk__47690 = G__50027;
count__47691 = G__50028;
i__47692 = G__50029;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4439__auto__,k__4440__auto__){
var self__ = this;
var this__4439__auto____$1 = this;
return this__4439__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4440__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4441__auto__,k47719,else__4442__auto__){
var self__ = this;
var this__4441__auto____$1 = this;
var G__47752 = k47719;
var G__47752__$1 = (((G__47752 instanceof cljs.core.Keyword))?G__47752.fqn:null);
switch (G__47752__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k47719,else__4442__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4458__auto__,f__4459__auto__,init__4460__auto__){
var self__ = this;
var this__4458__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4461__auto__,p__47760){
var vec__47762 = p__47760;
var k__4462__auto__ = cljs.core.nth.call(null,vec__47762,(0),null);
var v__4463__auto__ = cljs.core.nth.call(null,vec__47762,(1),null);
return f__4459__auto__.call(null,ret__4461__auto__,k__4462__auto__,v__4463__auto__);
}),init__4460__auto__,this__4458__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4453__auto__,writer__4454__auto__,opts__4455__auto__){
var self__ = this;
var this__4453__auto____$1 = this;
var pr_pair__4456__auto__ = (function (keyval__4457__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4454__auto__,cljs.core.pr_writer,""," ","",opts__4455__auto__,keyval__4457__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4454__auto__,pr_pair__4456__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4455__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__47718){
var self__ = this;
var G__47718__$1 = this;
return (new cljs.core.RecordIter((0),G__47718__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4437__auto__){
var self__ = this;
var this__4437__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4434__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4443__auto__){
var self__ = this;
var this__4443__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4435__auto__){
var self__ = this;
var this__4435__auto____$1 = this;
var h__4297__auto__ = self__.__hash;
if((!((h__4297__auto__ == null)))){
return h__4297__auto__;
} else {
var h__4297__auto____$1 = (function (coll__4436__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll.call(null,coll__4436__auto__));
}).call(null,this__4435__auto____$1);
(self__.__hash = h__4297__auto____$1);

return h__4297__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this47720,other47721){
var self__ = this;
var this47720__$1 = this;
return (((!((other47721 == null)))) && ((this47720__$1.constructor === other47721.constructor)) && (cljs.core._EQ_.call(null,this47720__$1.x,other47721.x)) && (cljs.core._EQ_.call(null,this47720__$1.y,other47721.y)) && (cljs.core._EQ_.call(null,this47720__$1.__extmap,other47721.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4448__auto__,k__4449__auto__){
var self__ = this;
var this__4448__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4449__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4448__auto____$1),self__.__meta),k__4449__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4449__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4446__auto__,k__4447__auto__,G__47718){
var self__ = this;
var this__4446__auto____$1 = this;
var pred__47862 = cljs.core.keyword_identical_QMARK_;
var expr__47863 = k__4447__auto__;
if(cljs.core.truth_(pred__47862.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__47863))){
return (new shadow.dom.Coordinate(G__47718,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__47862.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__47863))){
return (new shadow.dom.Coordinate(self__.x,G__47718,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4447__auto__,G__47718),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4451__auto__){
var self__ = this;
var this__4451__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4438__auto__,G__47718){
var self__ = this;
var this__4438__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__47718,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4444__auto__,entry__4445__auto__){
var self__ = this;
var this__4444__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4445__auto__)){
return this__4444__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4445__auto__,(0)),cljs.core._nth.call(null,entry__4445__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4444__auto____$1,entry__4445__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4482__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4482__auto__,writer__4483__auto__){
return cljs.core._write.call(null,writer__4483__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__47731){
var extmap__4478__auto__ = (function (){var G__47983 = cljs.core.dissoc.call(null,G__47731,new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776));
if(cljs.core.record_QMARK_.call(null,G__47731)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__47983);
} else {
return G__47983;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__47731),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__47731),null,cljs.core.not_empty.call(null,extmap__4478__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node.call(null,el));
return shadow.dom.__GT_Coordinate.call(null,pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node.call(null,el));
return shadow.dom.__GT_Coordinate.call(null,pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node.call(null,el));
return shadow.dom.__GT_Coordinate.call(null,pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4439__auto__,k__4440__auto__){
var self__ = this;
var this__4439__auto____$1 = this;
return this__4439__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4440__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4441__auto__,k48012,else__4442__auto__){
var self__ = this;
var this__4441__auto____$1 = this;
var G__48035 = k48012;
var G__48035__$1 = (((G__48035 instanceof cljs.core.Keyword))?G__48035.fqn:null);
switch (G__48035__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k48012,else__4442__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4458__auto__,f__4459__auto__,init__4460__auto__){
var self__ = this;
var this__4458__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4461__auto__,p__48045){
var vec__48048 = p__48045;
var k__4462__auto__ = cljs.core.nth.call(null,vec__48048,(0),null);
var v__4463__auto__ = cljs.core.nth.call(null,vec__48048,(1),null);
return f__4459__auto__.call(null,ret__4461__auto__,k__4462__auto__,v__4463__auto__);
}),init__4460__auto__,this__4458__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4453__auto__,writer__4454__auto__,opts__4455__auto__){
var self__ = this;
var this__4453__auto____$1 = this;
var pr_pair__4456__auto__ = (function (keyval__4457__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4454__auto__,cljs.core.pr_writer,""," ","",opts__4455__auto__,keyval__4457__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4454__auto__,pr_pair__4456__auto__,"#shadow.dom.Size{",", ","}",opts__4455__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__48011){
var self__ = this;
var G__48011__$1 = this;
return (new cljs.core.RecordIter((0),G__48011__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4437__auto__){
var self__ = this;
var this__4437__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4434__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4443__auto__){
var self__ = this;
var this__4443__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4435__auto__){
var self__ = this;
var this__4435__auto____$1 = this;
var h__4297__auto__ = self__.__hash;
if((!((h__4297__auto__ == null)))){
return h__4297__auto__;
} else {
var h__4297__auto____$1 = (function (coll__4436__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll.call(null,coll__4436__auto__));
}).call(null,this__4435__auto____$1);
(self__.__hash = h__4297__auto____$1);

return h__4297__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this48013,other48014){
var self__ = this;
var this48013__$1 = this;
return (((!((other48014 == null)))) && ((this48013__$1.constructor === other48014.constructor)) && (cljs.core._EQ_.call(null,this48013__$1.w,other48014.w)) && (cljs.core._EQ_.call(null,this48013__$1.h,other48014.h)) && (cljs.core._EQ_.call(null,this48013__$1.__extmap,other48014.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4448__auto__,k__4449__auto__){
var self__ = this;
var this__4448__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4449__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4448__auto____$1),self__.__meta),k__4449__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4449__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4446__auto__,k__4447__auto__,G__48011){
var self__ = this;
var this__4446__auto____$1 = this;
var pred__48134 = cljs.core.keyword_identical_QMARK_;
var expr__48135 = k__4447__auto__;
if(cljs.core.truth_(pred__48134.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__48135))){
return (new shadow.dom.Size(G__48011,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48134.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__48135))){
return (new shadow.dom.Size(self__.w,G__48011,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4447__auto__,G__48011),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4451__auto__){
var self__ = this;
var this__4451__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4438__auto__,G__48011){
var self__ = this;
var this__4438__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__48011,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4444__auto__,entry__4445__auto__){
var self__ = this;
var this__4444__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4445__auto__)){
return this__4444__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4445__auto__,(0)),cljs.core._nth.call(null,entry__4445__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4444__auto____$1,entry__4445__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4482__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4482__auto__,writer__4483__auto__){
return cljs.core._write.call(null,writer__4483__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__48021){
var extmap__4478__auto__ = (function (){var G__48175 = cljs.core.dissoc.call(null,G__48021,new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740));
if(cljs.core.record_QMARK_.call(null,G__48021)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__48175);
} else {
return G__48175;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__48021),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__48021),null,cljs.core.not_empty.call(null,extmap__4478__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj.call(null,goog.style.getSize(shadow.dom.dom_node.call(null,el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size.call(null,el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj.call(null,goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node.call(null,el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node.call(null,el);
var opts = (native$["options"]);
var a__4663__auto__ = opts;
var l__4664__auto__ = a__4663__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4664__auto__)){
var G__50299 = (i + (1));
var G__50300 = cljs.core.conj.call(null,ret,(opts[i]["value"]));
i = G__50299;
ret = G__50300;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_.call(null,query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.call(null,"&",cljs.core.map.call(null,(function (p__48387){
var vec__48390 = p__48387;
var k = cljs.core.nth.call(null,vec__48390,(0),null);
var v = cljs.core.nth.call(null,vec__48390,(1),null);
return [cljs.core.name.call(null,k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__48449 = arguments.length;
switch (G__48449) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.call(null,path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url.call(null,path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node.call(null,el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node.call(null,new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node.call(null,ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node.call(null,new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node.call(null,ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5733__auto__ = shadow.dom.dom_node.call(null,ref).firstChild;
if(cljs.core.truth_(temp__5733__auto__)){
var child = temp__5733__auto__;
return shadow.dom.insert_before.call(null,child,new$);
} else {
return shadow.dom.append.call(null,ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node.call(null,el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__50330 = ps;
var G__50331 = (i + (1));
el__$1 = G__50330;
i = G__50331;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node.call(null,el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent.call(null,el);
if(cljs.core.truth_(parent)){
return cljs.core.cons.call(null,parent,(new cljs.core.LazySeq(null,(function (){
return shadow.dom.parents.call(null,parent);
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node.call(null,el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node.call(null,el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node.call(null,el));
});
shadow.dom.xmlns = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__48784 = shadow.dom.parse_tag.call(null,tag_def);
var tag_name = cljs.core.nth.call(null,vec__48784,(0),null);
var tag_id = cljs.core.nth.call(null,vec__48784,(1),null);
var tag_classes = cljs.core.nth.call(null,vec__48784,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string.call(null,new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__48811_50344 = cljs.core.seq.call(null,props);
var chunk__48812_50345 = null;
var count__48813_50346 = (0);
var i__48814_50347 = (0);
while(true){
if((i__48814_50347 < count__48813_50346)){
var vec__48929_50348 = cljs.core._nth.call(null,chunk__48812_50345,i__48814_50347);
var k_50349 = cljs.core.nth.call(null,vec__48929_50348,(0),null);
var v_50350 = cljs.core.nth.call(null,vec__48929_50348,(1),null);
el.setAttributeNS((function (){var temp__5735__auto__ = cljs.core.namespace.call(null,k_50349);
if(cljs.core.truth_(temp__5735__auto__)){
var ns = temp__5735__auto__;
return cljs.core.get.call(null,cljs.core.deref.call(null,shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name.call(null,k_50349),v_50350);


var G__50354 = seq__48811_50344;
var G__50355 = chunk__48812_50345;
var G__50356 = count__48813_50346;
var G__50357 = (i__48814_50347 + (1));
seq__48811_50344 = G__50354;
chunk__48812_50345 = G__50355;
count__48813_50346 = G__50356;
i__48814_50347 = G__50357;
continue;
} else {
var temp__5735__auto___50358 = cljs.core.seq.call(null,seq__48811_50344);
if(temp__5735__auto___50358){
var seq__48811_50359__$1 = temp__5735__auto___50358;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__48811_50359__$1)){
var c__4609__auto___50360 = cljs.core.chunk_first.call(null,seq__48811_50359__$1);
var G__50361 = cljs.core.chunk_rest.call(null,seq__48811_50359__$1);
var G__50362 = c__4609__auto___50360;
var G__50364 = cljs.core.count.call(null,c__4609__auto___50360);
var G__50365 = (0);
seq__48811_50344 = G__50361;
chunk__48812_50345 = G__50362;
count__48813_50346 = G__50364;
i__48814_50347 = G__50365;
continue;
} else {
var vec__48968_50366 = cljs.core.first.call(null,seq__48811_50359__$1);
var k_50367 = cljs.core.nth.call(null,vec__48968_50366,(0),null);
var v_50368 = cljs.core.nth.call(null,vec__48968_50366,(1),null);
el.setAttributeNS((function (){var temp__5735__auto____$1 = cljs.core.namespace.call(null,k_50367);
if(cljs.core.truth_(temp__5735__auto____$1)){
var ns = temp__5735__auto____$1;
return cljs.core.get.call(null,cljs.core.deref.call(null,shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name.call(null,k_50367),v_50368);


var G__50374 = cljs.core.next.call(null,seq__48811_50359__$1);
var G__50375 = null;
var G__50376 = (0);
var G__50377 = (0);
seq__48811_50344 = G__50374;
chunk__48812_50345 = G__50375;
count__48813_50346 = G__50376;
i__48814_50347 = G__50377;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return shadow.dom._to_svg.call(null,el);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__49058 = shadow.dom.destructure_node.call(null,shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.call(null,vec__49058,(0),null);
var node_children = cljs.core.nth.call(null,vec__49058,(1),null);
var seq__49062_50386 = cljs.core.seq.call(null,node_children);
var chunk__49064_50387 = null;
var count__49065_50388 = (0);
var i__49066_50389 = (0);
while(true){
if((i__49066_50389 < count__49065_50388)){
var child_struct_50392 = cljs.core._nth.call(null,chunk__49064_50387,i__49066_50389);
if((!((child_struct_50392 == null)))){
if(typeof child_struct_50392 === 'string'){
var text_50394 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_50394),child_struct_50392].join(''));
} else {
var children_50395 = shadow.dom.svg_node.call(null,child_struct_50392);
if(cljs.core.seq_QMARK_.call(null,children_50395)){
var seq__49186_50396 = cljs.core.seq.call(null,children_50395);
var chunk__49188_50397 = null;
var count__49189_50398 = (0);
var i__49190_50399 = (0);
while(true){
if((i__49190_50399 < count__49189_50398)){
var child_50401 = cljs.core._nth.call(null,chunk__49188_50397,i__49190_50399);
if(cljs.core.truth_(child_50401)){
node.appendChild(child_50401);


var G__50403 = seq__49186_50396;
var G__50404 = chunk__49188_50397;
var G__50405 = count__49189_50398;
var G__50406 = (i__49190_50399 + (1));
seq__49186_50396 = G__50403;
chunk__49188_50397 = G__50404;
count__49189_50398 = G__50405;
i__49190_50399 = G__50406;
continue;
} else {
var G__50408 = seq__49186_50396;
var G__50409 = chunk__49188_50397;
var G__50410 = count__49189_50398;
var G__50411 = (i__49190_50399 + (1));
seq__49186_50396 = G__50408;
chunk__49188_50397 = G__50409;
count__49189_50398 = G__50410;
i__49190_50399 = G__50411;
continue;
}
} else {
var temp__5735__auto___50414 = cljs.core.seq.call(null,seq__49186_50396);
if(temp__5735__auto___50414){
var seq__49186_50415__$1 = temp__5735__auto___50414;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__49186_50415__$1)){
var c__4609__auto___50417 = cljs.core.chunk_first.call(null,seq__49186_50415__$1);
var G__50418 = cljs.core.chunk_rest.call(null,seq__49186_50415__$1);
var G__50419 = c__4609__auto___50417;
var G__50420 = cljs.core.count.call(null,c__4609__auto___50417);
var G__50421 = (0);
seq__49186_50396 = G__50418;
chunk__49188_50397 = G__50419;
count__49189_50398 = G__50420;
i__49190_50399 = G__50421;
continue;
} else {
var child_50422 = cljs.core.first.call(null,seq__49186_50415__$1);
if(cljs.core.truth_(child_50422)){
node.appendChild(child_50422);


var G__50424 = cljs.core.next.call(null,seq__49186_50415__$1);
var G__50425 = null;
var G__50426 = (0);
var G__50427 = (0);
seq__49186_50396 = G__50424;
chunk__49188_50397 = G__50425;
count__49189_50398 = G__50426;
i__49190_50399 = G__50427;
continue;
} else {
var G__50429 = cljs.core.next.call(null,seq__49186_50415__$1);
var G__50430 = null;
var G__50431 = (0);
var G__50432 = (0);
seq__49186_50396 = G__50429;
chunk__49188_50397 = G__50430;
count__49189_50398 = G__50431;
i__49190_50399 = G__50432;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_50395);
}
}


var G__50438 = seq__49062_50386;
var G__50439 = chunk__49064_50387;
var G__50440 = count__49065_50388;
var G__50441 = (i__49066_50389 + (1));
seq__49062_50386 = G__50438;
chunk__49064_50387 = G__50439;
count__49065_50388 = G__50440;
i__49066_50389 = G__50441;
continue;
} else {
var G__50448 = seq__49062_50386;
var G__50449 = chunk__49064_50387;
var G__50450 = count__49065_50388;
var G__50451 = (i__49066_50389 + (1));
seq__49062_50386 = G__50448;
chunk__49064_50387 = G__50449;
count__49065_50388 = G__50450;
i__49066_50389 = G__50451;
continue;
}
} else {
var temp__5735__auto___50453 = cljs.core.seq.call(null,seq__49062_50386);
if(temp__5735__auto___50453){
var seq__49062_50455__$1 = temp__5735__auto___50453;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__49062_50455__$1)){
var c__4609__auto___50456 = cljs.core.chunk_first.call(null,seq__49062_50455__$1);
var G__50457 = cljs.core.chunk_rest.call(null,seq__49062_50455__$1);
var G__50458 = c__4609__auto___50456;
var G__50459 = cljs.core.count.call(null,c__4609__auto___50456);
var G__50460 = (0);
seq__49062_50386 = G__50457;
chunk__49064_50387 = G__50458;
count__49065_50388 = G__50459;
i__49066_50389 = G__50460;
continue;
} else {
var child_struct_50468 = cljs.core.first.call(null,seq__49062_50455__$1);
if((!((child_struct_50468 == null)))){
if(typeof child_struct_50468 === 'string'){
var text_50469 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_50469),child_struct_50468].join(''));
} else {
var children_50471 = shadow.dom.svg_node.call(null,child_struct_50468);
if(cljs.core.seq_QMARK_.call(null,children_50471)){
var seq__49238_50473 = cljs.core.seq.call(null,children_50471);
var chunk__49240_50474 = null;
var count__49241_50475 = (0);
var i__49242_50476 = (0);
while(true){
if((i__49242_50476 < count__49241_50475)){
var child_50477 = cljs.core._nth.call(null,chunk__49240_50474,i__49242_50476);
if(cljs.core.truth_(child_50477)){
node.appendChild(child_50477);


var G__50479 = seq__49238_50473;
var G__50480 = chunk__49240_50474;
var G__50481 = count__49241_50475;
var G__50482 = (i__49242_50476 + (1));
seq__49238_50473 = G__50479;
chunk__49240_50474 = G__50480;
count__49241_50475 = G__50481;
i__49242_50476 = G__50482;
continue;
} else {
var G__50483 = seq__49238_50473;
var G__50484 = chunk__49240_50474;
var G__50485 = count__49241_50475;
var G__50486 = (i__49242_50476 + (1));
seq__49238_50473 = G__50483;
chunk__49240_50474 = G__50484;
count__49241_50475 = G__50485;
i__49242_50476 = G__50486;
continue;
}
} else {
var temp__5735__auto___50488__$1 = cljs.core.seq.call(null,seq__49238_50473);
if(temp__5735__auto___50488__$1){
var seq__49238_50494__$1 = temp__5735__auto___50488__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__49238_50494__$1)){
var c__4609__auto___50495 = cljs.core.chunk_first.call(null,seq__49238_50494__$1);
var G__50496 = cljs.core.chunk_rest.call(null,seq__49238_50494__$1);
var G__50497 = c__4609__auto___50495;
var G__50498 = cljs.core.count.call(null,c__4609__auto___50495);
var G__50499 = (0);
seq__49238_50473 = G__50496;
chunk__49240_50474 = G__50497;
count__49241_50475 = G__50498;
i__49242_50476 = G__50499;
continue;
} else {
var child_50500 = cljs.core.first.call(null,seq__49238_50494__$1);
if(cljs.core.truth_(child_50500)){
node.appendChild(child_50500);


var G__50502 = cljs.core.next.call(null,seq__49238_50494__$1);
var G__50503 = null;
var G__50504 = (0);
var G__50505 = (0);
seq__49238_50473 = G__50502;
chunk__49240_50474 = G__50503;
count__49241_50475 = G__50504;
i__49242_50476 = G__50505;
continue;
} else {
var G__50506 = cljs.core.next.call(null,seq__49238_50494__$1);
var G__50507 = null;
var G__50508 = (0);
var G__50509 = (0);
seq__49238_50473 = G__50506;
chunk__49240_50474 = G__50507;
count__49241_50475 = G__50508;
i__49242_50476 = G__50509;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_50471);
}
}


var G__50511 = cljs.core.next.call(null,seq__49062_50455__$1);
var G__50512 = null;
var G__50513 = (0);
var G__50514 = (0);
seq__49062_50386 = G__50511;
chunk__49064_50387 = G__50512;
count__49065_50388 = G__50513;
i__49066_50389 = G__50514;
continue;
} else {
var G__50516 = cljs.core.next.call(null,seq__49062_50455__$1);
var G__50517 = null;
var G__50518 = (0);
var G__50519 = (0);
seq__49062_50386 = G__50516;
chunk__49064_50387 = G__50517;
count__49065_50388 = G__50518;
i__49066_50389 = G__50519;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.call(null,"strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node.call(null,this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.call(null,shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4795__auto__ = [];
var len__4789__auto___50530 = arguments.length;
var i__4790__auto___50531 = (0);
while(true){
if((i__4790__auto___50531 < len__4789__auto___50530)){
args__4795__auto__.push((arguments[i__4790__auto___50531]));

var G__50532 = (i__4790__auto___50531 + (1));
i__4790__auto___50531 = G__50532;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg.call(null,cljs.core.vec.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq49303){
var G__49305 = cljs.core.first.call(null,seq49303);
var seq49303__$1 = cljs.core.next.call(null,seq49303);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__49305,seq49303__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__49334 = arguments.length;
switch (G__49334) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.call(null,el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.call(null,el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer.call(null,(1));
var chan = cljs.core.async.chan.call(null,buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.call(null,chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler.call(null,el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_.call(null,chan);
} else {
return null;
}
});
shadow.dom.dom_listen.call(null,shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,event),event_fn);

if(cljs.core.truth_((function (){var and__4174__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4174__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4174__auto__;
}
})())){
var c__42559__auto___50552 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42560__auto__ = (function (){var switch__42266__auto__ = (function (state_49370){
var state_val_49371 = (state_49370[(1)]);
if((state_val_49371 === (1))){
var state_49370__$1 = state_49370;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49370__$1,(2),once_or_cleanup);
} else {
if((state_val_49371 === (2))){
var inst_49365 = (state_49370[(2)]);
var inst_49368 = shadow.dom.remove_event_handler.call(null,el,event,event_fn);
var state_49370__$1 = (function (){var statearr_49385 = state_49370;
(statearr_49385[(7)] = inst_49365);

return statearr_49385;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_49370__$1,inst_49368);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__42267__auto__ = null;
var shadow$dom$state_machine__42267__auto____0 = (function (){
var statearr_49390 = [null,null,null,null,null,null,null,null];
(statearr_49390[(0)] = shadow$dom$state_machine__42267__auto__);

(statearr_49390[(1)] = (1));

return statearr_49390;
});
var shadow$dom$state_machine__42267__auto____1 = (function (state_49370){
while(true){
var ret_value__42268__auto__ = (function (){try{while(true){
var result__42269__auto__ = switch__42266__auto__.call(null,state_49370);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42269__auto__;
}
break;
}
}catch (e49395){var ex__42270__auto__ = e49395;
var statearr_49396_50562 = state_49370;
(statearr_49396_50562[(2)] = ex__42270__auto__);


if(cljs.core.seq.call(null,(state_49370[(4)]))){
var statearr_49398_50566 = state_49370;
(statearr_49398_50566[(1)] = cljs.core.first.call(null,(state_49370[(4)])));

} else {
throw ex__42270__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50569 = state_49370;
state_49370 = G__50569;
continue;
} else {
return ret_value__42268__auto__;
}
break;
}
});
shadow$dom$state_machine__42267__auto__ = function(state_49370){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__42267__auto____0.call(this);
case 1:
return shadow$dom$state_machine__42267__auto____1.call(this,state_49370);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__42267__auto____0;
shadow$dom$state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__42267__auto____1;
return shadow$dom$state_machine__42267__auto__;
})()
})();
var state__42561__auto__ = (function (){var statearr_49403 = f__42560__auto__.call(null);
(statearr_49403[(6)] = c__42559__auto___50552);

return statearr_49403;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42561__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
