goog.provide('shadow.object');
goog.require('cljs.core');
goog.require('shadow.dom');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('clojure.data');
goog.require('cljs.core.async.impl.protocols');
goog.require('shadow.util');
shadow.object.console_friendly = shadow.util.console_friendly;
shadow.object.log = shadow.util.log;
shadow.object.debug = shadow.util.log;
shadow.object.info = shadow.util.log;
shadow.object.warn = shadow.util.log;
shadow.object.error = shadow.util.log;
shadow.object.obj_id = cljs.core.atom.call(null,(0));
shadow.object.next_id = (function shadow$object$next_id(){
return cljs.core.swap_BANG_.call(null,shadow.object.obj_id,cljs.core.inc);
});
shadow.object.object_defs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.behavior_fns = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.instances = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.instance_parent = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.instance_children = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.events = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.define_event = (function shadow$object$define_event(event_name,desc,args){
return cljs.core.swap_BANG_.call(null,shadow.object.events,cljs.core.assoc,event_name,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"id","id",-1388402092),event_name,new cljs.core.Keyword(null,"description","description",-1428560544),desc,new cljs.core.Keyword(null,"args","args",1315556576),args], null));
});
shadow.object.unmunge = (function shadow$object$unmunge(s){
return clojure.string.replace.call(null,clojure.string.replace.call(null,s,/_DOT_/,"."),/_/,"-");
});
shadow.object.define_event.call(null,new cljs.core.Keyword(null,"init","init",-1875481434),"object initialization",cljs.core.PersistentVector.EMPTY);
shadow.object.define_event.call(null,new cljs.core.Keyword(null,"destroy","destroy",-843660405),"object descruction",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"cause","cause",231901252),"cause of destruction, :parent means the parent was destroyed, :direct is default"], null)], null));
shadow.object.define_event.call(null,new cljs.core.Keyword("dom","init","dom/init",-1875647652),"called after the dom was created but has not entered the document yet",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dom","dom",-1236537922),"the dom that was created"], null)], null));
shadow.object.define_event.call(null,new cljs.core.Keyword("dom","entered","dom/entered",506699596),"should be called whenever a dom node is added to the document, since that\n   is not in control of this library its up to you to call this\n   use (so/notify-tree! your-obj :dom/entered) to notify the node and every child you created",cljs.core.PersistentVector.EMPTY);
shadow.object.define_event.call(null,new cljs.core.Keyword(null,"bind-children-update","bind-children-update",-1610690160),"need to rethink this",cljs.core.PersistentVector.EMPTY);

/**
 * @interface
 */
shadow.object.IObject = function(){};

shadow.object._id = (function shadow$object$_id(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_id$arity$1 == null)))))){
return this$.shadow$object$IObject$_id$arity$1(this$);
} else {
var x__4487__auto__ = (((this$ == null))?null:this$);
var m__4488__auto__ = (shadow.object._id[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,this$);
} else {
var m__4485__auto__ = (shadow.object._id["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-id",this$);
}
}
}
});

shadow.object._type = (function shadow$object$_type(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_type$arity$1 == null)))))){
return this$.shadow$object$IObject$_type$arity$1(this$);
} else {
var x__4487__auto__ = (((this$ == null))?null:this$);
var m__4488__auto__ = (shadow.object._type[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,this$);
} else {
var m__4485__auto__ = (shadow.object._type["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-type",this$);
}
}
}
});

shadow.object._data = (function shadow$object$_data(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_data$arity$1 == null)))))){
return this$.shadow$object$IObject$_data$arity$1(this$);
} else {
var x__4487__auto__ = (((this$ == null))?null:this$);
var m__4488__auto__ = (shadow.object._data[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,this$);
} else {
var m__4485__auto__ = (shadow.object._data["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-data",this$);
}
}
}
});

/**
 * update and notify watches
 */
shadow.object._update = (function shadow$object$_update(this$,update_fn){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_update$arity$2 == null)))))){
return this$.shadow$object$IObject$_update$arity$2(this$,update_fn);
} else {
var x__4487__auto__ = (((this$ == null))?null:this$);
var m__4488__auto__ = (shadow.object._update[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,this$,update_fn);
} else {
var m__4485__auto__ = (shadow.object._update["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,this$,update_fn);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-update",this$);
}
}
}
});

shadow.object._destroy_BANG_ = (function shadow$object$_destroy_BANG_(this$,cause){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_destroy_BANG_$arity$2 == null)))))){
return this$.shadow$object$IObject$_destroy_BANG_$arity$2(this$,cause);
} else {
var x__4487__auto__ = (((this$ == null))?null:this$);
var m__4488__auto__ = (shadow.object._destroy_BANG_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,this$,cause);
} else {
var m__4485__auto__ = (shadow.object._destroy_BANG_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,this$,cause);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-destroy!",this$);
}
}
}
});

shadow.object.get_type = (function shadow$object$get_type(this$){
return shadow.object._type.call(null,this$);
});
shadow.object.get_type_attr = (function shadow$object$get_type_attr(var_args){
var G__49561 = arguments.length;
switch (G__49561) {
case 2:
return shadow.object.get_type_attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.object.get_type_attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.get_type_attr.cljs$core$IFn$_invoke$arity$2 = (function (oref,key){
if((oref == null)){
return null;
} else {
var type_id = (((oref instanceof cljs.core.Keyword))?oref:shadow.object._type.call(null,oref));
return cljs.core.get_in.call(null,cljs.core.deref.call(null,shadow.object.object_defs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type_id,key], null));
}
}));

(shadow.object.get_type_attr.cljs$core$IFn$_invoke$arity$3 = (function (oref,key,default$){
if((oref == null)){
return default$;
} else {
var type_id = (((oref instanceof cljs.core.Keyword))?oref:shadow.object._type.call(null,oref));
return cljs.core.get_in.call(null,cljs.core.deref.call(null,shadow.object.object_defs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type_id,key], null),default$);
}
}));

(shadow.object.get_type_attr.cljs$lang$maxFixedArity = 3);

shadow.object.get_dom = (function shadow$object$get_dom(oref){
return new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(oref);
});
goog.exportSymbol('shadow.object.get_dom', shadow.object.get_dom);
shadow.object.get_by_id = (function shadow$object$get_by_id(id){
return cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instances),id);
});
goog.exportSymbol('shadow.object.get_by_id', shadow.object.get_by_id);
shadow.object.get_from_dom = (function shadow$object$get_from_dom(dom){
var oid = shadow.dom.data.call(null,dom,new cljs.core.Keyword(null,"oid","oid",-768692334));
if(cljs.core.truth_(oid)){
return shadow.object.get_by_id.call(null,parseInt(oid,(10)));
} else {
return null;
}
});
goog.exportSymbol('shadow.object.get_from_dom', shadow.object.get_from_dom);
shadow.object.is_object_QMARK_ = (function shadow$object$is_object_QMARK_(obj_or_dom){
var or__4185__auto__ = (((!((obj_or_dom == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === obj_or_dom.shadow$object$IObject$))))?true:(((!obj_or_dom.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj_or_dom):false)):cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj_or_dom));
if(or__4185__auto__){
return or__4185__auto__;
} else {
return shadow.object.get_from_dom.call(null,obj_or_dom);
}
});
shadow.object.equal_QMARK_ = (function shadow$object$equal_QMARK_(obj,obj_or_dom){
if((((!((obj == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === obj.shadow$object$IObject$))))?true:(((!obj.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj):false)):cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj))){
} else {
throw (new Error(["Assert failed: ","can only test objects","\n","(satisfies? IObject obj)"].join('')));
}

if((((!((obj_or_dom == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === obj_or_dom.shadow$object$IObject$))))?true:(((!obj_or_dom.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj_or_dom):false)):cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj_or_dom))){
return cljs.core._EQ_.call(null,shadow.object._id.call(null,obj),shadow.object._id.call(null,obj_or_dom));
} else {
return cljs.core._EQ_.call(null,shadow.object._id.call(null,obj),(function (){var temp__5735__auto__ = shadow.dom.data.call(null,obj_or_dom,new cljs.core.Keyword(null,"oid","oid",-768692334));
if(cljs.core.truth_(temp__5735__auto__)){
var oid = temp__5735__auto__;
return parseInt(oid,(10));
} else {
return null;
}
})());
}
});
shadow.object.get_parent = (function shadow$object$get_parent(oref){
var temp__5735__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instance_parent),shadow.object._id.call(null,oref));
if(cljs.core.truth_(temp__5735__auto__)){
var parent_id = temp__5735__auto__;
return cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instances),parent_id);
} else {
return null;
}
});
goog.exportSymbol('shadow.object.get_parent', shadow.object.get_parent);
shadow.object.get_parent_of_type = (function shadow$object$get_parent_of_type(oref,parent_type){
var parent = new cljs.core.Keyword(null,"parent","parent",-878878779).cljs$core$IFn$_invoke$arity$1(oref);
while(true){
if(cljs.core.truth_(parent)){
if(cljs.core._EQ_.call(null,shadow.object._type.call(null,parent),parent_type)){
return parent;
} else {
var G__51251 = new cljs.core.Keyword(null,"parent","parent",-878878779).cljs$core$IFn$_invoke$arity$1(parent);
parent = G__51251;
continue;
}
} else {
return null;
}
break;
}
});
goog.exportSymbol('shadow.object.get_parent_of_type', shadow.object.get_parent_of_type);
shadow.object.get_children = (function shadow$object$get_children(parent){
var parent_id = shadow.object._id.call(null,parent);
var child_ids = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instance_children),parent_id,cljs.core.PersistentVector.EMPTY);
var instances = cljs.core.deref.call(null,shadow.object.instances);
return cljs.core.vec.call(null,cljs.core.map.call(null,(function (p1__49663_SHARP_){
return cljs.core.get.call(null,instances,p1__49663_SHARP_);
}),child_ids));
});
goog.exportSymbol('shadow.object.get_children', shadow.object.get_children);
shadow.object.tree_seq = (function shadow$object$tree_seq(var_args){
var G__49679 = arguments.length;
switch (G__49679) {
case 1:
return shadow.object.tree_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.object.tree_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('shadow.object.tree_seq', shadow.object.tree_seq);

(shadow.object.tree_seq.cljs$core$IFn$_invoke$arity$1 = (function (root){
return shadow.object.tree_seq.call(null,root,(function (node){
return true;
}));
}));

(shadow.object.tree_seq.cljs$core$IFn$_invoke$arity$2 = (function (root,branch_QMARK_){
return cljs.core.tree_seq.call(null,branch_QMARK_,shadow.object.get_children,root);
}));

(shadow.object.tree_seq.cljs$lang$maxFixedArity = 2);

shadow.object.get_children_of_type = (function shadow$object$get_children_of_type(oref,type){
var type_kw = (((type instanceof cljs.core.Keyword))?type:shadow.object._type.call(null,type));
return cljs.core.filter.call(null,(function (p1__49689_SHARP_){
return cljs.core._EQ_.call(null,type_kw,shadow.object._type.call(null,p1__49689_SHARP_));
}),shadow.object.get_children.call(null,oref));
});
/**
 * basically (get-children (:parent this))
 */
shadow.object.get_siblings = (function shadow$object$get_siblings(p__49699){
var map__49702 = p__49699;
var map__49702__$1 = (((((!((map__49702 == null))))?(((((map__49702.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49702.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49702):map__49702);
var oref = map__49702__$1;
var parent = cljs.core.get.call(null,map__49702__$1,new cljs.core.Keyword(null,"parent","parent",-878878779));
if(cljs.core.truth_(parent)){
} else {
throw cljs.core.ex_info.call(null,"object has no parent, thus has no siblings",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"oref","oref",-1547494840),oref], null));
}

return shadow.object.get_children.call(null,parent);
});
/**
 * returns set of all siblings of a common type
 */
shadow.object.get_siblings_of_type = (function shadow$object$get_siblings_of_type(var_args){
var G__49738 = arguments.length;
switch (G__49738) {
case 1:
return shadow.object.get_siblings_of_type.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.object.get_siblings_of_type.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.get_siblings_of_type.cljs$core$IFn$_invoke$arity$1 = (function (oref){
return shadow.object.get_siblings_of_type.call(null,oref,oref);
}));

(shadow.object.get_siblings_of_type.cljs$core$IFn$_invoke$arity$2 = (function (oref,type){
var type_kw = (((type instanceof cljs.core.Keyword))?type:shadow.object._type.call(null,type));
return cljs.core.filter.call(null,(function (p1__49721_SHARP_){
return cljs.core._EQ_.call(null,type_kw,shadow.object._type.call(null,p1__49721_SHARP_));
}),shadow.object.get_siblings.call(null,oref));
}));

(shadow.object.get_siblings_of_type.cljs$lang$maxFixedArity = 2);

shadow.object.get_collection_item = (function shadow$object$get_collection_item(oref){
var item_key = new cljs.core.Keyword("shadow.object","coll-item-key","shadow.object/coll-item-key",1888444366).cljs$core$IFn$_invoke$arity$1(oref);
return cljs.core.get.call(null,oref,item_key);
});
/**
 * find the object that contains this dom node
 */
shadow.object.find_containing_object = (function shadow$object$find_containing_object(dom){
while(true){
var temp__5733__auto__ = shadow.object.get_from_dom.call(null,dom);
if(cljs.core.truth_(temp__5733__auto__)){
var obj = temp__5733__auto__;
return obj;
} else {
var temp__5735__auto__ = dom.parentElement;
if(cljs.core.truth_(temp__5735__auto__)){
var parent = temp__5735__auto__;
var G__51292 = parent;
dom = G__51292;
continue;
} else {
return null;
}
}
break;
}
});
shadow.object.notify_BANG_ = (function shadow$object$notify_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___51294 = arguments.length;
var i__4790__auto___51295 = (0);
while(true){
if((i__4790__auto___51295 < len__4789__auto___51294)){
args__4795__auto__.push((arguments[i__4790__auto___51295]));

var G__51296 = (i__4790__auto___51295 + (1));
i__4790__auto___51295 = G__51296;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((2) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((2)),(0),null)):null);
return shadow.object.notify_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4796__auto__);
});

(shadow.object.notify_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (oref,ev,args){
var temp__5735__auto__ = cljs.core.get_in.call(null,oref,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633),ev], null));
if(cljs.core.truth_(temp__5735__auto__)){
var reactions_to_trigger = temp__5735__auto__;
var seq__49841 = cljs.core.seq.call(null,reactions_to_trigger);
var chunk__49842 = null;
var count__49843 = (0);
var i__49844 = (0);
while(true){
if((i__49844 < count__49843)){
var rfn = cljs.core._nth.call(null,chunk__49842,i__49844);
cljs.core.apply.call(null,rfn,cljs.core.cons.call(null,oref,args));


var G__51304 = seq__49841;
var G__51305 = chunk__49842;
var G__51306 = count__49843;
var G__51307 = (i__49844 + (1));
seq__49841 = G__51304;
chunk__49842 = G__51305;
count__49843 = G__51306;
i__49844 = G__51307;
continue;
} else {
var temp__5735__auto____$1 = cljs.core.seq.call(null,seq__49841);
if(temp__5735__auto____$1){
var seq__49841__$1 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__49841__$1)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,seq__49841__$1);
var G__51308 = cljs.core.chunk_rest.call(null,seq__49841__$1);
var G__51309 = c__4609__auto__;
var G__51310 = cljs.core.count.call(null,c__4609__auto__);
var G__51311 = (0);
seq__49841 = G__51308;
chunk__49842 = G__51309;
count__49843 = G__51310;
i__49844 = G__51311;
continue;
} else {
var rfn = cljs.core.first.call(null,seq__49841__$1);
cljs.core.apply.call(null,rfn,cljs.core.cons.call(null,oref,args));


var G__51314 = cljs.core.next.call(null,seq__49841__$1);
var G__51315 = null;
var G__51316 = (0);
var G__51317 = (0);
seq__49841 = G__51314;
chunk__49842 = G__51315;
count__49843 = G__51316;
i__49844 = G__51317;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
}));

(shadow.object.notify_BANG_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(shadow.object.notify_BANG_.cljs$lang$applyTo = (function (seq49818){
var G__49819 = cljs.core.first.call(null,seq49818);
var seq49818__$1 = cljs.core.next.call(null,seq49818);
var G__49820 = cljs.core.first.call(null,seq49818__$1);
var seq49818__$2 = cljs.core.next.call(null,seq49818__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__49819,G__49820,seq49818__$2);
}));

shadow.object.do_notify_tree = (function shadow$object$do_notify_tree(current_obj,ev,notify_fn){
var seq__49884_51321 = cljs.core.seq.call(null,shadow.object.get_children.call(null,current_obj));
var chunk__49885_51322 = null;
var count__49886_51323 = (0);
var i__49887_51324 = (0);
while(true){
if((i__49887_51324 < count__49886_51323)){
var child_51326 = cljs.core._nth.call(null,chunk__49885_51322,i__49887_51324);
shadow.object.do_notify_tree.call(null,child_51326,ev,notify_fn);


var G__51330 = seq__49884_51321;
var G__51331 = chunk__49885_51322;
var G__51332 = count__49886_51323;
var G__51333 = (i__49887_51324 + (1));
seq__49884_51321 = G__51330;
chunk__49885_51322 = G__51331;
count__49886_51323 = G__51332;
i__49887_51324 = G__51333;
continue;
} else {
var temp__5735__auto___51334 = cljs.core.seq.call(null,seq__49884_51321);
if(temp__5735__auto___51334){
var seq__49884_51335__$1 = temp__5735__auto___51334;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__49884_51335__$1)){
var c__4609__auto___51337 = cljs.core.chunk_first.call(null,seq__49884_51335__$1);
var G__51339 = cljs.core.chunk_rest.call(null,seq__49884_51335__$1);
var G__51340 = c__4609__auto___51337;
var G__51341 = cljs.core.count.call(null,c__4609__auto___51337);
var G__51342 = (0);
seq__49884_51321 = G__51339;
chunk__49885_51322 = G__51340;
count__49886_51323 = G__51341;
i__49887_51324 = G__51342;
continue;
} else {
var child_51345 = cljs.core.first.call(null,seq__49884_51335__$1);
shadow.object.do_notify_tree.call(null,child_51345,ev,notify_fn);


var G__51348 = cljs.core.next.call(null,seq__49884_51335__$1);
var G__51349 = null;
var G__51350 = (0);
var G__51351 = (0);
seq__49884_51321 = G__51348;
chunk__49885_51322 = G__51349;
count__49886_51323 = G__51350;
i__49887_51324 = G__51351;
continue;
}
} else {
}
}
break;
}

return notify_fn.call(null,current_obj);
});
shadow.object.notify_tree_BANG_ = (function shadow$object$notify_tree_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___51357 = arguments.length;
var i__4790__auto___51358 = (0);
while(true){
if((i__4790__auto___51358 < len__4789__auto___51357)){
args__4795__auto__.push((arguments[i__4790__auto___51358]));

var G__51360 = (i__4790__auto___51358 + (1));
i__4790__auto___51358 = G__51360;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((2) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((2)),(0),null)):null);
return shadow.object.notify_tree_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4796__auto__);
});

(shadow.object.notify_tree_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (oref,ev,args){
var notify_fn = (function (obj){
return cljs.core.apply.call(null,shadow.object.notify_BANG_,obj,ev,args);
});
return shadow.object.do_notify_tree.call(null,oref,ev,notify_fn);
}));

(shadow.object.notify_tree_BANG_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(shadow.object.notify_tree_BANG_.cljs$lang$applyTo = (function (seq49912){
var G__49913 = cljs.core.first.call(null,seq49912);
var seq49912__$1 = cljs.core.next.call(null,seq49912);
var G__49914 = cljs.core.first.call(null,seq49912__$1);
var seq49912__$2 = cljs.core.next.call(null,seq49912__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__49913,G__49914,seq49912__$2);
}));

shadow.object.notify_down_BANG_ = shadow.object.notify_tree_BANG_;
shadow.object.notify_up_BANG_ = (function shadow$object$notify_up_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___51368 = arguments.length;
var i__4790__auto___51369 = (0);
while(true){
if((i__4790__auto___51369 < len__4789__auto___51368)){
args__4795__auto__.push((arguments[i__4790__auto___51369]));

var G__51371 = (i__4790__auto___51369 + (1));
i__4790__auto___51369 = G__51371;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((2) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((2)),(0),null)):null);
return shadow.object.notify_up_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4796__auto__);
});

(shadow.object.notify_up_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (oref,ev,args){
var current = shadow.object.get_parent.call(null,oref);
while(true){
if(cljs.core.truth_(current)){
cljs.core.apply.call(null,shadow.object.notify_BANG_,current,ev,args);

var G__51376 = shadow.object.get_parent.call(null,current);
current = G__51376;
continue;
} else {
return null;
}
break;
}
}));

(shadow.object.notify_up_BANG_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(shadow.object.notify_up_BANG_.cljs$lang$applyTo = (function (seq49956){
var G__49957 = cljs.core.first.call(null,seq49956);
var seq49956__$1 = cljs.core.next.call(null,seq49956);
var G__49960 = cljs.core.first.call(null,seq49956__$1);
var seq49956__$2 = cljs.core.next.call(null,seq49956__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__49957,G__49960,seq49956__$2);
}));

shadow.object.update_BANG_ = (function shadow$object$update_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___51380 = arguments.length;
var i__4790__auto___51381 = (0);
while(true){
if((i__4790__auto___51381 < len__4789__auto___51380)){
args__4795__auto__.push((arguments[i__4790__auto___51381]));

var G__51383 = (i__4790__auto___51381 + (1));
i__4790__auto___51381 = G__51383;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((2) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((2)),(0),null)):null);
return shadow.object.update_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4796__auto__);
});

(shadow.object.update_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (oref,update_fn,args){
if(cljs.core.fn_QMARK_.call(null,update_fn)){
} else {
throw ["update! expects a fn as second arg, not ",cljs.core.pr_str.call(null,update_fn)].join('');
}

var id = shadow.object._id.call(null,oref);
var data = shadow.object._data.call(null,oref);
var work_fn = (function (data__$1){
return cljs.core.apply.call(null,update_fn,data__$1,args);
});
return shadow.object._update.call(null,oref,work_fn);
}));

(shadow.object.update_BANG_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(shadow.object.update_BANG_.cljs$lang$applyTo = (function (seq49997){
var G__49998 = cljs.core.first.call(null,seq49997);
var seq49997__$1 = cljs.core.next.call(null,seq49997);
var G__49999 = cljs.core.first.call(null,seq49997__$1);
var seq49997__$2 = cljs.core.next.call(null,seq49997__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__49998,G__49999,seq49997__$2);
}));

shadow.object.return_value = (function shadow$object$return_value(oref,return_value){
return shadow.object.update_BANG_.call(null,oref,cljs.core.assoc,new cljs.core.Keyword("shadow.object","return-value","shadow.object/return-value",1397593360),return_value);
});
shadow.object.set_parent_BANG_ = (function shadow$object$set_parent_BANG_(child,parent){
var child_id = shadow.object._id.call(null,child);
var parent_id = shadow.object._id.call(null,parent);
cljs.core.swap_BANG_.call(null,shadow.object.instance_parent,cljs.core.assoc,child_id,parent_id);

cljs.core.swap_BANG_.call(null,shadow.object.instance_children,(function (x){
var current = cljs.core.get.call(null,x,parent_id,cljs.core.PersistentHashSet.EMPTY);
return cljs.core.assoc.call(null,x,parent_id,cljs.core.conj.call(null,current,child_id));
}));

return true;
});
shadow.object.dom_destroy = (function shadow$object$dom_destroy(this$,cause){
if(cljs.core._EQ_.call(null,cause,new cljs.core.Keyword(null,"parent","parent",-878878779))){
return shadow.dom.remove.call(null,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(this$));
} else {
var temp__5733__auto__ = shadow.object.get_type_attr.call(null,this$,new cljs.core.Keyword("dom","remove","dom/remove",-131527420));
if(cljs.core.truth_(temp__5733__auto__)){
var custom_remove = temp__5733__auto__;
return custom_remove.call(null,this$,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(this$));
} else {
return shadow.dom.remove.call(null,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(this$));
}
}
});
shadow.object.destroy_BANG_ = (function shadow$object$destroy_BANG_(var_args){
var G__50041 = arguments.length;
switch (G__50041) {
case 1:
return shadow.object.destroy_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.object.destroy_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.destroy_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (oref){
return shadow.object.destroy_BANG_.call(null,oref,new cljs.core.Keyword(null,"direct","direct",-1775717856));
}));

(shadow.object.destroy_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (oref,cause){
return shadow.object._destroy_BANG_.call(null,oref,cause);
}));

(shadow.object.destroy_BANG_.cljs$lang$maxFixedArity = 2);

shadow.object.bind_dom_events = (function shadow$object$bind_dom_events(oref,dom,dom_events){
if((cljs.core.rem.call(null,cljs.core.count.call(null,dom_events),(2)) === (0))){
} else {
throw cljs.core.ex_info.call(null,"object defined invalid event",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"object-type","object-type",-1889869015),shadow.object._type.call(null,oref),new cljs.core.Keyword("dom","events","dom/events",1793437527),dom_events], null));
}

var seq__50050 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),dom_events));
var chunk__50051 = null;
var count__50052 = (0);
var i__50053 = (0);
while(true){
if((i__50053 < count__50052)){
var vec__50076 = cljs.core._nth.call(null,chunk__50051,i__50053);
var ev = cljs.core.nth.call(null,vec__50076,(0),null);
var handler = cljs.core.nth.call(null,vec__50076,(1),null);
var ev_def = vec__50076;
if((handler == null)){
throw ["ev with nil handler ",cljs.core.pr_str.call(null,ev)].join('');
} else {
}

var handler_51420__$1 = (((handler instanceof cljs.core.Keyword))?((function (seq__50050,chunk__50051,count__50052,i__50053,vec__50076,ev,handler,ev_def){
return (function (this$,e,el){
return shadow.object.notify_BANG_.call(null,this$,handler,e,el);
});})(seq__50050,chunk__50051,count__50052,i__50053,vec__50076,ev,handler,ev_def))
:handler);
shadow.dom.on.call(null,dom,ev,((function (seq__50050,chunk__50051,count__50052,i__50053,handler_51420__$1,vec__50076,ev,handler,ev_def){
return (function shadow$object$bind_dom_events_$_dom_event_handler(e,el){
if(cljs.core._EQ_.call(null,"A",el.tagName)){
shadow.dom.ev_stop.call(null,e);
} else {
}

return handler_51420__$1.call(null,oref,e,el);
});})(seq__50050,chunk__50051,count__50052,i__50053,handler_51420__$1,vec__50076,ev,handler,ev_def))
);


var G__51423 = seq__50050;
var G__51424 = chunk__50051;
var G__51425 = count__50052;
var G__51426 = (i__50053 + (1));
seq__50050 = G__51423;
chunk__50051 = G__51424;
count__50052 = G__51425;
i__50053 = G__51426;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__50050);
if(temp__5735__auto__){
var seq__50050__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__50050__$1)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,seq__50050__$1);
var G__51430 = cljs.core.chunk_rest.call(null,seq__50050__$1);
var G__51431 = c__4609__auto__;
var G__51432 = cljs.core.count.call(null,c__4609__auto__);
var G__51433 = (0);
seq__50050 = G__51430;
chunk__50051 = G__51431;
count__50052 = G__51432;
i__50053 = G__51433;
continue;
} else {
var vec__50082 = cljs.core.first.call(null,seq__50050__$1);
var ev = cljs.core.nth.call(null,vec__50082,(0),null);
var handler = cljs.core.nth.call(null,vec__50082,(1),null);
var ev_def = vec__50082;
if((handler == null)){
throw ["ev with nil handler ",cljs.core.pr_str.call(null,ev)].join('');
} else {
}

var handler_51435__$1 = (((handler instanceof cljs.core.Keyword))?((function (seq__50050,chunk__50051,count__50052,i__50053,vec__50082,ev,handler,ev_def,seq__50050__$1,temp__5735__auto__){
return (function (this$,e,el){
return shadow.object.notify_BANG_.call(null,this$,handler,e,el);
});})(seq__50050,chunk__50051,count__50052,i__50053,vec__50082,ev,handler,ev_def,seq__50050__$1,temp__5735__auto__))
:handler);
shadow.dom.on.call(null,dom,ev,((function (seq__50050,chunk__50051,count__50052,i__50053,handler_51435__$1,vec__50082,ev,handler,ev_def,seq__50050__$1,temp__5735__auto__){
return (function shadow$object$bind_dom_events_$_dom_event_handler(e,el){
if(cljs.core._EQ_.call(null,"A",el.tagName)){
shadow.dom.ev_stop.call(null,e);
} else {
}

return handler_51435__$1.call(null,oref,e,el);
});})(seq__50050,chunk__50051,count__50052,i__50053,handler_51435__$1,vec__50082,ev,handler,ev_def,seq__50050__$1,temp__5735__auto__))
);


var G__51438 = cljs.core.next.call(null,seq__50050__$1);
var G__51439 = null;
var G__51440 = (0);
var G__51441 = (0);
seq__50050 = G__51438;
chunk__50051 = G__51439;
count__50052 = G__51440;
i__50053 = G__51441;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.object.reaction_merge = (function shadow$object$reaction_merge(result,p__50132){
var vec__50139 = p__50132;
var event = cljs.core.nth.call(null,vec__50139,(0),null);
var handler = cljs.core.nth.call(null,vec__50139,(1),null);
if(cljs.core.truth_((function (){var and__4174__auto__ = event;
if(cljs.core.truth_(and__4174__auto__)){
return handler;
} else {
return and__4174__auto__;
}
})())){
} else {
throw cljs.core.ex_info.call(null,"invalid reaction",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),event,new cljs.core.Keyword(null,"handler","handler",-195596612),handler], null));
}

var current = cljs.core.get.call(null,result,event,cljs.core.List.EMPTY);
return cljs.core.assoc.call(null,result,event,cljs.core.conj.call(null,current,handler));
});
shadow.object.merge_reactions = (function shadow$object$merge_reactions(result,behavior){
if(cljs.core.sequential_QMARK_.call(null,behavior)){
} else {
throw cljs.core.ex_info.call(null,"behaviors must be vectors",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"behavior","behavior",1202392908),behavior], null));
}

if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,behavior))){
} else {
throw cljs.core.ex_info.call(null,"invalid behavior",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"behavior","behavior",1202392908),behavior], null));
}

return cljs.core.reduce.call(null,shadow.object.reaction_merge,result,cljs.core.reverse.call(null,cljs.core.partition.call(null,(2),behavior)));
});
shadow.object.merge_behaviors = (function shadow$object$merge_behaviors(result,behavior){
if(cljs.core.sequential_QMARK_.call(null,behavior)){
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633)], null),shadow.object.merge_reactions,behavior);
} else {
if(cljs.core.map_QMARK_.call(null,behavior)){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633)], null),shadow.object.merge_reactions,new cljs.core.Keyword(null,"on","on",173873944).cljs$core$IFn$_invoke$arity$2(behavior,cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"watch","watch",380988277)], null),(function (watches){
return cljs.core.concat.call(null,watches,new cljs.core.Keyword(null,"watch","watch",380988277).cljs$core$IFn$_invoke$arity$2(behavior,cljs.core.PersistentVector.EMPTY));
})),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("dom","events","dom/events",1793437527)], null),(function (default$){
return cljs.core.vec.call(null,cljs.core.concat.call(null,default$,new cljs.core.Keyword("dom","events","dom/events",1793437527).cljs$core$IFn$_invoke$arity$2(behavior,cljs.core.PersistentVector.EMPTY)));
}));
} else {
throw cljs.core.ex_info.call(null,"behavior not understood",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"behavior","behavior",1202392908),behavior], null));

}
}
});
shadow.object.define = (function shadow$object$define(var_args){
var args__4795__auto__ = [];
var len__4789__auto___51457 = arguments.length;
var i__4790__auto___51458 = (0);
while(true){
if((i__4790__auto___51458 < len__4789__auto___51457)){
args__4795__auto__.push((arguments[i__4790__auto___51458]));

var G__51460 = (i__4790__auto___51458 + (1));
i__4790__auto___51458 = G__51460;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return shadow.object.define.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(shadow.object.define.cljs$core$IFn$_invoke$arity$variadic = (function (id,args){
if((id instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.call(null,"object id needs to be a keyword",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"args","args",1315556576),args], null));
}

if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,args))){
} else {
throw ["invalid object definition ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," args: ",cljs.core.pr_str.call(null,args)].join('');
}

if(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,shadow.object.object_defs),id)){
console.warn(["object already defined ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)].join(''));
} else {
}

try{var odef = cljs.core.apply.call(null,cljs.core.hash_map,args);
var reactions = shadow.object.merge_reactions.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"on","on",173873944).cljs$core$IFn$_invoke$arity$2(odef,cljs.core.PersistentVector.EMPTY));
var odef__$1 = cljs.core.assoc.call(null,odef,new cljs.core.Keyword("shadow.object","id","shadow.object/id",-647954841),id,new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633),reactions);
var odef__$2 = cljs.core.reduce.call(null,shadow.object.merge_behaviors,odef__$1,cljs.core.reverse.call(null,new cljs.core.Keyword(null,"behaviors","behaviors",120724909).cljs$core$IFn$_invoke$arity$2(odef__$1,cljs.core.PersistentVector.EMPTY)));
cljs.core.swap_BANG_.call(null,shadow.object.object_defs,cljs.core.assoc,id,odef__$2);

return odef__$2;
}catch (e50295){if((e50295 instanceof Object)){
var e = e50295;
throw cljs.core.ex_info.call(null,"failed to define object",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"args","args",1315556576),args], null));
} else {
throw e50295;

}
}}));

(shadow.object.define.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.object.define.cljs$lang$applyTo = (function (seq50261){
var G__50262 = cljs.core.first.call(null,seq50261);
var seq50261__$1 = cljs.core.next.call(null,seq50261);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__50262,seq50261__$1);
}));

shadow.object.merge_defaults = (function shadow$object$merge_defaults(data,type){
var defaults = cljs.core.get_in.call(null,cljs.core.deref.call(null,shadow.object.object_defs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type,new cljs.core.Keyword(null,"defaults","defaults",976027214)], null));
if((defaults == null)){
return data;
} else {
if(cljs.core.map_QMARK_.call(null,defaults)){
return cljs.core.merge.call(null,defaults,data);
} else {
if(cljs.core.fn_QMARK_.call(null,defaults)){
return cljs.core.merge.call(null,defaults.call(null),data);
} else {
throw cljs.core.ex_info.call(null,"invalid object defaults",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"defaults","defaults",976027214),defaults,new cljs.core.Keyword(null,"type","type",1174270348),type], null));

}
}
}
});
shadow.object.make_dom = (function shadow$object$make_dom(var_args){
var G__50326 = arguments.length;
switch (G__50326) {
case 3:
return shadow.object.make_dom.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.object.make_dom.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.make_dom.cljs$core$IFn$_invoke$arity$3 = (function (oref,dom_key,events_key){
return shadow.object.make_dom.call(null,oref,dom_key,events_key,null);
}));

(shadow.object.make_dom.cljs$core$IFn$_invoke$arity$4 = (function (oref,dom_key,events_key,value){
var dom_fn = (((dom_key instanceof cljs.core.Keyword))?shadow.object.get_type_attr.call(null,oref,dom_key):dom_key);
var events = (((events_key instanceof cljs.core.Keyword))?shadow.object.get_type_attr.call(null,oref,events_key,cljs.core.PersistentVector.EMPTY):events_key);
var dom = shadow.dom.build.call(null,dom_fn.call(null,oref,value));
shadow.object.bind_dom_events.call(null,oref,dom,events);

return dom;
}));

(shadow.object.make_dom.cljs$lang$maxFixedArity = 4);

shadow.object.alive_QMARK_ = (function shadow$object$alive_QMARK_(obj){
return cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,shadow.object.instances),shadow.object._id.call(null,obj));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.object.Watch = (function (key,handler,__meta,__extmap,__hash){
this.key = key;
this.handler = handler;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.object.Watch.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4439__auto__,k__4440__auto__){
var self__ = this;
var this__4439__auto____$1 = this;
return this__4439__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4440__auto__,null);
}));

(shadow.object.Watch.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4441__auto__,k50340,else__4442__auto__){
var self__ = this;
var this__4441__auto____$1 = this;
var G__50371 = k50340;
var G__50371__$1 = (((G__50371 instanceof cljs.core.Keyword))?G__50371.fqn:null);
switch (G__50371__$1) {
case "key":
return self__.key;

break;
case "handler":
return self__.handler;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k50340,else__4442__auto__);

}
}));

(shadow.object.Watch.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4458__auto__,f__4459__auto__,init__4460__auto__){
var self__ = this;
var this__4458__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4461__auto__,p__50381){
var vec__50382 = p__50381;
var k__4462__auto__ = cljs.core.nth.call(null,vec__50382,(0),null);
var v__4463__auto__ = cljs.core.nth.call(null,vec__50382,(1),null);
return f__4459__auto__.call(null,ret__4461__auto__,k__4462__auto__,v__4463__auto__);
}),init__4460__auto__,this__4458__auto____$1);
}));

(shadow.object.Watch.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4453__auto__,writer__4454__auto__,opts__4455__auto__){
var self__ = this;
var this__4453__auto____$1 = this;
var pr_pair__4456__auto__ = (function (keyval__4457__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4454__auto__,cljs.core.pr_writer,""," ","",opts__4455__auto__,keyval__4457__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4454__auto__,pr_pair__4456__auto__,"#shadow.object.Watch{",", ","}",opts__4455__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"key","key",-1516042587),self__.key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"handler","handler",-195596612),self__.handler],null))], null),self__.__extmap));
}));

(shadow.object.Watch.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__50339){
var self__ = this;
var G__50339__$1 = this;
return (new cljs.core.RecordIter((0),G__50339__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"handler","handler",-195596612)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(shadow.object.Watch.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4437__auto__){
var self__ = this;
var this__4437__auto____$1 = this;
return self__.__meta;
}));

(shadow.object.Watch.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4434__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return (new shadow.object.Watch(self__.key,self__.handler,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.object.Watch.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4443__auto__){
var self__ = this;
var this__4443__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
}));

(shadow.object.Watch.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4435__auto__){
var self__ = this;
var this__4435__auto____$1 = this;
var h__4297__auto__ = self__.__hash;
if((!((h__4297__auto__ == null)))){
return h__4297__auto__;
} else {
var h__4297__auto____$1 = (function (coll__4436__auto__){
return (-17677043 ^ cljs.core.hash_unordered_coll.call(null,coll__4436__auto__));
}).call(null,this__4435__auto____$1);
(self__.__hash = h__4297__auto____$1);

return h__4297__auto____$1;
}
}));

(shadow.object.Watch.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this50341,other50343){
var self__ = this;
var this50341__$1 = this;
return (((!((other50343 == null)))) && ((this50341__$1.constructor === other50343.constructor)) && (cljs.core._EQ_.call(null,this50341__$1.key,other50343.key)) && (cljs.core._EQ_.call(null,this50341__$1.handler,other50343.handler)) && (cljs.core._EQ_.call(null,this50341__$1.__extmap,other50343.__extmap)));
}));

(shadow.object.Watch.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4448__auto__,k__4449__auto__){
var self__ = this;
var this__4448__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"handler","handler",-195596612),null], null), null),k__4449__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4448__auto____$1),self__.__meta),k__4449__auto__);
} else {
return (new shadow.object.Watch(self__.key,self__.handler,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4449__auto__)),null));
}
}));

(shadow.object.Watch.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4446__auto__,k__4447__auto__,G__50339){
var self__ = this;
var this__4446__auto____$1 = this;
var pred__50490 = cljs.core.keyword_identical_QMARK_;
var expr__50491 = k__4447__auto__;
if(cljs.core.truth_(pred__50490.call(null,new cljs.core.Keyword(null,"key","key",-1516042587),expr__50491))){
return (new shadow.object.Watch(G__50339,self__.handler,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__50490.call(null,new cljs.core.Keyword(null,"handler","handler",-195596612),expr__50491))){
return (new shadow.object.Watch(self__.key,G__50339,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.object.Watch(self__.key,self__.handler,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4447__auto__,G__50339),null));
}
}
}));

(shadow.object.Watch.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4451__auto__){
var self__ = this;
var this__4451__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"key","key",-1516042587),self__.key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"handler","handler",-195596612),self__.handler,null))], null),self__.__extmap));
}));

(shadow.object.Watch.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4438__auto__,G__50339){
var self__ = this;
var this__4438__auto____$1 = this;
return (new shadow.object.Watch(self__.key,self__.handler,G__50339,self__.__extmap,self__.__hash));
}));

(shadow.object.Watch.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4444__auto__,entry__4445__auto__){
var self__ = this;
var this__4444__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4445__auto__)){
return this__4444__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4445__auto__,(0)),cljs.core._nth.call(null,entry__4445__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4444__auto____$1,entry__4445__auto__);
}
}));

(shadow.object.Watch.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"handler","handler",1444934915,null)], null);
}));

(shadow.object.Watch.cljs$lang$type = true);

(shadow.object.Watch.cljs$lang$ctorPrSeq = (function (this__4482__auto__){
return (new cljs.core.List(null,"shadow.object/Watch",null,(1),null));
}));

(shadow.object.Watch.cljs$lang$ctorPrWriter = (function (this__4482__auto__,writer__4483__auto__){
return cljs.core._write.call(null,writer__4483__auto__,"shadow.object/Watch");
}));

/**
 * Positional factory function for shadow.object/Watch.
 */
shadow.object.__GT_Watch = (function shadow$object$__GT_Watch(key,handler){
return (new shadow.object.Watch(key,handler,null,null,null));
});

/**
 * Factory function for shadow.object/Watch, taking a map of keywords to field values.
 */
shadow.object.map__GT_Watch = (function shadow$object$map__GT_Watch(G__50352){
var extmap__4478__auto__ = (function (){var G__50534 = cljs.core.dissoc.call(null,G__50352,new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"handler","handler",-195596612));
if(cljs.core.record_QMARK_.call(null,G__50352)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__50534);
} else {
return G__50534;
}
})();
return (new shadow.object.Watch(new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(G__50352),new cljs.core.Keyword(null,"handler","handler",-195596612).cljs$core$IFn$_invoke$arity$1(G__50352),null,cljs.core.not_empty.call(null,extmap__4478__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IWatchable}
 * @implements {cljs.core.IEquiv}
 * @implements {shadow.object.IObject}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {shadow.dom.SVGElement}
 * @implements {cljs.core.ILookup}
*/
shadow.object.ObjectRef = (function (id,type,data,watches,result_chan){
this.id = id;
this.type = type;
this.data = data;
this.watches = watches;
this.result_chan = result_chan;
this.cljs$lang$protocol_mask$partition0$ = 2149613824;
this.cljs$lang$protocol_mask$partition1$ = 2;
});
(shadow.object.ObjectRef.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.object.ObjectRef.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (this$,handler){
var self__ = this;
var this$__$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.result_chan,handler);
}));

(shadow.object.ObjectRef.prototype.toString = (function (){
var self__ = this;
var this$ = this;
return cljs.core.pr_str.call(null,this$);
}));

(shadow.object.ObjectRef.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,k){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"parent","parent",-878878779),k)){
return shadow.object.get_parent.call(null,this$__$1);
} else {
return cljs.core.get.call(null,self__.data,k);
}
}));

(shadow.object.ObjectRef.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this$,k,d){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"parent","parent",-878878779),k)){
return shadow.object.get_parent.call(null,this$__$1);
} else {
return cljs.core.get.call(null,self__.data,k,d);
}
}));

(shadow.object.ObjectRef.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this$,writer,opts){
var self__ = this;
var this$__$1 = this;
return cljs.core._write.call(null,writer,["#<ObjectRef {:id ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),", :type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.type),"}>"].join(''));
}));

(shadow.object.ObjectRef.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.object.ObjectRef.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(self__.data);
}));

(shadow.object.ObjectRef.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return (((other instanceof shadow.object.ObjectRef)) && (cljs.core._EQ_.call(null,shadow.object._id.call(null,this$__$1),shadow.object._id.call(null,other))));
}));

(shadow.object.ObjectRef.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.object.ObjectRef.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(self__.data);
}));

(shadow.object.ObjectRef.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
throw (new Error("who be calling?"));
}));

(shadow.object.ObjectRef.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var self__ = this;
var this$__$1 = this;
return (self__.watches = cljs.core.conj.call(null,self__.watches,(new shadow.object.Watch(key,f,null,null,null))));
}));

(shadow.object.ObjectRef.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return (self__.watches = cljs.core.remove.call(null,(function (p1__50540_SHARP_){
return cljs.core._EQ_.call(null,key,new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(p1__50540_SHARP_));
}),self__.watches));
}));

(shadow.object.ObjectRef.prototype.shadow$object$IObject$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.object.ObjectRef.prototype.shadow$object$IObject$_id$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.id;
}));

(shadow.object.ObjectRef.prototype.shadow$object$IObject$_type$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.type;
}));

(shadow.object.ObjectRef.prototype.shadow$object$IObject$_data$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.data;
}));

(shadow.object.ObjectRef.prototype.shadow$object$IObject$_update$arity$2 = (function (this$,update_fn){
var self__ = this;
var this$__$1 = this;
var old = self__.data;
var new$ = update_fn.call(null,self__.data);
(self__.data = new$);

var seq__50594 = cljs.core.seq.call(null,self__.watches);
var chunk__50595 = null;
var count__50596 = (0);
var i__50597 = (0);
while(true){
if((i__50597 < count__50596)){
var map__50620 = cljs.core._nth.call(null,chunk__50595,i__50597);
var map__50620__$1 = (((((!((map__50620 == null))))?(((((map__50620.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50620.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50620):map__50620);
var watch = map__50620__$1;
var key = cljs.core.get.call(null,map__50620__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var handler = cljs.core.get.call(null,map__50620__$1,new cljs.core.Keyword(null,"handler","handler",-195596612));
if(shadow.object.alive_QMARK_.call(null,this$__$1)){
handler.call(null,key,this$__$1,old,new$);
} else {
}


var G__51592 = seq__50594;
var G__51593 = chunk__50595;
var G__51594 = count__50596;
var G__51595 = (i__50597 + (1));
seq__50594 = G__51592;
chunk__50595 = G__51593;
count__50596 = G__51594;
i__50597 = G__51595;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__50594);
if(temp__5735__auto__){
var seq__50594__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__50594__$1)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,seq__50594__$1);
var G__51597 = cljs.core.chunk_rest.call(null,seq__50594__$1);
var G__51598 = c__4609__auto__;
var G__51599 = cljs.core.count.call(null,c__4609__auto__);
var G__51600 = (0);
seq__50594 = G__51597;
chunk__50595 = G__51598;
count__50596 = G__51599;
i__50597 = G__51600;
continue;
} else {
var map__50625 = cljs.core.first.call(null,seq__50594__$1);
var map__50625__$1 = (((((!((map__50625 == null))))?(((((map__50625.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50625.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50625):map__50625);
var watch = map__50625__$1;
var key = cljs.core.get.call(null,map__50625__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var handler = cljs.core.get.call(null,map__50625__$1,new cljs.core.Keyword(null,"handler","handler",-195596612));
if(shadow.object.alive_QMARK_.call(null,this$__$1)){
handler.call(null,key,this$__$1,old,new$);
} else {
}


var G__51601 = cljs.core.next.call(null,seq__50594__$1);
var G__51602 = null;
var G__51603 = (0);
var G__51604 = (0);
seq__50594 = G__51601;
chunk__50595 = G__51602;
count__50596 = G__51603;
i__50597 = G__51604;
continue;
}
} else {
return null;
}
}
break;
}
}));

(shadow.object.ObjectRef.prototype.shadow$object$IObject$_destroy_BANG_$arity$2 = (function (this$,cause){
var self__ = this;
var this$__$1 = this;
var parent_id = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instance_parent),self__.id);
var seq__50640_51608 = cljs.core.seq.call(null,shadow.object.get_children.call(null,this$__$1));
var chunk__50641_51609 = null;
var count__50642_51611 = (0);
var i__50643_51612 = (0);
while(true){
if((i__50643_51612 < count__50642_51611)){
var child_51614 = cljs.core._nth.call(null,chunk__50641_51609,i__50643_51612);
shadow.object._destroy_BANG_.call(null,child_51614,new cljs.core.Keyword(null,"parent","parent",-878878779));


var G__51616 = seq__50640_51608;
var G__51617 = chunk__50641_51609;
var G__51618 = count__50642_51611;
var G__51619 = (i__50643_51612 + (1));
seq__50640_51608 = G__51616;
chunk__50641_51609 = G__51617;
count__50642_51611 = G__51618;
i__50643_51612 = G__51619;
continue;
} else {
var temp__5735__auto___51622 = cljs.core.seq.call(null,seq__50640_51608);
if(temp__5735__auto___51622){
var seq__50640_51627__$1 = temp__5735__auto___51622;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__50640_51627__$1)){
var c__4609__auto___51629 = cljs.core.chunk_first.call(null,seq__50640_51627__$1);
var G__51630 = cljs.core.chunk_rest.call(null,seq__50640_51627__$1);
var G__51631 = c__4609__auto___51629;
var G__51632 = cljs.core.count.call(null,c__4609__auto___51629);
var G__51633 = (0);
seq__50640_51608 = G__51630;
chunk__50641_51609 = G__51631;
count__50642_51611 = G__51632;
i__50643_51612 = G__51633;
continue;
} else {
var child_51644 = cljs.core.first.call(null,seq__50640_51627__$1);
shadow.object._destroy_BANG_.call(null,child_51644,new cljs.core.Keyword(null,"parent","parent",-878878779));


var G__51645 = cljs.core.next.call(null,seq__50640_51627__$1);
var G__51646 = null;
var G__51647 = (0);
var G__51648 = (0);
seq__50640_51608 = G__51645;
chunk__50641_51609 = G__51646;
count__50642_51611 = G__51647;
i__50643_51612 = G__51648;
continue;
}
} else {
}
}
break;
}

shadow.object.notify_BANG_.call(null,this$__$1,new cljs.core.Keyword(null,"destroy","destroy",-843660405),cause);

shadow.object.dom_destroy.call(null,this$__$1,cause);

var return_value_51656 = new cljs.core.Keyword("shadow.object","return-value","shadow.object/return-value",1397593360).cljs$core$IFn$_invoke$arity$1(this$__$1);
if((return_value_51656 == null)){
} else {
cljs.core.async.put_BANG_.call(null,self__.result_chan,return_value_51656);
}

cljs.core.async.close_BANG_.call(null,self__.result_chan);

cljs.core.swap_BANG_.call(null,shadow.object.instances,cljs.core.dissoc,self__.id);

cljs.core.swap_BANG_.call(null,shadow.object.instance_parent,cljs.core.dissoc,self__.id);

if(cljs.core.truth_(parent_id)){
return cljs.core.swap_BANG_.call(null,shadow.object.instance_children,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [parent_id], null),cljs.core.disj,self__.id);
} else {
return null;
}
}));

(shadow.object.ObjectRef.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.data;
}));

(shadow.object.ObjectRef.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"type","type",-1480165421,null),cljs.core.with_meta(new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"watches","watches",1367433992,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"result-chan","result-chan",3070926,null)], null);
}));

(shadow.object.ObjectRef.cljs$lang$type = true);

(shadow.object.ObjectRef.cljs$lang$ctorStr = "shadow.object/ObjectRef");

(shadow.object.ObjectRef.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"shadow.object/ObjectRef");
}));

/**
 * Positional factory function for shadow.object/ObjectRef.
 */
shadow.object.__GT_ObjectRef = (function shadow$object$__GT_ObjectRef(id,type,data,watches,result_chan){
return (new shadow.object.ObjectRef(id,type,data,watches,result_chan));
});

shadow.object.add_reaction_BANG_ = (function shadow$object$add_reaction_BANG_(var_args){
var G__50662 = arguments.length;
switch (G__50662) {
case 3:
return shadow.object.add_reaction_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return shadow.object.add_reaction_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.add_reaction_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (oref,ev,handler_fn){
return shadow.object.add_reaction_BANG_.call(null,oref,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ev,handler_fn], null));
}));

(shadow.object.add_reaction_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (oref,list){
return shadow.object.update_BANG_.call(null,oref,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633)], null),shadow.object.merge_reactions,list);
}));

(shadow.object.add_reaction_BANG_.cljs$lang$maxFixedArity = 3);

shadow.object.bind_change = (function shadow$object$bind_change(var_args){
var G__50699 = arguments.length;
switch (G__50699) {
case 3:
return shadow.object.bind_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.object.bind_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.bind_change.cljs$core$IFn$_invoke$arity$3 = (function (oref,attr,callback){
return shadow.object.bind_change.call(null,oref,attr,callback,cljs.core.gensym.call(null,"bind-change"));
}));

(shadow.object.bind_change.cljs$core$IFn$_invoke$arity$4 = (function (oref,attr,callback,watch_key){
if((((!((oref == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === oref.shadow$object$IObject$))))?true:(((!oref.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,oref):false)):cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,oref))){
} else {
throw cljs.core.ex_info.call(null,"binding currently only supports shadow objects, other atoms might leak, may add later",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"oref","oref",-1547494840),oref,new cljs.core.Keyword(null,"attr","attr",-604132353),attr], null));
}

var attr__$1 = ((cljs.core.sequential_QMARK_.call(null,attr))?attr:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attr], null));
return cljs.core.add_watch.call(null,oref,watch_key,(function shadow$object$bind_change_watch(_,___$1,old,new$){
var ov = cljs.core.get_in.call(null,old,attr__$1);
var nv = cljs.core.get_in.call(null,new$,attr__$1);
if(cljs.core._EQ_.call(null,ov,nv)){
return null;
} else {
return callback.call(null,ov,nv);
}
}));
}));

(shadow.object.bind_change.cljs$lang$maxFixedArity = 4);

shadow.object.dom_enter = (function shadow$object$dom_enter(parent,child){
shadow.dom.append.call(null,parent,child);

if(cljs.core.truth_(shadow.dom.contains_QMARK_.call(null,parent))){
return shadow.object.notify_tree_BANG_.call(null,child,new cljs.core.Keyword("dom","entered","dom/entered",506699596));
} else {
return null;
}
});
shadow.object.create = (function shadow$object$create(var_args){
var args__4795__auto__ = [];
var len__4789__auto___51774 = arguments.length;
var i__4790__auto___51778 = (0);
while(true){
if((i__4790__auto___51778 < len__4789__auto___51774)){
args__4795__auto__.push((arguments[i__4790__auto___51778]));

var G__51779 = (i__4790__auto___51778 + (1));
i__4790__auto___51778 = G__51779;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((2) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((2)),(0),null)):null);
return shadow.object.create.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4796__auto__);
});

(shadow.object.create.cljs$core$IFn$_invoke$arity$variadic = (function (type,args,node_children){
if(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,shadow.object.object_defs),type)){
} else {
throw cljs.core.ex_info.call(null,["cannot create unknown child type: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"args","args",1315556576),args], null));
}

if(cljs.core.map_QMARK_.call(null,args)){
} else {
throw cljs.core.ex_info.call(null,"so/create second arg must be a map",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"args","args",1315556576),args], null));
}

var oid = shadow.object.next_id.call(null);
var parent = new cljs.core.Keyword(null,"parent","parent",-878878779).cljs$core$IFn$_invoke$arity$1(args);
var result_chan = cljs.core.async.chan.call(null,(1));
var odef = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.object_defs),type);
var obj = cljs.core.dissoc.call(null,shadow.object.merge_defaults.call(null,cljs.core.assoc.call(null,args,new cljs.core.Keyword("shadow.object","object-id","shadow.object/object-id",-685993804),oid,new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633),cljs.core.get.call(null,odef,new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633),cljs.core.PersistentArrayMap.EMPTY)),type),new cljs.core.Keyword(null,"parent","parent",-878878779),new cljs.core.Keyword(null,"dom","dom",-1236537922));
var oref = (new shadow.object.ObjectRef(oid,type,obj,cljs.core.PersistentVector.EMPTY,result_chan));
cljs.core.swap_BANG_.call(null,shadow.object.instances,cljs.core.assoc,oid,oref);

if(cljs.core.truth_(parent)){
shadow.object.set_parent_BANG_.call(null,oref,parent);
} else {
}

shadow.object.notify_BANG_.call(null,oref,new cljs.core.Keyword(null,"init","init",-1875481434));

var dom_events_51853 = new cljs.core.Keyword("dom","events","dom/events",1793437527).cljs$core$IFn$_invoke$arity$2(odef,cljs.core.PersistentVector.EMPTY);
var temp__5733__auto___51857 = new cljs.core.Keyword(null,"dom","dom",-1236537922).cljs$core$IFn$_invoke$arity$1(args);
if(cljs.core.truth_(temp__5733__auto___51857)){
var dom_51867 = temp__5733__auto___51857;
shadow.dom.set_data.call(null,dom_51867,new cljs.core.Keyword(null,"oid","oid",-768692334),oid);

shadow.object.bind_dom_events.call(null,oref,dom_51867,dom_events_51853);

shadow.object.update_BANG_.call(null,oref,cljs.core.assoc,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311),dom_51867);

shadow.object.notify_BANG_.call(null,oref,new cljs.core.Keyword("dom","init","dom/init",-1875647652),dom_51867);
} else {
var temp__5735__auto___51878 = new cljs.core.Keyword(null,"dom","dom",-1236537922).cljs$core$IFn$_invoke$arity$1(odef);
if(cljs.core.truth_(temp__5735__auto___51878)){
var dom_fn_51884 = temp__5735__auto___51878;
var dom_51886 = shadow.dom.build.call(null,dom_fn_51884.call(null,oref,node_children));
shadow.dom.set_data.call(null,dom_51886,new cljs.core.Keyword(null,"oid","oid",-768692334),oid);

shadow.object.update_BANG_.call(null,oref,cljs.core.assoc,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311),dom_51886);

shadow.object.bind_dom_events.call(null,oref,dom_51886,dom_events_51853);

shadow.object.notify_BANG_.call(null,oref,new cljs.core.Keyword("dom","init","dom/init",-1875647652),dom_51886);
} else {
}
}

var temp__5735__auto___51909 = new cljs.core.Keyword(null,"watch","watch",380988277).cljs$core$IFn$_invoke$arity$1(odef);
if(cljs.core.truth_(temp__5735__auto___51909)){
var watches_51910 = temp__5735__auto___51909;
var seq__50847_51911 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),watches_51910));
var chunk__50848_51912 = null;
var count__50849_51913 = (0);
var i__50850_51914 = (0);
while(true){
if((i__50850_51914 < count__50849_51913)){
var vec__50862_51917 = cljs.core._nth.call(null,chunk__50848_51912,i__50850_51914);
var attr_51918 = cljs.core.nth.call(null,vec__50862_51917,(0),null);
var handler_51919 = cljs.core.nth.call(null,vec__50862_51917,(1),null);
shadow.object.bind_change.call(null,oref,attr_51918,((function (seq__50847_51911,chunk__50848_51912,count__50849_51913,i__50850_51914,vec__50862_51917,attr_51918,handler_51919,watches_51910,temp__5735__auto___51909,oid,parent,result_chan,odef,obj,oref){
return (function (old,new$){
return handler_51919.call(null,oref,old,new$);
});})(seq__50847_51911,chunk__50848_51912,count__50849_51913,i__50850_51914,vec__50862_51917,attr_51918,handler_51919,watches_51910,temp__5735__auto___51909,oid,parent,result_chan,odef,obj,oref))
);


var G__51920 = seq__50847_51911;
var G__51921 = chunk__50848_51912;
var G__51922 = count__50849_51913;
var G__51923 = (i__50850_51914 + (1));
seq__50847_51911 = G__51920;
chunk__50848_51912 = G__51921;
count__50849_51913 = G__51922;
i__50850_51914 = G__51923;
continue;
} else {
var temp__5735__auto___51924__$1 = cljs.core.seq.call(null,seq__50847_51911);
if(temp__5735__auto___51924__$1){
var seq__50847_51925__$1 = temp__5735__auto___51924__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__50847_51925__$1)){
var c__4609__auto___51927 = cljs.core.chunk_first.call(null,seq__50847_51925__$1);
var G__51928 = cljs.core.chunk_rest.call(null,seq__50847_51925__$1);
var G__51929 = c__4609__auto___51927;
var G__51930 = cljs.core.count.call(null,c__4609__auto___51927);
var G__51931 = (0);
seq__50847_51911 = G__51928;
chunk__50848_51912 = G__51929;
count__50849_51913 = G__51930;
i__50850_51914 = G__51931;
continue;
} else {
var vec__50869_51932 = cljs.core.first.call(null,seq__50847_51925__$1);
var attr_51933 = cljs.core.nth.call(null,vec__50869_51932,(0),null);
var handler_51934 = cljs.core.nth.call(null,vec__50869_51932,(1),null);
shadow.object.bind_change.call(null,oref,attr_51933,((function (seq__50847_51911,chunk__50848_51912,count__50849_51913,i__50850_51914,vec__50869_51932,attr_51933,handler_51934,seq__50847_51925__$1,temp__5735__auto___51924__$1,watches_51910,temp__5735__auto___51909,oid,parent,result_chan,odef,obj,oref){
return (function (old,new$){
return handler_51934.call(null,oref,old,new$);
});})(seq__50847_51911,chunk__50848_51912,count__50849_51913,i__50850_51914,vec__50869_51932,attr_51933,handler_51934,seq__50847_51925__$1,temp__5735__auto___51924__$1,watches_51910,temp__5735__auto___51909,oid,parent,result_chan,odef,obj,oref))
);


var G__51936 = cljs.core.next.call(null,seq__50847_51925__$1);
var G__51937 = null;
var G__51938 = (0);
var G__51939 = (0);
seq__50847_51911 = G__51936;
chunk__50848_51912 = G__51937;
count__50849_51913 = G__51938;
i__50850_51914 = G__51939;
continue;
}
} else {
}
}
break;
}
} else {
}

return oref;
}));

(shadow.object.create.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(shadow.object.create.cljs$lang$applyTo = (function (seq50815){
var G__50819 = cljs.core.first.call(null,seq50815);
var seq50815__$1 = cljs.core.next.call(null,seq50815);
var G__50820 = cljs.core.first.call(null,seq50815__$1);
var seq50815__$2 = cljs.core.next.call(null,seq50815__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__50819,G__50820,seq50815__$2);
}));

/**
 * [oref attr node-gen] produces a node via (node-gen new-value)
 * watches obj for changes and replaces the generated node on change (node-gen defaults to str)
 * 
 *   only use if the node has no attached behavior like clicks, use bind with an extra object for those
 */
shadow.object.bind_simple = (function shadow$object$bind_simple(var_args){
var G__50878 = arguments.length;
switch (G__50878) {
case 2:
return shadow.object.bind_simple.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.object.bind_simple.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.bind_simple.cljs$core$IFn$_invoke$arity$2 = (function (oref,attr){
return shadow.object.bind_simple.call(null,oref,attr,cljs.core.str);
}));

(shadow.object.bind_simple.cljs$core$IFn$_invoke$arity$3 = (function (oref,attr,node_gen){
var attr__$1 = ((cljs.core.sequential_QMARK_.call(null,attr))?attr:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attr], null));
var node_get = (function (p1__50875_SHARP_){
return shadow.dom.build.call(null,node_gen.call(null,p1__50875_SHARP_));
});
var node = cljs.core.atom.call(null,node_get.call(null,cljs.core.get_in.call(null,oref,attr__$1)));
var bind_key = cljs.core.gensym.call(null,"bind");
shadow.object.bind_change.call(null,oref,attr__$1,(function (old,new$){
var new_node = node_get.call(null,new$);
var current_node = cljs.core.deref.call(null,node);
shadow.dom.replace_node.call(null,current_node,new_node);

return cljs.core.reset_BANG_.call(null,node,new_node);
}));

return cljs.core.deref.call(null,node);
}));

(shadow.object.bind_simple.cljs$lang$maxFixedArity = 3);

/**
 * bind the given attribute a child item
 *   the item will be recreated whenever the value changes (old one will be destroyed)
 */
shadow.object.bind = (function shadow$object$bind(oref,attr,item_type,item_key,item_attrs){
var attr__$1 = ((cljs.core.sequential_QMARK_.call(null,attr))?attr:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attr], null));
var curval = cljs.core.get_in.call(null,oref,attr__$1);
var make_child_fn = (function (value){
return shadow.object.create.call(null,item_type,cljs.core.merge.call(null,item_attrs,cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.Keyword(null,"parent","parent",-878878779),oref,item_key,value])));
});
var child = cljs.core.atom.call(null,make_child_fn.call(null,curval));
shadow.object.bind_change.call(null,oref,attr__$1,(function (old,new$){
var new_child = make_child_fn.call(null,new$);
var current_node = cljs.core.deref.call(null,child);
shadow.dom.replace_node.call(null,current_node,new_child);

shadow.object.destroy_BANG_.call(null,cljs.core.deref.call(null,child));

cljs.core.reset_BANG_.call(null,child,new_child);

return shadow.object.notify_down_BANG_.call(null,new_child,new cljs.core.Keyword("dom","entered","dom/entered",506699596));
}));

return cljs.core.deref.call(null,child);
});
shadow.object.coll_destroy_children = (function shadow$object$coll_destroy_children(children,c,diff){
var seq__50896_51953 = cljs.core.seq.call(null,cljs.core.subvec.call(null,children,(c + diff),c));
var chunk__50897_51954 = null;
var count__50898_51955 = (0);
var i__50899_51956 = (0);
while(true){
if((i__50899_51956 < count__50898_51955)){
var obj_51958 = cljs.core._nth.call(null,chunk__50897_51954,i__50899_51956);
var obj_51959__$1 = shadow.object.get_from_dom.call(null,obj_51958);
shadow.object.destroy_BANG_.call(null,obj_51959__$1);


var G__51960 = seq__50896_51953;
var G__51961 = chunk__50897_51954;
var G__51962 = count__50898_51955;
var G__51963 = (i__50899_51956 + (1));
seq__50896_51953 = G__51960;
chunk__50897_51954 = G__51961;
count__50898_51955 = G__51962;
i__50899_51956 = G__51963;
continue;
} else {
var temp__5735__auto___51965 = cljs.core.seq.call(null,seq__50896_51953);
if(temp__5735__auto___51965){
var seq__50896_51966__$1 = temp__5735__auto___51965;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__50896_51966__$1)){
var c__4609__auto___51968 = cljs.core.chunk_first.call(null,seq__50896_51966__$1);
var G__51970 = cljs.core.chunk_rest.call(null,seq__50896_51966__$1);
var G__51971 = c__4609__auto___51968;
var G__51972 = cljs.core.count.call(null,c__4609__auto___51968);
var G__51973 = (0);
seq__50896_51953 = G__51970;
chunk__50897_51954 = G__51971;
count__50898_51955 = G__51972;
i__50899_51956 = G__51973;
continue;
} else {
var obj_51975 = cljs.core.first.call(null,seq__50896_51966__$1);
var obj_51976__$1 = shadow.object.get_from_dom.call(null,obj_51975);
shadow.object.destroy_BANG_.call(null,obj_51976__$1);


var G__51978 = cljs.core.next.call(null,seq__50896_51966__$1);
var G__51979 = null;
var G__51980 = (0);
var G__51981 = (0);
seq__50896_51953 = G__51978;
chunk__50897_51954 = G__51979;
count__50898_51955 = G__51980;
i__50899_51956 = G__51981;
continue;
}
} else {
}
}
break;
}

return cljs.core.subvec.call(null,children,(0),(c + diff));
});
shadow.object.bind_children = (function shadow$object$bind_children(var_args){
var G__50913 = arguments.length;
switch (G__50913) {
case 5:
return shadow.object.bind_children.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return shadow.object.bind_children.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.bind_children.cljs$core$IFn$_invoke$arity$5 = (function (node,parent,attr,item_type,item_key){
return shadow.object.bind_children.call(null,node,parent,attr,item_type,item_key,(function (p1__50908_SHARP_){
return cljs.core.map_indexed.call(null,cljs.core.vector,p1__50908_SHARP_);
}));
}));

(shadow.object.bind_children.cljs$core$IFn$_invoke$arity$6 = (function (node,parent,attr,item_type,item_key,coll_transform){
var attr__$1 = ((cljs.core.sequential_QMARK_.call(null,attr))?attr:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attr], null));
var update_children = cljs.core.atom.call(null,true);
var coll_dom = shadow.dom.build.call(null,node);
var make_item_fn = (function (p__50921){
var vec__50922 = p__50921;
var key = cljs.core.nth.call(null,vec__50922,(0),null);
var val = cljs.core.nth.call(null,vec__50922,(1),null);
var obj = shadow.object.create.call(null,item_type,cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.Keyword(null,"parent","parent",-878878779),parent,new cljs.core.Keyword("shadow.object","coll-path","shadow.object/coll-path",1583850048),attr__$1,new cljs.core.Keyword("shadow.object","coll-key","shadow.object/coll-key",827543616),key,new cljs.core.Keyword("shadow.object","coll-item-key","shadow.object/coll-item-key",1888444366),item_key,item_key,val]));
shadow.object.bind_change.call(null,obj,item_key,(function (old,new$){
var parent_key = cljs.core.conj.call(null,attr__$1,new cljs.core.Keyword("shadow.object","coll-key","shadow.object/coll-key",827543616).cljs$core$IFn$_invoke$arity$1(obj));
shadow.object.log.call(null,"direct child update",parent,obj,key,parent_key,new$);

cljs.core.reset_BANG_.call(null,update_children,false);

shadow.object.update_BANG_.call(null,parent,cljs.core.assoc_in,parent_key,new$);

return cljs.core.reset_BANG_.call(null,update_children,true);
}));

return obj;
});
var seq__50931_51991 = cljs.core.seq.call(null,coll_transform.call(null,cljs.core.get_in.call(null,parent,attr__$1)));
var chunk__50932_51992 = null;
var count__50933_51993 = (0);
var i__50934_51994 = (0);
while(true){
if((i__50934_51994 < count__50933_51993)){
var item_51997 = cljs.core._nth.call(null,chunk__50932_51992,i__50934_51994);
shadow.object.dom_enter.call(null,coll_dom,make_item_fn.call(null,item_51997));


var G__51998 = seq__50931_51991;
var G__51999 = chunk__50932_51992;
var G__52000 = count__50933_51993;
var G__52001 = (i__50934_51994 + (1));
seq__50931_51991 = G__51998;
chunk__50932_51992 = G__51999;
count__50933_51993 = G__52000;
i__50934_51994 = G__52001;
continue;
} else {
var temp__5735__auto___52005 = cljs.core.seq.call(null,seq__50931_51991);
if(temp__5735__auto___52005){
var seq__50931_52006__$1 = temp__5735__auto___52005;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__50931_52006__$1)){
var c__4609__auto___52007 = cljs.core.chunk_first.call(null,seq__50931_52006__$1);
var G__52008 = cljs.core.chunk_rest.call(null,seq__50931_52006__$1);
var G__52009 = c__4609__auto___52007;
var G__52010 = cljs.core.count.call(null,c__4609__auto___52007);
var G__52011 = (0);
seq__50931_51991 = G__52008;
chunk__50932_51992 = G__52009;
count__50933_51993 = G__52010;
i__50934_51994 = G__52011;
continue;
} else {
var item_52012 = cljs.core.first.call(null,seq__50931_52006__$1);
shadow.object.dom_enter.call(null,coll_dom,make_item_fn.call(null,item_52012));


var G__52014 = cljs.core.next.call(null,seq__50931_52006__$1);
var G__52015 = null;
var G__52016 = (0);
var G__52017 = (0);
seq__50931_51991 = G__52014;
chunk__50932_51992 = G__52015;
count__50933_51993 = G__52016;
i__50934_51994 = G__52017;
continue;
}
} else {
}
}
break;
}

shadow.object.bind_change.call(null,parent,attr__$1,(function shadow$object$bind_children_watch(old,new$){
if(cljs.core.truth_(cljs.core.deref.call(null,update_children))){
var children = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,shadow.dom.children.call(null,coll_dom));
var new_coll = cljs.core.vec.call(null,coll_transform.call(null,new$));
var count_children = cljs.core.count.call(null,children);
var count_new = cljs.core.count.call(null,new$);
var diff = (count_new - count_children);
var children__$1 = (((diff < (0)))?shadow.object.coll_destroy_children.call(null,children,count_children,diff):children);
var count_children__$1 = (function (){var x__4276__auto__ = count_new;
var y__4277__auto__ = count_children;
return ((x__4276__auto__ < y__4277__auto__) ? x__4276__auto__ : y__4277__auto__);
})();
var n__4666__auto___52022 = count_children__$1;
var idx_52023 = (0);
while(true){
if((idx_52023 < n__4666__auto___52022)){
var cn_52024 = cljs.core.nth.call(null,children__$1,idx_52023);
var cc_52025 = shadow.object.get_from_dom.call(null,cn_52024);
var ckey_52026 = new cljs.core.Keyword("shadow.object","coll-key","shadow.object/coll-key",827543616).cljs$core$IFn$_invoke$arity$1(cc_52025);
var cval_52027 = cljs.core.get.call(null,cc_52025,item_key);
var vec__50951_52028 = cljs.core.nth.call(null,new_coll,idx_52023);
var nkey_52029 = cljs.core.nth.call(null,vec__50951_52028,(0),null);
var nval_52030 = cljs.core.nth.call(null,vec__50951_52028,(1),null);
if(((cljs.core._EQ_.call(null,ckey_52026,nkey_52029)) && (cljs.core._EQ_.call(null,cval_52027,nval_52030)))){
} else {
var new_obj_52034 = make_item_fn.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [nkey_52029,nval_52030], null));
shadow.dom.replace_node.call(null,cn_52024,new_obj_52034);

shadow.object.destroy_BANG_.call(null,cc_52025);

shadow.object.notify_tree_BANG_.call(null,new_obj_52034,new cljs.core.Keyword("dom","entered","dom/entered",506699596));
}

var G__52036 = (idx_52023 + (1));
idx_52023 = G__52036;
continue;
} else {
}
break;
}

if((diff > (0))){
var seq__50959_52038 = cljs.core.seq.call(null,cljs.core.subvec.call(null,new_coll,count_children__$1,count_new));
var chunk__50960_52039 = null;
var count__50961_52040 = (0);
var i__50962_52041 = (0);
while(true){
if((i__50962_52041 < count__50961_52040)){
var item_52042 = cljs.core._nth.call(null,chunk__50960_52039,i__50962_52041);
shadow.object.dom_enter.call(null,coll_dom,make_item_fn.call(null,item_52042));


var G__52044 = seq__50959_52038;
var G__52045 = chunk__50960_52039;
var G__52046 = count__50961_52040;
var G__52047 = (i__50962_52041 + (1));
seq__50959_52038 = G__52044;
chunk__50960_52039 = G__52045;
count__50961_52040 = G__52046;
i__50962_52041 = G__52047;
continue;
} else {
var temp__5735__auto___52049 = cljs.core.seq.call(null,seq__50959_52038);
if(temp__5735__auto___52049){
var seq__50959_52050__$1 = temp__5735__auto___52049;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__50959_52050__$1)){
var c__4609__auto___52051 = cljs.core.chunk_first.call(null,seq__50959_52050__$1);
var G__52052 = cljs.core.chunk_rest.call(null,seq__50959_52050__$1);
var G__52053 = c__4609__auto___52051;
var G__52054 = cljs.core.count.call(null,c__4609__auto___52051);
var G__52055 = (0);
seq__50959_52038 = G__52052;
chunk__50960_52039 = G__52053;
count__50961_52040 = G__52054;
i__50962_52041 = G__52055;
continue;
} else {
var item_52057 = cljs.core.first.call(null,seq__50959_52050__$1);
shadow.object.dom_enter.call(null,coll_dom,make_item_fn.call(null,item_52057));


var G__52059 = cljs.core.next.call(null,seq__50959_52050__$1);
var G__52060 = null;
var G__52061 = (0);
var G__52062 = (0);
seq__50959_52038 = G__52059;
chunk__50960_52039 = G__52060;
count__50961_52040 = G__52061;
i__50962_52041 = G__52062;
continue;
}
} else {
}
}
break;
}
} else {
}

return shadow.object.notify_BANG_.call(null,parent,new cljs.core.Keyword(null,"bind-children-update","bind-children-update",-1610690160));
} else {
return null;
}
}));

return coll_dom;
}));

(shadow.object.bind_children.cljs$lang$maxFixedArity = 6);

shadow.object.remove_in_parent_BANG_ = (function shadow$object$remove_in_parent_BANG_(oref){
var parent = shadow.object.get_parent.call(null,oref);
var key = new cljs.core.Keyword("shadow.object","coll-key","shadow.object/coll-key",827543616).cljs$core$IFn$_invoke$arity$1(oref);
var value = cljs.core.get.call(null,oref,new cljs.core.Keyword("shadow.object","coll-item-key","shadow.object/coll-item-key",1888444366).cljs$core$IFn$_invoke$arity$1(oref));
var path = new cljs.core.Keyword("shadow.object","coll-path","shadow.object/coll-path",1583850048).cljs$core$IFn$_invoke$arity$1(oref);
if(cljs.core.truth_((function (){var and__4174__auto__ = key;
if(cljs.core.truth_(and__4174__auto__)){
return path;
} else {
return and__4174__auto__;
}
})())){
} else {
throw cljs.core.ex_info.call(null,"remove-in-parent! should only be called from items created via so/bind-children",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"oref","oref",-1547494840),oref], null));
}

var coll = cljs.core.get_in.call(null,parent,path);
var new_coll = shadow.util.remove_item_from_coll.call(null,coll,key,value);
return shadow.object.notify_BANG_.call(null,parent,new cljs.core.Keyword("bind","update","bind/update",1048601733),path,new_coll);
});
shadow.object.inspect_BANG_ = (function shadow$object$inspect_BANG_(oref){
return shadow.object.info.call(null,"inspect!",shadow.object._id.call(null,oref),cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.object._type.call(null,oref)),cljs.core.clj__GT_js.call(null,cljs.core.deref.call(null,shadow.object._data.call(null,oref))));
});
shadow.object.dump_BANG_ = (function shadow$object$dump_BANG_(){
shadow.object.info.call(null,"--------------- LIVE OBJECTS ------------");

var seq__50982_52071 = cljs.core.seq.call(null,cljs.core.seq.call(null,cljs.core.deref.call(null,shadow.object.instances)));
var chunk__50983_52072 = null;
var count__50984_52073 = (0);
var i__50985_52074 = (0);
while(true){
if((i__50985_52074 < count__50984_52073)){
var vec__50993_52076 = cljs.core._nth.call(null,chunk__50983_52072,i__50985_52074);
var id_52077 = cljs.core.nth.call(null,vec__50993_52076,(0),null);
var oref_52078 = cljs.core.nth.call(null,vec__50993_52076,(1),null);
shadow.object.info.call(null,"dump",id_52077,cljs.core.pr_str.call(null,shadow.object._type.call(null,oref_52078)),cljs.core.deref.call(null,shadow.object._data.call(null,oref_52078)));


var G__52082 = seq__50982_52071;
var G__52083 = chunk__50983_52072;
var G__52084 = count__50984_52073;
var G__52085 = (i__50985_52074 + (1));
seq__50982_52071 = G__52082;
chunk__50983_52072 = G__52083;
count__50984_52073 = G__52084;
i__50985_52074 = G__52085;
continue;
} else {
var temp__5735__auto___52087 = cljs.core.seq.call(null,seq__50982_52071);
if(temp__5735__auto___52087){
var seq__50982_52088__$1 = temp__5735__auto___52087;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__50982_52088__$1)){
var c__4609__auto___52089 = cljs.core.chunk_first.call(null,seq__50982_52088__$1);
var G__52091 = cljs.core.chunk_rest.call(null,seq__50982_52088__$1);
var G__52092 = c__4609__auto___52089;
var G__52093 = cljs.core.count.call(null,c__4609__auto___52089);
var G__52094 = (0);
seq__50982_52071 = G__52091;
chunk__50983_52072 = G__52092;
count__50984_52073 = G__52093;
i__50985_52074 = G__52094;
continue;
} else {
var vec__50999_52095 = cljs.core.first.call(null,seq__50982_52088__$1);
var id_52096 = cljs.core.nth.call(null,vec__50999_52095,(0),null);
var oref_52097 = cljs.core.nth.call(null,vec__50999_52095,(1),null);
shadow.object.info.call(null,"dump",id_52096,cljs.core.pr_str.call(null,shadow.object._type.call(null,oref_52097)),cljs.core.deref.call(null,shadow.object._data.call(null,oref_52097)));


var G__52098 = cljs.core.next.call(null,seq__50982_52088__$1);
var G__52099 = null;
var G__52100 = (0);
var G__52101 = (0);
seq__50982_52071 = G__52098;
chunk__50983_52072 = G__52099;
count__50984_52073 = G__52100;
i__50985_52074 = G__52101;
continue;
}
} else {
}
}
break;
}

return shadow.object.info.call(null,"--------------- //LIVE OBJECTS ------------");
});
goog.exportSymbol('shadow.object.dump_BANG_', shadow.object.dump_BANG_);

//# sourceMappingURL=shadow.object.js.map
