goog.provide('shadow.test');
goog.require('cljs.core');
goog.require('cljs.test');
goog.require('shadow.test.env');
/**
 * Like test-vars, but returns a block for further composition and
 *   later execution.
 */
shadow.test.run_tests_block = (function shadow$test$run_tests_block(env,namespaces){
var summary = cljs.core.volatile_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"test","test",577538877),(0),new cljs.core.Keyword(null,"pass","pass",1574159993),(0),new cljs.core.Keyword(null,"fail","fail",1706214930),(0),new cljs.core.Keyword(null,"error","error",-978969032),(0),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"summary","summary",380847952)], null));
var merge_counters = (function (){
return cljs.core._vreset_BANG_.call(null,summary,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core._PLUS_).call(null,cljs.core._deref.call(null,summary),new cljs.core.Keyword(null,"report-counters","report-counters",-1702609242).cljs$core$IFn$_invoke$arity$1(cljs.test.get_current_env.call(null))));
});
return cljs.core.conj.call(null,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.test.set_env_BANG_.call(null,env);
})], null),cljs.core.mapcat.call(null,(function (ns){
return cljs.core.conj.call(null,shadow.test.test_ns_block.call(null,env,ns),merge_counters);
}),namespaces)),(function (){
cljs.test.report.call(null,cljs.core.deref.call(null,summary));

cljs.test.report.call(null,cljs.core.assoc.call(null,cljs.core.deref.call(null,summary),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-run-tests","end-run-tests",267300563)));

return cljs.test.clear_env_BANG_.call(null);
}));
});
shadow.test.run_tests = (function shadow$test$run_tests(var_args){
var G__45501 = arguments.length;
switch (G__45501) {
case 0:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_tests.call(null,cljs.test.empty_env.call(null));
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_tests.call(null,env,shadow.test.env.get_test_namespaces.call(null));
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,namespaces){
return cljs.test.run_block.call(null,shadow.test.run_tests_block.call(null,env,namespaces));
}));

(shadow.test.run_tests.cljs$lang$maxFixedArity = 2);

/**
 * Runs all tests in all namespaces; prints results.
 *   Optional argument is a regular expression; only namespaces with
 *   names matching the regular expression (with re-matches) will be
 *   tested.
 */
shadow.test.run_all_tests = (function shadow$test$run_all_tests(var_args){
var G__45531 = arguments.length;
switch (G__45531) {
case 0:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_all_tests.call(null,cljs.test.empty_env.call(null),null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_all_tests.call(null,env,null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,re){
return shadow.test.run_tests.call(null,env,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.filter.call(null,(function (p1__45522_SHARP_){
var or__4185__auto__ = (re == null);
if(or__4185__auto__){
return or__4185__auto__;
} else {
return cljs.core.re_matches.call(null,re,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__45522_SHARP_));
}
}),shadow.test.env.get_test_namespaces.call(null))));
}));

(shadow.test.run_all_tests.cljs$lang$maxFixedArity = 2);

shadow.test.test_all_vars_block = (function shadow$test$test_all_vars_block(ns){
var env = cljs.test.get_current_env.call(null);
var map__45547 = shadow.test.env.get_test_ns_info.call(null,ns);
var map__45547__$1 = (((((!((map__45547 == null))))?(((((map__45547.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45547.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45547):map__45547);
var test_ns = map__45547__$1;
var fixtures = cljs.core.get.call(null,map__45547__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var vars = cljs.core.get.call(null,map__45547__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
if((env == null)){
cljs.test.set_env_BANG_.call(null,cljs.test.empty_env.call(null));
} else {
}

var temp__5735__auto___45590 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures);
if(cljs.core.truth_(temp__5735__auto___45590)){
var fix_45591 = temp__5735__auto___45590;
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,ns,fix_45591);
} else {
}

var temp__5735__auto__ = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures);
if(cljs.core.truth_(temp__5735__auto__)){
var fix = temp__5735__auto__;
return cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,ns,fix);
} else {
return null;
}
})], null),cljs.test.test_vars_block.call(null,vars));
});
/**
 * Calls test-vars on every var with :test metadata interned in the
 *   namespace, with fixtures.
 */
shadow.test.test_all_vars = (function shadow$test$test_all_vars(ns){
return cljs.test.run_block.call(null,cljs.core.conj.call(null,shadow.test.test_all_vars_block.call(null,ns),(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-test-all-vars","end-test-all-vars",548827253),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
})));
});
/**
 * Like test-ns, but returns a block for further composition and
 *   later execution.  Does not clear the current env.
 */
shadow.test.test_ns_block = (function shadow$test$test_ns_block(env,ns){
if((ns instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? ns)"));
}

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
cljs.test.set_env_BANG_.call(null,env);

cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-test-ns","begin-test-ns",-1701237033),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));

return cljs.test.block.call(null,shadow.test.test_all_vars_block.call(null,ns));
}),(function (){
return cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-test-ns","end-test-ns",1620675645),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
})], null);
});
/**
 * If the namespace defines a function named test-ns-hook, calls that.
 *   Otherwise, calls test-all-vars on the namespace.  'ns' is a
 *   namespace object or a symbol.
 * 
 *   Internally binds *report-counters* to a ref initialized to
 *   *initial-report-counters*.  
 */
shadow.test.test_ns = (function shadow$test$test_ns(var_args){
var G__45568 = arguments.length;
switch (G__45568) {
case 1:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1 = (function (ns){
return shadow.test.test_ns.call(null,cljs.test.empty_env.call(null),ns);
}));

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2 = (function (env,ns){
return cljs.test.run_block.call(null,cljs.core.concat.call(null,shadow.test.test_ns_block.call(null,env,ns),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.test.clear_env_BANG_.call(null);
})], null)));
}));

(shadow.test.test_ns.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=shadow.test.js.map
